#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/sysctl.h>
#include <err.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

#define BUFSIZE 1024;


static int
name2oid(char *name, int *oidp)
{
	int oid[2];
	int i;
	size_t j;

	oid[0] = 0;
	oid[1] = 3;

	j = CTL_MAXNAME * sizeof(int);
	i = sysctl(oid, 2, oidp, &j, name, strlen(name));
	if (i < 0) 
		return i;
	j /= sizeof(int);
	return (j);
}
static int
oidfmt(int *oid, int len, char *fmt, u_int *kind)
{
	int qoid[CTL_MAXNAME+2];
	u_char buf[BUFSIZ];
	int i;
	size_t j;

	qoid[0] = 0;
	qoid[1] = 4;
	memcpy(qoid + 2, oid, len * sizeof(int));

	j = sizeof(buf);
	i = sysctl(qoid, len + 2, buf, &j, 0, 0);
	if (i)
		err(1, "sysctl fmt %d %d %d", i, j, errno);

	if (kind)
		*kind = *(u_int *)buf;

	if (fmt)
		strcpy(fmt, (char *)(buf + sizeof(u_int)));
	return 0;
}



static int
get_var(int *oid, int nlen)
{
		int retval;
	u_char buf[BUFSIZ], *val, *p;
	char name[BUFSIZ], *fmt, *sep;
	int qoid[CTL_MAXNAME+2];
	int i;
	size_t j, len;
	u_int kind;
	int (*func)(int, void *);

	qoid[0] = 0;
	memcpy(qoid + 2, oid, nlen * sizeof(int));

	qoid[1] = 1;
	j = sizeof(name);
	i = sysctl(qoid, nlen + 2, name, &j, 0, 0);
	if (i || !j)
		err(1, "sysctl name %d %d %d", i, j, errno);

	sep = "=";


	/* find an estimate of how much we need for this var */
	j = 0;
	i = sysctl(oid, nlen, 0, &j, 0, 0);
	j += j; /* we want to be sure :-) */

	val = alloca(j + 1);
	len = j;
	i = sysctl(oid, nlen, val, &len, 0, 0);
	if (i || !len)
		return (1);

	val[len] = '\0';
	fmt = buf;
	oidfmt(oid, nlen, fmt, &kind);
	p = val;
	switch (*fmt) {		
	case 'I':
#ifdef DEBUG
		printf("I:%s%s", name, sep);
#endif
		fmt++;
		val = "";
		while (len >= sizeof(int)) {
			if(*fmt == 'U'){
				retval=*((unsigned int *)p);
#ifdef DEBUG
				printf("x%s%u", val, *(unsigned int *)p);
#endif
			}
			else {
				retval=*((int *)p);
#ifdef DEBUG
				printf("x%s%d", val, *(int *)p);
#endif
			}
			val = " ";
			len -= sizeof(int);
			p += sizeof(int);
		}
		
		return (retval);
	default:
			printf("%s%s", name, sep);
		printf("Format:%s Length:%d Dump:0x", fmt, len);
		while (len-- && (p < val + 16))
			printf("%02x", *p++);
		if (len > 16)
			printf("...");
		return (0);
	}
	return (0);
}


int main(void){
     char buf[BUFSIZ], fmt[BUFSIZ];
     void *oldp=(void *)buf;
     size_t oldlenp=BUFSIZ;
     int len,mib[CTL_MAXNAME];
	u_int kind;

     char *bufp;
     /* shucks! I could find no fan state in freeBSD acpi variables */
     char **string,*strings[]={
	     "hw.acpi.thermal.tz0.temperature",
	     "hw.acpi.battery.life",
	     "hw.acpi.battery.time",
	     "hw.acpi.acline",
	     NULL
     };

     for (string=strings;*string!=NULL;string++){
	int retval;     
	bufp = buf;
	snprintf(buf, BUFSIZ, "%s", *string);
	len = name2oid(bufp, mib);
	if (oidfmt(mib, len, fmt, &kind))
		err(1, "couldn't find format of oid '%s'", bufp);

	if (len < 0) errx(1, "unknown oid '%s'", bufp);
 		if ((kind & CTLTYPE) == CTLTYPE_NODE) {
			printf("oh-oh...\n");
		} else {
			retval=get_var(mib, len);
				putchar('\n');
			printf("retval=%d\n",retval);
		}
    
     }
	
}

