/* hypertextview.c generated by valac, the Vala compiler
 * generated from hypertextview.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gio/gio.h>


#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;
typedef struct _XnpHypertextViewPrivate XnpHypertextViewPrivate;
#define _gdk_cursor_unref0(var) ((var == NULL) ? NULL : (var = (gdk_cursor_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _XnpHypertextView {
	GtkTextView parent_instance;
	XnpHypertextViewPrivate * priv;
};

struct _XnpHypertextViewClass {
	GtkTextViewClass parent_class;
};

struct _XnpHypertextViewPrivate {
	GdkCursor* hand_cursor;
	GdkCursor* regular_cursor;
	gboolean cursor_over_link;
	guint undo_timeout;
	gint undo_cursor_pos;
	char* undo_text;
	char* redo_text;
	guint tag_timeout;
	GtkTextTag* tag_link;
	char* _font;
};


static gpointer xnp_hypertext_view_parent_class = NULL;

GType xnp_hypertext_view_get_type (void);
#define XNP_HYPERTEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewPrivate))
enum  {
	XNP_HYPERTEXT_VIEW_DUMMY_PROPERTY,
	XNP_HYPERTEXT_VIEW_FONT
};
static gboolean xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GdkEventButton* event);
static gboolean _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (XnpHypertextView* _sender, GdkEventButton* event, gpointer self);
static gboolean xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GdkEventMotion* event);
static gboolean _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (XnpHypertextView* _sender, GdkEventMotion* event, gpointer self);
static void xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GtkMovementStep step, gint count, gboolean extend_selection);
static void _xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor (XnpHypertextView* _sender, GtkMovementStep step, gint count, gboolean extend_selection, gpointer self);
static void xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void xnp_hypertext_view_insert_text_cb (XnpHypertextView* self, GtkTextBuffer* buffer, GtkTextIter* location, const char* text, gint len);
static void _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self);
static void xnp_hypertext_view_delete_range_cb (XnpHypertextView* self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end);
static void _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
XnpHypertextView* xnp_hypertext_view_new (void);
XnpHypertextView* xnp_hypertext_view_construct (GType object_type);
static gboolean xnp_hypertext_view_undo_snapshot (XnpHypertextView* self);
void xnp_hypertext_view_update_tags (XnpHypertextView* self);
static gboolean _xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self);
static gboolean xnp_hypertext_view_tag_timeout_cb (XnpHypertextView* self);
static gboolean _xnp_hypertext_view_tag_timeout_cb_gsource_func (gpointer self);
static void xnp_hypertext_view_tag_timeout_init (XnpHypertextView* self);
void xnp_hypertext_view_undo (XnpHypertextView* self);
const char* xnp_hypertext_view_get_font (XnpHypertextView* self);
void xnp_hypertext_view_set_font (XnpHypertextView* self, const char* value);
static GObject * xnp_hypertext_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void xnp_hypertext_view_finalize (GObject* obj);
static void xnp_hypertext_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void xnp_hypertext_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (XnpHypertextView* _sender, GdkEventButton* event, gpointer self) {
	return xnp_hypertext_view_button_release_event_cb (self, _sender, event);
}


static gboolean _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (XnpHypertextView* _sender, GdkEventMotion* event, gpointer self) {
	return xnp_hypertext_view_motion_notify_event_cb (self, _sender, event);
}


static void _xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor (XnpHypertextView* _sender, GtkMovementStep step, gint count, gboolean extend_selection, gpointer self) {
	xnp_hypertext_view_move_cursor_cb (self, _sender, step, count, extend_selection);
}


static void _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	xnp_hypertext_view_buffer_changed_cb (self);
}


static void _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self) {
	xnp_hypertext_view_insert_text_cb (self, _sender, pos, text, length);
}


static void _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	xnp_hypertext_view_delete_range_cb (self, _sender, start, end);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


XnpHypertextView* xnp_hypertext_view_construct (GType object_type) {
	XnpHypertextView * self;
	GtkTextIter iter = {0};
	GtkTextTag* _tmp0_;
	self = g_object_newv (object_type, 0, NULL);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "move-cursor", (GCallback) _xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor, self, 0);
	g_signal_connect_object (gtk_text_view_get_buffer ((GtkTextView*) self), "changed", (GCallback) _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object (gtk_text_view_get_buffer ((GtkTextView*) self), "insert-text", (GCallback) _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text, self, 0);
	g_signal_connect_object (gtk_text_view_get_buffer ((GtkTextView*) self), "delete-range", (GCallback) _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range, self, 0);
	gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &iter, 0);
	gtk_text_buffer_create_mark (gtk_text_view_get_buffer ((GtkTextView*) self), "undo-pos", &iter, FALSE);
	self->priv->tag_link = (_tmp0_ = _g_object_ref0 (gtk_text_buffer_create_tag (gtk_text_view_get_buffer ((GtkTextView*) self), "link", "foreground", "blue", "underline", PANGO_UNDERLINE_SINGLE, NULL, NULL)), _g_object_unref0 (self->priv->tag_link), _tmp0_);
	return self;
}


XnpHypertextView* xnp_hypertext_view_new (void) {
	return xnp_hypertext_view_construct (XNP_TYPE_HYPERTEXT_VIEW);
}


static gboolean xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GdkEventButton* event) {
	gboolean result;
	GError * _inner_error_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter iter = {0};
	char* link;
	gint x = 0;
	gint y = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	_inner_error_ = NULL;
	link = NULL;
	if ((*event).button != 1) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	gtk_text_buffer_get_selection_bounds (gtk_text_view_get_buffer ((GtkTextView*) self), &start, &end);
	if (gtk_text_iter_get_offset (&start) != gtk_text_iter_get_offset (&end)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) (*event).x, (gint) (*event).y, &x, &y);
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &iter, x, y);
	if (gtk_text_iter_has_tag (&iter, self->priv->tag_link)) {
		char* _tmp0_;
		start = end = iter;
		if (!gtk_text_iter_begins_tag (&start, self->priv->tag_link)) {
			gtk_text_iter_backward_to_tag_toggle (&start, self->priv->tag_link);
		}
		gtk_text_iter_forward_to_tag_toggle (&end, self->priv->tag_link);
		link = (_tmp0_ = g_strdup (gtk_text_iter_get_text (&start, &end)), _g_free0 (link), _tmp0_);
		{
			g_app_info_launch_default_for_uri (link, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
				goto __finally0;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("hypertextview.vala:121: Unable to open link with default handler: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			char* _tmp1_;
			gdk_spawn_command_line_on_screen (gdk_screen_get_default (), _tmp1_ = g_strconcat ("xdg-open ", link, NULL), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
				goto __finally1;
			}
			_g_free0 (_tmp1_);
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			char* _tmp2_;
			gdk_spawn_command_line_on_screen (gdk_screen_get_default (), _tmp2_ = g_strconcat ("firefox ", link, NULL), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
				goto __finally2;
			}
			_g_free0 (_tmp2_);
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		g_critical ("hypertextview.vala:136: Unable to find an appropriate fallback to open the link");
	}
	result = FALSE;
	_g_free0 (link);
	return result;
}


static gboolean xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GdkEventMotion* event) {
	gboolean result;
	GtkTextIter iter = {0};
	GdkWindow* win;
	gboolean over_link = FALSE;
	gint x = 0;
	gint y = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	win = NULL;
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) (*event).x, (gint) (*event).y, &x, &y);
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &iter, x, y);
	over_link = gtk_text_iter_has_tag (&iter, self->priv->tag_link);
	if (over_link != self->priv->cursor_over_link) {
		GdkWindow* _tmp0_;
		GdkCursor* _tmp1_;
		self->priv->cursor_over_link = over_link;
		win = (_tmp0_ = _g_object_ref0 (gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT)), _g_object_unref0 (win), _tmp0_);
		_tmp1_ = NULL;
		if (over_link) {
			_tmp1_ = self->priv->hand_cursor;
		} else {
			_tmp1_ = self->priv->regular_cursor;
		}
		gdk_window_set_cursor (win, _tmp1_);
	}
	result = FALSE;
	_g_object_unref0 (win);
	return result;
}


static void xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self, XnpHypertextView* hypertextview, GtkMovementStep step, gint count, gboolean extend_selection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hypertextview != NULL);
	if (self->priv->undo_timeout > 0) {
		gint _tmp0_;
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
		xnp_hypertext_view_undo_snapshot (self);
		self->priv->undo_cursor_pos = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self), "cursor-position", &_tmp0_, NULL), _tmp0_);
	}
	if (self->priv->tag_timeout > 0) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
		xnp_hypertext_view_update_tags (self);
	}
}


static gboolean _xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self) {
	return xnp_hypertext_view_undo_snapshot (self);
}


static gboolean _xnp_hypertext_view_tag_timeout_cb_gsource_func (gpointer self) {
	return xnp_hypertext_view_tag_timeout_cb (self);
}


static void xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->undo_timeout > 0) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	self->priv->undo_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_undo_snapshot_gsource_func, g_object_ref (self), g_object_unref);
	if (self->priv->tag_timeout > 0) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
		self->priv->tag_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_tag_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void xnp_hypertext_view_insert_text_cb (XnpHypertextView* self, GtkTextBuffer* buffer, GtkTextIter* location, const char* text, gint len) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (text != NULL);
	if (gtk_text_iter_has_tag (location, self->priv->tag_link)) {
		_tmp0_ = !gtk_text_iter_begins_tag (location, self->priv->tag_link);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		start = *location;
		gtk_text_iter_backward_to_tag_toggle (&start, self->priv->tag_link);
		if ((gtk_text_iter_get_offset (location) - gtk_text_iter_get_offset (&start)) < 7) {
			gboolean _tmp1_ = FALSE;
			end = start;
			gtk_text_iter_forward_to_tag_toggle (&end, self->priv->tag_link);
			gtk_text_buffer_remove_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, &start, &end);
			if (len > 1) {
				gboolean _tmp2_ = FALSE;
				if (string_contains (text, " ")) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = string_contains (text, "\n");
				}
				_tmp1_ = _tmp2_;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				xnp_hypertext_view_tag_timeout_init (self);
			}
		} else {
			gboolean _tmp3_ = FALSE;
			if (string_contains (text, " ")) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = string_contains (text, "\n");
			}
			if (_tmp3_) {
				end = *location;
				gtk_text_iter_forward_to_tag_toggle (&end, self->priv->tag_link);
				gtk_text_buffer_remove_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, &start, &end);
				xnp_hypertext_view_tag_timeout_init (self);
			}
		}
	} else {
		if (gtk_text_iter_ends_tag (location, self->priv->tag_link)) {
			gboolean _tmp4_ = FALSE;
			if (len >= 1) {
				gboolean _tmp5_ = FALSE;
				if (g_utf8_get_char (g_utf8_offset_to_pointer (text, 0)) == ' ') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = g_utf8_get_char (g_utf8_offset_to_pointer (text, 0)) == '\n';
				}
				_tmp4_ = !_tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				start = *location;
				gtk_text_iter_backward_to_tag_toggle (&start, self->priv->tag_link);
				gtk_text_buffer_remove_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, &start, location);
				xnp_hypertext_view_tag_timeout_init (self);
			}
		} else {
			gboolean _tmp6_ = FALSE;
			if (len == 1) {
				_tmp6_ = g_utf8_get_char (g_utf8_offset_to_pointer (text, 0)) == '/';
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gboolean _tmp7_ = FALSE;
				start = *location;
				if (!gtk_text_iter_backward_chars (&start, 6)) {
					_tmp7_ = TRUE;
				} else {
					char* _tmp8_;
					_tmp7_ = _vala_strcmp0 (_tmp8_ = g_utf8_strdown (gtk_text_iter_get_text (&start, location), -1), "http:/") != 0;
					_g_free0 (_tmp8_);
				}
				if (_tmp7_) {
					return;
				}
				xnp_hypertext_view_tag_timeout_init (self);
			} else {
				gboolean _tmp9_ = FALSE;
				if (len == 1) {
					gboolean _tmp10_ = FALSE;
					if (g_utf8_get_char (g_utf8_offset_to_pointer (text, 0)) == ' ') {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = g_utf8_get_char (g_utf8_offset_to_pointer (text, 0)) == '\n';
					}
					_tmp9_ = _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					xnp_hypertext_view_update_tags (self);
				} else {
					gboolean _tmp11_ = FALSE;
					if (len > 1) {
						_tmp11_ = string_contains (text, "http://");
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						xnp_hypertext_view_tag_timeout_init (self);
					}
				}
			}
		}
	}
}


static void xnp_hypertext_view_delete_range_cb (XnpHypertextView* self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter iter = {0};
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	if (!gtk_text_iter_has_tag (start, self->priv->tag_link)) {
		_tmp0_ = !gtk_text_iter_has_tag (end, self->priv->tag_link);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (gtk_text_iter_has_tag (start, self->priv->tag_link)) {
		iter = *start;
		gtk_text_iter_backward_to_tag_toggle (&iter, self->priv->tag_link);
		gtk_text_buffer_remove_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, &iter, start);
	}
	if (gtk_text_iter_has_tag (end, self->priv->tag_link)) {
		iter = *end;
		gtk_text_iter_forward_to_tag_toggle (&iter, self->priv->tag_link);
		gtk_text_buffer_remove_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, end, &iter);
	}
	xnp_hypertext_view_tag_timeout_init (self);
}


static gboolean xnp_hypertext_view_undo_snapshot (XnpHypertextView* self) {
	gboolean result;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->undo_cursor_pos = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self), "cursor-position", &_tmp0_, NULL), _tmp0_);
	gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &start, 0);
	gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &end, -1);
	self->priv->undo_text = (_tmp1_ = g_strdup (self->priv->redo_text), _g_free0 (self->priv->undo_text), _tmp1_);
	self->priv->redo_text = (_tmp2_ = g_strdup (gtk_text_buffer_get_text (gtk_text_view_get_buffer ((GtkTextView*) self), &start, &end, FALSE)), _g_free0 (self->priv->redo_text), _tmp2_);
	result = FALSE;
	return result;
}


void xnp_hypertext_view_undo (XnpHypertextView* self) {
	GtkTextIter iter = {0};
	GtkTextMark* mark;
	char* tmp;
	GtkTextMark* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	mark = NULL;
	tmp = NULL;
	if (self->priv->undo_timeout > 0) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
		xnp_hypertext_view_undo_snapshot (self);
	}
	gtk_text_buffer_set_text (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->undo_text, -1);
	gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &iter, self->priv->undo_cursor_pos);
	gtk_text_buffer_place_cursor (gtk_text_view_get_buffer ((GtkTextView*) self), &iter);
	mark = (_tmp0_ = _g_object_ref0 (gtk_text_buffer_get_mark (gtk_text_view_get_buffer ((GtkTextView*) self), "undo-pos")), _g_object_unref0 (mark), _tmp0_);
	gtk_text_buffer_move_mark (gtk_text_view_get_buffer ((GtkTextView*) self), mark, &iter);
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, mark, 0.0, FALSE, 0.5, 0.5);
	tmp = (_tmp1_ = g_strdup (self->priv->undo_text), _g_free0 (tmp), _tmp1_);
	self->priv->undo_text = (_tmp2_ = g_strdup (self->priv->redo_text), _g_free0 (self->priv->undo_text), _tmp2_);
	self->priv->redo_text = (_tmp3_ = g_strdup (tmp), _g_free0 (self->priv->redo_text), _tmp3_);
	if (self->priv->undo_timeout > 0) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	_g_object_unref0 (mark);
	_g_free0 (tmp);
}


static gboolean xnp_hypertext_view_tag_timeout_cb (XnpHypertextView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	xnp_hypertext_view_update_tags (self);
	result = FALSE;
	return result;
}


static void xnp_hypertext_view_tag_timeout_init (XnpHypertextView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->tag_timeout > 0) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
	}
	self->priv->tag_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_tag_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
}


void xnp_hypertext_view_update_tags (XnpHypertextView* self) {
	GtkTextIter iter = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter tmp = {0};
	g_return_if_fail (self != NULL);
	if (self->priv->tag_timeout > 0) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
	}
	gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &iter, 0);
	while (TRUE) {
		if (!gtk_text_iter_forward_search (&iter, "http://", GTK_TEXT_SEARCH_TEXT_ONLY, &start, &end, NULL)) {
			break;
		}
		iter = end;
		if (gtk_text_iter_begins_tag (&start, self->priv->tag_link)) {
			continue;
		}
		if (!gtk_text_iter_forward_search (&iter, " ", GTK_TEXT_SEARCH_TEXT_ONLY, &end, NULL, NULL)) {
			if (!gtk_text_iter_forward_search (&iter, "\n", GTK_TEXT_SEARCH_TEXT_ONLY, &end, NULL, NULL)) {
				gtk_text_buffer_get_iter_at_offset (gtk_text_view_get_buffer ((GtkTextView*) self), &end, -1);
			}
		} else {
			if (gtk_text_iter_forward_search (&iter, "\n", GTK_TEXT_SEARCH_TEXT_ONLY, &tmp, NULL, NULL)) {
				if (gtk_text_iter_get_offset (&tmp) < gtk_text_iter_get_offset (&end)) {
					end = tmp;
				}
			}
		}
		if ((gtk_text_iter_get_offset (&end) - gtk_text_iter_get_offset (&start)) >= 7) {
			gtk_text_buffer_apply_tag (gtk_text_view_get_buffer ((GtkTextView*) self), self->priv->tag_link, &start, &end);
		}
	}
}


const char* xnp_hypertext_view_get_font (XnpHypertextView* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_font;
	return result;
}


void xnp_hypertext_view_set_font (XnpHypertextView* self, const char* value) {
	char* _tmp0_;
	PangoFontDescription* font_descr;
	g_return_if_fail (self != NULL);
	self->priv->_font = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_font), _tmp0_);
	font_descr = pango_font_description_from_string (value);
	gtk_widget_modify_font ((GtkWidget*) self, font_descr);
	_pango_font_description_free0 (font_descr);
	g_object_notify ((GObject *) self, "font");
}


static GObject * xnp_hypertext_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpHypertextView * self;
	parent_class = G_OBJECT_CLASS (xnp_hypertext_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XNP_HYPERTEXT_VIEW (obj);
	{
		xnp_hypertext_view_set_font (self, "Sans 13");
	}
	return obj;
}


static void xnp_hypertext_view_class_init (XnpHypertextViewClass * klass) {
	xnp_hypertext_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpHypertextViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = xnp_hypertext_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = xnp_hypertext_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_hypertext_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_hypertext_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_HYPERTEXT_VIEW_FONT, g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void xnp_hypertext_view_instance_init (XnpHypertextView * self) {
	self->priv = XNP_HYPERTEXT_VIEW_GET_PRIVATE (self);
	self->priv->hand_cursor = gdk_cursor_new (GDK_HAND2);
	self->priv->regular_cursor = gdk_cursor_new (GDK_XTERM);
	self->priv->cursor_over_link = FALSE;
	self->priv->undo_timeout = (guint) 0;
	self->priv->undo_text = g_strdup ("");
	self->priv->redo_text = g_strdup ("");
	self->priv->tag_timeout = (guint) 0;
}


static void xnp_hypertext_view_finalize (GObject* obj) {
	XnpHypertextView * self;
	self = XNP_HYPERTEXT_VIEW (obj);
	{
		if (self->priv->undo_timeout != 0) {
			g_source_remove (self->priv->undo_timeout);
		}
		if (self->priv->tag_timeout != 0) {
			g_source_remove (self->priv->tag_timeout);
		}
	}
	_gdk_cursor_unref0 (self->priv->hand_cursor);
	_gdk_cursor_unref0 (self->priv->regular_cursor);
	_g_free0 (self->priv->undo_text);
	_g_free0 (self->priv->redo_text);
	_g_object_unref0 (self->priv->tag_link);
	_g_free0 (self->priv->_font);
	G_OBJECT_CLASS (xnp_hypertext_view_parent_class)->finalize (obj);
}


GType xnp_hypertext_view_get_type (void) {
	static GType xnp_hypertext_view_type_id = 0;
	if (xnp_hypertext_view_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpHypertextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_hypertext_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpHypertextView), 0, (GInstanceInitFunc) xnp_hypertext_view_instance_init, NULL };
		xnp_hypertext_view_type_id = g_type_register_static (GTK_TYPE_TEXT_VIEW, "XnpHypertextView", &g_define_type_info, 0);
	}
	return xnp_hypertext_view_type_id;
}


static void xnp_hypertext_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpHypertextView * self;
	self = XNP_HYPERTEXT_VIEW (object);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT:
		g_value_set_string (value, xnp_hypertext_view_get_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void xnp_hypertext_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpHypertextView * self;
	self = XNP_HYPERTEXT_VIEW (object);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT:
		xnp_hypertext_view_set_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




