/* $Id: xfce-menu-app-item.c,v 1.6 2004/11/04 16:02:52 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * Copyright (c) 2004 Brian Tarricone <bjt23@cornell.edu>
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <libxfcegui4/libxfcegui4.h>

#include "xfce-menu-app-item.h"



static void xfce_menu_app_item_class_init (XfceMenuAppItemClass *klass);
static void xfce_menu_app_item_init       (XfceMenuAppItem      *item);
static void xfce_menu_app_item_finalize   (GObject              *object);
static void xfce_menu_app_item_activate   (XfceMenuAppItem      *item);



static GObjectClass *parent_class;



GType
xfce_menu_app_item_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo type_info = {
        sizeof (XfceMenuAppItemClass),
        NULL,
        NULL,
        (GClassInitFunc) xfce_menu_app_item_class_init,
        NULL,
        NULL,
        sizeof (XfceMenuAppItem),
        0,
        (GInstanceInitFunc) xfce_menu_app_item_init,
        NULL,
      };

      type = g_type_register_static (XFCE_TYPE_MENU_ITEM,
                                     "XfceMenuAppItem",
                                     &type_info,
                                     0);
    }

  return type;
}



GtkWidget*
xfce_menu_app_item_new (const gchar *text,
                        const gchar *icon,
                        const gchar *command,
                        const gchar *tooltip,
                        gboolean     use_sn,
                        gboolean     use_term)
{
  XfceMenuAppItem *item;

  item            = g_object_new (XFCE_TYPE_MENU_APP_ITEM, NULL);
  item->command   = g_strdup (command);
  item->use_sn    = use_sn;
  item->use_term  = use_term;

  xfce_menu_item_set_text (XFCE_MENU_ITEM (item), text);
  xfce_menu_item_set_icon (XFCE_MENU_ITEM (item), icon);
  xfce_menu_item_set_tip  (XFCE_MENU_ITEM (item), tooltip);

  return (GtkWidget *) item;
}



void
xfce_menu_app_item_set_command (XfceMenuAppItem *item,
                                const gchar     *command)
{
  if (item->command != NULL)
    g_free (item->command);
  item->command = g_strdup (command);
}



void
xfce_menu_app_item_set_use_sn (XfceMenuAppItem *item,
                               gboolean         use_sn)
{
  item->use_sn = use_sn;
}



void
xfce_menu_app_item_set_use_term (XfceMenuAppItem *item,
                                 gboolean         use_term)
{
  item->use_term = use_term;
}



static void
xfce_menu_app_item_class_init (XfceMenuAppItemClass *klass)
{
  GObjectClass *gobject_class;

  parent_class = g_type_class_peek_parent (klass);

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfce_menu_app_item_finalize;
}



static void
xfce_menu_app_item_init (XfceMenuAppItem *item)
{
  g_signal_connect (G_OBJECT (item), "activate",
                    G_CALLBACK (xfce_menu_app_item_activate), item);
}



static void
xfce_menu_app_item_finalize (GObject *object)
{
  XfceMenuAppItem *item;

  item = XFCE_MENU_APP_ITEM (object);
  g_free (item->command);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}



static void
xfce_menu_app_item_activate (XfceMenuAppItem *item)
{
  GdkScreen *screen;
  gchar     *old_dpy;
  gchar     *new_dpy;
  gchar     *dpy;
  gchar     *p;
  gchar     *q;

  if (G_LIKELY (item->command != NULL))
    {
      screen = gtk_widget_get_screen (GTK_WIDGET (item));

      old_dpy = g_strdup (g_getenv ("DISPLAY"));

      dpy = g_strdup (gdk_display_get_name (gtk_widget_get_display (GTK_WIDGET (item))));
      p = g_strrstr (dpy, ":");
      q = g_strrstr (dpy, ".");
      if (p != NULL && q != NULL && p < q)
        *q = '\0';

      if (p != NULL)
        {
          new_dpy = g_strdup_printf ("%s.%d", dpy, GDK_SCREEN_XNUMBER (screen));
          xfce_setenv ("DISPLAY", new_dpy, TRUE);
          g_free (new_dpy);
        }

      g_free (dpy);

      if (!xfce_exec (item->command, item->use_term, item->use_sn, NULL))
        {
          g_warning ("Unable to start \"%s\"", item->command);
        }

      xfce_setenv ("DISPLAY", old_dpy, TRUE);
      g_free (old_dpy);
    }
}





