/* $Id: xfce-menu-app-item.h,v 1.3 2004/08/04 22:26:40 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * Copyright (c) 2004 Brian Tarricone <bjt23@cornell.edu>
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XFCE_MENU_APP_ITEM_H__
#define __XFCE_MENU_APP_ITEM_H__

#include "xfce-menu-item.h"

G_BEGIN_DECLS;

#define XFCE_TYPE_MENU_APP_ITEM             (xfce_menu_app_item_get_type ())
#define XFCE_MENU_APP_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_MENU_APP_ITEM, XfceMenuAppItem))
#define XFCE_MENU_APP_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((obj), XFCE_TYPE_MENU_APP_ITEM, XfceMenuAppItemClass))
#define XFCE_IS_MENU_APP_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_MENU_APP_ITEM))
#define XFCE_IS_MENU_APP_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), XFCE_TYPE_MENU_APP_ITEM))
#define XFCE_MENU_APP_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), XFCE_TYPE_MENU_APP_ITEM, XfceMenuAppItemClass))


typedef struct _XfceMenuAppItemClass XfceMenuAppItemClass;
typedef struct _XfceMenuAppItem      XfceMenuAppItem;

struct _XfceMenuAppItemClass
{
  XfceMenuItemClass __parent__;
};

struct _XfceMenuAppItem
{
  XfceMenuItem      __parent__;
  gchar            *command;
  gboolean          use_sn;
  gboolean          use_term;
};


GType      xfce_menu_app_item_get_type (void) G_GNUC_CONST;

GtkWidget *xfce_menu_app_item_new      (const gchar *text,
                                        const gchar *icon,
                                        const gchar *command,
                                        const gchar *tooltip,
                                        gboolean     use_sn,
                                        gboolean     use_term);

void       xfce_menu_app_item_set_command (XfceMenuAppItem *item,
                                           const gchar     *command);

void       xfce_menu_app_item_set_use_sn  (XfceMenuAppItem *item,
                                           gboolean         use_sn);

void       xfce_menu_app_item_set_use_term  (XfceMenuAppItem *item,
                                             gboolean         use_term);

G_END_DECLS;

#endif /* !__XFCE_MENU_APP_ITEM_H__ */
