/* $Id: xfce-menu.h,v 1.2 2004/08/04 22:26:40 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XFCE_MENU_H__
#define __XFCE_MENU_H__

#include <gtk/gtk.h>

#include "xdg-menu.h"

G_BEGIN_DECLS;

#define XFCE_TYPE_MENU            (xfce_menu_get_type ())
#define XFCE_MENU(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFCE_TYPE_MENU, XfceMenu))
#define XFCE_MENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), XFCE_TYPE_MENU, XfceMenuClass))
#define XFCE_IS_MENU(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFCE_TYPE_MENU))
#define XFCE_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), XFCE_TYPE_MENU))
#define XFCE_MENU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), XFCE_TYPE_MENU, XfceMenuClass))


typedef struct _XfceMenuClass XfceMenuClass;
typedef struct _XfceMenu      XfceMenu;

struct _XfceMenuClass
{
  GtkMenuClass __parent__;
};

struct _XfceMenu
{
  GtkMenu      __parent__;

  GtkWidget   *hook;

  gchar       *icon;
  gchar       *name;

  XdgPattern  *include;
  XdgPattern  *exclude;
  gboolean     only_unallocated;

  GList       *appdirs;
  GList       *appdirs_legacy;
};


GType      xfce_menu_get_type        (void) G_GNUC_CONST;

GtkWidget *xfce_menu_new             (const gchar     *name,
                                      const gchar     *icon);

GtkWidget *xfce_menu_new_from_parsed (const XdgMenu   *parsed_menu,
                                      XdgDesktopCache *cache);

void       xfce_menu_append_submenu  (XfceMenu        *menu,
                                      GtkWidget       *submenu);

G_END_DECLS;

#endif /* !__XFCE_MENU_H__ */
