#ifndef XFILEEXPLORER_H
#define XFILEEXPLORER_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "FileDict.h"
#include "FilePanel.h"
#include "InputDialog.h"
#include "Properties.h"
#include "DirPanel.h"

// Helper function
void toolbarSeparator(FXHorizontalFrame*);

// Application object
class XFileExplorer : public FXMainWindow
{
    FXDECLARE(XFileExplorer)
    friend class FilePanel;
    friend class DirPanel;
public:
    long onQuit(FXObject*,FXSelector,void*);
	long onCmdHelp(FXObject*,FXSelector,void*);
    long onCmdAbout(FXObject*,FXSelector,void*);
    long onCmdAutoSave(FXObject*,FXSelector,void*);
    long onCmdToggleStatus(FXObject*,FXSelector,void*);
    long onUpdToggleStatus(FXObject*,FXSelector,void*);
    long onCmdFileAssoc(FXObject*,FXSelector,void*);
    long onCmdMenu(FXObject*,FXSelector,void*);
    long onCmdPrefs(FXObject*,FXSelector,void*);
    long onCmdReloadPrefs(FXObject*,FXSelector,void*);
    long onCmdRun(FXObject*,FXSelector,void*);
    long onCmdXTerm(FXObject*,FXSelector,void*);
    long onCmdSelect(FXObject*,FXSelector,void*);
    long onCmdFileMan(FXObject*,FXSelector,void*);
    long onCmdShow(FXObject*,FXSelector,void*);
    long onUpdShow(FXObject*,FXSelector,void*);
    long onCmdToggleHidden(FXObject*,FXSelector,void*);
    long onUpdToggleHidden(FXObject*,FXSelector,void*);
	long onCmdShowPanels(FXObject*,FXSelector,void*);
	long onUpdShowPanels(FXObject*,FXSelector,void*);
    long onCmdRestart(FXObject*,FXSelector,void*);
    long onCmdBookmark(FXObject*,FXSelector,void*);
    long onCmdExtract(FXObject*,FXSelector,void*);
	long onCmdGotoLocation(FXObject*,FXSelector,void*);
	long onCmdClearLocation(FXObject*,FXSelector,void*);
	long onUpdFileLocation(FXObject*,FXSelector,void*);
	long onCmdCfm(FXObject*,FXSelector,void*);
	long onTabPress(FXObject* sender,FXSelector sel,void* ptr);
#if defined(linux)
    long onCmdRpmInstall(FXObject*,FXSelector,void*);
    long onCmdRpmUninstall(FXObject*,FXSelector,void*);
#endif
protected:
	int rpanel_width;
	int rpanel_tree_width;
	enum
	{
		ONE_PANEL,
		TWO_PANELS,
		TREE_PANEL,
		TREE_TWO_PANELS
	};	
	int panel_view;
    int RunHistSize;
#define RUN_HIST_SIZE 15
    char RunHistory[RUN_HIST_SIZE][100];

    FXIcon *archicon;
    FXIcon *attricon;
	FXIcon *newfoldericon;
	FXIcon *minidocicon;
	FXIcon *delicon;	
	FXIcon *copyicon;	
	FXIcon *cuticon;	
	FXIcon *pasteicon;
	FXIcon *symlinkicon;
	FXIcon *renameicon;
	FXIcon *moveicon;
	FXIcon *mapicon;	
	FXIcon *unmapicon;	
	FXIcon *minixtermicon;
	FXIcon *minicfmicon;
	FXIcon *minirpmicon;
	FXIcon *locationicon;
	FXIcon *entericon;
	FXIcon *filtericon;
	FXIcon *viewicon;
	FXIcon *editicon;
	
    FXMenubar			*menubar;
    FXHorizontalFrame	*toolbar;
    FXHorizontalFrame	*locationbar;
	FXComboBox			*address;
    FXStatusbar			*status;
    DirPanel			*dirpanel;
    FilePanel			*lpanel;
    FilePanel			*rpanel;
    FXbool             	auto_save_layout;
    FXString           	target;
    FXString           	sources;
    char               	*opendir;
    FXMenuPane         	*leftviewmenu;
    FXMenuPane         	*rightviewmenu;
    FXMenuTitle        	*rmenutitle;
    FXMenuTitle        	*lmenutitle;
    FXRecentFiles      	*bookmarks;
public:
    enum{
        ID_ABOUT=FXMainWindow::ID_LAST,
		ID_HELP,
        ID_XTERM,
        ID_CFM,
        ID_SELECT_ALL,
        ID_DESELECT_ALL,
        ID_SELECT_INVERSE,
        ID_FILE_COPY,
        ID_FILE_RENAME,
        ID_FILE_MOVE,
        ID_FILE_CUT,
        ID_FILE_SLINK,
        ID_FILE_DEL,
		ID_CLEAR_LOCATION,
		ID_GOTO_LOCATION,
        ID_RUN,
        ID_PREFS,
        ID_RELOAD_PREFS,
        ID_AUTO_SAVE,
        ID_FILE_ASSOC,
        ID_DIR_BOX,
        ID_MENU,
        ID_TOGGLE_STATUS,
        ID_SHOW_BIG_ICONS,
        ID_SHOW_MINI_ICONS,
        ID_SHOW_DETAILS,
        ID_TOGGLE_HIDDEN,
		ID_SHOW_ONE_PANEL,
		ID_SHOW_TWO_PANELS,
		ID_SHOW_TREE_PANEL,
		ID_SHOW_TREE_TWO_PANELS,
        ID_RESTART,
        ID_BOOKMARK,
        ID_ADD_BOOKMARK,
        ID_EXTRACT,
#if defined(linux)
		ID_RPM_INSTALL,
		ID_RPM_UNINSTALL,
#endif
        ID_QUIT,
        ID_LAST
    };
public:
    XFileExplorer(FXApp *app=NULL,char *title = "X File Explorer",FXIcon *bigicon=NULL,FXIcon *miniicon=NULL);
    virtual void create();
    ~XFileExplorer();
    void saveConfig();
    FileDict *getAssociations()
    {
        return lpanel->current->list->getAssociations();
    }
};
#endif
