#ifndef XFILEVIEW_H
#define XFILEVIEW_H

class XFileView : public FXMainWindow
{
    FXDECLARE(XFileView)
protected:
    FXMenubar			*menubar;			// Menu bar
    FXMenuPane			*filemenu;			// File menu
    FXMenuPane			*helpmenu;			// Help menu
    FXHorizontalFrame	*contents;			// Sunken border for text widget
    FXHorizontalFrame	*toolbar;			// Tool bar
    FXText				*viewer;			// Multiline text widget
    FXStatusbar			*statusbar;			// Status bar
    FXString			filename;			// File being edited
    FXTextField			*text;
protected:
    FXbool loadfile(const FXString& file);
protected:
    XFileView()
    {}
public:
    long onCmdAbout(FXObject*,FXSelector,void*);
    long onCmdOpen(FXObject*,FXSelector,void*);
    long onCmdNew(FXObject*,FXSelector,void*);
    long onCmdQuit(FXObject*,FXSelector,void*);
    long onUpdTitle(FXObject*,FXSelector,void*);
    long onCmdFind(FXObject*,FXSelector,void*);
    long onCmdColors(FXObject*,FXSelector,void*);
	long onCmdPrint(FXObject*,FXSelector,void*);
public:
    enum{
        ID_ABOUT=FXMainWindow::ID_LAST,
        ID_OPEN,
        ID_NEW,
        ID_TITLE,
        ID_FIND,
        ID_FIND_AGAIN,
        ID_COLORS,
        ID_QUIT,
		ID_PRINT,
        ID_LAST
    };
public:
    XFileView(FXApp* a);
    virtual void create();
	void saveConfig();
    void start(int& argc,char** argv);
    FXint find(const FXString,FXint);
};
#endif

