#ifndef DIRBOX_H
#define DIRBOX_H


/// Directory Box
class FXAPI DirBox : public FXTreeListBox
{
    FXDECLARE(DirBox)
protected:
    FXString    directory;              // Current directory
    FXIcon     *foldericon;             // Folder icons
protected:
    DirBox()
    {}
    FXString itempath(FXTreeItem *item);
private:
    DirBox(const DirBox&);
    DirBox &operator=(const DirBox&);
public:
    long onChanged(FXObject*,FXSelector,void*);
    long onCommand(FXObject*,FXSelector,void*);
    long onCmdSetValue(FXObject*,FXSelector,void*);
    long onCmdSetStringValue(FXObject*,FXSelector,void*);
    long onCmdGetStringValue(FXObject*,FXSelector,void*);
public:

    /// Constructor
    DirBox(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

    /// Create server-side resources
    virtual void create();

    /// Detach server-side resources
    virtual void detach();

    /// Destroy server-side resources
    virtual void destroy();

    /// Save to stream
    virtual void save(FXStream& store) const;

    /// Load from stream
    virtual void load(FXStream& store);

    /// Set current directory
    void setDirectory(const FXString& pathname);

    /// Return current directory
    FXString getDirectory() const
    {
        return directory;
    }

    /// Destructor
    virtual ~DirBox();
};

#endif
