#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <fox-1.4/fx.h>
#include <fox-1.4/fxkeys.h>
#include <fox-1.4/FXPNGIcon.h>

#include "xfedefs.h"
#include "FileList.h"
#include "FileDict.h"
#include "Preferences.h"
#include "FilePanel.h"
#include "XFileExplorer.h"
#include "InputDialog.h"
#include "HistInputDialog.h"
#include "OverwriteBox.h"
#include "DirPanel.h"
#include "icons.h"
#include "File.h"
#include "MessageBox.h"
#include "TextWindow.h"
#include "CommandWindow.h"
#include "Bookmarks.h"
#include "help.h"

// Size of the location bar
#define LOCATION_BAR_LENGTH 70
#define LOCATION_BAR_HEIGHT 6

// Minimum width of a file or directory panel
#define MIN_PANEL_WIDTH 100


// Global variables
FXString editor;
FXString viewer;
FXString clipboard="";
char OpenHistory[OPEN_WITH_HIST_SIZE][100];
int OpenNum;

// External global variables
extern FXMainWindow *mainWindow;
extern char** args;
extern FXString startdir;
extern FXbool confirm_quit;
extern FXbool warn_if_root;
extern FXbool use_trashcan;
extern FXbool confirm_del;
extern FXbool confirm_overwrite;
extern FXbool ask_before_copy;
#if defined(linux)
extern FXbool mount_warn;
extern FXbool mount_messages;
extern FXStringDict* fsdevices;
extern FXStringDict* updevices;
#endif
extern FXbool iconic;
extern FXbool maximized;


// Helper function to draw a toolbar separator
void toolbarSeparator(FXToolBar* tb)
{
#define SEP_SPACE	1
#define SEP_HEIGHT	15
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE);
    new FXVerticalSeparator(tb,LAYOUT_SIDE_TOP|LAYOUT_CENTER_Y|SEPARATOR_GROOVE|LAYOUT_FIX_HEIGHT,0,0,0,SEP_HEIGHT);
    new FXFrame(tb,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,SEP_SPACE);
}

// This function is taken from the FXSplitter class
// and hacked to set a minimum splitter width when moving splitter to right
// It replaces the normal function...
void FXSplitter::moveHSplit(FXint pos)
{
    register FXint smin,smax;
    register FXuint hints;
    hints=window->getLayoutHints();
    if(options&SPLITTER_REVERSED)
    {
        smin=barsize;
        smax=window->getX()+window->getWidth();
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smax-=window->getDefaultWidth();
    }
    else
    {
        smin=window->getX();
        smax=width-barsize;
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smin+=window->getDefaultWidth();
    }
	// !!! Hack to limit the width to a minimum value !!!
	smax=smax-MIN_PANEL_WIDTH;
    split=pos;
    if(split<smin)
        split=smin;
    if(split>smax)
        split=smax;
}


// Map
FXDEFMAP(XFileExplorer) XFileExplorerMap[]={
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onCmdToggleStatus),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RUN,XFileExplorer::onCmdRun),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_COPY,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_RENAME,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_COPYTO,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_MOVE,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_CUT,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_SYMLINK,XFileExplorer::onCmdFileMan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_QUIT,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_HELP,XFileExplorer::onCmdHelp),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ABOUT,XFileExplorer::onCmdAbout),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_FILE_ASSOC,XFileExplorer::onCmdFileAssoc),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_REFRESH,XFileExplorer::onCmdRefresh),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_EMPTY_TRASHCAN,XFileExplorer::onCmdEmptyTrashcan),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_XTERM,XFileExplorer::onCmdXTerm),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_AUTO_SAVE,XFileExplorer::onCmdAutoSave),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_CLEAR_LOCATION,XFileExplorer::onCmdClearLocation),
									 FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onCmdGotoLocation),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_PREFS,XFileExplorer::onCmdPrefs),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RELOAD_PREFS,XFileExplorer::onCmdReloadPrefs),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onCmdShowPanels),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_RESTART,XFileExplorer::onCmdRestart),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_BOOKMARK,XFileExplorer::onCmdBookmark),
                                     FXMAPFUNC(SEL_COMMAND,XFileExplorer::ID_ADD_BOOKMARK,XFileExplorer::onCmdBookmark),
            						 FXMAPFUNC(SEL_KEYPRESS,0,XFileExplorer::onKeyPress),
                                     FXMAPFUNC(SEL_CLOSE,0,XFileExplorer::onQuit),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_TOGGLE_STATUS,XFileExplorer::onUpdToggleStatus),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TWO_PANELS,XFileExplorer::onUpdShowPanels),
                                     FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_SHOW_TREE_PANEL,XFileExplorer::onUpdShowPanels),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_GOTO_LOCATION,XFileExplorer::onUpdFileLocation),
									 FXMAPFUNC(SEL_UPDATE,XFileExplorer::ID_EMPTY_TRASHCAN,XFileExplorer::onUpdEmptyTrashcan),
                                 };


// Object implementation
FXIMPLEMENT(XFileExplorer,FXMainWindow,XFileExplorerMap,ARRAYNUMBER(XFileExplorerMap))


// Make some windows
XFileExplorer::XFileExplorer(FXApp *app,char *title,FXIcon *bigicon,FXIcon *miniicon):
        FXMainWindow(app,title,bigicon,miniicon,DECOR_ALL,2,2,600,480, 2,2)
{
    FXHotKey hotkey;

    bookmarks=new Bookmarks("bookmarks",this,ID_BOOKMARK);

	// Create some icons
	FXIcon *homeicon=new FXPNGIcon(app,home);
	FXIcon *dirupicon=new FXPNGIcon(app,dirup);
    FXIcon *quiticon=new FXPNGIcon(app,mini_stop);
	FXIcon *reloadicon=new FXPNGIcon(app,reload);
	FXIcon *largeicon=new FXPNGIcon(app,bigicons);
	FXIcon *smallicon=new FXPNGIcon(app,smallicons);
	FXIcon *detailicon=new FXPNGIcon(app,details);
	FXIcon *showhiddenicon=new FXPNGIcon(app,showhidden);
	FXIcon *hidehiddenicon=new FXPNGIcon(app,hidehidden);
	FXIcon *showthumbicon=new FXPNGIcon(app,showthumb);
	FXIcon *hidethumbicon=new FXPNGIcon(app,hidethumb);
	FXIcon *twopanelsicon=new FXPNGIcon(app,twopanels);
	FXIcon *xtermicon=new FXPNGIcon(app,shell);
	FXIcon *treepanelicon=new FXPNGIcon(app,treeonepanel);
	FXIcon *setbookicon=new FXPNGIcon(app,setbook);
	FXIcon *clrbookicon=new FXPNGIcon(app,clrbook);
	FXIcon *runicon=new FXPNGIcon(app,run);
	FXIcon *selallicon=new FXPNGIcon(app,selall);
	FXIcon *invselicon=new FXPNGIcon(app,invsel);
	FXIcon *deselicon=new FXPNGIcon(app,desel);
	FXIcon *prefsicon=new FXPNGIcon(app,prefs);
	FXIcon *helpicon=new FXPNGIcon(app,help);
    FXIcon *attricon=new FXPNGIcon(app,attrib);
    FXIcon *newfoldericon=new FXPNGIcon(app,newfolder);
    FXIcon *minidocicon=new FXPNGIcon(app,minidoc);
	FXIcon *delicon=new FXPNGIcon(app,filedelete);	
	FXIcon *trashicon=new FXPNGIcon(app,trash_full);	
	FXIcon *copyicon=new FXPNGIcon(app,copy_clp);	
	FXIcon *cuticon=new FXPNGIcon(app,cut_clp);	
	FXIcon *pasteicon=new FXPNGIcon(app,paste_clp);	
	FXIcon *renameicon=new FXPNGIcon(app,renameit);
	FXIcon *moveicon=new FXPNGIcon(app,moveit);
	FXIcon *symlinkicon=new FXPNGIcon(app,minilink);
#if defined(linux)
	FXIcon *mapicon=new FXPNGIcon(app,maphost);	
	FXIcon *unmapicon=new FXPNGIcon(app,unmaphost);
#endif
	FXIcon *minixtermicon=new FXPNGIcon(app,minishell);
  	FXIcon *locationicon=new FXPNGIcon(app,location);
  	FXIcon *entericon=new FXPNGIcon(app,enter);
	FXIcon *filtericon=new FXPNGIcon(app,filter);
	FXIcon *openicon=new FXPNGIcon(app,fileopen);

	// Site where to dock
	FXDockSite *docksite=new FXDockSite(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

    // Menu bar
  	FXToolBarShell* dragshell1=new FXToolBarShell(this,FRAME_RAISED);
    menubar=new FXMenuBar(docksite,dragshell1,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
	new FXToolBarGrip(menubar,menubar,FXMenuBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

    // Toolbar
  	FXToolBarShell* dragshell2=new FXToolBarShell(this,FRAME_RAISED);
  	toolbar=new FXToolBar(docksite,dragshell2,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
  	new FXToolBarGrip(toolbar,toolbar,FXToolBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

   	// Location bar
  	FXToolBarShell* dragshell3=new FXToolBarShell(this,FRAME_RAISED);
  	locationbar=new FXToolBar(docksite,dragshell3,LAYOUT_DOCK_NEXT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|FRAME_RAISED);
  	new FXToolBarGrip(locationbar,locationbar,FXToolBar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);

    // Main splitter
  	FXHorizontalFrame * splitterbox=new FXHorizontalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
	FXSplitter* mainsplit=new FXSplitter(splitterbox,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);

    // Directory panel on the left (with minimum size)
    dirpanel=new DirPanel(mainsplit,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);

	// Sub splitter
    FXSplitter* subsplit=new FXSplitter(mainsplit,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_TRACKING);

    // File panels on the right (with minimum size) : remembers size of each field
	lpanel=new FilePanel("LEFT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("LEFT PANEL","attr_size",100),
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    rpanel=new FilePanel("RIGHT PANEL",subsplit,
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","name_size",200),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","size_size",60),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","type_size",100),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","modd_size",150),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","user_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","grou_size",50),
                     getApp()->reg().readUnsignedEntry("RIGHT PANEL","attr_size",100),
					 LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH,0,0,MIN_PANEL_WIDTH,0);
    lpanel->Next(rpanel);
    rpanel->Next(lpanel);
    lpanel->focus();

	// Read and set sort function for left panel
	FXString sort_func=getApp()->reg().readStringEntry("LEFT PANEL","sort_func","ascendingCase");
    if (sort_func=="ascendingCase")
		lpanel->list->setSortFunc(lpanel->list->ascendingCase);        
    else if (sort_func=="descendingCase")
		lpanel->list->setSortFunc(lpanel->list->descendingCase);        
    else if (sort_func=="ascending")
		lpanel->list->setSortFunc(lpanel->list->ascending);        
    else if (sort_func=="descending")
		lpanel->list->setSortFunc(lpanel->list->descending);        
	else if (sort_func=="ascendingSize")
		lpanel->list->setSortFunc(lpanel->list->ascendingSize);        
	else if (sort_func=="descendingSize")
		lpanel->list->setSortFunc(lpanel->list->descendingSize);        
	else if (sort_func=="ascendingType")
		lpanel->list->setSortFunc(lpanel->list->ascendingType);        
	else if (sort_func=="descendingType")
		lpanel->list->setSortFunc(lpanel->list->descendingType);        
	else if (sort_func=="ascendingTime")
		lpanel->list->setSortFunc(lpanel->list->ascendingTime);        
	else if (sort_func=="descendingTime")
		lpanel->list->setSortFunc(lpanel->list->descendingTime);        
	else if (sort_func=="ascendingUser")
		lpanel->list->setSortFunc(lpanel->list->ascendingUser);        
	else if (sort_func=="descendingUser")
		lpanel->list->setSortFunc(lpanel->list->descendingUser);         
	else if (sort_func=="ascendingGroup")
		lpanel->list->setSortFunc(lpanel->list->ascendingGroup);        
	else if (sort_func=="descendingGroup")
		lpanel->list->setSortFunc(lpanel->list->descendingGroup);        
	FXuint ignore_case=getApp()->reg().readUnsignedEntry("LEFT PANEL","ignore_case",1);
	lpanel->list->setIgnoreCase(ignore_case);        

	// Read and set sort function for right panel
	sort_func=getApp()->reg().readStringEntry("RIGHT PANEL","sort_func","ascendingCase");
    if (sort_func=="ascendingCase")
		rpanel->list->setSortFunc(rpanel->list->ascendingCase);        
    else if (sort_func=="descendingCase")
		rpanel->list->setSortFunc(rpanel->list->descendingCase);        
    else if (sort_func=="ascending")
		rpanel->list->setSortFunc(rpanel->list->ascending);        
    else if (sort_func=="descending")
		rpanel->list->setSortFunc(rpanel->list->descending);        
	else if (sort_func=="ascendingSize")
		rpanel->list->setSortFunc(rpanel->list->ascendingSize);        
	else if (sort_func=="descendingSize")
		rpanel->list->setSortFunc(rpanel->list->descendingSize);        
	else if (sort_func=="ascendingType")
		rpanel->list->setSortFunc(rpanel->list->ascendingType);        
	else if (sort_func=="descendingType")
		rpanel->list->setSortFunc(rpanel->list->descendingType);        
	else if (sort_func=="ascendingTime")
		rpanel->list->setSortFunc(rpanel->list->ascendingTime);        
	else if (sort_func=="descendingTime")
		rpanel->list->setSortFunc(rpanel->list->descendingTime);        
	else if (sort_func=="ascendingUser")
		rpanel->list->setSortFunc(rpanel->list->ascendingUser);        
	else if (sort_func=="descendingUser")
		rpanel->list->setSortFunc(rpanel->list->descendingUser);         
	else if (sort_func=="ascendingGroup")
		rpanel->list->setSortFunc(rpanel->list->ascendingGroup);        
	else if (sort_func=="descendingGroup")
		rpanel->list->setSortFunc(rpanel->list->descendingGroup);        
	ignore_case=getApp()->reg().readUnsignedEntry("RIGHT PANEL","ignore_case",1);
	rpanel->list->setIgnoreCase(ignore_case);        

    FXButton *btn=NULL;
    FXToggleButton *tgbtn=NULL;

    // Spacer
    new FXFrame(toolbar,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,5,20);

    // Add some toolbar buttons
    btn=new FXButton(toolbar,_("\tGo up (Backspace)"),dirupicon,lpanel->current,FilePanel::ID_DIRECTORY_UP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    btn->addHotKey(KEY_BackSpace);

    new FXButton(toolbar,_("\tGo home (Ctrl-H)"),homeicon,lpanel->current,FilePanel::ID_GO_HOME,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

	toolbarSeparator(toolbar);

    new FXButton(toolbar,_("\tExecute command (Ctrl-E)"),runicon,this,XFileExplorer::ID_RUN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tTerminal (Ctrl-T)"),xtermicon,this,XFileExplorer::ID_XTERM,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tPanel refresh (Ctrl-R)"),reloadicon,this,XFileExplorer::ID_REFRESH,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

	toolbarSeparator(toolbar);

    new FXButton(toolbar,_("\tCreate new file (F2)"),minidocicon,lpanel->current,FilePanel::ID_NEW_FILE,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    new FXButton(toolbar,_("\tCreate new folder (F7)"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

	toolbarSeparator(toolbar);
	
    btn=new FXButton(toolbar,_("\tCopy selected files to clipboard (Ctrl-C, F5)"),copyicon,lpanel->current,FilePanel::ID_COPY_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    btn->addHotKey(KEY_F5);

    new FXButton(toolbar,_("\tCut selected files to clipboard (Ctrl-X)"),cuticon,lpanel->current,FilePanel::ID_CUT_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    new FXButton(toolbar,_("\tPaste from clipboard (Ctrl-V)"),pasteicon,lpanel->current,FilePanel::ID_PASTE_CLP,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);

    btn=new FXButton(toolbar,_("\tDelete selected files (Del, F8)"),delicon,lpanel->current,FilePanel::ID_FILE_DEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    hotkey=KEY_Delete;
    btn->addHotKey(hotkey);
    btn->addHotKey(KEY_F8);

    new FXButton(toolbar,_("\tShow properties of selected files (F9)"),attricon,lpanel->current,FilePanel::ID_PROPERTIES,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);

#if defined(linux)
	toolbarSeparator(toolbar);

    // Mount and unmount buttons
    btn=new FXButton(toolbar,_("\tMount (Ctrl-M)"),mapicon,lpanel->current,FilePanel::ID_MOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey=(0004<<16) | KEY_m;
    btn->addHotKey(hotkey);

    btn=new FXButton(toolbar,_("\tUnmount (Ctrl-U)"),unmapicon,lpanel->current,FilePanel::ID_UMOUNT,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
    hotkey=(0004<<16) | KEY_u;
    btn->addHotKey(hotkey);
#endif

	toolbarSeparator(toolbar);

	// Show tree and panel
   	new FXButton(toolbar,_("\tShow tree and panel (Ctrl-F1)"),treepanelicon,this,XFileExplorer::ID_SHOW_TREE_PANEL,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);

	// Show two panels
   	new FXButton(toolbar,_("\tShow two panels (Ctrl-F2)"),twopanelsicon,this,XFileExplorer::ID_SHOW_TWO_PANELS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);

	// Show or hide hidden files (button not shown : just to add the shortcut)   
    tgbtn=new FXToggleButton(toolbar,_("\tHide hidden files (Ctrl-F6)"),_("\tShow hidden files (Ctrl-F6)"),hidehiddenicon,showhiddenicon,lpanel->current,FilePanel::ID_TOGGLE_HIDDEN,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    tgbtn->hide();
	hotkey=(0004<<16) | KEY_F6;
    tgbtn->addHotKey(hotkey);

	// Show or hide thumbnails (button not shown : just to add the shortcut)   
   	tgbtn=new FXToggleButton(toolbar,_("\tHide thumbnails (Ctrl-F7)"),_("\tShow thumbnails (Ctrl-F7)"),showthumbicon,hidethumbicon,lpanel->current,FilePanel::ID_TOGGLE_THUMBNAILS,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT);
    tgbtn->hide();
	hotkey=(0004<<16) | KEY_F7;
   	tgbtn->addHotKey(hotkey);

	toolbarSeparator(toolbar);

    // Switch display modes
    btn=new FXButton(toolbar,_("\tBig icons (F10)"),largeicon,lpanel->current,FilePanel::ID_SHOW_BIG_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
   	btn->addHotKey(KEY_F10);
    btn=new FXButton(toolbar,_("\tSmall icons (F11)"),smallicon,lpanel->current,FilePanel::ID_SHOW_MINI_ICONS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
   	btn->addHotKey(KEY_F11);
    btn=new FXButton(toolbar,_("\tFull file list (F12)"),detailicon,lpanel->current,FilePanel::ID_SHOW_DETAILS,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    btn->addHotKey(KEY_F12);

	toolbarSeparator(toolbar);

    // Quit button
    btn=new FXButton(toolbar,_("\tQuit (Ctrl-Q, Ctrl-W)"),quiticon,this,XFileExplorer::ID_QUIT,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
    hotkey=(0004<<16) | KEY_w;
    btn->addHotKey(hotkey);

  	// Location bar
  	new FXLabel(locationbar,_("Location:"));
  	new FXButton(locationbar,_("\tClear Location bar\tClear Location bar."),locationicon,this,ID_CLEAR_LOCATION,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);
	address=new FXComboBox(locationbar,LOCATION_BAR_LENGTH,this,ID_GOTO_LOCATION,TEXTFIELD_NORMAL|JUSTIFY_LEFT|LAYOUT_CENTER_Y);
	address->setNumVisible(5);
 	new FXButton(locationbar,_("\tGo\tGo to location."),entericon,this,ID_GOTO_LOCATION,BUTTON_TOOLBAR|LAYOUT_TOP|LAYOUT_LEFT|ICON_BEFORE_TEXT|FRAME_RAISED);

    // Menus

    // File menu
    FXMenuPane* commenu=new FXMenuPane(this);
    new FXMenuCommand(commenu,_("New &file...\tF2"),minidocicon,lpanel->current,FilePanel::ID_NEW_FILE);
    new FXMenuCommand(commenu,_("New fo&lder...\tF7"),newfoldericon,lpanel->current,FilePanel::ID_NEW_DIR);
    new FXMenuCommand(commenu,_("&Execute command...\tCtrl-E"),runicon,this,ID_RUN);
    new FXMenuCommand(commenu,_("Go &home\tCtrl-H"),homeicon,lpanel->current,FilePanel::ID_GO_HOME);
    new FXMenuCommand(commenu,_("&Terminal\tCtrl-T"),minixtermicon,this,XFileExplorer::ID_XTERM);
    new FXMenuCommand(commenu,_("&Refresh\tCtrl-R"),reloadicon,this,XFileExplorer::ID_REFRESH);
    new FXMenuCommand(commenu,_("&Empty trash can\tCtrl-Del"),trashicon,this,XFileExplorer::ID_EMPTY_TRASHCAN);
    new FXMenuSeparator(commenu);
    new FXMenuCommand(commenu,_("&Open...\tCtrl-O"),openicon,lpanel->current,FilePanel::ID_OPEN);
    new FXMenuCommand(commenu,_("Re&name...\tCtrl-N"),renameicon,lpanel->current,FilePanel::ID_FILE_RENAME);
    new FXMenuCommand(commenu,_("&Copy to...\tCtrl-K"),copyicon,lpanel->current,FilePanel::ID_FILE_COPYTO);
    new FXMenuCommand(commenu,_("&Move...\tCtrl-D"),moveicon,lpanel->current,FilePanel::ID_FILE_MOVE);
    new FXMenuCommand(commenu,_("&Symlink...\tCtrl-S"),symlinkicon,lpanel->current,FilePanel::ID_FILE_SYMLINK);
    new FXMenuCommand(commenu,_("&Delete\tDel"),delicon,lpanel->current,FilePanel::ID_FILE_DEL);
    new FXMenuCommand(commenu,_("&Properties...\tF9"),attricon,lpanel->current,FilePanel::ID_PROPERTIES);
    new FXMenuSeparator(commenu);
    new FXMenuCommand(commenu,_("&Quit\tCtrl-Q"),quiticon,this,XFileExplorer::ID_QUIT);
    new FXMenuTitle(menubar,_("&File"),NULL,commenu);

    // Edit menu
    FXMenuPane* editmenu=new FXMenuPane(this);
    new FXMenuCommand(editmenu,_("&Copy\tCtrl-C"),copyicon,lpanel->current,FilePanel::ID_COPY_CLP);
    new FXMenuCommand(editmenu,_("C&ut\tCtrl-X"),cuticon,lpanel->current,FilePanel::ID_CUT_CLP);
    new FXMenuCommand(editmenu,_("&Paste\tCtrl-V"),pasteicon,lpanel->current,FilePanel::ID_PASTE_CLP);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("&Select all\tCtrl-A"),selallicon,lpanel->current,FilePanel::ID_SELECT_ALL);
    new FXMenuCommand(editmenu,_("&Deselect all\tCtrl-Z"),deselicon,lpanel->current,FilePanel::ID_DESELECT_ALL);
    new FXMenuCommand(editmenu,_("&Invert selection\tCtrl-I"),invselicon,lpanel->current,FilePanel::ID_SELECT_INVERSE);
    new FXMenuSeparator(editmenu);
    new FXMenuCommand(editmenu,_("P&references"),prefsicon,this,XFileExplorer::ID_PREFS);
    new FXMenuTitle(menubar,_("&Edit"),NULL,editmenu);

    // Bookmarks menu
    FXMenuPane* bookmarksmenu=new FXMenuPane(this);
    new FXMenuCommand(bookmarksmenu,_("&Add bookmark\tCtrl-B"),setbookicon,this,ID_ADD_BOOKMARK);
    FXMenuSeparator* sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(Bookmarks::ID_ANYBOOKMARKS);

    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_1);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_2);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_3);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_4);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_5);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_6);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_7);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_8);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_9);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_10);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_11);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_12);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_13);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_14);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_15);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_16);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_17);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_18);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_19);
    new FXMenuCommand(bookmarksmenu,NULL,NULL,bookmarks,Bookmarks::ID_BOOKMARK_20);

    sep1=new FXMenuSeparator(bookmarksmenu);
    sep1->setTarget(bookmarks);
    sep1->setSelector(Bookmarks::ID_ANYBOOKMARKS);
    new FXMenuCommand(bookmarksmenu,_("&Clear bookmarks"),clrbookicon,bookmarks,Bookmarks::ID_CLEAR);
    new FXMenuTitle(menubar,_("&Bookmarks"),NULL,bookmarksmenu);

    // View menu
    FXMenuPane* viewmenu=new FXMenuPane(this);
    new FXMenuCheck(viewmenu,_("&Tool&bar"),toolbar,FXWindow::ID_TOGGLESHOWN);
	new FXMenuCheck(viewmenu,_("&Location bar"),locationbar,FXWindow::ID_TOGGLESHOWN);
    new FXMenuCheck(viewmenu,_("&Status bar"),this,XFileExplorer::ID_TOGGLE_STATUS);
    new FXMenuSeparator(viewmenu);
    new FXMenuRadio(viewmenu,_("T&ree and panel\tCtrl-F1"),this,XFileExplorer::ID_SHOW_TREE_PANEL);
    new FXMenuRadio(viewmenu,_("Two &panels\tCtrl-F2"),this,XFileExplorer::ID_SHOW_TWO_PANELS);
    new FXMenuSeparator(viewmenu);
    new FXMenuCheck(viewmenu,_("&Hidden folders\tCtrl-F5"),dirpanel,DirPanel::ID_TOGGLE_HIDDEN);
    FXMenuCheck* autosave=new FXMenuCheck(viewmenu,_("&Auto save layout"),this,XFileExplorer::ID_AUTO_SAVE);
    new FXMenuTitle(menubar,_("&View"),NULL,viewmenu);

    // Left View Menu Pane
    leftviewmenu=new FXMenuPane(this);
    new FXMenuCommand(leftviewmenu,_("&Filter..."),filtericon,lpanel,FilePanel::ID_FILTER);
    new FXMenuCheck(leftviewmenu,_("&Hidden files"),lpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCheck(leftviewmenu,_("&Thumbnails"),lpanel->list,FileList::ID_TOGGLE_THUMBNAILS);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuRadio(leftviewmenu,_("&Big icons"),lpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuRadio(leftviewmenu,_("&Small icons"),lpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuRadio(leftviewmenu,_("F&ull file list"),lpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuRadio(leftviewmenu,_("&Rows"),lpanel->list,FXIconList::ID_ARRANGE_BY_ROWS);
    new FXMenuRadio(leftviewmenu,_("&Columns"),lpanel->list,FXIconList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(leftviewmenu);
    new FXMenuRadio(leftviewmenu,_("&Name"),lpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuRadio(leftviewmenu,_("Si&ze"),lpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuRadio(leftviewmenu,_("T&ype"),lpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuRadio(leftviewmenu,_("Ti&me"),lpanel->list,FileList::ID_SORT_BY_TIME);
  	new FXMenuCheck(leftviewmenu,_("I&gnore case"),lpanel->list,FileList::ID_SORT_CASE);
    lmenutitle=new FXMenuTitle(menubar,_("&Left panel"),NULL,leftviewmenu);

    // Right View Menu Pane
    rightviewmenu=new FXMenuPane(this);
    new FXMenuCommand(rightviewmenu,_("&Filter"),filtericon,rpanel,FilePanel::ID_FILTER);
    new FXMenuCheck(rightviewmenu,_("&Hidden files"),rpanel->list,FileList::ID_TOGGLE_HIDDEN);
    new FXMenuCheck(rightviewmenu,_("&Thumbnails"),rpanel->list,FileList::ID_TOGGLE_THUMBNAILS);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuRadio(rightviewmenu,_("&Big icons"),rpanel->list,FXIconList::ID_SHOW_BIG_ICONS);
    new FXMenuRadio(rightviewmenu,_("&Small icons"),rpanel->list,FXIconList::ID_SHOW_MINI_ICONS);
    new FXMenuRadio(rightviewmenu,_("F&ull file list"),rpanel->list,FXIconList::ID_SHOW_DETAILS);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuRadio(rightviewmenu,_("&Rows"),rpanel->list,FXIconList::ID_ARRANGE_BY_ROWS);
    new FXMenuRadio(rightviewmenu,_("&Columns"),rpanel->list,FXIconList::ID_ARRANGE_BY_COLUMNS);
    new FXMenuSeparator(rightviewmenu);
    new FXMenuRadio(rightviewmenu,_("&Name"),rpanel->list,FileList::ID_SORT_BY_NAME);
    new FXMenuRadio(rightviewmenu,_("Si&ze"),rpanel->list,FileList::ID_SORT_BY_SIZE);
    new FXMenuRadio(rightviewmenu,_("T&ype"),rpanel->list,FileList::ID_SORT_BY_TYPE);
    new FXMenuRadio(rightviewmenu,_("Ti&me"),rpanel->list,FileList::ID_SORT_BY_TIME);
  	new FXMenuCheck(rightviewmenu,_("I&gnore case"),rpanel->list,FileList::ID_SORT_CASE);
    rmenutitle=new FXMenuTitle(menubar,_("&Right panel"),NULL,rightviewmenu);

    // Help menu
    FXMenuPane* helpmenu=new FXMenuPane(this);
    new FXMenuTitle(menubar,_("&Help"),NULL,helpmenu);
    new FXMenuCommand(helpmenu,_("&Help\tF1"),helpicon,this,ID_HELP);
    new FXMenuCommand(helpmenu,_("&About X File Explorer"),NULL,this,ID_ABOUT);

  	// Install some other key accelerators for compatibility with Midnight Commander
	getAccelTable()->addAccel(FXSEL(0,KEY_F3),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_VIEW));
	getAccelTable()->addAccel(FXSEL(0,KEY_F4),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_EDIT));
	getAccelTable()->addAccel(FXSEL(0,KEY_F6),lpanel->current,FXSEL(SEL_COMMAND,FilePanel::ID_FILE_MOVE));

    // Make a tool tip
    new FXToolTip(app,0);
    
	// Get autosave flag
    auto_save_layout=getApp()->reg().readUnsignedEntry("OPTIONS","auto_save_layout",TRUE);
    if (auto_save_layout==TRUE)
		autosave->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
}

// Save configuration when quitting
void XFileExplorer::saveConfig()
{
    if(auto_save_layout==TRUE)
    {
		getApp()->reg().writeUnsignedEntry("LEFT PANEL","name_size",lpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","size_size",lpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","type_size",lpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","modd_size",lpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","user_size",lpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","grou_size",lpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","attr_size",lpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","liststyle",lpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","hiddenfiles",lpanel->list->showHiddenFiles());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","showthumbnails",lpanel->list->showThumbnails());
        
		// Get and write sort function for left panel
		FXString sort_func;
		if (lpanel->list->getSortFunc()==lpanel->list->ascendingCase)
			sort_func="ascendingCase";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingCase)
			sort_func="descendingCase";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascending)
			sort_func="ascending";
		else if (lpanel->list->getSortFunc()==lpanel->list->descending)
			sort_func="descending";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingSize)
			sort_func="ascendingSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingSize)
			sort_func="descendingSize";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingType)
			sort_func="ascendingType";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingType)
			sort_func="descendingType";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingTime)
			sort_func="ascendingTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingTime)
			sort_func="descendingTime";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingUser)
			sort_func="ascendingUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingUser)
			sort_func="descendingUser";
		else if (lpanel->list->getSortFunc()==lpanel->list->ascendingGroup)
			sort_func="ascendingGroup";
		else if (lpanel->list->getSortFunc()==lpanel->list->descendingGroup)
			sort_func="descendingGroup";
		else
			sort_func="ascendingCase";
		getApp()->reg().writeStringEntry("LEFT PANEL","sort_func",sort_func.text());
        getApp()->reg().writeUnsignedEntry("LEFT PANEL","ignore_case",lpanel->list->getIgnoreCase());

		getApp()->reg().writeUnsignedEntry("RIGHT PANEL","name_size",rpanel->list->getHeaderSize(0));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","size_size",rpanel->list->getHeaderSize(1));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","type_size",rpanel->list->getHeaderSize(2));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","modd_size",rpanel->list->getHeaderSize(3));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","user_size",rpanel->list->getHeaderSize(4));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","grou_size",rpanel->list->getHeaderSize(5));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","attr_size",rpanel->list->getHeaderSize(6));
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","liststyle",rpanel->list->getListStyle());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_width",(FXuint)rpanel_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","panel_tree_width",(FXuint)rpanel_tree_width);
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","hiddenfiles",rpanel->list->showHiddenFiles());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","showthumbnails",rpanel->list->showThumbnails());

		// Get and write sort function for right panel
		if (rpanel->list->getSortFunc()==rpanel->list->ascendingCase)
			sort_func="ascendingCase";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingCase)
			sort_func="descendingCase";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascending)
			sort_func="ascending";
		else if (rpanel->list->getSortFunc()==rpanel->list->descending)
			sort_func="descending";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingSize)
			sort_func="ascendingSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingSize)
			sort_func="descendingSize";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingType)
			sort_func="ascendingType";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingType)
			sort_func="descendingType";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingTime)
			sort_func="ascendingTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingTime)
			sort_func="descendingTime";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingUser)
			sort_func="ascendingUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingUser)
			sort_func="descendingUser";
		else if (rpanel->list->getSortFunc()==rpanel->list->ascendingGroup)
			sort_func="ascendingGroup";
		else if (rpanel->list->getSortFunc()==rpanel->list->descendingGroup)
			sort_func="descendingGroup";
		else
			sort_func="ascendingCase";
		getApp()->reg().writeStringEntry("RIGHT PANEL","sort_func",sort_func.text());
        getApp()->reg().writeUnsignedEntry("RIGHT PANEL","ignore_case",rpanel->list->getIgnoreCase());

        getApp()->reg().writeUnsignedEntry("OPTIONS","width",(FXuint)getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","height",(FXuint)getHeight());
        getApp()->reg().writeIntEntry("OPTIONS","xpos",getX());
        getApp()->reg().writeIntEntry("OPTIONS","ypos",getY());
        getApp()->reg().writeUnsignedEntry("OPTIONS","toolbar",(FXuint)toolbar->shown());
		getApp()->reg().writeUnsignedEntry("OPTIONS","locationbar",(FXuint)locationbar->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","status",(FXuint)lpanel->statusbar->shown());
        getApp()->reg().writeUnsignedEntry("OPTIONS","panel_view",(FXuint)panel_view);
        getApp()->reg().writeUnsignedEntry("OPTIONS","root_warn",(FXuint)warn_if_root);
        getApp()->reg().writeUnsignedEntry("OPTIONS","use_trashcan",(FXuint)use_trashcan);
#if defined(linux)
        getApp()->reg().writeUnsignedEntry("OPTIONS","mount_warn",(FXuint)mount_warn);
		getApp()->reg().writeUnsignedEntry("OPTIONS","mount_messages",(FXuint)mount_messages);
#endif
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_width",(FXuint)dirpanel->getWidth());
        getApp()->reg().writeUnsignedEntry("OPTIONS","tree_hidden_dir",dirpanel->list->showHiddenFiles());

        FXString history="";
        for(int i=0;i<RunHistSize;i++)
        {
            history+=RunHistory[i];
            history+=":";
        }
        if(RunHistory)
            getApp()->reg().writeStringEntry("HISTORY","run",history.text());

        history="";
        for(int i=0;i<OpenNum;i++)
        {
            history+=OpenHistory[i];
            history+=":";
        }
        if(OpenNum)
            getApp()->reg().writeStringEntry("HISTORY","open",history.text());
    }
    getApp()->reg().writeUnsignedEntry("OPTIONS","auto_save_layout",auto_save_layout);
    getApp()->reg().write();
}

// Make application
void XFileExplorer::create()
{
    panel_view=getApp()->reg().readUnsignedEntry("OPTIONS","panel_view",TREE_PANEL);
    width=getApp()->reg().readUnsignedEntry("OPTIONS","width",600);
    height=getApp()->reg().readUnsignedEntry("OPTIONS","height",500);
    xpos=getApp()->reg().readIntEntry("OPTIONS","xpos",0);
    ypos=getApp()->reg().readIntEntry("OPTIONS","ypos",0);
    position(xpos,ypos,width,height);

    FXMainWindow::create();
	FXint window_width=getWidth();
    FXint dirpanel_width=getApp()->reg().readUnsignedEntry("OPTIONS","tree_width",200);
	dirpanel->setWidth(dirpanel_width);
    rpanel_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_width",200);
    rpanel_tree_width=getApp()->reg().readUnsignedEntry("RIGHT PANEL","panel_tree_width",200);
	switch(panel_view)
	{
	case TWO_PANELS:
        dirpanel->hide();
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		break;
	case TREE_PANEL:
        rpanel->hide();
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		break;
	}

    if(!getApp()->reg().readUnsignedEntry("OPTIONS","toolbar",TRUE))
        toolbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","locationbar",TRUE))
        locationbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    if(!getApp()->reg().readUnsignedEntry("OPTIONS","status",TRUE))
        handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_TOGGLE_STATUS),NULL);

	// Wheel scrolling
    FXint wheellines=getApp()->reg().readUnsignedEntry("SETTINGS","wheellines",5);
	getApp()->setWheelLines(wheellines);
	
    // Open left or right panel in starting directory (if specified) or in current directory
    if (startdir=="")
        startdir=FXFile::getCurrentDirectory();

    liststyle=getApp()->reg().readUnsignedEntry("LEFT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
    lpanel->list->setDirectory(startdir);
    lpanel->label->setText(startdir);
    lpanel->list->setListStyle(liststyle);
    dirpanel->list->setDirectory(startdir,TRUE);

    liststyle=getApp()->reg().readUnsignedEntry("RIGHT PANEL","liststyle",(FXuint)FXIconList::ID_SHOW_DETAILS);
    rpanel->list->setDirectory(startdir);
    rpanel->label->setText(startdir);
    rpanel->list->setListStyle(liststyle);

	// Show or hide hidden files listed in panels
    FXbool hiddenfiles;
	hiddenfiles=getApp()->reg().readUnsignedEntry("LEFT PANEL","hiddenfiles",0);
    lpanel->list->showHiddenFiles(hiddenfiles);
    hiddenfiles=getApp()->reg().readUnsignedEntry("RIGHT PANEL","hiddenfiles",0);
    rpanel->list->showHiddenFiles(hiddenfiles);
	
	// Show or hide hidden directories listed in dirpanel
    FXbool tree_hidden_dir;
	tree_hidden_dir=getApp()->reg().readUnsignedEntry("OPTIONS","tree_hidden_dir",0);
    dirpanel->list->showHiddenFiles(tree_hidden_dir);

    // Display thumbnails or not
    FXbool showthumbnails;
	showthumbnails=getApp()->reg().readUnsignedEntry("LEFT PANEL","showthumbnails",0);
    lpanel->list->showThumbnails(showthumbnails);
    showthumbnails=getApp()->reg().readUnsignedEntry("RIGHT PANEL","showthumbnails",0);
    rpanel->list->showThumbnails(showthumbnails);
	
	// Get external programs settings
	editor=getApp()->reg().readStringEntry("PROGS","editor","nedit ");
    viewer=getApp()->reg().readStringEntry("PROGS","viewer","xfv ");
    xterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");

    warn_if_root=getApp()->reg().readUnsignedEntry("OPTIONS","root_warn",TRUE);
    use_trashcan=getApp()->reg().readUnsignedEntry("OPTIONS","use_trashcan",TRUE);
    confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
    confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
    confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
    ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
    FXString history=getApp()->reg().readStringEntry("HISTORY","run","");
#if defined(linux)
	mount_warn=getApp()->reg().readUnsignedEntry("OPTIONS","mount_warn",TRUE);
	mount_messages=getApp()->reg().readUnsignedEntry("OPTIONS","mount_messages",TRUE);
#endif

   	int i;
    FXString histent;
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.section(':',i);
            if(::streq(histent.text(),""))
                break;
            strlcpy(RunHistory[i],histent.text(),histent.length()+1);
        }
        RunHistSize=i;
    }
    else
        RunHistSize=0;

    history=getApp()->reg().readStringEntry("HISTORY","open","");
    histent="";
    if(history != "")
    {
        for(i=0;;i++)
        {
            histent=history.section(':',i);
            if(::streq(histent.text(),""))
                break;
			strlcpy(OpenHistory[i],histent.text(),histent.length()+1);
        }
        OpenNum=i;
    }
    else
        OpenNum=0;

    getApp()->forceRefresh();

	// Running as root?
    if(getuid()==0 && warn_if_root)
        MessageBox::information(this,MBOX_OK,_("Warning"),_("Running Xfe as root!"));

	// Show window
    show();

#if defined(linux)
	// Warning message if a mount point is down
	if (mount_warn)
	{
		FXint d;
		for (d=updevices->first(); d<updevices->size(); d=updevices->next(d))
		{
			if(::streq(updevices->data(d),"down"))
				MessageBox::warning(this,MBOX_OK,_("Warning"),_("Mount point %s is not responding..."),updevices->key(d));
		}
	}
#endif

    // Create trash can directory if it doesn't exist
	FXString homelocation=getenv("HOME");
    if(homelocation=="")
        homelocation=ROOTDIR;
	trashlocation=homelocation+PATHSEPSTRING+TRASHNAME;
	if (!exists(trashlocation))
	{
		// Create the trash can directory
		FXint ret=::mkdir(trashlocation.text(),0755);
		if (ret==-1)
         	MessageBox::error(this,MBOX_OK,_("Error"),"Cannot create trash can directory '%s': %s",trashlocation.text(),strerror(errno));
    		// And what to do after that?
	}

	// Eventually start iconic or maximized
	if (iconic)
		minimize();
	if (maximized)
		maximize();		
}

// Destructor
XFileExplorer::~XFileExplorer()
{
    delete menubar;
    delete toolbar;
    delete dirpanel;
    delete lpanel;
    delete rpanel;
    delete leftviewmenu;
    delete rightviewmenu;
    delete rmenutitle;
    delete lmenutitle;
    delete bookmarks;	
}


// If Tab pressed, cycle through the panels 
long XFileExplorer::onKeyPress(FXObject* sender,FXSelector sel,void* ptr)
{
    FXEvent* event=(FXEvent*)ptr;
	FXint current;
    
	// Tab was pressed : cycle through the panels
	if(event->code==KEY_Tab)
    {
		if (dirpanel->shown())
		{
			if (dirpanel->hasFocus())
			{
				lpanel->list->setFocus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				lpanel->list->setCurrentItem(current);
				lpanel->list->selectItem(current);
			}
			else
			{
				dirpanel->list->setFocus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;				
				lpanel->list->deselectItem(current);
			}
		}
		else
		{
			if (lpanel->current==rpanel)
			{
				lpanel->focus();
				current=lpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				lpanel->list->selectItem(current);
			}
			else
			{
				rpanel->focus();
				current=rpanel->list->getCurrentItem();
				if (current<0)
					current=0;
				rpanel->list->selectItem(current);
			}
		}
		return 1;
	}

	// Shift-F10 was pressed : open popup menu
	else if(event->state&SHIFTMASK && event->code==KEY_F10)
    {
		lpanel->current->handle(sender,FXSEL(SEL_COMMAND,FilePanel::ID_MENU),NULL);
        return 1;
    }

	// Any other key was pressed : handle the pressed key in the usual way
    else
	{
		if(FXTopWindow::onKeyPress(sender,sel,ptr))
        	return 1;
		else
			return 0;
	}

}


// Handle quitting
long XFileExplorer::onQuit(FXObject*,FXSelector,void*)
{
    if(confirm_quit)
        if(MBOX_CLICKED_CANCEL==MessageBox::question(this,MBOX_QUIT_CANCEL,_("Quitting Xfe"),_("Do you really want to quit Xfe?")))
            return 1;
    saveConfig();
	while(waitpid(-1,NULL,WNOHANG)>0);
	getApp()->exit(0);
    return 1;
}




// Handle bookmarks
long  XFileExplorer::onCmdBookmark(FXObject*,FXSelector s,void* p)
{
    if(FXSELID(s) == ID_ADD_BOOKMARK)
        bookmarks->appendBookmark(lpanel->current->list->getDirectory());
	
	// Handle location address fields
	else if(FXSELID(s) == ID_BOOKMARK)
	{
        lpanel->current->list->setDirectory((FXchar*)p);
        dirpanel->list->setDirectory((FXchar*)p,TRUE);
        FXString item;
		FXint i=0;
		FXint count=address->getNumItems();
		if(!count)
		{
			count++;
			address->insertItem(0,address->getText());
		}
        while(i < count)
		{
        	item=address->getItem(i++);
        	if(::streq((char*)p,(const char*)&item[0]))
			{
				i--;
				break;
			}
        }
        if(i==count) 
			address->insertItem(0,(FXchar*)p);
    }
    return 1;
}


// Goto location entered into the text field;
long XFileExplorer::onCmdGotoLocation(FXObject*,FXSelector,void*)
{
	FXString path=FXFile::absolute(lpanel->current->list->getDirectory(),address->getText());
	FXString dir=path;

	// Go up to the lowest directory which still exists
	while(!FXFile::isTopDirectory(dir) && !::isDirectory(dir))
    	dir=FXFile::upLevel(dir);

	// Move to this existing directory
	lpanel->current->list->setDirectory(dir);
	dirpanel->list->setDirectory(dir,TRUE);
	address->setText(path);
	
	return 1;
}


// Clear location bar
long XFileExplorer::onCmdClearLocation(FXObject*,FXSelector,void*)
{
  address->setText(FXString::null);
  return 1;
}

// Restart the application when required
long  XFileExplorer::onCmdRestart(FXObject*,FXSelector,void*)
{
    saveConfig();

    if(fork() == 0)
        execvp("xfe",args);
    else
        exit(0);
    return 1;
}


// Run Terminal
long  XFileExplorer::onCmdXTerm(FXObject*,FXSelector,void*)
{
    chdir(lpanel->current->list->getDirectory().text());
    FXString cmd=xterm;
    cmd += " &";
    system(cmd.text());
    lpanel->current->list->setFocus();
    return 0;
}


// Help menu
long XFileExplorer::onCmdHelp(FXObject*,FXSelector,void*)
{
    // Display help window
	TextWindow *helpwindow=new TextWindow(this,_("Help"),35,90);			

    // Set text font
	FXString fontspec;
	fontspec=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
	if(!fontspec.empty())
	{
    	FXFont* font=new FXFont(getApp(),fontspec);
        helpwindow->setFont(font);
	}

	helpwindow->setText(helptext);
	helpwindow->execute(PLACEMENT_CURSOR);
	delete helpwindow;
    lpanel->current->list->setFocus();
    return 1;
}

// About menu
long XFileExplorer::onCmdAbout(FXObject*,FXSelector,void*)
{
    FXPNGIcon icon(getApp(),FileManager);
    char msg[1000];
    snprintf(msg,sizeof(msg)-1,_("XFE, X File Explorer Version %s\n\nCopyright (C) 2002-2005 Roland Baudin (roland65@free.fr)\n\nBased on X WinCommander by Maxim Baranov\n"),VERSION);
    MessageBox about(this,_("About X File Explorer"),msg,&icon,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
    about.execute(PLACEMENT_CURSOR);
    lpanel->current->list->setFocus();
    return 1;
}


// Handle file association (called by Properties.cc)
long XFileExplorer::onCmdFileAssoc(FXObject*,FXSelector s,void *p)
{
	char **str=(char**)p;
    char* ext=str[0];
    char* cmd=str[1];

	// ext=extension, cmd=associated command
	// replace : to allow immediate association in Xfe
    FileDict *associations=lpanel->list->getAssociations();
    associations->replace(ext,cmd);
    associations=rpanel->list->getAssociations();
    associations->replace(ext,cmd);

    return 1;
}


// FilePanel and DirPanel refresh
long XFileExplorer::onCmdRefresh(FXObject*,FXSelector,void*)
{
	getApp()->beginWaitCursor();
#if defined(linux)
	dirpanel->list->onMtdevicesRefresh(0,0,0);
	dirpanel->list->onUpdevicesRefresh(0,0,0);
#endif
	lpanel->current->onRefresh(0,0,0);
	dirpanel->list->onRefresh(0,0,0);
	getApp()->endWaitCursor();
	return 1;
}


// Update file location
long XFileExplorer::onUpdFileLocation(FXObject* sender,FXSelector,void*)
{
	static FXString prevdir=NULL;
	FXString currentdir=lpanel->current->list->getDirectory();
	if (currentdir != prevdir)
	{
		address->setText(currentdir);
		prevdir=currentdir;
	}
	return 1;
}


// Switch between the two possible panel views
long XFileExplorer::onCmdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
	// Get directory tree and window widths
	FXint dirpanel_width=dirpanel->getWidth();
	FXint window_width=getWidth();

    switch(FXSELID(sel))
    {
    case ID_SHOW_TWO_PANELS:
		panel_view=TWO_PANELS;
		lpanel->setWidth(window_width-8-rpanel_width);
		rpanel->setWidth(rpanel_width);
		if (dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (!rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
        break;
    case ID_SHOW_TREE_PANEL:
		panel_view=TREE_PANEL;
		lpanel->setWidth(window_width-8-dirpanel_width);
		rpanel->setWidth(rpanel_tree_width);
		if (!dirpanel->shown())
    		dirpanel->handle(sender,FXSEL(SEL_COMMAND,DirPanel::ID_TOGGLE_TREE),ptr);
		if (rpanel->shown())
			rpanel->handle(sender,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),ptr);	
        break;
    }
	return 1;
}

// Update sender
long XFileExplorer::onUpdShowPanels(FXObject* sender,FXSelector sel,void* ptr)
{
    FXuint msg=FXWindow::ID_UNCHECK;
		
    switch(FXSELID(sel))
    {
	case ID_SHOW_TWO_PANELS:
		if (!dirpanel->shown() && rpanel->shown())
		{
            msg=FXWindow::ID_CHECK;
			rpanel_width=rpanel->getWidth();
        	if(!rmenutitle->shown())
        	{
            	rmenutitle->show();
            	rmenutitle->setText(_("&Right panel"));
            	lmenutitle->setText(_("&Left panel"));
            	lpanel->focus();
        	}
		}
        break;
    
	case ID_SHOW_TREE_PANEL:
 		if (dirpanel->shown() && !rpanel->shown())
		{
           	msg=FXWindow::ID_CHECK;		
			rpanel_tree_width=rpanel->getWidth();
        	if(rmenutitle->shown())
        	{
            	lpanel->focus();
            	rmenutitle->hide();
            	lmenutitle->setText(_("&Panel"));
            	lpanel->focus();
       	 	}
		}
        break;
    }
    sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
    return 1;
}



// Toggle autosave flag
long XFileExplorer::onCmdAutoSave(FXObject* sender,FXSelector,void*)
{
    if(auto_save_layout==TRUE)
    {
        auto_save_layout=FALSE;
        sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
    }
    else
    {
        auto_save_layout=TRUE;
        sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
    }
    return 1;
}



// Preferences
long XFileExplorer::onCmdPrefs(FXObject*,FXSelector s,void *p)
{
    PreferencesBox *prefs=new PreferencesBox(this);
    prefs->execute(PLACEMENT_SCREEN);
    delete prefs;
    lpanel->current->list->setFocus();
    return 1;
}


// Reload preferences
long XFileExplorer::onCmdReloadPrefs(FXObject*,FXSelector s,void *p)
{
    editor=getApp()->reg().readStringEntry("PROGS","editor","nedit");
    viewer=getApp()->reg().readStringEntry("PROGS","viewer","xfv");
    xterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");

    confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
    confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
    confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
    ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
    return 1;
}


long XFileExplorer::onCmdToggleStatus(FXObject*,FXSelector s,void *p)
{
    dirpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    lpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    rpanel->statusbar->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_TOGGLESHOWN),NULL);
    return 1;
}


long XFileExplorer::onUpdToggleStatus(FXObject *o,FXSelector s,void *p)
{
    FXMenuCheck *cmd =(FXMenuCheck*)o;
    if(lpanel->statusbar->shown())
        cmd->setCheck(TRUE);
    else
        cmd->setCheck(FALSE);
    return 1;
}


// Run shell command or X program
long XFileExplorer::onCmdRun(FXObject*,FXSelector,void*)
{
    int i;
    chdir(lpanel->current->list->getDirectory().text());
    HistInputDialog* dialog;
    FXString command="";
    dialog=new HistInputDialog(this,command,_("Execute the command :"),_("Execute command"),"", NULL,1, _("Console mode"));
    for(int i=0;i<RunHistSize;i++)
        dialog->appendItem(RunHistory[i]);
    dialog->CursorEnd();
    if(dialog->execute())
    {
        command=dialog->getText();
        if(command != "")
        {
			// Execute command in command window
			if (dialog->getOption())
			{
    			// Make and show command window
				CommandWindow *cmdwin=new CommandWindow(getApp(),_("Command log"),command,30,80);			
				cmdwin->create();
				
				// The CommandWindow object will delete itself when closed!
			}
			
			// Execute silently in background
			else
			{
				command+=" &";
				system(command.text());
			}
        }
		// Update history list
		RunHistSize=dialog->getHistorySize();
        RunHistSize++;
        command=dialog->getText();
        if(RunHistSize>RUN_HIST_SIZE)
            RunHistSize=RUN_HIST_SIZE;
        for(i=0;i<RunHistSize-1;i++)
            if(::streq(RunHistory[i],command.text()))
                break;
        if(i==RunHistSize-1)
        {
            strlcpy(RunHistory[0],command.text(),command.length()+1);
            for(i=1;i<RunHistSize;i++)
                strlcpy(RunHistory[i],dialog->getHistoryItem(i-1).text(),dialog->getHistoryItem(i-1).length()+1);
        }
        else
            RunHistSize--;
    }
    delete dialog;
    lpanel->current->list->setFocus();
    return 1;
}


// Empty trash can
long XFileExplorer::onCmdEmptyTrashcan(FXObject*,FXSelector sel,void* ptr)
{
    // Confirmation message
	FXPNGIcon icon(getApp(),trash_full_big);
	FXString message=_("Do you really want to empty the trash can?\n\nAll items will be definitively lost!");
    MessageBox box(this,_("Empty trash can"),message,&icon,MBOX_OK_CANCEL|DECOR_TITLE|DECOR_BORDER);
 	if(box.execute(PLACEMENT_CURSOR) != MBOX_CLICKED_OK)
    	return 0;

	// Wait cursor
	getApp()->beginWaitCursor();

	// Delete trash can folder	
   	File* f=new File(this,_("File Delete"),DELETE);
   	f->create();
	f->remove(trashlocation);
	delete f;
	
	// Re-create the trash can directory
	if (!exists(trashlocation))
	{
		FXint ret=::mkdir(trashlocation.text(),0755);
		if (ret==-1)
         	MessageBox::error(this,MBOX_OK,_("Error"),"Cannot create trash can directory '%s': %s",trashlocation.text(),strerror(errno));
	}
 
 	// Wait cursor
	getApp()->endWaitCursor();
	
	onCmdRefresh(0,0,0);
	
	return 1;
}



// Update the empty trash can menu item
long XFileExplorer::onUpdEmptyTrashcan(FXObject* o,FXSelector,void*)
{
	if (use_trashcan)
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


// Copy/Move/Rename/Symlink File(s) 
long XFileExplorer::onCmdFileMan(FXObject*,FXSelector sel,void* ptr)
{
    FXString command, message, title, target;
	File *f=NULL;
	FXbool dirman=FALSE;

    lpanel->current->list->setFocus();

	// Extract target directory, number of sources and sources names
	FXString str=(char*)ptr;

	FXString targetdir=str.section('\n',0);
	int num=FXUIntVal(str.section('\n',1));
	FXString src=str.after('\n',2);

    const unsigned char *ic=::copy_big;
    FXIcon *icon=NULL;
    chdir(targetdir.text());
    
	// No selected files
	if(num==0)
        return 0;
		
	// We were called from DirPanel::onCmdDirMan
	if (num==-1)
	{
		dirman=TRUE;
		num=1;
	}
		
	// Name and directory of the first source file
	FXString source=src.section('\n',0);
	FXString name=FXFile::name(source);
	FXString dir=FXFile::directory(source);

	// Initialise target name	
	if (targetdir!=ROOTDIR)
		target=targetdir+PATHSEPSTRING;
	else
		target=targetdir;

    // Configure the command, title, message, etc.
	if(FXSELID(sel)==ID_FILE_COPY)
    {
        command="copy";
        title=_("Copy");
        ic=::copy_big;
        if(num==1)
        {
            message=_("Copy ");
            message+=source;
		}
        else
            message=_("Copy ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_RENAME)
    {
        command="rename";
        title=_("Rename");
        ic=move_big;
        if(num==1)
        {
            message=_("Rename ");
			message+=name;
            target=name;
			title=_("Rename");
        }
        else
			return 0;
    }
	if(FXSELID(sel)==ID_FILE_COPYTO)
    {
        command="copy";
        title=_("Copy to");
        ic=::copy_big;
        if(num==1)
        {
            message=_("Copy ");
            message+=source;
		}
        else
            message=_("Copy ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_MOVE)
    {
        command="move";
        title=_("Move");
        ic=move_big;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_CUT)
    {
        command="move";
        title=_("Move");
        ic=move_big;
        if(num==1)
        {
            message=_("Move ");
            message+=source;
            title=_("Move");
        }
        else
            message=_("Move ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
    if(FXSELID(sel)==ID_FILE_SYMLINK)
    {
        command="symlink";
        title=_("Symlink");
        ic=link_big;
        if(num==1)
        {
            message=_("Symlink ");
            message+=source;
        }
        else
            message=_("Symlink ")+FXStringVal(num)+_(" files/folders.\nFrom: ")+dir;
    }
	
    // File operation dialog, if needed
	if(ask_before_copy || source==target ||  FXSELID(sel)==ID_FILE_COPYTO || FXSELID(sel)==ID_FILE_MOVE ||  FXSELID(sel)==ID_FILE_RENAME || FXSELID(sel)==ID_FILE_SYMLINK)
	{
    	InputDialog* dialog;
    	icon=new FXPNGIcon(getApp(),ic);
    	dialog=new InputDialog(this,target,message,title,_("To:"),icon);
    	dialog->CursorEnd();
	    int rc=1;
        rc=dialog->execute(PLACEMENT_CURSOR);
	    target=dialog->getText();
		delete dialog;
		delete icon;
		if (!rc)
			return 0;
	}    

	// Update target and target parent directory
	target=::filePath(target);
	if (!::isDirectory(target))
		targetdir=FXFile::directory(target);
	else
		targetdir=target;	

    // Target directory not writable
    if(!::isWritable(targetdir))
    {
        MessageBox::error(this,MBOX_OK,_("Error"), _("Can't write to %s : Permission denied"), targetdir.text());
        return 0;
    }

	// Multiple sources and non existent destination
	if (num>1 & !::exists(target))
	{
        MessageBox::error(this,MBOX_OK,_("Error"),_("Folder %s does'nt exist"),target.text());
        return 0;
	}
		
	// Multiple sources and target is a file
	if (num>1 & ::isFile(target))
	{ 			
        MessageBox::error(this,MBOX_OK,_("Error"),_("%s is not a folder"),target.text());
        return 0;
	}

	// Target is a directory and is not writable
    if(::isDirectory(target) & !::isWritable(target))
    {
        MessageBox::error(this,MBOX_OK,_("Error"),_("Can't write to %s : Permission denied"), target.text());
        return 0;
    }
	
	// Target is a file and its parent directory is not writable
	if (::isFile(target) & !::isWritable(targetdir))
	{
        MessageBox::error(this,MBOX_OK,_("Error"),_("Can't write to %s : Permission denied"),targetdir.text());
        return 0;
	}

	// Target parent directory doesn't exist
	if (!::exists(targetdir))
	{
		MessageBox::error(this,MBOX_OK,_("Error"),_("Folder %s does'nt exist"),targetdir.text());
        return 0;
	}
		
	// Target parent directory is not a directory
	if (!::isDirectory(targetdir))
	{
		MessageBox::error(this,MBOX_OK,_("Error"),_("%s is not a folder"),targetdir.text());
        return 0;
	}
		
	// One source
    if(num==1)
	{
		// An empty source file name corresponds to the ".." file
		// Don't perform any file operation on it!
		if (source=="")
			return 0;
		
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if(command=="copy")
        {
			f=new File(this,_("File copy"),COPY);
        	f->create();
			f->copy(source,target);
			
			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,MBOX_OK,_("Error"),_("Copy file operation cancelled!"));
			}
        }
        else if(command=="rename")
        {
			f=new File(this,_("File rename"),RENAME);
        	f->create();
			f->rename(source,target);
        }
        else if(command=="move")
        {
			f=new File(this,_("File move"),MOVE);
        	f->create();
			f->move(source,target);

			// If action is cancelled in progress dialog
			if (f->isCancelled)
			{
				f->hide();
				MessageBox::error(this,MBOX_OK,_("Error"),_("Move file operation cancelled!"));
			}
        }
        else if(command=="symlink")
        {
			f=new File(this,_("Symlink"),SYMLINK);
        	f->create();
			f->symlink(source,target);
		}
       	else
           	exit(-1);
									
		getApp()->endWaitCursor();
		delete f;

		// We were called from DirPanel::onCmdDirMan => set directory to the new one in DirList and FileList
		if (dirman)
		{
			((XFileExplorer*) mainWindow)->dirpanel->list->setDirectory(target,TRUE);
			lpanel->current->list->setDirectory(target);
		}
	}
	
	// Multiple sources
	// Note : rename and symlink are not used in this case!
    else if(num>1)
    {
		// Wait cursor
		getApp()->beginWaitCursor();

		// File object
        if (command=="copy")
			f=new File(this,_("File copy"),COPY);
		else if (command=="move")
			f=new File(this,_("File move"),MOVE);
		f->create();
			
		// Loop on the multiple files
		for(int i=0;i<num;i++)
        {
			// Individual source file
			source=src.section('\n',i);

			// An empty file name corresponds to the ".." file (why?)
			// Don't perform any file operation on it! 
			if (source!="")
			{
            	if(command=="copy")
				{
					f->copy(source,target);
				
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,MBOX_OK,_("Error"),_("Copy file operation cancelled!"));
						break;
					}
				}
            	else if(command=="move")
            	{
					f->move(source,target);
				
					// If action is cancelled in progress dialog
					if (f->isCancelled)
					{
						f->hide();
						MessageBox::error(this,MBOX_OK,_("Error"),_("Move file operation cancelled!"));
						break;
					}
           	 	}
            	else
                	exit(-1);
			}
		}
		
		getApp()->endWaitCursor();		
		delete f;
	}	

	// Force panel refresh
	lpanel->current->onRefresh(0,0,0);
    return 1;
}
