static xfdir_t bookshelf_xfdir;

static
xfdir_t *
private_get_xfdir(	record_entry_t *en){
  	glob_t dirlist;
	int j,count=1;
	int i;
    	gchar *bm_dir;
	gchar *p,*g;
	gchar *globstring;

	bm_dir = g_build_filename(xdg_cache_dir(),BOOKMARK_DIR,NULL);

	if (!g_file_test(bm_dir,G_FILE_TEST_EXISTS)){
	    if(mkdir(bm_dir, 0770) < 0)  {
		g_warning("cannot create %s",bm_dir);
		return NULL;
	    }
	}
	
	globstring = g_strconcat(bm_dir,G_DIR_SEPARATOR_S,"*.bm.dbh",NULL);
	dirlist.gl_pathc=0;

	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0 || !dirlist.gl_pathc)
       	{
	   TRACE("%s: no match", globstring);
	} else {
	   TRACE("Files found=%d",dirlist.gl_pathc);
	   
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if (!g) continue;
	      if(!strstr(g,".bm.dbh")) {
		  TRACE("%s is not named",g);
		  g_free(g);
		  continue;
	      }
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      g_free(g);
	      count++;
	   }
	}

	bookshelf_xfdir.gl = (dir_t *) malloc(count * sizeof(dir_t));
	bookshelf_xfdir.pathc=count;
	/* default bookmark file: */
	j=0;
	g=g_build_filename(bm_dir,"bookmarks.dbh",NULL);
	TRACE("Adding default bookmark file=%s",g);
	bookshelf_xfdir.gl[j].pathv=g_strdup(_("Default book"));
	bookshelf_xfdir.gl[j].en = mk_entry(0);
	bookshelf_xfdir.gl[j].en->path = g_strdup(g);
	bookshelf_xfdir.gl[j].en->tag = g_strdup(g);
	bookshelf_xfdir.gl[j].en->module = SUBMODULE_NAME;

	/* this flag enables the treeview expander: */
	SET_XF_NODE(bookshelf_xfdir.gl[j].en->type);

	SET_SHOWS_IMAGES(bookshelf_xfdir.gl[j].en->type);
	SET_SHOWS_HIDDEN(bookshelf_xfdir.gl[j].en->type);
	g_free(g);
	/* named bookmark files: */
	j=1;
	for (i = 0; i < dirlist.gl_pathc; i++){
	    g=g_path_get_basename(dirlist.gl_pathv[i]);
	    if (!g) continue;
	    if(!strstr(g,".bm.dbh")){
		  g_free(g);
		  continue;
	    }
	    p=strstr(g,".bm.dbh");
	    *p=0;
            TRACE ("glob match: %s", g);
	    bookshelf_xfdir.gl[j].pathv=g;
	    bookshelf_xfdir.gl[j].en = mk_entry(0);
	    bookshelf_xfdir.gl[j].en->path = g_strdup(g);
	    bookshelf_xfdir.gl[j].en->tag = g_strdup(my_utf_string(g));
	    bookshelf_xfdir.gl[j].en->module = SUBMODULE_NAME;
	
	    /* this flag enables the treeview expander: */
	    SET_XF_NODE(bookshelf_xfdir.gl[j].en->type);

	    SET_SHOWS_IMAGES(bookshelf_xfdir.gl[j].en->type);
	    SET_SHOWS_HIDDEN(bookshelf_xfdir.gl[j].en->type);
	    j++;
	}
  	globfree (&dirlist);
	g_free(bm_dir);
	g_free(globstring);
              
	TRACE ("bookshelf_xfdir.pathc: %d", bookshelf_xfdir.pathc);
	return &bookshelf_xfdir;

}


