/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

/* how to change desktop color? DESKTOP_COLOR=color xffm-deskview
 * or define environment variable DESKTOP_COLOR */

typedef struct deskview_geometry_t {
    int x;
    int y;
}deskview_geometry_t;
G_MODULE_EXPORT

static
void 
save_deskview_geometry(const gchar *fullpath, int x, int y){
    DBHashTable *preferences;
    GString *gs;
    gchar *f;
    deskview_geometry_t deskview_geometry;
    gchar *path;

    
    if (!fullpath || !strlen(fullpath)) return;
    path=g_path_get_basename(fullpath);

    f=g_build_filename(xdg_cache_dir(),DESKVIEW_GEOMETRY_DBH_FILE,NULL);
    
    preferences = DBH_open(f);
    if (!preferences) preferences = DBH_create(f, 11);

    g_free(f);
    if (!preferences) return;
    
    gs = g_string_new(path);	
    sprintf((char *)DBH_KEY(preferences), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);

    deskview_geometry.x=x;
    deskview_geometry.y=y;
    	    
    memcpy(DBH_DATA(preferences),&deskview_geometry,  sizeof(deskview_geometry_t));
    DBH_set_recordsize(preferences, sizeof(deskview_geometry_t));
    
    if (!DBH_update(preferences))	{
	g_warning("!DBH_update(deskview_geometry preferences)");
    }
    DBH_close(preferences);
    TRACE("saved deskview_geometry preferences with key=%s\n",path);
    g_free(path);
    return;
}

static
deskview_geometry_t *
get_deskview_geometry_p(const gchar *fullpath){
    DBHashTable *geometry;
    GString *gs;
    static deskview_geometry_t deskview_geometry;
    gchar *f;
    gchar *path;

    if (!fullpath || !strlen(fullpath)) return NULL;
    path=g_path_get_basename(fullpath);

    f=g_build_filename(xdg_cache_dir(),DESKVIEW_GEOMETRY_DBH_FILE,NULL);
    
    TRACE("looking for geometry with key=%s",path);
    
    geometry = DBH_open(f);
    g_free(f);
    
    if(!geometry){
	TRACE("no deskview geometry file");
	return NULL;
    }
        
    gs = g_string_new(path);	
    sprintf((char *)DBH_KEY(geometry), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    
    
    if(!DBH_load(geometry)) {
	TRACE("no deskview_geometry record for %s (%s)", path, (char *)DBH_KEY(geometry));
	DBH_close(geometry);
	return NULL;
    }
    memcpy(&deskview_geometry, DBH_DATA(geometry), sizeof(deskview_geometry_t));
    TRACE("got geometry with key=%s  position=%d,%d\n",
	    path,deskview_geometry.x,deskview_geometry.y);
    DBH_close(geometry);
    g_free(path);
    return &deskview_geometry;
}

/*********************************************************************/
/**************   deskview_t functions  ******************************/
static 
void 
select_pen(		desk_view_t *desk_view_p,
			int p)
{
  static gchar *desktop_color=NULL;
  static GdkColor *user_bg_color=NULL;
  static int offset=7;
  
  static GdkColor pen_colors[]={
/* light background */
      {0,65535,65535,65535}, 	/*white*/
      {1,0,0,0}, 		/*black*/
      {2,65535,0,0}, 		/*red*/
      {3,0,30000,0}, 		/*green*/
      {4,0,0,65535}, 		/*blue*/
      {5,32000,32000,0}, 	/*brown*/
      {6,65535,0,65535}, 	/*magenta*/
/* dark background */
      {1,0,0,0}, 		/*black*/
      {0,65535,65535,65535}, 	/*white*/
      {12,65535,20000,20000}, 		/*red*/
      {13,20000,60000,20000}, 		/*green*/
      {14,40000,40000,65535}, 		/*blue*/
      {15,32000,32000,0}, 	/*brown*/
      {16,65535,0,65535}, 	/*magenta*/
  };
  
  if (p < 0 ||  p > 6) {
      g_error("pen %d out of range.",p);
  }
  if (!desk_view_p->cmap) {
    int i;
    desk_view_p->cmap = gdk_drawable_get_colormap (desk_view_p->paper->window);
    if (getenv("DESKTOP_COLOR") && strlen(getenv("DESKTOP_COLOR"))){
      XColor db_def, hw_def;
      desktop_color=g_strdup(getenv("DESKTOP_COLOR"));
      user_bg_color = NULL;
      if (!XAllocNamedColor(GDK_DISPLAY(),
		GDK_COLORMAP_XCOLORMAP(desk_view_p->cmap),
		getenv("DESKTOP_COLOR"),&db_def, &hw_def)){
	    g_warning("Cannot allocate color %s",getenv("DESKTOP_COLOR"));
	    offset=0;
      } 
      else {
        user_bg_color = (GdkColor *)malloc(sizeof(GdkColor));
	user_bg_color->red = db_def.red * 0xff - 1;
	user_bg_color->green = db_def.green * 0xff - 1;
	user_bg_color->blue = db_def.blue * 0xff - 1;
	user_bg_color->pixel = db_def.pixel;
        if ((int)(db_def.red)+db_def.green+db_def.blue >=384) offset=0;
        else offset=7; 
     }
    }
    for (i=0; i<7*2; i++){
	if (!gdk_colormap_alloc_color(desk_view_p->cmap,pen_colors+i,TRUE,TRUE)) 
	    g_error ("couldn't allocate color");
    }

    desk_view_p->penGC = gdk_gc_new (desk_view_p->paper->window);
    gdk_gc_set_colormap (desk_view_p->penGC,desk_view_p->cmap);
  }

  if (getenv("DESKTOP_COLOR") && strlen(getenv("DESKTOP_COLOR")) ){
      if (!desktop_color || strcmp(desktop_color,getenv("DESKTOP_COLOR")))
      {
	  XColor db_def, hw_def;
	  g_free(desktop_color);
	  g_free(user_bg_color);
	  user_bg_color=NULL;
	  desktop_color=g_strdup(getenv("DESKTOP_COLOR"));
	  if (!XAllocNamedColor(GDK_DISPLAY(),
		GDK_COLORMAP_XCOLORMAP(desk_view_p->cmap),
		getenv("DESKTOP_COLOR"),&db_def, &hw_def)){
	    offset=0;
	    g_warning("Cannot allocate color %s",getenv("DESKTOP_COLOR"));
	  } else {
	    user_bg_color = (GdkColor *)malloc(sizeof(GdkColor));
            user_bg_color->red = db_def.red * 0xff - 1;
            user_bg_color->green = db_def.green * 0xff - 1;
            user_bg_color->blue = db_def.blue * 0xff - 1;
            user_bg_color->pixel = db_def.pixel;
	    if ((int)(db_def.red)+db_def.green+db_def.blue >=384) offset=0;
	    else offset=7; 
	  }
	  TRACE("offset now is %d",offset);
     } 
      
  }
  
  if (p == BACKGROUND_COLOR && user_bg_color) {
    gdk_gc_set_foreground (desk_view_p->penGC, user_bg_color);    
  } else gdk_gc_set_foreground (desk_view_p->penGC, pen_colors+p+offset);	
}


static 
void 
clean_rectangle(	desk_view_t *desk_view_p,
			int x, 
			int y, 
			int w, 
			int h)
{
    select_pen(desk_view_p,BACKGROUND_COLOR); 
    
    if (desk_view_p->root_pxm == None) {
	desk_view_p->root_pxm=mb_util_get_root_pixmap(GDK_DISPLAY());
    }
     

    if (desk_view_p->root_pxm != None) {
	TRACE("copy area %d %d",w,h);
	
       XCopyArea(	GDK_DISPLAY(), 
		desk_view_p->root_pxm, 
		GDK_PIXMAP_XID(desk_view_p->pixmap), 
		GDK_GC_XGC(desk_view_p->penGC), 
		x,y, w,h, x,y);

    } 
    else {
	TRACE("rectangle %d %d",w,h);
	gdk_draw_rectangle (desk_view_p->pixmap, desk_view_p->penGC, TRUE, x, y, w, h);
	gtk_widget_queue_draw_area (desk_view_p->paper, x, y, w, h);
	
    }
  
}

static
void 
clean_paper(		desk_view_t *desk_view_p)
{
    if (!desk_view_p->paper) g_error("desk_view_p->paper==NULL");
    if (desk_view_p->pixmap) {
	g_object_unref(G_OBJECT(desk_view_p->pixmap));
    }
    desk_view_p->pixmap = gdk_pixmap_new (desk_view_p->paper->window, 
		desk_view_p->paper->allocation.width+2*ICON_SIZE, 
		desk_view_p->paper->allocation.height+2*ICON_SIZE, -1);
    
    if (!desk_view_p->pixmap ){
	g_warning("pixmap is null!");
	return;
    }
    select_pen(desk_view_p,BACKGROUND_COLOR);




    clean_rectangle(desk_view_p, 0, 0, 
	    desk_view_p->paper->allocation.width, 
	    desk_view_p->paper->allocation.height);
    /*if (desk_view_p->root_pxm == None) {
	gint root_w, root_h, root_d;	
	gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,&root_d);	
	desk_view_p->root_pxm = XCreatePixmap(GDK_DISPLAY(), GDK_ROOT_WINDOW(),
		root_w,root_h,root_d);
        XCopyArea(	GDK_DISPLAY(), 
		GDK_PIXMAP_XID(desk_view_p->pixmap), 
		desk_view_p->root_pxm, 
		GDK_GC_XGC(desk_view_p->penGC), 
		0,0,root_w,root_h,0,0);
	TRACE("setting pixmap to 0x%x", desk_view_p->root_pxm);
	mb_util_set_root_pixmap(GDK_DISPLAY(),  desk_view_p->root_pxm, True);

    }*/
    
    gtk_widget_queue_draw_area (desk_view_p->paper, 0, 0, 
	    desk_view_p->paper->allocation.width, 
	    desk_view_p->paper->allocation.height);
}


static 
void
privy_redraw_text (	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p){
    int x,y;
    x=desk_population_p->x;
    y=desk_population_p->y + desk_population_p->h;
    gdk_draw_layout(desk_view_p->pixmap, desk_view_p->penGC, x,y, desk_population_p->layout);
    gtk_widget_queue_draw_area (desk_view_p->paper,
				x, 
				y, 
				desk_population_p->logical_rect.width,
				desk_population_p->logical_rect.height);
}
static 
void
privy_redraw_text_outline (	desk_view_t *desk_view_p,
				desk_population_t *desk_population_p){
    int x,y,lowX,lowY,i,j;
    x=desk_population_p->x;
    y=desk_population_p->y + desk_population_p->h;
    lowX=((x-1 < 0)?0:x-1); lowY=((y-1 < 0)?0:y-1);
    /*lowX=x; lowY=y;*/
    for (i=lowX; i<=x+1; i++) for (j=lowY; j<=y+1; j++) {
	if (i==x && j==y) continue;
	gdk_draw_layout(desk_view_p->pixmap, desk_view_p->penGC, i, j, desk_population_p->layout);
    }
    gtk_widget_queue_draw_area (desk_view_p->paper,
				lowX, 
				lowY, 
				desk_population_p->logical_rect.width+1,
				desk_population_p->logical_rect.height+1);
}


static 
void
erase_text (		desk_view_t *desk_view_p,
			desk_population_t *desk_population_p){
    int lowX,lowY;
    lowX=((desk_population_p->x-1 < 0)?0:desk_population_p->x-1);
    lowY=((desk_population_p->y-1 < 0)?0:desk_population_p->y-1);

    clean_rectangle(desk_view_p,
	    lowX,
	    lowY + desk_population_p->h,
	    desk_population_p->logical_rect.width+2,
	    desk_population_p->logical_rect.height+2);
}

static 
void
redraw_text (		desk_view_t *desk_view_p,
			desk_population_t *desk_population_p,
			int color)
{
    erase_text(desk_view_p,desk_population_p);
    select_pen(desk_view_p,BACKGROUND_COLOR);
    privy_redraw_text_outline(desk_view_p,desk_population_p);
    select_pen(desk_view_p,color);
    privy_redraw_text(desk_view_p,desk_population_p);
}


static
void 
unsaturate(		desk_view_t *desk_view_p)
{
    gdouble x,y;
    if (!desk_view_p->saturated) return;

    if (desk_view_p->saturated->selected) {
	desk_view_p->saturated=NULL;
	return;
    }
    x=desk_view_p->saturated->x;
    y=desk_view_p->saturated->y;
    desk_view_p->offset_x=desk_view_p->offset_y=0;
    TRACE("unsaturating");
    redraw_pixbuf(desk_view_p,desk_view_p->saturated, x, y);
    redraw_text(desk_view_p,desk_view_p->saturated,TEXT_COLOR);
    desk_view_p->saturated=NULL;
}

static void
make_layout(desk_view_t *desk_view_p,
			desk_population_t *desk_population_p,
			const gchar *tag){
    if (!tag) tag="";
    desk_population_p->layout = gtk_widget_create_pango_layout(desk_view_p->paper, tag);
    
    pango_layout_get_pixel_extents(desk_population_p->layout, NULL, &(desk_population_p->logical_rect));
    
    /* ++ because zero is actually unity, not nonexistance */
    (desk_population_p->logical_rect.width)++;
    (desk_population_p->logical_rect.height)++;
}

static 
void
insert_layout(		desk_view_t *desk_view_p,
			desk_population_t *desk_population_p) 
{
    if (!desk_view_p || !desk_population_p){
	g_warning("function parameter is null");
	return;
    }
    redraw_text (desk_view_p,desk_population_p,TEXT_COLOR);       	
}			

static 
void
insert_pixbuf(		desk_view_t *desk_view_p,
			desk_population_t *desk_population_p)
{
  
    gdk_draw_pixbuf ((GdkDrawable *)desk_view_p->pixmap,
                         desk_view_p->penGC,
                         desk_population_p->pixbuf,
                         0,0, /* src */
			 desk_population_p->x,
			 desk_population_p->y, /* dest */
			 desk_population_p->w,
			 desk_population_p->h,
                         GDK_RGB_DITHER_NONE,0,0);
    gtk_widget_queue_draw_area (desk_view_p->paper,
				desk_population_p->x, 
				desk_population_p->y, 
				desk_population_p->w,
				desk_population_p->h);
    return;
}


static 
void 
privy_redraw_pixbuf(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p, 
			GdkPixbuf *pixbuf, 
			gdouble x, 
			gdouble y)
{
    int X,Y;
    int iconW, iconH;
   
    if (!pixbuf) return;
    iconH = gdk_pixbuf_get_height(pixbuf);
    iconW = gdk_pixbuf_get_width(pixbuf);
    X = x - desk_view_p->offset_x;
    Y = y - desk_view_p->offset_y;
    
    if (X < 0) X=0;
    if (Y < 0) Y=0;
    if (X+iconW >= desk_view_p->paper->allocation.width) X=desk_view_p->paper->allocation.width-iconW-1;
    if (Y+iconH >= desk_view_p->paper->allocation.height) Y=desk_view_p->paper->allocation.height-iconH-1;


    
    if (X + desk_population_p->w < 0 || Y + desk_population_p->h < 0){
	TRACE("X + desk_population_p->w < 0 || Y + desk_population_p->h < 0");
	return;
    }
    if (X - desk_population_p->w > desk_view_p->paper->allocation.width || 
	Y - desk_population_p->w > desk_view_p->paper->allocation.height) {
	TRACE("X - desk_population_p->w > paper->allocation.width || Y - desk_population_p->w > paper->allocation.height");
	return;
    }
    
    TRACE("redraw business...");
    
    desk_population_p->x=X;
    desk_population_p->y=Y;

    {
	GdkPixbuf *pb = gdk_pixbuf_get_from_drawable (NULL,
		desk_view_p->pixmap,
		desk_view_p->cmap,
		X,Y,0,0,iconW,iconH);
	GdkBitmap *mask_return;
	GdkPixmap *sandbox;

	gdk_pixbuf_render_pixmap_and_mask_for_colormap (pb, 
		desk_view_p->cmap, 
		&sandbox, NULL, 128);
	
	gdk_pixbuf_render_pixmap_and_mask_for_colormap (pixbuf, 
		desk_view_p->cmap, 
		NULL, &mask_return, 128);
	
	gdk_gc_set_clip_mask   (desk_view_p->penGC,mask_return);

	gdk_draw_pixbuf ((GdkDrawable *)sandbox,
                         desk_view_p->penGC,
                         pixbuf,
                         0,0, /* src */
			 0,0, /* dest */
			 iconW,iconH,
                         GDK_RGB_DITHER_NONE,0,0);
	gdk_gc_set_clip_mask   (desk_view_p->penGC,NULL);
	gdk_draw_drawable ((GdkDrawable *)desk_view_p->pixmap,
                         desk_view_p->penGC,
			 (GdkDrawable *)sandbox,
			 0,0,
			 desk_population_p->x,
			 desk_population_p->y, /* dest */
			 desk_population_p->w,
			 desk_population_p->h);
	g_object_unref(G_OBJECT(sandbox));
	g_object_unref(G_OBJECT(pb));
	if (mask_return) g_object_unref(G_OBJECT(mask_return));
    }
    
    
    gtk_widget_queue_draw_area (desk_view_p->paper, 
	    desk_population_p->x, 
	    desk_population_p->y, 
	    desk_population_p->w,
	    desk_population_p->h);

    /**/
}

static 
void 
redraw_background(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p)
{
    GList *tmp;
    // XXX: should use background instead of cleaning (for custom background, like desktop)
    clean_rectangle(desk_view_p,
	    desk_population_p->x,
	    desk_population_p->y,
	    desk_population_p->w,
	    desk_population_p->h);
    for (tmp=desk_view_p->population_list; tmp && (void *)desk_population_p != tmp->data; tmp=tmp->next){
	desk_population_t *p = (desk_population_t *)tmp->data;
	/*TRACE("... %s",p->path);*/
	if (p->x > desk_population_p->x + ICON_SIZE + desk_population_p->logical_rect.width
		|| p->x +ICON_SIZE + p->logical_rect.width < desk_population_p->x 
		|| p->y > desk_population_p->y + ICON_SIZE + desk_population_p->logical_rect.height
		|| p->y +ICON_SIZE + p->logical_rect.height<  desk_population_p->y );
	else {
		int o_x=desk_view_p->offset_x, o_y=desk_view_p->offset_y;
		desk_view_p->offset_x = desk_view_p->offset_y = 0;
		/*TRACE("will redraw ... %s",p->path);*/
		redraw_pixbuf(desk_view_p, p, p->x, p->y);
		redraw_text(desk_view_p, p,TEXT_COLOR);
		desk_view_p->offset_x=o_x, desk_view_p->offset_y=o_y;
	} 
    }
}
static 
void 
redraw_pixbuf(		desk_view_t *desk_view_p,
			desk_population_t *desk_population_p,
			gdouble x, 
			gdouble y)
{
    if (!desk_population_p) {
	g_warning("!desk_population_p");
	return;
    }
    privy_redraw_pixbuf(desk_view_p, desk_population_p, desk_population_p->pixbuf, x, y);
}
static 
void 
saturate_pixbuf(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p, 
			gdouble x, 
			gdouble y)
{
    if (!desk_population_p) {
	g_warning("!desk_population_p");
	return;
    }

    if (!desk_population_p->saturated){
	desk_population_p->saturated = gdk_pixbuf_copy (desk_population_p->pixbuf);
	gdk_pixbuf_saturate_and_pixelate(desk_population_p->saturated,desk_population_p->saturated,8.0,FALSE);

    }
    if (desk_view_p->dnd_pixmap) {
	    g_object_unref(desk_view_p->dnd_pixmap);
	    if (desk_view_p->dnd_mask)g_object_unref(desk_view_p->dnd_mask);
	    desk_view_p->dnd_pixmap=NULL;
	    desk_view_p->dnd_mask=NULL;
	    TRACE("unref dnd_pixmap (now null)");
    }
    TRACE("setting dnd_pixmap");
    gdk_pixbuf_render_pixmap_and_mask(desk_population_p->pixbuf,&(desk_view_p->dnd_pixmap),&(desk_view_p->dnd_mask),1);
	
    privy_redraw_pixbuf(desk_view_p,desk_population_p, desk_population_p->saturated, x, y);
}

static
GdkPixbuf *mk_select_pixbuf(desk_population_t *desk_population_p){
    if (!desk_population_p->selected_pixbuf){
	desk_population_p->selected_pixbuf = gdk_pixbuf_copy (desk_population_p->pixbuf);
	gdk_pixbuf_saturate_and_pixelate(desk_population_p->selected_pixbuf,desk_population_p->selected_pixbuf,-8.0,TRUE);
    }
    return desk_population_p->selected_pixbuf;
}

void 
select_pixbuf(	desk_view_t *desk_view_p,
			desk_population_t *desk_population_p, 
			gdouble x, 
			gdouble y)
{
    if (!desk_population_p) {
	g_warning("!desk_population_p");
	return;
    }

    desk_population_p->selected_pixbuf = mk_select_pixbuf(desk_population_p);


    privy_redraw_pixbuf(desk_view_p,desk_population_p, desk_population_p->selected_pixbuf, x, y);

}

static 
void select_desk_population_p (desk_view_t *desk_view_p, desk_population_t *desk_population_p){
    if (!desk_population_p) return;
    desk_population_p->selected=TRUE;
    desk_population_p->selected_pixbuf = mk_select_pixbuf(desk_population_p);
}

/*
static 
void unselect_desk_population_p (desk_population_t *desk_population_p){
    if (!desk_population_p) {
	return;
    }
    desk_population_p->selected=FALSE;
}
*/

