/***********************************************************************************/
static 
void
remove_item(	desk_view_t *desk_view_p)
{
    record_entry_t *en=desk_view_p->selection_list->data;
    /* for local remove: */
    if (IS_BROKEN_LNK(en->type) || g_file_test(en->path,G_FILE_TEST_EXISTS))	
    {
	showit(desk_view_p->widgets.window, "remove_menuitem");
    }
}

static 
void
properties_item(	desk_view_t *desk_view_p)
{
    record_entry_t *en=desk_view_p->selection_list->data;
    if (IS_BROKEN_LNK(en->type) || g_file_test(en->path,G_FILE_TEST_EXISTS) )	
    {
	showit(desk_view_p->widgets.window, "properties2");
    }
}

static 
void
print_item(		desk_view_t *desk_view_p)
{
    record_entry_t *en=desk_view_p->selection_list->data;
    if (g_file_test(en->path,G_FILE_TEST_EXISTS)&&
        !g_file_test(en->path,G_FILE_TEST_IS_DIR)&&
	g_list_length(desk_view_p->selection_list)==1)	
    {
	showit(desk_view_p->widgets.window, "print_menuitem");
    }
}



static 
void
refresh_item(	desk_view_t *desk_view_p)
{
    showit(desk_view_p->widgets.window, "refresh3");
    showit(desk_view_p->widgets.window, "arrange_menuitem");
    showit(desk_view_p->widgets.window, "goto_menuitem");
    if (g_slist_length(go_list) > 0 )
	    showit(desk_view_p->widgets.window, "goback_menuitem");

    showit(desk_view_p->widgets.window, "opentreeview");
    showit(desk_view_p->widgets.window, "openiconview");
    showit(desk_view_p->widgets.window, "iv_separator00");
	showit(desk_view_p->widgets.window, "newfile_menuitem"); 
	showit(desk_view_p->widgets.window, "newdirectory_menuitem"); 
    showit(desk_view_p->widgets.window, "iv_separator0");

    showit(desk_view_p->widgets.window, "terminal2");
    showit(desk_view_p->widgets.window, "run2");
    showit(desk_view_p->widgets.window, "find2");
    showit(desk_view_p->widgets.window, "differences2");
    showit(desk_view_p->widgets.window, "xfmime-edit2");
    showit(desk_view_p->widgets.window, "iv_separator1");

    showit(desk_view_p->widgets.window, "about2");
#ifdef HAVE_LIBXFCE4MCS_CLIENT
    showit(desk_view_p->widgets.window, "settings2");
#endif
}


static 
void
open_item(	desk_view_t *desk_view_p)
{
    record_entry_t *en=desk_view_p->selection_list->data;
    if (g_file_test(en->path,G_FILE_TEST_EXISTS)){
	showit(desk_view_p->widgets.window, "open_with_menuitem"); 
        showit(desk_view_p->widgets.window, "iv_separator0");
    }
}

static 
void
mount_item(	desk_view_t *desk_view_p){
    record_entry_t *en=desk_view_p->selection_list->data;
    if (function_void("plugins","xffm_fstab","is_root_module")) {
	 int mounted=GPOINTER_TO_INT(FSTAB_is_mounted(en->path));
	 TRACE("%s is mounted=%d",en->path,mounted);
	 if (IS_DIR(en->type) && FSTAB_is_in_fstab(en->path))
	 {
	  if (mounted>=0){
	      if (mounted) showit(desk_view_p->widgets.window, "unmountP");
	      else showit(desk_view_p->widgets.window, "mountP");
	  } else {
	      if (IS_MOUNTED(en->type)) showit(desk_view_p->widgets.window, "unmountP");
	      else showit(desk_view_p->widgets.window, "mountP");
	  }
	 }
	 else if (mounted){
	    showit(desk_view_p->widgets.window, "unmountP");
	 }
    }
}


/***********************************************************************************/


static
GtkWidget * 
common_mk_popup_menu (	widgets_t *widgets_p, 
			GtkWidget *parent,
			GtkAccelGroup *accel_group,
			void *data)
{
  /*GtkAccelGroup *accel_group;*/
  GtkWidget *w;
  GtkWidget *item22_menu;
  /*desk_view_t *desk_view_p=(desk_view_t *)data;*/
  

#ifdef USE_ACCEL_LABELS
  if (!accel_group) {
    accel_group = gtk_accel_group_new ();
    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
  }
#endif
  
  item22_menu=gui_mk_menu(
	  widgets_p,
	  "item22", /* label */
	  "item22",   /* name */
	  parent, 	  /* parent */
	  NULL,NULL); /* callback (or NULL)*/

  /* common menu items */
#if 0
    gui_add_menu_item(widgets_p, item22_menu,
		    _("Reload"),
		    "xffm/stock_refresh",
		    "refresh3",
		    (gpointer)deskview_refresh_activate,
		    data,
		    NULL,0,0);
#endif

   {
    gchar *string[11]={N_("Reload"),N_("Arrange icons"),N_("Go to"),N_("Go back"),N_("Open with ..."),"","",N_("Detailed view"),N_("Icon view"),NULL};
    gchar *iconfile[11]={"xffm/stock_refresh","xffm/stock_import","xffm/stock_jump-to","xffm/stock_go-back","xffm/stock_open","xffm/stock_run","xffm/stock_run","xffm-treeview","xffm-iconview",NULL};
    gchar *id[11]={"refresh3","arrange_menuitem","goto_menuitem","goback_menuitem","open_with_menuitem","autotype_R","autotype_Prun","opentreeview","openiconview",NULL};
    gpointer callback[11]={(gpointer)deskview_on_refresh,(gpointer)deskview_on_autoplace,(gpointer)on_goto_activate,(gpointer)on_goback_activate,(gpointer)on_open_with_activate,(gpointer)on_autotype_R,NULL,(gpointer)on_treeview_activate,(gpointer)on_iconview_activate,NULL};
    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    NULL,0,0);
    }
   }
   w=gui_add_menu_separator(item22_menu);
   GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator00");

   
    /* abstract menu items */
   {
    gchar *string[7]={N_("Cut"),N_("Copy"),N_("Paste"),N_("Paste link"),N_("Remove"),N_("Properties"),NULL};
    gchar *iconfile[7]={"xffm/stock_cut","xffm/stock_copy","xffm/stock_paste","xffm/stock_pastelink","xffm/stock_delete","xffm/stock_properties",NULL};
    gchar *id[7]={"cut_menuitem","copy_menuitem","paste_menuitem","pastelink_menuitem","remove_menuitem","properties2",NULL};
    gpointer callback[7]={NULL,NULL,NULL,NULL,(gpointer)deskview_remove_activate,(gpointer)deskview_on_prop_activate,NULL};
//    gpointer callback[7]={(gpointer)gridview_cut_activate,(gpointer)gridview_copy_activate,(gpointer)gridview_paste_activate,(gpointer)gridview_pastelink_activate,(gpointer)deskview_remove_activate,(gpointer)deskview_on_prop_activate,NULL};

    int i;

    for (i=0; string[i]; i++){
 	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    NULL,0,0);
    }
   }
   
   {
    gchar *string[6]={N_("Print"),N_("Mount"),N_("Unmount"),N_("New file"),N_("New directory"),NULL};
    gchar *iconfile[6]={"xffm/stock_print","xffm/stock_yes","xffm/stock_no","xffm/stock_new-tab","xffm/stock_new-dir",NULL};
    gchar *id[6]={"print_menuitem","mountP","unmountP","newfile_menuitem","newdirectory_menuitem",NULL};
    gpointer callback[6]={(gpointer)deskview_print_activate,NULL,NULL,(gpointer)on_newfile_activate,(gpointer)on_newdir_activate,NULL};
    int i;

    for (i=0; string[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    NULL,0,0);
    }
  }
 
 
  /* execution group of menuitems */
  
    w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator0");

  {
    gchar *string[6]={N_("Terminal"),N_("Run"),N_("Find"),N_("Differences"),N_("Customize icons"),NULL};
    gchar *iconfile[6]={"xffm/stock_terminal","xffm/stock_run","xffm/stock_search","xfdiff-icon","xfmime-edit-icon",NULL};
    gchar *id[6]={"terminal2","run2","find2","differences2","xfmime-edit2",NULL};
    gpointer callback[6]={(gpointer)deskview_open_in_terminal_activate,(gpointer)deskview_run_activate,(gpointer)deskview_glob_activate,(gpointer)deskview_differences_activate,(gpointer)deskview_xfmime_edit_activate,NULL};
    int i;

    for (i=0; string[i]; i++){
	gui_add_menu_item(widgets_p,item22_menu,
		    _(string[i]),
		    iconfile[i],
		    id[i],
		    callback[i],
		    data,
		    NULL,0, 0);
    }
  }
    
    w=gui_add_menu_separator(item22_menu);
    GLADE_HOOKUP_OBJECT (widgets_p->window, w, "iv_separator1");
    
    
    gui_add_menu_item(widgets_p,item22_menu,
		    _("Global Configuration"),
		    "xffm/stock_preferences",
		    "settings2",
		    (gpointer)on_settings_show,
		    widgets_p,
		    accel_group, GDK_c, GDK_MOD1_MASK);

    
   
    gui_add_menu_item(widgets_p,item22_menu,
		    _("About"),
		    "xffm/stock_about",
		    "about2",
		    (gpointer)gui_on_about_activate,
		    data,
		    NULL,0,0);
    


  GLADE_HOOKUP_OBJECT (widgets_p->window, item22_menu, "item22_menu");
  return item22_menu;

}

