#define FILEMANAGER "xffm-iconview"
#define FILEMANAGER_OPTIONS "--no-desktop"
static void *run_process;
static gchar *deskdir = NULL;

typedef struct extra_key_t {
    GtkWidget *check1;
    GtkEntry *entry;
    gboolean interm;
    gboolean hold;
    const gchar *response;
} extra_key_t;

static void
activate_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_YES);
}
static void
cancel_entry(GtkEntry *entry, gpointer data){
    gtk_dialog_response  ((GtkDialog *)data,GTK_RESPONSE_CANCEL);
}


static
void warn(gchar *text){

    g_warning(text);
#if 0
    GtkWidget *label,*dialog;

    gtk_init(NULL,NULL);
    
    dialog=gtk_dialog_new();
    gtk_window_set_title (GTK_WINDOW (dialog), "xffm-run");
    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

    if (label) label=gtk_label_new(text);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox),label, FALSE, FALSE, 0);
    
    gtk_dialog_add_button ((GtkDialog *)dialog,_("Ok"),0);
    gtk_widget_show_all(dialog);
    gtk_dialog_run((GtkDialog *)dialog);
    gtk_widget_hide(dialog);
    while (gtk_events_pending())gtk_main_iteration();
#endif
    exit(0);
}

static
void 
save_flags(	extra_key_t *extra_key_p)
{
    DBHashTable *runflags;
    GString *gs;
    int *flags;
    gchar *g=g_build_filename(xdg_cache_dir(),RUN_FLAG_FILE,NULL);

    
    if((runflags = DBH_open(g)) == NULL)
    {
	if((runflags = DBH_create(g, 11)) == NULL){
	    g_warning("Cannot create %s\n",g);
	    g_free(g);
	    return;
	}
    }
    gs = g_string_new(extra_key_p->response);
    sprintf((char *)DBH_KEY(runflags), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    /*printf("TRACE: bookmarking with key=%s\n",d_path);*/
    flags = (int *)runflags->data;
    flags[0]=extra_key_p->interm;
    flags[1]=extra_key_p->hold;
    DBH_set_recordsize(runflags, 2*sizeof(int));
    
    DBH_update(runflags);
    DBH_close(runflags);
    TRACE("flags saved in dbh file  %s\n",g);
	    
    g_free(g);
    g=g_build_filename(xdg_cache_dir(),RUN_DBH_FILE,NULL);
    COMBO_save_to_history(g,(char *)(extra_key_p->response));
    g_free(g);
}


static
void
recover_flags(	extra_key_t *extra_key_p)
{
    DBHashTable *runflags;
    GString *gs;
    int *flags;
    gchar *g=g_build_filename(xdg_cache_dir(),RUN_FLAG_FILE,NULL);

    if((runflags = DBH_open(g)) == NULL)
    {
	    TRACE("Cannot open %s\n",g);
	    extra_key_p->interm=0;
	    extra_key_p->hold=0;
	    return;
    }
    gs = g_string_new(extra_key_p->response);
    sprintf((char *)DBH_KEY(runflags), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    /*printf("TRACE: bookmarking with key=%s\n",d_path);*/
    flags = (int *)runflags->data;
    DBH_load(runflags);
    extra_key_p->interm = flags[0];
    extra_key_p->hold = flags[1];
    DBH_close(runflags);

    TRACE("flags recovered from dbh file for %s, interm=%d hold=%d\n",extra_key_p->response,extra_key_p->interm,extra_key_p->hold);
}

static
int extra_key_completionR (gpointer data)
{
	extra_key_t *extra_key_p=(extra_key_t *)data;
	
	if (!extra_key_p){
	    g_warning("!extra_key_p");
	    return FALSE;
	}
	if (!GTK_IS_ENTRY (extra_key_p->entry)) return FALSE;
    	extra_key_p->response = gtk_entry_get_text(extra_key_p->entry);

	recover_flags(extra_key_p);
        gtk_toggle_button_set_active ((GtkToggleButton *)extra_key_p->check1,extra_key_p->interm);	
	return FALSE;
}



static
const extra_key_t *
get_response_history(		const gchar *label_txt,
				gchar *history_file,
				const gchar *path,
				gboolean internal){
    static extra_key_t extra_key;
    int response = GTK_RESPONSE_NONE;
    GtkWidget *hbox,*label,*button,*dialog ;
    GtkCombo *combo=NULL;
    xfc_combo_info_t *combo_info=NULL;
    xfc_combo_functions *xfc_fun=NULL;

    memset(&extra_key,0,sizeof(extra_key_t));
    

    dialog = gtk_dialog_new();

    gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
    gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
    gtk_container_set_border_width(GTK_CONTAINER (dialog), 6);

	
    if (label_txt) label=gtk_label_new(label_txt);
    else label=gtk_label_new(_("Input requested"));
    
    
    combo=(GtkCombo *)gtk_combo_new();

    hbox=gtk_hbox_new(FALSE, 6);
    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), (GtkWidget *)combo, TRUE, TRUE, 0); 
    
    xfc_fun=load_xfc();  
    
    if (combo_info==NULL){
	combo_info = COMBO_init_combo(combo);
    } else {
	COMBO_clear_history(combo_info);
    }
    
    combo_info->activate_func = activate_entry;
    combo_info->activate_user_data=dialog;
    combo_info->cancel_func = cancel_entry;
    combo_info->cancel_user_data=dialog;
     
    xfc_fun->extra_key_completion = extra_key_completionR;
    xfc_fun->extra_key_data = &extra_key;    
    
    COMBO_set_combo(combo_info,NULL);

    COMBO_read_history(combo_info,history_file);

    if (path) {
	const gchar *p=MIME_command(path);
    	if (p) combo_info->list = g_list_prepend(combo_info->list,g_strdup(p) );
    }
    COMBO_set_combo(combo_info,NULL);
    
    extra_key.response = NULL;
	    	    
    extra_key.check1 = (GtkWidget *) gtk_check_button_new_with_mnemonic(_("In terminal"));
    extra_key.entry = combo_info->entry;
    

    gtk_box_pack_start (GTK_BOX ((GTK_DIALOG (dialog))->action_area), GTK_WIDGET(extra_key.check1), FALSE, FALSE, 0);
    
    
    button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_from_stock (GTK_STOCK_OK);

    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);



    gtk_widget_realize(dialog);
    extra_key_completionR(&extra_key);

    
    if (internal) gdk_window_set_decorations (dialog->window,GDK_DECOR_ALL);
    else gdk_window_set_decorations (dialog->window,GDK_DECOR_BORDER);

    gdk_flush();
    gtk_widget_show_all (dialog); 
    
    /* show dialog and return */
    response = gtk_dialog_run (GTK_DIALOG (dialog));
    extra_key.interm=FALSE;
    if (gtk_toggle_button_get_active ((GtkToggleButton *)extra_key.check1)){
	extra_key.interm=TRUE;
    }	
    gtk_widget_hide (dialog);
    if (response == GTK_RESPONSE_YES){
	const gchar *et=COMBO_get_entry(combo_info);
	TRACE("et=%s",et);
	if (et && strlen(et)){
		  extra_key.response=g_strdup(et);      
	}		      
    } else {
	gtk_widget_destroy (dialog);
	return NULL;
    }
    gtk_widget_destroy (dialog);
    return (const extra_key_t *)(&extra_key);
}

/******   end run lib *****/

static
void
wait_till_kaput(widgets_t *widgets_p){
    do {
	  while(gtk_events_pending())gtk_main_iteration();
	  /*sleep(1);printf(".");fflush(NULL);*/
	  usleep(500);	
    } while (!g_object_get_data(G_OBJECT(widgets_p->diagnostics_window),"concluded"));
    TRACE("exiting kaput cycle");
    if (GTK_WIDGET_VISIBLE(widgets_p->diagnostics_window)){
	  TRACE("Process has finished");
	  print_diagnostics(widgets_p,"xffm/stock_no",_("Process has finished"),"\n",NULL);
	  gtk_main();
    } else {
	  TRACE("Process manager is now exiting");
	  exit(0);
    }
}


int deskview_runit(widgets_t *widgets_p, int argc, gchar **argv, gboolean internal){
      gchar *f=g_build_filename(xdg_cache_dir(),RUN_DBH_FILE,NULL); 
      gchar *q;
      GError *error=NULL;
      int argcp;
      gchar **argvp;
      extra_key_t *extra_key_p;
      const gchar *path=((argc)?argv[0]:NULL);

    TRACE("deskview_runit now..."); 
    if (path) extra_key_p=(extra_key_t *)get_response_history(_("Open with"),f,path,internal);
    else extra_key_p=(extra_key_t *)get_response_history(_("Run"),f,path,internal);

    g_free(f);

    if (!internal) {
	if (!extra_key_p) exit(1);
	if (!extra_key_p->response || !strlen(extra_key_p->response)) exit(1);
    } else {
	if (!extra_key_p) return FALSE;
	if (!extra_key_p->response || !strlen(extra_key_p->response)) return FALSE;
    }
	save_flags(extra_key_p);
     
    TRACE("response is %s, interm is %d",extra_key_p->response,extra_key_p->interm);
    if (g_file_test(extra_key_p->response,G_FILE_TEST_IS_DIR)){
	  if (extra_key_p->interm) {
	      const gchar *term=xffm_what_term();
	      chdir(extra_key_p->response);
	      if (internal && fork()) {
		    usleep(500);
		    while(gtk_events_pending())gtk_main_iteration();
		    return TRUE;
	      }

	      execlp(term, term, NULL);
	      g_warning("cannot execute %s",term);
	  } else {
		int j=0;
		char *n_argv[4];
		n_argv[4]=n_argv[3]=NULL;
		n_argv[j++]=FILEMANAGER;
#ifdef FILEMANAGER_OPTIONS
		n_argv[j++]=FILEMANAGER_OPTIONS;
#endif
		n_argv[j++]=(char *)extra_key_p->response;
		n_argv[j++]=NULL;
		TRACE("1.opening filemanager %s",n_argv[0]);
		if (internal && fork()) {
		    usleep(500);
		    while(gtk_events_pending())gtk_main_iteration();
		    return TRUE;
		}
		execvp(n_argv[0],n_argv);
		g_warning("cannot execute %s",n_argv[0]);
		/*run_process=xffm_runvwd(widgets_p,deskdir,n_argv);*/
	  }
	  _exit(123);
    }

    if (extra_key_p->interm){
	const gchar *the_terminal=xffm_what_term();
	const gchar *exec_flag="-e";
	const gchar *hold_flag="";
	TRACE("the terminal=%s",the_terminal);
	if (strstr(the_terminal,"gnome-terminal") 	|| 
		strstr(the_terminal,"gnome2-terminal")	||
		strstr(the_terminal,"Terminal")	||
		strstr(the_terminal,"terminal")	||
		strstr(the_terminal,"xterminal") ) exec_flag="-x";
	if (extra_key_p->hold) hold_flag="-hold";
	
		
	if (path)
	    q = g_strdup_printf("%s %s %s %s \"%s\"",the_terminal, hold_flag, exec_flag,extra_key_p->response, path);
	else 
	    q = g_strdup_printf("%s %s %s %s",the_terminal, hold_flag, exec_flag,extra_key_p->response);

	TRACE("in term command line is=%s",q);
	g_shell_parse_argv (q, &argcp,&argvp,&error);
	if (error){
	    warn(error->message);
	    g_error_free(error);
	    return FALSE;
	}
	g_free(q);
	if (internal && fork()) {
	    usleep(500);
	    while(gtk_events_pending())gtk_main_iteration();
	    return TRUE;
	}

	execvp(argvp[0],argvp);
	_exit(123);
	    
    } 
    else {
	if (path){
	    q=g_strdup_printf("%s %s \"%s\"",(internal?"xffm-run":""),extra_key_p->response,path);
	}
	else {
	    q=g_strdup_printf("%s %s",(internal?"xffm-run":""),extra_key_p->response);
	}
    }	

      
      g_shell_parse_argv (q, &argcp,&argvp,&error);
      TRACE("gui-run command line is=%s",q);
      if (error){
        warn(error->message);
	g_error_free(error);
	return FALSE;
      }
      g_free(q);
      if (internal) {
	  TRACE("internal handling");
	  if (fork()){
	      TRACE("forked %s",argvp[0]);
	      execvp(argvp[0],argvp);
	      _exit(123);
	  }
	  else {
	      usleep(500);
	      while(gtk_events_pending())gtk_main_iteration();
	      g_strfreev (argvp);
	      return TRUE;
	  }
      } else {
	run_process=xffm_runvwd(widgets_p,deskdir,(const gchar **)argvp);
	TRACE("going to wait_till_kaput");
	wait_till_kaput(widgets_p);
	exit(0);
      }
      /* should save program and flags */
}


void run_command(widgets_t *widgets_p, int argc, const gchar *argv[]){
    /* check for file existance, first try absolute, then relative
     * and last but not least, relative to homedir */
	char *p=NULL,*exec_path;
	const gchar *prg;
	int exists=0;
	gchar *path=g_strdup(argv[0]);
	int is_absolute=(path[0]=='/');
	
	g_free(deskdir);
	deskdir = g_get_current_dir();  
	/*deskdir = g_build_filename(g_get_home_dir(),"Desktop",NULL);
	if (!g_file_test(deskdir,G_FILE_TEST_EXISTS)){
	    if (mkdir(deskdir, 0777) < 0) deskdir = g_strdup(g_get_home_dir());
	}*/

	/* first, find executable in path */
	exec_path=g_find_program_in_path(path);
	if (exec_path) {
	    run_process=xffm_runvwd(widgets_p,deskdir,argv);
	    wait_till_kaput(widgets_p);
	    exit(0);
	}
	g_free(exec_path);

	if (g_file_test(path,G_FILE_TEST_EXISTS)) exists=1;
	if (!exists && !is_absolute){
	    gchar *p=g_build_filename(g_get_home_dir(),path,NULL);
	    g_free(path);
	    path=p;
	    argv[0] = (const gchar *)p;
	    if (g_file_test(path,G_FILE_TEST_EXISTS)) exists=1;
	}
	 
	if (!exists) {
	    warn(g_strdup_printf(_("%s does not exist"), *(argv)));
	    g_free(path);
	    return;
	}
	if (g_file_test(path,G_FILE_TEST_IS_DIR)) {
	    int j=0;
	    char *n_argv[4];
	    TRACE("2.opening filemanager %s",FILEMANAGER);
	    n_argv[j++]=FILEMANAGER;
#ifdef FILEMANAGER_OPTIONS
	    n_argv[j++]=FILEMANAGER_OPTIONS;
#endif
	    n_argv[j++]=(char *)argv[0];
	    n_argv[j++]=NULL;
	    execvp(n_argv[0],n_argv);
	    g_free(path);
	    exit(0);
	}
	
	    
	/* does it have an associated mimetype application? */
	p=path;
	prg=NULL;
	while (p && !prg){
	    if ((prg = MIME_command (p)) != NULL) break;
	    p=strchr(p+1,'.');
	}
	TRACE("prg=%s",((prg)?prg:"null"));
	if (prg) {
		GError *error=NULL;
		int argcp;
		char **argvp;
	 	const gchar *g;
	 	gchar *arguments = (gchar *)argv[0];
		TRACE("arguments=%s",arguments);
		
	 	g=MIME_mk_command_line(prg,arguments,FALSE,FALSE);
		TRACE("command line=%s",g);
		
		if (!is_absolute) {
		    g_free(deskdir);
		    deskdir=g_get_current_dir();
		}
		if (g_shell_parse_argv(g,&argcp,&argvp,&error)){
		    run_process=xffm_runvwd(widgets_p,deskdir,(const gchar **)argvp);
		    wait_till_kaput(widgets_p);
		    g_free(path);
		    exit(0);
		    /*g_strfreev(argvp); let this hang around until exit */
		} else {
		    warn(error->message);
		    g_error_free(error);
		}    
	}
	//broken:
	/* only if no mime association: */
	deskview_runit(widgets_p, argc, (gchar **)argv,FALSE);
	g_free(path);
	return;
}
    
    

static 
int
deskview_run(){
    desk_view_t *desk_view_p = create_deskview_p();
    GtkWidget *dialog = xffm_create_diagnostics_window(&(desk_view_p->widgets));

    if (xffm_details->argc==1) {
	deskview_runit(&(desk_view_p->widgets), 0, xffm_details->argv+1,FALSE);
	exit(0);
    }
   
    run_command(&(desk_view_p->widgets),xffm_details->argc - 1, (const gchar **)(xffm_details->argv+1)); 
    gtk_widget_realize(dialog);
    /*gtk_widget_show_all(dialog);*/
	    
    gtk_main();
    TRACE("deskview_run is terminating now.");
    exit(1);
}

