/* Copyright 2005-6 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*
 * must think about what is necessary and what not, to keep
 * the application fast and light. No duplication of ways to do
 * things. Only one way will be present. That means, either a toolbar
 * or a menu. 
 * */

#define GRIDVIEW_C

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gridview.h"
#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
SessionClient *session_client;
#endif

/* static headers */
static void
done_with_rename (	gpointer data);
void 
mk_text_entry(		icon_view_t *icon_view_p, 
			population_t *population_p, 
			int caso);
static population_t *
find_in_labels(		icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y);
static population_t *
create_population_t(	icon_view_t *icon_view_p,
			record_entry_t *en,
			int element,
			const gchar *icon_id,
			const gchar *label);
static void
destroy_population(	icon_view_t *icon_view_p);
static population_t *
find_in_population(	icon_view_t *icon_view_p,
			gdouble x, 
			gdouble y);
static void
init_icon_view(		icon_view_t *icon_view_p, 
			record_entry_t *en);
static void
init_grid(		icon_view_t *icon_view_p, 
			int pathc, 
			xfdir_t *xfdir_p);
static void
enter_drag_state(	icon_view_t *icon_view_p);
static void
setup_drag_state(	icon_view_t *icon_view_p,
			GdkEventButton *event,
			int x, 
			int y, 
			int drag_button);
static void 
saturate_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p);
static void 
unsaturate_pixbuf(	icon_view_t *icon_view_p);
static void 
select_pixbuf(		icon_view_t *icon_view_p,
			population_t *population_p);
static void 
unselect_pixbuf(	icon_view_t *icon_view_p,
			population_t *population_p);
static void 
unselect_all_pixbuf(	icon_view_t *icon_view_p);

static void
process_double_click(	icon_view_t *icon_view_p,
			population_t *population_p, 
			gboolean control);
static void 
select_pen(		icon_view_t *icon_view_p,
			int p);
/*#define CLUES*/
#ifdef CLUES
#define CLUE(x) x
/* size debugging: */
static void
show_clues(icon_view_t *icon_view_p,gchar *string);
#else
#define CLUE(x)
#endif
/****************************************************************/
/* private symbols */

#if 0
#ifdef DBG
#undef DBG
#endif
#define DBG 
#endif

static GList *iconview_list=NULL;
static GList *widgets_p_list=NULL;
gboolean gridview_atomic=FALSE;

#include "gridview-graphics.i"
#include "gridview-callbacks.i"
#include "gridview-roots.i"
#include "gridview-population.i"
#include "gridview-monitor.i"
#include "gridview-main.i"

/* public symbols (listed in gridview_lib.h) */
G_MODULE_EXPORT
GtkWidget *create_gridview(void)
{
    icon_view_t *icon_view_p=NULL;
    int type=__LOCAL_TYPE|__ROOT_TYPE;
    record_entry_t *en=NULL;
    gchar *exec=g_path_get_basename(xffm_details->argv[0]);
        
    if (exec && strcmp(exec,"xffm") && strcmp(exec,"xffm-iconview")){
        const gchar *path=xffm_details->argv[1];
	if (!path) path="/";
	GSList *plugin_list = find_root_plugins();
	en=mk_entry(type);
	en->path=g_strdup(path);
	for(; plugin_list; plugin_list=plugin_list->next)
	{
	    const gchar *exec_name=(const gchar *)function_void("plugins",plugin_list->data,"exec_name");
	    if (exec_name && strcmp(exec_name,xffm_details->argv[0])==0) {
		en->module=function_void("plugins",plugin_list->data,"module_name");
		if (function_natural("plugins",en->module,en,"module_path")) en->path=g_strdup(function_natural("plugins",en->module,en,"module_path"));
		else if (function_natural("plugins",en->module,en,"module_label")) en->path=g_strdup(function_natural("plugins",en->module,en,"module_label"));
		TRACE("%s is in module %s",exec_name,en->module);
		goto load;
	    }
	}
	g_warning("There is no plugin with exec_name = %s",xffm_details->argv[0]);
	g_free(exec);
	exit(0);
    }
    g_free(exec);

    if (xffm_details->argc == 2){
	gchar *path=NULL;
	en=mk_entry(type);
	if (!g_file_test(xffm_details->argv[1],G_FILE_TEST_IS_DIR)) {
	    path=g_build_filename(g_get_home_dir(),xffm_details->argv[1],NULL);
	    if (!g_file_test(path,G_FILE_TEST_IS_DIR)) {
		g_warning("%s is not a directory",path);
		g_free(path);
		exit(0);
	    }
	}
	else if (g_path_is_absolute(xffm_details->argv[1])) {
	    path=g_strdup(xffm_details->argv[1]);
	} else {
	    gchar *wd=g_get_current_dir();
	    path=g_build_filename(wd,xffm_details->argv[1],NULL);
	    g_free(wd);
	} 
	en=stat_entry((const gchar *)path,type);
	g_free(path);
	
    } else if (xffm_details->argc >= 3){
	en=mk_entry(type);
	en->path=g_strdup(xffm_details->argv[1]);
	if (function_void("plugins",xffm_details->argv[2],"is_root_module")){
		TRACE("%s is_root_module",xffm_details->argv[2]);
		en->module=xffm_details->argv[2];    
	} else {
		en->module=function_natural("plugins",xffm_details->argv[2],NULL,"parent_module_name");
		TRACE("%s is parent_module_name for %s",(en->module?en->module:"null"),xffm_details->argv[2]);
	    
	}
	
	if (!en->module) {
	    	g_warning("There is no %s plugin",xffm_details->argv[2]);
		exit(0);
	}

    }
load:
    icon_view_p=create_iconview(en);
    xffm_details->widgets_p_list_p = &widgets_p_list;
    if (en) icon_view_p->module_name=en->module;
    TRACE("module=%s",icon_view_p->module_name);
    reload_iconview(icon_view_p,en,TRUE);
    gridview_monitor(NULL);
    if (!icon_view_p) return NULL;
    return icon_view_p->widgets.window;
}

G_MODULE_EXPORT
int select_all_iconview(icon_view_t *icon_view_p){
    population_t **population_pp;
    int items=0;
    if (!icon_view_p || !icon_view_p->en) return items;
    ATOMIC_CHECK return items;
ATOMIC_ON
    cursor_wait(icon_view_p->widgets.window);
    population_pp = icon_view_p->population_pp;
    for (;population_pp && *population_pp; population_pp++){
	if ((*population_pp)->en == NULL) continue;
	if (IS_DUMMY_TYPE((*population_pp)->en->type)) continue;
	items++;
	TRACE("selected item %d",items);
	saturate_pixbuf(icon_view_p,*population_pp);
	select_pixbuf(icon_view_p,*population_pp);	
    }
    icon_view_p->saturated_p=NULL;
    graphics_expose_all(icon_view_p);
    cursor_reset(icon_view_p->widgets.window);
ATOMIC_OFF
    return items;
}

G_MODULE_EXPORT
void unselect_all_iconview(icon_view_t *icon_view_p){
    ATOMIC_CHECK return;
ATOMIC_ON
    cursor_wait(icon_view_p->widgets.window);
    unselect_all_pixbuf(icon_view_p);	
    unsaturate_pixbuf(icon_view_p);
    graphics_expose_all(icon_view_p);
    cursor_reset(icon_view_p->widgets.window);
ATOMIC_OFF
}

G_MODULE_EXPORT
int select_byfilter_iconview(icon_view_t *icon_view_p, const gchar *select_filter){
    population_t **population_pp;
    const regex_t *preg;
    gchar *g;
    int items=0;
    if (!icon_view_p || !icon_view_p->en) return items;
    if (!select_filter || !strlen(select_filter)) return items;
    ATOMIC_CHECK return items;
ATOMIC_ON
    cursor_wait(icon_view_p->widgets.window);
    preg = compile_regex_filter(select_filter,SHOWS_HIDDEN(icon_view_p->en->type));   
    unselect_all_pixbuf(icon_view_p);	
    unsaturate_pixbuf(icon_view_p);
    population_pp = icon_view_p->population_pp;
    for (;population_pp && *population_pp; population_pp++){
	gchar *f;
	if ((*population_pp)->en == NULL) continue;
	if ((*population_pp)->en->path == NULL) continue;
	if (IS_DUMMY_TYPE((*population_pp)->en->type)) continue;
	f=g_path_get_basename((*population_pp)->en->path);
	TRACE("regexec %s => %s",select_filter,f);
	if (regexec(preg, f, 0, NULL, 0)) {
	    g_free(f);
	    continue;
	}
	g_free(f);
	items++;
	saturate_pixbuf(icon_view_p,*population_pp);
	select_pixbuf(icon_view_p,*population_pp);
    }   
    cursor_reset(icon_view_p->widgets.window);
    g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d item selected","%d items selected",items), items);
    print_status(&(icon_view_p->widgets),"xffm/info",g,NULL);
    g_free(g);
ATOMIC_OFF
    return items;
}


G_MODULE_EXPORT
void push_iconview_go_history(icon_view_t *icon_view_p){
    record_entry_t *history_en;
    /*if (!icon_view_p->en || !icon_view_p->en->path) return;*/
    if (icon_view_p->go_list) {
	GList *last=g_list_last(icon_view_p->go_list);
	record_entry_t *last_en;	
	last_en=last->data;
	if (!last_en && !icon_view_p->en) return; /* NULL case */
	if (last_en && icon_view_p->en){
	    if (!last_en->path && !icon_view_p->en->path) return;
	    if (last_en->path && icon_view_p->en->path){
		if (strcmp(last_en->path,icon_view_p->en->path)==0) return;
	    }
	}
    }
    history_en=copy_entry(icon_view_p->en);
    icon_view_p->go_list = g_list_append(icon_view_p->go_list,history_en);
    return;
}

G_MODULE_EXPORT
void pop_iconview_go_history(icon_view_t *icon_view_p){
    GList *last;
    if (!icon_view_p->go_list) return;
    last=g_list_last(icon_view_p->go_list);
    if (!last) {
	g_list_free(icon_view_p->go_list);
	icon_view_p->go_list=NULL;
	return;
    }
    icon_view_p->go_list=g_list_remove(icon_view_p->go_list,last->data);
    if (!g_list_length(icon_view_p->go_list)){
	g_list_free(icon_view_p->go_list);
	icon_view_p->go_list=NULL;
	return;
    }
    return;
}

G_MODULE_EXPORT
int
gridview_set_icon(icon_view_t *icon_view_p, record_entry_t *en){
    int i;
    for (i=0; i<icon_view_p->max_elements && icon_view_p->population_pp[i]; i++)
    {
	population_t *population_p=icon_view_p->population_pp[i];
	if (en && population_p->en == en){
	    if (population_p->normal_pixbuf)
		g_object_unref(G_OBJECT(population_p->normal_pixbuf)); 
	    if (population_p->selected_pixbuf)
		g_object_unref(G_OBJECT(population_p->selected_pixbuf)); 
	    population_p->pixbuf = population_p->normal_pixbuf = get_icon (&(icon_view_p->widgets),population_p->en,icon_view_p->en);
	    if (population_p->normal_pixbuf){
		population_p->selected_pixbuf = gdk_pixbuf_copy (population_p->normal_pixbuf);

		gdk_pixbuf_saturate_and_pixelate(population_p->selected_pixbuf,population_p->selected_pixbuf,-8.0,TRUE); 
		population_p->pixbufW=gdk_pixbuf_get_width((const GdkPixbuf *)population_p->normal_pixbuf);
		population_p->pixbufH=gdk_pixbuf_get_height((const GdkPixbuf *)population_p->normal_pixbuf);
	    } else {
		population_p->pixbufW=ICON_SIZE;
		population_p->pixbufH=ICON_SIZE;
	    }

	    graphics_expose_item(icon_view_p,
		    (icon_view_p->population_pp[i])->row,
		    (icon_view_p->population_pp[i])->column);
	    TRACE("%s : %s (%d,%d) type=0x%x",((IS_CUT(en->type))?"CUT":"UNCUT"),en->path,
		    (icon_view_p->population_pp[i])->row,
		    (icon_view_p->population_pp[i])->column,
		    (icon_view_p->population_pp[i])->en->type);
	    return 1;
	}
    }
    return 0;
}

#ifdef CLUES
static void
show_clues(icon_view_t *icon_view_p,gchar *string){
	GtkAdjustment *a=gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window);

    CLUE(printf("------------%s:\nadj: lower=%.1lf,upper=%.1lf,size=%.1lf,increment=%.1lf,step_increment=%.1lf,value=%.1lf\npaper size=(%d,%d), allocation=(%d,%d)\nrows=%d (%d), columns=%d (%d), area=%d\n",
	    string,
	    a->lower,a->upper,a->page_size,a->page_increment,a->step_increment,a->value,
	    icon_view_p->paperX,
	    icon_view_p->paperY,
	    icon_view_p->paper->allocation.width,
	    icon_view_p->paper->allocation.height,
	    icon_view_p->grid_rows,icon_view_p->grid_rows*CELLHEIGHT,
	    icon_view_p->grid_columns,icon_view_p->grid_columns*CELLWIDTH,
	    icon_view_p->grid_area
	    );)

}
#endif

G_MODULE_EXPORT 
int
reload_iconview(icon_view_t *icon_view_p, record_entry_t *en, gboolean replace){
    GSList *t,*reselect_list=NULL;
    GList *tmp;
/* this entry (old_en==icon_view_p->en) may be used by plugins to 
 * create up element, but plugins should copy_entry to malloc memory itself
 * This entry goes down the drain...*/
    record_entry_t *old_en=NULL;
    xfdir_t *xfdir_p=NULL;
    time_t inicio = time(NULL);
    ATOMIC_CHECK return FALSE;
ATOMIC_ON    

    TRACE("reload_iconview...");
    cursor_wait(icon_view_p->widgets.window);
    /*show_clues(icon_view_p,"entering reload_iconview");*/
	    
    
#ifdef DO_THE_STATUS_READING_THING
    print_status(&(icon_view_p->widgets),"xffm/info",_("Reading..."),NULL);
    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();
#endif
    
    for (tmp=icon_view_p->selection_list; tmp; tmp=tmp->next){
	record_entry_t *en=(record_entry_t *)tmp->data;
	if (en && en->path)
	    reselect_list=g_slist_append(reselect_list,g_strdup(en->path));
    }
    /*destroy_entry(icon_view_p->en);*/
    old_en=icon_view_p->en;
    icon_view_p->en=NULL;
    
    destroy_population(icon_view_p);

    if (en) {
	iconview_preferences_t *iconview_preferences_p=get_iconview_preferences(en->path);
	if (iconview_preferences_p){
	    icon_view_p->preferences=iconview_preferences_p->preferences;
	    icon_view_p->sortcolumn=iconview_preferences_p->sortcolumn;
	}

	if (icon_view_p->preferences & __SHOW_HIDDEN) SET_SHOWS_HIDDEN(en->type);
	else UNSET_SHOWS_HIDDEN(en->type);
	if (icon_view_p->preferences & __SHOW_IMAGES) SET_SHOWS_IMAGES(en->type);
	else UNSET_SHOWS_IMAGES(en->type);
	if (en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)) SET_DIR(en->type);
    }

     if (icon_view_p->module_name) {
	const gchar *icon=function_natural("plugins",icon_view_p->module_name,NULL,"module_icon_id");
	if (en && en->path){
	    print_status(&(icon_view_p->widgets),icon,en->path,NULL);
	} else {
	    const gchar *label=function_natural("plugins",icon_view_p->module_name,en,"module_label");
	    print_status(&(icon_view_p->widgets),icon,label,NULL);
	}
    } 

    if (!en || !icon_view_p->module_name) {
	icon_view_p->submodule_name=NULL;
	if (!en) {
	    TRACE("call to add_icon_roots");
	    add_icon_roots(icon_view_p);
	    goto end;
	}
	xfdir_p=local_xfdir(icon_view_p,en);

    } else {
	TRACE("obtaining xfdir_p from module %s",icon_view_p->module_name);
	xfdir_p=module_xfdir(&(icon_view_p->widgets),icon_view_p->module_name,en);
	TRACE("xfdir_p obtained!");
	icon_view_p->submodule_name=function_void("plugins",icon_view_p->module_name,"submodule_name");
    }
    /* By this point we have loaded the xfdir structure. */
    if (xfdir_p && xfdir_p->pathc >= 512){
	set_progress_full(&(icon_view_p->widgets),-1, -1);
    }

    init_icon_view(icon_view_p, en);
    init_grid(icon_view_p, 0,xfdir_p);
    set_iconview_title(icon_view_p);
    
    restore_iconview_size(icon_view_p);
    	    
    if (!xfdir_p) {
	if (icon_view_p->module_name && function_void("plugins",icon_view_p->module_name,"empty_text")) {
	    print_status(&(icon_view_p->widgets),"xffm/warning",function_void("plugins",icon_view_p->module_name,"empty_text"),NULL);
	} else {
	    print_status(&(icon_view_p->widgets),"xffm/warning",_("Nothing found"),NULL);
	}
    } else {
	TRACE("do quicksort here: sortcolumn is %d",icon_view_p->sortcolumn);
	TRACE("xfdir_p=0x%x,pathc is %d",(unsigned)xfdir_p, xfdir_p->pathc);
	/*print_status(&(icon_view_p->widgets),"xffm/info",_("Sorting..."),NULL);
	while (gtk_events_pending()) gtk_main_iteration();
	gdk_flush();*/
	set_ascending(icon_view_p->preferences & SORT_ASCENDING);
	set_sort_column(icon_view_p->sortcolumn);
	/* qsort may race gtk internals, flushing seems to prevent this...(hack) */
	fflush(NULL);
	qsort((void *)xfdir_p->gl, 
		xfdir_p->pathc, sizeof(dir_t), 
#ifdef __COMPAR_FN_T
		(__compar_fn_t)
#endif
		xfdir_compare);
    }
    if (xfdir_p && xfdir_p->pathc >= 512){
        set_progress_full(&(icon_view_p->widgets),-1, -1);
    }


    
    /* old_en is used in this function to construct the "up" element
     * by querying plugins. */
    if (!load_xfdir_icons(icon_view_p, xfdir_p, reselect_list, old_en)){
	/* load fails */
	xfdirfree(xfdir_p);
	if (old_en) destroy_entry(old_en);
	for (t=reselect_list; t; t=t->next){g_free(t->data);}
	if (reselect_list) g_slist_free(reselect_list);
	goto done;
    }
    
    xfdirfree(xfdir_p);
    if (!icon_view_p->module_name) {
	if (en && en->tag){  
	    const gchar *icon=NULL;
	    if (en->path && g_file_test(en->path,G_FILE_TEST_IS_DIR)){
		icon="xffm/open_folder";
	    }
	    else {
		icon=resolve_icon_id(en);
	    }
	    print_status(&(icon_view_p->widgets),icon,en->tag,NULL);
	} else if (en && en->path){
	    gchar *buf=g_strdup(_("No files"));
	    gchar *base=g_path_get_basename(en->path);
	    print_status(&(icon_view_p->widgets),"xffm/open_folder",base," (",buf,")",NULL);
	    g_free(base);
	    g_free(buf);
	} else {
	    print_status(&(icon_view_p->widgets),NULL,"fixme:reload_icons()",NULL);
	}
    }
   


end:
    set_progress_generic(&(icon_view_p->widgets),-1, -1, -1);
    if (icon_view_p->en) icon_view_p->en->load_time = time(NULL) - inicio;
    TRACE("paper size=(%d,%d), allocation=(%d,%d)",
	    icon_view_p->paperX,
	    icon_view_p->paperY,
	    icon_view_p->paper->allocation.width,
	    icon_view_p->paper->allocation.height);
    for (t=reselect_list; t; t=t->next){g_free(t->data);}
    if (reselect_list) g_slist_free(reselect_list);

    cursor_reset(icon_view_p->widgets.window);
    gdk_flush();
    while (gtk_events_pending()){
	gtk_main_iteration();
    }
    gdk_flush();
    graphics_set_default_tooltip(icon_view_p,NULL);
    
    destroy_entry(old_en);	
    TRACE("reload is done");
done:
ATOMIC_OFF
    return TRUE;   
}

G_MODULE_EXPORT
void 
save_iconview_preferences(icon_view_t *icon_view_p){
    iconview_preferences_t iconview_preferences;
    DBHashTable *preferences;
    GString *gs;
    gchar *f;
    const gchar *key;
    if (!icon_view_p) return;

    if (!icon_view_p->en || !icon_view_p->en->path) key="ROOT_ICONVIEW";
    else key=icon_view_p->en->path;
    
    f=g_build_filename(xdg_cache_dir(),GRIDVIEW_PREFERENCES_DBH_FILE,NULL);
    
    preferences = DBH_open(f);
    if (!preferences) preferences = DBH_create(f, 11);

    g_free(f);
    if (!preferences) return;
    
    gs = g_string_new(key);	
    sprintf((char *)DBH_KEY(preferences), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);

    iconview_preferences.preferences=icon_view_p->preferences;
    iconview_preferences.sortcolumn=icon_view_p->sortcolumn;
	    
    memcpy(DBH_DATA(preferences),&iconview_preferences,  sizeof(iconview_preferences_t));
    DBH_set_recordsize(preferences, sizeof(iconview_preferences_t));
    
    if (!DBH_update(preferences))	{
	g_warning("!DBH_update(preferences)");
    }
    DBH_close(preferences);
    TRACE("saved preferences with key=%s\n",key);
    return;
}

G_MODULE_EXPORT
record_entry_t *gridview_get_selected_entry(widgets_t *widgets_p){
    icon_view_t *icon_view_p = (icon_view_t *)widgets_p->parent;
    if (!icon_view_p->selection_list) return NULL;
    return (record_entry_t *) icon_view_p->selection_list->data;
}

G_MODULE_EXPORT
record_entry_t *gridview_get_selected_parent_entry(widgets_t *widgets_p){
    icon_view_t *icon_view_p = (icon_view_t *)widgets_p->parent;
    return icon_view_p->en;
}

G_MODULE_EXPORT
icon_view_t *
create_iconview(	record_entry_t *en)
{
    icon_view_t *icon_view_p;
    iconview_geometry_t *iconview_geometry_p=NULL;
    GtkWidget *vbox1,*input_box;

    icon_view_p=(icon_view_t *)malloc(sizeof(icon_view_t));
    g_return_val_if_fail(icon_view_p!=NULL,NULL);
    /*g_object_ref(G_OBJECT(icon_view_p));*/
    memset(icon_view_p,0,sizeof(icon_view_t));
    widgets_p_list=g_list_append(widgets_p_list,&(icon_view_p->widgets));
    TRACE(">>>>>>>>>>>>>widgets_p=0x%x",(unsigned)&(icon_view_p->widgets));


    TRACE("icon_view_p initializations...");

    /* initializations: */
    icon_view_p->tips = gtk_tooltips_new ();
    icon_view_p->widgets.tooltips = gtk_tooltips_new ();

    icon_view_p->preferences=__SHOW_IMAGES;
    
    icon_view_p->go_list=NULL;
    icon_view_p->module_name=NULL;
    icon_view_p->submodule_name=NULL;
    icon_view_p->population_list=NULL;
    icon_view_p->selection_list=NULL;
    icon_view_p->penGC=NULL;    
    icon_view_p->cmap=NULL;
    icon_view_p->dragstate=FALSE;
    icon_view_p->vpane_ratio=-1;
    icon_view_p->popup=NULL;
    icon_view_p->widgets.combo_info=NULL;
    icon_view_p->sortcolumn=GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
    init_icon_view(icon_view_p, NULL);
    icon_view_p->widgets.type = ICONVIEW_TYPE;
    icon_view_p->widgets.parent = icon_view_p;
    icon_view_p->widgets.stop=FALSE;
    icon_view_p->widgets.tubo_object = NULL;

    icon_view_p->widgets.back_activate = gridview_back_activate;
    icon_view_p->widgets.refresh = gridview_refresh;
    icon_view_p->widgets.refresh_parent = gridview_refresh;
    icon_view_p->widgets.open_with = gridview_open_with;
    icon_view_p->widgets.get_selected_entry = gridview_get_selected_entry;
    icon_view_p->widgets.get_selected_parent_entry = gridview_get_selected_parent_entry;
    
    icon_view_p->widgets.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_gravity ((GtkWindow *)icon_view_p->widgets.window,GDK_GRAVITY_STATIC);
    {
      	GdkPixbuf *xffm_icon_pixbuf;
	TRACE("create application icon...");
 	xffm_icon_pixbuf = icon_tell (&(icon_view_p->widgets),REAL_BIG,"xffm-iconview");
  	if (xffm_icon_pixbuf)
    	{
      		gtk_window_set_icon (GTK_WINDOW (icon_view_p->widgets.window), 
				xffm_icon_pixbuf);
      		g_object_unref (G_OBJECT(xffm_icon_pixbuf));
   	}
	else g_warning("cannot create application icon");
	

	

	TRACE("call to get_iconview_geometry_p");
	iconview_geometry_p=get_iconview_geometry_p(icon_view_p);
	
	if (iconview_geometry_p) {
	    gtk_window_set_default_size ((GtkWindow *)icon_view_p->widgets.window, 
		iconview_geometry_p->w, 
		iconview_geometry_p->h);
	} else {
	    gtk_window_set_default_size ((GtkWindow *)icon_view_p->widgets.window, 440, 350);
	}
	
	gtk_window_set_resizable ((GtkWindow *)icon_view_p->widgets.window, TRUE);
	/*gtk_window_set_title (GTK_WINDOW (icon_view_p->widgets.window), OUR_HOST_NAME(&(icon_view_p->widgets.window)));*/
	    while (gtk_events_pending()) gtk_main_iteration();
	    gdk_flush();
    }
    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (icon_view_p->widgets.window), vbox1);

    input_box=gui_mk_input_box(&(icon_view_p->widgets),vbox1,icon_view_p);
    g_signal_connect ((gpointer) lookup_widget(icon_view_p->widgets.window,"input_ok"), 
	    "clicked",G_CALLBACK (gridview_input_ok), (gpointer)icon_view_p);

    gtk_widget_hide(input_box);

    icon_view_p->widgets.vpane = gtk_vpaned_new ();
    gtk_widget_show (icon_view_p->widgets.vpane);
    gtk_box_pack_start (GTK_BOX (vbox1), icon_view_p->widgets.vpane, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (icon_view_p->widgets.vpane), 1000);


    
    icon_view_p->paper = gtk_drawing_area_new ();
    gtk_widget_show (icon_view_p->paper);
    
    icon_view_p->scrolled_window=(GtkScrolledWindow *)gtk_scrolled_window_new (NULL,NULL);
    {
	gtk_scrolled_window_set_policy (icon_view_p->scrolled_window,GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_paned_pack1 (GTK_PANED (icon_view_p->widgets.vpane), GTK_WIDGET(icon_view_p->scrolled_window), FALSE, TRUE);
	gtk_widget_show (GTK_WIDGET(icon_view_p->scrolled_window));
        gtk_scrolled_window_add_with_viewport (icon_view_p->scrolled_window,icon_view_p->paper);
    }
   
    {
	icon_view_p->widgets.diagnostics=gtk_text_view_new();
	GtkWidget *scrolledwindow5=gtk_scrolled_window_new (NULL,NULL);
	gtk_widget_show (scrolledwindow5);
	gtk_widget_show (icon_view_p->widgets.diagnostics);
	gtk_paned_pack2 (GTK_PANED (icon_view_p->widgets.vpane), scrolledwindow5, TRUE, TRUE);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scrolledwindow5), icon_view_p->widgets.diagnostics);
	gtk_container_set_border_width (GTK_CONTAINER (icon_view_p->widgets.diagnostics), 2);
	GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.diagnostics, GTK_CAN_FOCUS);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (icon_view_p->widgets.diagnostics), GTK_WRAP_WORD);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (icon_view_p->widgets.diagnostics), FALSE);
    }

    icon_view_p->widgets.button_space = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (icon_view_p->widgets.button_space);
    gtk_box_pack_start (GTK_BOX (vbox1), icon_view_p->widgets.button_space, FALSE, FALSE, 0);    
    icon_view_p->widgets.progress = gtk_progress_bar_new ();
    gtk_box_pack_start (GTK_BOX (icon_view_p->widgets.button_space), icon_view_p->widgets.progress, FALSE, FALSE, 0);
    GLADE_HOOKUP_OBJECT (icon_view_p->widgets.window, icon_view_p->widgets.vpane, "vpaned1");
    GLADE_HOOKUP_OBJECT (icon_view_p->widgets.window, icon_view_p->widgets.progress, "progressbar1");
    /*gtk_widget_show (icon_view_p->widgets.progress);*/


    icon_view_p->widgets.status = gtk_text_view_new ();
    gtk_widget_show (icon_view_p->widgets.status);
    gtk_box_pack_start (GTK_BOX (icon_view_p->widgets.button_space), icon_view_p->widgets.status, TRUE, TRUE, 3);
    GTK_WIDGET_UNSET_FLAGS (icon_view_p->widgets.status, GTK_CAN_FOCUS);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (icon_view_p->widgets.status), FALSE);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (icon_view_p->widgets.status), FALSE);

    icon_view_p->widgets.stop_button = mk_little_button(
	    &(icon_view_p->widgets),
	    "xffm/stock_stop",
	    (void *) on_stop,
	    (void *) (&(icon_view_p->widgets)),
	    _("Stop the current operation"));
    gtk_box_pack_end (GTK_BOX (icon_view_p->widgets.button_space), icon_view_p->widgets.stop_button, FALSE, FALSE, 0);
    icon_view_p->widgets.clear_button = mk_little_button(
	    &(icon_view_p->widgets),
	    "xffm/stock_clear",
	    (void *) on_clear_text_window,
	    (void *) (&(icon_view_p->widgets)),
	    _("Clear text window")); 
    gtk_box_pack_end (GTK_BOX (icon_view_p->widgets.button_space), icon_view_p->widgets.clear_button, FALSE, FALSE, 0);
    gtk_widget_show (icon_view_p->widgets.clear_button);
    
 
    /* events */
    gtk_widget_add_events (icon_view_p->paper,
	  GDK_POINTER_MOTION_MASK|
	  GDK_BUTTON_MOTION_MASK|
	  GDK_BUTTON_PRESS_MASK|
	  GDK_BUTTON_RELEASE_MASK|
	  GDK_ENTER_NOTIFY_MASK|
	  GDK_LEAVE_NOTIFY_MASK|
	  GDK_EXPOSURE_MASK);
    

    g_signal_connect(G_OBJECT(gtk_scrolled_window_get_vadjustment(icon_view_p->scrolled_window)), "value-changed", G_CALLBACK(adjustment_changed), icon_view_p);
   
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "key-press-event", 
	    G_CALLBACK(keyboard_event), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "destroy_event", 
	    G_CALLBACK(destroy_event), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->widgets.window), "delete_event", 
	    G_CALLBACK(destroy_event), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), "expose-event", 
		  GTK_SIGNAL_FUNC (on_expose), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), 
	      "size-allocate", G_CALLBACK (on_size_paper), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->widgets.window), 
	      "size-allocate", G_CALLBACK (on_size_window), icon_view_p);
    /* pointer events */
    /*g_signal_connect (G_OBJECT (icon_view_p->scrolled_window), "check-resize", 
	    G_CALLBACK (on_check_resize), icon_view_p);  */ 
    g_signal_connect (G_OBJECT (icon_view_p->widgets.window), "configure-event", 
	    G_CALLBACK (on_configure_window), icon_view_p);      
    g_signal_connect (G_OBJECT (icon_view_p->paper), "configure-event", 
	    G_CALLBACK (on_configure_paper), icon_view_p);          
    g_signal_connect (G_OBJECT (icon_view_p->paper), "button-press-event",
		  GTK_SIGNAL_FUNC (on_button_press),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper), "button-release-event",
		  GTK_SIGNAL_FUNC (on_button_release), icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"enter-notify-event",
		  GTK_SIGNAL_FUNC (on_enter),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"leave-notify-event",
		  GTK_SIGNAL_FUNC (on_leave),icon_view_p);
    g_signal_connect (G_OBJECT (icon_view_p->paper),"motion-notify-event",
		  GTK_SIGNAL_FUNC (on_motion),icon_view_p);
  
  

    /* drag and drop events */
   
    if (!target_list) target_list = gtk_target_list_new (target_table,NUM_TARGETS);
  
    gtk_drag_source_set((GtkWidget *) icon_view_p->paper, 
	  GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
    gtk_drag_dest_set((GtkWidget *) icon_view_p->paper, 
	  GTK_DEST_DEFAULT_DROP , target_table, NUM_TARGETS, 
	  GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    g_object_set_data(G_OBJECT(icon_view_p->widgets.window),"icon_view_p",(gpointer)icon_view_p->paper);
    g_object_set_data(G_OBJECT(icon_view_p->paper),"icon_view_p",(gpointer)icon_view_p->paper);
    
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_received", 
	  G_CALLBACK(gridview_drag_data), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_get", 
	    G_CALLBACK(gridview_drag_data_get), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_motion", 
	    G_CALLBACK(gridview_drag_motion), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_end", 
	    G_CALLBACK(gridview_drag_end), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_begin", 
	    G_CALLBACK(gridview_drag_begin), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_leave",
	    G_CALLBACK(gridview_drag_leave), icon_view_p);
    g_signal_connect(G_OBJECT(icon_view_p->paper), "drag_data_delete",
	    G_CALLBACK(gridview_drag_delete), icon_view_p);

    
    {
	TRACE("hscrollbar=%d",icon_view_p->scrolled_window->hscrollbar->allocation.height);
	TRACE("vscrollbar=%d",icon_view_p->scrolled_window->vscrollbar->allocation.width);
    }
    gtk_widget_queue_draw (icon_view_p->paper);
    
    TRACE("iconview now flushing events...");

    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();
    
    /* now lets get the text height from pango */
    {
	PangoLayout *layout;
	PangoRectangle logical_rect;
	const gchar *tag="HECHO EN MEXICO";
	layout = gtk_widget_create_pango_layout(icon_view_p->paper, tag);
	pango_layout_get_pixel_extents(layout, NULL, &(logical_rect));
	CLUE(printf("logical_rect.height=%d\n",logical_rect.height);)
	icon_view_p->text_height=logical_rect.height;
	g_object_unref(layout);
    }

    iconview_list=g_list_append(iconview_list, icon_view_p);




    
    gtk_widget_show (icon_view_p->widgets.window);  
 /*   gtk_widget_realize (icon_view_p->widgets.window);  */
    
    while (gtk_events_pending()) gtk_main_iteration();
    gdk_flush();

    return icon_view_p;
}



