#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gridview.h"

extern gboolean gridview_atomic;

/******************** common menu configuration ******************************/

static void 
gridview_mk_module_popup_menu (	const gchar *module_name,
				icon_view_t *icon_view_p, 
				record_entry_t *en);
static void
gridview_autotype_C            (GtkMenuItem     *menuitem,
				gpointer         user_data);
static void 
gridview_mount (		GtkMenuItem *menuitem, 
				gpointer user_data);
static void gridview_unmount (	GtkMenuItem *menuitem, 
				gpointer user_data);

#include "gridview-menu.i"
#include "gridview_popup-callbacks.i"
#include "gridview_popup.i"

/************** shared symbols (not to be used by other than gridview_lib ****/

G_MODULE_EXPORT
GtkWidget * 
gridview_mk_popup_menu (	GtkWidget *parent,
				GtkAccelGroup *accel_group,
				icon_view_t *icon_view_p)
{
    return (common_mk_popup_menu(&(icon_view_p->widgets),parent,accel_group));
}


G_MODULE_EXPORT
void 
gridview_mk_module_popup_menu (	const gchar *module_name,
				icon_view_t *icon_view_p, 
				record_entry_t *en){
    const gchar *txt;
    if (!module_name) return;
    txt=function_natural("plugins",module_name,en,"module_label");
    
    /* set the submenu label */
    if (txt) {
        GtkWidget *label,*a=lookup_widget(icon_view_p->widgets.window,"module1");
        label = gtk_bin_get_child(GTK_BIN(a));
        gtk_label_set_text((GtkLabel *)label,my_utf_string(txt));
    }
    /* remove anything left over */
    gtk_container_foreach ((GtkContainer *)lookup_widget(icon_view_p->widgets.window,"module1_menu"), remove_menu_item,NULL);

    /* add new stuff to submenu */
    function_rational(	"plugins",
			module_name,
			(void *)(lookup_widget(icon_view_p->widgets.window,"module1_menu")),
			&(icon_view_p->widgets),
			"extend_popup");
    

}
G_MODULE_EXPORT
gint gridview_refresh(widgets_t *widgets_p)
{
    icon_view_t *icon_view_p=(icon_view_t *)widgets_p->parent;
    record_entry_t *en=copy_entry(icon_view_p->en);
    if (icon_view_p->en && icon_view_p->en->path) 
	unlink(get_local_cache_path(icon_view_p->en->path));
    return reload_iconview(icon_view_p,en,FALSE);
}
G_MODULE_EXPORT
void gridview_run_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    if (icon_view_p) gridview_show_input(RUN_INPUT,icon_view_p);
}

G_MODULE_EXPORT
void 
gridview_open_with(widgets_t *widgets_p, record_entry_t *en)	{
    icon_view_t *icon_view_p=(icon_view_t *)widgets_p->parent;
    /* open with */
    gchar *name;
    int argc;
    gchar **argv;
    const gchar *command;
    const gchar *command_fmt;
    GError *error=NULL;
    
    if (!en || !en->path) return;
    name=g_path_get_basename(en->path);
    
    
    command_fmt = MIME_command(name);
    
    if(!command_fmt)
    {
	gridview_show_input(RUN_DOUBLE_CLICK,icon_view_p);
	print_status(widgets_p,"xffm/question",name,NULL);
    } else {
        gchar *wd=g_path_get_dirname((const gchar *)en->path);	    
	command =  MIME_mk_command_line(command_fmt,name,FALSE,FALSE);


	g_shell_parse_argv (command, &argc,&argv,&error);
	if (error){
	    gchar *msg = g_strcompress (error->message);
	    print_diagnostics(widgets_p,"xffm/error",msg,":\n",command,"\n",NULL);
	    g_error_free(error);
	    g_free (msg);
	    g_free(wd);
	    return;
	}
	xffm_runvwd(widgets_p,wd,(const gchar **)argv);
	g_free(wd);
	g_strfreev (argv); 
    }
    g_free(name);
    return;
}

G_MODULE_EXPORT
void gridview_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gboolean valid_path=FALSE;
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);   
    TRACE("gridview_print_activate");
    if (icon_view_p->selection_list) {
	GList *tmp;
	for (tmp=icon_view_p->selection_list; tmp; tmp=tmp->next){
	    record_entry_t *en=(record_entry_t *)tmp->data;
	    if (en && IS_FILE(en->type)) {
		valid_path=TRUE;
		break;
	    }
	}
    }
    if(!valid_path)
    {
	show_text(widgets_p);
	print_diagnostics(widgets_p,"xffm/error", strerror(EINVAL),"\n", NULL);
	return;
    }
    gridview_show_input(PRINT_INPUT,icon_view_p);
}

G_MODULE_EXPORT
void gridview_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    record_entry_t *new_en;
    ATOMIC_CHECK return;
ATOMIC_ON
    xffm_remove(widgets_p,icon_view_p->selection_list);
    if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
ATOMIC_OFF
    new_en = copy_entry(icon_view_p->en);
    reload_iconview(icon_view_p,new_en,FALSE);
}

G_MODULE_EXPORT
void 
do_iconview_popup(	icon_view_t *icon_view_p, 
			population_t *population_p, 
			GdkEventButton *event)
{
    if (!icon_view_p) return;
    /* only need to destroy and recreate if module fiddles around with it */
    if (!icon_view_p->popup){
	icon_view_p->popup = gridview_mk_popup_menu(NULL,NULL,icon_view_p);
    }    
    gtk_widget_hide_all(icon_view_p->popup);
	TRACE("do_iconview_popup");

    if (icon_view_p->module_name && !population_p && function_rational("plugins",icon_view_p->module_name,(void *)(icon_view_p->en),&(icon_view_p->widgets),"private_popup"))
    {
	TRACE("private module popup menu here (no population.");	
	return;
    }
    if (population_p && population_p->en && population_p->en->module && 
	function_rational("plugins",population_p->en->module,(void *)(population_p->en),&(icon_view_p->widgets),"private_popup"))
    {
	TRACE("private module popup menu here.");
	return;
    }

    {
	///hmmm works when menu is created, but not here.....
	GtkWidget *w,*inner_label=lookup_widget(icon_view_p->widgets.window,"sort1");
	GdkPixbuf *pb;
	if (icon_view_p->preferences & SORT_ASCENDING) pb=icon_tell(&(icon_view_p->widgets),SMALL,"xffm/stock_sort-ascending");
	else pb=icon_tell(&(icon_view_p->widgets),SMALL,"xffm/stock_sort-descending");
	w=gtk_image_new_from_pixbuf (pb);
	g_object_unref(pb);
	gtk_widget_show (w);
	TRACE("now setting image for sort order menu item...");
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (inner_label), w);
    }

      
    if (!population_p || 
        !population_p->en || 
        !population_p->en->path || 
	IS_DUMMY_TYPE(population_p->en->type) ||
	IS_ROOT_TYPE(population_p->en->type) 
	 )
    {
	TRACE("main menu here");
	refresh_item(icon_view_p,population_p);
	set_menu_toggles(icon_view_p);
	gtk_menu_popup(GTK_MENU(icon_view_p->popup), NULL, NULL, NULL, NULL, 3, event->time);
	return;
    }
    

    gui_autostuff(&(icon_view_p->widgets),icon_view_p, icon_view_p->popup,population_p->en,(gpointer)gridview_autotype_C, (gpointer)gridview_mount, (gpointer)gridview_unmount);
    
    mount_item(icon_view_p,population_p);
    remove_item(icon_view_p,population_p);
    open_item(icon_view_p,population_p);    
    properties_item(icon_view_p,population_p);    
    print_item(icon_view_p,population_p); 

    TRACE("icon_view_p->module_name=%s,icon_view_p->submodule_name=%s",
	    icon_view_p->module_name,icon_view_p->submodule_name);
    gridview_mk_module_popup_menu(icon_view_p->module_name,icon_view_p,icon_view_p->en);

    
    set_menu_toggles(icon_view_p);
    gtk_menu_popup(GTK_MENU(icon_view_p->popup), NULL, NULL, NULL, NULL, 3, event->time);
}

G_MODULE_EXPORT
void gridview_back_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    widgets_t  *widgets_p=(widgets_t  *)user_data;
    icon_view_t *icon_view_p=(icon_view_t *)(widgets_p->parent);
    GList *last;
    record_entry_t *en;
    TRACE("iconview goback");
    if (!icon_view_p) {
	g_warning("!icon_view_p");
	return;
    }
    last=g_list_last(icon_view_p->go_list);
    if (!last) return;
    en=last->data;	    
    if (en) icon_view_p->module_name=en->module;
    else icon_view_p->module_name=NULL;
    reload_iconview(icon_view_p,en,FALSE);
    pop_iconview_go_history(icon_view_p);
}

