/* basic_row_i */
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Static functions for basic_local.c */

 
static
int 
add_folder_local(	GtkTreeView * treeview, 
			GtkTreeIter * iter,
			record_entry_t *en)
{
    xfdir_t xfdir;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    time_t inicio = time(NULL);
    
#ifdef DO_THE_STATUS_LOADING_THING
    print_status(&(xffm_details->arbol->widgets),NULL,_("Loading..."),NULL);
#endif
    
    if (!get_xfdir_local(&xfdir, en, gui_get_filter(&(xffm_details->arbol->widgets))))
    	    
    {
	if (xfdir.gl) g_free(xfdir.gl);
	reset_dummy_row(treemodel, iter,NULL,en,"xffm/error_icon",_("Load failed"));
	print_diagnostics(&(xffm_details->arbol->widgets),"xffm/error_icon", en->path, " :\n", strerror(errno), "\n", NULL);
	return 0;
    }
	
    add_contents_row(treemodel, iter, &xfdir);
    xfdirfree(&xfdir);
    if (!IS_ROOT_TYPE(en->type)){
        erase_dummy_row(treemodel,iter,NULL);
    }

    SET_LOADED(en->type);

    /* XXX: is en->tag really necessary? */
    if(xffm_details->arbol->widgets.stop)
    {
	SET_INCOMPLETE(en->type);
	xffm_details->arbol->widgets.stop = FALSE;
 	if (en->tag) g_free(en->tag);	
	en->tag = g_strconcat(my_utf_string(FILENAME(en))," : ", strerror(ECANCELLED), NULL);
	print_diagnostics(&(xffm_details->arbol->widgets),"xffm/warning_icon",strerror(ECANCELLED),":\n",en->tag, "\n",NULL);
	TRACE("TRACE: stopped!\n");
    }
    else
    {
	UNSET_INCOMPLETE(en->type);
	hide_stop(&(xffm_details->arbol->widgets));
	if (en->tag && strchr(en->tag,'%')){
		print_status(&(xffm_details->arbol->widgets),resolve_icon_id(en), my_utf_string(FILENAME(en)), NULL);
	}
	else if (en->tag) {
	    TRACE("en-<tag is %s",en->tag);
	    print_status(&(xffm_details->arbol->widgets),resolve_folder_icon(en), en->tag, NULL);
	}
	process_pending_gtk();
    }
    en->load_time = time(NULL) - inicio;

    return xfdir.pathc;

}

