static char *diff_file[2];
static int diff_selected;
static
void gui_on_about_activate (GtkMenuItem *menuitem, gpointer data)
{
	widgets_t *widgets_p = (widgets_t *)data;
#ifdef HAVE_LIBXFCEGUI4
	XfceAboutInfo *info;
	GtkWidget *dialog;
	GdkPixbuf *pixbuf = icon_tell (widgets_p, REAL_BIG,"xffm/xffm");
	struct passwd *p;
	gchar *g;
	
	
	if((p = getpwuid(geteuid())) != NULL){
	    g=g_strdup_printf("%s@%s",p->pw_name,xffm_details->argv[0]);
	} else {
	    g=g_strdup_printf("%d@%s",geteuid(),xffm_details->argv[0]);
	}
	info = xfce_about_info_new(
		g,
		VERSION,
		_("Xfce fast file manager"),
		XFCE_COPYRIGHT_TEXT("2002-2005", "The Xfce development team"),
		XFCE_LICENSE_LGPL);

	xfce_about_info_set_homepage(info, "http://www.xfce.org/");
	xfce_about_info_add_credit(info,
		"Edscott Wilson Garcia and others",
		"xfce4-dev@xfce.org",
		"");

	dialog = xfce_about_dialog_new(NULL, info,pixbuf );
	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 400);
	xfce_about_info_free(info);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
	if (pixbuf) g_object_unref(G_OBJECT(pixbuf));
	g_free(g);
#else
	show_text(widgets_p);
	print_diagnostics(widgets_p,"xffm/info","Xfce fast file manager:",VERSION,
		"\nEdscott Wilson Garcia and others",
		"\nxfce4-dev@xfce.org",NULL);
#endif
}


static void tag_select(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    record_entry_t *en;

    if(diff_selected >= 2)
	return;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    diff_file[diff_selected++] = en->path;
    return;
}

static 
void on_differences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeSelection *selection;
    diff_selected = 0;
    diff_file[0] = diff_file[1] = NULL;
    
    selection = xffm_details->arbol->treestuff[tree_id].selection;
    gtk_tree_selection_selected_foreach(selection, tag_select, NULL);
    TRACE("xfdiff %s %s",diff_file[0],diff_file[1]);
    xffm_diff(&(xffm_details->arbol->widgets),diff_file[0], diff_file[1]);


}

G_MODULE_EXPORT
void treeview_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
    en = treeview_get_selected_entry(&iter);
    if(!en || !IS_FILE(en->type))
    {
	show_text(widgets_p);
	print_diagnostics(widgets_p,"xffm/error", strerror(EINVAL),"\n", NULL);
	return;
    }
    treeview_show_input(PRINT_INPUT);
}


static
const
gchar *
on_scramble(		GtkWidget *w){
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;

    GtkTreeIter iter;
    
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
    if(!gtk_tree_selection_get_selected(selection, &treemodel, &iter)) {
    	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return NULL;
    }
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    if(!en || !IS_PATH(en->type))
    {
	show_text(&(xffm_details->arbol->widgets));
	print_diagnostics(&(xffm_details->arbol->widgets),"xffm/error", strerror(EINVAL),"\n", NULL);
	return NULL;
    }
    return (const gchar *)en->path;
}

/*   callback  */

static
void on_scramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   xffm_scramble(&(xffm_details->arbol->widgets),on_scramble(NULL),TRUE); 
}

static
void on_unscramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   xffm_scramble(&(xffm_details->arbol->widgets),on_scramble(NULL),FALSE); 
}
static
void tb_print(GtkWidget *w)
{
    treeview_print_activate((GtkMenuItem *) w, NULL);
}

/* only used by treeview at this point: */

static
void
on_printer_configuration_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GError *error=NULL;
    const gchar *command="xfprint4-manager";
    print_diagnostics(&(xffm_details->arbol->widgets),NULL,"$",command,"\n",NULL);

   if (!g_spawn_command_line_async (command,&error)){
	  gchar *msg = g_strcompress (error->message);
	  print_diagnostics(&(xffm_details->arbol->widgets),"xffm/error",msg,":\n",command,"\n",NULL);
	  g_error_free (error);
	  g_free (msg);
   } 
}

static
void sb_run(GtkWidget *w){
    treeview_show_input(RUN_INPUT);
}

G_MODULE_EXPORT
void treeview_run_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    treeview_show_input(RUN_INPUT);
}


G_MODULE_EXPORT
void 
treeview_open_with(		widgets_t *widgets_p, record_entry_t *en)
{
    /* open with */
    gchar *name;
    int argc;
    gchar **argv;
    const gchar *command;
    const gchar *command_fmt;
    GError *error=NULL;
    
    if (!en || !en->path) return;
    name=g_path_get_basename(en->path);
    
    
    command_fmt = MIME_command(name);
    
    if(!command_fmt)
    {
	treeview_show_input(RUN_DOUBLE_CLICK);
	print_status(widgets_p,"xffm/question",name,NULL);
    } else {
        gchar *wd=g_path_get_dirname((const gchar *)en->path);	    
	command =  MIME_mk_command_line(command_fmt,name,FALSE,FALSE);


	g_shell_parse_argv (command, &argc,&argv,&error);
	if (error){
	    gchar *msg = g_strcompress (error->message);
	    print_diagnostics(widgets_p,"xffm/error",msg,":\n",command,"\n",NULL);
	    g_error_free(error);
	    g_free (msg);
	    g_free(wd);
	    return;
	}
	xffm_runvwd(widgets_p,wd,(const gchar **)argv);
	g_free(wd);
	g_strfreev (argv); 
    }
    g_free(name);
    return;
}


static
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    en = treeview_get_selected_entry(&iter);
    xffm_open_with(&(xffm_details->arbol->widgets),en);
    return;
}

static
void on_term(GtkWidget *w){
    record_entry_t *en=NULL;
    GtkTreeIter iter;
    gchar *path=NULL;
   
    if (get_selectpath_iter(&iter, &en)){
	if (en && en->path) path=g_strdup(en->path);
    }
    xffm_new_terminal_path(&(xffm_details->arbol->widgets),path);
    g_free(path);
}

/*static
void tb_diff(GtkButton * button, gpointer user_data)
{
    on_differences_activate(NULL,NULL);

}*/

static
void sb_diff(GtkWidget *w)
{
    on_differences_activate(NULL,NULL);
}

static 
void on_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    GtkTreeIter iter;
    gchar *path=NULL;
   
    if (get_selectpath_iter(&iter, &en)){
	if (en && en->path) path=g_strdup(en->path);
    }
    xffm_new_terminal_path(&(xffm_details->arbol->widgets),path);
    g_free(path);
    return;
}
   
static
void on_iconview_activate(GtkMenuItem *w,gpointer data){
    gchar *dir=NULL;
    record_entry_t *en;
    GtkTreeIter iter;
    gchar *argv[4];

    en = treeview_get_selected_entry(&iter);
    argv[0]="xffm-iconview";
    if (en && en->path) {
	if ((IS_NETFILE(en->subtype)) ||
	    (g_file_test(en->path,G_FILE_TEST_EXISTS) && !g_file_test(en->path,G_FILE_TEST_IS_DIR)))
	    dir=g_path_get_dirname(en->path);
	else dir=g_strdup(en->path);
	argv[1]=dir;
	argv[2]=(char *)en->module;
	/*TRACE("en->module=%s",en->module);*/
	argv[3]=NULL;
    } else argv[1]=NULL;

    xffm_runvwd(&(xffm_details->arbol->widgets),g_get_home_dir(),(const gchar **)argv);

    g_free(dir);
    return;
 
}


static
void on_newdir_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    treeview_show_input(NEW_DIR_INPUT);
}

static
void on_newfile_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    treeview_show_input(NEW_FILE_INPUT);
}


static
void tb_new(GtkWidget *w)
{
    treeview_show_input(NEW_FILE_INPUT);
}

static
void tb_newd(GtkWidget *w)
{
    treeview_show_input(NEW_DIR_INPUT);
}

static
void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    en = treeview_get_selected_entry(&iter);
    if(!en){
	treeview_show_input(RUN_INPUT);
    }
    else
    {
	treeview_show_input(RUN_DOUBLE_CLICK);
	print_status(&(xffm_details->arbol->widgets),"xffm/question", _("Input requested"), NULL);
    }


}

static 
int
autofunction_workdir  (	GtkTreeView *treeview,
			record_entry_t *en,
			const gchar *querypath) 
{
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);

         
  g_free(widgets_p->workdir);
  widgets_p->workdir=NULL;
  if (querypath){
      widgets_p->workdir=g_strdup(querypath); 
      	/* remove any previous gtk loop: */ 
	treeview_cancel_input(NULL,NULL);    
	/* this starts a new gtk loop */
	treeview_show_input(WORKDIR_INPUT);
      
      /* on returning from the loop, xffm_details->input == OTHER_INPUT
       * means it was cancelled by button press, or menu selection */
      if (widgets_p->input == OTHER_INPUT) return FALSE;
      widgets_p->input = OTHER_INPUT;
      if (!widgets_p->workdir){
	 print_status(widgets_p,"xffm/warning",strerror(ENOTDIR),NULL);
	 return FALSE;
      }	 
  } else {
  	widgets_p->workdir=g_path_get_dirname (en->path);
  }
  if(!widgets_p->workdir || chdir(widgets_p->workdir)<0){
	 print_status(widgets_p,"xffm/error",strerror(errno), NULL);
	 g_free(widgets_p->workdir);
	 widgets_p->workdir=NULL;
	 chdir(GETWD);
	 return FALSE;
  }
  chdir(GETWD);
  return TRUE;
}

G_MODULE_EXPORT
void
treeview_autotype_C                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    const gchar *command;
    const gchar *dirname;
    static gchar *new_command=NULL;
    GtkTreeIter iter;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    record_entry_t *en;
    GtkTreeView *treeview;
    gint argc;
    gchar **argv;
    GError *error=NULL;
    record_entry_t *tmp_en=NULL;
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
  
    gint tree_id = get_active_tree_id();
 


    treeview = xffm_details->arbol->treestuff[tree_id].treeview;
     
    en = treeview_get_selected_entry(&iter);
    if (IS_NETFILE(en->subtype)){
	const gchar *file=XF_SMBget_cache_file(en,&(xffm_details->arbol->widgets));
	tmp_en = stat_entry ((gchar *)file, __LOCAL_TYPE);
	en=tmp_en;
    }
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    dirname=g_object_get_data(G_OBJECT(menuitem),"workdir");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    if (querypath && !autofunction_workdir (treeview, en,querypath)) {
	if (tmp_en) destroy_entry(tmp_en);
	return;
    }
    
    if (output_arg) {
	gchar *outputdir=widgets_p->workdir;
	widgets_p->workdir=g_strdup(dirname);
	TRACE("output dir is %s",outputdir);
	if (new_command) g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    } else if (!querypath)
    {
	g_free(widgets_p->workdir);
	widgets_p->workdir=g_strdup(dirname);
	TRACE("*****widgets_p->workdir is %s",widgets_p->workdir);
    } else if (!widgets_p->workdir)
    {
	g_warning("widgets_p->workdir==NULL");
	return;
    }
    
    TRACE("output_arg=%s, command=%s, querypath=%s, output_ext=%s, dirname=%s",
	    output_arg, command, querypath, output_ext, dirname);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
#if 0
    {
	int i;
	DBG("command is: %s",command);
	for (i=0;i<argc;i++)DBG("argv[%d]=%s",i,argv[i]);
    }
#endif
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics(&(xffm_details->arbol->widgets),"xffm/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
    if (!queued || *queued == FALSE){
       if (xffm_runvwd(&(xffm_details->arbol->widgets),widgets_p->workdir,(const gchar **)argv)){
	    if (en && en->path) RECENT_add2history(&(xffm_details->arbol->widgets),en->path);
       }
	g_strfreev (argv);
	if (tmp_en) destroy_entry(tmp_en);
       return;
    } 

    
    gui_autofunction(&(xffm_details->arbol->widgets),en,(const gchar **)argv,(queued && *queued));
    
    chdir(GETWD);
    if (widgets_p->workdir && strcmp(widgets_p->workdir,GETWD)!=0) print_diagnostics(&(xffm_details->arbol->widgets),NULL,"$chdir ",GETWD,"\n",NULL);
    g_strfreev (argv);
    if (tmp_en) destroy_entry(tmp_en);

	
}



static
void on_collect_trash1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    TRASH_collect_trash_callback(menuitem, user_data);
}

static
void on_uncollect_trash(GtkMenuItem * menuitem, gpointer user_data)
{

    TRASH_uncollect_trash_callback(menuitem, user_data);
}


static
void on_delete_all_trash(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    TRASH_delete_all_trash(treeview);
}

static
void on_uncollect_from_trash_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    TRASH_uncollect_from_trash_callback (menuitem, user_data);
}

G_MODULE_EXPORT
void treeview_duplicate_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    en = treeview_get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(xffm_details->arbol->widgets),"xffm/error", strerror(EINVAL), NULL);
	return;
    }
    treeview_show_input(DUPLICATE_INPUT);

}


G_MODULE_EXPORT
void treeview_rename_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    
    
    en = treeview_get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(xffm_details->arbol->widgets),"xffm/error", strerror(EINVAL), NULL);
	return;
    }
    treeview_show_input(RENAME_INPUT);

}


G_MODULE_EXPORT
void treeview_symlink_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    if (!xffm_details->arbol->widgets.window) return;
    en = treeview_get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(xffm_details->arbol->widgets),"xffm/error", strerror(EINVAL), NULL);
	return;
    }
    treeview_show_input(SYMLINK_INPUT);

}


static
void private_unselect_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    gtk_tree_selection_unselect_all (selection);
}

static
void private_select_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = get_active_tree_id();
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    gtk_tree_selection_select_all (selection);

#if 0  
    int items=0;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    record_entry_t *en;
    GtkTreeIter iter;
    
    print_status(&(xffm_details->arbol->widgets),"xffm/info",_("Select all"),"...",NULL);
    cursor_wait(xffm_details->arbol->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    
	
	/*gtk_tree_selection_select_all (selection);*/
	

	if (!get_selectpath_iter(&iter,&en)) {
	    cursor_reset(xffm_details->arbol->widgets.window);
	    return;
	}
	
    	do {
      	  gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
      	  if (!IS_DUMMY_TYPE(en->type)){
   		gtk_tree_selection_select_iter (selection,&iter);
		items++;
	  }
    	}
    	while (gtk_tree_model_iter_next(treemodel,&iter));

    {
	gchar *g=g_strdup_printf(dngettext(GETTEXT_PACKAGE,"%d item selected","%d items selected",items),items);
	print_status(&(xffm_details->arbol->widgets),"xffm/info",g,NULL);
	g_free(g);
    }
    cursor_reset(xffm_details->arbol->widgets.window);
#endif
}

G_MODULE_EXPORT
void treeview_touch_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter iter;
    GtkTreeModel *treemodel = NULL;  
    gint tree_id = get_active_tree_id();
    treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    
    en = treeview_get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(xffm_details->arbol->widgets),"xffm/error", strerror(EINVAL), NULL);
	return;
    }
    xffm_touch(&(xffm_details->arbol->widgets),en->path);
    if (treemodel) {
	struct stat st;
	record_entry_t *en;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	stat(en->path, &st);
	memcpy(en->st, &st, sizeof(struct stat));
	update_row(treemodel, &iter, NULL, en);
	unset_load_wait();
    }
    return;
}


static void new_win(gpointer user_data)
{
    treeview_show_input(NEW_WIN_INPUT);
    return;
}


static
void on_open_in_xffm_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    new_win(user_data);
}

static
void
on_preview_this_image_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GdkPixbuf *tgt;
    record_entry_t *en;
    GtkTreeIter iter;
    GtkTreeModel *treemodel = NULL;
    if (xffm_details->arbol->widgets.window) {
	gint tree_id = get_active_tree_id();
	treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    }
    en = treeview_get_selected_entry(&iter);
    print_status(&(xffm_details->arbol->widgets),"xffm/warning", 
			_("Preview"), ": ", FILENAME(en), 
			NULL);
    process_pending_gtk();

    tgt = create_preview(en->path, REAL_BIG);
    if (!tgt) print_status(&(xffm_details->arbol->widgets),"xffm/error", 
			strerror(EINVAL), ": ", FILENAME(en), 
			NULL);
    else {
	if (treemodel) update_iconcolumn_for_row(treemodel, &iter, tgt);	
    }
}


static
void on_countfiles_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    gchar *fname;
    GtkTreeView *treeview;
    GtkTreeSelection *selection;
    gint tree_id = get_active_tree_id();
    
    treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    selection = xffm_details->arbol->treestuff[tree_id].selection;

    if ((fname=xffm_PlainTmpList(treeview,selection))==NULL) {
	g_warning("fname=PlainTmpList(treeview,selection))==NULL");
	return;
    }

    xffm_count_window(&(xffm_details->arbol->widgets),fname);
    g_free(fname);
    return;
}

static
void on_clear_all_results_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeIter parent;
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;

    get_module_root(treeview, &parent, &en,"xffm_find");
    prune_row(treemodel,&parent,NULL,en);
    insert_dummy_row(treemodel, &parent,NULL,en,"xffm/info",_("Nothing searched"));

}
static
void on_remove_from_results_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    GtkTreeIter iter, parent;
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;

    /*get selection */
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {
	remove_row(treemodel, &iter,NULL,NULL);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    get_module_root(treeview, &parent, &en,"xffm_find");
    if (!gtk_tree_model_iter_has_child(treemodel,&parent)) {
	insert_dummy_row(treemodel, &parent,NULL,en,"xffm/info",_("Nothing searched"));
    }
}


#if 0
static
void titles_toggle(GtkButton * button, gpointer user_data)
{
    unsigned l = (unsigned)((long)user_data);
    if(l & 0x100){
       xffm_details->preferences |= (QUICK_HIDE_MASK & l);
    } else {
        xffm_details->preferences &= (BIT_MASK ^ l);
    }
    hide_bars();
}




static
void on_tb_close(GtkWidget * w){
    /* treeview only*/
    on_close_activate(NULL, NULL);
}

#endif

static
void
private_mount   (int mounted){
    GtkTreeIter iter;
    record_entry_t *en=NULL;

    en = treeview_get_selected_entry(&iter);
    TRACE("<<<<<<<<<<< on mount %d ",mounted);
    if(!en || !en->path) {
	g_warning("no entry to mount");
	return;
    }
    if (mounted) SET_MOUNTED(en->type); else UNSET_MOUNTED(en->type);
    FSTAB_fstab_mount(en,&(xffm_details->arbol->widgets));
    TRACE("<<<<<<<<<<< on mount done");
}


G_MODULE_EXPORT
void
treeview_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    private_mount(FALSE);
}
G_MODULE_EXPORT
void
treeview_unmount   (GtkMenuItem     *menuitem, gpointer         user_data){
    private_mount(TRUE);
}

static
void
on_edit_themes                         (GtkMenuItem     *menuitem,
                                        gpointer         user_data){
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);
    const gchar *argv[]={"xfmime-edit",NULL};
    xffm_runvwd(widgets_p,NULL,argv);
    xffm_confirm(widgets_p,_("You can make xffm use an alternate icon theme with the XFFM_ICON_THEME environment variable"),NULL,"Ok");
}

/* pasteboard stuff ***/ 

extern GtkTreeRowReference *pasteref;
static GList *paste_list=NULL;

static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    record_entry_t *en;
       gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return;   

    if(!en){
	TRACE("TRACE: on check_select for pasteboard, entry is null!\n");
	return;
    }
    if(IS_DUMMY_TYPE(en->type))
	return;
    if(!IS_PATH(en->type)&&!IS_NETTHING(en->subtype))
	return;
    paste_list = g_list_append(paste_list, en);
    return;
}


static void private_paste(widgets_t *widgets_p, GtkTreeView * treeview, gboolean symlink)
{
    gboolean cut;
    GList *list=NULL;
    record_entry_t *t_en = NULL;
    int i;
    GtkTreeIter *iter;
    GtkTreeIter parent,child;
    gboolean will_expand=FALSE;
    GtkTreeModel *treemodel = NULL;

    if (treeview) treemodel = gtk_tree_view_get_model(treeview);

    if(!xffm_details->pastepath) return;
    
    
    TRACE("TRACE:pastepath=%s\n",xffm_details->pastepath);
    if (!treeview_get_selected_entry(&child)) return;
    gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &t_en, -1);
    if (!t_en) return;

    if ((i=gui_pasteboard_list(&list))==0) return;
    if (i==1) cut=TRUE; else cut=FALSE;

    
    if(IS_FILE(t_en->type)){
	if (!gtk_tree_model_iter_parent (treemodel,&parent,&child)){
	    g_warning("this should not happen");
	    return;
	}
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &t_en, -1);
	if (!t_en) return;
	iter=&parent;
    }
    else {
	iter=&child;
    }
    
    if (!pasteref){/*FIXME: is this used or not ? (probably is) */
 	GtkTreePath *treepath=gtk_tree_model_get_path(treemodel,iter);
	g_warning("pasteref == NULL");
    	pasteref=gtk_tree_row_reference_new(treemodel,treepath);
    	gtk_tree_path_free(treepath);
    }	
    if (IS_EXPANDED(t_en->type)) will_expand=TRUE;
    
    if(!set_load_wait())
    {
	print_diagnostics(widgets_p,"xffm/error",strerror(EBUSY),"\n",NULL);
	return;
    }
    i=gui_pasteboard_transfer(widgets_p, t_en,list, NULL,  cut,  symlink);
    
    list = uri_free_list(list);	
    
    if (i) {
	update_dir(treeview, pasteref);
	if(cut) XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);
	turn_on_pasteboard();
    }
    unset_load_wait();
    if (i && will_expand && (IS_NETDIR(t_en->subtype) || 
			IS_XF_NETSHARE(t_en->subtype)||  
			IS_NETFILE(t_en->subtype)) )

    {
	GtkTreePath *treepath=gtk_tree_row_reference_get_path(pasteref);
    	gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	gtk_tree_path_free(treepath);
    }
    return;
}


static GtkTreeView *make_pasteboard_list(void){
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    gtk_tree_selection_selected_foreach(selection, check_select, (gpointer) treeview);
    if (paste_list) return treeview;
    return NULL;
}

static
gboolean uncut_row(		GtkTreeModel *treemodel, 
				GtkTreePath *path,
				GtkTreeIter *iter,
                                gpointer data){
    record_entry_t *en;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (IS_CUT(en->type)) set_icon(treemodel,iter);
    return FALSE;
}

static 
void icon_select(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    set_icon(treemodel, iter);
    return;
}

/*   callbacks   */
static 
void copy_cut_callback(gboolean cut){
    gint tree_id=get_active_tree_id();
    GtkTreeView *treeview=xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel=xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection=xffm_details->arbol->treestuff[tree_id].selection;
    if (!make_pasteboard_list()) return;
    gui_pasteboard_copy_cut(&(xffm_details->arbol->widgets),cut, &paste_list);
    gtk_tree_model_foreach (treemodel, uncut_row, NULL);
    if (cut) {
	gtk_tree_selection_selected_foreach(selection, icon_select, (gpointer) treeview);
	turn_on();
    }
    turn_on_pasteboard();
    g_list_free(paste_list);
    paste_list=NULL;
}

static
void tb_cut(GtkWidget * w)
{
    copy_cut_callback(TRUE);
    return;
}

G_MODULE_EXPORT
void treeview_cut_activate(GtkMenuItem * menuitem, gpointer data)
{
    copy_cut_callback(TRUE);
    return;
}


static
void tb_copy(GtkWidget * w)
{
    copy_cut_callback(FALSE);
    return;
}


G_MODULE_EXPORT
void treeview_copy_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    copy_cut_callback(FALSE);
    return;
}

static 
void paste_callback(gboolean symlink) {
    gint tree_id=get_active_tree_id();
    GtkTreeView *treeview=xffm_details->arbol->treestuff[tree_id].treeview;
    private_paste(&(xffm_details->arbol->widgets),treeview, symlink);
    turn_on_pasteboard();
    return;

}

static
void tb_paste(GtkWidget * w)
{
    paste_callback(FALSE);
    return;

}

G_MODULE_EXPORT
void treeview_paste_activate(GtkMenuItem * menuitem, gpointer data)
{
    paste_callback(FALSE);
    return;
}

static
void tb_pastelink(GtkWidget * w)
{
    paste_callback(TRUE);
    return;
}

static
void treeview_pastelink_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    paste_callback(TRUE);
    return;
}


G_MODULE_EXPORT
void treeview_list_pasteboard_activate(GtkMenuItem * menuitem, gpointer data)
{
    gui_pasteboard_show(&(xffm_details->arbol->widgets));
}


G_MODULE_EXPORT
void treeview_clear_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);	/* store a null string */
    turn_on_pasteboard();
}

/***************   remove stuff ************************/
static GList *remove_list=NULL;
static GList *remove_reference_list=NULL;

static void remove_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeRowReference *reference;
    record_entry_t *en;
       
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return;   

    if(!en){
	TRACE("TRACE: on check_select for pasteboard, entry is null!\n");
	return;
    }
    if(IS_DUMMY_TYPE(en->type))
	return;
    if(!IS_PATH(en->type)&&!IS_NETTHING(en->subtype))
	return;
    remove_list = g_list_append(remove_list, en);
    reference = gtk_tree_row_reference_new(treemodel, path);
    remove_reference_list = g_list_append(remove_reference_list, reference);        
    return;
}

G_MODULE_EXPORT
void treeview_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GList *tmp;
    widgets_t *widgets_p;
    gint tree_id=get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    widgets_p = &(xffm_details->arbol->widgets);
    
    if (!set_load_wait()) return;
    if (remove_list) g_list_free(remove_list);
    remove_list=NULL;
    if (remove_reference_list) {
	for (tmp=remove_reference_list; tmp; tmp=tmp->next){
	    GtkTreeRowReference *reference=(GtkTreeRowReference *)tmp->data;
	    if (reference)gtk_tree_row_reference_free(reference);
	}
	g_list_free(remove_reference_list);
    }
    remove_reference_list=NULL;
    gtk_tree_selection_selected_foreach(selection, remove_select, (gpointer) treeview);
    
    xffm_remove(widgets_p,remove_list);
	
    for (tmp=remove_reference_list; tmp; tmp=tmp->next){
	GtkTreeRowReference *reference=(GtkTreeRowReference *)tmp->data;
	if (reference){
	    remove_it(treeview,(GtkTreeRowReference *) tmp->data);
	    gtk_tree_row_reference_free(reference);
	}
    }
    g_list_free(remove_reference_list);
    remove_reference_list=NULL;
    
    
    unset_load_wait();
    turn_on();
}

static
void tb_delete(GtkWidget * w)
{
    treeview_remove_activate(NULL, NULL);
}

/****************   refresh   ********************************/
static gboolean toggle_enabled=TRUE;

G_MODULE_EXPORT
void enable_refresh_by_toggle(gboolean value){
	toggle_enabled=value;
}
G_MODULE_EXPORT
gboolean is_toggle_enabled(void){
	return toggle_enabled;
}

enum
{
    DO_REFRESH,
    DO_TOGGLE_DOT
};

static void do_it(GtkTreeModel * treemodel, GtkTreeIter * iter, GtkTreeView * treeview)
{
    record_entry_t *en;
    GtkTreePath *treepath;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    treepath = gtk_tree_model_get_path(treemodel, iter);
    if(!en)
	assert_not_reached();
    /*if(caso == DO_TOGGLE_DOT) TOGGLE_SHOWS_HIDDEN(en->type);*/
    SET_INCOMPLETE(en->type);
    prune_row(treemodel, iter,NULL,en);
    insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
    gtk_tree_view_collapse_row(treeview, treepath);
    unset_load_wait();
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);
}




G_MODULE_EXPORT
gint treeview_refresh(widgets_t *widgets_p)
{
    GtkTreeIter iter;
    record_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    
    if (!toggle_enabled) return 0;

    if(get_selectpath_iter(&iter, &en))
    {
       const gchar *cache=get_local_cache_path(en->path);
       unlink(cache);
       do_it(treemodel, &iter, treeview);
    }
    else 
    {	
	if (gtk_tree_model_get_iter_first(treemodel,&iter)){
		do{
    		   gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		   if (en && IS_EXPANDED(en->type))	
        	      do_it(treemodel, &iter, treeview);
		} while(gtk_tree_model_iter_next(treemodel,&iter));
	}
    }
    return 1;
}

static
void treeview_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    treeview_refresh(&(xffm_details->arbol->widgets));
}

G_MODULE_EXPORT
void treeview_on_refresh(GtkButton * button, gpointer user_data)
{
    treeview_refresh(&(xffm_details->arbol->widgets));
}


static void hide_arrow(GtkTreeViewColumn * column,const gchar *which){
    GtkWidget *a;
    a=(GtkWidget *)g_object_get_data(G_OBJECT(column),which);
    if (a) gtk_widget_hide(a);
}
static void show_arrow(GtkTreeViewColumn * column,const gchar *which){
    GtkWidget *a;
    a=(GtkWidget *)g_object_get_data(G_OBJECT(column),which);
    if (a) gtk_widget_show(a);
}


static void arrow_trick(GtkTreeView *treeview,GtkTreeViewColumn * column){
    treestuff_t *treestuff= get_treestuff(treeview);
    hide_arrow(treestuff->column[NAME_COLUMN],"up");
    hide_arrow(treestuff->column[NAME_COLUMN],"down");
    hide_arrow(treestuff->column[OWNER_COLUMN],"up");
    hide_arrow(treestuff->column[OWNER_COLUMN],"down");
    hide_arrow(treestuff->column[GROUP_COLUMN],"up");
    hide_arrow(treestuff->column[GROUP_COLUMN],"down");
    hide_arrow(treestuff->column[DATE_COLUMN],"up");
    hide_arrow(treestuff->column[DATE_COLUMN],"down");
    hide_arrow(treestuff->column[SIZE_COLUMN],"up");
    hide_arrow(treestuff->column[SIZE_COLUMN],"down");
    hide_arrow(treestuff->column[MODE_COLUMN],"up");
    hide_arrow(treestuff->column[MODE_COLUMN],"down");
    
}

static GtkTreeViewColumn * lastcolumn=NULL;

G_MODULE_EXPORT
void on_column_click(GtkTreeViewColumn * column, gpointer data){
    GtkTreeModel *treemodel;
    GtkTreeSortable *sortable;
    static gboolean red=FALSE;
    GtkTreeView *treeview =(GtkTreeView *)data;
    treestuff_t *treestuff=get_treestuff(treeview);
    gint column_id = (gint)((long)g_object_get_data (G_OBJECT(column),"column_id"));
    
    if (!toggle_enabled || red) return;
    red=TRUE;
    arrow_trick(treeview,column);
    treemodel = gtk_tree_view_get_model(treeview);
    {
	sortable=GTK_TREE_SORTABLE(treemodel);
	TRACE("gtk_tree_sortable_has_default_sort_func=%d\n",
		gtk_tree_sortable_has_default_sort_func(sortable));
    }
    if (column_id == GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID) {
	treestuff->ascending=0;
    }
    else {
      GtkSortType order;
      if (gtk_tree_sortable_get_sort_column_id (sortable,&(treestuff->sort_column),&order)){
	  if (column_id != treestuff->sort_column) treestuff->ascending=1;
	  else treestuff->ascending++;
      } else treestuff->ascending=1;
    }
    
    treestuff->sort_column=column_id;
    
    switch (treestuff->ascending%3) {
	case 0:
	  treestuff->sort_column =GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_ASCENDING);
	  break;
	case 1:
	  show_arrow(column,"up");
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_ASCENDING);
	  break;
	case 2:
	  show_arrow(column,"down");
	  gtk_tree_sortable_set_sort_column_id (sortable,treestuff->sort_column,GTK_SORT_DESCENDING);
	  break;
    }
    lastcolumn=column;
    red=FALSE;
}


