/* basic_row.i: static functions for basic_row.c */
/*
 * Copyright (C) 2004 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*static gchar *icon_theme=NULL;*/

static gboolean set_size_icons(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    set_icon(treemodel,  iter);
    return FALSE;
}


static 
void 
free_column_values(	GtkTreeModel * treemodel,
			GtkTreeIter *iter)
{
#if 0
    //no longer needed, makes no difference now...
    gchar *old_text;
    int i,text_columns[]={
       NAME_COLUMN,
       MODE_COLUMN, 
       DATE_COLUMN, 
       GROUP_COLUMN, 
       OWNER_COLUMN, 
       SIZE_COLUMN, 
       -1
    };
    for (i=0; text_columns[i] != -1; i++) {
	gtk_tree_model_get (treemodel, iter, text_columns[i], &old_text, -1);
	g_free(old_text);
    }
#endif
}


 

static 
void 
erase_children(		GtkTreeModel * treemodel, 
			GtkTreeIter * target)
{
    GtkTreeIter iter;
    if(gtk_tree_model_iter_n_children(treemodel, target) < 1) return;
    while(gtk_tree_model_iter_children(treemodel, &iter, target))
    {
	erase_children(treemodel, &iter);
	free_column_values(treemodel,&iter);
	free_entry(treemodel,&iter,NULL);
	gtk_tree_store_remove((GtkTreeStore *) treemodel, &iter);
    }
    return;
}

static 
void
blank_column_values(	GtkTreeModel * treemodel,
			GtkTreeIter *iter)
{
    gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
	PIXBUF_COLUMN, NULL, 
	STYLE_COLUMN, PANGO_STYLE_NORMAL, 
	NAME_COLUMN, (""), 
	SIZE_COLUMN,(""),
	DATE_COLUMN,(""),
	OWNER_COLUMN,(""),
	GROUP_COLUMN,(""),
	MODE_COLUMN,(""),
	-1);
}

static
gboolean 
update_row_full(	GtkTreeModel * treemodel, 
		        GtkTreeIter * target, 
			record_entry_t * en,
			gboolean new_row)
{
    struct group *g;
    struct passwd *p;
    const gchar *grupo=NULL, *owner=NULL, *tag=NULL, *mode_s=NULL, *date_s=NULL;
    gboolean is_editable=FALSE;

    if (!en || !target){
	g_warning("(!en || !target) not met");
	return FALSE;
    }
  
    if (!new_row) {
	int i,w[]={
	    MODE_COLUMN,
	    DATE_COLUMN,
	    GROUP_COLUMN,
	    OWNER_COLUMN,
	    SIZE_COLUMN,
	    -1};
	for (i=0; w[i] > 0; i++){
	    gchar *old_text;
	    gtk_tree_model_get (treemodel, target, w[i], &old_text, -1);
	    g_free(old_text);
	}
    }

    if (en->module) {
	tag = function_natural("plugins",en->module,en,"size_column_string");
	owner = function_natural("plugins",en->module,en,"owner_column_string");
	grupo = function_natural("plugins",en->module,en,"group_column_string");
	date_s = function_natural("plugins",en->module,en,"date_column_string");
	mode_s = function_natural("plugins",en->module,en,"mode_column_string");
    }
    
    if (!tag && en->st){
      if(IS_DIR(en->type)) {
	 en->count = count_files(en->path);
	 tag = sizetag((off_t)-1, en->count);
      } else if(IS_FILE(en->type))  {
	  tag = sizetag((off_t)en->st->st_size, -1);
      }
    }

    
    if (!grupo && en->st){
     if(IS_DIR(en->type) || IS_FILE(en->type) ){
      if((g = getgrgid(en->st->st_gid)) != NULL){
	grupo = g->gr_name;
      } else {
	static gchar *g = NULL;
	g_free(g);
	g=g_strdup_printf("%d",(int)en->st->st_gid);
	grupo = g;
      }
     }
    }
     
    
    if (!owner && en->st){
      if((p = getpwuid(en->st->st_uid)) != NULL){
	owner = p->pw_name;
      } else {
	static gchar *g = NULL;
	g_free(g);
	g = g_strdup_printf("%d",(int)en->st->st_uid);
	owner = g;
      }
    }
    
    if (!mode_s && en->st) mode_s=mode_string(en->st->st_mode);
    if (!date_s && en->st) date_s=(gchar *)my_utf_string(time_to_string(en->st->st_mtime));
    if (!date_s) date_s="";

    
    if (!tag) tag="";
    if (!grupo) grupo="";
    if (!owner) owner="";
    if (!mode_s) mode_s="";

    gtk_tree_store_set((GtkTreeStore *) treemodel, target, 
	MODE_COLUMN, mode_s, 
	DATE_COLUMN, date_s, 
	GROUP_COLUMN, grupo, 
	OWNER_COLUMN, owner,
	SIZE_COLUMN, tag, 
	-1);
    
    /* tag editable rows */
    if (getenv("XFFM_DISABLE_CELL_EDIT") && strlen(getenv("XFFM_DISABLE_CELL_EDIT")));
    else is_editable=IS_PATH(en->type);
    
    gtk_tree_store_set((GtkTreeStore *) treemodel, target,
	EDITABLE_COLUMN,is_editable,
	-1);
    /* don't forget colors */
    switch_colors(treemodel, NULL, target, en);

    return TRUE;
}


static 
void 
add_row_info(	GtkTreeModel *treemodel, 
		GtkTreeIter * iter, 
		record_entry_t * en, 
		gchar *name)
{
    
    if(strcmp(name, "..Wastebasket") == 0 ){
	name = _("Wastebasket");
    }
    gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
		    NAME_COLUMN, (my_utf_string(name)), 
		    ENTRY_COLUMN, (gpointer) en, 
		    STYLE_COLUMN, PANGO_STYLE_NORMAL, 
		    -1);

    if(IS_NODE(en->type))
    {
	insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
    }
    
    update_row_full(treemodel, iter, en, TRUE); /* the other columns... */    
    set_icon(treemodel,iter);
   
    /* row text colours */
    if (!g_utf8_validate (en->path,-1,NULL)){
	set_row_colours(treemodel, iter, NULL,INVALID_UTF8_COLOR);
    }
    else if (IS_TOP_BOOKMARK(en->subtype)) {
	set_row_colours(treemodel, iter, NULL, BOOKMARK_COLOR);	
    } else if (IS_TRASH_TYPE(en->type)) {
	set_row_colours(treemodel, iter, NULL, TRASH_COLOR);	
    } else if (IS_DIR(en->type)||IS_XF_NETSHARE(en->subtype)||IS_NETDIR(en->subtype)) {
	set_row_colours(treemodel, iter, NULL, DIR_COLOR);
    } else if(IS_EXE(en->type)) {
        set_row_colours(treemodel, iter, NULL, EXEC_COLOR);
    } else if(IS_XF_SOCK(en->type)) {
	set_row_colours(treemodel, iter, NULL, SOCK_COLOR);
    } else if(IS_XF_FIFO(en->type)) {
	set_row_colours(treemodel, iter, NULL, PIPE_COLOR);
    } else if(IS_DIR(en->type) && FSTAB_is_in_fstab(en->path)) {
	set_row_colours(treemodel, iter, NULL, FSTAB_COLOR);
    }	
    return;
}




