static GSList *ppid_list=NULL;
static GSList *ps_list=NULL;
static GtkWidget *private_popup_widget=NULL;
static 
void
open_proc(GtkMenuItem *m, gpointer data){
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    GError *error=NULL;
    const gchar *cmd;
    int tree = GPOINTER_TO_INT(data);
    switch (tree){
	case 1:
	    cmd="xffm-treeview / xffm_proc";
	    break;
	default:
	    cmd="xffm-iconview / xffm_proc";
    }
    g_spawn_command_line_async (cmd,&error);
    if (error) {
	print_diagnostics(widgets_p,"xffm/error",error->message,"\n",NULL);
	g_error_free(error);
    }
    usleep(500);
    xffm_refresh(widgets_p);
    return;
}


static 
void
proc_nice(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    if (!en || !en->st) return;
    if (fork()){
	gchar pid[64];
	gchar ni[64];
	sprintf(pid,"%d",(int)en->st->st_uid);
	sprintf(ni,"+%d",(int)en->st->st_ctime+1);
	execlp("renice","renice",ni,"-p",pid,NULL);
	_exit(123);
    }
    usleep(500);
    xffm_refresh(widgets_p);
    return;
}
static 
void
proc_reload(GtkMenuItem *m, gpointer data){
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    xffm_refresh(widgets_p);
    return;
}

static 
void
proc_signal(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    int sig=GPOINTER_TO_INT(g_object_get_data(G_OBJECT(m),"signal"));
    if (!en || !en->st || !sig) return;
    kill((pid_t)en->st->st_uid, sig);
    xffm_refresh(widgets_p);
    return;
}

static
void
dialog_pipe(gchar *ps,widgets_t *widgets_p){
    FILE *pipe;
    TRACE(ps);
    show_text(widgets_p);
    pipe = popen(ps, "r");
    if(pipe) {
	gchar line[256];
	memset(line,0,256);
	while (fgets(line, 255, pipe)){
	    print_diagnostics(widgets_p,NULL,line,NULL);
	}
	pclose(pipe);	
    } else {
	gchar *g=g_strdup_printf("%s: %s",strerror(EINVAL),ps);
	print_diagnostics(widgets_p,"xffm/error",g,"\n",NULL);
	g_free(g);
    }	
}

static 
void
proc_info(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    gchar *ps;
    if (!en || !en->st) return;
#ifdef  HAVE_BSD_L
    ps=g_strdup_printf("ps lp %u",(unsigned)en->st->st_uid);
#else
#ifdef HAVE_UNIX_LY
    ps=g_strdup_printf("ps -lyp %u",(unsigned)en->st->st_uid);
#else 
    ps=g_strdup_printf("ps -lp %u",(unsigned)en->st->st_uid);
#endif
#endif
    dialog_pipe(ps,widgets_p);   
    return;
}
static 
void
proc_tree(GtkMenuItem *m, gpointer data){
    gchar *ps;
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
#ifdef  HAVE_BSD_XF
    if (en->subtype & ALL_PROCS) ps=g_strdup_printf("ps axf");
    else ps=g_strdup_printf("ps xf");
#else
#ifdef HAVE_UNIX_JH
    if (en->subtype & ALL_PROCS) ps=g_strdup_printf("ps -jHe");
    else ps=g_strdup_printf("ps -jHU %u",getuid()); ps=g_strdup_printf("ps -jHe");
#endif
#endif
    show_text(widgets_p);
    print_diagnostics(widgets_p,"xffm/stock_yes",ps,"\n",NULL);
    dialog_pipe(ps,widgets_p);   
    return;
}

static 
void
proc_set(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    int flag=GPOINTER_TO_INT(g_object_get_data(G_OBJECT(m),"flag"));
    en->subtype ^= flag;
    xffm_refresh(widgets_p);
    return;
}

static
void *
private_name_column_title(void)
{
    return (void *)_("COMMAND");
}
static
void *
private_size_column_title(void)
{
#ifdef HAVE_UNIX_O_RSS
    return (void *)_("RSS");
#else 
    return (void *)_("VSZ");
#endif
}
static
void *
private_date_column_title(void)
{
    return (void *)_("TIME");
}
static
void *
private_owner_column_title(void)
{
    return (void *)_("PID:NI");
}
static
void *
private_group_column_title(void)
{
    return (void *)_("PPID:PGID");
}
static
void *
private_mode_column_title(void)
{
    return (void *)_("%CPU");
}

static
void *
private_date_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");

    g_free(tag);
    tag=g_strdup_printf("%02d:%02d:%02d",
	    (int)(en->st->st_mtime/3600),
	    (int)((en->st->st_mtime%3600)/60),
	    (int)((en->st->st_mtime%3600)%60)
	    );
    return tag;
/*    return NULL;*/
}
static
void *
private_size_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");

    if (!p) return ("");
    g_free(tag);
    tag=g_strdup_printf("%d",(int)en->st->st_size);
    return tag;
}
static
void *
private_group_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");
    g_free(tag);
    tag=g_strdup_printf("%d:%d",(int)en->st->st_gid,(int)getpgid((pid_t)en->st->st_uid));
    return tag;
}

static
void *
private_owner_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");

    g_free(tag);
    tag=g_strdup_printf("%d:%d",(int)en->st->st_uid,(int)en->st->st_ctime);
    return tag;
}

static
void *
private_mode_column_string(void * p){
    static gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) {
	return ("");
    }

    g_free(tag);
    tag=g_strdup_printf("%d%%",(int)en->st->st_mode);
    return tag;
}


