/*   
  *   *  
 *  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

static GList *mastersIP=NULL;
static void *resolve_object=NULL;
static gboolean lookup_done;
static xfdir_t smb_xfdir;


/***************  master resolve segment  *************************/
typedef struct master_t {
	char *master_name;
	char *master_netbios;
	char *master_group;
	char *master_IP;
	int   master_status;
} master_t;
static master_t *master_p=NULL;
static char **all_IP;

#define RESOLVED 	0x01
#define NOT_RESOLVED	0x0

static
int 
smb_stderr(int n, void *data, void *user_data)
{
    widgets_t *widgets_p=user_data;
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(widgets_p,"xffm/error", line, NULL);
    return TRUE;
}


static void 
NMBmastersResolveOver (pid_t pid, void *user_data){
    widgets_t *widgets_p=user_data;
    GList *tmp;
    for (tmp=mastersIP; tmp && tmp->data; tmp=tmp->next){
	 gchar *g;
	  master_t *mp=(master_t *)tmp->data;
	 if (mp->master_status == RESOLVED) {
		g=g_strdup_printf(_("Resolved %s"),mp->master_name);
    	    	print_status(widgets_p,"xffm/info", g, NULL);
	 }
	 else {
		g=g_strdup_printf(_("Not resolved %s"),mp->master_IP);
    	    	print_status(widgets_p,"xffm/warning", g, NULL);
	 }
	 g_free(g);
    }

    resolve_object=NULL;
}

static int 
NMBparseMastersResolve (int n, void *data, void *user_data){
    widgets_t *widgets_p=user_data;
    GList *tmp;
  char *line;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics(widgets_p,NULL,line,NULL);

  for (tmp=mastersIP; tmp && tmp->data; tmp=tmp->next){
      master_t *mp=(master_t *)tmp->data;
      if (strstr(line, mp->master_IP)) {
	      master_p=mp;
	      break;
      }
  }
  if (!master_p || !master_p->master_IP) {
	  TRACE("!master_p || !master_p->master_IP");
	  return TRUE;
  }
  /* apparently <00> is used by more stuff than netbios
   * name, such as a netbios services like databases
   * or whatever. We now switch to <20> to determine
   * netbios name.*/
  if (strstr (line, "<00>")) {
	 if (strstr (line, "<GROUP>")){ /* workgroup name */
 	     strtok (line, " ");
	     g_free(master_p->master_group);
	     master_p->master_group=g_strdup(line + 1);
	 } 
  }
  if (strstr (line, "<20>")) {
	 /* server name */
	     g_free(master_p->master_netbios);
	     g_free(master_p->master_name);
 	     strtok (line, " ");
	     if (strncmp(line+1,"IS~",strlen("IS~"))==0) {
	       master_p->master_netbios=g_strdup(line + 1+strlen("IS~"));
	       master_p->master_name=g_strdup(line + 1+strlen("IS~"));
	     } else {
	       master_p->master_netbios=g_strdup(line + 1);
	       master_p->master_name=g_strdup(line + 1);
	     }
  	     master_p->master_status=RESOLVED;	     
  }
  return TRUE;
}


static gboolean 
NMBmastersResolve (widgets_t *widgets_p){
  char **arg;
  gchar *g;
  GList *tmp;
  int c;
  if (!all_IP || !*all_IP) {
	g_warning("!all_IP || !*all_IP");
	return FALSE;
  }
  

  
  arg=(char **)malloc((g_list_length(mastersIP)+2+1)*sizeof(char *));
  memset(arg,0,(g_list_length(mastersIP)+2+1)*sizeof(char *));
  
  *arg=  "nmblookup";
  *(arg+1)=  "-A";
  for (c=2,tmp=mastersIP; tmp && tmp->data; tmp=tmp->next,c++){
	  master_t *mp=(master_t *)tmp->data;
	  *(arg+c) = mp->master_IP;
  }
 
  print_diagnostics(widgets_p,NULL, "XFSAMBA> ","nmblookup -A ",NULL);
  for (tmp=mastersIP; tmp && tmp->data; tmp=tmp->next){
	  master_t *mp = (master_t *)tmp->data;
	  print_diagnostics(widgets_p,NULL, mp->master_IP,NULL);
  }
  print_diagnostics(widgets_p,NULL,"\n", NULL);
  
  g=g_strdup_printf(_("Resolving %s"), "...");
  print_status(widgets_p,"xffm/info", g,NULL);
  master_p=NULL;
  resolve_object=Tubo_full (fork_function, 
	(void *)arg, 
	NMBmastersResolveOver, 
	NULL, 
	NMBparseMastersResolve, 
	smb_stderr,widgets_p,
	15);
  
  
  return FALSE;
}


/***************  master lookup segment  *************************/

/* Look up the subnet master browsers, it fails for win95 master
 * browsers, but that's ok. */


static void
resolve_mastersIP(widgets_t *widgets_p){
      print_status(widgets_p,"xffm/info",_("Master browser found"),NULL);
      NMBmastersResolve (widgets_p);
      while (resolve_object) {
	      usleep(5000);
	      set_progress_generic(widgets_p,-1,-1,1);
	      while (gtk_events_pending()) gtk_main_iteration();
      }
}

static void 
populate_xfdir(widgets_t *widgets_p){
  	GList *tmp=NULL;
	int master_count;
	smb_xfdir.pathc = g_list_length(mastersIP);
       	smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	for (master_count=0,tmp=mastersIP; tmp && tmp->data; master_count++,tmp=tmp->next){
	  master_t *mp=(master_t *)tmp->data;
	  print_diagnostics(widgets_p,NULL,mp->master_netbios," -> ",mp->master_group,"\n",NULL);
  	  smb_xfdir.gl[master_count].en=mk_entry(0);
  	  SET_NETWORK_TYPE(smb_xfdir.gl[master_count].en->type);
	  SET_XF_NETWG(smb_xfdir.gl[master_count].en->subtype);
  	  smb_xfdir.gl[master_count].pathv=g_strdup(mp->master_group);
	  smb_xfdir.gl[master_count].en->path=
		     (char *)malloc(strlen(mp->master_netbios)+strlen("smb://")+1);
	  sprintf(smb_xfdir.gl[master_count].en->path,"smb://%s",mp->master_netbios);
	  smb_xfdir.gl[master_count].en->st=(struct stat *)malloc(sizeof(struct stat));
	  smb_xfdir.gl[master_count].en->st->st_size=0;
	  smb_xfdir.gl[master_count].en->st->st_mtime=time(NULL);
	  smb_xfdir.gl[master_count].en->st->st_ctime=time(NULL);
	  smb_xfdir.gl[master_count].en->st->st_gid=(gid_t)-1;
	  smb_xfdir.gl[master_count].en->st->st_uid=(uid_t)-1;
	  smb_xfdir.gl[master_count].en->st->st_mode=S_IFDIR;
	  SET_XF_NETWG(smb_xfdir.gl[master_count].en->subtype);
	  SET_XF_NODE(smb_xfdir.gl[master_count].en->type);	
	}
}

static void
NMBmastersForkOver (pid_t pid, void *user_data)
{
  	char **a;
  	GList *tmp=NULL;
  	widgets_t *widgets_p=user_data;
  
  	if (!mastersIP){
    	  print_status(widgets_p,"xffm/error", _("No master browser found."),NULL);
    	  lookup_done=TRUE;
    	  return;
  	}
       	a = all_IP = (char **)malloc((g_list_length(mastersIP) + 1 ) * sizeof (char *));
       	memset(a,0,(g_list_length(mastersIP) + 1 ) * sizeof (char *));
       	for (tmp=mastersIP; tmp && tmp->data; tmp = tmp->next){
	    master_t *mp=(master_t *)tmp->data;
	  print_diagnostics(widgets_p,NULL,"IP>",mp->master_IP,"\n",NULL);
	    *a=mp->master_IP;
	    a++;
       	}
	show_text(widgets_p);
	resolve_mastersIP(widgets_p);
       	lookup_done=TRUE;
       	g_free(all_IP);
	populate_xfdir(widgets_p);
	print_diagnostics(widgets_p,NULL,"-----------\n",NULL);
	
	return;
}

static int
NMBmastersParseLookup (int n, void *data, void *user_data)
{
  widgets_t *widgets_p=user_data;
  char *line, *buffer;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics(widgets_p,NULL,line,NULL); /* verbose diagnostics */
  if (!strncmp (line, "querying", strlen ("querying")))
	  return TRUE;
  if (strstr (line, "name_query") 
		  && strstr (line, "failed") 
		  && strstr (line, "__MSBROWSE__")){
          return TRUE;
  }
  if (strstr (line, "__MSBROWSE__") && strstr (line, "<01>")) {
    GList *tmp;
    master_t *mp;
    buffer = strtok (line, " ");
    if (!buffer) return TRUE;
    for (tmp=mastersIP;tmp;tmp=tmp->next){
	gchar *g=tmp->data;
	if (strcmp(g,buffer)==0) return TRUE;
    }
    mp = (master_t *)malloc(sizeof(master_t));
    memset (mp,0,sizeof(master_t));
    mp->master_IP = g_strdup(buffer);
    mp->master_name = g_strdup(mp->master_IP);
    mp->master_netbios = g_strdup(mp->master_IP);
    mp->master_group = g_strdup_printf("foo-%s",mp->master_IP);
//	hide_text(widgets_p->diagnostics);
    mastersIP = g_list_append (mastersIP,mp);
  }
  return TRUE;
}

static
void 
free_data(gpointer data,gpointer user_data){
	g_free((char *)(data));
	data=NULL;
}


static
xfdir_t *
private_get_xfdir(widgets_t *widgets_p, record_entry_t *en){
  char *argument[5];
  

  smb_xfdir.pathc=0;
  argument[0]=  "nmblookup";
  argument[1]=  "-M";
  argument[2]=  "--";
  argument[3]=  "-";
  argument[4]=  0;

  if (mastersIP && !g_file_test(get_local_cache_path(en->path),G_FILE_TEST_EXISTS)){
	g_list_foreach(mastersIP,free_data,NULL);
      	g_list_free(mastersIP);
	mastersIP=NULL;
  }
  
  if (mastersIP){
	populate_xfdir(widgets_p);
	return &smb_xfdir;
  }
  show_text(widgets_p);
  print_diagnostics(widgets_p,NULL, _("Looking for master browsers...\n"), NULL);  
  print_diagnostics(widgets_p,NULL,NULL,"XFSAMBA> ","nmblookup -M -- -\n",NULL);
  lookup_done=FALSE;
  
  
  Tubo_full (fork_function, 
	(void *)argument,
	NMBmastersForkOver, 
	NULL, 
	NMBmastersParseLookup, 
	smb_stderr,widgets_p,15);
  

  while (!lookup_done){
	usleep(5000);
	 set_progress_generic(widgets_p,-1,-1,1);
	while (gtk_events_pending()) gtk_main_iteration();
  }
    hide_text(widgets_p->diagnostics);
    fclose(fopen(get_local_cache_path(en->path),"w"));
    
    return &smb_xfdir;
}


