/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*******************************************************
 * This plugin has extra functionality available only
 * for the treeview (or detailed) GUI. The iconview
 * version is simpler. Just collects trash automatically
 * and allows user to browse wastebaskets. To collect
 * trash from other places, or to toggle autotrash
 * collection and other functions, treeview GUI
 * must be used. Such functions are too complex
 * for iconview usage. End of story.
 * ****************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"

#include "trash.h"
#include "tubo.h"


#include "ls.h"

#include "trash.i"

G_MODULE_EXPORT
LIBXFFM_MODULE

G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}


/****************   void  functions  ***********************/

G_MODULE_EXPORT
void *
module_label(void){
    return _("Trash");
}

G_MODULE_EXPORT
void *
module_name(void){
    return "xffm_trash";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffm-trash";
}

G_MODULE_EXPORT
xftrash_functions *module_init(void){
    xftrash_fun = g_new0 (xftrash_functions,1);
    if (!xftrash_fun) g_assert_not_reached();
    xftrash_fun->collect_trash=collect_trash;
    xftrash_fun->add2trash=add2trash;
    xftrash_fun->count_trash=count_trash;
    xftrash_fun->collect_trash_callback=collect_trash_callback;
    xftrash_fun->uncollect_trash_callback=uncollect_trash_callback;
    xftrash_fun->uncollect_from_trash_callback=uncollect_from_trash_callback;
    xftrash_fun->delete_all_trash=delete_all_trash;
    xftrash_fun->trash_background_purge=trash_background_purge;
    return xftrash_fun;
}

G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The TRASH plugin allows you to keep wastebaskets for trash in the directories where the trash is generated, allowing for easy recovery. The plugin also keeps tabs of all generated wastebaskets and allows management from a central location.");
}


/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xffm-trash.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
const gchar *
module_icon_id(void *p){
    return "xffm-trash.png";
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (IS_PATH(en->type)) return (void *)"Yes";
    
    return NULL;
}

G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return NULL;
    if(IS_DIR(en->type)) return (void *)((long)1);
    return NULL;
}

/*******************  rational functions **********************/


G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    widgets_t *widgets_p=q;
    return private_get_xfdir(widgets_p, en);
}

