#ifndef __PREFERENCES_I__
#define __PREFERENCES_I__

#include <gdk/gdkkeysyms.h>

/* keep first five elements unaltered. (needed by quick_hide()) */
preferences_t opt_col_titles[]={
	    {N_("Show main menu"),"SHOW_MM",SHOW_MM,GDK_F1},
	    {N_("Show navigation toolbar"),"SHOW_TB1",SHOW_TB1,GDK_F2},
	    {N_("Show file toolbar"),"SHOW_TB2",SHOW_TB2,GDK_F3},
	    {N_("Show filter"),"SHOW_F",SHOW_F,GDK_F4},
	    {N_("Show column titles"),"SHOW_TITLES",SHOW_TITLES,GDK_F5},
	    {N_("Show sizes"),"SHOW_SIZE",SHOW_SIZE,GDK_F6},
	    {N_("Show dates"),"SHOW_DATE",SHOW_DATE,GDK_F7},
	    {N_("Show owner"),"SHOW_UID",SHOW_UID,GDK_F8},
	    {N_("Show group"),"SHOW_GID",SHOW_GID,GDK_F9},
	    {N_("Show permissions"),"SHOW_MODE",SHOW_MODE,GDK_F11},
	    {NULL,NULL,0,0}
};

static preferences_t opt_view_titles[]={
	    {N_("Icon view"),"ICON_VIEW",ICON_VIEW,0},
	    {N_("Default view"),"DEFAULT_VIEW",DEFAULT_VIEW,0},
	    {N_("Small view"),"SMALL_VIEW",SMALL_VIEW,0},
	    {N_("Detailed view"),"DETAILED_VIEW",DETAILED_VIEW,0},
	    {NULL,NULL,0,0}
};

static preferences_t opt_remote_titles[]={
	    {N_("rsh before ssh"),"RSH_X_SSH",RSH_X_SSH,GDK_R},
	    {N_("scp before rsync"),"RSYNC_X_SCP",RSYNC_X_SCP,GDK_S},
	    {NULL,NULL,0,0}
};


static preferences_t preferences_titles[]={
	    {N_("Autoscroll"),"AUTOSCROLL",AUTOSCROLL,GDK_A},
	    {N_("Copy on drag"),"DRAG_DO_COPY",DRAG_DO_COPY,GDK_C},
	    {N_("Show Hidden"),"SHOW_DOT",SHOW_DOT,GDK_H},
	    {N_("Filetype subsorting"),"FILETYPE_SUBS",FILETYPE_SUBS,GDK_F},
	    {N_("Image auto-previews"),"IMAGE_PREVIEW",IMAGE_PREVIEW,GDK_I},
	    {N_("Monitor enabled"),"ENABLE_MONITOR",ENABLE_MONITOR,GDK_M},
#if 0
	    {N_("One click drag mode"),"ENABLE_GTK_CLICK",ENABLE_GTK_CLICK,GDK_O},
	    {N_("Resize fonts to match icons"),"ENABLE_RESIZE_FONTS",ENABLE_RESIZE_FONTS,GDK_R},
#endif
	    {N_("Disable auto trash collection"),"ENABLE_AUTO_T",ENABLE_AUTO_T,GDK_T},
	    {N_("Invisible Wastebaskets"),"HIDE_WASTE_B",HIDE_WASTE_B,GDK_W},
	    {NULL,NULL,0,0}
    };
static preferences_t opt_branches_titles[]={
	    {N_("Book"),"ACTIVATE_BOOK",ACTIVATE_BOOK,GDK_B},
	    {N_("Local"),"ACTIVATE_LOCAL",ACTIVATE_LOCAL,GDK_L},
	    {N_("SMB Network"),"ACTIVATE_SMB",ACTIVATE_SMB,GDK_N},
	    {N_("Applications"),"ACTIVATE_APPS",ACTIVATE_APPS,GDK_P},
	    {N_("Trash"),"ACTIVATE_TRASH",ACTIVATE_TRASH,GDK_U},
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	    {N_("Fstab"),"ACTIVATE_FSTAB",ACTIVATE_FSTAB,GDK_Y},
#endif
	    {NULL,NULL,0,0}
    };

#endif
