/* Copyright 2005 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/
/*
 * must think about what is necessary and what not, to keep
 * the application fast and light. No duplication of ways to do
 * things. Only one way will be present. That means, either a toolbar
 * or a menu. 
 * */

#define XFFM_GRIDVIEW_C

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#ifdef HAVE_LIBSM
#include <X11/SM/SMlib.h>
#endif
#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif



#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gmodule.h>
#include <dbh.h>

#include "types.h"
#include "constants.h"

#include "primary.h"
#include "secondary.h"

#include "gridview_lib.h"
#include "gridview_input.h"
#include "gridview_popup.h"

#include "actions_lib.h"


/* this is one small file for one small library ... */

static GList *iconview_list=NULL;

#include "gridview.h"

/* primary gridview stuff (for setup and basic navigation) */
#include "gridview-graphics.i"
#include "gridview-menu.i"
#include "gridview-callbacks.i"
#include "gridview-roots.i"
#include "gridview-population.i"
#include "gridview-monitor.i"
#include "gridview-main.i"

G_MODULE_EXPORT
GtkWidget *create_gridview(	int argc, gchar *argv[])
{
    icon_view_t *icon_view_p;
    int win;
    int type=__LOCAL_TYPE|__ROOT_TYPE;
    record_entry_t *en=NULL;
    gboolean ok=FALSE;
    

    xffm_details->geometryX=440;
    xffm_details->geometryY=350;

    if (argc >=1 ) for (win=1; win<argc; win+=2){
	if (strncmp(argv[win],"--",strlen("--"))==0) continue;
	en=mk_entry(type);
	en->path=g_strdup(argv[win]);
		
	if (argc >= win+1 && argv[win+1] && strcmp(argv[win+1],"null")){
	    if (function_void("plugins",argv[win+1],"module_name")){
		icon_view_p=create_iconview(en);
		icon_view_p->module_name=argv[win+1];
		icon_view_p->submodule_name=function_void("plugins",argv[win+1],"submodule_name");
		en->module = icon_view_p->module_name;
		TRACE("en->module = %s",en->module);
		ok=TRUE;
		reload_iconview(icon_view_p,en,TRUE);
	    }	    
	    else {
		TRACE("no module by name of %s",argv[win+1]);
	    }
	} 	
	else { /* local business */
	    TRACE(" multiple fish fry");
	    en->path=startup_path(argv[win]);
		if (!en->path && strcmp(argv[win],"null")!=0) {
		    g_warning("%s does not exist",en->path);
		    destroy_entry(en);
		    en=NULL;
		}
		icon_view_p=create_iconview(en);	    
		ok=TRUE;
		reload_iconview(icon_view_p,en,TRUE);
	}
    } else {
	    TRACE(" no fish fry");
	icon_view_p=create_iconview(en);	    
	reload_iconview(icon_view_p,en,TRUE);
	ok=TRUE;
    }
    DBG("%s",profile());
    if (!ok){
	/* single fish fry */
	TRACE(" single fish fry");
	icon_view_p=create_iconview(en);	    
	DBG("create_iconview(24,1): %s",profile());
	reload_iconview(icon_view_p,en,TRUE);
	DBG("reload_iconview(8,0): %s",profile());
    }
    gridview_monitor(NULL);
    return icon_view_p->widgets.window;

#if 0
    if (argc >= 2){
        if (!en){
	    en=mk_entry(type);
	    en->path=g_strdup(argv[1]);
	}
    }
    icon_view_p=create_iconview(en);
    if (argc >= 3){
	if (function_void("plugins",argv[2],"module_name")){
	    icon_view_p->module_name=argv[2];
	    icon_view_p->submodule_name=function_void("plugins",argv[2],"submodule_name");
	    en->module = icon_view_p->module_name;
	    TRACE("en->module = %s",en->module);
	}
    }
   
    /*{
	record_entry_t *en;
	en=stat_entry(g_get_home_dir(),0);
	reload_iconview(icon_view_p,en);
    }*/
    if (en) TRACE("<<<<<<<<<<<<<< reloading %s",en->path);
    enable_write_config();
    reload_iconview(icon_view_p,en,FALSE);
    gridview_monitor(NULL);
    return icon_view_p->widgets.window;
#endif
    
}


G_MODULE_EXPORT
int select_all_iconview(icon_view_t *icon_view_p){
    population_t **population_pp;
    int items=0;
    if (!icon_view_p || !icon_view_p->en) return items;
    population_pp = icon_view_p->population_pp;
    for (;population_pp && *population_pp; population_pp++){
	if ((*population_pp)->en == NULL) continue;
	if (IS_DUMMY_TYPE((*population_pp)->en->type)) continue;
	items++;
	saturate_pixbuf(icon_view_p,*population_pp);
	select_pixbuf(icon_view_p,*population_pp);	
    }
    icon_view_p->saturated_p=NULL;
    return items;
}

G_MODULE_EXPORT
void unselect_all_iconview(icon_view_t *icon_view_p){
    cursor_wait(icon_view_p->widgets.window);
    unselect_all_pixbuf(icon_view_p);	
    unsaturate_pixbuf(icon_view_p);
    cursor_reset(icon_view_p->widgets.window);
}

G_MODULE_EXPORT
int select_byfilter_iconview(icon_view_t *icon_view_p, const gchar *select_filter){
    population_t **population_pp;
    const regex_t *preg;
    gchar *g;
    int items=0;
    if (!icon_view_p || !icon_view_p->en) return items;
    if (!select_filter || !strlen(select_filter)) return items;
    cursor_wait(icon_view_p->widgets.window);
    preg = compile_regex_filter(select_filter,SHOWS_HIDDEN(icon_view_p->en->type));   
    unselect_all_pixbuf(icon_view_p);	
    unsaturate_pixbuf(icon_view_p);
    population_pp = icon_view_p->population_pp;
    for (;population_pp && *population_pp; population_pp++){
	gchar *f;
	if ((*population_pp)->en == NULL) continue;
	if ((*population_pp)->en->path == NULL) continue;
	if (IS_DUMMY_TYPE((*population_pp)->en->type)) continue;
	f=g_path_get_basename((*population_pp)->en->path);
	TRACE("regexec %s => %s",select_filter,f);
	if (regexec(preg, f, 0, NULL, 0)) {
	    g_free(f);
	    continue;
	}
	g_free(f);
	items++;
	saturate_pixbuf(icon_view_p,*population_pp);
	select_pixbuf(icon_view_p,*population_pp);
    }   
    cursor_reset(icon_view_p->widgets.window);
    g=g_strdup_printf(_("%d item(s) selected"), items);
    print_status(&(icon_view_p->widgets),"xfce/info",g,NULL);
    g_free(g);
    return items;
}


G_MODULE_EXPORT
void push_iconview_go_history(icon_view_t *icon_view_p){
    record_entry_t *history_en;
    if (!icon_view_p->en || !icon_view_p->en->path) return;
    if (icon_view_p->go_list) {
	GList *last=g_list_last(icon_view_p->go_list);
	record_entry_t *last_en;
	if (!last) return;
	last_en=last->data;
        if (strcmp(last_en->path,icon_view_p->en->path)==0) return;
    }
    history_en=copy_entry(icon_view_p->en);
    icon_view_p->go_list = g_list_append(icon_view_p->go_list,history_en);
    return;
}

G_MODULE_EXPORT
void pop_iconview_go_history(icon_view_t *icon_view_p){
    GList *last;
    if (!icon_view_p->go_list) return;
    last=g_list_last(icon_view_p->go_list);
    if (!last) {
	g_list_free(icon_view_p->go_list);
	icon_view_p->go_list=NULL;
	return;
    }
    icon_view_p->go_list=g_list_remove(icon_view_p->go_list,last->data);
    if (!g_list_length(icon_view_p->go_list)){
	g_list_free(icon_view_p->go_list);
	icon_view_p->go_list=NULL;
	return;
    }
    return;
}

G_MODULE_EXPORT
int
gridview_set_icon(icon_view_t *icon_view_p, record_entry_t *en){
    int i;
    for (i=0; i<icon_view_p->max_elements && icon_view_p->population_pp[i]; i++)
    {
	population_t *population_p=icon_view_p->population_pp[i];
	if (en && population_p->en == en){
	    if (population_p->normal_pixbuf)
		g_object_unref(G_OBJECT(population_p->normal_pixbuf)); 
	    if (population_p->selected_pixbuf)
		g_object_unref(G_OBJECT(population_p->selected_pixbuf)); 
	    population_p->pixbuf = population_p->normal_pixbuf = get_icon (&(icon_view_p->widgets),population_p->en,icon_view_p->en);
	    if (population_p->normal_pixbuf){
		population_p->selected_pixbuf = gdk_pixbuf_copy (population_p->normal_pixbuf);

		gdk_pixbuf_saturate_and_pixelate(population_p->selected_pixbuf,population_p->selected_pixbuf,-8.0,TRUE); 
		population_p->pixbufW=gdk_pixbuf_get_width((const GdkPixbuf *)population_p->normal_pixbuf);
		population_p->pixbufH=gdk_pixbuf_get_height((const GdkPixbuf *)population_p->normal_pixbuf);
	    } else {
		population_p->pixbufW=ICON_SIZE;
		population_p->pixbufH=ICON_SIZE;
	    }

	    graphics_expose_item(icon_view_p,
		    (icon_view_p->population_pp[i])->row,
		    (icon_view_p->population_pp[i])->column);
	    TRACE("%s : %s (%d,%d) type=0x%x",((IS_CUT(en->type))?"CUT":"UNCUT"),en->path,
		    (icon_view_p->population_pp[i])->row,
		    (icon_view_p->population_pp[i])->column,
		    (icon_view_p->population_pp[i])->en->type);
	    return 1;
	}
    }
    return 0;
}
