/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gmodule.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>


#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"
#include "treeview.h"


extern gboolean dragging;

#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))
typedef struct scrolltree_t
{
    GtkTreeView *treeview;
    gint scrolly;
    gint scrollheight;
}
scrolltree_t;

#include "treeview_dnd.i"

G_MODULE_EXPORT
void treeview_update_status_line (record_entry_t *en){
    if (!xffm_details->arbol->widgets.window){
	g_warning("treeview_update_status_line");
	return;
    }
    if (en && en->path) {
        gchar *readable_path=g_path_get_basename(en->path);
	print_status_pixbuf(&(xffm_details->arbol->widgets),resolve_icon_small(&(xffm_details->arbol->widgets),en),readable_path,NULL);
    	g_free(readable_path);
	/*printf("TRACE: item is=%s\n", en->path);*/
    } 	
    else print_status(&(xffm_details->arbol->widgets),NULL,"",NULL);
}

G_MODULE_EXPORT
void treeview_clear_dnd_selection_list(void)
{
    GList *tmp;
    
    if (!xffm_details->arbol->widgets.window) return;
    tmp = xffm_details->selection_list;
    if (dragging) return;
    /*printf("TRACE: clearing selection list!\n");*/
    while(tmp)
    {
	selection_list_t *sl;
	sl = (selection_list_t *) tmp->data;
	if(sl->reference)
	    gtk_tree_row_reference_free(sl->reference);
	g_free(sl);
	sl=NULL;
	tmp = tmp->next;
    }
    if(xffm_details->selection_list!=NULL)
    {
	g_list_free(xffm_details->selection_list);
	xffm_details->selection_list = NULL;
    }
    
    xffm_details->selection_list = NULL;
}


G_MODULE_EXPORT
void treeview_get_dnd_selection (GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    record_entry_t *en;
    if (!xffm_details->arbol->widgets.window) return;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!IS_PATH(en->type) && !IS_NETTHING(en->subtype) ) return;
    
    if (!IS_LOCAL_TYPE(en->type) && IS_ROOT_TYPE(en->type)) return;
    
    if (en && en->path) {
	selection_list_t *sl;
	GList *tmp;
	for (tmp=xffm_details->selection_list;tmp;tmp=tmp->next){
	    sl = (selection_list_t *)tmp->data;
	    if (strcmp(sl->en->path,en->path)==0) return;
	}
	sl = (selection_list_t *) malloc(sizeof(selection_list_t));
	if(!sl) assert_not_reached();
	sl->en = en;
	sl->reference = gtk_tree_row_reference_new(treemodel, path);
	xffm_details->selection_list = g_list_append(xffm_details->selection_list, sl);
	
	
	TRACE("TRACE:treeview_get_dnd_selection() added to selection list=%s\n",en->path);
    } 
    return;
}
#ifdef DEBUG
void the_sl (void)
    {
	selection_list_t *sl;
	GList *tmp;
	printf("****************************\n");
	for (tmp=xffm_details->selection_list;tmp;tmp=tmp->next) {
	    sl = (selection_list_t *)tmp->data;
	    printf("-> %s\n",sl->en->path);
	}
    }
#endif 

G_MODULE_EXPORT
void treeview_setup_drag_signal (GtkTreeView * treeview)
{
   
    g_signal_connect(G_OBJECT(treeview), "drag_data_received", G_CALLBACK(treeview_on_drag_data), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_data_get", G_CALLBACK(treeview_on_drag_data_get), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_motion", G_CALLBACK(treeview_on_drag_motion), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_end", G_CALLBACK(treeview_on_drag_end), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_begin", G_CALLBACK(treeview_on_drag_begin), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag-leave", G_CALLBACK(treeview_on_drag_leave), NULL);
#if 0
    this signal looks bugged in gtk.only works well forsame widget.segv otherwise g_signal_connect(G_OBJECT(treeview), "drag_data_delete", G_CALLBACK(on_drag_data_delete), NULL);
#endif

    /*
     * DO NOT put gtk_drag_source_set here. It is very buggy if you do.
     * Instead set at first mouse click and unset on expand+contract
     * (inherent GtkCTree bug workaround) [This is a gtk1.2 note,
     * this may or may not apply in gtk2.]
     * gtk_drag_source_set (ctree, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, 
     target_table, NUM_TARGETS, 
     GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);*/
    treeview_drag_source_set(treeview);	/*this location might need change */

    /*  this kind of dnd is useful to rearrange the order of the root nodes: */
    /*
       gtk_tree_view_enable_model_drag_source(treeview, 
       GTK_DEST_DEFAULT_DROP|GTK_DEST_DEFAULT_HIGHLIGHT, 
       target_table, 
       NUM_TARGETS, 
       GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK
       ); */


    gtk_drag_dest_set((GtkWidget *) treeview, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, target_table, sizeof(target_table) / sizeof(*target_table), GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

}

