/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>



#include <gtk/gtk.h>

#include "types.h"
#include "constants.h"

#include "primary.h"
#include "secondary.h"
#include "treeview.h"
#include "xmcs-manager.h"

extern
xffm_details_t *xffm_details;

G_MODULE_EXPORT
gboolean enable_pane_resize=FALSE;


static
gboolean on_xffm_destroy_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    /* treeview only */
    gtk_widget_hide(xffm_details->arbol->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    gui_on_close_activate(NULL,NULL );
    return FALSE;
}

static
gboolean on_xffm_delete_event(GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
    /* treeview only */
    gtk_widget_hide(xffm_details->arbol->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    gui_on_close_activate(NULL,NULL );
    return FALSE;
}


static void init_xffm_window(void){
    if((xffm_details->arbol->widgets.window = create_xffm()) == NULL)	assert_not_reached();
    xffm_details->arbol->widgets.type = TREEVIEW_TYPE;
    xffm_details->arbol->widgets.stop=FALSE;
    xffm_details->arbol->widgets.tubo_object = NULL;
    xffm_details->arbol->widgets.parent = xffm_details->arbol;
    xffm_details->arbol->widgets.refresh= treeview_refresh;

    
    xffm_details->arbol->widgets.vpane = lookup_widget(xffm_details->arbol->widgets.window,"vpaned1");
    xffm_details->arbol->widgets.diagnostics = lookup_widget(xffm_details->arbol->widgets.window,"diagnostics");
    xffm_details->arbol->widgets.status = lookup_widget(xffm_details->arbol->widgets.window,"status");
    xffm_details->arbol->widgets.progress = lookup_widget(xffm_details->arbol->widgets.window,"progressbar1");
    parse_colours();
    g_signal_connect(G_OBJECT(xffm_details->arbol->widgets.window), 
		    "destroy_event", G_CALLBACK(on_xffm_destroy_event), (gpointer) xffm_details);
    g_signal_connect(G_OBJECT(xffm_details->arbol->widgets.window), 
		    "delete_event", G_CALLBACK(on_xffm_delete_event), (gpointer) xffm_details);
    hideit(xffm_details->arbol->widgets.window, "item22");
    hide_stop(&(xffm_details->arbol->widgets));
    hide_text(xffm_details->arbol->widgets.diagnostics);
    hideit(xffm_details->arbol->widgets.window, "input_box");
    /* XXX does this "activates-default" do anything??? */
    g_object_set(G_OBJECT (lookup_widget(xffm_details->arbol->widgets.window,"combo_entry2")), "activates-default", TRUE, NULL);
    g_object_set(G_OBJECT (lookup_widget(xffm_details->arbol->widgets.window,"input_entry")), "activates-default", TRUE, NULL);
 
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"show_hidden_menuitem")), "activate", 
			    GTK_SIGNAL_FUNC(toggle_preference),
			    (gpointer) ((long)(SHOW_DOT|INDIVIDUAL_TOGGLE)));
    g_signal_connect(G_OBJECT(lookup_widget(xffm_details->arbol->widgets.window,"preview_images_menuitem")), "activate", 
			    GTK_SIGNAL_FUNC(toggle_preference),
			    (gpointer) ((long)(IMAGE_PREVIEW|INDIVIDUAL_TOGGLE)));
     /* main window configuration: */
    if (xffm_details->preferences & SHOW_TB1) toolbar_buttons();
#ifdef USE_TOOLBAR_PANEL    
    if (xffm_details->preferences & SHOW_TB2) parse_panel_config();
#endif

    smart_menus();
  

}


G_MODULE_EXPORT
void fireup_treeview(int argc,gchar **argv)
{
    GtkTreeView *treeview;
    int i;
   
   init_xffm_window(); /* tree window...*/


    
    init_xffm_treeviews(argc, argv); /* initialize treeviews */

    
    treeview = get_bigger_treeview();
    if (!strstr(xffm_details->argv[0],"xfglob")) 
        gtk_widget_show((GtkWidget *)(xffm_details->arbol->widgets.window));
    else 
        gtk_widget_realize((GtkWidget *)(xffm_details->arbol->widgets.window));
   
    hide_text(xffm_details->arbol->widgets.diagnostics);

    /* final column settings until here to get around a gtk bug (2.2.4)
     * with the autosize column not rendering... 
     *
     * but by now i'm giving up on the autosize mode since it is 
     * buggy, and moving to grow only (user resize==true) to allow the user
     * to correct the display problem caused by the gtk-native bug
     * 
     * (now will make fixed length for xfglob and align to right to
     * put full paths in)
     * 
     * */
    for (i=0;i<TREECOUNT;i++){
      treestuff_t *treestuff = (xffm_details->arbol->treestuff)+i;	
      treestuff->ascending = 0;
      treestuff->sort_column = GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
       
      gtk_tree_view_column_set_sizing(treestuff->column[NAME_COLUMN], GTK_TREE_VIEW_COLUMN_FIXED);
      gtk_tree_view_column_set_resizable(treestuff->column[NAME_COLUMN], TRUE);
      TRACE("TRACE:setting width to %d\n",treestuff->name_size);
      gtk_tree_view_column_set_fixed_width(treestuff->column[NAME_COLUMN],treestuff->name_size);

      gtk_tree_view_column_set_sizing(treestuff->column[PIXBUF_COLUMN], GTK_TREE_VIEW_COLUMN_AUTOSIZE);
      gtk_tree_view_column_set_resizable(treestuff->column[PIXBUF_COLUMN], TRUE);
      /*gtk_tree_view_column_set_sizing(treestuff->column[PIXBUF_COLUMN], GTK_TREE_VIEW_COLUMN_AUTOSIZE);
      gtk_tree_view_column_set_resizable(treestuff->column[PIXBUF_COLUMN], FALSE);*/
    }

    hide_bars();
    enable_pane_resize=TRUE;
    
    set_widget_initial_state();
    turn_on_pasteboard();
    
    
  
    {
	GtkWidget *hpaned=lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
	if (!strstr(xffm_details->argv[0],"xffm")) xffm_details->arbol->hpane=0;
	TRACE("pane size to %d\n",xffm_details->arbol->hpane);
	gtk_paned_set_position(GTK_PANED(hpaned), xffm_details->arbol->hpane);
	xffm_details->arbol->hpane_ratio = (double)xffm_details->arbol->hpane / (double)hpaned->allocation.width;
    } 

    
    treeview_clear_dnd_selection_list();
    /* program name other than xffm or xfglob will trigger an expand */
    if (!strstr(xffm_details->argv[0],"xfglob")) {
      GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
      /*GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);*/
      GtkTreePath *treepath=gtk_tree_path_new_first();
      if (treepath) {
	gtk_tree_selection_select_path (selection,treepath);
	/*get_dnd_selection(treemodel, treepath, &iter, (gpointer) treeview);*/
	gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
	if (!strstr(xffm_details->argv[0],"xffm")) {
	      gtk_tree_view_expand_row(treeview, treepath, FALSE);  
     	      gdk_flush();
	      gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
	}
	set_path_reference(treeview,treepath);
	gtk_tree_path_free(treepath); 
      }
      else TRACE("Cannot find root element for %s", xffm_details->argv[0]); 
    }
    


   for (i=0;i<TREECOUNT;i++){
     GtkTreeSortable *sortable=GTK_TREE_SORTABLE(xffm_details->arbol->treestuff[i].treemodel);
     xffm_details->arbol->treestuff[i].sort_column =GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
     gtk_tree_sortable_set_sort_column_id (sortable,xffm_details->arbol->treestuff[i].sort_column,GTK_SORT_ASCENDING);
   }

   turn_on();
   enable_write_config();
    
   write_xffm_config();

   gtk_widget_grab_focus((GtkWidget *) treeview);
      
   xffm_details->comm=0;

    if (strstr(xffm_details->argv[0],"xffm"))
	gtk_window_set_title (GTK_WINDOW (xffm_details->arbol->widgets.window), 		g_strdup(OUR_HOST_NAME(&(xffm_details->arbol->widgets))));
	
#if 10
    if (strstr(xffm_details->argv[0],"xfglob")) {
	if (argc >= 2) FIND_do_find_path((GtkWidget *) treeview,argv[1]);
	else FIND_do_find((GtkWidget *) treeview);

	hideit(xffm_details->arbol->widgets.window,"hbox27");
	hideit(xffm_details->arbol->widgets.window,"box_tb1");
	hideit(xffm_details->arbol->widgets.window,"eventbox_sidebar");
	gtk_tree_view_set_headers_visible(treeview,TRUE);
	showit(xffm_details->arbol->widgets.window,"show_titles");
	/* XXX: function returns before find is done, so
	* we should not unload here, but later. 
	* Can a gmodule unload itself when done? */
	/*unload_find_module();*/
    }
#endif

    return ;
}


