
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __MENU_C__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <glob.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h" 

#include "treeview.h"

#include "actions_lib.h"

#include "treeview_preferences.i"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)


/* keep first five elements unaltered. (needed by quick_hide()) */
G_MODULE_EXPORT
preferences_t opt_col_titles[]={
	    {N_("Show sizes"),"SHOW_SIZE",SHOW_SIZE|INDIVIDUAL_TOGGLE,GDK_F1},
	    {N_("Show dates"),"SHOW_DATE",SHOW_DATE|INDIVIDUAL_TOGGLE,GDK_F2},
	    {N_("Show owner"),"SHOW_UID",SHOW_UID|INDIVIDUAL_TOGGLE,GDK_F3},
	    {N_("Show group"),"SHOW_GID",SHOW_GID|INDIVIDUAL_TOGGLE,GDK_F4},
	    {N_("Show permissions"),"SHOW_MODE",SHOW_MODE|INDIVIDUAL_TOGGLE,GDK_F5},
	    {NULL,NULL,0,0}
};

G_MODULE_EXPORT
preferences_t opt_view_titles[]={
	    {N_("Icon view"),"ICON_VIEW",ICON_VIEW,0},
	    {N_("Default view"),"DEFAULT_VIEW",DEFAULT_VIEW,0},
	    {N_("Small view"),"SMALL_VIEW",SMALL_VIEW,0},
	    {N_("Detailed view"),"DETAILED_VIEW",DETAILED_VIEW,0},
	    {NULL,NULL,0,0}
};


#if JUST_TRANSLATE_THIS_STOOPID
static gchar *xxx[]={
    	    N_("Local"),
	    N_("Book"),
	    N_("Default book"),
	    N_("SMB Network"),
	    N_("Fstab"),
	    N_("Recent"),
	    N_("Frequent"),
	    N_("Trash"),
	    NULL
};
#endif


static gchar *always_show[]={
    "refresh3",
    "select_all_menuitem",
    "unselect_all_menuitem",
    "iv_separator0",
    "find2",
    "about2",
    "exit2",
    NULL
};

static gchar *multiple_selection[]={
    "cut_menuitem",
    "copy_menuitem",
    "remove_menuitem",
    "properties2",
    "popup_disk_usage_menuitem",
    NULL
};

static gchar *trash_menu_stuff[]={
    "collect_trash1_menuitem",
    NULL
};

static gchar *file_menu_stuff[]={
    /*"duplicate_menuitem",*/
    "symlink_menuitem",
    "touch_menuitem",
    "rename_menuitem",
    "print_menuitem",
    "scramble_menuitem",
    "unscramble_menuitem",
    NULL
};

#if 0  
static gchar *book_menu_stuff[]={
    "open_book2_menuitem",
    "default_book2_menuitem",
    "new4_menuitem",
    "save_book2_menuitem",
    "purge_bookmarks1_menuitem",
    NULL
};
#endif
  
static gchar *popup_menu_stuff[]={
    "refresh3",
    "select_all_menuitem",
    NULL
};

static gchar *path_selection[]={
    "iv_separator_cut", 
    "cut_menuitem",
    "copy_menuitem",

    /* FIXME: the following two should be insensitive if invalid pasteboard, 
     * should also test since no longer a directory must be target, 
     * but plain path. Check also in widgets...*/
    "pastelink_menuitem",   
    "paste_menuitem", 
    
    "remove_menuitem",
    "properties2",
    
    "iv_separator_single_selections",
    "file1",
	"print_menuitem",
	"duplicate_menuitem",
	/*"symlink_menuitem",
	"touch_menuitem",
	"rename_menuitem",
	"scramble_menuitem",
	"unscramble_menuitem",*/
    "popup_disk_usage_menuitem",
    NULL
};

static gboolean invalid_input;
static gboolean local_stuff;
static gboolean remote_stuff;
static gchar *remote_pass=NULL;
static gchar *remote_location=NULL;
static GList *unselect_list=NULL;
static gboolean is_recent_selection,is_frequent_selection;



G_MODULE_EXPORT
void set_sense (int which,gboolean state)
{
    gchar **p;
    if (which==0) p=trash_menu_stuff;
    else if (which==1) p=file_menu_stuff;
    else if (which==3) p=popup_menu_stuff;
    else {
	g_warning("p==NULL");
	return;
    }
    for (;*p;p++){
	GtkWidget *w=lookup_widget(xffm_details->arbol->widgets.window,*p);
	gtk_widget_set_sensitive(w,state);
    }
}

G_MODULE_EXPORT
void
change_sort_column (GtkButton     *button, gpointer         user_data)
{
    int tree_id=get_relative_tree_id();
    int column_id;
    column_id=(int)((long)user_data);
    
    xffm_details->arbol->treestuff[tree_id].ascending--;
    on_column_click(
	    xffm_details->arbol->treestuff[tree_id].column[column_id],
	    xffm_details->arbol->treestuff[tree_id].treeview);
}


static gboolean anything_selected=FALSE;
static void check_select(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    record_entry_t *en;
   
    anything_selected=TRUE;
       gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en) return;   
/*    GtkTreeRowReference *reference;*/

    if(!en || IS_DUMMY_TYPE(en->type)){		    
         GtkTreeRowReference *reference=
		 gtk_tree_row_reference_new(model,path);
	 unselect_list = g_list_append(unselect_list, reference);    
	 return;
    }	
    //if (IS_RECENT_TYPE(en->type)) is_recent_selection=TRUE;    
    if (IS_PATH(en->type)) local_stuff=TRUE;
    if(IS_NETTHING(en->subtype)||IS_NETWORK_TYPE(en->type)){
	remote_stuff=TRUE;
	if (IS_NETDIR(en->subtype)||IS_NETFILE(en->subtype)||
			IS_XF_NETSHARE(en->subtype)){
	   gchar *server_pass=g_strdup(en->tag);
	   gchar *location=g_strdup(en->path);
	   if (local_stuff){
		   invalid_input=TRUE;
		   return;
	   }
	   if (!strchr(location+2,'/')) assert_not_reached();
	   strtok(strchr(location+2,'/')+1,"/");
	   /*printf("TRACE:location=%s\n",location);*/
	   if (!location || !strlen(location)) assert_not_reached();
   	   if (!remote_location)remote_location=location;
	   else {
	     if (strcmp(remote_location,location)!=0)invalid_input=TRUE;
	     g_free(location);location=NULL;
	   }
   	   if (!remote_pass)remote_pass=server_pass;
	   else {
	     if (strcmp(remote_pass,server_pass)!=0)invalid_input=TRUE;
	     g_free(server_pass);server_pass=NULL;
	   }
	}
    }
    if (local_stuff&&remote_stuff){
	   invalid_input=TRUE;
	   return;
    }
    xffm_details->arbol->selectionOK++;
    return;
}

static void show_group(GtkWidget *popup, gchar **p){
    int i;
    for (i=0; *(p+i); i++){
	  showit(xffm_details->arbol->widgets.window,*(p+i));
    }
}


G_MODULE_EXPORT
void set_menu_context (void){
    gint tree_id = get_relative_tree_id();
    GtkTreeView *treeview=xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    
    anything_selected=FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    set_column_menu(tree_id);
}

// only for treeview:::

G_MODULE_EXPORT
void do_main_popup (const gchar *name,gint32 t){
    GtkWidget  *popup;
    if(xffm_details->arbol->loading) return;

    set_menu_context();
    popup = lookup_widget(xffm_details->arbol->widgets.window,name);
    if (!lookup_widget(xffm_details->arbol->widgets.window,"ejecutar1")){
	gui_add_autotype_C_widgets(&(xffm_details->arbol->widgets), NULL, lookup_widget(xffm_details->arbol->widgets.window,"item22_menu"),treeview_autotype_C, treeview_mount, treeview_unmount);
    }
    gtk_widget_show_all(popup);
    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, 0);
}

G_MODULE_EXPORT
gboolean  popup_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
   if( event->button != 3) return FALSE;
   do_main_popup("main_menu2_menu",event->time);
   return TRUE;
}

 
G_MODULE_EXPORT
gboolean  column_button_press_event (GtkWidget *event_box,  GdkEventButton *event, gpointer user_data) {
    /*g_print ("Event box clicked at coordinates %f,%f\n", event->x, event->y);*/
    gint tree_id=(gint)((long)user_data);
   if( event->button != 3) return FALSE;
   set_relative_tree_id(tree_id);
   set_column_menu(tree_id); /* does branch menu too...*/
   do_main_popup("columns1_menu",event->time);
   return TRUE;
}



G_MODULE_EXPORT
void do_select_popup (GtkTreeView * treeview,  GtkTreePath *selectpath,gint32 t)
{
    GtkWidget *widget, *popup;
    GtkTreeIter iter;
    record_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    int tree_id = get_tree_id(treeview);

    if(xffm_details->arbol->loading) return;
    popup = lookup_widget(xffm_details->arbol->widgets.window,"item22_menu");
    if (!lookup_widget(xffm_details->arbol->widgets.window,"ejecutar1")){
	gui_add_autotype_C_widgets(&(xffm_details->arbol->widgets), NULL, lookup_widget(xffm_details->arbol->widgets.window,"item22_menu"),treeview_autotype_C, treeview_mount, treeview_unmount);
    }
    invalid_input=FALSE;
    local_stuff=FALSE;
    remote_stuff=FALSE;
    remote_pass=NULL;
    remote_location=NULL;    
    xffm_details->arbol->selectionOK=0;
    is_frequent_selection=is_recent_selection=FALSE;

    
    anything_selected=FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    check_select, (gpointer) treeview);
    while (unselect_list){
	    GtkTreeRowReference *ref=(GtkTreeRowReference *)unselect_list->data;
	    GtkTreePath *tpath=gtk_tree_row_reference_get_path(ref);
	    gtk_tree_selection_unselect_path(selection,tpath);
    	    unselect_list = g_list_remove(unselect_list, ref);
	    gtk_tree_path_free(tpath);
	    gtk_tree_row_reference_free(ref);	    
    }
    gtk_widget_hide_all(popup);
    

    set_sense(0,TRUE);/* trash */
    set_sense(1,TRUE);/* file */
    set_sense(3,TRUE);/* popup */
    
    show_group(popup,always_show);
    
    set_relative_tree_id(tree_id);

    

    if (invalid_input || xffm_details->arbol->selectionOK==0){
	set_sense(3,FALSE);
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
    }

    /* something selected */
    
    if (xffm_details->arbol->selectionOK > 1){
	show_group(popup,multiple_selection);
	if (is_frequent_selection) showit(xffm_details->arbol->widgets.window, "undo_frequent");
	if (is_recent_selection) showit(xffm_details->arbol->widgets.window, "undo_recent");
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
   }
    
	    /* single item selected */	    
    gtk_tree_selection_unselect_all(selection);
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_select_path(selection, selectpath);
    gtk_tree_model_get_iter(treemodel, &iter, selectpath);
    gtk_tree_selection_select_iter(selection, &iter);
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);

    if (en ) {
	GtkTreeIter parent;
	record_entry_t *p_en;
	if (function_rational("plugins",en->module,(void *)(en),&(xffm_details->arbol->widgets),"private_popup"))
	{
	    TRACE("private popup is shortcircuited from callbacks");
	    return;
	}	
	if (gtk_tree_model_iter_parent(treemodel, &parent, &iter)){
	    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
	    if (p_en && p_en->module) {
		if (function_rational("plugins",p_en->module,(void *)(en),&(xffm_details->arbol->widgets),"private_popup"))
		{
		    TRACE("fixme: private module popup goes here.");
		    return;
		}		
		gui_mk_module_popup_menu(&(xffm_details->arbol->widgets),p_en->module,NULL,p_en);
		TRACE("module popup menu added.");
	    }
	}
    }

	    
    if (IS_PATH(en->type)) {
	showit(xffm_details->arbol->widgets.window, "duplicate_menuitem");
	if (!IS_DIR(en->type)) showit(xffm_details->arbol->widgets.window, "print_menuitem");
    }
   
    if(!en){
 	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
	return;
    }
	
    showit(xffm_details->arbol->widgets.window,"hide_branch_menuitem");
    if (IS_ROOT_TYPE(en->type)) {
	if(IS_FIND_TYPE(en->type)) showit(popup, "clear_all_results_menuitem"); 
	if(IS_TRASH_TYPE(en->type)) {
	    showit(xffm_details->arbol->widgets.window, "delete_all_trash1_menuitem"); 
	    showit(xffm_details->arbol->widgets.window, "uncollect_trash1_menuitem"); 
	}
    }

    enable_refresh_by_toggle(FALSE);
    print_status(&(xffm_details->arbol->widgets), resolve_icon_id(en),  FILENAME(en), NULL);

    /* turn on/off toolbar buttons... */
    turn_on();

    if (IS_NETTHING(en->subtype)){
        showit(xffm_details->arbol->widgets.window, "copy_menuitem");
        showit(xffm_details->arbol->widgets.window, "remove_menuitem");
	
        showit(xffm_details->arbol->widgets.window, "iv_separator00");
        showit(xffm_details->arbol->widgets.window, "show_hidden_menuitem");
        showit(xffm_details->arbol->widgets.window, "paste_menuitem"); 
	if (IS_NETFILE(en->subtype)) {
	    gui_autostuff(&(xffm_details->arbol->widgets), NULL, popup,en,treeview_autotype_C, treeview_mount, treeview_unmount);
	}
	if (IS_XF_NETSHARE(en->subtype)){
	      showit(xffm_details->arbol->widgets.window, "mountP");
	}
    }
    
    if(IS_FIND_TYPE(en->type) && !IS_ROOT_TYPE(en->type)) {
	showit(xffm_details->arbol->widgets.window, "remove_from_results_menuitem");	    
    }	    
    if(IS_PATH(en->type)){
	int mounted;
	show_group(popup,path_selection);
	
	if (strrchr(en->path,'/') && IS_IMAGE(strrchr(en->path,'/')))
			showit(xffm_details->arbol->widgets.window,"preview_this_image_menuitem");
	
	widget = lookup_widget(xffm_details->arbol->widgets.window,"show_hidden_menuitem");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_HIDDEN(en->type));
	widget = lookup_widget(xffm_details->arbol->widgets.window,"preview_images_menuitem");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(widget), 
			SHOWS_IMAGES(en->type));
        showit(xffm_details->arbol->widgets.window, "iv_separator00");
	showit(xffm_details->arbol->widgets.window, "show_hidden_menuitem");
	showit(xffm_details->arbol->widgets.window, "preview_images_menuitem");
	    
	
	if (function_void("plugins","xffm_fstab","is_root_module")) {
	 mounted=GPOINTER_TO_INT(FSTAB_is_mounted(en->path));
	 if (IS_DIR(en->type) && FSTAB_is_in_fstab(en->path))
	 {
	  if (mounted>=0){
	      if (mounted) showit(xffm_details->arbol->widgets.window, "unmountP");
	      else showit(xffm_details->arbol->widgets.window, "mountP");
	  } else {
	      if (IS_MOUNTED(en->type)) showit(xffm_details->arbol->widgets.window, "unmountP");
	      else showit(xffm_details->arbol->widgets.window, "mountP");
	  }
	 }
	 else if (mounted){
	    showit(xffm_details->arbol->widgets.window, "unmountP");
	 }
	}
	
	if (IS_DIR(en->type) && !IS_TRASH_TYPE(en->type)){
	    showit(xffm_details->arbol->widgets.window, "collect_trash1_menuitem"); 
	}
#if USE_XFALL || USE_SCRAMBLEDIR
	if (!IS_PATH(en->type))
#else
	if (IS_DIR(en->type)|| !IS_FILE(en->type))
#endif
	{
	  gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"scramble_menuitem"),FALSE);
	  gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"unscramble_menuitem"),FALSE);
	} 
	else 
#if USE_XFALL || USE_SCRAMBLEDIR
	   if (IS_DIR(en->type)) 
	     gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"unscramble_menuitem"),TRUE);
	   else
			
#endif
	{
	    gchar *p=strrchr(en->path,'.');
	    if (!p || strcmp(p,".cyt")!=0) {
		gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"scramble_menuitem"),TRUE);
		gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"unscramble_menuitem"),FALSE);
	    }
	    else {
		gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"unscramble_menuitem"),TRUE);
		gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"scramble_menuitem"),FALSE);
	    }
	}
	    
	/* mutually exclusive conditions: */
	if(IS_TRASH_TYPE(en->type)) showit(xffm_details->arbol->widgets.window, "uncollect_from_trash_menuitem");
	gui_autostuff(&(xffm_details->arbol->widgets), NULL, popup,en,treeview_autotype_C, treeview_mount, treeview_unmount);
	/* gray out stuff that wont work anyways: */
	if(IS_BROKEN_LNK(en->type)) {
	    set_sense(1,FALSE);/* file */
	    set_sense(4,FALSE);/* auto_C */
	}
	    
    }
    

    gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, t);
			/*event->time);*/
    enable_refresh_by_toggle(TRUE);
    return;
}
	
	

G_MODULE_EXPORT
void do_popup (GtkTreeView * treeview, GdkEventButton * event)
{
    GtkTreePath *selectpath;
    if (gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, &selectpath, NULL, NULL, NULL)) do_select_popup(treeview,  selectpath,event->time);
}

G_MODULE_EXPORT
void
hide_branch_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    record_entry_t *en;
    GtkTreeIter child;
    GtkTreeIter parent;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    
    en = treeview_get_selected_entry(&child);
    while (1){
	if (!gtk_tree_model_iter_parent(treemodel, &parent, &child)){
	    parent=child;
	    break;
	}
	else child=parent;
    }
    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &en, -1);
    remove_row(treemodel, &parent, NULL, en);
    
}

G_MODULE_EXPORT
void
on_tools_menu                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gint tree_id = get_active_tree_id();
   GtkTreeIter iter;
   record_entry_t *en;
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    gboolean trash=find_module_root(treeview,&iter,&en,"xffm_trash");
    gboolean find=find_module_root(treeview,&iter,&en,"xffm_find");
    if (trash){
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"collect_trash1"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"uncollect_all_trash1"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"delete_all_trash2"), 
			TRUE);
    } else {
 	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"collect_trash1"), 
			FALSE);
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"uncollect_all_trash1"), 
			FALSE);
			
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"delete_all_trash2"), 
			FALSE);
    }
    if (find) {
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"clear_find_results1"), 
			TRUE);
    } else {
	gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"clear_find_results1"), 
			FALSE);
    }
}
G_MODULE_EXPORT
void
on_set_menu_context                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    set_menu_context();
}


