/*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "primary.h"
#define EXPAND      TRUE
#define FILL        TRUE
#define NOEXPAND    FALSE
#define NOFILL      FALSE

#include "password_dialog.i"

G_MODULE_EXPORT
const gchar *xffm_get_password(widgets_t *widgets_p,const gchar *ptext){
    const gchar *p;
    g_free(password);
    password=NULL;
    p=passwd_dialog (widgets_p, 11,NULL,ptext);
    if (p && strchr(p,'%')) p = strchr(p,'%')+1;
    return p;
}

G_MODULE_EXPORT
const gchar *xffm_get_smbuserpass(widgets_t *widgets_p,record_entry_t *en){
    const gchar *p;
    const gchar *u=NULL;
    /* browse password: */
    if (en && en->tag && strlen(en->tag)){
        u=en->tag;
    } else {
        if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))){
	   u=getenv("SMB_USER");
        }
    }
    p=passwd_dialog (widgets_p, 1,u,NULL);
    return p;
}


