
// FIXME (treeview and iconview types should be moved
//        to their respective parent libraries on cleanup day)
#ifndef __XFFM_TYPES_H__
#define __XFFM_TYPES_H__
#include <gtk/gtk.h>
#include <time.h>
#include <sys/types.h>

typedef struct preferences_t {
  char *label;
  char *xml_option;
  int  flag;
  gint key;
} preferences_t;

#define TREEVIEW_TYPE 0x01
#define ICONVIEW_TYPE 0x02
#define DESKVIEW_TYPE 0x04

typedef struct widgets_t { /* 4.3.2.4 */
    guint		type;
    gint 		input;
    gboolean		stop;
    void		*tubo_object;
    void 		*parent;
    gpointer		data;

    GtkWidget 		*window;
    GtkWidget 		*remove;
    GtkWidget 		*diagnostics;
    GtkWidget 		*status;
    GtkWidget 		*progress;
    GtkWidget 		*vpane;
    GtkWidget 		*stop_button;
    GtkWidget 		*clear_button;

    gint		(*refresh)(struct widgets_t *widgets_p);
    
    void		*combo_info;
    void		*filter_combo_info;
} widgets_t;

typedef struct record_entry_t	/* was: record_entry_t */ 
{
    gint type;			
    gint subtype;
    gint count;		        /* only for directories */
    struct stat *st;
    gchar *tag;
    gchar *path;
    gchar *icon;	/* for desktop entries */
    gchar *exec;	/* for desktop entries */
    gchar *filter;		/* filter for directories, path for trash */
    const gchar *module;	/* module name, or NULL for local files */
    off_t checksum;		/* only for directories */
    time_t load_time;
}
record_entry_t;

typedef struct dir_t
{
    char *pathv;		/* matched pathname.  */
    record_entry_t *en;

}
dir_t;


typedef struct xfdir_t
{
    size_t pathc;		/* Count of paths matched */
    dir_t *gl;
}
xfdir_t;



/****************************************************************/
/*  XXX iconview types: move these to gui/iconview/iconview_types.h
 *  for next branch (4.3.2.5) and privy to gridview_lib
 ****************************************************************/

typedef struct population_t {
    int row;
    int column;
    record_entry_t *en;
    int pixbufW;
    int pixbufH;
    GdkPixbuf *pixbuf;
    GdkPixbuf *normal_pixbuf;
    GdkPixbuf *saturated_pixbuf;
    GdkPixbuf *selected_pixbuf;
    gboolean selected;
    PangoLayout *layout;
    PangoRectangle logical_rect;
    PangoLayout *layout2;
    PangoRectangle logical_rect2;
} population_t;

typedef struct icon_view_t {
    widgets_t widgets;
    int grid_rows;
    int grid_columns;
    int grid_area;
    int max_elements;
    int selection_count;
    int preferences;
    gint paperX;
    gint paperY;
    gdouble mouseX;
    gdouble mouseY;
    int old_X;
    int old_Y;
    int down_X;
    int down_Y;
    int drag_button;
    population_t **population_pp;
    population_t *doing_drag_p;
    population_t *saturated_p;
    population_t *label_p;
    population_t *selected_p;
    GdkColormap *cmap;
    GdkGC *penGC;  
    record_entry_t *en;
    GList *population_list;
    GList *selection_list;
    GList *go_list;
    GtkWidget *paper;
    GtkWidget *rename;
    GtkWidget *popup;
    GtkTooltips *tips;
    int tip_timer;
    double vpane_ratio;
    GdkEventDND drag_event;
    GtkScrolledWindow *scrolled_window;
    int hot_x;
    int hot_y;
    gboolean dragstate;
    const gchar *module_name;
    const gchar *submodule_name;
    int sortcolumn;
    gboolean redlight;
    gboolean redlight2;
    gboolean stop;
    /* public functions */
    void (*double_click_open_with)(record_entry_t *en,struct icon_view_t *icon_view_p);

} icon_view_t;


/****************************************************************/
/*  treeview types: move these to gui/iconview/iconview_types.h
 *  for next branch (4.3.2.5) and privy to treeview_lib
 *  *************************************************************/
typedef struct column_info_t
{
    int id;
    GType type;
}
column_info_t;



typedef struct root_t
{
    int id;
    char *path;
    char *label;
    unsigned int type;
}
root_t;

/* only 2 treeview supported  */
enum
{
    RIGHT_TREEVIEW,
    LEFT_TREEVIEW,
    TREECOUNT
};


typedef struct golist
{
    struct golist *previous;
    struct golist *next;
    char *path;
}
golist;


enum
{
    EMPTY_COLUMN,
    ENTRY_COLUMN,
    STYLE_COLUMN,
    FONT_COLUMN,
    SFONT_COLUMN,
    EDITABLE_COLUMN,
    COLOUR_COLUMN,
    WEIGHT_COLUMN,

    PIXBUF_COLUMN,
    NAME_COLUMN,
    SIZE_COLUMN,
    DATE_COLUMN,
    OWNER_COLUMN,
    GROUP_COLUMN,
    MODE_COLUMN,

    TREE_COLUMNS
};

typedef struct treestuff_t {
    GtkTreeView *treeview;
    GtkTreeModel *treemodel;
    GtkTreeSortable *sortable;
    GtkTreeSelection *selection;

    GtkTreeViewColumn *column[TREE_COLUMNS];
    unsigned preferences;
    golist *gogo;
    gint ascending;
    gint sort_column;
    gint name_size;
}treestuff_t;

typedef struct arbol_t
{
    widgets_t widgets;
    gint  hpane;
    double hpane_ratio;
    /* smart button status */
    GHashTable *smart_hash;
    /* individual treeview information */
    treestuff_t treestuff[TREECOUNT];
    /* process variables */    
    gint selectionOK;
    gboolean loading;
    gchar *sidebar;
    gint relative_one;
    /* public functions usable by plugins: */
    void (*double_click_open_with)(record_entry_t *en);
    int (*get_active_tree_id)(void);
    record_entry_t * (*get_selected_entry)(GtkTreeIter *iter);
    int (*get_module_root)(GtkTreeView * treeview, GtkTreeIter * iter, record_entry_t ** en, const gchar *which);
    void (*hide_branch_activate) (GtkMenuItem *menuitem, gpointer user_data);
    gboolean (*prune_row)(GtkTreeModel *treemodel,GtkTreeIter *iter,GtkTreeRowReference *reference,record_entry_t *en);
    gboolean (*add_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference, GtkTreeIter *child_iter, record_entry_t * child_en, gchar *child_name);
    void (*add_contents_row)(GtkTreeModel *treemodel, GtkTreeIter * iter, xfdir_t * xfdir);
    gboolean (*remove_row)(GtkTreeModel *treemodel,GtkTreeIter *iter,GtkTreeRowReference *reference,record_entry_t *en);

    void (*erase_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference);
    void (*insert_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference, record_entry_t *parent_en, gchar *icon_id, gchar *text);
    void (*reset_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter,GtkTreeRowReference *parent_reference,record_entry_t *parent_en,gchar *icon_id, gchar *text);
    gboolean (*set_load_wait)(void);
    gboolean (*unset_load_wait)(void);
    gboolean (*find_module_root)(GtkTreeView * treeview,GtkTreeIter *iter,  record_entry_t ** en, const gchar *module_name);
    void (*update_icon)(GtkTreeModel * model, GtkTreeIter * iterator);
    void (*set_icon) (GtkTreeModel *treemodel, GtkTreeIter * iterator);
    gint (*local_monitor)(gboolean force);
    gboolean (*get_selectpath_iter)(GtkTreeIter * iter, record_entry_t ** en);

}arbol_t;


enum
{
    /*ROOT_TASKS,*/
    ROOT_BOOKMARKS,
    ROOT_FILES,
    ROOT_NETWORK,
    ROOT_FIND,
    ROOT_TRASH,
    ROOT_FREQUENT,
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    ROOT_FSTAB,
#endif
    ROOT_TAGS
};

typedef struct selection_list_t
{
    record_entry_t *en;
    GtkTreeRowReference *reference;
}
selection_list_t;


/****************************************************************/
/*  main types: 4.3.2.4
 *  *************************************************************/
typedef struct xffm_details_t
{
    arbol_t *arbol;
    icon_view_t *icon_view_p;
    void *gui_p; /* this should be a pointer to the users abstract
		  gui structure (or list of structures, whatever) */
    /* widgets */
    
    /* global options */
    GList *selection_list;
    unsigned preferences;
    gchar *argv[2];
    /* geometric stuff treeview only:*/
    gint  geometryX;
    gint  geometryY;
    /* process variables */
    guint32 eventtime;    
    gchar *pastepath;
    int comm;
    gint timer;
}
xffm_details_t;




/* Two step input stuff */
enum
{
    OTHER_INPUT,
    GOTO_INPUT,
    RUN_INPUT,
    RUN_DOUBLE_CLICK,
    PRINT_INPUT,
    NEW_INPUT,
    NEW_FILE_INPUT,
    NEW_DIR_INPUT,
    RENAME_INPUT,
    DUPLICATE_INPUT,
    SYMLINK_INPUT,
    SCRAMBLE_INPUT,
    UNSCRAMBLE_INPUT,
    WORKDIR_INPUT,
    OPEN_BOOK_INPUT,
    SAVE_BOOK_INPUT,
    NEW_BOOK_INPUT,
    NEW_WIN_INPUT,
    NEW_BOOK_WIN_INPUT,
    NEW_TERM_INPUT,
    FREQUENCY_INPUT,
};

#endif
