/*   master.c: this file contains routines to query and
 *   resolve the master browser(s) on the local subnet. 
 *
 *   It requires the samba suite programs:
 *  smbclient and nmblookup (included in most linux distributions).
 *  
 *  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "tubo.h"

#include "master_lookup.i"

/**********************************************************/
/****************   void  functions  ***********************/

G_MODULE_EXPORT
void *
module_name(void){
    return "xffm_nmb";
}

G_MODULE_EXPORT
void *
submodule_name(void){
    return "xffm_smb_wg";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xfsamba";
}
G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The SMB network plugin queries the SAMBA network for master browsers and allows you see and browse other samba servers, in combination with other SMB plugins");
}


/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xfsamba.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
module_icon_id(void *p){
    return "network";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("SMB Network");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    return NULL;
}


/*******************  rational functions **********************/

G_MODULE_EXPORT
void *
get_xfdir(void *p, void *q){
    record_entry_t *en=(record_entry_t *)p;
    set_private_variables(q);
    return private_get_xfdir(en);
}

