/*
 * Copywrite 2005 Edscott Wilson Garcia
 */


#define __XFFM_MAIN_C__
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif

#include <gtk/gtk.h>
#include <gmodule.h>
#include <dbh.h>


#include "xffm.h"

#ifdef XFFM_TREEVIEW_BINARY
#include "treeview_lib.h"
#endif
#ifdef XFFM_ICONVIEW_BINARY
#include "gridview_lib.h"
#endif
#ifdef XFFM_DESKVIEW_BINARY
#include "deskview_lib.h"
#endif




#include "xmcs-manager.h"


#ifdef HAVE_LIBXFCEGUI4
extern
SessionClient *session_client;
#endif


extern
gchar *xffm_iconpath;

static
int restore_old_histories(void){
    int result=0;
    gchar *old_dir=NULL, *new_dir=NULL;
    gchar *cache_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *config_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);
    /* cache */
    old_dir=g_build_filename(cache_dir,OLD_CACHE,NULL);
    new_dir=g_build_filename(cache_dir,NEW_CACHE,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old cache files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    /* config */
    old_dir=g_build_filename(config_dir,OLD_CONFIG,NULL);
    new_dir=g_build_filename(config_dir,NEW_CONFIG,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old config files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    /* modules */

    old_dir=g_build_filename(cache_dir,OLD_MODULES,NULL);
    new_dir=g_build_filename(cache_dir,NEW_MODULES,NULL);
    if (g_file_test(old_dir,G_FILE_TEST_EXISTS) && !g_file_test(new_dir,G_FILE_TEST_EXISTS)){
	TRACE("moving old module files: %s -> %s",old_dir, new_dir);
	rename(old_dir, new_dir);
	result=1;
    }
    g_free(old_dir);
    g_free(new_dir);

    
    g_free(cache_dir);
    g_free(config_dir);
    return result;
}


static void finishit(int sig)
{
    static gboolean green=TRUE;
    if (!green) return;
    green=FALSE;
    if(sig == SIGUSR1)
    {
	green=TRUE;
	/*g_timeout_add_full(0, 260, (GtkFunction) open_warning, NULL, NULL); */
	return;
    }
    else
    {
	gchar *b=g_path_get_basename(xffm_details->argv[0]);
	/* Query for application to restart on signal */
	gchar *text=g_strdup_printf(_("%s received signal (%d).\n Restart?"),b,sig);
	
	g_warning("xffm: signal %d received. Cleaning up before exiting\n", sig);
	cleanup_tmpfiles();
	
	if (sig == SIGSEGV || sig == SIGHUP) 
	{   
	  if (xffm_confirm(NULL,text,_("No"),_("Restart"))) {
	    execlp(xffm_details->argv[0],xffm_details->argv[0],xffm_details->argv[1],NULL);
	    _exit(1);
	  }
	}
	exit(1);
    }
}

static gboolean setup_dir(gchar *path){
	struct stat st;
	if(stat(path, &st) < 0)
	{
	    if(mkdir(path, 0770) < 0)
	    {
		printf("xffm: cannot write to %s\n", path);
		assert_not_reached();
	    }
	    g_warning ("%s created\n", path);
	    return TRUE;
	}
	return FALSE;
}

static void verify_directories(void){
    gchar *path;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",FALSE);
    path=g_build_filename(xdg_dir,"xffm",NULL);
    setup_dir(path);
    g_free(path);
    
    g_free(xdg_dir);
    xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
        
    path=g_build_filename(xdg_dir,"xffm",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xffm","books",NULL);
    
    path=g_build_filename(xdg_dir,"xffm","histories",NULL);
    setup_dir(path);
    g_free(path);
    
    path=g_build_filename(xdg_dir,"xffm","modules",NULL);
    setup_dir(path);
    g_free(path);
    g_free(xdg_dir);

     return ;
}

static void signal_connections(void)
{
#ifdef HAVE_SIGACTION
	struct sigaction act;
	act.sa_handler = finishit;
	sigemptyset(&act.sa_mask);
#ifdef SA_RESTART
	act.sa_flags = SA_RESTART;
#else
	act.sa_flags = 0;
#endif
	sigaction(SIGHUP,&act,NULL);
	sigaction(SIGINT,&act,NULL);
	sigaction(SIGQUIT,&act,NULL);
	sigaction(SIGABRT,&act,NULL);
	sigaction(SIGBUS,&act,NULL);
	sigaction(SIGSEGV,&act,NULL);
	sigaction(SIGTERM,&act,NULL);
	sigaction(SIGFPE,&act,NULL);
	sigaction(SIGUSR1,&act,NULL);
	sigaction(SIGUSR2,&act,NULL);
#else
	signal(SIGHUP, finishit);
	signal(SIGINT, finishit);
	signal(SIGQUIT, finishit);
	signal(SIGABRT, finishit);
	signal(SIGBUS, finishit);
	signal(SIGSEGV, finishit);
	signal(SIGTERM, finishit);
	signal(SIGFPE, finishit);
	signal(SIGUSR1, finishit);
	signal(SIGUSR2, finishit);
#endif
}

static void xffm_details_init(int argc, char *argv[]) {
    if (xffm_details) return;
    xffm_details = (xffm_details_t *) malloc(sizeof(xffm_details_t));
    memset(xffm_details,0,sizeof(xffm_details_t));
    
    
    xffm_details->argv[0] = g_path_get_basename(argv[0]);
    if (strncmp(xffm_details->argv[0],"lt-",strlen("lt-"))==0){ 
	  xffm_details->argv[0] += strlen("lt-");
    }
    if (argc >=2) xffm_details->argv[1] = g_strdup(argv[1]);
    else xffm_details->argv[1] = NULL;
    xffm_details->preferences = DEFAULT_PREFERENCES;

}

static gboolean version_query(int argc, char *argv[]){
    int i;
    for(i = 0; i < argc; i++){
        if(strcmp(argv[i], "--version") == 0)  {
#ifdef HAVE_LIBXFCEGUI4
	    g_print ("\tThis is %s version %s for Xfce %s\n", 
                    PACKAGE, VERSION, xfce_version_string());
#else
	    g_print ("\tThis is %s version %s\n", 
                    PACKAGE, VERSION);
#endif
	    g_print ("\tbuilt with GTK+-%d.%d.%d, ", 
                    GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
	    g_print ("linked with GTK+-%d.%d.%d.\n", 
                    gtk_major_version, gtk_minor_version, gtk_micro_version);
	    g_print ("\tDBH version-%s, ",DBH_VERSION); 
#ifdef HAVE_RODENT_ICONS
	    g_print ("using Rodent icons as default.\n");
#else
#ifdef HAVE_GNOME_ICONS
	    g_print ("using Gnome icons as default.\n");
#endif
#endif
	    exit (0);
	}
    }
    return FALSE;
}


int main(int argc, char *argv[])
{
    /* do the following before allowing any dynamic library
     * to be loaded to memory (except glib)... */
    if (version_query(argc, argv)) exit(1);
    if (!g_module_supported()){
	    g_error("g_module_supported() != TRUE\n");
	    exit(1);
    }
    restore_old_histories();
    signal_connections();
    TRACE("call to xffm_details_init");
    xffm_details_init(argc, argv);
    
    /***************************************************/
    /* start loading required dynamic libraries here... */  
    verify_directories(); 
#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain(GETTEXT_PACKAGE);
#endif
    gtk_set_locale();
    gtk_init(&argc, &argv);

#ifdef HAVE_LIBXFCEGUI4
    session_client = client_session_new (argc,argv, NULL,SESSION_RESTART_IF_RUNNING,1);
    if(!session_init(session_client))
    {
	DBG("Cannot connect to session manager");
	session_client=NULL;
    }
#endif

    TRACE("call to init_xffm_env");
    init_xffm_env(); /* allocate memory for dynamic environment variables */
    xffm_setenv("PWD",(gchar *)GETWD,FALSE);
    
#ifdef XFFM_TREEVIEW_BINARY
    /* this should be moved to treeview_lib on code cleanup day
     * (it really makes no difference...)*/
    {
	int i;
	xffm_details->arbol = (arbol_t *) malloc(sizeof(arbol_t));
	memset(xffm_details->arbol,0,sizeof(arbol_t));
	xffm_details->arbol->widgets.input = OTHER_INPUT;
	/* object functions */
	xffm_details->arbol->double_click_open_with=treeview_double_click_open_with ;
	xffm_details->arbol->get_active_tree_id= get_active_tree_id;
	xffm_details->arbol->get_selected_entry= treeview_get_selected_entry;
	xffm_details->arbol->get_module_root=get_module_root;
	xffm_details->arbol->hide_branch_activate=hide_branch_activate;
	xffm_details->arbol->prune_row=prune_row;
	xffm_details->arbol->add_row=add_row;
	xffm_details->arbol->add_contents_row=add_contents_row;
	xffm_details->arbol->remove_row=remove_row;
	xffm_details->arbol->erase_dummy_row=erase_dummy_row;
	xffm_details->arbol->insert_dummy_row=insert_dummy_row;
	xffm_details->arbol->reset_dummy_row=reset_dummy_row;
	xffm_details->arbol->set_load_wait=set_load_wait;
	xffm_details->arbol->unset_load_wait=unset_load_wait;
	xffm_details->arbol->find_module_root=find_module_root;
	xffm_details->arbol->update_icon=update_icon;
	xffm_details->arbol->set_icon=set_icon;
	xffm_details->arbol->local_monitor=local_monitor;
	xffm_details->arbol->get_selectpath_iter=get_selectpath_iter;
	for (i=0; i<TREECOUNT; i++){
	    xffm_details->arbol->treestuff[i].name_size=100;
	}
    }
    /* read user configuration or set to default (loads treeview library)*/    
    get_xffm_config(); 
#endif
    
#ifdef XFFM_DESKVIEW_BINARY
    if (argc < 2 || (strcmp(argv[1],"--id") && strcmp(argv[1],"-id")))
#endif
        connect_mcs(); /* read in settings from mcs manager */

    if (!MIME_ICON_load_theme()) g_warning("cannot load mime_icon theme\n");

    if (!strstr(argv[0],"xffm-deskview")) {
            GError *error=NULL;
	    if (getenv("DISABLE_DESKTOP") && strlen(getenv("DISABLE_DESKTOP"))) 
	    {
		TRACE("Deskview disabled");
	    } else {
		Window xid;
		Atom selection_atom=XInternAtom(GDK_DISPLAY(), "XFFM_DESKVIEW_SELECTION", False);
		if((xid = XGetSelectionOwner(GDK_DISPLAY(), selection_atom))){
		    TRACE("xffm-deskview already running");
		} else if (!g_spawn_command_line_async ("xffm-deskview", &error))
		{
		    g_warning(error->message);
		}

	    }
    } 
    

	  	
#ifdef XFFM_ICONVIEW_BINARY
	TRACE("call to create_gridview");
	create_gridview(argc, argv);
#endif
	
#ifdef XFFM_DESKVIEW_BINARY
	create_desktop(argc, argv);
#endif
	
#ifdef XFFM_TREEVIEW_BINARY
	TRACE("call to fireup_treeview");
	fireup_treeview(argc, argv);
#endif
	
    chdir(GETWD);
    gtk_main();
    mcs_stop_watch(); 
    cleanup_tmpfiles();
    return 0;
}


