/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2007 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish distribute, sublicense and/or sell copies of
 * the Software, and to permit persons who receive copies from any such
 * party to do so, with the only requirement being that the above copyright
 * and this permission notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/

#ifdef USE_SMALL_ICONS

#define addpt_width 22
#define addpt_height 22
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width 22
#define align_height 22
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width 22
#define arc_height 22
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width 22
#define arc_box_height 22
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width 22
#define autoarrow_height 22
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width 22
#define box_height 22
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width 22
#define break_height 22
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width 22
#define open_comp_height 22
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width 22
#define join_split_height 22
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define chop_width 22
#define chop_height 22
static unsigned char chop_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x1c, 0x00, 0xc0, 0x13, 0x00, 0x30, 0x14, 0x00, 0x10, 0x2a, 0x00,
   0x90, 0x65, 0x00, 0x50, 0x64, 0x00, 0x30, 0x92, 0x00, 0x60, 0x89, 0x00,
   0xc0, 0x05, 0x01, 0x00, 0x03, 0x01, 0x04, 0x00, 0x02, 0x08, 0x00, 0x02,
   0x08, 0x00, 0x04, 0x11, 0x04, 0x04, 0x06, 0x03, 0x08, 0x88, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define c_intspl_width 22
#define c_intspl_height 22
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width 22
#define c_spl_height 22
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width 22
#define cirdia_height 22
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width 22
#define cirrad_height 22
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width 22
#define convert_height 22
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width 22
#define copy_height 22
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width 22
#define delete_height 22
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width 22
#define deletept_height 22
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width 22
#define edit_height 22
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width 22
#define elldia_height 22
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width 22
#define ellrad_height 22
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width 22
#define flip_x_height 22
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width 22
#define flip_y_height 22
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width 22
#define glue_height 22
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width 22
#define intspl_height 22
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width 22
#define line_height 22
static unsigned char line_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width 22
#define move_height 22
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width 22
#define movept_height 22
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width 22
#define picobj_height 22
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width 45
#define library_height 22
static unsigned char library_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width 22
#define polygon_height 22
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width 22
#define regpoly_height 22
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width 22
#define rotCCW_height 22
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width 22
#define rotCW_height 22
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width 22
#define scale_height 22
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width 22
#define spl_height 22
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width 22
#define text_height 22
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width 22
#define update_height 22
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define tangent_width 22
#define tangent_height 22
static unsigned char tangent_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x03,0x02,
 0x00,0x0c,0x02,0x24,0x10,0x02,0x2c,0x20,0x00,0x34,0x20,0x00,
 0x24,0x40,0x00,0x00,0x40,0x00,0xfe,0xff,0x03,0x00,0x40,0x00,
 0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,
 0x00,0x0c,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,};
#define anglemeas_width 22
#define anglemeas_height 22
static unsigned char anglemeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x36,0x00,0xc0,0x74,0x00,0xc0,
 0x84,0x01,0xc0,0x0e,0x02,0xc0,0x00,0x0c,0xc0,0x00,0x38,0xc0,0x00,0xc4,0xc8,
 0x00,0x84,0xd3,0x00,0x84,0xcb,0x00,0x68,0xd8,0x00,0x18,0xc0,0x06,0x06,0xc0,
 0x84,0x01,0xc0,0x66,0x00,0xc0,0x34,0x00,0xc0,0x36,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define lenmeas_width 22
#define lenmeas_height 22
static unsigned char lenmeas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0xf0,0x00,0xc0,0x8c,0xc0,0xcc,
 0x84,0xb0,0xc8,0x82,0x10,0xc9,0xc2,0x10,0xc9,0x60,0x08,0xc9,0x18,0x0c,0xcf,
 0x08,0x02,0xc0,0xf0,0x01,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x24,0x49,0xd2,0xfc,0xff,0xdf,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define areameas_width 22
#define areameas_height 22
static unsigned char areameas_bits[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x80,0x01,0xc0,0xc0,0x03,0xc0,
 0x60,0x05,0xc0,0x50,0x0d,0xc0,0x58,0x15,0xc0,0x54,0x15,0xc0,0x56,0x35,0xc0,
 0x56,0x35,0xcc,0x56,0xf5,0xd7,0x56,0x55,0xd5,0x56,0x55,0xd5,0xdc,0x57,0xd5,
 0x78,0x5c,0xcd,0x18,0x58,0xc7,0x00,0xf8,0xc1,0x00,0x20,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};

#else /* USE_SMALL_ICONS */

/****** NORMAL SIZE ICONS ******/

#define regpoly_width 36
#define regpoly_height 32
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width 36
#define addpt_height 32
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width 36
#define align_height 32
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width 36
#define arc_height 32
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width 36
#define autoarrow_height 32
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width 36
#define box_height 32
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width 36
#define arc_box_height 32
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width 36
#define cirdia_height 32
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width 36
#define cirrad_height 32
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width 36
#define convert_height 32
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width 36
#define c_spl_height 32
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width 36
#define copy_height 32
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width 36
#define glue_height 32
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width 36
#define break_height 32
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width 36
#define open_comp_height 32
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width 36
#define join_split_height 32
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define chop_width 36
#define chop_height 32
static unsigned char chop_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x0c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0xc0, 0x73, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0x00, 0x00, 0x80,
   0x03, 0xe6, 0x00, 0x00, 0x80, 0x80, 0xe1, 0x01, 0x00, 0x80, 0x70, 0xc0,
   0x01, 0x00, 0x80, 0x0c, 0xd2, 0x03, 0x00, 0x80, 0x00, 0x89, 0x03, 0x00,
   0x80, 0xc0, 0xc8, 0x01, 0x00, 0x80, 0x21, 0x24, 0x03, 0x00, 0x00, 0x13,
   0x12, 0x03, 0x00, 0x00, 0x02, 0x09, 0x06, 0x00, 0x00, 0x06, 0x09, 0x06,
   0x00, 0x00, 0x8c, 0x04, 0x0c, 0x00, 0x00, 0x18, 0x02, 0x0c, 0x00, 0x00,
   0x60, 0x01, 0x18, 0x00, 0x20, 0xc0, 0x00, 0x18, 0x00, 0x40, 0x00, 0x00,
   0x30, 0x00, 0x40, 0x00, 0x00, 0x30, 0x00, 0x80, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x01, 0x00, 0x60, 0x00, 0x00, 0x02, 0x40, 0xc0, 0x00, 0x08, 0x02,
   0x30, 0xc0, 0x00, 0x30, 0x04, 0x0c, 0x80, 0x01, 0xc0, 0x00, 0x03, 0x80,
   0x01, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};


#define delete_width 36
#define delete_height 32
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width 36
#define deletept_height 32
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width 36
#define elldia_height 32
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width 36
#define ellrad_height 32
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width 36
#define flip_x_height 32
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width 36
#define flip_y_height 32
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width 36
#define intspl_height 32
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width 36
#define c_intspl_height 32
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width 36
#define line_height 32
static unsigned char line_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width 73
#define library_height 32
static unsigned char library_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width 36
#define move_height 32
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width 36
#define movept_height 32
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width 36
#define polygon_height 32
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width 36
#define scale_height 32
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width 36
#define spl_height 32
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width 36
#define text_height 32
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width 36
#define picobj_height 32
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width 36
#define rotCCW_height 32
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width 36
#define rotCW_height 32
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width 36
#define update_height 32
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width 36
#define edit_height 32
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define areameas_width 36
#define areameas_height 32
static unsigned char areameas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0xee,0x00,0x00,0x00,0x00,0x27,0x01,0x00,0x00,0x80,
0x25,0x03,0x00,0x00,0xc0,0x24,0x05,0x00,0x00,0xe0,0x24,0x09,
0x00,0x00,0xa0,0x24,0x09,0x00,0x00,0xb0,0x24,0x19,0x00,0x00,
0xb0,0x24,0x19,0x00,0x00,0x98,0x24,0x39,0x00,0x00,0x98,0x24,
0x29,0x00,0x00,0x98,0x24,0x29,0x60,0x00,0x98,0x24,0xe9,0xdc,
0x00,0x98,0x24,0xc9,0x97,0x01,0x98,0x24,0x49,0x92,0x01,0x98,
0x24,0x49,0x92,0x01,0x90,0x24,0x49,0x92,0x01,0xb0,0xfc,0x49,
0x92,0x01,0xb0,0x0e,0x4b,0x92,0x00,0xe0,0x03,0x4e,0xd2,0x00,
0xc0,0x00,0x4c,0x72,0x00,0x00,0x00,0x4c,0x3a,0x00,0x00,0x00,
0xdc,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define tangent_width 36
#define tangent_height 32
static unsigned char tangent_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7d,0x00,0x00,0xe0,0x00,0x11,
0x00,0x00,0x00,0x03,0x11,0x00,0x00,0x00,0x0c,0x11,0x00,0x00,
0x00,0x10,0x11,0x00,0x00,0x00,0x20,0x01,0x00,0x10,0x01,0x20,
0x01,0x00,0x30,0x01,0x40,0x01,0x00,0x50,0x01,0x40,0x01,0x00,
0x90,0x01,0x80,0x01,0x00,0x10,0x01,0x80,0x01,0x00,0x00,0x00,
0xc0,0x01,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
0x00,0x40,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x10,0x01,0x00,
0x00,0x00,0x0c,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0xe0,
0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define anglemeas_width 36
#define anglemeas_height 32
static unsigned char anglemeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x07,0x00,0x00,
0x00,0x30,0x07,0x00,0x00,0x00,0x20,0x0f,0x00,0x00,0x00,0x20,
0x30,0x00,0x00,0x00,0x20,0x40,0x00,0x00,0x00,0x20,0x80,0x01,
0x00,0x00,0x70,0x00,0x06,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
0x00,0x00,0x21,0xc0,0x00,0x00,0x80,0xc0,0x20,0x01,0x00,0x80,
0x00,0x0f,0x01,0x00,0x80,0x00,0x8e,0x00,0x00,0x80,0x00,0x4f,
0x00,0x00,0x80,0xc0,0x20,0x00,0x00,0x00,0x21,0xe0,0x01,0x00,
0x00,0x1a,0x00,0x00,0x30,0x00,0x06,0x00,0x00,0x48,0x80,0x01,
0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
0x40,0x0f,0x00,0x00,0x00,0x48,0x07,0x00,0x00,0x00,0x30,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define lenmeas_width 36
#define lenmeas_height 32
static unsigned char lenmeas_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x80,0x13,0x00,0x40,
0x00,0x70,0x10,0x80,0xc1,0x00,0x18,0x10,0xe0,0x83,0x01,0x08,
0x10,0x30,0x06,0x01,0x0c,0x10,0x10,0x0c,0x01,0x04,0x18,0x18,
0x08,0x01,0x04,0x08,0x08,0x0c,0x01,0x04,0x04,0x08,0x04,0x01,
0x00,0x03,0x0c,0x84,0x01,0xc0,0x00,0x06,0xdc,0x00,0x60,0x00,
0x03,0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x02,
0x08,0x21,0x84,0x10,0x02,0x08,0x21,0x84,0x10,0x02,0xf8,0xff,
0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#endif /* USE_SMALL_ICONS */

/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/

#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define grid_iso1_width 32					// isometric grid
#define grid_iso1_height 32
static unsigned char grid_iso1_bits[] = {
0x00,0x00,0x00,0x00,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0x00,0x00,0x00,0x00};

#define grid_iso2_width 32
#define grid_iso2_height 32
static unsigned char grid_iso2_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,
0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,
0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,
0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,
0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,
0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,
0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x00,0x00,0x00,0x00};

#define grid_iso3_width 32
#define grid_iso3_height 32
static unsigned char grid_iso3_bits[] = {
0x00,0x00,0x00,0x00,0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,
0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,
0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,
0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,0x40,0xe0,0x03,0x01,
0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,
0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,
0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,
0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,
0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,
0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,
0x40,0x80,0x00,0x01,0x00,0x00,0x00,0x00};

#define grid_iso4_width 32
#define grid_iso4_height 32
static unsigned char grid_iso4_bits[] = {
0x00,0x00,0x00,0x00,0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,
0x60,0x32,0x40,0x00,0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,
0x80,0x0f,0x40,0x00,0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,
0x06,0x02,0x43,0x18,0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,
0x00,0x02,0x40,0x00,0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,
0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,0x60,0x32,0x40,0x00,
0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,0x80,0x0f,0x40,0x00,
0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,0x06,0x02,0x43,0x18,
0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,0x00,0x02,0x40,0x00,
0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,0x06,0x02,0x43,0x18,
0x18,0xc2,0x40,0x60,0x00,0x00,0x00,0x00};


#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/* create the data structures for them */

icon_struct	regpoly_ic = { regpoly_width, regpoly_height, 
				(char*)regpoly_bits };
icon_struct	addpt_ic = { addpt_width, addpt_height, 
				(char*)addpt_bits };
icon_struct	align_ic = { align_width, align_height, 
				(char*)align_bits };
icon_struct	arc_ic = { arc_width, arc_height, 
				(char*)arc_bits };
icon_struct	open_arc_ic = { open_arc_width, open_arc_height, 
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	autoarrow_ic = { autoarrow_width, autoarrow_height, 
				 (char*)autoarrow_bits };
icon_struct	box_ic = { box_width, box_height, 
				(char*)box_bits };
icon_struct	arc_box_ic = { arc_box_width, arc_box_height, 
				(char*)arc_box_bits };
icon_struct	cirrad_ic = { cirrad_width, cirrad_height,
				(char*)cirrad_bits };
icon_struct	cirdia_ic = { cirdia_width, cirdia_height,
				(char*)cirdia_bits };
icon_struct	c_spl_ic = { c_spl_width, c_spl_height,
				(char*)c_spl_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	intspl_ic = { intspl_width, intspl_height,
				(char*)intspl_bits };
icon_struct	c_intspl_ic = { c_intspl_width, c_intspl_height,
				(char*)c_intspl_bits };
icon_struct	copy_ic = { copy_width, copy_height,
				(char*)copy_bits };
icon_struct	glue_ic = { glue_width, glue_height,
				(char*)glue_bits };
icon_struct	break_ic = { break_width, break_height,
				(char*)break_bits };
icon_struct	open_comp_ic = { open_comp_width, open_comp_height, 
				 (char*)open_comp_bits };
icon_struct	join_split_ic = { join_split_width, join_split_height, 
				 (char*)join_split_bits };
icon_struct	chop_ic = { chop_width, chop_height, 
				 (char*)chop_bits };
icon_struct	deletept_ic = { deletept_width, deletept_height, 
				(char*)deletept_bits };
icon_struct	ellrad_ic = { ellrad_width, ellrad_height,
				(char*)ellrad_bits };
icon_struct	elldia_ic = { elldia_width, elldia_height,
				(char*)elldia_bits };
icon_struct	flip_x_ic = { flip_x_width, flip_x_height,
				(char*)flip_x_bits };
icon_struct	flip_y_ic = { flip_y_width, flip_y_height,
				(char*)flip_y_bits };
icon_struct	line_ic = { line_width, line_height,
				(char*)line_bits };
icon_struct	library_ic = {library_width, library_height,
				    (char*)library_bits };
icon_struct	move_ic = { move_width, move_height,
				(char*)move_bits };
icon_struct	movept_ic = { movept_width, movept_height,
				(char*)movept_bits };
icon_struct	polygon_ic = { polygon_width, polygon_height,
				(char*)polygon_bits };
icon_struct	delete_ic = { delete_width, delete_height,
				(char*)delete_bits };
icon_struct	rotCCW_ic = { rotCCW_width, rotCCW_height,
				(char*)rotCCW_bits };
icon_struct	scale_ic = { scale_width, scale_height,
				(char*)scale_bits };
icon_struct	convert_ic = { convert_width, convert_height,
				(char*)convert_bits };
icon_struct	spl_ic = { spl_width, spl_height,
				(char*)spl_bits };
icon_struct	text_ic = { text_width, text_height,
				(char*)text_bits };
icon_struct	picobj_ic = { picobj_width, picobj_height,
				(char*)picobj_bits };
icon_struct	rotCW_ic = { rotCW_width, rotCW_height,
				(char*)rotCW_bits };
icon_struct	update_ic = { update_width, update_height,
				(char*)update_bits };
icon_struct	edit_ic = { edit_width, edit_height,
				(char*)edit_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height, 
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height, 
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height, 
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height, 
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height, 
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height, 
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height, 
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height, 
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height, 
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height, 
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height, 
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height, 
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height, 
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height, 
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	grid_iso1_ic = { grid_iso1_width, grid_iso1_height,		// isometric grid
				(char*)grid_iso1_bits };
icon_struct	grid_iso2_ic = { grid_iso2_width, grid_iso2_height,
				(char*)grid_iso2_bits };
icon_struct	grid_iso3_ic = { grid_iso3_width, grid_iso3_height,
				(char*)grid_iso3_bits };
icon_struct	grid_iso4_ic = { grid_iso4_width, grid_iso4_height,
				(char*)grid_iso4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height, 
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height, 
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height, 
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height, 
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height, 
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height, 
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height, 
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height, 
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height, 
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height, 
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height, 
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height, 
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height, 
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height, 
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height, 
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height, 
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height, 
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height, 
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height, 
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height, 
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height, 
				(char*)fbarrows_bits };
icon_struct	tangent_ic = { tangent_width, tangent_height, (char*)tangent_bits };
icon_struct	anglemeas_ic = { anglemeas_width, anglemeas_height, (char*)anglemeas_bits };
icon_struct	lenmeas_ic = { lenmeas_width, lenmeas_height, (char*)lenmeas_bits };
icon_struct	areameas_ic = { areameas_width, areameas_height, (char*)areameas_bits };


/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define no_arrow_width 32
#define no_arrow_height 32
unsigned char no_arrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x04,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x24,0x32,0xd1,0x13,
0x24,0x4a,0x51,0x10,0x62,0x4a,0x53,0x20,0x62,0x4a,0x53,0x20,
0xa2,0x4a,0xd5,0x21,0xa2,0x4a,0x55,0x20,0x22,0x4b,0x59,0x20,
0x22,0x4b,0x59,0x20,0x24,0x4a,0x51,0x10,0x24,0x32,0xd1,0x13,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x10,0x00,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x40, 0x00, 0x06,
  0x00, 0x20, 0xe0, 0x01, 0x00, 0x10, 0x1e, 0x00, 0x00, 0xe8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x20, 0x70, 0x00,
  0x00, 0x40, 0x80, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x07,
  0x00, 0xe0, 0xff, 0x01, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow10o_width 32
#define arrow10o_height 32
unsigned char arrow10o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x08,0x1f,0x00,0x00,0x08,0xf0,0x01,
 0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow10f_width 32
#define arrow10f_height 32
unsigned char arrow10f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
  0x00, 0xf8, 0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow11o_width 32
#define arrow11o_height 32
unsigned char arrow11o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0xe8,0x01,0x00,0x00,0x10,0x1e,0x00,0x00,0x20,0xe0,0x01,0x00,0x40,0x00,0x06,
 0xfc,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow11f_width 32
#define arrow11f_height 32
unsigned char arrow11f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow12o_width 32
#define arrow12o_height 32
unsigned char arrow12o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x03,0x00,0x00,0x80,0x1c,0x00,0x00,0x80,0xe0,0x01,0x00,0x40,0x00,0x0e,
 0xf0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow12f_width 32
#define arrow12f_height 32
unsigned char arrow12f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x80, 0xff, 0x01,
  0x00, 0xc0, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow13a_width 32
#define arrow13a_height 32
unsigned char arrow13a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow13b_width 32
#define arrow13b_height 32
unsigned char arrow13b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14a_width 32
#define arrow14a_height 32
unsigned char arrow14a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14b_width 32
#define arrow14b_height 32
unsigned char arrow14b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
icon_struct	no_arrow_ic = { no_arrow_width, no_arrow_height, 
			      (char*)no_arrow_bits };
icon_struct	arrow0_ic = { arrow0_width, arrow0_height, 
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height, 
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height, 
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height, 
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height, 
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height, 
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height, 
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height, 
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height, 
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height, 
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height, 
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height, 
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height, 
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height, 
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height, 
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height, 
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height, 
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height, 
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height, 
			      (char*)arrow9b_bits };
icon_struct	arrow10o_ic = { arrow10o_width, arrow10o_height, 
			      (char*)arrow10o_bits };
icon_struct	arrow10f_ic = { arrow10f_width, arrow10f_height, 
			      (char*)arrow10f_bits };
icon_struct	arrow11o_ic = { arrow11o_width, arrow11o_height, 
			      (char*)arrow11o_bits };
icon_struct	arrow11f_ic = { arrow11f_width, arrow11f_height, 
			      (char*)arrow11f_bits };
icon_struct	arrow12o_ic = { arrow12o_width, arrow12o_height, 
			      (char*)arrow12o_bits };
icon_struct	arrow12f_ic = { arrow12f_width, arrow12f_height, 
			      (char*)arrow12f_bits };
icon_struct	arrow13a_ic = { arrow13a_width, arrow13a_height, 
			      (char*)arrow13a_bits };
icon_struct	arrow13b_ic = { arrow13b_width, arrow13b_height, 
			      (char*)arrow13b_bits };
icon_struct	arrow14a_ic = { arrow14a_width, arrow14a_height, 
			      (char*)arrow14a_bits };
icon_struct	arrow14b_ic = { arrow14b_width, arrow14b_height, 
			      (char*)arrow14b_bits };

icon_struct	printer_ic = { printer_width, printer_height, 
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

/* new icon from Marc-Aurle Darche */

#define fig_width 64
#define fig_height 64
static char fig_bits[] = {
 0x55,0x55,0x55,0x55,0x55,0xb5,0x6d,0xdb,0x55,0x55,0xa9,0xa4,0x54,0xd5,0xb6,
 0xb5,0x2a,0x95,0x4a,0x95,0xd2,0x6a,0xdb,0xde,0xa9,0x52,0xaa,0x52,0xf5,0xab,
 0x6d,0x6b,0x55,0x55,0x49,0xaa,0xea,0xd7,0xaa,0xd5,0xaa,0x4a,0x25,0x49,0x6a,
 0x2b,0xb7,0xbe,0xa5,0x2a,0x55,0xa5,0xd2,0xdf,0xda,0xd5,0x9a,0x54,0x29,0x95,
 0xd4,0x5f,0xad,0xba,0xa5,0x52,0xa5,0x52,0xea,0xfb,0x76,0xd7,0x55,0x95,0x14,
 0x49,0xe5,0xef,0xda,0xba,0xaa,0xaa,0xaa,0x54,0xf2,0xff,0x6b,0xdb,0xaa,0x24,
 0x49,0x25,0xb5,0xef,0xad,0xad,0x95,0xaa,0x24,0x92,0xf4,0xfe,0xdb,0xf6,0x54,
 0x55,0x55,0xa9,0xfa,0xff,0x6f,0xad,0xab,0x4a,0x55,0x25,0xf9,0x6f,0xbf,0xbb,
 0x54,0x02,0x00,0x95,0xac,0xfb,0xfd,0xd6,0x4a,0x1f,0x50,0x19,0x80,0x5e,0xef,
 0xbb,0x55,0x1f,0xe0,0x7a,0x50,0xeb,0xfa,0xdd,0xaa,0x3e,0xe0,0x3d,0xf8,0x5f,
 0xbf,0xb7,0x55,0x5f,0xe0,0x3c,0xfc,0xea,0xea,0xdf,0x4a,0x7f,0x40,0x1d,0xff,
 0x5d,0xbf,0xbf,0xaa,0x7e,0xc2,0x4e,0xff,0xeb,0xfa,0xdf,0x55,0xf5,0x40,0x84,
 0x7f,0x5f,0xef,0x7e,0xaa,0xf2,0x80,0xe5,0xdf,0xb7,0xfb,0xff,0x55,0x6a,0x81,
 0xf2,0xfb,0xed,0xbe,0xbf,0xaa,0xea,0x89,0xf0,0x7f,0xbf,0xf7,0xff,0xa5,0xea,
 0x01,0xfc,0xff,0xfd,0xde,0x7f,0x54,0xd5,0x03,0xfe,0xff,0xef,0xff,0xff,0x95,
 0xa4,0x03,0xf6,0xef,0xbf,0xff,0xff,0x55,0xd5,0x15,0xf6,0xbf,0xf7,0xfb,0x7f,
 0x55,0x95,0x43,0xf4,0xff,0xff,0xbf,0xff,0xaa,0xaa,0x07,0xea,0xff,0xff,0xff,
 0xff,0xaa,0x54,0x03,0xf4,0xff,0xee,0xfe,0xff,0xaa,0x52,0x11,0xec,0xff,0xff,
 0xff,0x7f,0xaa,0xca,0x18,0xe8,0xff,0xff,0xff,0xff,0x55,0x55,0x1c,0xe8,0xff,
 0xff,0xff,0xbf,0xaa,0x6a,0x2e,0xf0,0xff,0xff,0xff,0xff,0x52,0x15,0xbf,0xd0,
 0xff,0xff,0xff,0x5f,0xaa,0x9a,0x3f,0xaa,0x1f,0x9c,0xff,0xff,0x95,0xc6,0x7b,
 0xa0,0x07,0x04,0xff,0xaf,0xaa,0xd2,0x7a,0x69,0x07,0x00,0xfe,0xbf,0x5b,0xe3,
 0xba,0x40,0x03,0x08,0xff,0xef,0xd5,0x78,0xf5,0x64,0x45,0x0f,0xff,0xd7,0x6d,
 0x74,0x75,0x89,0xe1,0xff,0x7f,0xfa,0xb6,0x5c,0xf5,0xa1,0x02,0x00,0x0f,0x80,
 0x0b,0xe8,0x5a,0x04,0x05,0x81,0x0f,0x80,0x42,0xa2,0x8e,0x50,0x0c,0x80,0x03,
 0x81,0xbd,0xbd,0x7d,0xbf,0xd7,0x96,0xa3,0xe9,0xff,0xff,0xfe,0xff,0xe2,0xc3,
 0xc2,0xe0,0xff,0x77,0xfd,0xff,0xe9,0x83,0x83,0xe8,0x55,0xad,0x56,0x55,0x51,
 0x53,0x4b,0xb0,0xaa,0xb5,0xab,0xea,0xe0,0xc2,0x07,0xf8,0xdd,0x56,0x75,0xbf,
 0x52,0xcb,0x1e,0xfa,0x6b,0xbb,0xad,0xd5,0xe0,0x41,0x8e,0xdf,0xad,0xd5,0xda,
 0xea,0x54,0x25,0x06,0xf8,0xb6,0x6e,0x6f,0xbf,0xf0,0x03,0x01,0xd0,0xdb,0x55,
 0xb5,0xd5,0x54,0x89,0x60,0xe0,0xad,0xba,0x5b,0x6d,0xf0,0xeb,0xa1,0xc1,0xea,
 0x6e,0xed,0x0b,0x5d,0xbf,0xe9,0xca,0xbf,0xd5,0xb6,0x06,0xb8,0xfd,0x01,0xe0,
 0x52,0xbb,0xdb,0x05,0xde,0x77,0x13,0xf0,0xef,0xd6,0xb6,0x2e,0x77,0xff,0x85,
 0xb8,0x5a,0x7b,0xdb,0xab,0xef,0xdd,0x5f,0xff,0xed,0xad,0x6d,0xfd,0xfb,0xf7,
 0xff,0xef};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM_ICON

/* XPM version of xfig icon - first in full color for TrueColor displays,
   then in reduced color for 256 color-mapped displays */

char * fig_full_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64      253            2",
/* colors */
".. c #050804", ".# c #138820", ".a c #793d26", ".b c #ac8664", ".c c #084808", ".d c #74622c",
".e c #e0c68c", ".f c #d0895b", ".g c #3f180a", ".h c #ae643e", ".i c #47511c", ".j c #9c522e",
".k c #ccaa74", ".l c #066813", ".m c #785030", ".n c #412f27", ".o c #b17859", ".p c #eda870",
".q c #117611", ".r c #072804", ".s c #84767c", ".t c #f9e6a4", ".u c #60301f", ".v c #925132",
".w c #ed9967", ".x c #748634", ".y c #1b9c2c", ".z c #07580d", ".A c #9a6350", ".B c #eac8c4",
".C c #cc986c", ".D c #c5774e", ".E c #efb97f", ".F c #b09ea8", ".G c #603b30", ".H c #8c4930",
".I c #342818", ".J c #bb8863", ".K c #b27052", ".L c #7a4730", ".M c #1e6818", ".N c #073707",
".O c #9b6f4f", ".P c #248822", ".Q c #24791f", ".R c #9e5834", ".S c #ae786a", ".T c #8e5b3d",
".U c #1f5717", ".V c #d4a6a0", ".W c #805c3e", ".X c #43251e", ".Y c #b98b84", ".Z c #260f05",
".0 c #eca99d", ".1 c #10801e", ".2 c #e9d9df", ".3 c #d1998e", ".4 c #ae5e39", ".5 c #0a7015",
".6 c #613247", ".7 c #086011", ".8 c #074008", ".9 c #14480e", "#. c #e9dd9c", "## c #cd8d7f",
"#a c #623c3f", "#b c #a05853", "#c c #1c9428", "#d c #924f52", "#e c #279b29", "#f c #f1b7ad",
"#g c #4c2413", "#h c #996960", "#i c #753e49", "#j c #ac6554", "#k c #74514f", "#l c #bd704a",
"#m c #5e4732", "#n c #b27e5b", "#o c #7c4745", "#p c #d5babe", "#q c #766667", "#r c #522f28",
"#s c #f8c9c3", "#t c #c4966c", "#u c #041804", "#v c #fae8e6", "#w c #a4634b", "#x c #ca8055",
"#y c #1c7f21", "#z c #1c892a", "#A c #0a500f", "#B c #d29062", "#C c #f3af77", "#D c #a27759",
"#E c #6c3521", "#F c #6c3c2f", "#G c #c48a60", "#H c #997169", "#I c #ae8069", "#J c #dd9d90",
"#K c #fbc88b", "#L c #146818", "#M c #84503c", "#N c #082f05", "#O c #603629", "#P c #de9966",
"#Q c #14380a", "#R c #259425", "#S c #f0b0a5", "#T c #146016", "#U c #25a430", "#V c #605e24",
"#W c #51372f", "#X c #bc6843", "#Y c #bc7852", "#Z c #1c7720", "#0 c #945638", "#1 c #145812",
"#2 c #ac715c", "#3 c #1e6f16", "#4 c #b99391", "#5 c #2f1c15", "#6 c #147019", "#7 c #14400a",
"#8 c #522a32", "#9 c #746e6c", "a. c #f7d0cb", "a# c #94868c", "aa c #e2b982", "ab c #bfadb4",
"ac c #ac9aa0", "ad c #fcfafa", "ae c #e3a774", "af c #4f4947", "ag c #f0a290", "ah c #f8d7d3",
"ai c #fbf7b0", "aj c #896240", "ak c #fcd898", "al c #1a0a04", "am c #2c3614", "an c #e3a89e",
"ao c #87645e", "ap c #685048", "aq c #a07972", "ar c #e4a694", "as c #c4a4a8", "at c #a7888f",
"au c #888084", "av c #ef9f69", "aw c #f1bf87", "ax c #d9c1c4", "ay c #f0bfba", "az c #dcd294",
"aA c #052004", "aB c #6c4834", "aC c #9c5150", "aD c #1d6012", "aE c #fbe1e0", "aF c #904a52",
"aG c #805e54", "aH c #844225", "aI c #b9877c", "aJ c #6c3644", "aK c #6c3b46", "aL c #84534c",
"aM c #c4948e", "aN c #25811f", "aO c #d49f96", "aP c #14500e", "aQ c #fceff0", "aR c #a48264",
"aS c #fbd092", "aT c #e2a06e", "aU c #e4b078", "aV c #a17f79", "aW c #fcb87e", "aX c #a46f4e",
"aY c #e4b6b0", "aZ c #fcb076", "a0 c #341404", "a1 c #443a24", "a2 c #cf9f6f", "a3 c #c48e84",
"a4 c #c48879", "a5 c #041004", "a6 c #fce09c", "a7 c #aa8784", "a8 c #dc885f", "a9 c #fc9a74",
"b. c #844830", "b# c #8f5b4e", "ba c #fcaa94", "bb c #ac5e54", "bc c #a46a5c", "bd c #844847",
"be c #d4825a", "bf c #a47264", "bg c #bc806f", "bh c #fcb29c", "bi c #1c7228", "bj c #343234",
"bk c #148e25", "bl c #401e13", "bm c #78563f", "bn c #e4ced4", "bo c #ceaeae", "bp c #cf9285",
"bq c #4f2a1e", "br c #846a4c", "bs c #8a6a69", "bt c #94766c", "bu c #fca284", "bv c #fcaa74",
"bw c #bc7a64", "bx c #fcbab1", "by c #bc8059", "bz c #dc915f", "bA c #143204", "bB c #fcc084",
"bC c #fcc1b5", "bD c #141a04", "bE c #8c7274", "bF c #ecd094", "bG c #6c4846", "bH c #a46a51",
"bI c #1c8e24", "bJ c #78422e", "bK c #b36a43", "bL c #1ca22c", "bM c #9c6a52", "bN c #5c4234",
"bO c #b68e6a", "bP c #278e20", "bQ c #a45e39", "bR c #422a20", "bS c #633642", "bT c #a05e4f",
"bU c #945651", "bV c #7b4246", "bW c #ac6a54", "bX c #795651", "bY c #e0a297", "bZ c #bc9a99",
"b0 c #342214", "b1 c #c4b2b4", "b2 c #e4aea6", "b3 c #ecc68c", "b4 c #7c4f3f", "b5 c #0f781d",
"b6 c #5c3231",
/* pixels */
"bK.h#XbKbK#X#l#X#l#l#l#l#l#l#l#l.D#l.D.D#Y.D.D#Y.D.D#Y.D.D#Y#l.D#l#l#l#l#l#l#XbKbKbK.h.h.h.h.h.hbQ.4bQ.R.R.R.R.R.R.j.R.v.j.v.j.v",
"bK#XbKbK#lbK#lbK#l#l#l#l#l.D#l.D#l.D#Y#l.D#l#Y.D#Y#Y.D#Y#Y.D.D#l.D.D#l#l#l#l.ObK#XbK#XbK.h.h.h.4.4bQbQbQ.4.R.R.R.j.j.j.j.j.j.v.v",
"bKbKbK#XbK#l#l#l#l#l#l#l#l.D#l.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y#l.D.D#l.xbk.5.hbKbKbK.h.h.h.4bQ.4bQ.RbQ.R.R.R.R.R.j.j.j.v.v.j",
".hbK#lbK#X#l#X#l#l#l#l.D#l.D#Y.D#Y#Y.D#Y#Y#x#Yby.D#Yby#Y#x#Y#Y#Y#Y.D#Y#Y.h.z.q.1.7bKbK#XbK.h.h.h.hbQbQ.4.RbQ.R.R.R.j#0.j.j.v.v.v",
"#X#XbK#l#lbK#l#l#l#l.D#l#Y#Y#Y#Y#Y.Dby#Yby#Yby#Ybyby.Dby#Yby.Dby#Y#Y#Y#YbQ.r.7#y.7#VbKbKbKbK.h.h.4bQ.4bQbQ.R.R.R.R.j#0.j.j.j.v.v",
"bKbK#lbK#l#l#l#l#l#Y#l#Y#Y.D#Y.D#Yby#Yby.Dbybyby#xbybybybybyby#Yby.D#Y#Y#Y#w.8.q.M.z.m#lbK.hbK.h.h.hbQbQbQbQ.R.R.R.R#0.v.j.v.v.v",
"bK#lbK#l#l#l#l#l#Y#l#Y#Y#Y#Y#Yby#Yby#Ybybybybybybybybybybyby.Dbyby#Yby#Y#YaX.N.9#1.z.N#0bKbKbK.h.hbQ.hbQbQ.RbQ.R.j.R.j.j.v.j.v.v",
"#lbK#X#l#l#l#l#Y#l#Y#Y#Y#Y#Y#Y#Yby#xbybybyby#xbybybybyby#xbybybybybyby#Y#x.K.r.c#A.z.7#A.ibKbK.hbKbQ.4bQbQbQ.R.R.R#0#0#0.j.v.v.v",
"bK#l#l#l#l#l#l#Y#Y#Y#Y#Y#Ybybybybybybybybybyby.Jbybyby.Jbybybybybyby#Yby#YbM.N.z.7.5.5#T.l.7.W.h.h.h.hbQbQbQ.R.R.R.R.j#0.v.v.v.v",
"bK#lbK#lbK#Y#l#Y#l#Y#Y#Yby#Yby#Ybybybybyby.Jby.Jby.J.Jby.Jby.Jbybybybyby#n#m.8.z.7.7.U.#.1.5#A.WbK.hbQbQbQbQbQ.R.R.j#0.j.v.v.v.v",
"#l#l#l#l#Y.K#Y.K#Y#Y#Y#Yby#Yby#nby#n.J.J.Jby.J.J.J.Jby.J.J.Jby.JbybybybybH.N#A.c.9#L.1.1.1.1.l.c.W.h.hbQbQbQ.R.R.R#0.R#0.v.v.v.v",
"#X.K#l.K#l#l#Y#Y#Y#Y.o#Yby#nbybyby.Jby#n.J.J.J.J.J.J.J.J.J.J.Jby.J.Jby#n.m.8.c.N.z.l.l.5.5.l.l.7#AbQ#wbQbQbQ.RbQ.R#0.j.v.j.v.v.v",
"#l.K#l#l.o#l.o#Y.o#Ybyby#nbyby#n.Jby.J.J.J.J.J.J.J.J.J.J.J.J.J.J#n.J#n#Dam.N.N.9.7.7.l.l.l.z.7.7.7.z.W.hbQbQbQ.T.R.R#0.v.v.v.v.H",
".K#l.K#l#Y.K#Y#Y#Y#Y.o#Yby#nbyby.J.J#n.J.J.J.J.J.J.J.J.J.J.J.J.J.Jby.Jbm.r.N#A.z.7.7.l.l.7.7.l.5.l.7.z.ibQbT.R.R.R.R.v.R.v.v.v.v",
"#l#l.K#l.K#Y.o#Y.o#0#nbybybK.KaX.K#D.o.O.O#D#naR#n.bbO.J.b.J.b.J.J.J#Da1.N.c#A.7.7.lb5.1.5.5.1.1.1.1.5.l.z.mbQ.R.R#0#0.v.v.v.v.H",
".K#l.K#l.o#l.o#YaX#lbO.k.ea6a6a6a6akakakakaSbFaT.WbObO#D#Y.C#t.C#t#t.K.T.W.W.d#V.7.1.#.1.1bkbkbkbkbk.1.5.5.7.i#0#0.R.v.j.v.v.H.v",
".K#l.K#Y.K#Y.o#Y#0#E.v.hbeaaa6a6a6.t.taS#G#G#x#xaj.JbOaj.fa2.e#.aiaiaiaiazaz#K.o#3.#bk.#.#.ybk.y.ybk.#.1.1.5.z.c.m.R#0#0.v.v.v.v",
".K#l.K.K#l.o#Y.oaBal.Za0aH#Baka6a6a6a6aS#xbqbqa0#D.J.J#W.u.H#Y.p.taib3bz.f.D#Y.W.#bkbk#c#c.ybLbL.y.y.1.#.1.1.l.z.c.L.v#d.v.v#M.H",
".K.K#l.o.K#Y.o.o.Lalalala0bKaaa6a6a6a6.t#xblalb0aRbObralala0bKakaiaUa8#wbq.Z.ZaD.##c#c#c.ybLbLbLbL.ybk.#.1.1.5.7.c.c.m.v.v.v.H.v",
"#l.K.K#l.o.K#Y.obmalalalal.a#Gakakaka6a6.E#M..bNbObO#m..a0.vb3#.aUa8.L.Z..al#Q.qbk#c.y.y#e#U#UbLbL.ybI#c.1.#.1.l.z.8.8.H.v.v#M.H",
".K.K.K.K.o#Y.o.o#Malalalala0.D#Kaka6aka6aSbKal.O.baRalalbJaU#.aebe#Fal..bD#Q#L#Z#z#c#cbP#R#U#U#UbL#ebIbI#Z.1b5.5.z.8.8.N#M.H.v.H",
".K.K#l.K#l.o.o.o.Aa1.Xalal.Z#0aeakakakakak#P#WaRbObral.aa2bFae#l#Oal#N#A.7#6b5#6.##c#e#e#e#U#U#U#e.ybPbI#y.#b5.l.z.c.8.N#W.v#d.H",
".K.K.K.o.K.o.o#Y.o.o#n.Oalal.g#lakakakakak.EbQbObO.b#F#Gb3ae.K.u..#N.c.z.7#6.q#Z#z#cbP#e#U#e#e#e#R#e#c#y.#.1.1.l.z.c.8.8#N.H#M.H",
".K.K.K.K.o.K.o.o.o#n#n#nbmala0.haeaSakakakak.Dbt.J.O#YaSaT#l.X..#N.8#A.z#L#6#3#3#ybIbP#R#e#e#e#ebP#RbI#z#y#y.q.7.c.8.8.N#N#W.vbd",
".K.K.K.K.K.o.o.o.o.o#n#n.oalal.a.faSaSaSakaSaTaj#D.o#KaTbK.X...r#N.8#A.c.7#L#6b5aN#y.PbP#R#RbP#R#R.P#y#Z#6.q#6.7#A.c.8.8.r.Ib..H",
"bW.K.K.K.o.K#Y.o.obw.S.o#n#mal.g.DaaaSaSaSaS#KbQbKawaebK.X..#u.N#N.8.c.c#T#L#6#3#Z#3aN.P.PbPaN.P#zaN#Z#Z#L#6#L.7.8.8.8.N#NaAb.bd",
".KbW.K.K#2.K.o.o.o.o#n#n#IbMal.Z.R#PaSaSaSaSaSa8aaaebQbq..a5.r#N#N.N#A#A.7#T.MaD#Z#3aN#y.P.PaNaN#y.M#3#Z#T#6.7#A.c.c.8#N.raA.G.v",
"bW.K.K#2.K.o#2#2.o.o.o.o#n#nalal.u.D#K#KaS#KaS#K.EbH.u...na5aA#N.N#N.c.9#A#1#T#Tbi.M#3.Q#y#y#y.M#y#3.M#LaP#L.7#A.N.N.8.N.raA#rb.",
".KbW.K.K.K#2.K.o.o.o.S.o#I.o.Wala0.4a2#K#K#KaS#K#B#Oal.Wbma5aA.r#N#N.8.8aP#1#1.U.MaD.M.Q#Z#Z.Q.Ubi#L#L#T.c#T.z.8.N.8.N.N.r#ubqbd",
"bW.KbW.K#2.K.o#2.o.S.o.S.o.S.Oalal.H.D#K#K#K#K#K#P#Fbm.bapa5#u.r#N#N.8.8.caP#1aP#TaDaD#3#3#3.MaDbi#1#T#1.9.z.c.8#N.N#N.raA#u.nb.",
"bWbW.KbW.K#2.K#2.o.K.o.o.o#I.obNal#g#lbB#K#K#K#K.EbQaR#Ibma5#u.r.r#N.N.N#7aPaP.9.U#TaD#T#L.M#LaP#T#1#T.9.c#A.c.8.N.N#NaA#ua5b0bd",
"bWbWbW.K.K.K#2.K#2#2.o.S.o.o.S.Wal#g#laWbBbBbBbB#K#x.T#I.Wa5#uaA.r.r#N.8.N.c.9.9aP#1aPaD#T#1.U#7#TaPaP.N.8.9.8.N.r.r.r.r#ua5bqb.",
"bWbWbWbW#2#2.K#2#2.o#2.o.o.o.o.Sbl.Rae.EbBbB#KbBbBav#0#naja5#u#uaA.raA.NbA.N.9#7.9aPaP#1#1#1#7aPaP.c#7#N.c.8.N#N.r.r.raA#u..#r#o",
"#jbWbWbWbWbW#2#2#2#2#2bf.obf.o.AbQaT.E.f.fbBbBbBbBbB.h#h#Ha5a5#uaAaAaA#N#N.N#7.c#Q.9#7.9aP.9#7.c.9.9.8.r.8.N#N.r.raAaAa5a5..#E#o",
"bWbWbWbWbWbW#2bW#2#2#2.obf.obM.R#PaW.f.jbQbBaWbBbBaW.f#0.o#5a5#u#uaA#u.r.rbA#N#Q#Q#7#Q.9#7.9#N.9.8.N#N.r.N#N.r.raAaA#ua5....bJbV",
"bK#j#jbWbW#2bWbW#2#2#2bW#2aX.R#BaW#B.a.g#XaTbBaWaWaW#C#0aXbN..#u#u#u#uaA.raAbA.N#N#Q.N#Q.8#Q#N#7#NbA#N.r#N#NaA#u#u#ua5.....XbJ#o",
"#j#j#jbW#jbWbWbW#2bW#2#2aX.v.faW#BbJ.Z.Z.v#laWaWaWaWaW#l.W.A..a5#uaA#uaAaAaA.rbA.rbA.rbA#NbA#N#N.r.r.raA.raA#u#u#ua5......b6bVbJ",
"#j#j#j#jbWbWbWbWbWbWbWbH.v.faWav.R.Zalal#E.havaWaWaWaW#P.v#2.n..#u#u#u#uaAaAbDaA.raA.r.r.raAbA.raAaAaA#u#u#u#ua5a5......#5bJbVbV",
"#j#j#j#j#jbWbWbW#2bWbH.v#xaZ#P.Rbl.I#rala0.R.faWaZaZ#C#C.R.A.A....a5#u#uafas.2aQbnaubD.rafa##9bDaAaA#u#u#ua5a5a5a5......aJbJbVbJ",
"#j#w#j#j#j#j#j#jbc#w#0#xaZ.p.hbqbR.A.Aal.ZaH.RaZaZ.EaZ#C#x#MbWb4..a5a5#qayahaEaEaQaEaubEa.adaQab#u#ua5a5#ua5a5........bq.LbVbVbV",
"#jbb#j#w#jbH#jbW#w#0#xaZbv.K.u...Tbc#2#5.Z.g.4#P#CaZ#C#CaT.v#wbc#r..afb2a.#sbCbCbC#fbZ.3a.a.#say#9a5a5a5a5a5..a5.....Z#ibVbJbVbJ",
"bbbT#jbT#j#jbcbT.v#xaZav#x.aalb4bWbWaX#oala0.jbK#C#C#C#C.pbQ#MbW.Aa0a7bC#s.0.wbhbxaObsbgbhbxbxaO#qa5a5..a5........#5aKbJbVbV#i#i",
"bb#jbb#jbb#wbT.j#xaZaZ#xaH.ZaB#jbWbcbW.Aalal.u.4#P#C.p#C.p#BaH#jbcbcbYbCbC.3aLbKbyaLbRbd.wag.3bf.na5.............ZaK#obVbJbJ#ibJ",
"bbbQbbbT#jbU.jbebvaZbe.vblb6#wbcbc#jbc#j.Gal.g.R#x#C.p.p.p.p.R#M#jbf.0bCbx.Y#W.ubq#5al#g.aaLb4aoa5..........bj#qbsb4bVbV#i#i#i#i",
"#b#b.R#0.v.ja8bvaZav.4.ubRb##j#j#w#jbc#j#Mal#g.j.D.p.p.p.p.p.fb..Sa3#fbx#S#4ababbZacb1bnaQaQaEat.........s#p#vadaQaE#p#p#pb1as#i",
"b..4bK.DbeavaZaZbvbv#X#X.4bQ#0#b#j#wbU.v.R.R.R.h#P.p.p.p.paT.p#Y.vbg###J.BaQadadabaEadaQaEa.boap......a#a.ad#va.#s#saEadadadb1.G",
"b..4bzbza8.w.w.w.w#P#Pav.w#l.HbT#w#jb6.j#xbz#PaT.p.p.pavae.paTaT#P.f.Rb#bx#fbx#SaM#J#S#S#S#S#4bN#r#ObsayaE#sana3###S.0ananara7bS",
".uaH.aaH.a.a.a.aaHaHaHaHaHaHaHbTbTbU.g.aaH.HaHaHaHaHaHaHaH.H.H.v#Mb..vaqa4#2bHbW.Y.AbWbY#Sb2aIbGbd#o.Y#sah#Sa3b4bwbh#SanbfbT#H#a",
"b6alalalalalalalalalalalalal#Fbbbb#Malalal.Zal.Zal.Z.Zal.Z.Z.Zbl.G#h.SbpaM.G.u.ubq#Wa4#S#Sanaq#ibdbGaObC#San#H#Wa3bxananaVbq#g.G",
"aC#i#O#E#OaJ#O#FaJ#F#FaJ#O.G#dbTbTbd#r#r#rbq#r.Xbq.X.XbR.X.Xb0.X.AbY#f#S.YbGaK#F#FaB#J#f#SbYbs#obd#Wbp#Sb2an#H#q#Sa.#SbY#HbSb6aK",
"#b#b#b#bbb#b#b#bbQ#b#b#bbb#b#bbTbb#b#b#b#b#b#b#b#b#b#b#b#b#bbUbU.SbY#S#Sa7b4#daF#dbXbY#S#S.3aG#o#obRbwbab2ana7axaha.anaMbXbSaKaJ",
"aC.4aCbbaC#b#bbb#b#bbb#b#b#bbb#b#b#b#bbT#b#bbT#bb##bbU#bbUbUbU#d#I.0#SanaV#o#daL#o.Aan#S#SaMap#obV.X#oa9.0anayadaEaY#J#H#raJaKaK",
"#baC#baC.4aC#baC#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#bbUbUbU#d#b#daLa4.0#SbY#HbdbdaF#o.S.0#SanaIbGbVbVb6#g.va9an.0#Sb2a3.A.GbSaKaJbS",
"aCaCaCaCaCaC#baC.4aC#baC#b#baC#b#b#b#b#bbU#b#dbU#daCbUaCbU#d#daLbpag#SaO#qaFaLbdaK.Y.0.0anaV#kat#4#ibqaoanahbY#hb#.L#rb6aJ#aaJaJ",
"aC#b#b#b#baC#baCaCaC#baCaC#b#baCaC#daC#d#b#d#b#d#b#d#d#d#d#d#0bU.3.0#SbpaGbdbdbd.G##.0.0bYbZ.2aQac#iaobZ#S#fan#say#pa##iaKaJbSaJ",
"aCaCaCaCaC#baCaCaCaCaC#baCaCaC#b#d#b#b#daCbU#d#d#d#d#d#0#d#d#db##J#S.0.Y#kbdbdbd.Ga4.0an.0aEaQ.Bbtat.BaQaEananan#SbCa.axbXbSaJbS",
"aCaCaCaCaCaCaCaC#baCaCaCaCaC#daC#daC#d#daC#d#d#d#d#d#d#d#daLaFbfbYbaan#IbGbdbdbdb6bTbu.0anan.3bgaqaY#vahanbga4#JanbYb2ayboaKbSbS",
"aCaCaCaCaCaCaCaCaCaCaCaCaC#d.R#daC#daC#d#d#d#d#d#d#daF#dbdaFbdbgan.0.3bs#ibdbdbV#i.u.R#jbHbT#M#Oao#f#sbY#Ib4b.bTbg#JbYbY.VbsbS.6",
"aCaCaCaCaCaCaCaCaCaC#daC#daC#d#d#d#d#0#d#d#d#d#d#dbd#d#h#p#pa7#J.0.0#IbGbdbVbVbVbVbSbq.u.ub6b6bq.S.0.0bYaI#Wbl.ubJ.D.0bY.3bs.6bS",
"aCaFaCaFaCaFaFaCaFaC#daC#daFaCaFaC#daFaF#daF#daFaFaFaLaOahadad#S.0##.AaKbVbdbVbV#ibVbV#i#i#i#i#8b#buanbY.Vbo.Fab#pa.aybYaIbGbS.6",
"aCaFaCaFaCaFaCaFaCaFaCaFaFaCaFaFaFaFaF#daFaFbdaFbdaF#obp#S#f#say#J#hbS#ibVbVbVbV#i#i#i#i#iaK#ib6#ObebabYanayaEadad#vaYbpaG#8bS.6",
"aCaFaFaFaFaCaFaCaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbV.Kag.0babp.A.GaKbd#ibd#i#i#i#i#i#i#iaK#iaJblbV.DbpbYbYb2#SaYbYbgaL#W.6.6.6",
"aFaFaCaFaFaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdbdbdbdaH#jbw#2aL.uaKbV#ibV#i#ibV#i#i#iaK#iaJaKaJaJbl.a#dbT#2bg.Sbc#M.Gb6.6.6.6.6",
"aFaFaFaFaCaFaFaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdaFbdaFbVbd#i#E#E.ub6#i#ibVbV#i#i#i#i#i#i#iaJ#iaJaKaJaKaJ#8bq.u#F#O.u.u#8#8.6.6.6.6.6"
};

/* now reduced colors (notice that some match the predefined brown3, brown4, red4, etc */

char * fig_reduced_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64       32            1",
/* colors */
". c #000000", "# c #009000", "a c #925132", "b c #bb8863", "c c #145812", "d c #fbc88b",
"e c #bc8059", "f c #000000", "g c #9e5834", "h c #47511c", "i c #ed9967", "j c #000000",
"k c #b17859", "l c #000000", "m c #84767c", "n c #fbf7b0", "o c #748634", "p c #00b000",
"q c #a05853", "r c #ffe0e0", "s c #bc7852", "t c #b09ea8", "u c #000000", "v c #b27052",
"w c #ffc0c0", "x c #aa8784", "y c #900000", "z c #d5babe", "A c #803000", "B c #bd704a",
"C c #ffffff", "D c #a04000",
/* pixels */
"BgBBBBBBBBBBBBBBsBssssssssssssBsBBBBBBBBBBgggggggggggggggggagaga",
"BBBBBBBBBBBBBsBsBssBsBsssssssssBssBBBBvBBBBBggggggggggggggggggaa",
"BBBBBBBBBBBBBsBssssssssssssssssssBssBo##gBBBgggggggggggggggggaag",
"gBBBBBBBBBBsBssssssssesessesesssssssgc##cBBBBgggggggggggggaggaaa",
"BBBBBBBBBBsBsssssseseseseesesesessssglc#chBBBBggggggggggggagggaa",
"BBBBBBBBBsBsssssseseseeeeeeeeeesessssql#ccaBBgBgggggggggggaagaaa",
"BBBBBBBBsBssssseseseeeeeeeeeeeseesessvlccclaBBBgggggggggggggagaa",
"BBBBBBBsBssssssseeeeeeeeeeeeeeeeeeesevlccccchBBgBggggggggaaagaaa",
"BBBBBBBsssssseeeeeeeeeebeeebeeeeeesesqlcc##cccaggggggggggggaaaaa",
"BBBBBsBsBssseseseeeeebebebbebebeeeeekulcccc###caBgggggggggagaaaa",
"BBBBsvsvssssesekekbbbebbbbebbbebeeeevlcccc####ccaggggggggagaaaaa",
"BvBvBBssssksekeeebekbbbbbbbbbbbebbekalclccc##ccccgqggggggagagaaa",
"BvBBkBkskseekeekbebbbbbbbbbbbbbbkbkklllcccccccccccaggggaggaaaaaa",
"vBvBsvssssksekeebbkbbbbbbbbbbbbbbeballccccccccc#ccchgqggggagaaaa",
"BBvBvskskakeeBvvvkkvvkkkkbbbbbbbbbkjlccccc#########ccagggaaaaaaa",
"vBvBkBksvBbidddddddddddiabbksbbbbbvaaaahc############chaagagaaaa",
"vBvsvsksauageddddnndbbeeabbaeiddnnnndddk#####p#pp#####ccagaaaaaa",
"vBvvBksku.ffabddddddefffkbbufasinndiessa###ppppppp####cccaayaaaa",
"vvBkvskka...fBdddddnef.fkby..fBdniiqfffc#ppppppppp#####cccaaaaaa",
"BvvBkvska....abdddddda.ubbu.faddiiaf..l##ppppppppp#p###ccllaaaaa",
"vvvvkskka....fsddddddB.vbk..aidieu...lc##pp#pppppp######clllaaaa",
"vvBvBkkkqjf..faidddddiukby.aidiBu.lcc####ppppppppp#####ccclluaya",
"vvvkvkkskkkv..fBddddddgbbbubdivf.lccc####p#pppppppp####ccclllaaa",
"vvvvkvkkkkkka.fgidddddsmbvsdiBf.llccc######ppppp#p#####cclllluaA",
"vvvvvkkkkkkkk..aedddddiakkdiBf.lllcccc######pp#pp######ccclllfaa",
"vvvvkvskkekkku.fsddddddgBdiBf..lllcccc##############c#ccllllllaA",
"vvvvkvkkkkkkbq.fgidddddidigf..llllcccccc#########c##c#ccccllllua",
"vvvkvkkkkkkkkk..fsdddddddvf.j.llllcccccc#c#####c##ccccccllllllja",
"vvvvvkvkkkkkbka.fgidddddbu.aa.llllllccccccc####c#ccccccllllll.fA",
"vvvvkvkkkkkkkkv..asdddddiuabu..lllllccccccc###cc#ccccccllllll.ja",
"vvvvvkvkkvkkkbku.fBddddddgkba..llllllcccccccccccccccccclllll..fA",
"vvvvvvkvkkkkkkka.fBddddddeaba..llllllcccccccccclcccllcllllll..fa",
"vvvvkkvkkkkkkkkkfgiddddddiaka...llllllclcccccclcccllclllllll..jA",
"vvvvvvkkkkkkkkkqgideedddddgqm...lllllllclclccclccclllllllll...uA",
"vvvvvvkvkkkkkkqgideggdddddeakf...l.llllllllclclcllllllllll....aA",
"BvvvvkvvkkkvkvgbdbafBiddddiavu.....llllllllllllllllllll......faA",
"vvvvvvvvkvkkvaedbaffaBdddddBaq...l.lllllllllllllllllll.......uAa",
"vvvvvvvvvvvvaedigf..ugiddddiakj.....ll.llllllllllll.........faAA",
"vvvvvvvvkvvaeiigffj.fgediiiigqq.....utrCrm.luxm.ll..........uaAa",
"vqvvvvvvvqaeiigffqq.fagiidiieava...mrrrrCrmmrCCt...........faAAA",
"vqvqvvvvqaeiivf.avkfffgiiiiiiaqvj.uwrrrrrztwrrrrm.........fuAaAa",
"qqvqvvvqaeiiea.avvvA.fgBiiiiigavqfxrrwidrwmbdrrwm........fuaAAuu",
"qvqvqqqgeiieafuvvvvq..fgiiiiibavvvwrrwyBeyfAiwwkj.......fuAAaaua",
"qgqqvygeiieafuqvvvvvu.fgeiiiiigavkwrrxufff.fayay......jmmaAAuuuu",
"qqgaagiiiigffyvvqvvva.fgsiiiiieakxzrwxttttzrCCrx....mzCCCrzzzztu",
"agBseiiiiiBBggaqvqyaggggiiiiiiisabbwrCCCtrCCrrzu...xrCCrrrrCCCzu",
"agiiiiiiiiiiiBaqqvugeiiiiiiiiiiiiegyrzrwxwwwwwxujumrrrwxbwwwwwxu",
"faaaaaaaaaaaaaaqqyfaaaaaaaaaaaaaaaaxbkvvxqvwwwxuAAxrrwxaedwwkqmu",
"u.............uqqa...f.f.ff.ffffuqkwxufffubwwwxuAuwrwwmuxrwwxffu",
"DuuuuuuuuuuuuuyqqAjjjfjfffffffffqwzwxuuuuuwzwwmAAuwwwwmmwrwwmuuu",
"qqqqqqqqgqqqqqqqqqqqqqqqqqqqqqyykwwwxayAyAwwwwyAAfewwwxzrrwxAuuu",
"DgDqDqqqqqqqqqqqqqqqqqqqyqyqyyyybwwwxAyyAqwwwxuAAfAiwwrCrzwmjuuu",
"qDqDgDqDqqqqqqqqqqqqqqqqqyyyyqyybwwwmAAAAkwwwxuAAufaiwwwwxquuuuu",
"DDDDDDqDgDqDqqDqqqqqyqyyyDyDyyyywwwwmAyAuxwwwxAxxufywrwqyajuuuuu",
"DqqqqDqDDDqDDqqDDyDyqyqyqyyyyyaywwwwyAAAubwwwtrCtuytwzwrrzxuuuuu",
"DDDDDqDDDDDqDDDqyqqyDyyyyyyayyyywwwxAAAAubwwwrCrmxrCrwwwwrrzAuuu",
"DDDDDDDDqDDDDDyDyDyyDyyyyyyyyyAkwwwbuAAAuqwwwwwbxzCrwbbwwwwrzuuu",
"DDDDDDDDDDDDDygyDyDyyyyyyyAyAAAbwwwmuAAAufgvvqauyzrwbaaqbwwwwmuu",
"DDDDDDDDDDyDyDyyyyayyyyyyAyqzzxwwwbuAAAAAufffuufkwwwxuffaswwwmuu",
"DADADAADADyDyADADyAAyAyAAAywrCCwwbquAAAAuAAuuuuuywwwwzttzrrwxuuu",
"DADADADADADAADAAAAAyAAAAAAAwwzrrwquuAAAAuuuuuuuuuewwwrrCCCzwyuuu",
"DAAAADADAAADAAAAAAAAAAAAAAAvwwwwquuAuAuuuuuuuuuufAswwwwwzwbyuuuu",
"AADAAAAADAAAAAAAAAAAAAAAAAAavekyfuAuAuuAuuuuuuuuufayqkbkvauuuuuu",
"AAAADAAAAAAAAAAAAAAAAAAAAAAuuufuuuAAuuuuuuuuuuuuuuuffuuffuuuuuuu"
};

#endif /* USE_XPM_ICON */

/* bitmap of letters for splash screen ("3.2.X") */

#define letters_width 274
#define letters_height 68
static char letters_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,
 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x02,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xbf,0x00,0xd0,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0xc0,0xff,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,
 0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
 0x0f,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,
 0x03,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x3f,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x00,0xfc,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0xff,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x0f,0x00,0xfe,
 0x7f,0x00,0x00,0x00,0x00,0x00,0xff,0x01,0xfe,0xff,0x07,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf0,0x0f,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0xf0,0xff,
 0x0f,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,
 0x80,0x1f,0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0xf8,
 0xff,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0x7f,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0xc0,0x0f,0x00,0xc0,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x7f,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,
 0xe0,0x0f,0x00,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x00,0xf8,
 0xff,0x01,0x00,0x00,0x00,0xe0,0x1f,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xff,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfc,0xff,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0xe0,0x3f,0x00,0x80,0xff,
 0x3f,0x00,0x00,0x00,0x00,0x80,0x1f,0xff,0xbf,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,
 0xf0,0xff,0x01,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x00,0xf8,
 0xff,0x01,0x00,0x00,0x00,0xf0,0xff,0x03,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,
 0x80,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xf8,0xff,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0x07,0x80,0xff,
 0x3f,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0xfc,0xff,0x01,0x00,0x00,0x00,
 0xf0,0xff,0x07,0xc0,0xff,0x3f,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x7f,0x00,0xfc,
 0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0x0f,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,
 0xc0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xe0,0x3f,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0xf0,0xff,0x0f,0xc0,0xff,
 0x1f,0x00,0x00,0x00,0x00,0xe0,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0xfe,0x7f,0x00,0x00,0x00,0x00,
 0xf0,0xff,0x0f,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,0xc0,0x07,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
 0x3f,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0xe0,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x7f,0xf0,0xff,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0xff,0x3f,0x00,0x00,0x00,0x00,0xe0,0xff,0x0f,0xe0,0xff,
 0x0f,0x00,0x00,0x00,0x00,0xe0,0x83,0xfe,0x05,0x00,0x00,0x00,0xe0,0xff,0xff,
 0xf1,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
 0xc0,0xff,0x0f,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,0xf0,0xf3,0xff,0x3f,0x00,
 0x00,0x00,0xf0,0xff,0xff,0xfb,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,
 0x0f,0x00,0x00,0x00,0x00,0xc0,0xff,0x07,0xf0,0xff,0x07,0x00,0x00,0x00,0x00,
 0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0xfc,0xff,0xff,0xfb,0xff,0x01,0x00,0x00,
 0x00,0x00,0x00,0xc0,0xff,0x03,0x00,0x00,0x00,0x00,0x80,0xff,0x03,0xf8,0xff,
 0x07,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x03,0x00,0x00,0xfe,0x7f,0xc0,
 0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,0x00,
 0x00,0xfe,0x01,0xf8,0xff,0x03,0x00,0x00,0x00,0x00,0xf0,0xff,0xff,0xff,0x07,
 0x00,0x00,0xff,0x3f,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x3e,0xfc,0x7f,
 0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xfc,0xff,0x01,0x00,0x00,0x00,0x00,
 0xf8,0xff,0xff,0xff,0x0f,0x00,0x80,0xff,0x1f,0x00,0xff,0xff,0x00,0x00,0x00,
 0x00,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,
 0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0xf8,0xff,0x1f,0x00,0xc0,0xff,0x0f,0x00,
 0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0xe0,0xff,0x3f,
 0x00,0xe0,0xff,0x07,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,
 0xff,0x00,0xc0,0xff,0x3f,0x00,0xe0,0xff,0x03,0x00,0xff,0x7f,0x00,0x00,0x00,
 0x00,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x1f,
 0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x80,0xff,0x3f,0x00,0xf0,0xff,0x03,0x00,
 0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x1c,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x80,0xff,0x7f,
 0x00,0xf8,0xff,0x01,0x00,0xff,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
 0x3f,0x00,0x00,0xff,0xff,0x00,0xf8,0xff,0x01,0x00,0xff,0x3f,0x00,0x00,0x00,
 0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x01,
 0x00,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0xff,0x7f,0x00,0xfc,0xff,0x01,0x00,
 0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0xfc,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,
 0x00,0xfc,0xff,0x00,0x80,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,
 0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x00,0xfe,0xff,0x00,0x00,0xff,0x1f,0x00,0x00,0x00,
 0x00,0x00,0x00,0xc0,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0x00,0xfe,0x7f,0x00,0x80,
 0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x0f,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,
 0x00,0xff,0x7f,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xfe,0xff,0x00,0xff,0x7f,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,
 0xc0,0x0f,0x00,0xc0,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0xe0,0x7f,0x00,0x80,
 0x01,0x00,0x00,0x00,0x00,0x0d,0x00,0x00,0xfe,0xff,0x00,0xff,0x3f,0x00,0xc0,
 0xff,0x0f,0x00,0x00,0x00,0xf0,0x3f,0x00,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xf0,0x3f,0x00,0xc0,0x03,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0xfe,0xff,
 0x00,0xff,0x3f,0x00,0xc0,0xff,0x0f,0x00,0x00,0x00,0xf8,0x3f,0x00,0xc0,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x00,0xfc,0x0f,0x00,0xe0,0x03,0x00,0x00,0x00,0xf0,
 0x7f,0x00,0x00,0xfe,0x7f,0x80,0xff,0x3f,0x00,0xc0,0xff,0x0f,0x00,0x00,0x00,
 0xfc,0x7f,0x00,0xc0,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0xfe,0x03,0x00,0xe0,
 0x03,0x00,0x00,0x00,0xf0,0xff,0x01,0x00,0xff,0xff,0x80,0xff,0x3f,0x00,0xe0,
 0xff,0x07,0x00,0x00,0x00,0xfc,0xff,0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0xfe,0x01,0x00,0xf0,0x01,0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0xfe,0x7f,
 0x80,0xff,0x1f,0x00,0xe0,0xff,0x07,0x00,0x00,0x00,0xfe,0xff,0x00,0xc0,0xff,
 0x1f,0x00,0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0xf0,0x01,0x00,0x00,0x00,0xf8,
 0xff,0x01,0x00,0xff,0x7f,0x80,0xff,0x3f,0x00,0xe0,0xff,0x07,0x00,0x00,0x00,
 0xfe,0xff,0x00,0xe0,0xff,0x1f,0x00,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,0xf8,
 0x01,0x00,0x00,0x00,0xfc,0xff,0x01,0x00,0xff,0x3f,0x80,0xff,0x1f,0x00,0xf0,
 0xff,0x03,0x08,0x00,0x00,0xfe,0x7f,0x00,0xe0,0xff,0x0f,0x00,0x00,0x00,0x00,
 0xe0,0x0f,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0xfc,0xff,0x01,0x80,0xff,0x3f,
 0x80,0xff,0x1f,0x00,0xf0,0xff,0x03,0x3c,0x00,0x00,0xfe,0xff,0x00,0xe0,0xff,
 0x0f,0x00,0xfc,0x00,0x00,0xf0,0x07,0x00,0x00,0xfe,0x00,0x80,0x1f,0x00,0xfc,
 0xff,0x01,0x80,0xff,0x3f,0x80,0xff,0x1f,0x00,0xf0,0xff,0x03,0x3e,0x00,0x00,
 0xfe,0x7f,0x00,0xf0,0xff,0x0f,0x00,0xff,0x03,0x00,0xf8,0x03,0x00,0x80,0x7f,
 0x00,0xe0,0x7f,0x00,0xfc,0xff,0x01,0x80,0xff,0x1f,0x80,0xff,0x1f,0x00,0xf8,
 0xff,0x03,0x3f,0x00,0x00,0xfe,0x7f,0x00,0xf0,0xff,0x07,0x80,0xff,0x03,0x00,
 0xfe,0xff,0xff,0xff,0x7f,0x00,0xf0,0x7f,0x00,0xfc,0xff,0x01,0xc0,0xff,0x1f,
 0x80,0xff,0x1f,0x00,0xfc,0xff,0x01,0x1f,0x00,0x00,0xfe,0x3f,0x00,0xf8,0xff,
 0x07,0xc0,0xff,0x0f,0x00,0xfe,0xff,0xff,0xff,0x7f,0x00,0xf8,0xff,0x01,0xfc,
 0xff,0x00,0xc0,0xff,0x0f,0x00,0xff,0x1f,0x00,0xfc,0xff,0x81,0x0f,0x00,0x00,
 0xfc,0x0f,0x00,0xf8,0xff,0x03,0xc0,0xff,0x0f,0x00,0xff,0xff,0xff,0xff,0x7f,
 0x00,0xf8,0xff,0x01,0xf8,0x7f,0x00,0xe0,0xff,0x07,0x00,0xff,0x1f,0x00,0xfe,
 0xff,0xc1,0x07,0x00,0x00,0xfc,0x03,0x00,0xfc,0xff,0x03,0xe0,0xff,0x0f,0x80,
 0xff,0xff,0xff,0xff,0x3f,0x00,0xfc,0xff,0x01,0xfc,0x1f,0x00,0xf0,0xff,0x07,
 0x00,0xff,0x3f,0x00,0xfe,0xff,0xe0,0x07,0x00,0x00,0xfc,0x03,0x00,0xfc,0xff,
 0x01,0xe0,0xff,0x1f,0xc0,0xff,0xff,0xff,0xff,0x3f,0x00,0xfc,0xff,0x03,0xf8,
 0x07,0x00,0xf8,0xff,0x01,0x00,0xff,0x3f,0x80,0xff,0xff,0xf1,0x03,0x00,0x00,
 0xf8,0x03,0x00,0xfe,0xff,0x00,0xe0,0xff,0x0f,0xe0,0xff,0xff,0xff,0xff,0x1f,
 0x00,0xfc,0xff,0x01,0xf0,0x07,0x00,0xfc,0xff,0x01,0x00,0xfe,0x7f,0x80,0xff,
 0xff,0xfd,0x01,0x00,0x00,0xf8,0x07,0x00,0xff,0x7f,0x00,0xe0,0xff,0x1f,0xf0,
 0xff,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0x03,0xf0,0x0f,0x00,0xfe,0xff,0x00,
 0x00,0xfc,0xff,0xe0,0xf7,0xff,0xff,0x00,0x00,0x00,0xf0,0x0f,0xc0,0xff,0x3f,
 0x00,0xe0,0xff,0x0f,0xf0,0xff,0xff,0xff,0xff,0x1f,0x00,0xfc,0xff,0x01,0xe0,
 0x1f,0xc0,0xff,0x3f,0x00,0x00,0xfc,0xff,0xff,0xf7,0xff,0x7f,0x00,0x00,0x00,
 0xe0,0x1f,0xe0,0xff,0x0f,0x00,0xc0,0xff,0x0f,0xf8,0xff,0xff,0xff,0xff,0x0f,
 0x00,0xf8,0xff,0x01,0xc0,0xff,0xff,0xff,0x1f,0x00,0x00,0xf8,0xff,0xff,0xe1,
 0xff,0x7f,0x00,0x00,0x00,0xc0,0xff,0xff,0xff,0x07,0x00,0xc0,0xff,0x07,0xf8,
 0xff,0xff,0xff,0xff,0x0f,0x00,0xf8,0xff,0x00,0x80,0xff,0xff,0xff,0x07,0x00,
 0x00,0xf0,0xff,0xff,0xe1,0xff,0x1f,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x01,
 0x00,0x80,0xff,0x07,0xfc,0xff,0xff,0xff,0xff,0x07,0x00,0xf0,0xff,0x00,0x00,
 0xff,0xff,0xff,0x03,0x00,0x00,0xe0,0xff,0x7f,0xc0,0xff,0x0f,0x00,0x00,0x00,
 0x00,0xfc,0xff,0x3f,0x00,0x00,0x00,0xff,0x03,0xf8,0xff,0xff,0xff,0xff,0x07,
 0x00,0xe0,0x7f,0x00,0x00,0xfc,0xff,0x7f,0x00,0x00,0x00,0x80,0xff,0x1f,0xc0,
 0xff,0x03,0x00,0x00,0x00,0x00,0xe0,0xff,0x07,0x00,0x00,0x00,0xfe,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x1f,0x00,0x00,0xc0,0xff,0x07,0x00,0x00,
 0x00,0x00,0xfe,0x07,0x00,0xff,0x00,0x00,0x00,0x00};

/* splash background in XPM */

#ifdef USE_XPM

/* XPM */
char *spl_bckgnd_xpm[] = {
/* width height ncolors chars_per_pixel */
"630 210 241 2",
/* colors */
"   c #000000",
" . c #F3F1FF",
" X c #9F9AD1",
" o c #B2A9DD",
" O c #D4D1F1",
" + c #4E3407",
" @ c #CEC3FF",
" # c #CDC3FE",
" $ c #E6DAD1",
" % c #CAB7A5",
" & c #ACA9C3",
" * c #B9B6DD",
" = c #6E5A44",
" - c #907A6C",
" ; c #C4947E",
" : c #D4D1F4",
" > c #BAA9FF",
" , c #B9A9FE",
" < c #F8DCBE",
" 1 c #A59ADD",
" 2 c #D0B39A",
" 3 c #B48978",
" 4 c #EFE6E0",
" 5 c #6D5446",
" 6 c #CCAE8C",
" 7 c #C7BAB2",
" 8 c #E9CCAF",
" 9 c #9A8172",
" 0 c #8B8377",
" q c #FDD9BC",
" w c #AC9AFE",
" e c #A39ECA",
" r c #EACCC7",
" t c #D9D1FF",
" y c #4B3F42",
" u c #534336",
" i c #B1978F",
" p c #7F6554",
" a c #0C0B0E",
" s c #F1DCD1",
" d c #837465",
" f c #D8B89E",
" g c #472C09",
" h c #CBC3F1",
" j c #E0DDF5",
" k c #B8B6D1",
" l c #AAA9B6",
" z c #E2B8AB",
" x c #AE846E",
" c c #8F7460",
" v c #A98469",
" b c #F2ECEC",
" n c #B8947B",
" m c #D7D0E2",
" M c #FCFCF9",
" N c #764D23",
" B c #CFCDE4",
" V c #A49AD1",
" C c #AEA9E8",
" Z c #D6A995",
" A c #564435",
" S c #F4DCDA",
" D c #D8B9AE",
" F c #A78574",
" G c #96643F",
" H c #F1CDB6",
" J c #9F9CB8",
" K c #DBC4BE",
" L c #696679",
" P c #BEB6DD",
" I c #B4A9F1",
" U c #757192",
" Y c #F4E2DD",
" T c #DCD3CC",
" R c #C5C3DD",
" E c #B7B6C2",
" W c #9993BF",
" Q c #6E502B",
" ! c #EDD3CC",
" ~ c #978FBD",
" ^ c #B9B6DB",
" / c #C5B6FE",
" ( c #FBF5F4",
" ) c #D6D6FE",
" _ c #A79EC6",
" ` c #AE968E",
" ' c #7A6251",
" ] c #D7B2A9",
" [ c #8484B4",
" { c #B19CA8",
" } c #52484E",
" | c #D8C4C1",
".  c #816C5B",
".. c #C3B6FF",
".X c #D3C1B2",
".o c #68523F",
".O c #BEBEE6",
".+ c #6A554E",
".@ c #DCC3AA",
".# c #E8D0C3",
".$ c #D4D3CD",
".% c #1E070A",
".& c #B3AEDB",
".* c #817CA0",
".= c #DCBFAA",
".- c #AE9494",
".; c #C6A89B",
".: c #9E9AC3",
".> c #DCBEA0",
"., c #37344A",
".< c #D1B6A9",
".1 c #C4C3D1",
".2 c #C1B4AD",
".3 c #121715",
".4 c #9489C3",
".5 c #0F0F12",
".6 c #E4E5E3",
".7 c #403921",
".8 c #593408",
".9 c #E6CFBA",
".0 c #C0B6EE",
".q c #BAB6E8",
".w c #C8B1AD",
".e c #B9A9F1",
".r c #DDB19A",
".t c #C29C86",
".y c #91756D",
".u c #AB8A6C",
".i c #5E5B73",
".p c #C0B6F1",
".a c #C6B8B8",
".s c #271A12",
".d c #6F5B5C",
".f c #A69AE8",
".g c #B9B5B5",
".h c #C7C3F1",
".j c #D2BEB3",
".k c #956A3F",
".l c #EFCABF",
".z c #BCB6F0",
".x c #F3D5D0",
".c c #CAA78A",
".v c #FEFEFF",
".b c #9C9AB6",
".n c #ACA49E",
".m c #E5C4B5",
".M c #E3DDFF",
".N c #502C05",
".B c #C1A28B",
".V c #9B91AB",
".C c #C1B8F8",
".Z c #9E98CF",
".A c #ECD3B5",
".S c #B7A2AC",
".D c #C3A79A",
".F c #747474",
".G c #E8B39A",
".H c #8E86A8",
".J c #906C54",
".K c #FECDB6",
".L c #DDC3D1",
".P c #96857E",
".I c #262406",
".U c #43383D",
".Y c #9589D3",
".T c #FEDAC3",
".R c #AA8C77",
".E c #C1B6FE",
".W c #3C332C",
".Q c #BB9B81",
".! c #AA9A8E",
".~ c #ADA9DD",
".^ c #A07456",
"./ c #FCE4C4",
".( c #BFB6E8",
".) c #B6A49D",
"._ c #BCB8E5",
".` c #C8C3FE",
".' c #F1DBC3",
".] c #AA99DA",
".[ c #F4E9DD",
".{ c #242128",
".} c #C6AFA6",
".| c #BFB6FF",
"X  c #D8BEB1",
"X. c #D9D1FE",
"XX c #C6C3E8",
"Xo c #9A8CA9",
"XO c #BCBEBD",
"X+ c #9C8976",
"X@ c #2F302C",
"X# c #2B2932",
"X$ c #B4A9FE",
"X% c #B89D98",
"X& c #402415",
"X* c #D6B09B",
"X= c #B2A9E8",
"X- c #B6ABAD",
"X; c #8D7B92",
"X: c #D6CEC9",
"X> c #E5C6C4",
"X, c #CCCDC9",
"X< c #4B475B",
"X1 c #706051",
"X2 c #CDBFCA",
"X3 c #B68E78",
"X4 c #2B2C17",
"X5 c #9D9BA8",
"X6 c #CDBEC0",
"X7 c #755842",
"X8 c #E8BFA9",
"X9 c #524F65",
"X0 c #B69C8F",
"Xq c #F4D5B8",
"Xw c #553B12",
"Xe c #BFA9A5",
"Xr c #70675E",
"Xt c #9F98CB",
"Xy c #6D6786",
"Xu c #855D4B",
"Xi c #8D87AC",
"Xp c #513C2F",
"Xa c #221E0E",
"Xs c #B5A79B",
"Xd c #ACA9D1",
"Xf c #A99482",
"Xg c #98938F",
"Xh c #22160E",
"Xj c #CFC2C5",
"Xk c #A59B9F",
"Xl c #696999",
"Xz c #977B63",
"Xx c #544E60",
"Xc c #B5A5B2",
"Xv c #776F7F",
"Xb c #ECE8FF",
"Xn c #DCDCD8",
"Xm c #CCB7A4",
"XM c #E5D6CD",
"XN c #E4BEB5",
"XB c None",
/* pixels */
" O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX",
".O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [",
".O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [",
".O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [",
".O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [",
".O.O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [ [",
".O.O.O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [ [ [",
".O.O.O.O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O O ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )XX [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( o.qX8Xd o oXd V.( oX=.p oXd 1 o 1 1 XX=.q X V X 1 o.fX= I...z.~X8 o.~.<XdXdX= 1 1.~X= oX= , #X=.M #.pX=.e H.e.K H.q.f I o o oX=.q o.(.~ V oX= oXd 1.(Xd o o o.(.(.(XdXdXd.D 1 * P P & V *.X &.<.# h R.< *.p.M t.T t.M.M @.K @.MXX kXd.=.(.( V o.(X=X=.~ o *.=.( o.( R.D.D.2 &.2 & o &.< & o * &Xd & & & & o * o.2 &.DXd.<Xd.< *.<.:.D.< *.<Xd *Xd.D.b.<.( &Xd.<.<Xd.2 &Xd & oXd & &.<.D &.DXd &.b.D.< &.:.:Xd & E *.D.D.:.2.bXs & &Xd & &.< * *Xd V * V o &.:.D.< &.D.D V.:Xd &Xd V.:Xd V o.( o.qX8Xd o oXd V.( oX=.p oXd 1 o 1 1 XX=.q X V X 1 o.fX= I...z.~X8 o.~.<XdXdX= 1 1.~X= oX= , #X=.M #.pX=.e H.e.K H.q.f I o o oX=.q o.(.~ V oX= oXd 1.(Xd o o o.(.(.(XdXdXd.D 1 * P P & V *.X &.<.# h R.< *.p.M t.T t.M.M @.K @.MXX kXd.=.(.( V o.(X=X=.~ o *.=.( o.(.( R.D.D.2 &.2 & o &.< & o * &Xd & & & & o * o.2 &.DXd.<Xd.< *.<.:.D.< *.<Xd *Xd.D.b.<.( &Xd.<.<Xd.2 &Xd & oXd & &.<.D &.DXd &.b.D.< &.:.:Xd & E *.D.D.:.2.bXs & &Xd & &.< * *Xd V * V o &.:.D.< &.D.D V.:Xd &Xd V.:Xd V o.( o.qX8Xd o oXd V.( oX=.p oXd 1 o 1 1 XX=.q X V X 1 o.fX= I...z.~X8 o.~.<XdXdX= 1 1.~X= oX= , #X=.M #.pX=.e H.e.K H.q.f I o o oX=.q o.(.~ V oX= oXd 1.(Xd o o o.(.(.(XdXdXd.D 1 * P P & V *.X &.<.# h R.< *.p.M t.T t.M.M @.K @.MXX kXd.=.(.( V o.(X=X=.~ o *.=.( o.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& o *.(.q o V V oX8.( o.p X.DXd oXd V 1 o V.D.: V V 1.f I I IX= o.pX= VXd oX8 H 1 o 1 o C 1X=.eX= , #.p.K.p.p.K.p.E.z.p.z.q.~X8X= o *.p oXdXd o o.<Xd.q.< *.( o oX8XdXd V.q V.( o.#XX V.< o k l.<.9 h k o.(.(.T.M.M t # o @ t @.M ..# R.# O *XdXd o o oXdXd oXX o.( * h.(Xd &.D & & k.<Xd.< o P V.= P & V.D *.<Xd.b &Xd & & &.:.D &.:.b.<XdXd.r.< 1 & l.<.p oXd.< k.<XdXd.<.<.( * 2Xd.D.b.b.D &Xd.D.D & &.D.D.D & & VXdXd & V.D * k.< o.< V V.q.( P &.<.~.<.D.D.DXd.D.: &.~ o.~ V * V &.D.~ V o o *.(.q o V V oX8.( o.p X.DXd oXd V 1 o V.D.: V V 1.f I I IX= o.pX= VXd oX8 H 1 o 1 o C 1X=.eX= , #.p.K.p.p.K.p.E.z.p.z.q.~X8X= o *.p oXdXd o o.<Xd.q.< *.( o oX8XdXd V.q V.( o.#XX V.< o k l.<.9 h k o.(.(.T.M.M t # o @ t @.M ..# R.# O *XdXd o o oXdXd oXX o.( * o h.(Xd &.D & & k.<Xd.< o P V.= P & V.D *.<Xd.b &Xd & & &.:.D &.:.b.<XdXd.r.< 1 & l.<.p oXd.< k.<XdXd.<.<.( * 2Xd.D.b.b.D &Xd.D.D & &.D.D.D & & VXdXd & V.D * k.< o.< V V.q.( P &.<.~.<.D.D.DXd.D.: &.~ o.~ V * V &.D.~ V o o *.(.q o V V oX8.( o.p X.DXd oXd V 1 o V.D.: V V 1.f I I IX= o.pX= VXd oX8 H 1 o 1 o C 1X=.eX= , #.p.K.p.p.K.p.E.z.p.z.q.~X8X= o *.p oXdXd o o.<Xd.q.< *.( o oX8XdXd V.q V.( o.#XX V.< o k l.<.9 h k o.(.(.T.M.M t # o @ t @.M ..# R.# O *XdXd o o oXdXd oXX o.( * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&X8 o * oXd V.DXd * *.<X= V V oX= o.YX= V.~ X V V 1.: Z.f ,.f 1.G.K.( V.<.q o H V V VX8X= CX= I IX=X=.pX=X=.p #.K.K.E.pX=.( o.p o.~ *X= o 1.DXd oXd 2 o V.rXd oXdXd o o oXd.<.= P.(XX R P & & o.2 &XdXd k o H t.M.M @.e.e...MX..'XbXb *.q P.(.= o o o oXd 2Xd o.< P.< h m.# o &.D &XdXd.= o *.< & o * *.<Xd k.< k.<Xd l.<XdXd & & &.DXdXd o.( h & * V.D * P.<.<.<.D o o.< o k oXX & & & &.b &.D.=.q.~.D.: &.D & E.:.< o & V &.: E E o o oXd o *.< o o.<Xd 1 oXd.~ & V.~.D.r.~ IX=.( VXd.< V * oX8 o * oXd V.DXd * *.<X= V V oX= o.YX= V.~ X V V 1.: Z.f ,.f 1.G.K.( V.<.q o H V V VX8X= CX= I IX=X=.pX=X=.p #.K.K.E.pX=.( o.p o.~ *X= o 1.DXd oXd 2 o V.rXd oXdXd o o oXd.<.= P.(XX R P & & o.2 &XdXd k o H t.M.M @.e.e...MX..'XbXb *.q P.(.= o o o oXd 2Xd o.< P.<.< h m.# o &.D &XdXd.= o *.< & o * *.<Xd k.< k.<Xd l.<XdXd & & &.DXdXd o.( h & * V.D * P.<.<.<.D o o.< o k oXX & & & &.b &.D.=.q.~.D.: &.D & E.:.< o & V &.: E E o o oXd o *.< o o.<Xd 1 oXd.~ & V.~.D.r.~ IX=.( VXd.< V * oX8 o * oXd V.DXd * *.<X= V V oX= o.YX= V.~ X V V 1.: Z.f ,.f 1.G.K.( V.<.q o H V V VX8X= CX= I IX=X=.pX=X=.p #.K.K.E.pX=.( o.p o.~ *X= o 1.DXd oXd 2 o V.rXd oXdXd o o oXd.<.= P.(XX R P & & o.2 &XdXd k o H t.M.M @.e.e...MX..'XbXb *.q P.(.= o o o oXd 2Xd o.< P.< [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=X= oX= o oXd.: &.D o.DXd oXdXd 1 1 o o o V V 1 X.D 1Xd.p I I.p.T @XdX=.q V.~ VX8.p.(.(.p o.(X=X= I oX8X=.G I # #.p.q I.p I.p.( oXd o.:XdXd * &X0.<Xd.D.<.M P V.<.D o.( & VXX *Xd P o.'X. *Xd.b.2.DXd.< *.K t.. t @.. t.. h h h.MXb.M * 2 *.< o o *.(.( o P.~Xd.D.< &.(.(.# h.< l.b.D * P * * oXX h.q.h o.( &.<Xd # * o & & &.D &Xd oXd o PX= & P P h.<.( P *Xd & *.< * *Xd.< &.D.D.b.b.: &.b &.D & & & & V RXd k &.<X8.~ &.D.D &Xd.(.p H.(.q *.(.(Xd.~X8 #.p.( h o 1XdX= *.~X=X= *.~Xd o oXdX=X= oX= o oXd.: &.D o.DXd oXdXd 1 1 o o o V V 1 X.D 1Xd.p I I.p.T @XdX=.q V.~ VX8.p.(.(.p o.(X=X= I oX8X=.G I # #.p.q I.p I.p.( oXd o.:XdXd * &X0.<Xd.D.<.M P V.<.D o.( & VXX *Xd P o.'X. *Xd.b.2.DXd.< *.K t.. t @.. t.. h h h.MXb.M * 2 *.< o o *.(.( o P.~Xd.D.< &.<.(.(.# h.< l.b.D * P * * oXX h.q.h o.( &.<Xd # * o & & &.D &Xd oXd o PX= & P P h.<.( P *Xd & *.< * *Xd.< &.D.D.b.b.: &.b &.D & & & & V RXd k &.<X8.~ &.D.D &Xd.(.p H.(.q *.(.(Xd.~X8 #.p.( h o 1XdX= *.~X=X= *.~Xd o oXdX=X= oX= o oXd.: &.D o.DXd oXdXd 1 1 o o o V V 1 X.D 1Xd.p I I.p.T @XdX=.q V.~ VX8.p.(.(.p o.(X=X= I oX8X=.G I # #.p.q I.p I.p.( oXd o.:XdXd * &X0.<Xd.D.<.M P V.<.D o.( & VXX *Xd P o.'X. *Xd.b.2.DXd.< *.K t.. t @.. t.. h h h.MXb.M * 2 *.< o o *.(.( o P.~Xd.D.< & [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.q.q o V.~.~.:.D XXdXdXd.D V V V V X.~.K.p * 1.: X.: V 1X=.~.(X=.h tXd V 2 o V V V 1 V 1.~ oX= H.q.q 1X=X=X=.K.p.K I.e.E.K.p I.p o.<Xd.D 2 o.<.: &.D.D &.=XX &Xd *.< V * o PXd.<.<Xd.~X.XX.<.< &.< P P *.K t t @ @ @ t.K t h.K # . ..M o o * o k o * o.( V.( P * & * o * o P R oXd.D &Xd.DXd.D.< P k.< P o & &.<.9 B & &.D & &.:.D o.<.( o * * & k.D.( * o *Xd &.< *Xd.D &.( k.D.< &.:.b &.b.D.D &.DXd V o * * &.D.DXd *.<.: &.b &.<.~ o.q.( o.( * P.( *.(.p o o.(Xd.<X= oX= o.EXd o.< oX= o.e.q.q o V.~.~.:.D XXdXdXd.D V V V V X.~.K.p * 1.: X.: V 1X=.~.(X=.h tXd V 2 o V V V 1 V 1.~ oX= H.q.q 1X=X=X=.K.p.K I.e.E.K.p I.p o.<Xd.D 2 o.<.: &.D.D &.=XX &Xd *.< V * o PXd.<.<Xd.~X.XX.<.< &.< P P *.K t t @ @ @ t.K t h.K # . ..M o o * o k o * o.( V.( P * & * o o * o P R oXd.D &Xd.DXd.D.< P k.< P o & &.<.9 B & &.D & &.:.D o.<.( o * * & k.D.( * o *Xd &.< *Xd.D &.( k.D.< &.:.b &.b.D.D &.DXd V o * * &.D.DXd *.<.: &.b &.<.~ o.q.( o.( * P.( *.(.p o o.(Xd.<X= oX= o.EXd o.< oX= o.e.q.q o V.~.~.:.D XXdXdXd.D V V V V X.~.K.p * 1.: X.: V 1X=.~.(X=.h tXd V 2 o V V V 1 V 1.~ oX= H.q.q 1X=X=X=.K.p.K I.e.E.K.p I.p o.<Xd.D 2 o.<.: &.D.D &.=XX &Xd *.< V * o PXd.<.<Xd.~X.XX.<.< &.< P P *.K t t @ @ @ t.K t h.K # . ..M o o * o k o * o.( V.( P * & * o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& o o V V.D.:Xd.< oXd P.(.~ X oXd V 1 h.q 1 V 1.Y V V.~X=.p * oX8.p V oXd.~.D V V 1 o V V.( 1X= H.K.e hX=.p.z.E ,.p ,.K #.q.(.q o o *XdXd & &.D.<.:.D o &.<.< VXd R o P.(X..(Xd.< o o o.(.(.< o & * h * @Xb.M # # #.K.E.T @ @ @ ..v t.~Xd.<X=XdXd *Xd o.( * o o P H P & * V o o &Xs & o & &XdXd &Xd.D &.:.: &.b k.< &.D &.D &.DXd PX= * & P k V &Xd.q.q o.( &.D o k &Xd V & & & & & & V l & & & &.:.:.(XX k &.:.D &.b.D.:.b.D.b.b.D o V.r.( V.( VX8 h H h *Xd o 1.q P o 1 o o.q.D.<XdXd * o o o o o V V.D.:Xd.< oXd P.(.~ X oXd V 1 h.q 1 V 1.Y V V.~X=.p * oX8.p V oXd.~.D V V 1 o V V.( 1X= H.K.e hX=.p.z.E ,.p ,.K #.q.(.q o o *XdXd & &.D.<.:.D o &.<.< VXd R o P.(X..(Xd.< o o o.(.(.< o & * h * @Xb.M # # #.K.E.T @ @ @ ..v t.~Xd.<X=XdXd *Xd o.( * o o P H P * & * V o o &Xs & o & &XdXd &Xd.D &.:.: &.b k.< &.D &.D &.DXd PX= * & P k V &Xd.q.q o.( &.D o k &Xd V & & & & & & V l & & & &.:.:.(XX k &.:.D &.b.D.:.b.D.b.b.D o V.r.( V.( VX8 h H h *Xd o 1.q P o 1 o o.q.D.<XdXd * o o o o o V V.D.:Xd.< oXd P.(.~ X oXd V 1 h.q 1 V 1.Y V V.~X=.p * oX8.p V oXd.~.D V V 1 o V V.( 1X= H.K.e hX=.p.z.E ,.p ,.K #.q.(.q o o *XdXd & &.D.<.:.D o &.<.< VXd R o P.(X..(Xd.< o o o.(.(.< o & * h * @Xb.M # # #.K.E.T @ @ @ ..v t.~Xd.<X=XdXd *Xd o.( * o o P H P [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.~X8.~Xd X.:Xd V 1 V.:.:.D.~ V V V X.D.D 1 V.D VXd X 1 # C.Y.e ,.KXd V o C V.r.~X= hX=XdXd 1 1 1X=.p.K.p.eX= #X8.p.K.( I oX=.p V V k P &.~.~.(.< o V o O.<.2.<Xd *Xd oX=X. o.2.DXd h.D P hXd V oXd.: k...M.MX=.p.~.(.(.#.M t t.vXbXb.2 V o o o V *.< o o.:.:.:.= h.( l o.~.D *XdXd.< &Xd.b.b &.D &.D & &.:.: & & h.(Xd.bXs.: *Xd o & &.<.<.b.b & V.( *.( kXd.< o l.D o hXd &.( E.b &Xs.b.:.: &Xd o.# E & &.b.b.b &.b.bXd.b.b & & oX=X8.p @ #.(.p o oX=.< o o.< o o.pX. #.q o o.: V &.D.~X= oX=.~X8.~Xd X.:Xd V 1 V.:.:.D.~ V V V X.D.D 1 V.D VXd X 1 # C.Y.e ,.KXd V o C V.r.~X= hX=XdXd 1 1 1X=.p.K.p.eX= #X8.p.K.( I oX=.p V V k P &.~.~.(.< o V o O.<.2.<Xd *Xd oX=X. o.2.DXd h.D P hXd V oXd.: k...M.MX=.p.~.(.(.#.M t t.vXbXb.2 V o o o V *.< o o.:.:.:.= h.(.D l o.~.D *XdXd.< &Xd.b.b &.D &.D & &.:.: & & h.(Xd.bXs.: *Xd o & &.<.<.b.b & V.( *.( kXd.< o l.D o hXd &.( E.b &Xs.b.:.: &Xd o.# E & &.b.b.b &.b.bXd.b.b & & oX=X8.p @ #.(.p o oX=.< o o.< o o.pX. #.q o o.: V &.D.~X= oX=.~X8.~Xd X.:Xd V 1 V.:.:.D.~ V V V X.D.D 1 V.D VXd X 1 # C.Y.e ,.KXd V o C V.r.~X= hX=XdXd 1 1 1X=.p.K.p.eX= #X8.p.K.( I oX=.p V V k P &.~.~.(.< o V o O.<.2.<Xd *Xd oX=X. o.2.DXd h.D P hXd V oXd.: k...M.MX=.p.~.(.(.#.M t t.vXbXb.2 V o o o V *.< o o.:.:.:.= h.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.r.qXd VXd VXdXd o & V.D.: 1 VXd.D V V.: V 1Xd V.~ VX=.K.E.e @ # # V V V o 1X=X=.e.pX= V.c.~ 1 1 1X=.e @ #.(X=X=X=.h.qX=X= VX= V o PXd.<Xd V o.q.~Xd.<.hX8XX.<X8 H.<.r *X. * V.<.'.# o.q.( o.#XX k &Xd.K @ t #.( 1.#XX h.(.(..Xb t @.v PXd.~.( oX8.q o.~ & V l.X.# P.: & o o.( o k k.< &.D.DXd.DXd.<Xd.D &.D &.D oXX h oXd.< &.<X=.D.: & &.D & & *.(Xd o o P o &XdX8.'.# H.< R l.:.b & & l.:Xs &.< k.:.D &.bX5X5.b.b.bXd.:.:.:.< o h.#.( h P # H.q.(.< o k o oX= o.(.( P.(.~XdXd V & & V.(X=X=.r.qXd VXd VXdXd o & V.D.: 1 VXd.D V V.: V 1Xd V.~ VX=.K.E.e @ # # V V V o 1X=X=.e.pX= V.c.~ 1 1 1X=.e @ #.(X=X=X=.h.qX=X= VX= V o PXd.<Xd V o.q.~Xd.<.hX8XX.<X8 H.<.r *X. * V.<.'.# o.q.( o.#XX k &Xd.K @ t #.( 1.#XX h.(.(..Xb t @.v PXd.~.( oX8.q o.~ & V l.X.# PXd.: & o o.( o k k.< &.D.DXd.DXd.<Xd.D &.D &.D oXX h oXd.< &.<X=.D.: & &.D & & *.(Xd o o P o &XdX8.'.# H.< R l.:.b & & l.:Xs &.< k.:.D &.bX5X5.b.b.bXd.:.:.:.< o h.#.( h P # H.q.(.< o k o oX= o.(.( P.(.~XdXd V & & V.(X=X=.r.qXd VXd VXdXd o & V.D.: 1 VXd.D V V.: V 1Xd V.~ VX=.K.E.e @ # # V V V o 1X=X=.e.pX= V.c.~ 1 1 1X=.e @ #.(X=X=X=.h.qX=X= VX= V o PXd.<Xd V o.q.~Xd.<.hX8XX.<X8 H.<.r *X. * V.<.'.# o.q.( o.#XX k &Xd.K @ t #.( 1.#XX h.(.(..Xb t @.v PXd.~.( oX8.q o.~ & V l.X.# P [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.qX= oXdXd V oXd V V V V.:.:Xd.~ 1 1Xd V.Y X o.~.~X=X=.K t @.( oX= VXd o 1 I.K q @ t 1 1 1 1 oX8.e.e.K @.KX=X=X=.(X=X=X=.h I.( o o * o oXdXd.< * oXd o o h h * o.( P.(XX.(.(Xd.:.(XX h PXX hXX P.<.<Xd.e ,.K.e.K.q.#.6.p.q.(.T t.K #.v ..M 2 o.(X=.~ o.r o o.2 *.# *.D V oXd oXdXd.D & &.b &.< lXd *.< &.D & V &.q.( *XX o * 1.( o &.D oXd.D.b V P.(X8 o H.q.<Xd.<Xb . P R.<.D.:XsXs &.DXs.:.:.< R.:.D.DXs.b.b.b.b.b.bXd.D.D.b.D o h.( o *.( H t.( o.q.( *.<Xd * o *.(Xd.(.K.<.< &.DXd V * oX=.qX= oXdXd V oXd V V V V.:.:Xd.~ 1 1Xd V.Y X o.~.~X=X=.K t @.( oX= VXd o 1 I.K q @ t 1 1 1 1 oX8.e.e.K @.KX=X=X=.(X=X=X=.h I.( o o * o oXdXd.< * oXd o o h h * o.( P.(XX.(.(Xd.:.(XX h PXX hXX P.<.<Xd.e ,.K.e.K.q.#.6.p.q.(.T t.K #.v ..M 2 o.(X=.~ o.r o o.2 *.# * o.D V oXd oXdXd.D & &.b &.< lXd *.< &.D & V &.q.( *XX o * 1.( o &.D oXd.D.b V P.(X8 o H.q.<Xd.<Xb . P R.<.D.:XsXs &.DXs.:.:.< R.:.D.DXs.b.b.b.b.b.bXd.D.D.b.D o h.( o *.( H t.( o.q.( *.<Xd * o *.(Xd.(.K.<.< &.DXd V * oX=.qX= oXdXd V oXd V V V V.:.:Xd.~ 1 1Xd V.Y X o.~.~X=X=.K t @.( oX= VXd o 1 I.K q @ t 1 1 1 1 oX8.e.e.K @.KX=X=X=.(X=X=X=.h I.( o o * o oXdXd.< * oXd o o h h * o.( P.(XX.(.(Xd.:.(XX h PXX hXX P.<.<Xd.e ,.K.e.K.q.#.6.p.q.(.T t.K #.v ..M 2 o.(X=.~ o.r o o.2 *.# * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd o.q o.r o o o.~ oXd.D V.b.D & & V V 1.q VX= X V.(.~.G t.M *X=.p.E V V.r 1.p @ t , / HX= 1 1X=X= H.K.K.E.eX=.q 1X=.qX= oX=Xd V o.p.TXdXd.D.D 1.( * o o o.( H o o o h o & P.#.q.T O.( oXd V &.<.2.D.: 1.( o 1.rX=X=XX PX= o o.T * P.p h.(Xb.v.v.M hX=.(.~ oX= P oXX * @X8 o o 1.~X8 o oX=.~.e.p.q o o oXd o &.D &X=.p H * o.<.# * * & V.<Xd.p.<.D HXX.(.#XX h * PX8 hXd k k.X & &.D &.< P.D.: &X2.D o.D.b.: &.b.bXs.b.b.:.D V V * h.(X8.r P.h.(.T.pX8 o.< o.q.(.( tXX.q *.(.( h t h V.D V V V V o.q o.r o o o.~ oXd.D V.b.D & & V V 1.q VX= X V.(.~.G t.M *X=.p.E V V.r 1.p @ t , / HX= 1 1X=X= H.K.K.E.eX=.q 1X=.qX= oX=Xd V o.p.TXdXd.D.D 1.( * o o o.( H o o o h o & P.#.q.T O.( oXd V &.<.2.D.: 1.( o 1.rX=X=XX PX= o o.T * P.p h.(Xb.v.v.M hX=.(.~ oX= P oXX * , @X8 o o 1.~X8 o oX=.~.e.p.q o o oXd o &.D &X=.p H * o.<.# * * & V.<Xd.p.<.D HXX.(.#XX h * PX8 hXd k k.X & &.D &.< P.D.: &X2.D o.D.b.: &.b.bXs.b.b.:.D V V * h.(X8.r P.h.(.T.pX8 o.< o.q.(.( tXX.q *.(.( h t h V.D V V V V o.q o.r o o o.~ oXd.D V.b.D & & V V 1.q VX= X V.(.~.G t.M *X=.p.E V V.r 1.p @ t , / HX= 1 1X=X= H.K.K.E.eX=.q 1X=.qX= oX=Xd V o.p.TXdXd.D.D 1.( * o o o.( H o o o h o & P.#.q.T O.( oXd V &.<.2.D.: 1.( o 1.rX=X=XX PX= o o.T * P.p h.(Xb.v.v.M hX=.(.~ oX= P oXX * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` t.TXd oX=.q o o 1 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M V X HX=X=.fX= >.M.qX8 V.e @X=.G.p.G I.. @.M . @ t.pX=X=X= #.K # I ,.p o o.( o.~ o.(.:Xd &Xd o o V.:.: oX=.(X= oX=.(.p o *.<Xd &.< *Xd.r o.( o.:.DXd k kXd.<Xd H.p 1 VX=.q o.(.e @X= H.M.<.D.KXd o t.v.v.v.'.(X=.9.( P.( *X8.(...E.E.~ I.E / @ h.E.p o *.( o o.< *.~ o * o.~X=X= I.p.q.~ o o *XdXd * 2XXXdXd *.#.q.(X=.<.p P h O.<.D & E.D.:.b.:.D &Xd.2 k k.DXd.:.b.D.:X5.b.b.b.b.DXd.:.: o *.(.(X= *.(.(X..q.(Xd o.q.qX8.p #.( *.D.~X=.qX8 h oX= o VX8 # t.TXd oX=.q o o 1 1.~ V.:Xd.:.:.D 1.D V X HX=X=.fX= >.M.qX8 V.e @X=.G.p.G I.. @.M . @ t.pX=X=X= #.K # I ,.p o o.( o.~ o.(.:Xd &Xd o o V.:.: oX=.(X= oX=.(.p o *.<Xd &.< *Xd.r o.( o.:.DXd k kXd.<Xd H.p 1 VX=.q o.(.e @X= H.M.<.D.KXd o t.v.v.v.'.(X=.9.( P.( *X8.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O :.T t.(.~ V.rX= o.~ M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M oXd.`.f ,.eX=.K.p.e #.G.. @ @ h # H.K...M t t t @.TX=.e.pX=X=X=X=.e hX=X8.q o.( o.( VXd &Xs.: * P * V o * o.(.p.p H HXd.<Xd.( *.< VXd.D.DXd o.b.< *.<XdXd.<X8.qX=X= 1 V o P.~X= #.e.K.eXd * h o.( h.M . t t.M *.( * R.( * o * H h * oX8.(.p.p o * o.( o *XX o.(Xd.D 1X=X=.p I.p I.pX8 oXd.< VXd V o &.<.< V oXX.(.(.q o PXX # hXd.<.<.: &.D.b.DXd V.< P.~ V *.<.DXd.D.b.b.b.b.D.D.:Xd VXd o P.(.( H P R *.KX=X=X8.p o # tX. *Xd.<.<X= o o *X=.(.( * t.MX..T t.(.~ V.rX= o.~ VXdXd.D.D XXdXd V.~ oXd.`.f ,.eX=.K.p.e #.G.. @ @ h # H.K...M t t t @.TX=.e.pX=X=X=X=.e hX=X8.q o.( o.( VXd &Xs.: * P * V o * o.(.p.p H HXd.<Xd.( *.< VXd.D.DXd o.b.< *.<XdXd.<X8.qX=X= 1 V o P.~X= #.e.K.eXd * h o.( h.M . t t.M *.( * R.( * o * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXX * o.( h # H.r V X M M M M M M M M M M M M.% M M M M M M M M M M M M M MXa M M M M M M M M M M M M M a M M M M M M M M M M M M M.3 M M M M M M M M M M M M M.I M M M M M M M M M M M M M M.% M M M M M M M M M M M M M M g M M M M M M M M M M M M M.% M M M M M M M M M M M M M   M M M M M M M M M M M M M.% M M M M M M M M M M M M M M a M M M M M M M M M M M M M.I M M M M M M M M M M M M M M   M M M M M M M M M M M M M.I M M M M M M M M M M M M M.3 M M M M M M M M M M M M M M.I M M M M M M M M M M M M M.% M M M M M M o V.K @.e @ h.e.K.h.(.~ o.r.f.e t.M.M t.M.M.M.pX= 1.f.K.( 1 VX=.~X=X= h.p.q * 1X=.( o 1 oXd o.< o V o.p H.h h.#.h.( #XX o.( *X8 o.< *.D l.b & & & &.D.b.D VXd.r V V Z *.#.( o o.< t.M tX..(.(.(.(.< t.M.M.MXb H m.1.p.K h h E.q.e.K.. t ( .Xb.M @.pXX o o V o.(.(.# * o o.K o oX=.K #..X=.~.~ I.K *.< oXd o.p h.p.p.( k.2 & &.( h V &.D &.b.DXd o *.< o &.D VX= V &.DX0.b.:.:.D &.D.: o.: V o V.DXd o.~Xd @.. # H.(.q oX= * P V o o.e.pX=.(.( H.p.(.<.TXX * o.( h # H.r V X 1.~Xd o oXd o o V o o V.K @.e @ h.e.K.h.(.~ o.r.f.e t.M.M t.M.M.M.pX= 1.f.K.( 1 VX=.~X=X= h.p.q * 1X=.( o 1 oXd o.< o V o.p H.h h.#.h.( #XX o.( *X8 o.< *.D l.b & & & &.D.b.D VXd.r V V Z *.#.( o o.< t.M tX..(.(.(.(.< t.M.M.MXb H m.1.p.K h h E [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.h o o.qX=.( h.( o o M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.~ VX. h I.K # I # V o oX= I h.q 1 1.p #.M t @./ h.(.E.p 1 1 1 oX=X=.e.(.qX8X= H.( o 1 o.q.=.~.(.qX8.(.(.p.( *.(.(.(.K.M.( o o h.( V V V.:Xs &X0 V o.D &.:.D V V X V 1 RXX.pX=Xd &.(.M.M.T.MXXXX P * tXbXbXb.M H B O.( h h h.# h t.M.MXb.v . .Xb ..M.rX=X8X8.q.~ oXd 1X=.p h o.q.(.p.K.EX=X= o.p.p oX= o V.9.p.(X= o * &.D o VX= *.<.b.:.: &XdXd R *.<XdXdXd V.~ V V.:.:.D.b.< &.: V.: & & o * VXd oXd V.e @ h.(.p.( o o.q o.( * o oX=.q.(.pX=.q.(.( H t h o o.qX=.( h.( o o.r o 1 o o o oXdXd V.~ VX. h I.K # I # V o oX= I h.q 1 1.p #.M t @./ h.(.E.p 1 1 1 oX=X=.e.(.qX8X= H.( o 1 o.q.=.~.(.qX8.(.(.p.( *.(.(.(.K.M.( o o h.( V V V.:Xs &X0 V o.D &.:.D V V X V 1 RXX.pX=Xd &.(.M.M.T.MXXXX P * tXbXbXb.M H B O.( h h h.# [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O O oX=X=.( oXd o o.( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M MXd e.: WXt.~.p @ #X= 1.(X=.( o.rX= 1.fX=X=X= V.~ 1 o t #X=X=X= C.pX= o o.~X=.p.pX= o 1 1.T.T.p.eX8.E.' h.(.(.<.DX=X8.T @ h *Xd o.(.(.( o.:X0.D.-.D.<Xd V o 1XdXdX= 1 oXX h.~X=.<.<.(X. # @ t.( t.(.p.M @.M.M t B t t h t t # @ t t.M.MXb.v.v . . .Xb ,.. @ # HX8 o V.~ o.p #.(X8X=.<.q HX= o V.TX..~X=X$ ,.E #X8.(.< V.(Xd.<.( h.< &.D V.b.D & k.<.<XdXd V VXd o.~Xd.D.D.:.D l.:.:.:.b V V o o.D o o 1 o # h oX=X= * o oX=.(.(.q.q V.pX=.(.(.(.p.p * # H O oX=X=.( oXd o o.(X=.~ o.~ V V V.DX=X=.pX=.~ 1.f.E.. @ #X= 1.(X=.( o.rX= 1.fX=X=X= V.~ 1 o t #X=X=X= C.pX= o o.~X=.p.pX= o 1 1.T.T.p.eX8.E.' h.(.(.<.DX=X8.T @ h *Xd o.(.(.( o.:X0.D.-.D.<Xd V o 1XdXdX= 1 oXX h.~X=.<.<.(X. # @ t.( t.(.p.M @.M.M t B t t h t t # @ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O :Xd.~ oXdXd oXd V V M M M M M M M M M M M MXa M M M M M M M M M M M M M MXa M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M M M M M M M M M.3 M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M a M M M M M M M M M M M M M a M M M M M M M M M M M M M   M M M M M M M M M M M M M g M M M M M M M M M M M M M M a M M M M M M M M M M M M MXa M M M M M M M M M M M M M M.I M M M M M M M M M M M M M.% M M M M M M M M M M M ( M a M M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M M.F.F.F.F.F.F ] h.e.q 1X= V V HX=X= H.K.q * * o &.~ 1 H.e.. #.T h h.p H.eX= oX=.p I.p.p o.eX=.p.M H # #.(.p.(.(X= *.=XX k.(.( h * o.qX= oX8 o.:Xd.= h 8.K.p.(Xd V V * *.< o.q *.<.q h O h.(XdX8 # h.( t t @.T.(.E #.(.<.T.(.( ..M t @ t tX..MXb.MXb . ..v.v.v .X8.=Xd o o I.p * o.<.(.pX=.p.( I.E.e.(.r oX=.KX= 1.pXd.< H.hXd * & o.D & &Xd & oXd V.b.< &Xd o o V.D.D.DXd VXd V.:.b.:.D lXd V V.<.~ o @.( * * V o o o.q.~X= o o o 1 * o @X=.q o o.~ o h hX.Xd.~ oXdXd oXd V VX8XX o 1X= o o V 1.r.( o 1.DX=.f.K h.e.q 1X= V V HX=X= H.K.q * * o &.~ 1 H.e.. #.T h h.p H.eX= oX=.p I.p.p o.eX=.p.M H # #.(.p.(.(X= *.=XX k.(.( h * o.qX= oX8 o.:Xd.= h 8.K.p.(Xd V V * *.< o.q *.<.q h O h.(XdX8 # h.( t t @.T.(.E #.(.<.T.(.( . [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( P V o o o * o o.~ M M M M M M M ( M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M.F.F.F.F.F.FXd.G.z 1 ZX= I 1X=XX o O.( o o V V ZX=.G.E ,.K #.p.(X. tX. #.( o.p HX= 1X=X= #.(X= t @X. @ h H.9.( * * &.D o.( *Xd.< &Xd 1 o oXd.D.D.p t @...p.p.< V P *.<Xd & &Xd o.<X.XdXd.bXdX= HXX.< t t.T.q , tX= * P P.< *Xb @X. @ t.MX. h HXb . . ..MXb t ..M.( o.<Xd.(XX V.~Xd o.(XX.(.(.(.(.p ,.pX8 o t.p V.p C.< h.# &XdXdXd &.: V.2 P t o &.D &.D &.<Xd & V.: V & V V.:.D.:.b.:.D oX= o V VXdX. P.( o oX=.~ o o.~ o.~.~ o o o.q.(X= o.q o 1 1 o.(.( P V o o o * o o.~.~ o o.(.e o 1 oX8.(Xd.~.(X8.p H.p.G.z 1 ZX= I 1X=XX o O.( o o V V ZX=.G.E ,.K #.p.(X. tX. #.( o.p HX= 1X=X= #.(X= t @X. @ h H.9.( * * &.D o.( *Xd.< &Xd 1 o oXd.D.D.p t @...p.p.< V P *.<Xd & &Xd o.<X.XdXd.bXdX= HXX.< t t.T.q , tX= * P P.< *Xb [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0 h * V.~ 1 V.~ o V M g M M.% M MXh M M.I M.I M M + M M g M M.I M MXh M M.% M M M M.I M MXa M M a M MXa M M a M M.I M.I M MXa M M a M MXa M M.I M M.I M.I M M.% M M.I M M.% M M g M M M + M g M M g M M.% M M.% M M g ( M g M MXh M.% M M.I M M.I M M + M M.I M M.I M.% M M g M MXh M M + M M + ( M.% M M M M g M M.I M M g M M.I M MXa M MXa M.I M M.3 M MXa M M.I M M   M MXa M M.I M M g M M + M M.I M M.I M M g M M M M.I M MXa M M g M M.I M M.I M M.I M g M MXa M M   M MXa M M   M M.I MXa M M   M M.3 M M g M M.I M M.I M M (.F.F.F.F.F.F e IX= 1 V.eX= VX= P.~ * oX=.q.~X= I.e #.e.K...(X=.(.K h.(.p P.q H.K #.rX=.p h h.# @X. h.( h.K.( o oXd V.<Xd.<.<Xd V.b & VXd.~.:Xs VX=.e t # H VXd.r * oXd.<.D.:.DXd.<XX & &.D.D.(.(.( R @ t H.p tX.X= o o P.<Xd t.M @.M.M t P h @ h.M . . t.M @ t ..E.<.q V V o.~ V V.<.q oXdXd V.<X=.K #.E.q.(.p V V.f.~ & o &Xs &Xd oXd.= o @ h &.D.:.D *Xd V &.: & V.D VXd.:.DXd.D.D X 1 o.p.qXd oX=.hX8.p.qXd V V.~ o o o V o o o o.(.q.pX8 oX=.q oX=.(.p h * V.~ 1 V.~ o V.r o.~.qX=.p.( h OXd.r VX= H hX=X= IX= 1 V.eX= VX= P.~ * oX=.q.~X= I.e #.e.K...(X=.(.K h.(.p P.q H.K #.rX=.p h h.# @X. h.( h.K.( o oXd V.<Xd.<.<Xd V.b & VXd.~.:Xs VX=.e t # H VXd.r * oXd.<.D.:.DXd.<XX & &.D.D.(.(.( R @ t H.p tX.X= o o P.<Xd t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O *.( oXd * * o o o.~.6 $.6.6.6.6.6.6.6.6.6.6Xn.6.6Xn.6.6.6.6.6 $.6.6.6.6.6.6.6.6.6.6.6.6 4.6.6.6.6.6.6 $.6.6.6.6.6.6.6.6.6.6 $.6.6.6.6.6.6.6 $.6.6.6.6.6Xn.6.6.6.6.6.6.6 $.6.6.6.6.6.6.6Xn.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6Xn.6.6.6.6.6.6.6.6.6.6Xn.6.6Xn.6.6.6 $.6.6.6.6.6.6.6.6 $.6.6.6.6.6.6.6.6.6.6.6 $.6.6Xn.6.6Xn.6.6Xn.6.6.6.6.6.6.6.6.6.6.6.6.6.6Xn.6.6Xn.6.6.6.6.6.6Xn.6.6.6 $.6.6 $.6.6Xn.6.6.6.6.6.6.6Xn $.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6.6Xn.6.6.6.F.F.F.F.F.F.;.( 1 1.GX= o o k.~ oX8.pX= V V V oX=.p.p # h V V 1X= o o o H #.p H.p.(X= o.K.K tX=X8.~ o.(.q o o o.D & &Xd.< *Xd V.< XX= *Xd.D.:.D V.(.p.p H o H.T * V o.<Xd o.9XX oXsXd.<XdX8 OXd o.9 O.K @ @.M H o P o.# h #.M.M.M.M @ h o.f.KX. t.M t t @Xb.M.M @ . #.( H.K h.K.e o * o.< 1.D o VXd 1 o.( o.p @ oXd.e.( * o oXd o $ P *X. * & &.b &.<.:.D.:.DXd.D.D.:Xd VXd &.:.: 1.. H.q.K.( o.e t o.p * o VXd.~ o *Xd o.~ o * V.(.q.( h C o o *X8 o.( *.( oXd * * o o o.~ V.~ o.# $ s B.( P * o.~.<XXXdX=X8.( 1 1.GX= o o k.~ oX8.pX= V V V oX=.p.p # h V V 1X= o o o H #.p H.p.(X= o.K.K tX=X8.~ o.(.q o o o.D & &Xd.< *Xd V.< XX= *Xd.D.:.D V.(.p.p H o H.T * V o.<Xd o.9XX oXsXd.<XdX8 OXd o.9 O.K @ @.M H o P o.# h #.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.p.(.< o o.(X=.(.~X,X,.$X,X,X:X,.XX,X,X:X,X,.$X,X,X:X,X,X,X,X,X,X,X,X,X:X,X,X:X,X:X, |XjX:X,X,X,X:X,X,X,X:X, g.I.7X,.$X:X,X,X,X,X, |X,X,X,X,X,X,X,X,X,X,.$X,X:X:X,X,X,X,X,X,X,X,X,X:X,X,X:X,X,X,X:X,X,X,X,X,X:X,X,X,X,X:X,X,X,X,X,X:X,X:X,X,X:X,X,X,X,X,X,X,X,X,X,.$X,X,X,X:X,X,X,X,X,X,X,.$X,X,X,X,X,.$X,X:X,X, |X,X,X,X:X, |X,X,X:X,X,X,X,X,X,X,.$X,X,.$X,X,X,X,.$X,X,X,X,X,X,X,X,X,X,X,X,.$.I.I.I.I.$XjX,X,X,X,X,X,X,X,X,X,X,X,.$X,.$X,X,X,X,X,X,X,.$X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,.$X,X,X,.F.F.F.F.F.F J 1.G 1 o *.~Xd V VX=.pX..eX= o VX=X= 1 V 1 o.~.r o o.r o.( #.(.p.p.(.e H H.T @ H.T hX=X8.p.<.< k.D.D P &.( R.< VXdXd.r V 1Xd V &XdXd V VX8.p #X. O.~ o o P.(.(.q.< o &.< *.< h h.= P h h.( @ # h *Xd.2.< P.p tXb.M t t.M t / h o.(.(.( tXX h.M.M.. t tXbX8.(XX # @ @ o.< VXd.q.D.D 1X= *.( oXd o hX=X=.(.. I o *Xd o R.(.p.#Xd &.:.: &Xd &.D & &.D VXd.D.DXd V.D V V.E # H o o.qX=...T.p.T o h oXd V o * * oXd o.< oXdX=.q o.rXd o o.q.p.( o.p.(.< o o.(X=.(.~ V V PXb.v j.M B * 1.<Xd VX= X oXd 1.G 1 o *.~Xd V VX=.pX..eX= o VX=X= 1 V 1 o.~.r o o.r o.( #.(.p.p.(.e H H.T @ H.T hX=X8.p.<.< k.D.D P &.( R.< VXdXd.r V 1Xd V &XdXd V VX8.p #X. O.~ o o P.(.(.q.< o &.< *.< h h.= P h h.( @ # h *Xd.2.< P.p tXb [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& o.( o o o o o o 1X,X,X,X,X,X,X,.$X,X,X,X, gX,X,X,X,X,X,X,X,X,X,X,X,X,X, gX,X,X,X,X,X,X,X,X,X:X,X,X, g.$Xj.IX,X,X,.7XjX,X,X,X,.$.IX,X,.$X,.$X,X:X,.$X,X,X,X,X4X,X,X,X,X,X,X,X,X:X,X,X,X,X, gX,X,X,X,X:X,X,X,X,X,X,X,X,X,.IX:X,X,X,X,X,X,X,X,X,X,X,X, gX:X,X,X,.$X,X,X,.$X,X,X,X,.I.$X,.$X,X,X,X,.$X,X,X,X,X, gX,X,X,X,X,X,X,X,X,X,X,X,X,X, gX,X,X,X,X,X,X,X:X,X,X,X,X,.IX:X,X,X:.$X,X,X:X,X,.IX,X,X,.7.%.$X,X,X,X,.$X,.$X,X,.$X, gX,X,XjX:X,X,X,X,.$X,X,X,X, gX:X,.$X,X:X,X,X:X,.$X,X,.$X,.IX,X,X,X:X,X,X,X,X,.$X,X:X, gX:X,X,X,X,X,.F.F.F.F.F.F ~ oX8 o oXd.D.c.D 1 *X=.p.(.G.p * 1 o *Xd 1 o.pX=X= 1X=X=.p.p H h H H.(X=.p @ #.(.(.( o.(.T *Xd &.D &Xd.2.<.:Xd k o.<.~Xd 1 1.( V VX=.(Xd.fX= # #.# V.<Xd o o o o.( hXd.< o *X8.T R.( h t # t t.p h oXX.h # t t t t t @ tXb.T h.p.e.e.p.qXdXd.(.M . t t.M.K.E o.( h #.e.p o oXd.~.DXdX=X= oXd VXd VXd *Xd.M...pX8 o VX=.pX=.(.~ &.D V E & V.D.D.:.:.DXd.:Xd VXdXdXd V.p.(.(.~ V.r t t *.pX. o.qXX.( V.~.~ * o oXd o * o *X=.~ o V o o.( o o o o.( o o o o o o 1 V o R B b.#.# B kXd.DXd oX=.r * X oX8 o oXd.D.c.D 1 *X=.p.(.G.p * 1 o *Xd 1 o.pX=X= 1X=X=.p.p H h H H.(X=.p @ #.(.(.( o.(.T *Xd &.D &Xd.2.<.:Xd k o.<.~Xd 1 1.( V VX=.(Xd.fX= # #.# V.<Xd o o o o.( hXd.< o *X8.T R.( h t # t t.p h oXX.h # t t t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&X8X=X= 1.f 1.e H jX,X,X,.$X,X,X,X,.$X,X,X,X,.$X,X,X,X:X,X,X,X,.$X,X,X,X,X,X,X,X,X,X,X:X,X,X,X,X,.$X,X,X, gX,.I.I.7X, gX,.$.$X,X,X,X,X,X,X,X,X,X,X,X,X,X:X,X,X:X,X,.$X,.$X,X:X,X,X,X,X,.$X,X,.$X,X,X,X,X,X:X,X,.$X,X:X,X,X,X,X,.$X,X,X,.$X,X,X,X,X,X,X,X,X,.$X,X,X,X,X,X,X,X,X,.$X,X,X,X,X,X,X,X,X,X,.$X,X:X,X,X,X,.$X,X,.$X,X:X,.$X,X:X,X:X,X,X:X,.$X,X:X,X,X,.$X,X:X,X,X,X:X,X,X:X,X:X,X:.I g.I.IX:X,X, gX,X:X,X:X,X,X,X,.$X,X,X,X,X,.$X,X,X:X,X,X,X,X:X,X,X,X,X,X,X,X,X,.$X,X,X,X,X:X,X,X,.$X,X,X,X,X,X,X:X,X,X,X,X,X,X,X,.$X,X,X,.F.F.F.F.F.F W oXX o o.< * o V o V 1 oX= oXd o o o *.(.(.e.p h.(.(.(.(.p.K #X=X=.q *X8.(.p @.(.(.e.( oXd o & V * &.D.D &Xd.< &.:.<.: & o.q.( o o o H.K h h.T.T.T * V.<Xd.< o.( o hXd o V.<.<.p.M s.'.9.q . P h t t.M @X.XbXb . .Xb tXbXb t H HXX.(Xd.~ o V.~.K.K.e.e @.K h t , 1 V.p.( h.( C 1 o o.~X=.(.pX=.r o V.D.: t @.. @ t.. H.(.(Xd V.D.:.b.D.D & VXdXd.D.DXdXd V V VX=.qX=.p H.~ o.~X=.(.q.< *.D V o.~ o 1 o 1Xd V V oXd o.< 1 o oX=Xd o o.q.q P.~X8X=X= 1.f 1.e H j $ B P.( RXdX8 * P.~ VX=.~X= o.~ 1 oXX o o.< * o V o V 1 oX= oXd o o o *.(.(.e.p h.(.(.(.(.p.K #X=X=.q *X8.(.p @.(.(.e.( oXd o & V * &.D.D &Xd.< &.:.<.: & o.q.( o o o H.K h h.T.T.T * V.<Xd.< o.( o hXd o V.<.<.p.M s.'.9.q . P h t t.M @X.XbXb . [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.~.GX=.e ,.e t.MXbX,.$X,X,X,X,.$X,X,X,X:.$X,X,X:.$X:X,X,.$X:X,X,X:X,.$X:X,.$X,X,X:X,X,.$X:.$X,X:X,X,X:.IX,X,X, gX,X:X, gX,X,X,X:X,.$.$X,X:X,X:X:X:X,X:X,X:X,X:X,X:X,X:X,X,X:X,X:X,X:X,X:X,X,X,X:X,.$X:X,X:X,X:X,X:X,X,X:.$X,X:X,.$X,X:X,X,X:.$X,X:X,X:X,X,X,X:X:.$X:X:X,X:X,X:X,.$X,X,X:X,X:.$X:X:X:X,X,X,X,.$X,.$X,X:X,X,.$X,X:X,X,.$X,X,X:.$X,X,X:X,X,X:X,X:X,X,X:X,X,.$.XX,X:X:X,X,X,.IX,X: gX:X,X:X,X:.I.$X,X,X,.$X:X,X,.$X,.$X:X,X:X,.$X,X:X:X,.$X,X:X,.$X,X:X,X:.$X,X,X:X,X:.$X,X,X,X:X,.$X,.$.$X:.$X,.$X,X:X,X:.$X,X:X,X:X,X,.F.F.F.F.F.F.: o o #.p o P *Xd.DXdXd o o V.D VXd.r.< V o.qX=.p H h H o VX=.p HX=X8 o.(.h.(.p o.~.rX= V.= P.D &.D &.:.D V o P.2.b.:Xs.D o.q o 1.~.p H h.p.( h.T hX=.(Xd.D &.p h.( *.<.<.<.(.(.#.MX. h.(X.XbX= o h.v.vXb.v ( ..v.v.v . .Xb t @ h o o o.( PXd *.(.( t t.p.MXb t.M.T I #.p HX=.e ,X=.e.eX=.# # @ @ @X= X 1 hXXX= @ # t.EX8.p V.~.(.D.:.:.:XdXd & &.:.: VXd V.~ o o o 1 # o V.~X=X= o.~ o h.DXdXdXd V o V V oXd.~ V.< V.D &.D * *.D.<XdXd o 1 o.~.GX=.e ,.e t.MXb j B oXd.D V.: V o.K o C 1.~Xd 1 o o o #.p o P *Xd.DXdXd o o V.D VXd.r.< V o.qX=.p H h H o VX=.p HX=X8 o.(.h.(.p o.~.rX= V.= P.D &.D &.:.D V o P.2.b.:Xs.D o.q o 1.~.p H h.p.( h.T hX=.(Xd.D &.p h.( *.<.<.<.(.(.#.MX. h.(X.XbX= o h.v.vXb.v ( ..v [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.e.TX..M.M.M . .Xb.$.$.$.$.$.$X:.$.$X:.$X:. .$X,X:X,.$ TX:.$.$.$X:.$.$X:Xr.$.$.$X:.$.$.$.$X:.$X:.$ T d dX: T.$ d.$X:.$ dX: T.$X: d.$.$.$.$.$.$.$.$.$X:.$.$X: d.$.$ T.$ T.$X:.$ T.$X:X:.$ T d.$X: T.$.$.$.$ T.$X:.$.$ TX:Xr T.$X:X:.$.$.$.$.$.$X:X:.$Xr T TX:X:.$X:X:X:X,.$.$.$X:Xr.$X:X,X:.$X,.$X,.$X:.$X,.$ =.$X,X:X,X:X,.$X:X,.$X:.$.$X: =X:X:X,.$X,X:X,X,X:X,X:X,X: =X,X,.$X,X,X:X:X: =X:X, =X:X,.+X:X,.+X:.$.$X:X,X,X:X,X,X: uX,.$X,.$X:X,.$X,X:X,X,X:X: u.$.$X,X,X,.$X,X,.$X,X,X:.$X, QX,.$X,X,X,X,X,.$X,.$X,X:X,Xw.$X,X,.$X,X,.F.F.F.F.F.FXd * o.(.T o * k V VXd V.~.~ 1 1 o VXd V oXd 1 o o o.pX=.r V.rX=.q.p.p.T.(.( oX= o o.(.(Xd oXd.:.b.<Xs.DXd &.( k.< VXdXd.<Xd.~ oX= 1.K s h.K.K H #.p oX8 k o.#.9.( *X8.< P RX. O.# h.# P sX..M h @ t.v.v.v.v ..v .Xb .Xb ..M.M.M.( o o * &.:.DXX o 1 @.E.KXbXb.MX..' #.T.p.p.. t t.T.T # t.( H.M.M.M #.e t 1 X o.E.K t @.KX=Xd V.<Xd & V VXd &.D V VXd.~ o o o.~ V o.~.` V o oX=.p.~ VX=.~ V V V V VX= o.~Xd V.~ VXd.DXd.D &.< o &.:.D.D oX=X=.e.TX..M.M.M . .Xb j O *Xd V V.c 1X=.p I ,X=X= o o.( * o.(.T o * k V VXd V.~.~ 1 1 o VXd V oXd 1 o o o.pX=.r V.rX=.q.p.p.T.(.( oX= o o.(.(Xd oXd.:.b.<Xs.DXd &.( k.< VXdXd.<Xd.~ oX= 1.K s h.K.K H #.p oX8 k o.#.9.( *X8.< P RX. O.# h.# P sX..M h @ t.v.v.v.v ..v . [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.M.v.v.v ..MXbXbXbXb.$.$.$ T T.$ T.$ T T T.$ T.$ T T T T T T T T T T T T T T T T TXn T T T T T TXnXMXn T.P $ TXM.PXM $ TXfXM T $ TXn $ TXM $ $ T $ TXMXn TXMXn T T $ TXM TXMXMXn $ T $ T T $XM T $ TXM TXM T T T TXM T T T T T T T TXM T T T T T T T T T T T.$X+ 0 T T T T T T T.$ T T.$ T T.$ T T T.$.$ T T.$.$.$ T.$.$.$ T.$.$ T.$.$.$.$.$.$.$.$.$.$X: T.$X:.$.$.$.$X,X:.$.$.$X:.$.$X,X:Xr.$ TXrX:X:X:.$.$XrX:X:X,.$.$.$X,X:.$.$.$.$X:X:X,.$X:.$.$X:.$.$X,X:.$X,X:.$.$.$X:.$.$X:.$.$X,X:X,.$X,X:.$X:.$X:.$X:.$X:.$.$.$.$X,X:.$X,X:X,.F.F.F.F.F.F.: o o V o.p P oXX.~ o 1 V o VXd V.( o o V 1Xd *.~.D V 1 H.p.K.e.r.( oX8.p.( o o.r oXd o o.= & o.(.<.D.DXd.( tX..pX= H *XX.( 1X= h.p.# $XX.p h.(.q.(.( k oXX o.' o.K.M P k 1.#.#.(.1.q.(Xd o *.# t t.v.MXb ..M t.# t.M t t # H.p HXd V V.D.:Xd VX=.e I * h hX. t.M.M.M./.MX..# h.# * o *Xd.~X8.( H.(X=.< o.~.< h.K.T @ t # #X= H.( V V kXdXdXd o * o.~Xd V VXd V o.p.K o.(Xd.p.p * o hX= V VXd.~ 1 V o.p.( o & V V.< oXd &Xd o * V.:.DXd o.' ..v.v.v ..MXbXbXbXb.#X= V h.p o.p.p.qXd h * o *.q.( o o o V o.p P oXX.~ o 1 V o VXd V.( o o V 1Xd *.~.D V 1 H.p.K.e.r.( oX8.p.( o o.r oXd o o.= & o.(.<.D.DXd.( tX..pX= H *XX.( 1X= h.p.# $XX.p h.(.q.(.( k oXX o.' o.K.M P k 1.#.#.(.1.q.(Xd o *.# t t.v.MXb ..M t.# [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXb ..v.vXb.TX. h O s.$ T.$ T.$ T T T T T.$ T T T T T T TXn T T $ TXn T $Xn T $ TXM TXM T $XnXMXMXM TXMXMXf T $XMXfXMXMXMXfXgXMXMXM $XM $XnXM T $XnXM $ T T $XM $Xn $ T $XnXMXnXM T $ T $ TXM TXM T T $XnXMXnXM $ T T $ TXM TXM TXMXn T T T T T T T TXn T T TXM 9 9 T T T T.$ T T T T T T T.$ T T.$ T T T.$ T.$ TX: T T.$ TX: T.$ T.$ T.$ T.$.$.$X:X:.$.$X:X:.$ TX:.$X:.$.$X:.$X:.$X:.$X:X:. X:X:Xr TX:.$X:X:XrX:X:XrX:X:X:X:.$X:.$X:X:.$.$.$.$.$.$X:.$.$X:.$.$X,.$X:X,X:X:X,.$X:X,.$X:.$.$X:X:.$X,X:.$X,.$X:X,.$X,.$X:X,X:.$X,X:X,X:X,.F.F.F.F.F.F ~.~ V.~ o.(XX.< o.GX= o V o VXd VX= o o VXdXdXd o.<Xd.~XdX= h.(X= 1 o.(.pX8 V o *.~ V 1 oX=Xd.<.<.D V.q o.DXX * oX=.(.< *.( V.(XX.(.# B sXX.( k o.# o.< o o.= #X. tXb.D o o B.#XX P *.<.<Xd.(.p.M.MXbXbXb t tX..#.' t tX. H.p H hXd V &Xd &.:Xd.~X8.p o & o h @ t.M.M.MXb.M t # H.( o.( o.D.<.p.q.G.E C VX=.GX=.p.q # @.K.K.e.(.(.DXd.~ * o P oXd V.<XdXdXd VXd.q.(.p h * V.e.pX= 1.p.(Xd.<.~ o oXd.~X8.h *.<XdXd.< & &.D.:.p , o &.D k PXb.v ..v.vXb.TX. h O s.~ 1.~ h.qX8 oX=.( VXd V 1X8 o.< V.~ V.~ o.(XX.< o.GX= o V o VXd VX= o o VXdXdXd o.<Xd.~XdX= h.(X= 1 o.(.pX8 V o *.~ V 1 oX=Xd.<.<.D V.q o.DXX * oX=.(.< *.( V.(XX.(.# B sXX.( k o.# o.< o o.= #X. tXb.D o o B.#XX P *.<.<Xd.(.p.M.MXbXbXb t tX..# [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O j j.[Xb h.p I I.K.pX: T T T T T T T.$ T T TX+ T T T T.$ T $ T TXM TXM T TX+ T T T TXn $ TXM T TXM.aXf. .! c.! c. .JXf dXf.Q dXfXf dXfXfXfXfXkXfXfXfXfXfXfXfXf. XfXfXfXfXfXfXfXkXfXfXfXfXfXf. .$ $ TXM TXMXM TXn.aXfXfXfXf p.!XfXfXfXfXf.!XfXfXfXfXfXfXuXfXfXfXrXuXgXfXgXfXgXfXgXfXuXgXfXfXgX:.$ T T.$ T TX: TXz T.$ | TX:.$ T TX:.$ T.$ T.$ d.$X:.$ TX:.$.$X:.$.$X:.$X:. X:.$X:.$.$X: T.$X,.  p 'XrX: pX:XrX:X:X:XuX1X:X:X:X,X:.$XrX,.$X:X:X:X:.$X:.$X:X,X:X,X1X:.$X:.$.$.$X:.$.$X:.$X,X:X:X1X,.$.$X,X:.$.$X,X:.$X,X:.$ =X:.$X,X:X,X:.F.F.F.F.F.F.:Xd.rXd o V o.q.<.~X8.r o PXd V V.~ X V * o V V V oXd o V V 1 1.( o o o 1 o V o 1 V 2Xd o o V *.(Xd.D o * & V o 1 o oX8 o.D.D.<XX.#XX.#.( k P o * P.<.<.< P.( @ ..M o.(.(.# $ h P * oXd o * P HXb tX..M.M.(.T H.q *.M.K.E.p.( / t o.( VXs V.D V V o.pX= 1.<.K tXb t t t.M . t @ @.p.p H o.( o @ ,.. t @.e.~X=X= I I.(.e.E.. t.K o.~ oXd.<.~ o o VXd VXd V V 1 o oX=X=X= o o.(.(.~ oX=X= oXd VXd.~ 1Xd o P.< o &XdXd V.D.D.D.. t.pXd & VXX bXb j.[Xb h.p I I.K.p VX8.# X 1.KX=.q.(.D V H h.(X8.q oXd.rXd o V o.q.<.~X8.r o PXd V V.~ X V * o V V V oXd o V V 1 1.( o o o 1 o V o 1 V 2Xd o o V *.(Xd.D o * & V o 1 o oX8 o.D.D.<XX.#XX.#.( k P o * P.<.<.< P.( @ ..M o.(.(.# $ h P * oXd o * P HXb tX..M.M.(.T H.q [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXX.MXb t.f.r.fX= 1.~.$.$ T T T.$ T T $ T T T T T TXn T T T T TXn TXM T T $XnXM T T TXM TXn T $XnXMXf.J 9 vXzXzXz v 9Xz 9 9.^Xz 9.^ 9XzXzXz 9XzXz 9XzXzXzXzXzXz 9XzXzXzXzXzXzXz cXzXzXzXzXzXu Q.N |XnXMXM TXM TXMXf d c.J.J.J. .J. . .k. . Xu. Xu. Xu. Xu. Xu. Xu. XuXuX1Xu. XuXuXuXuXuX7.o A 7.$ T.$ T T.$ TX:.$ TX: T.$ TX:.$ T T.$X: TX: T.$ T TX:X:.$ T.$ TX:.$.$.$X:X:X:X:X:.$X:.$X1X: TX:Xu TX:X:X: pX:.$XrX:X: pX7X:X:X:X:X:X:.$X:X:.$.$X:.$X:X,.$.$X:.$X,.$X,X:.$X:X,.$X:X:.$X,X:.$.$X:X:.$X:.$.$X,X:.$.$X,.$X,X:X,X:X:X:X,X:X,.F.F.F.F.F.F.:.(Xd o V VXd V * P.(.qX= o o 1 o o.T #.~ V oXd V.~ V.~X= *X8.( oX=.rXd.r.~ VX=X= o 1 V.r V V o k o V o o o.D VX= oXdXd.b.b.< k VXd o P o o.( &.(.( P P o.(.(.e @ # hX8 s . sXX.(.< PXd o o * o h o * o o H #.K t @ t.p.p P o.( o 1.DXd * V V V V H 1 o.(.e.q @.D h . q @ # t t t t h V oXd o.M tXX o 1X=.~.p.p.. t t.. @ @ @ t t HX8 o oXd V o.< V o oXd 1 V oXd oX=.(X=.p.(.~ V.h o oX= o o.( oX= o.~X= VXd o V V.DXd.:.D.h 1 o V.~Xd 1 oXX.MXb t.f.r.fX= 1.~.q 1X=.G.K * o 1.r * P P.2Xd V * o.(Xd o V VXd V * P.(.qX= o o 1 o o.T #.~ V oXd V.~ V.~X= *X8.( oX=.rXd.r.~ VX=X= o 1 V.r V V o k o V o o o.D VX= oXdXd.b.b.< k VXd o P o o.( &.(.( P P o.(.(.e @ # hX8 s . sXX.(.< PXd o o * o h o * o o H #.K t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( @ #...G I.q 1 1 o.$ T T T T T T T.$ T T T T T T T T T T $ TXM T $ T $ TXM T TXMXMXn T $ T TXM T.R.c D fX  f.>.> f.> f.>.> f.>.> f f f.> f f.> f f f f f f 6 fX*Xm 6.} 6X* 6 6 6 6.c.c 6 9 Q.N +.a $ TXnXM $ TX+ vX0X0X0X0.Q.Q.Q.Q.Q.Q.Q n.QXf.Q nX3 n.uXfX3.uX3.uXf.R.u.u.u.u v.R.u c.8XwX+.$ T T TX: T T T TX: TX:.$ T TX: TX:.$ T T.$ T.$X:.$X:.$.$X: | T.$X:X:X:X:.$ T.$.$X:X:. . X: TX:X: p pX1. X:X:X:X:X:X:X1. X:X,X:.$.$X:X:.$X:.$X:.$X:.$.$.$X:X,X, |.$X:.$X,X:.$X,X:.$.$X:.$X,X:X,.$X:X:X,X:.$.$X,X:.$X:.$X:X:.$X,.$X:X,X:.F.F.F.F.F.F.:.< VXd VXd V 1 o.< oX= o 1X= o o.(.(.p.( o *.~ V o.~X8 H P.(X= o o 1X=X8.~ o.(.( o V o V.~ V.w &.= V.~ 1.:Xd.: o.D oX5X0.DXd o.~Xd P.( o P * o P.< * *.(.( hX=.h.e h sXb.vXX.( h o P o.(.<.<.(.(.q V o.( h.T #.K.TX..T.pX=X=.9.=.p 1 o V o.~.< o h o o o HX=X..E.eXb t t @.M.M.M t t #.( o o.q 1.~Xd VX= IX8.q.K @ t @ @.K.K @ @ t t.p o VXd.~.< o o o VXd V.~ V o.~.K #.p H.~.~X8.~ oX=.qX=.(.(.q.~ o 1 V V.q.<Xd XXd o.p 1 X.DX=.~.: 1 1.( @ #...G I.q 1 1 o o o.f # #.q.=.(.( 1XdXd.<.1X= o o.< VXd VXd V 1 o.< oX= o 1X= o o.(.(.p.( o *.~ V o.~X8 H P.(X= o o 1X=X8.~ o.(.( o V o V.~ V.w &.= V.~ 1.:Xd.: o.D oX5X0.DXd o.~Xd P.( o P * o P.< * *.(.( hX=.h.e h sXb.vXX.( h o P o.(.<.<.(.(.q V o.( h.T #.K [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.E w @.f I I.fX=.(X: T.$ T T T T TXn T T TX+ T TXM T TXn T TXnXM T TXn TX+ $XM T $ TXMXn $ T $.X NXm.>.A.x <.AXq < <.AXq.A <XqXqXqXqXq.A.A.A.AXq.A.A.A.A 8Xq 8.A 8.A 8.A 8 8 8 8 8.c 6.;.^.8.8 g g 7XnXMXM T 8 c.Q.Q.t fX8 f.>XmXm.> 6Xm f 6 f 6Xm 6.}X* 6.} 6 6.; 6 6.c.;.}.Q v v.u.JXw.8 g T T.$ T T T T T d T T TX: TX:.$ T T TX:.$ TX: d.$X:.$X: T.$.$.$ |.$X:.$ TXr.$X:X: T.$ p p.$X:X:X:X: TX:XrX:X:X: pX:X:XuXu.$.$X:X:X,XrX:.$.$X:X:X:X,.$X:.$X:.$X:X1.$ |X,.$X:.$X:X:X,X:X:.$X:.$X1X,.$X,.$X:X,X:.$.$X,.$X:X,X7X,X:X:X:X:X,.F.F.F.F.F.F l & h o o 1 o o.q * * o V oX=X=.(X= oX= o o VX8.q.(X8.h.q.~ o o o V o H.( o.( oX=Xd o o VX8 tXs V &.D.D.<.b &.b.< *.<.b.: & &.<X8.<.< P * o P P.~.9 *.<.<X8.p.(X= h t b.vXbXX.#.# o.(X= R &Xs.h o oX=X=.h.( H.T.p.K.p.K.T #.pX8X8.(X=.q 1Xd VXdXd k.( o.~XX * V.v.M.v t t.MX..M #.M t @ P.<X= o 1Xd 1Xd o o.p.K.K.E @ t t @.p.. t @.T @.p o 1Xd.~ o o.~ o.<.~XdXd o 1 @.h H.(.r o.~Xd.~X= o.(X=.~.q 1.~ o.(.r oXd V.<.9 @ #.~ VXd.< V.4 1.GX=.E w @.f I I.fX=.(.Y I.G h *X8X=.( * o & VXdXd * o k & h o o 1 o o.q * * o V oX=X=.(X= oX= o o VX8.q.(X8.h.q.~ o o o V o H.( o.( oX=Xd o o VX8 tXs V &.D.D.<.b &.b.< *.<.b.: & &.<X8.<.< P * o P P.~.9 *.<.<X8.p.(X= h t b.vXbXX.#.# o.(X= R &Xs.h o oX=X=.h.( H.T.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.e @ t t t.K.K >...E.$ T T T T.$ T T T TXn T T T T T T TXM T T T T TXM TXMXMXn T $ TXMXM TXn TXM.g v.> 8 <./././././././././././ <./ < <./././ < < < < < < < <.A <Xq < <XqXqXqXq.AX8.t.;.;X7.8.N.8 g gXeXM T $ 7.k.Q.t f 8.@.@.@.@.@.@.@.>.>.>.>.>.>.>.>.> f.> f f f fXm fXm 6.u.u.u F N N.N.N.g.$ T TX: TX:.$ T T T.$ TX: T T.$X:.$ T.$ T TX: T.$X:X:X:X: TX: T.$ TX:X:.$X: TX:X:. . XuX:. X:X: TX:X: TX: rX: 'XuXM. Xu 'X:X:X:X:X:X,.$ |.$X,X:.$X:X:X,.$X,.$X:X:.$.$X:.$X:.$X:.$.$X,X:.$X:X:.$X:.$ |.$.$X:X:X,X:.$X:.$X:X:X,X:X:X,X,.F.F.F.F.F.F J.D V.~ V.q H.q o o V H *.~.~ o o oXd o.(X..(.<.~.r.< o.r V o o o.~ o.~X=.(X=.(.(X= V.~ o.~ V * *.(.( V.D &.b.<.( *Xd.DXd &.< & 2 o.( oXd P P.( P.<.D o * h h #.. @.M.v ..( o &.<.( H # * oXdXdXd V.MXb t.(.(.(.(.p.T #.K #X. #X= V.(X8.( P o oX=.<.(.< k h H o.M.v.vXb .Xb t @ t @ h t t.pX8X= oXd & o o o P.(.K.p.pX= , #.(.~.~ @.K.T @ @ @X= o V o.q oX8.K.( # h # I.K @ #.K # o oX=.~ oX= oX=.qX=X=.~.( * V #.q.~ o.p.eXd.DXd.:.< 1.p.q.e @ t t t.K.K >...E @.` h.( P.(.D * o.DXdXd.D V o &Xd.D V.~ V.q H.q o o V H *.~.~ o o oXd o.(X..(.<.~.r.< o.r V o o o.~ o.~X=.(X=.(.(X= V.~ o.~ V * *.(.( V.D &.b.<.( *Xd.DXd &.< & 2 o.( oXd P P.( P.<.D o * h h #.. @.M.v ..( o &.<.( H # * oXdXdXd V.MXb t.(.(.(.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O I tXX.< h h #.. @ t.$ T T T T T T T T T T.$XM T $ T TXn T TXM TXM T TXM T TXM $ $ TXMXM T $ $ $.Q.QX  f.m 8 8Xq.x <././././ <./././ <././ < <./ <./ < < < < < < < < <.A.A 8X .>X* 6X*.;.t N.8 g g +.N.N.PXM TX0XzX0.t.c.c 6 6.>.>.@.@.@.@.@.>.X.>.X.>Xm.>Xm.>XmXm 6.c.t.Q n n F.u v v.8.8.N.NXf T TX: T T T T T TX: TX:X: T.$X: TX:.$ TX:X: TX: T.$X: T.$.$X:X:X: T.$.$X:X: T | TXuXu.J p pX:X: pX:X:X: pX:X:Xu 'X7 'Xu ' 'X:X:X:.$X:X:X,X:X:X:.$.$X,X:X:.$X:.$.$X:X:X,X:X:.$X:X:.$.$X:X,X:X:.$.$X,.$X:X,.$X,X:X:X,X:X,X:X:X:X:X,X:X:.F.F.F.F.F.F.) o o o o oX8X=Xd o o.( 1Xd V oXd o o V.q o o 1X8.~ oXd X 1 o o 1 2 oXd.rX= V oX= o o.e HX=X=Xd k VXd V V.<Xd V *Xd.< k.< V o &.D hX=.( o P.(.'.hXd & & &XX H.( @.K.TXb.M h &.:.b.p H.( o o V.DXd.D.M.M.M.K.E H.h H.T.KX..T t #X8 V.(XX.h * o.~ o VX8 *.<.( * *.(Xb.vXb.M.MXb @.M @ t #.T #.p o o V.D.D o.< &X8.p.pX=X=.e.E o 2 V H @ @ # t t.KX=X=.(X8 h.E @ @.p.(.p.K.K @.T t.K oX= o o o o.qX=X=X= o.~ o.(.p X X V I.p.~ V VXdXd V.~.(.q I tXX.< h h #.. @ t o o * o.q.r.<Xd.: V o o V o o &.< o o o o oX8X=Xd o o.( 1Xd V oXd o o V.q o o 1X8.~ oXd X 1 o o 1 2 oXd.rX= V oX= o o.e HX=X=Xd k VXd V V.<Xd V *Xd.< k.< V o &.D hX=.( o P.(.'.hXd & & &XX H.( @.K.TXb.M h &.:.b.p H.( o o V.DXd.D.M.M.M.K.E H.h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX= tXdXd o.( o t tX=.$ 0 T TXzXn T 9 T T 0 TX+ T TX+ T TX+XM.$X+ T $X+ TXMXg TXM T $Xf TXMXg T TXu.}.>X8 f z z.> z.GXq././././././ <././ <././ <./ < <././ <./.@.>X*.c.c.t ZX* 6X*.; ZX* n NX& gXw +.8 g.oX: $ cXz.t.t.t.t.t.t.Q.Q.u.c.>.@.@.>.>.>.>Xm.>.>Xm.c n.u v.u.u v.u.u v.R.uXz.8.8.N +X1 T.$Xz T.$ T T d.$ T d T T d TX: d T.$ dX: T d T d.$ TXr.$ | d TX:.  TX:Xr.$X: dXu.JXu '.J p rX: pX: p.  '.  'Xu pXuX: ' pX:. X:X:X7X:X:X7.$.$XrX:X:X1X:.$X7X,XrX:X:X1.$.$X1X:X,X1.$ |Xr.$X:Xr |X7X:.$ =X:.$ =X,X: =X,X: =.$X, =.$ |X,.F.F.F.F.F.F i * PXd o o.<.~.q o o.(X= o.~ oXd V VXd o 1Xd o.p o o 1 o.< * VXd 1 oX= o o V o.qX=.e.K 1X= o.2 k.:.<.<.~.( o o.< V o.<XdXd & &.D.(X8.p * o.( s.( o & V.<.9.p.p q.p.p.[ t H V.D.: * o.( o o o oX=.E t t t t t t.M.M t HX..p.M t.e V o H.= P &X8 * o.p o.e PXd.< o.T.vXb t.M.M / @ tXbX. @.K.pXd &Xd &.:.D V *.p.E.e.e.e.qX= 1.~ o o.e #.T.T.M t.K H.z.q.p.K @ t * oX=.e @.p h.p.( o.( H o o.~ oX=.q.~ o o.p @X= V.~Xd ,X= V 1.DXd V V o *X=X= tXdXd o.( o t tX=X8 o o * o.< o k.D V o.q.(.q H V.D * PXd o o.<.~.q o o.(X= o.~ oXd V VXd o 1Xd o.p o o 1 o.< * VXd 1 oX= o o V o.qX=.e.K 1X= o.2 k.:.<.<.~.( o o.< V o.<XdXd & &.D.(X8.p * o.( s.( o & V.<.9.p.p q.p.p.[ t H V.D.: * o.( o o o oX=.E t t t t t t.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.CXX oXd o o oXd o.p.$ T T T T T T T T T T T T T T T T TXn T T $ T TXnXM TXMXM TXM T T $ TXM T.X.kXf.c.cX*X* fX8.> zX8 8 <././././././ <././././././ <./ < $.@.c fX*X* fX*X*X*X* Z.c.t n vX7.8 + + + g.8.PXnX:.J.^XfX3X3 n n.Q.Q.Q.Q.Q 6.@.@.@.>.>.>.>.>.t v.u.u.uX3.u.u x v v v.^Xz.k N.8 g.NXeX: T T.$ T T.$ TX: T T TX: T T TX:.$ T.$ T.$ TX: TX:.$ TX:X:X:X:.$X:.$.$ TX:X: p. .J.JXu p pX:Xu p p p '.JXuXuX:Xu.JXu 'X:X:X1.$X:X:.$X,.$.X.$X:X,X:.$X:X,.$X:X:X,.$X:X:X:X,.$X:.$X:X,.$.$X,X:X,X,X:.$X:.$X:.$X:X:X:X:X:X:X:X:.$X:X,.X.F.F.F.F.F.F.:.(.q H o.<.D V V.~ V R * o.~ V V V.<Xd 1 o.~XdXd o oX=.q 1.D.: VXd V o o V 1 o.~ oX=X=.(.~.D.b V V 1 o.<Xd V oXd * o PXd.( o.<Xd.< o *.( *.(Xd.( o o * o.p @..X8.E.K H #.( V.~ o X X V.K #.. @.K.( @ t t.T t.M t t.M # t h t t.T o.( o.q 2 H oXd o.~ HXX.<.D & o o . .Xb .Xb.M t.M t t @.T.KXd oXdXd.DXd oX= H o oX=X= oX=Xd 1Xd V.~X8.E H h t.M @.E.K.p.p , #.e.p.( H.p # h.q.<.< o o o *.~.<.~ o oX=.e 1 o 1 &XdX=Xd V.D V V X X.G.q.p.e..XX oXd o o oXd o.p.< o o V.D &.< &.D P.<.< V V V * o.(.q H o.<.D V V.~ V R * o.~ V V V.<Xd 1 o.~XdXd o oX=.q 1.D.: VXd V o o V 1 o.~ oX=X=.(.~.D.b V V 1 o.<Xd V oXd * o PXd.( o.<Xd.< o *.( *.(Xd.( o o * o.p @..X8.E.K H #.( V.~ o X X V.K #.. @.K.( @ t t.T t.M t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O : O V & &Xd &.<.(.(.$ T T T T T T T T T T TX+ TXM T TXM TXM T TXM T TXM TXgXM T T $ T $XnXMXnXm c.^.^.^.^.k.^.^ 3X* zX8 <././././././././ <././ <./ <./././ fX* fX*X*.c ; n x.^.k.^.^.^.^.J.N + + g.8 g.n T.a.J c.^.^.^.^.^.k.^.u ;.Q.>.@.@.X.>.X.>Xm.Q.u n n nX3.u v.^.k.^.^.^.^.^ cXu.N.8 g.X.$ T.$ T T T.$ c T T TX:.$ TX:.$.$ T TX:X:X: d T.$X: TX:.$.$X: TX: T.$X:XrX: TX:. Xu.J p.J p r G p.J p ' GXuXu r pXu 'XuX:X:XrX:X:X1X:X:.$X:X,X:X:.$X,.$X:X:X,X1.$X:X,.$.$X:.$.$X,X:.$X:X:.$X1X:X:.$X,X:X:X,X:X:X,.$.$X, =X:X,X:.$X,X,.F.F.F.F.F.F.:.~ *X= oXdXd V V o o P *.< V o o V o 1 VXd.< V.< V o o V oXd.r.D.DXd 1.~ 1 oX=X=.c o.( o V.r 2 o 1.r * o oX=X8 o oXd o o.<Xd * & *.2Xd h.( o.< o * * k.< o t @.. @...(.p * 1.f.e.f , @ # @.K #.T.M.T t t t t.M.MXb.M.p.TXX.p.T tX8 h.z o.~.p V o V HXX.X.q.9 o hX= ( ..v . @.MXb @.M t t @.T.pX=.eXdXd V h.p.( VX= C.q o o o VXdXdXd.~.K.q I t t t /.p.q.p.p.K.p.K.. I I.p # o oXdXd 1Xd V oXd.< 1X=.pX= o.~ 1 & 1.p o.< X V 1.f.f 1X= I.e t O V & &Xd &.<.(.( o o o &.D V &Xd.<Xd *.qX= o o.( o.~ *X= oXdXd V V o o P *.< V o o V o 1 VXd.< V.< V o o V oXd.r.D.DXd 1.~ 1 oX=X=.c o.( o V.r 2 o 1.r * o oX=X8 o oXd o o.<Xd * & *.2Xd h.( o.< o * * k.< o t @.. @...(.p * 1.f.e.f , @ # @.K #.T.M.T t t t t.M.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O O *.<.D.: & V o o.(.$ T T T T T T T T T T TXM TXM T TXnXM T $ TXMXn T $ T TXMXn $ TXMXn TXM $XMXMX:.w Q.8.8.8.8 Q.J x.@X8Xq./././././././././././ <./ < <./Xq f fX*.u G.JXu Q.8.8.8.8.8.8.8.8.8 gXp.N.N.XXMXMXMXz.8.8.8.8.8.8Xu.^.Q.>.@.>.@.@.> 6.u n.u n n.u.^ G.^ G.8.8.8.8.8.8.8Xw.8.8 gXg.$ T T T T TX: T T T T T TX:.$ T.$X: TX:X: TX:X:X:.$ TX:X:X:X:.$X:X: T.$X: TX:X: T. XM p p p.JX:Xu.JXuXu.JXu GXu '.  ' pX1X:X:X:X1 TX:X:X:X,X:X:X,X:.$X:X,X:X:X:.$X, |.$.$X,X:X:.$X:.$X:.$X,X:X:.$.$.$X:X,X:X:.$.$X:X:X,X:X:.$X:X,.$X:X:.F.F.F.F.F.F.: o o.(.~ V V o V.~ o o k &.( o V V V o o o.< V.~Xd.q 1 o 1 oX=Xd V.b o.=.q.( o o V oXX V X.rX. k.r V 1.r oX= h o.< V.( R k *.( o oXd.<.#.( o o o.<Xd.D & o t.M @ @ t.E.e.p @ @...K.T #.9 #.p.K.T t...T.T.T.T t tXbXX *.9X. P.p t I.p.(.(.e.TX8.( o hXd & P k.#.TXb.v ..v . t t.M.M.M.M @.M t @.. @ @ #.K.e.pX=.q.q.p o oXd o o 1Xd VXd.p.eX=.M t @ @.K.p H H.K.p.E.K.e.E.p @.p o o o.<Xd 1 o.~.~ o.pX=.~Xd V o.~.e.(.D V V.f.f.f.... H.K.T O *.<.D.: & V o o.( & &.<Xd o.( *.<.< 1.=.(.( o.(.( o o o.(.~ V V o V.~ o o k &.( o V V V o o o.< V.~Xd.q 1 o 1 oX=Xd V.b o.=.q.( o o V oXX V X.rX. k.r V 1.r oX= h o.< V.( R k *.( o oXd.<.#.( o o o.<Xd.D & o t.M @ @ t.E.e.p @ @...K.T #.9 #.p.K.T t...T.T.T.T t t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=X= oXd.D k.< k k &.$ T.$ T TXn TXnXM T T TX+ T T T TXM T T $ T TXM T T $XgXMXM $XnXM TXM $XM $XM $ TXf.g p.8Xw.8Xw.J.t.>X8././././././././././ <././ <./ < < ; f f.t N.8.N.8.8.8.8.8.8.8.8Xp.8Xw.N g.8X:XMXM TXM.P A AXw.8 N.k v f.>.@.@.@.> 6.u.Q n n n v.k G.^ N.8.8Xw.N AXw.N.8.8Xw A gXe T T T T.$ T T T d TX: TX: T TX: T T.$ T TX: T.  TX:.$X:.$.$X: TX:.$X:X:.$. .$X:X:.  p c p p.  p.JXu pXuXu. .JXuXu p.$X: pX:X: TX:X1X1X:X: TX:.$X:.$.$X:X:X,.$X,X1.$.$.$X:X:.$X:X:.$X,.$X:X,X:Xr.XX:X,.$X:.$X:X:X:X,.$.$X: =.$X:X:X:X,X,.F.F.F.F.F.F k o.<Xd o o 1 o o o VXd 2 k oX= &.~Xd o o o oXd V o o oX= o o.qX=.(X8.2Xd 1.(.p.D o * o.p.(.(X=.p.(.< * o o * oXd.( o k.<Xd.< * o P P * o *.K.T h o P.< k.p s j tXbXb.(X8 H t.<X8 h.K # o.(.( @.T.T.T t t.M.M t.M t.p &.9 O PX= o @ @.p t.M @.<X8.K o o h &.<.< & P ..v.v.v.M.M t t.M t @ t t #.p.pXdX8.(.p.p.( o H.qXd.< oX=XdXd o oXd.~X=.EX. @ @...K @.q.p H.K.p.e.K.K.p.E.K.K o oX= o * o 1 o oX= o.~ o.~.eXd VXd o V ,X. #X=.e.p.q o oX=X= oXd.D k.< k k & o o o.qX8 *.< V V *.(X8.( *X=.( h o.<Xd o o 1 o o o VXd 2 k oX= &.~Xd o o o oXd V o o oX= o o.qX=.(X8.2Xd 1.(.p.D o * o.p.(.(X=.p.(.< * o o * oXd.( o k.<Xd.< * o P P * o *.K.T h o P.< k.p s j tXbXb.(X8 H t.<X8 h.K # o.(.( @.T.T.T t t.M.M t.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.a.< P.<.DXd.b kXdXd.$ T T T T T T T TXn T T T TXM TXn TXMXn TXMXn $ T $XMXM T T TXM T $XM TXn TXMXMXfXMXMXfX:XfXw.8.J.k.>.m <././././././././././././ < < <./.@ f fX* N N.N g g +.8 A.8.8 Q.8.8.8Xp.N -XM $ T $ $XMXe.8.8 N G c.Q.@ 8.@.@.@.c.Q n ; n n v.^.J G.8.8.8Xp.N.8.N.N.8Xw.8.8.8 +Xj T.$ T T T T T T TX: TX: TX:.$ T T T TX:.$ T T.$X:.$X:.$X:.$X:X:.$X:.$X:X:.$X: T.  rX:X:. X:X: p p p.J.JXuXuXu p p 'X:.$X:.$X: TX:X:X1 TX:X:X,X:X:X:X:X,.$.$X:.$X:X:X:.$X:.$.$X,X:.$X:X:.$X:X:.$X,.$.$X:X,.$X,X:X,.$.$X:X:.$X:X:.$X,X:X:.F.F.F.F.F.FXd.# VXd o H o.r o o V o.~.< oXd o.r o o V oX= o & o.q o o.( oX=.p.( o.~.2 oX8.eX=XdXd V.~ o.~ HXX.<.<Xd V h o o o * o.<.< *Xd & VXdXd.= h @ t.K.E t h.p.(.'.[ #.( @ t tX. PXb.( oXX.T.MXX h *.M.M t t @ @ @.MXb.M t t PXX.( * P o.M @ H.MX. H.r.T.qXd.<Xd.DXd.<.q.( t.v.v.v.MXb . t t t.. t t...e.KX= # @.p.K.p.q.p h.D V o o o V o o o V oX=XXX. @ t.K @.p.p.p @.pX8.( H.K.K # # oX=.(X=X= o oX8.h.q o o 1.p.q 1Xd V.( 1.p X 1 1.p.(X=X= *.<.< P.<.DXd.b kXdXdXd o.q o o 1 * oX=.q.(.( oX=X8 oXX.# VXd o H o.r o o V o.~.< oXd o.r o o V oX= o & o.q o o.( oX=.p.( o.~.2 oX8.eX=XdXd V.~ o.~ HXX.<.<Xd V h o o o * o.<.< *Xd & VXdXd.= h @ t.K.E t h.p.(.'.[ #.( @ t tX. PXb.( oXX.T.MXX h *.M.M t t @ @ @.MXb.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.~X=Xd PXd.D P.<.(.$ T T T T T T T T T TXn T T T T T T TXM TXnXM T $ T T T $ T T $XM T $XMXMXnXMXMXfXMXM.!XMXM.R.g.8.k.tX  8./././././././././././ <./././ <Xq 6.G f G N.8 g g + + +.8.N.8XwXw.8.8Xw.!Xn $ $XnXM T $.g NXu.J.Q.c 8.@.@.@ 6.Q n ;.u.Q.^ G G N.8.8.8.8.8 A.NXp.8.8.NXw.8Xw. X: TXn T T T T TX: T T.$ TX: T T.$ TX: TX: TX: TX: T.$X: TX:.$ TX: TX:.$ T.$X:X:X:. X:X: r. X:X:XMX:.J p ' p p.J '.$X:.$X:X:.$X:X:X:X: pX:X:X:X:X:.$X:X,X:X:X:.$.$X:X,.$X:.$X:X:X:.$.$X:X,.$X:X:X,X:X:X:.$X:X:X,.$.$X:X,.$.$X,X:X:X:X,.$X,.F.F.F.F.F.F i.p V VX=.q.( o V o oX= oXd o.(X= o.DXd o oX8 oXd o o V V 1X=.pX= o.(.~ V.<X=.p.(X8 o.( o.( o h *Xd.< k.<.p.E.p..X$.(XdXd.<.E oXd P.p.q P h @ t t.M.T.(.(.M t.' H #.( R.< P.M h.p.M.MXb.M.M t @ t @ t #.K.MXbXb.MXb.M h.(.(.<.<Xd t @..Xb t.K t O o VX8XX h oXd h s h.v.v.v.M . . @ #.M.. @ @ @.K.E.p # @.K.p ,.pX=.K o o oX=X=.~ o.~.<.~ oX=.E t t t @.K @.K / h.(.p.h.E.p t.K @ o o *.q.q o o.qX= o.~ 1X=X= o.~ o *X=.G.p 1X8XXX=.(.p.( *Xd.~X=Xd PXd.D P.<.( 1 o oXdXd.<.(X= o o.~Xd.~ 1.( o.D.p V VX=.q.( o V o oX= oXd o.(X= o.DXd o oX8 oXd o o V V 1X=.pX= o.(.~ V.<X=.p.(X8 o.( o.( o h *Xd.< k.<.p.E.p..X$.(XdXd.<.E oXd P.p.q P h @ t t.M.T.(.(.M t.' H #.( R.< P.M h.p.M.MXb.M.M t @ t @ t #.K.MXbXb.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.hX=.q.p o.# h o oX=.$ T T TXn TXn T TXn T TX+ TXMXn T T T $ TXM T $ T T $Xf TXMXM TXMXMXMXn T $XMXM iXf.! $XMXMXfXMXM.} G.m.m <././././././././././././././././.G f fX0 Q.oX&X&Xh g +.8 A 9 c.g.a | T T $ TXM $XMXnXMXMXeXuXf.c.>.@ 8.@Xm ; n.Q.Q n.^ G.J N.8.8.8.8.8.N.8. .!Xe 7 -.aX:X:X:.$ T T T T T T T.$ - TX:X: TX:X: T.$ T T T.$ TX: d.$ TX:.$.$X:.$X:.$X:X:X:X:.  T T. X: TX,. X:X:X:X: p TX: pX:X:. X:X:X:X:X:X:.$X:X:X:XrXrX:X:.$X:X,X:.$.$.$X:X:X,Xr |.$X,X:.$.$X,X:X:.$.$X:X,X:X1X,X,X:.$.$X,.$.$.$X,X:X,X: =X:.$X:.$X,X:.F.F.F.F.F.F J 1 o o o o & V.( V oXd VX= *.( HX= o V.~X8.q.rX8.(.(X8 H.( h.qX=.( oX=X= HX=X=X=XdXd & & o #XdXd V o o.K @ t t.E # @ @.. ,X$.K.EX=.(.p.qX= h t @ @Xb t #.(.p.( &.DX=.( * VX. * o o.9.K t t ..M.( t.M .Xb t t . t t t.M t t tX8 h h t.v V H @XX hX= H H.(.( *X= P.D *Xb.v #Xb.M.M @.e @ t.M t ,...E.p.K.p VX=.q.(X=X=.(X=.(X=.qX=.p.( oX=.(Xd.p.pX= @ @ t @ @ t.K H.p H.K.T.K @.(.p.q.(X=.q.( #.p * oX=.e o o o oX= @ h.q 1 o 1X=.pX8X=X=.p hX=.q.p o.# h o oX= o P o o.~ oX=.~ V * o o.~ o o VXd 1 o o o o & V.( V oXd VX= *.( HX= o V.~X8.q.rX8.(.(X8 H.( h.qX=.( oX=X= HX=X=X=XdXd & & o #XdXd V o o.K @ t t.E # @ @.. ,X$.K.EX=.(.p.qX= h t @ @Xb t #.(.p.( &.DX=.( * VX. * o o.9.K t t ..M.( t.M .Xb t t . t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.hX=.( PX=.q.qX8.(.(.$ T T T T T T T T T T TXM T T TXMXn T T $ TXnXM T $XnXM T $XnXM.AXnXM T $ T $XMXf $Xf $XMXM iXM $ |.J.;X8 8././././././././././ <./././ < < 8 f fX* NX7 g.I g g.I 0 T $ $XM $Xn $ $ T $ $XM $XMXM 7XuX3.tX .@.@.@ f n.Q.Q ; n.^ G G N.8.8.8.N A.8 - 7.$ T $.$ T T T T.$ T T T T.$ T.$ T T T.$ T T.$ T T T TX: T.$ T.$ TX:.$.$ TX:.$X: TX:.$ TX:.$ TX:.$X:. X:X: p.$.$X: TX:. X:X: pX:X: pX: TX:X:X: pX:X:X:X:X: '.$X:X:X,.$X:X:X:X:X:X,X:X,.$.$X:.$X:.$.$.$X:.$X:X,.$X:X,X:.$X:X,.$.$X:X,X:.$.$X:X,X:X:X,.$X,X:X,.F.F.F.F.F.F ~ o.~Xd V oXd.D.(.( h o oXd oXX.(.(X=.(.e.p 8.p h.p oX8.p o oX=X= * oX8.p H.9 H.p.<.2 V V V o o.<X= @.K @ @ @ @.(.K.E I.E.z I.p.z o...E.( * H.M t.. t @ H.K.p o.DXd o.< P h o.<.DXd.<.(.( H t.v.v.M.( h t t t ..M.M tXb h P.M @ H @ h .Xd.=X. VX= H.q.MXX 1 1.( R l.< h.v.MXb.M.M.T # # @ t t.. ,.e.K.p oX= oX=.eX=X8X= o o o.q *.qX=.~.qX8.p.p H.p.K @ @ @ # t H #.K.K.` h.K # @.(.(.(.(.(.p.E.(.qX=X=.qX=.qX=.(.K..XX.< oX=X=X=.K.K.(.( H hX=.( PX=.q.qX8.(.(.r.q o 1 o oXd V.< 1 o.~ 1 o V V V o.~Xd V oXd.D.(.( h o oXd oXX.(.(X=.(.e.p 8.p h.p oX8.p o oX=X= * oX8.p H.9 H.p.<.2 V V V o o.<X= @.K @ @ @ @.(.K.E I.E.z I.p.z o...E.( * H.M t.. t @ H.K.p o.DXd o.< P h o.<.DXd.<.(.( H t.v.v.M.( h t t t ..M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0.( o.~.(X8 H.q o o.$.$ T T.$ TXn T $ TXnXn T T $ T T T $ T $ TXM T $ TXM T T $XMXMXn T $XMXnXMXMXfXM $ iXM $XM iXM $ $Xz.k.mX8./././././././././././././ <././ <.t f f.R NXw.I.I gX&X& T $ $ $ T $ $ T $ $ $ T $Xn.X.R.^X0 6 8 8.@ f n.Q ; n n.^ G G N.8.8Xp.8.8.N A T T T T T T T T T T T T T T T T T T TX: T TX: TX: T T.$X: T.$ T T T T.$ T TX: TX: T.$X: TX:.$X:X: TX:X:.  TX:.  TX: TX:X:.  TX:. XMX: pX:X:X:.$X:X1X:X:X:X:X:.$XrX:X:X:X:X,.$X:X:.$X: |.$X:X:.$.$X:.$X:.$X,.$X:.$.$X:X:X,X,X:.$X:.$X,.$X:X:X,X:.$.$X:.$X:X,X:X,.F.F.F.F.F.F JXd V.DXd V oXd V *.(.( h * 1 PXXX= h t.K h.p.(X= o o.qX8X= 1.< VX=.e.K h h.h.(.<.D &XdXd oXd.(.p @.K @.p @ #.(X=.z VXdX=.( h.9X= @ @.p.9 hXXXb.E @.K @ @ @ t.(.D.<X..< k.( o.~.:XdXd o * P oXb.v ..M.M . . .Xb.v.v.v .Xb t .Xb t o 2.M tX8.9 o o.( o o.<.<.<Xd.b.D *.D.M ..M t h.q.~.e tXb t.K.e C.p.e HX=XdX=.pX=.(.(.qX= oX=.(X=.( o.(.K.p #.p.e @.K...M t @ h @ h h.K @ @ # @ HX. H.(.p.T.p.(.p.(X8.( *X=.(.e.. t o.eX=X=X=.pX=.p.p #X=.p.( o.~.(X8 H.q o o.~ 1Xd k.<Xd o o * 1 o o 1 o.~.<XdXd V.DXd V oXd V *.(.( h * 1 PXXX= h t.K h.p.(X= o o.qX8X= 1.< VX=.e.K h h.h.(.<.D &XdXd oXd.(.p @.K @.p @ #.(X=.z VXdX=.( h.9X= @ @.p.9 hXXXb.E @.K @ @ @ t.(.D.<X..< k.( o.~.:XdXd o * P oXb.v ..M.M . . .Xb.v [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.(X=X8 #.p.hX=.~X=.$XM.$ T T T T T T TXM TX+XM T T $ T TXn T $ T $ TXM $XgXM T TXnXM $ TXMXM $XMXfXMXfXf $XMXMX0XM $ $Xf GX*.mXq./././././././././././ <./ <./ < 8 f f Z NX7.I.I.IX&.%.gXnXf T $ $XM $ $ T $ $XMX:XfXz.Q f 8.@ 8.> n.Q ;.Q ;.^ G G.8.8 Q +Xp.8.N -.aXM TXM T T T 9 T T T T T T T T T T T T TXz.$ T TX:X: T.$ T T T.$.$ T.$ dX:X:X: T.$X: T.$X: TX: TX:. X:Xu TX:X:. X:X:X:X:X:. X:X: pX:X: pX:X:X:X:X:X:. X:.$X:X1 T pX,X:X:.$.$.$X:X:X:X,.$X1.$X:X:.$X:X:.$X:.$X:.$X:.$.$X1.$.$X:.$X:X:.$X:.$.$X:.$X: = TX,X:.$.$X:.F.F.F.F.F.FXdX=.~ V o o V V o.~ o.~ 2.p.( P PX= oX= H.pX=.~ o o.( *X=.~ oXd o.(.T.< H s H o &Xd.< o H t @.( oXX.#.p h.p H.h o o.(.( H #.e.p.T t @ o tX. t s # t t t tX..(.9 *.DXd o.< *.<Xd oXd.< oX8.( o o P H t ..M.M.T t @.M ..M ..v.v ..v t.M.M ..MX= H o o h #.( oXd.D P.(.#Xd.D H . t.e.(.p...p @.M...eX=X=X=.( 1 V.K.q oXd * o.q #.p.~.h o.~.eX8 H @ #.E @ t t @ @ @ t t @ tXbXb @ @ @ t # #.(.p.K h #.p.(.(.p t.M t @ #.p #.p H # h h.T H.p H.( o.(X=X8 #.p.hX=.~X=.( o o.D X.D * * o.~.~ V.< oX=X8.pX=.~ V o o V V o.~ o.~ 2.p.( P PX= oX= H.pX=.~ o o.( *X=.~ oXd o.(.T.< H s H o &Xd.< o H t @.( oXX.#.p h.p H.h o o.(.( H #.e.p.T t @ o tX. t s # t t t tX..(.9 *.DXd o.< *.<Xd oXd.< oX8.( o o P H t ..M.M.T t @ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0.(X=X=X..e.( oX=.~.$ T T T TXn T T TXn T $ T T TXM TXnXM $ T $ TXMXn $ TXM $ T $XM TXM T $ TXM $XfXM $.!XMXMXMXf $ $XMXMXz.R.> 8./././././././././././././././ <XqX* f f N N +Xh gX&X&.P $ $XM $ $XM $ $ $ T $ TX0.k.Q 6.> 8 8.@.Q.Q.t.Q ;.^ G G N.8.8.NXp.8.8 QX: T T T T TXM T T T T T T T T T T T T T T T T T T T.$ T T T T.$ T T TX:X: T T TX: TX: TX:.$ TX:.$X:.$.$ T.  TX:X: p.$.$X:X: T pX:X:. X: T pX: TX:X:.$ T 'X:.$X:X:X:X: p |X:.$X:X:X:.$X:.$X:.$X,X:.$X,X:.$X:.$.$X,X:.$X,X:.$X:X:X,.$X:X,.$.$X:.$X,X:X:.$X:X:.$X,X:X,.F.F.F.F.F.FXd.p 1 V V.~ o V P VXdXd.DXdXX B OX=.( 1.p o oX8X=X= o PX= * o.< * * o o * *.( PXdXd o o @ t #.hX8.(XX P.( *XX.#.#XX.(.(XX.p.' # @.M.qXd.M.M ..K t.M @ @ t H.p.(Xd 2.( VX=.(.h.DXd V o oXX o o.(.( *.M.T # t #.T t.( P.M .Xb.M.v.v.M t.MXbXb #.'.q.9 H o.~ P & & & k R & & VXb @.K.p @ @.e...M @.p.(.(X=X=.qX=X8.q o o.(.( o.p.pX=.pX=X=.E.E #.....p...K t #.p @X= #.M.MXb t # #.p @ @ hX=.p.p # #.K.p.p.K , @ t.( o.p.p.(.( CX=X=.qX8.p I.e.p.(X=X=X..e.( oX=.~.~ oXd.D V X P *.( 1 oXdXd oXdX=.(.p 1 V V.~ o V P VXdXd.DXdXX B OX=.( 1.p o oX8X=X= o PX= * o.< * * o o * *.( PXdXd o o @ t #.hX8.(XX P.( *XX.#.#XX.(.(XX.p.' # @.M.qXd.M.M ..K t.M @ @ t H.p.(Xd 2.( VX=.(.h.DXd V o oXX o o.(.( *.M.T # t #.T t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O :.(.~X= h.(.G.~ V o.$ T T T $ T T TXM T T T TXM $ T TXM TXn TXMXnXM TXMXn T $ $ $XnXMXM $ $ T $XfXM $.!XM $XM $X0XM $ $XM.R.k fX8Xq./././././././././././././ <./ < Z f fX0 NX7X&.I.{.% gX, $ $XM $XMXMXM $ $ T.}.JXf.t.@ 8.@ 8 f.t.t.t n.^.^ G.8.8.8.8.8.8.NXu 9 T T T T $ T T T T T TXM T T T T T T T T.$ TX: T TX: T T TX: TX:.$ TX: T.$X:X:.$ T.$ T.$X: T.$X: T.$.$X: T d TX:X:. X:.$X: TX:. .$X: p TX:X:. .$X:X:.$.$ '.$X:X: TX:X:.$X1X:X:X:X,.$X:X:X:.$ |.$.$ |.$.$X:X:.$X:X:X,X:.$X:X,X:X:.$X:.$.$X:X:X,.$X:X:.$X:X:X:X,.$X:X,.F.F.F.F.F.F.; # oXd V 1 V 1Xd VXd V V.<.( 1X= H.~.r o o.r.pX=.(X8XX o o *.<.< VXd.p k.:.< oXd o.p @ # # t.9X=.q h H.( o.=.#.( R.(.( H.T # @ t t.p.D hX. t @ t t t.e @.K H.q oX. tX8X. H.T.T tX= t h h * H h &.<.= # @X..T.M./ s h.M.M.vXb.v .Xb.( t.v ..M.(.=.pX=.(X= *.< V.D & lXd.D.: ..M / / t #X=.K t t.(.(.z.(X= o I.p * oX=.( #.K I.K.TX=.~ V.. @ @.E.p.K @ H.pX= tXb @.p.p.p h.p.p.e.q # @X..(X=X8 H.h.p #.K.K.. @XX.(X=.(.p.( o.rX=X=X=.e.K H tX..(.~X= h.(.G.~ V o.r.~ 1 X.r o.<X= * o.~ V V V V oX8 # oXd V 1 V 1Xd VXd V V.<.( 1X= H.~.r o o.r.pX=.(X8XX o o *.<.< VXd.p k.:.< oXd o.p @ # # t.9X=.q h H.( o.=.#.( R.(.( H.T # @ t t.p.D hX. t @ t t t.e @.K H.q oX. tX8X. H.T.T tX= t h h * H h &.<.= # @X..T.M./ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` o I.TX=.(XX V o 1X,X+ T.$X+ TXnX+ T TX+XMX+ T TX+ $ TX+ T $X+XM TXgXM TXfXM TXM TXfXMXnXf $XMXf $XM iXMXMX0 $ nXfXfX0 $ n.J nX8 8././././././././././././ <././ < 8 f f.} NX7 gX&.W.WX&XeXfXM $XfXM $XfXM $X+. .u.t.> 8 8 8.>.t.t.t n.^ G G.8.8.8.8.8.8.N p F F.P T 9 T T 9 TXM 9 T T 0 T T 9 T T 9 T TX:.$ 9 T TXz T.$ d TX:Xz T T dX: T d T dX: T d T.$ d T.$. X:X: d T p. .$ T.  T.$. X:.$ pX:.$XuX:X:. XrX:. .$X:X:X: pX:X:. .$X, pXu TX1.$.$X1X:X:X1.$Xr.$X,XrX:X,XrX:X,XrX:X,X1X:X:XrX,XrX:X,X7X:X,X1.$X:X1X:X:.oX:X,X7.$X,X:.F.F.F.F.F.FXd.( 1 V 1Xd V oX=.< 1 oXd V.< o.KX=.K h o oXd V o.e.( o.q h.#.q hX. h #.( # t @.K.p.(.q.(.p.T.( P.q.( P.(X. h t.9 o o V o H t @ t @ t @ t h #.E.E @.M t.K.M @ @.K.K @.( H t @.p.K.2 o o.( o o h V.(Xd o P.(.(.T h t t.T # t.M t hXb t.M t.MXb H.=.(.(.~XdX=.q.< V o.D &.D &.v t @ t @.pX=.(.K @.( H #.K HX=.q.q.q.(.p @ @.K t.K t.K.K @ IX=.( @ #XX.(.z.qXb.MX8X= h @ t @X. t #.K.K # # # # @.T #.` H.h.e t # H h.(X=X=X=X=X=X=.K.p.p.p @.T # o I.TX=.(XX V o 1.p.q o o o o.q o o.D o V V VXd o.(.( 1 V 1Xd V oX=.< 1 oXd V.< o.KX=.K h o oXd V o.e.( o.q h.#.q hX. h #.( # t @.K.p.(.q.(.p.T.( P.q.( P.(X. h t.9 o o V o H t @ t @ t @ t h #.E.E @.M t.K.M @ @.K.K @.( H t @.p.K.2 o o.( o o h V.(Xd o P.(.(.T h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( H.. t.p o 1 o o o.$.$ T T T T T TXM.$ T T TXM TXn T T $ T T $ T $XM T $ T $Xn T $ T T $ $ TXMX0XM $Xf $XMXMXM.! $X0XM $X0Xm.k.mX8 <./././././././././././././ <./ < Z f D FX7.8.IX&   g.% $XMXM $ $ $XM $.XXz.u.cX  8 8 8.>.c.t.t n.^ G N.8.8.8 A.8.8.8X0X: F F T T $ T T T T T T T T T T T T T T.$ T TXM TX: T T T T T T.$ T.$ TX: T.$ TX:X:.$X:X: TX: TX:.$ T.$X:.$X:.  T T T. X: TX,.$X:X:. X:X: T pX:X:. X:X:.$X:X: T pX:X:X:.$.$X:X: 'X:X:.$.$X:X:.$X,X:X:.$X:X,.$X:X:X,.$X:.$X,.$X,X:X:X,.$.$X,.$.$.$X:X:X:X:X:X:.$.$.$X, TX,.F.F.F.F.F.F e.( oXd oXd.< o H.qXd.z o o oX8.qX= H.K * * VXd.<.(XX.=.#XX H.9 *.pXX t @ t t # @ o.(.e.( *.(XXXX.<.(.# h # HX.XX o.(.( #.T.K t @.K t @.T # # #.K.MXb.M / #.K @.K @ H h.( t.(X8 @Xd.< k * V.D.< VXd *Xd o P H H.9 t.M.MXb . HXX t.M t t.( * tXb P oX= V V k.<Xd o.# &.D.D V t.M @.M @.K.~.~.e @.p h o.q.K.qX8.q.K o.(.E.K.E.E # H I I.e H.pX= #.p H.e.(X= O o o.(.pX. t.MX. #.p.E h H.E t t.M.MX. HX=.p.e t t.p # H.q I I.zX=.e #.p.e.K # h.( H.. t.p o 1 o o oXX.qX= o.~X=X=.~ V o.~ o V.: VX=X=.( oXd oXd.< o H.qXd.z o o oX8.qX= H.K * * VXd.<.(XX.=.#XX H.9 *.pXX t @ t t # @ o.(.e.( *.(XXXX.<.(.# h # HX.XX o.(.( #.T.K t @.K t @.T # # #.K.MXb.M / #.K @.K @ H h.( t.(X8 @Xd.< k * V.D.< VXd *Xd o P H H.9 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.l t t @ #.(X8 oX=.q.$ TXn T T T T T T T T TXM TXMXM T $ T T $ TXM T T $ T $ TXM $ T $ $ $ $XMXMXfXMXM.!XMXMXM $ iXMXf $XMX0X:.J.c.m 8././././././././././././././ <./X* f f.t N QX&.I.I.I g $ $XMXM $ T $X:.R.^.t f 8 8 8.@.t.t.t.t.^ G G.8.8 Q.8 g.8.8.! T T.u 9 $ TXM TXM T T T T TXM T T T T T T T T TX: T TX: T T TX: T T TX:.$ TX: TX: T T T.$ T.$X: TX:X: TX:.$ TX:. X:.$X:.J T.$.$ TX:X: p TX: T pX:X: p.$X:.$X: TX: 'X:X:.$.$X:X:X: p |.$X:X,X:.$ |X:X:.$X:X:.$X:X:.$.$X,X:.$X:X:.$ |.$X:.$ |.$X:X,X:X:X:X:X,X:.$ |X:.$.$X,X,.F.F.F.F.F.FX5 V.( o o V VXdX=.( VX= o.~.f.(X=.r.q.e o V.~ *.#.( PXX *.< *XX.< o.( t @ @ @ #.p.(.p.E o.< o oXX.=.# h.pX. #.T o.( h.T.T t.M t t.K.T t h @.T.K.MXb .Xb t @ @ t @.E.h #.( #.(.( HXX o.=.#.qXd.b.< oX8.D *.D.(.p.( # tXb . . H t.M.MXb t o.< t.M hX8 o oXd.~ VXdXd o o VXdXd t.M.M @.K # o 1.q tX. @X8.rX8 #.K.p # I.(.p.K IX=.e #.p.e.G.p.~.e.q.e.(X=X=X=.q o o o.K #.( hXX @.K H #.K # t H.(.M.M.M #.K @.. t t h.p h.p H h.p.T # @ t h.K ,.K t t @ #.(X8 oX=.qX=X=.q o.p.p.p o.~ o o.(Xd.r o V & V.( o o V VXdX=.( VX= o.~.f.(X=.r.q.e o V.~ *.#.( PXX *.< *XX.< o.( t @ @ @ #.p.(.p.E o.< o oXX.=.# h.pX. #.T o.( h.T.T t.M t t.K.T t h @.T.K.MXb .Xb t @ @ t @.E.h #.( #.(.( HXX o.=.#.qXd.b.< oX8.D *.D.(.p.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX> t t t @ H hX= o.q.$ T T T T T TXM T TXMXnX+ T T T TXMXnXM T $ T $XM T $XfXM T $Xn T $ T $ $Xf $XM $Xf $ $ $XMXf $X0XM $ nXM.; G.m 8 <./././././././././././ <././ <Xq z f f N N + g gXh gXf $XM $XnXM TXfXz.QX*.m 8 8 8.t.t.t.t.^ G G.8.8Xw.N.8Xp + d TXM r.R F TXM T T T TXM T 9 T T T T T T T T T T T T TXz TX: T T T T.$X: TX: TX: T T dX:X:X: TX:.$X:X:.$X:.$X:X: d.J TX: T. X:X:.$X: TX:. X:X: p p T.$. X:X:.$X:X:X: T pX:XrX:.$X:X:X:. X:X:X:.$X:.$X:XrX:X,X:X:.$X,X:X:.$X:X:.$X,X:XrX,X:X:X,.$X:X:.$X:X,.$X:.$X7X,X:X:X:.$X,.F.F.F.F.F.F eX= 1 oX= o o V o o o ,...p 1X=.e o.pX=.# * & P.( o *.<X8 P * o.h.K #.h.( # h.(.e o oXXXd o o o.=.( H.p.<.9X..'X. hX..p.T t # @ t @ #.TX..T t t h.KXb ..M t t t , @.e o o o.(XX./ ..M # O P.<Xd.2.b V.< o.:X8 * t.M .Xb . .Xb.M O *.=Xb h # tX. t @ @.eX=.T.eXX h 1 o k o *.KXb t.pX=.qX=.f.p.p.K t.p.E.p.`.p.. # @ t HX=.(.p # H.p H.p.( o o o oX=.q.K.p.q H h O.(X=.qX8.(X=.q h.(.h #.K h h h oX=.E t @ O h #.M @ #.K h.p.T t t t @ # h.# H t t t @ H hX= o.qX=.~X=.(.p I oX=.q *.q.(.# * o oX=X= 1 oX= o o V o o o ,...p 1X=.e o.pX=.# * & P.( o *.<X8 P * o.h.K #.h.( # h.(.e o oXXXd o o o.=.( H.p.<.9X..'X. hX..p.T t # @ t @ #.TX..T t t h.KXb ..M t t t , @.e o o o.(XX./ ..M # O P.<Xd.2.b V.< o.:X8 * t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` t @ t t t...eX=.p.$ T T T T T T T T T T TXM T $ TXM TXM T $ T $ T T $ TXMXnXM TXMXM $XMXMXMXfXMXMX0XMXM $XMXMX0XM i $ $Xf $ |.J fX8Xq./././././././././././././ <././.c f f.Q N Q g.I.I.IX, $XMXM $ T.D G.t.c.@ 8.A.@.c.t.t.t.B G G.8.8.8.8.N.8.8X0 TXM T T.R 9XM T $ T T T T T T T T T T T T T T T TX: T T.$ T T T TX:X: T T T T T TX: TX: T T.$ T.$ TX:X: TX:X:.$ TX:. X:X: T. X:.$.$X:X:X: p TX:.$. X:X:. X:X:X:.$X:X:X:.  |X:.$X:X:X:X:. X:X:X:X:.$X,X,.$X: TX,X:X:.$.$.$X:.$X,X:X:.$X:X:X:.$.$X,X:.$X:.$X:X,X:.$X:.$X:.$X:X:X,.F.F.F.F.F.F e o o o.~X= o.~X=X= oX=.qX=.e.p.pX=.pX8 * V.D.p.p.( o * P.( h.K.p.E H H.p.T.p.p.(Xd.<.< k & & o sXX h o P.MXXXX.p h.T # t @.p H @ #.K @ # t tX..EX$.M.M.M t # @.K #.(X8.(.( o * H.T t H t.TXX o.p hXXXdX8.(X= V.v . . ..v.M.v.v.M #.M.M @.p @ t h.MXb # I.M.( o.M.( o k PXX t.M.M.eX8X=X=.e # @.K #X=X= tX=.( #.. t t h I.e.TX= o.e.p.p.~ V o o o o.(...E.h.p.( oX= o.q.q.qX8 o o.E.(.(.h # s #.p #.K.K t t.(.X hXb t.K H #.h H @.K h O H # # t @ t t t...eX=.p.pX8.p.qX= IX= oX= o oX=.( *.< oX= o o o.~X= o.~X=X= oX=.qX=.e.p.pX=.pX8 * V.D.p.p.( o * P.( h.K.p.E H H.p.T.p.p.(Xd.<.< k & & o sXX h o P.MXXXX.p h.T # t @.p H @ #.K @ # t tX..EX$.M.M.M t # @.K #.(X8.(.( o * H.T t H t.TXX o.p hXXXdX8.(X= V.v [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.l @ h #.T t t # #.p.$ T T T T TXn T T T T TXM T T T $ T TXM T T $XM T $ $ TXM $XMXn $ T $XMXMXf $XMXf $XM $ $XMX0XMX0XM $XMX0XMXzX3.m.@././././././././././././././ <./.@ z fX* NX7X&Xh.I.IXeXn $ T $XmXu.Q 6.m 8 8 8 6.c.t.c.t v G.8.8.8.N.8Xw.N.n.$ T T $XM 9.u T T T T $ T T TXM T T T T T T T TX: T T T T TX: T T T T T TX:X: TX: T TX: TX:X:.$X:X: TX:.$X:.$ T TX:.  T.$X:X:. X:X:.$X:X: r. X:X:X:. X:X:X: p.$X:X,X:.$X:X: p.$X:.$X:X:X:X:X1.$X:X:.$X:.$X:X,.$X:.$.$X:X:X:X,X:.$X:X,X:X:X,X:X,.$X:.$X:X,X,X:X:X:X,X:X:X,.$X:X, |.F.F.F.F.F.F.: oX= oX=.q oX=Xd 1X=.(.(.(.p.p.pX8.p.pX=.~.D.( * o HXX.h.h t t.( H t.T h h.T.p.( *.( o.< V.D VXd k O *.TX.X. o h.TX. h @ t.T #.E.p h #X.X. #.E I.. tXb.M.M t tXb.M h h h * H.h.9.( t h @ t t h h.p.# P oXb.T H.M t.M.M.( & ..M t.TXbXb.M.p *.p t @Xb.M @.M.p.e.h H o o.K h @ @ t @.E.e I H.p t @ @.p ,.MX=.K @ t @.p.K.K..X..(X=.p.~ V o.~ V.~Xd o.K @.( o o o o.~ VX8 o o oX=X=.(.p.p oX=.(X=.(X8 # @ t.K @.K t hX. t @.p H.p.K h.(.K.p #.K @ h #.T t t # #.p.T O.pX=.(.(X=X8X8X= o * * o o o o oX= oX=.q oX=Xd 1X=.(.(.(.p.p.pX8.p.pX=.~.D.( * o HXX.h.h t t.( H t.T h h.T.p.( *.( o.< V.D VXd k O *.TX.X. o h.TX. h @ t.T #.E.p h #X.X. #.E I.. tXb.M.M t tXb.M h h h * H.h.9.( t h @ t t h h.p.# P oXb.T H.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` # @ t t.. @.K.K H.$ T T T T T TXM TXM TXMX+ TXMXn T $ TXMXnXM T T $ TXnXf TXMXMXMXM $ T $Xf $ $XMX0.! $XM $ $Xf $Xf $ $ $X0XM.a.k f 8Xq./././././././././././././ <./ < Z f f.^ Q A g.I.IX& $ $ $.aXuXf 6.> 8.A 8 f.t.c.t.t x G.8.8.8.8 A.N.8.) T $X+XM T T.R.RXM T T T T T T TX+XM T T T T T T T T T T T T 9X: TX:.$ TX:.$ TX: T TX:.$ T d T T TX: T.$X: T T.$X:X: T. X: TX:. X:X:.$X: T TX: p TX:. . X:X:X:. X:.$X:.$X:X: TXr pX:.$X:X:.$X:X: p.$X:.$X:.$XrX:X:.$X:.$X:X:X:.$X:X:X:.$X:XrX:X,.$X:.$X:X,X:.$.$X:.$X,X7X:.$X:X,X:X,.F.F.F.F.F.FXd.qX=X=X=.p.(.(X=.(.p @ # @ HX. t t @ @.. @ t @ # @.E @ t @X.XX t t t H h #X. * h o oXd o o P.T O P.9X= H t t.(.( h H t #.p t # # # h h H.(.T.#XXX=.K .X.X= h h H t.MX. h s # # H * t t t.T h h t o o.= & P h P.TX..'Xd o.9Xd o.p h HX. # *.(.p # t t t.M.M t # H.K t t t.e t @ , # H.p # @.. t t.M.K.E H H.( @.q #.p.qX=.G HX=.(.q.( oX= oX=X= oX=.pX=X= o oX=.qX=.p *X=X= o.~ oX8 o C.pX8 o.( o.pX= oX= t t t # @ @ tX. s.T #XX h.K #.p.K @ # @ t t.. @.K.K H.p H.K o.(XX.(.( h.p o o R R.L.(.(.qX=X=X=.p.(.(X=.(.p @ # @ HX. t t @ @.. @ t @ # @.E @ t @X.XX t t t H h #X. * h o oXd o o P.T O P.9X= H t t.(.( h H t #.p t # # # h h H.(.T.#XXX=.K .X.X= h h H t.MX. h s # # H * t t t.T h h t o o.= & P h P.T [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O : #X=X= @ t.K.K.E.(.$ T TXn T T T T TXn T T $ TXM TXM TXnXM T $ $ TXM $XM T $XM $ T $ $ $XMXf $XMXMXfXM $ $ $ $X0XMX0 $ $XMX0XM $.J.c.mX8./././././././././././ <././ <./ f f f.c NX7.I.I.WX&.a $.XXz.R.c.>.A.A.AX*.t.t.c.t x G.J.8.8Xw.8.N Q.) T TXM T $ TXM 9.R T T T TXM T T T T T T T T T T T T T T T T T.$ T T TX: TX: T T T.$ T T T TX:.$X:.$ TX: TX: T.$.$ TX:X:.JX: TX:.JX:X: T.$X:X:X:. X: TX:.  TX:X:Xu.$X:.$X:X:X:.$ pX:X:X:X:.$X:X:.$X1X:X:X:.$X:X:.$X:X:.$X:.$.$.$X:.$X:X,X:X:X:X:X:.$.$X:X:.$X:.$X:X,.$X:.$X:X:.$.$X:X:.F.F.F.F.F.F & P o.qX=X=.(.K.T # @.M.M t @ @ @ @ @...... # t t @.. t t tX. q.M tX. h.( h s.(.# * o.r P *.<.TX. P.( h H.pX. h.( # t H h.(.M t #.(.(.( h.q H h t h.K .X. h.T #.( # t h H O h t h t.T.M hXX.= P.#XXX=.<.D.< * h hXXXd oXd.9X. # # #.e @.( oXdX= h.q ,.. t .Xb.MX=.K tXb.M hXb.M t @.K.E t @ @.K.M @ @ t HX=X= @X= o.E 8 @ @ #.p IX=.p.e.qX=X= IX=.p o.qX= o o.~X=X8X= o o o o o o.q 1 o H.qX=.(X= o o.qX=.(.p.E.M t t t @ t.M ..T #.K # t t t #X=X= @ t.K.K.E.( I I I.E.p.E.p # h H hX8 1.~ oXX R P o.qX=X=.(.K.T # @.M.M t @ @ @ @ @...... # t t @.. t t tX. q.M tX. h.( h s.(.# * o.r P *.<.TX. P.( h H.pX. h.( # t H h.(.M t #.(.(.( h.q H h t h.K .X. h.T #.( # t h H O h t h t.T.M hXX.= P.#XXX=.<.D.< * h h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.l # H.( t.M @.p.e.p.$ T T TXMXn TXM TXM T T T TXM TXn T $ TXMXn T $ T $ TXM $ TXM $XM T $ $Xf $XM $X0XM $ $XMXMX0XM.QXM $XM.QXM $.c.k.m.mXq./././././././././././ <././ < 8X8.GX* NX7.% gX&X&.P TX+.^.c f 8.A 8.>.c.t.c.B x G G N.8.8.8.8.8.) TXM T $ TXM T T.u.R T $ TXM T TXM T T T T T T TXn T T T T T T TX: T T T T T T T T.$ TX: T.$ TX: T TX: T.$X:X:X: TX:.$ T | d TX:X:.  TX:X:.$.$ TX:. X:X: TXuX:X:X:. .$.$X:X:X:.$.$X: p.$X:.$X:.$.$X:X: pX:X:X,X:X:.$X,X:X:X:X:.$X,X:.$X:.$.$.$X,X:X:X:.$X,X:.$X,X:.$X:.$X:X:X:X,X:.$X:X:.F.F.F.F.F.FXdXX P.(.(.p.EX$ @X$X$.MXb t..X$ ,.pX=.q.E.. , @.. @ @ t @ @.M.T.M @ t h.#.TX. O o.(XX o P *.D.#.h o.(.q.(.=.p # t t t.E H.M.MXb.TXX h h.(.( h.T.p.( tXb.p.q h H H.T h.p.(.K o H @ t #.T o.p h o P.# # * *.(.(.(.(.(.(.# h.M t.M t h @ t t.M oX= h * #.p ,Xb ..(.K @ t.M @ @.M .Xb.M.T @Xb.M t.M.M @.M @ t @ @ @ @.K.K.e # #.~X8.q.<.~.p I.p.p.q.K # o o.~.~ 1 1 oX=.~ o o oX= 1 oX= 1X=.q o o.~ oX= o.(.q.(.(.p # t t.K.p.K.T .Xb t.MXb @ #.K # H.( t.M @.p.e.pX8.p.e.K.. @.K.p.(X= h h.( o o.(.(XX P.(.(.p.EX$ @X$X$.MXb t..X$ ,.pX=.q.E.. , @.. @ @ t @ @.M.T.M @ t h.#.TX. O o.(XX o P *.D.#.h o.(.q.(.=.p # t t t.E H.M.MXb.TXX h h.(.( h.T.p.( tXb.p.q h H H.T h.p.(.K o H @ t #.T o.p h o P.# # * *.(.(.(.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.`.p.e.K..Xb . , ,...$Xn T T T TXM T T TXM T $ T TXMXn TXM TXn $ T $XMXn $ T T $XM $XMXM $XfXM $XMX0XMXM $ $XM $XfXMX0 $XM $.Q $ $ $Xf.uX8 8 <././././././././ <./././ <././.@ f f.} NX7.%.%X& p.J.t 6.mXqXqX8.c.c.;.c x G G.8.8.N.8.8.8.)XM T $ T $ T $ TXM T F.u T $ T T $ T T T T T T T T T TXMXn T T T T T T T T T T.$ T T.$ TX: TX: T T TX: TX: T T T.$X: T.$X: T. X: TX:.$.J TX: T.$X:X:X:. X:.$ T. X:X:X:. .$ |.$X:.$.$.$X: 'X:X:X:X:.$X,X: TX: p |X:.$X:X:X:X:.$X:.$X:.$.$X,X:.$X,.$.$X,.$X,X:.$.$X,X:X,X:.$.$X:X:X:X:.$X,.$X,.F.F.F.F.F.F e *.p #.K.. IX= @.K.E @.M t H #.KXb o.K.....K.( #.K t t.M.M h.(.(.T t #XX P.#.M O B.< o.(X=.<.h.( h hX. H H t.T #.p H.( @.M h.T.T # h H # * *.( @.T.M H.( o.q.( # H h HX. h *.( oX. H.M.( PX=.(.(.( H H.p.p h.( h h.( o.( hX..( # t.MXb .Xb # PX= V 1.f.e.K.` t t.M.M.M.MXbXb t t @ t t t tXb.v.v . @Xb.M @ @ @ @.qX8.(.pX= o.( V.~Xd VX= o V.E IX=X= o.~ o.~X8 * o o o oX= o o o oX=X=X= o o o oX=.e.p.pX=.( I.q.(.p.M #.K h # h t t.T t # #.p.e.K..Xb . , ,.. t t #.T # h / t @.p.p.p.q.(.p oX= *.p #.K.. IX= @.K.E @.M t H #.KXb o.K.....K.( #.K t t.M.M h.(.(.T t #XX P.#.M O B.< o.(X=.<.h.( h hX. H H t.T #.p H.( @.M h.T.T # h H # * *.( @.T.M H.( o.q.( # H h HX. h *.( oX. H.M.( PX=.(.(.( H H.p.p h.( h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O ! t.. @XbXbXb t @.. T T T TXn T T TXMXn T $ TXM T $ T $ T $ T $ T $ T $ T $ $Xn TXMXnXM $Xf $XM $Xf $XM $ $ $ $X0 $Xf $XM $XM.Q $ $ f.k.>X8 8./././././././././././ <./ < < < Z f f.^ NXwX&X1Xu.t 6 8XqXq 8.c 6.c.cX3 G G N.8.8.8.8.8.n T T $XM T $ TXM TXMXM.RX+XM TXM T T T $ T T TXM TXn T T T T T TXn T T T T T T T T T T T.$ T.$ TX: TX: T.$ T.$ T.$ T T.$X: T | c TX:X:X:.JX:X:.$X: TX:X:. X:.$X:.  TX:X:Xu T.$X:.$X:X:X: TX: pX: TX:X:.$.$ |.$X1 TX:X:X:X,.$X:X:.$X:.$X:.$X:.$X:.$X:X:X:X:X:.$.$X:.$.$X:X:.$X:.$X,.$X:.$X:.$X:.F.F.F.F.F.FXdX= h.E..X$X=X= @ t , t.K tXb H.K . H.e H #.p.E #.E @ tXb.M h.(.p.MXb h.'.# k * k P *.< o.( o.9 h h @.M.M t tX..T # # t.(.T.9X. #.T.(.p.T.9 * h H @.T.h o.( o.( @.K h hX..( hXX h.(.K.M o.(X=.(X= o.( h.` t t h o.rXd.T.(.p t t H t t.MXb.MXX.r k.D.~.GX=.p.~ H @ t tXbXb.M.v.M t.K.e.. t.p t ..v . @ t t @ t @ /.p.G.p.p.pX= *X= oX=X= o.qX=.K.e I o o o oX=X=.( 1 o.~ * 1 oX= 1 o I.( oX= 1 1.~ o oX=X=.( oX=X=X8.z t.T.p h.(.K.M t.T.' #.T t.. @XbXbXb t @.. @.K.T.E H.p.K t # @ t.K.p.9X8X8.pX= h.E..X$X=X= @ t , t.K tXb H.K . H.e H #.p.E #.E @ tXb.M h.(.p.MXb h.'.# k * k P *.< o.( o.9 h h @.M.M t tX..T # # t.(.T.9X. #.T.(.p.T.9 * h H @.T.h o.( o.( @.K h hX..( hXX h.(.K.M o.(X=.(X= o.( h.` t t h o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O : @.MXb . .XbXbXb.M.$ T T T T TXn TXM T T TX+ T $ T TXMXnXM T $ T $XM $ TXf TXMXMXM $XMXM iXM $XMX0XM.!XM $ $XM.Q $X0 $ SXMXMX0 $X0XM c.t.m 8././././././././././././././ <./.G f f.Q Q QX&.J.uXm.>XqXq.A Z.c Z 6 n G G N.8.8.8.8.8.n T $ TXM $ T $ TXf T $ T F.uXMXn TXM T T T TX+ T T T T T TXn.AXn T T T TXz T T TX:.$ T.$ T TX: T T T T d T TX: TX:X:.$X:X:.$ T T d. XMX:. .$.$X: TX:X: TX:. X: T. XuX:X:X: T pX:.$X,.$.$X:X:.  pX:X:.$X:X:X:.$X:X: pX:X:Xr.$X,.$X,X:X:X:X:.$X:X:X,X:X:X1X:.$.$X:X:.$X:.$X:.$X,.$X:X1 |.$X,X,.$X,.F.F.F.F.F.F k H @ @..X=X= o @.M.e.K.K.MXb.M @ t t.K.K t H h h h @.MXb.M.' o * H @ # O O.<.<.< P P * o h.T.T @.T t.M.M.M.M.M @ t # #.p.#.KX..( h.( H H O.( t @ tX. h.(.(X:.( h.q P H h H h.# h H.( t #.( h H.h.p.K.T.T #.T h.q.(X= h h h.T t t @ tXbXb #Xd.~ 1 1 1X=X=.e 1 #X=.e..XbXbXb t t t # 8 t.p.~X=.(X..M tX. h.T t t.K.. @.K.E.( hX=X8 o.q H.p o.K # #.p.~ 1 o o o.(.p oXd o.( o o * oX=X= oX= o o.~ VXd oXd o.qX=X=X=X=.(.p t.T H.p h @ t h hX. t @.MXb . .XbXbXb.M @.K.K.e # H.K.K # @ t t @ @ # # h H @ @..X=X= o @.M.e.K.K.MXb.M @ t t.K.K t H h h h @.MXb.M.' o * H @ # O O.<.<.< P P * o h.T.T @.T t.M.M.M.M.M @ t # #.p.#.KX..( h.( H H O.( t @ tX. h.(.(X:.( h.q P H h H h.# h H.( t #.( h H.h.p.K.T.T #.T h.q [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0 #.K t.MXb t t t.M.$ T T $ T TXM T T $ T $ TXM T T $ T T $XnXM $ T $XM $XM $ TXM $XM $Xf $XMXM $XfXM $ $XMXMXMX0XM $X0 $ $ S n $ $ $X0.k.mX8Xq./././././././././ <./ <./ < <.A zX* f N Q QX3Xm.>.AXqXq 6.c 6 Z n G.^ N.8.N.8.N.8X0X:XMXM $ TXMXn TXM TXM TXM.R 9XM TXM T TXM TXM TXM TXM T T T T T T T T T T T T T T T.$.$ T T T T T.$ T.$ T TX: T T.$ TX:.$ T T |. X:X:X:X: c.$.$X:X:X:.$X:X:.  TX,X: T. X:X: T p.$ |.$X:X:.$X:X:X:. X:X:X:.$.$X,X:.$X: pX:X:X:.$.$.$X:.$X:X:.$X:.$.$X:X:.$X:X:X,.$.$X:X,.$X:X:.$X:X:X,X:X: TX:X,X,.F.F.F.F.F.F.~ @.K ,.p , t .XbXb.M t.M . t.( H t t t t.K t.( @.MXbXb.M.M t #.p.MX. h.#.# P.(.< * PX8 o.( h.M .Xb t t.M t t #.K @ @ #.( H h.T @Xb.MX. h s h.( * oX. t.T.T.( H # #.T.TX. hX.X. h.e.K @.M.(X= # H @XbXb.M.T.pX=.(.p H t h.T P o H.K.MXb.pX8.K.K.< *.~ 1.p h h.K @ #.K @ t tXb t.M.K h.p.(.p.( 1Xd V.~ 1XdXd.:.D VXd V.K @ t.K @X. @ # @X= @ t @.K #.p.p.K.. @.eX8.q o oX=X= oX=X= o o oX=.~ oX= o.~ o.q o *.rX= 1 o o.(.p h.T.(.K @ tX. H.(.p #.K t.MXb t t t.M @...M.p h.p #.p.e H.E.K @ t t @.. @.K ,.p , t .XbXb.M t.M . t.( H t t t t.K t.( @.MXbXb.M.M t #.p.MX. h.#.# P.(.< * PX8 o.( h.M .Xb t t.M t t #.K @ @ #.( H h.T @Xb.MX. h s h.( * oX. t.T.T.( H # #.T.TX. hX.X. h.e.K @.M.(X= # H @XbXb.M.T.pX=.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` q @ H @ @ @ t @ #.$ T T TXn T T $ T T T T TXM T $ T $ $ TXMXM T $ T $ T $ T $ $ T $ $Xf $XMXMXf SXM $ $XM $XM.Q $XMX0XM $XMXf < $ $ r G 6.mX8./././././././././././././ <./ < ; f f.u N G 6 f 8XqXqX* Z 6.c.t.^.k N.8.N Q.8.N.8X:XMXn $ T $ $XM TXMXMXM TXM F.RXM TXM T $ T T T T T T TXM T T T T TXM T T T T T T T TX: T T T TX: T T T T TX: T TX: TX:X: TX:.$ T d.A T rX:. X: T TX:X:.$X: TXuX: TX:X:. X: TX:Xu TX:X:X:.$X: TX:X: pX:.$X:X:X:.$X:X:X:X1X:X:.$X:X:X:X:.$X:.$ |.$X:.$X,X:X:X:.$.$X:.$X:.$X:.$X:.$X:.$X:.$X:X,.$X:X:.F.F.F.F.F.F.& @ t @.p.e @Xb .Xb.M.M.M.MX. oX8 t.K @ @.p.K.K t.MXbXb t.M t.#.( # t O h.#.#XX.# o.< * P H t t t.M t @ t.M t t t.MX. h.p H.T t .Xb h.T * P h PXd.<.p.T # t h h H # H # @ tX..9.E t.K.M.M.M t.M.M.M.M t t.z.p.p.( H t.p.( tXXXX.( @ t.M h.p h O.< P V 1X8.q.eX..T.zX=.p.h.pXb.M @ hX= o o.~ 1Xd VXdXd.DXdXd.D.D V V &X= t.( o o VXd.~.( t t.K @ t @.(.p.q.pX=X=.~ o oX=X=X= o.~Xd 1 o oX=X8X= o o oXd.r *X=X= o oX=.q *X=.p t H.p.K @.M h h # q @ H @ @ @ t @ # @.MXb H.e.p H.K.K @ #.p # @ t.K @ @ t @.p.e @Xb .Xb.M.M.M.MX. oX8 t.K @ @.p.K.K t.MXbXb t.M t.#.( # t O h.#.#XX.# o.< * P H t t t.M t @ t.M t t t.MX. h.p H.T t .Xb h.T * P h PXd.<.p.T # t h h H # H # @ tX..9.E t.K.M.M.M t.M.M.M.M t t.z.p.p.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O !.K @ # @ @ /.M.M.M TX+Xn TX+ T TX+ T TX+Xn.R T TX+Xn TXgXM TXgXM TXf T $Xf $ T $XMXfXM iXf $ $X0XMXMX0 $XMX0XMXfX0 $X0 $ $X0X0XMXf $ $.^ 3.m.@ <././././././././ <./ <./ <./ <.@ f f.; N.^ f.AXq.A.@ Z.c 6.t.^.^ N.8.8.8.NXw.NX1 $XfXM TXf T TXf TXM.PXMXMX+.R FX+ $X+XnXMX+ T $X+ T TX+ T TX+.$XnXz T T T T 9 TX:Xz T TXzX:.A c T T d TX: d T d T T d T T dX:X:.  cX: dX: T c.$X:.  TX:. .$ T. X:X:. X:Xu.  TX:. X: T.$.$XrX:X: p.$ p pX:.$XrX:.$X1X:X: pX:X1.$X:XrX:.$X1.$X:Xr.$X: = TX:X1X:X7.$.$X1X,X:X1.$X:X1X,X:X1X:.$X7X,.$X,.F.F.F.F.F.F.& t t @.K #X8XbXb.v t t @.M t h.KX. h ,.p.(.pX8 @.MXb.M.K #.K h.(.( t t h.(.# * * P.# h H.MXb.M t t.T t @ t t t.M h.T.(.(X.XbXb . o.(.(.( oX8.9 h.# h.K tX. hXX.K.K H @X..T #.T #X$.. t.M.M t @ t t t #...K @ h.T # H.q.9 # @ t @ @ t @ #.rX. * &.<.q.e.K.~X= h.pX=.e.. > ,.E @ t *.~ X.D.D.:.D &.D V oXd V XXd & V 1X= h & VXd.~ 1.~ 1.K @.K.p.p.p.~Xd.r o o o.rXd V.qX=X= o.~.r.~ 1.~ o o o o oX= o.(X=.( oX= P.q oX8X=.q #.M t t @.MXb t.T.K @ # @ @ /.M.M.M.M.M t t.M.T.p.e.K.K # H #.E.K.K @ t t @.K #X8XbXb.v t t @.M t h.KX. h ,.p.(.pX8 @.MXb.M.K #.K h.(.( t t h.(.# * * P.# h H.MXb.M t t.T t @ t t t.M h.T.(.(X.XbXb . o.(.(.( oX8.9 h.# h.K tX. hXX.K.K H @X..T #.T #X$.. t.M.M t @ t t t #...K @ h.T [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O j.( H #.pXb ... @...$ T T T T T T T T T $ T TXMXn $ TXMXM TXM $ T $XMXM TXM T $ T $XMXMXfXM $XMXf $XM $ $ $XM $ i $XMX0 $ $ $X0 $ $ $ $ 7.k.>X8 8./././././././././././ <./././Xq.cX* f N.t 8 <Xq 8 Z 6X*.t.^ G N.N.8.8Xp.NXp 9X:XM $XM T $XMXMXn $ TXMXM TXM.R.R T T TXM T TXn T T T T T T T T.$ TXj.a.gXg.!.!Xk.XX:X:.$ T T T TX: T TX: T T TX:.$X:X:X:X:X:XMX:XM. X:X: T |. X:.$X: TX:.$X:X: dX:.$ | T. X:X:X:. X:X:.$X:X: T.$X:X:X:Xu.$X:X:.$ |.$X:.$X: TX:X:X:X:.$.$X,X:X:.$ |.$.$X,X:X:X,.$X,.$.$.$X,X:X,X:X,X:.$X:X:.$X,X:.$X,.F.F.F.F.F.F PXbXb.M t.M t t.M t @ t h # t tXb.(.KX. o.p.eX=.T t.MXb.M hX8 # #.p h tX. t.(.( P P.(.p.T h H.M.T t.M t h.T . tX.X8.(.p tXX h h * 1.= o *X= H t.M ..T.M.M oXdXd h @X.X..K.T t.M.M h @Xb t t @ t @ @.E t #.E.E @.(.p h *.T.M @.M @ @ t...K.pX= V.<XX.G 1 ,.eX=.f V V VX=X=X= tXb.z &.D.:.: V.D.DXd V o o & VXd V.:.: o o.D.: V.:.:.D.~.p.q.~ V.<XdXd o.pX=X=Xd.~ o.~ * 1XdXd o *.~ o V o.~ o o o.( o o o o o.~ 1 V o o o o o.qX=.(.M t.M t @Xb.( H #.pXb ... @...K @ @ t t t.M.M t t h H.K # H @ tXbXb.M t.M t t.M t @ t h # t tXb.(.KX. o.p.eX=.T t.MXb.M hX8 # #.p h tX. t.(.( P P.(.p.T h H.M.T t.M t h.T . tX.X8.(.p tXX h h * 1.= o *X= H t.M ..T.M.M oXdXd h @X.X..K.T t.M.M h @Xb t t @ t @ @.E t #.E.E @.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O :X..(.e t t.M.K.K.K.$ T T T T T T $ T T T TXMXM T T $ T T $ T TXM T T $ $ T $ $XM $ $XfXM $XMXM i $ $XM $XM $ $X0 $XMX0XM $ SX0 $ $ $ $ S.k.tX8X8 <./././././././ <./ <./ <./ < < f fX*X*X* <.A.A.c 6 6.t.^ G N.8.8.8.8.8.8 0 | $ $ TXM $ TXM TXM T $ TXMXM T.R.R T T T TXM TXM T T T TXM T TX:.g.).n.n.nX-.!XgX+ dX1Xg.$ TX: T T TX: T TX: T T T T T T T TX:X:X: cX: T T T cX: T T.$X:.$X: TX:. X: TX:X:.  TX:.$ ' T TX:.$X:.$X:X:X: TXrX:X:.$.$.$X:.$X:X:X7X:.$X:X,X:X:.$.$X:X:.$.$X:.$X:X:.$X:.$X:X:X:X:.$X:X:X:.$X,X:X,X:.$X:X,X:.F.F.F.F.F.F P t.K @.M.M @.K.MXb.M t.T / t.M t.M t t h # P.(.M.M . .Xb.M H t.K / #Xb t t hXX.(.(.T h h #.T.M.M.MXb O o t ..' h.T t t.p oX. h o.e.M h HXX.( H @.M H.MX.Xd.D.D.(.T @.T h H.T H t t.M . t t tX. t @.~ @ t.p.E.TX..T h.E @.M H.T # t t.. @ t h.~.< H.e I.9 h h H.~ PXd @.( X t.M # &.D V.D.DXd * oXd.<Xd o VXd V.:.D oXd.D.D V &.:.: VX8 VXd VXd V VXd o.( o o o VXd.r V VXdXd o o o V o V V.~X= o.~ o o.~ o.r o o oX= o.qX= o.(.(.M.MXb t t tX..(.e t t.M.K.K.K.K @ @ @ t t t.M t t t @ @.K @ t t t.K @.M.M @.K.MXb.M t.T / t.M t.M t t h # P.(.M.M . .Xb.M H t.K / #Xb t t hXX.(.(.T h h #.T.M.M.MXb O o t ..' h.T t t.p oX. h o.e.M h HXX.( H @.M H.MX.Xd.D.D.(.T @.T h H.T H t t.M . t t tX. t @.~ @ t.p.E.TX. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.lXbX..T.M @.. @ @ #.$ T T T T T T T T TXn $X+ TXM T T $ T $ T $ T $XM $ TXf $ T $XMXMXf $XM $XMX0XM $Xf $ $ $XMX0XM $X0 $ $XM $X0.Q $ $ $.D.k.@X8 H./././././././ <././ <./ < < <.A fX*X* 8XqXq f ZX* Z v G N.8.8.N.NXp.8X1.X $XM $ T $XnXMXMXM TXM TXf TXM T.R.uXMXM $ TXM T T TX+XM T TX:.aXe.g.g 7X2.a.g 7.gXe.!Xg d.oXe.$.$.$.$X:Xj 7.g.  T.$X:.$X:.$X: T TX:.  TX:. X:. XMX:X:.$X:X: TX: TXuX:X:.  T pX:X:.$XuX:X:X:X:.$X:X:. X:X: pX:X:.$ |.$X:X:.$X: pX7X:X:.$.$X:X:X:.$X,X:X:X:X:X:X7X:X,.$X:.$X,X:X:X:X:X:.$.$X7.$.$X:.$X:X,.F.F.F.F.F.F P t h.K @ # @ tXb t / @ @ tXbXb .Xb.M.K.M ..M t ..v.v.v .Xb.M t t @.(.M.MX. h h.#.h.(.(XX H t @.M.M.M.T h t.M.M t.TX. @ h *.( H.T.K @ h.T.'.(.T t k.<.( P V &.bXd.p H @ t # # # HXb.M . @ t @ t t @.K.M.M tX..K @.p.q IX=X= t @ t.T h.e @ t t.( 1 HX=.p.# 4Xb s o PXd O.~XdXd.q #X=X8Xd VXdXdXdXd V.~ VXd V VXdXd V o &Xd VXdXdXd V.e *.D V VXdXdXdXd.~ o.DXd.q o.~ oXdXd V * o.~XdXd VXd V.rX8.~ VXd V oXd o o oX= oX=X=.q.(.( o h @.M.M.T.KXbX..T.M @.. @ @ #.K.p @ @ t.. @ @ @ I.eX=.e IX= t t t h.K @ # @ tXb t / @ @ tXbXb .Xb.M.K.M ..M t ..v.v.v .Xb.M t t @.(.M.MX. h h.#.h.(.(XX H t @.M.M.M.T h t.M.M t.TX. @ h *.( H.T.K @ h.T.'.(.T t k.<.( P V &.bXd.p H @ t # # # HXb.M . @ t @ t t @.K.M.M tX..K @ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O : @ @Xb @ t @.K.K @.$ TXn T TXn TXM T TXM T $ TXM T $ T $.$XMXnXM T $ T $ TXMXM TXM $XfXM $ $XfXM $XM $ $ $ $ $.QXMXMX0 $ $ $ $X0 $XM $ $X: G 6X8X8././././././././ <./ <./ <./ < < 6 fX8XqXq.>.c 6 Z.^ G G.8.8Xw.8Xp.8.8.a $Xn $XMXM TXMXM TXM $XnXM TXM TXM F.R T T T T T TXM TXM TX:.a.g.gX2Xj | |Xj | |.a 7 7.wXe.!.PX1.PX:X2.g.!Xk.! 0 d.!.a.$ TX:.$ TX: TX: c TX: TX: cX:X:.$.$X:.$X: TX:.  TX:X:X:. X:X:X: T. X:.$X:.$X:.$.$X:X:X: p T.$X:.$X:.$X:X:X: pX:X:.$X:X:.$.$X:.$X:X:X,.$X:X:X:X:X:X,.$X:X:X,X:X,X:X:.$X:X:X:X:.$X,X,.F.F.F.F.F.F.<.p h t.M # P V 1X= # t t.TX= o.K.q.TXX @.M.9X= @ t @ t.# h.(.# H #.M t.T.M.MX. H.h H.p.T t tXb tXb @ tX. t.M.M P.(XX V.q.< h oX= tX. * @ @ @.K h.<.(.( H.(.9.q.(Xd.< h t #.(.K.K @.M.M.K t.M @ @ @.p @.KX=.K @ t t.|X=.~.~.. @ t.(.p.( @ @X= 1 #.K tX8.p.T t.p o V P o jXX.~ 1X= R.< & V VXd.DXd VXd.<Xd.D.: V V.qXd.:.D &.b.:.DXX V & V.D V &.D V &XdXd.~ 1Xd.(.(.~.~ 1 oXdXd V.(X= o.~ o.p V.D VXd o 1 o oX= o.q o 1 oXd.~ oX=X= H t @ t t @ @Xb @ t @.K.K @ @ t @...E H.p.K , o oX=X= H t h H.p h t.M # P V 1X= # t t.TX= o.K.q.TXX @.M.9X= @ t @ t.# h.(.# H #.M t.T.M.MX. H.h H.p.T t tXb tXb @ tX. t.M.M P.(XX V.q.< h oX= tX. * @ @ @.K h.<.(.( H.(.9.q.(Xd.< h t #.(.K.K @.M.M.K t.M @ @ @.p @.KX=.K @ t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.` #.. @ @ @ t...K #.$.$ TXM T T T T $ T T TXM TXM TXn T $ TXMXM TXMXnXM $ T $ T $ $Xf $XMXn $ iXMXM $ $XMXM $XMXf $XMX0 $XM $ $X0 S $ $XMXM.Q.u.mX8Xq./././././././ <./ <./ < < < <.@.>Xq < 8.cX* Z 3 G G.8.8.8.8XpXp.8.a $XM $ TXM TXMXnXM TXM TXM TXMXM $X:.R FXM T T TXM T TXM T.$ 7XjX2 |X: |X: |X> | | |X  D 7.w.w.).P.+.!.g.g.g.gXO.n.! d.o.D.$ T.$ TX:X:XM.  TX:X: T.JX:X: T.$.$X:X:X: T p TX:X: T pX:X: TX: pX:X:X:X:.$ |X:X:X:.$ pX:X:X:X:.$X:.$X:X: TX7.$X:X:.$X:X:X:X,.$X:X:.$X:.$X,X,.$.$X:.$X,X:.$X:X:X,X:X:.$X,.$X:X:X:.F.F.F.F.F.FXd.T.' t.M @ o V V.r o.K.q.~ V oX=.9.(XX t.M.( o /.M HXXX= h.p.( h.9 P #X. t.M.MX. h h.h.T.MX.Xb.M . t./ H t . h P.# h.=X. o * oX8 t.(.(.p.T t t.(.( s.p h #X..XXd V.< #.=.`.(.M @ #.M t.. t @ #.K.p.K @ h.K.K.K...K.. t @ @ @ @ t @.. , t @.p 1X=.K # #.K P h.p.G 1 V o P.1 *Xd.pXd V V.DXd.< & &XdXdXdXdXd & V o.pXd & VXdXd.DX=.:.:.D.:.: VXdXd.D V V.D o oXd.( P.~ V o o V.<XdX= HX= V o.( VXd.~ V V o o o oX= o.q o o 1Xd o o.q.(.T.E @ @ #.. @ @ @ t...K # t t @ @.p.K.e.K.p o V o.q.(.p.p.(.T.' t.M @ o V V.r o.K.q.~ V oX=.9.(XX t.M.( o /.M HXXX= h.p.( h.9 P #X. t.M.MX. h h.h.T.MX.Xb.M . t./ H t . h P.# h.=X. o * oX8 t.(.(.p.T t t.(.( s.p h #X..XXd V.< #.=.`.(.M @ #.M t.. t @ #.K.p.K @ h.K.K.K.. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( H.. @.M.T.K t.K /.$ T T T T TXn T T T T TX+ $ TXM T $ TXn TXM T $ T $XMXf T $ $XMXfXMXM $ $Xf $XM $Xf $ $XM $X0 $XMX0 $ $ $XMX0Xf $ $ $ $.a G f.mX8./././././ <./ <./ < <./ < <./ <Xq <Xq 6 f 6X3 G.J N.8.NXp.8.8.N 7XMXf T $XMXnXM $ TXMXM T $ T $.R T TXM.R.R T T $ T T T T T.P.a.aXjX: TX: r r r rX>X>X>X> |XN.w.w.)X0.PXeX2Xj |X2.a 7.g.!.PX7 d T T.$ T.$.  TX: T.yX:.  TX:.$X:X:.$ TX:X:. .$X: dX:. X:X:X:X:. X:X:X:.$.$X:XrX:X:X: T p.$X:X:X:.$X:.$X:X1. X:X:X:X,X:.$X,.$X:X:X:X:X:XrX:.$X:X:X,X:X:X:X,X:.$X:.$X1X:X:.$X,X:X:.F.F.F.F.F.FXd.T.p.T #.KX= o o.~ o o V V VXd V *.(.< #X. o.( #.T #X. h s s.'.T # h o H h # @Xb.M @ t.M.M t.M .Xb tX..T ..M.9 h.( s.(.M * oXdXdX. P o.h.K h h & 2.(X= hX8 @ h.<.(.' H oX.Xb ....M.M @ @ t #X$ ,.E t @ # @ I.K @ @ t.M t t t @ @ ,...|.E.p P 1X=X=.(.p t.D V H.E o V.zX= o * o H V o VXd oXd VXd.D V.D.D.< VXd oX= &Xd V X.<.~X= V.:.:Xs.: &.<.: & V &.D.~XdXd &.D V 1 o oXd o.<.r.q o o.(X=Xd V oXd o V o o.~ o o o o.~Xd o 1 o.(.q.K.T #.( H.. @.M.T.K t.K /.M.M t.K H.(.eX=.pX=X= 1X=.q o.(.(.T.p.T #.KX= o o.~ o o V V VXd V *.(.< #X. o.( #.T #X. h s s.'.T # h o H h # @Xb.M @ t.M.M t.M .Xb tX..T ..M.9 h.( s.(.M * oXdXdX. P o.h.K h h & 2.(X= hX8 @ h.<.(.' H oX.Xb ....M.M @ @ t #X$ ,.E t @ # @ I.K @ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0 H H IX. @.MXb.M t.$ T T T T T T T T TXn T $ T T T $ T TXMXM T T $XMXnXM T $ $XMXM.!XMXMXM $Xf $ $XM $XM $ $ $X0XM $X0 $ $ $ $Xf < $ $ $ $ $.k.tX8X8Xq./././././././ <././ < < < <Xq <Xq < 6X* ; G.J N.8.8.8.N.N.8Xe $ T $ $ TXMXM $ T $ T $ T $ TXM T T $ T F.uXM T T TXM T $X:.aXjX: T TXM rX: r rX> r r r rX>X> | D.w.w iX2X: | | | | 7 7Xe.!.PX7XfX:.$ TX:.yX: TX:X:X: c TX:.$X: TX:.$X: T. X:X:X:X:.JX: TX:.$Xu T.$X:X:X: TX:X:X: T |XrX:.$X:.$X:.$X:X:X:X:XrX:X:.$X:.$.$X:.$X,X:X:X:X:X:X:.$X:.$.$X,X:X:X:X:X:.$X,X:.$X:.$.$X,.F.F.F.F.F.F _.( H h t h.(.(.r *.#X8 s.<.D oXdXd P PX8 h h #.h.KXX oX=.<.D oXX.(.( t #.T # # H t.vXb.M.M . tXbXb.M @ t.M o V H #.T q.M.M.( o * o.9XX * o.D PXdXd oXd o o.( o.T h.TXb.T t @ . j @.M t t #.h t.p.E t t t.....E s h oX=.e.K @ @.e.. I.(.~Xd *X= o hX= H.qX8 H.E.qX=.G @ @ @Xb # 8 VXd.~.~ o V VXd &XdXd V & 1 oX=.< & o o * 1 o V V.D.:.D.D.D.:.:.b.:.D.:.:Xd VXd.D.:Xd & oXd oXdXd 1X=.qX=Xd V V VX= o * o.<.~ 1 o 1Xd o V VXd.~ oX8 h.pX8.p H H IX. @.MXb.M t @.MXb H.z H.e.p.e.q 1 V.(.( o o.q.( H h t h.(.(.r *.#X8 s.<.D oXdXd P PX8 h h #.h.KXX oX=.<.D oXX.(.( t #.T # # H t.vXb.M.M . tXbXb.M @ t.M o V H #.T q.M.M.( o * o.9XX * o.D PXdXd oXd o o.( o.T h.TXb.T t @ . j @.M t t #.h t.p.E t t t.....E s [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX>.E.p h.T.K t t @ t.$Xn T T TXn T TXM TXM T TXM $ T T $ $ T T $ T T $ TXM $ T $ $XMXfXMXMXM $XfXM $ $XM $ $ $ $ n $ $X0 $ $ $ $X0 $ $ $ $ $ $.D.^.@X8.@././././ <./ <./ < < <./ < < <Xq < 8X*.t G G N.N.N.8.NXp.8X0 T $XM $ $ T $ $Xn $XMXMXM TXM T $ TXMXMXM.RX+XM TXM T T T T.aXjX: T T rXM r r r r r r rX> r r rX>X>.w.;X0 r r rX>X> | D D.;.)X0.J A 7.$.$X: d TX: TX:.J TX: T.$X:X:.$X: TX:. X: TX: T. X:X: TX:. X:.$X:X:.$X:X:.$.$X:.$ p.$X:X:X:.$X:.$X:.$X:XuX:X:.$X:X:X:X:.$.$X:X:X:X:X:.$.$X:X:X:X:X:X:X,X:.$X:X:.$X:.$X:X,X,.F.F.F.F.F.FXd.( t.MXb.K #.p V P k.M *.< V o P 2.<Xd.T h.(X..(.e h.(.( * hXX.9 o.9 t t h * H @.M.MXb.M t . tXb .X..' @Xb.# H.( t.MX. @.M P o &.TXX P P.p o V.D o.< *.< o h tXb tXb . t #.# t t @ t @ @ @ @ @X$.K @ t @.M.E I o o.< # H.( o.(.( o @ @X8X= V oXdXd C o o.p I.e.Y.r ,X=.( hXb s t o o.r V V V.D V.D V.DXd.~ o o oXd oXdXd o.p.~XdXd.:.b VXd.: &.D.:.: VXd.b.D.:.w.D.: VXd V V VXd V.< VX8Xd V o.~.< o o oXdXd.< V o o.( o o o 1 o.q.( # H H H.E.p h.T.K t t @ tXb.M.M H.pX8.z.(.pX=.( o.(.h h.(.(.( t.MXb.K #.p V P k.M *.< V o P 2.<Xd.T h.(X..(.e h.(.( * hXX.9 o.9 t t h * H @.M.MXb.M t . tXb .X..' @Xb.# H.( t.MX. @.M P o &.TXX P P.p o V.D o.< *.< o h tXb tXb . t #.# t t @ t @ @ @ @ @X$.K @ t @.M.E I o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.C.p.K H h # H.E.. @.$ T T T T T T T T T T TX+ T TXM TXn T $ T $ T $ T $XnXfXM $XMXfXM $XM $Xf $ $ $ $Xf $ $ $XMX0 $ $.QXM $ $ $X0X0 $.A $ $ $X: G 6X8X8././././ <./ <./ <./ < < < < < <Xq 6.c G N N.N.NXp g.8.NX0X: $XMXMXf T $XM T TXM T $ TXMXn $ TXf T TXM F.R T T T TXMX:Xj | T TXM $ S r r r rX> rX> r r rX> rX>X>XN.w.; $ $ r rX>X>X>X> D.;X0XfX7.8X: T T dXMX:X: d.JX:X: T TX: TX: TX:X: cX:X:. X:. X:X:X:X:. X:.$X:.$X:.$ pX:X:X:X:.$. X:X:X:X:.$.X TXr.$ TX1X:X:X:.$X:X:X:X:X:X:X:X1X:X:X:.$X,X:.$X:X,.$X:.$X:X1 |.$X:X,.$ |.F.F.F.F.F.F.< h.T t.M 8.p.K * o.~ O.<Xd.<.(.T *.<.<Xb.M.9.M H.K h.( h.( h o.( h hX. h H h h #Xb.M t t tXb.9 h.MX. h.pXb tX..MXb.M.T t.q.(.q.DXX.X & h.( o.:.b V o * o.p.( .XbX. # tX..(.( tXb @ @.E h , @ t.p.q @ t t.M.E.( V VX= *Xd 1.(.(X=X= #.M.e HX=X= V V 1XdX=XXX8.. o o.p V.f H.K.. HX8 o oXd.D VXd.: V & VXd o o.~Xd V o V o o.( V.D.D.DXd.DXd.: &.b &.DXdXd.D.:.D VXdXd VXd.D.:Xd o.D.~ V o V.~ o o.~ * * 1 o o.~Xd o o.q o.~ o o oX=.( h #.p.E.p.K H h # H.E.. @.M t @.p.p.qX8 IX=X=X= oXd.( h h H h.T t.M 8.p.K * o.~ O.<Xd.<.(.T *.<.<Xb.M.9.M H.K h.( h.( h o.( h hX. h H h h #Xb.M t t tXb.9 h.MX. h.pXb tX..MXb.M.T t.q.(.q.DXX.X & h.( o.:.b V o * o.p.( .XbX. # tX..(.( tXb @ @.E h , @ t.p.q @ t t.M.E.( V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0.p.p H #.p.p.q.p.K.$ T T T T T T T T T $XM $ T T $ TXM TXnXM T $ TXM TXMXMXn T $XfXMXMXMXMXfXM $ T $ $XMXM $XM.Q $ $ $X0 $ $ $XM.Q $ $ $ $ $ $ n.uX8X8 <././././ <./ <./ < < < < < <Xq < 6 f N G.8.N + g g.N 0 T $ T $XM $XM $ TXM $ T $ T $ $ TXM TXMXMXM T F.u TXM TXM T.XXjX: T $ S S r r r r r r r rX>X>X>X>X>X> r.m.w ] b Y r |X>X>X>X> D.w.; i.y N.aX: T cX:X:X: r.yX:X:.$ TX:X:X:.$X: TXu TX: TX:X:. X: T TX:. X:.$X:X:.$.$.$X: TX:X:Xr TX:.$.$X:.$X:X:X:X: TX7.$X:X:X,X:.$X,X:.$ |.$X:X,X:.$X:.$X:X,X:.$X:X,.$X:X,X:X:.$.$X,.F.F.F.F.F.F k.TX. @ @ t t.p o.<.D.DXdXd.< PXd @ tXb.MXbXb t H.T h h.' H *X8.T t.9 # h h.T.T.T.v.M.M.TX..T.M.( h t.T h.(X8.( h P.( tXb @.( VXd oX8.(.D.9 t P h H @ t.M ..v hX. @.M.M.M @ t.M.M @.M.M #.qX= t hX. @ @ @.E.~ o o o oX8.(.p.zX8.q.~ VX8 @.T.h.K.EX= o.eX= o o.(XXX=.(X= C 1XX tX..K o o o oXd & o.D.D.:XdXd oX=Xd o o oX=.p.< VXd.b.:.: V.b V &.b.D.:.D.b.D.DXd.b.D.D.D.:.D.D.DXd.< o o o.r 1.<.~ oXd o.< * o oXd o.~ H t t.M h o oX=.h h.e.p.p.p H #.p.p.q.p.K @ @ @.qX8 oX=X=X=.(.( oXd o o t h.TX. @ @ t t.p o.<.D.DXdXd.< PXd @ tXb.MXbXb t H.T h h.' H *X8.T t.9 # h h.T.T.T.v.M.M.TX..T.M.( h t.T h.(X8.( h P.( tXb @.( VXd oX8.(.D.9 t P h H @ t.M ..v hX. @.M.M.M @ t.M.M @.M.M #.qX= t hX. @ @ @.E.~ o o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.e H.p.K H H H.e.p.p.$ TXn T TXn TXM T T T TXM TXM TXn T $ T T $ TXMXn $ $ TXM $XMXfXM $XMXM i $XM $ $XMXM $ $ $XfXM $ $X0XM $ $XM.Q $ $ $.6 $ $Xm.k f f <./ <./ <./ < < < < < < < <Xq < <.>X*.t NX7 g.N g g.8.aXM $XM $ TXMXn $XMXM T $ $XM TXM T $XM TXM TXM.R.u T T T TX:X2X: T S Y SXM r r r rX>XM.x r rX> r r rX>X> r ] | M bX: rX>X>X>X>X> ].;X0 FX7X0X:.yX: T TX:X:.JX: TX:X:X: TX:.$X:X: dX:X:X:X:X:.  TX:X:X:. .$X: TX:X:X:X:.$X:X: TXrX:.$ |.$X:.$.$X:X:X:.$ pX:X:X:.$X:X:X:X:X:.$X:X:X:.$X:.$X:X:.$X:X,.$.$X,X:X:.$.$X:X, |.F.F.F.F.F.F k.M s.( H.M t q.(.2.< &XsXd o o oXbXb.M.p.. t h.p #.( h t o H h hX.X. h # h.p h hXb tXb / tX..T.(.pXb.M H h h.(.( H.(.pXb.M.( h.<Xd.( *.<.(X..e t.MXb.MXbXb.M h t @ t / t.M.M t.M t @ t.p.T tX. H @ t t.M 8.( & o o.~.pX8.( @ hX=X=X= H o.p.(.( #.E s.# h.q.<Xd *.( CX=.~ o XXX.h @ o.<Xd & V V.<XdXd.: o V.~.(.r o o V.E.( o o V.:.D.:.:.:.:.: V &Xd 1 V.: l.b.b &.b &.:.:.: &.DXd * oX= VXd o V V VXd V oXd o o oX=Xd o.( t.M * oX=.e B.K.e H.p.K H H H.e.p.p # H.p.zX8X=.p.pX=X=.p.(Xd P *.( h.M s.( H.M t q.(.2.< &XsXd o o oXbXb.M.p.. t h.p #.( h t o H h hX.X. h # h.p h hXb tXb / tX..T.(.pXb.M H h h.(.( H.(.pXb.M.( h.<Xd.( *.<.(X..e t.MXb.MXbXb.M h t @ t / t.M.M t.M t @ t.p.T tX. H @ t t.M 8.( & o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0.E H.E # #.T H.p.(.$ T T T T T T T $ T T TX+ $ TXM TXM T $XnXMXM T $ T TXf TXMXfXMXMXM $ $XfXM $ $XMXfXM $ $XMX0XM $XMX0 $ $ SXMX0 $ $XM $ $ $ $.k.t zXq././ <./ <./ <./ <./ < < < <XqXq.>X*X* NXu.N g + g g.D $XM $XM $XfXM $ T $XMXM T $XMXM $ T $.P $ TXM.R.R TXMXn TXjX:XM $ Y b.x r r r rX>X> r rXM rX>X>X> rX> r |Xm S M SX> |X>X>X>X>.m D.w ; FX7.RX: cX:X: TX:.J dX:.$ T TX: TX:.$X: T p TX:.  TX:. X:.$X:X: pX:.$X:X: T p.$X:.$.$X:X: pX:.$X,X:.$X:XrX:X:X:X: 'X:.$X:.$X:.$X:X,.$X1X:X:X,.$X:X:.$X:X:X:X:.$.$XrX:X:X:.$X:X,.F.F.F.F.F.FXdX. h.(.K t t t t R o o &Xd 1 o o .Xb #.( I /X..K h.p.TX..( oXXX..TXX.p.(.( H h t t.T.M.# h h.M.( H.M h h.( # tX.X..T.TXb.M t t @.K.' s.(.(Xb.( # #.MX..T h.' t t t t.K.. tXb.M t t.T #.(.T.[ h.(.p @.M t t P *X= o o.p.p.p #.(X8 I H.h o.q.K.q.K #.qXX R.#Xd.D V 1.(.p o.r 1 1.~X. *.: o.< oXd o.D V 1 o V V.q.(.( * #.qXd.<Xd V.D & V.:.D.b &.<Xd.D & &.b.b.b.: &.:.D &.D V &.: V oX= o 1 1XdXd oXd VXd o.~Xd o o o * o o.h.p.( o I.K B h.p.E H.E # #.T H.p.(.K.p.K.p I.q.e.K.p H.( o o.<.<.(.pX. h.(.K t t t t R o o &Xd 1 o o .Xb #.( I /X..K h.p.TX..( oXXX..TXX.p.(.( H h t t.T.M.# h h.M.( H.M h h.( # tX.X..T.TXb.M t t @.K.' s.(.(Xb.( # #.MX..T h.' t t t t.K.. tXb.M t t.T #.(.T.[ h.(.p @.M t t P *X= [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O O.K.(X= H # h h H.p.$ T T T T T TXM T T T TXM T T $ TXnXM TXM TXM $ T $ T $ T $.R $ $ T $XfXM $XMXMXM $ $XMXM $ iXM $ $X0XMXM $ $X0XM $ $ $ $ $ $.@.J.c z < <./ <./ <./ < < < < <Xq <Xq <Xq 6 Z.; N Q.8 +.I.% g.w T $XM $XM TXMXMXMXM T T $XMXMXM T TXM T TXM F.R TXMX:X,X:Xn 4 ( b.x r r rX>XN DX* ] r HXM H rX> r 8X>X8 ]./ M SX>X>X>X>X>X>X> D ] ;.R G.R T cX:X: T T. XMX:X:X:X:X:X: TX: TX:. X:X: T TX: pX:X:X:X:XuX:X:.$X:X:.$X:X:X:X:X:X:X:.JX:X:.$ |X:X:.$X:X:X:X:XuX:.$.$X:.$X:X:X:X:X:.$.$.$X:X:X:X:.$X:X:X:X,X:X:.$ |X,X:X,.F.F.F.F.F.FXd.q.p *X= t.M @ t # H V * *.qXd 2.p H *X8.(.T.(X8XX.( H # * P.< h h @X8X=.p #.T t.T.T tX.XX.( t.T #.M.TX. H.(X= t t.M ..v . t . ..M t.(.T.M t H # h H * o.(.T #.( # @X..K.M t t.M oXd * *.<.(.[.(.q # H s o.< P oXd VX=.p H o o.(.(.p.( o.q.e.(.( @ # H H.(X8 o t @.e PXX.q 1 1.D V V.:.2Xd oXd V.~ o o.D V.( *.~.<.( V.D V.~ 1 o.:.:.D V V &.:Xs.D.:.D.:.D V.: V.:.D V.D.:.:.D.: o VXd.<Xd 1 VXdXdXdXd.~ o o o.~.~ o o o o * o o o oX=X=.# O.K.(X= H # h h H.p.p.K.T # #.pX=X=X=.hX=.( o o P.(.p.q.p *X= t.M @ t # H V * *.qXd 2.p H *X8.(.T.(X8XX.( H # * P.< h h @X8X=.p #.T t.T.T tX.XX.( t.T #.M.TX. H.(X= t t.M ..v . t . ..M t.(.T.M t H # h H * o.(.T #.( # @X..K.M t t.M oXd * *.<.(.[.(.q # H s o.< P o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.h.E.K H.p.p H h h #.$X+ T TX+Xn TX+ T TX+XnX+XMXnX+XM TXf T $Xf T TXfXn $XfXMXMXfXM.! $ $ iXM $XfXM $.! $ $.QXM.!X0 $XfX0XMX0XMXM.QXM $X0 $ $X0 $ $Xz v.> H./ <./ < < < < < < < < < <.A <Xq 6X*X*.^ N.8X& +.I gX& $XfXnXMXf $ TXfXMXf $ $Xf T $.PXMXn.RXMXM.RX+.RX+XMXe |XM 4 ( ( S rXM r rX> z Z.cX3 r r r.xXM HX> H H.m Z S YXMX>X>X>X>.m.mX> D.c.B F GX0 cX:X:.yX:X:.yX:X:. .$X:. X:.$. X: T.  TX:. X:X:.JX:.$. X:.  TX:. X:.$ pX: T p.$X:XuX: ' pX: TXrX:XrX:X: pX:X:X1.$X:Xr.$X:XrX:.$X1X:XrX:X:XrX:X:X1X:X:X1X:.$X1X:.$XrX:.$X:.F.F.F.F.F.F k.(.( o P / # t.T.p h o.'.T.e.( #.( k.D P o * h.p.(.(.( h o o hX. t.K h.#X8.T t.M h.T.M h.# # t #.KXbX.X..p.( @ @ @ t t.MXbXb.M.M t.M @ t t t # # H.p.( P.9.K.K.9 # @ h h @X..T.M o.<.<.(Xd P.6 m.#.T.p.#X8.(X8 h.(.q.e.p.( V.< oX=.(.(.p.e.p.p.K t.E.e...(X..(.h @ tX8.(.K.e C V.:X= oXd oXd.DXd V oXd.D V o o V.~.E.D.:.D o.D.:.4.D V &.:.:Xd V.:.DXd V.D.D.: &.:.: &.D.:.b.:.b oXd.D V oX= V oX= o o o o o o V.~ o oX=.( o.~ o.z.(X= I H h.E.K H.p.p H h h # H.p.p H.K HX=X=.e #.#.(.( hX. o h.(.( o P / # t.T.p h o.'.T.e.( #.( k.D P o * h.p.(.(.( h o o hX. t.K h.#X8.T t.M h.T.M h.# # t #.KXbX.X..p.( @ @ @ t t.MXbXb.M.M t.M @ t t t # # H.p.( P.9.K.K.9 # @ h h @X..T.M o.<.<.(Xd P.6 m.#.T.p.#X8.(X8 h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.h #.T @.(.p.( #.E.K.$ T T T T T T T T TXn T T T T TXM T TXM T $ T $ TXM $ T $XMXMXMXnXM T.!XMXM $XM $XM $XM $ $.QXM $ $ i $ $ $ $X0 $ $XM $XMXM $ $.X.k f.@./ <./ <./ < < < < <XqXqXq <Xq.A.t 6.;.Q N Q g.%.I gX&XjXM $XM T $XM T TXM TXM T $XM $ TXM T TXM T.R F TXMXj T $ b ( Y r r r r rXN ] ZX3 G D rXM H H H.xXq HX8XN.x.x.x rX> 8 |X>.m.m ].c.t.^ G.w c T TX:X: r.JX: r TX: T TX: TX:X: T. X: T TX: r. X:X:X: T. X: TX:X:X:X: TX:.$X: TX: T ' TX:X:.$X:X:X:X:X:.$X:X:X1 TX:X:X:X:X:X:.$X:X:.$.$X:X,.$X:X:.$.$.$X:X:X:X:X:X:X:X:.F.F.F.F.F.FXdXX H.(X=.p.K @.p.( H.#.(.(.K.E.KX. P o P oX=.T h H h HX..( h.T.( h h.T # h.T t t.M tX. t h.T./ #.TXb t.M.M t.K.E #.q.p.T t t @ / @ @X= IX= , ,.K , t @ h.p.p H.M t # t t t.M tXb.(.(.9 *.D o.M $ j s #.(Xd o # oX8.p.p.# o oXd.< o o oX=.p.q q.M t.K.p.e.e.~ o.f.p.M I I h H.pX= V o.9 V &.D V.~ o V 1 * 1X=Xd V.e hXd.:.: VXd.D.D.:.:.D o.< V.D.D &.D VXd V.DXd.D V.D & &.:.D.DXd.b V.: V o.~ 1 o o 1.~ CX=X= * V V o.~ o 1Xd oX=.(.qX=.p h #.T @.(.p.( #.E.K H H.p H.p.p.p.p H.T.(.( P.p.( o.(XX H.(X=.p.K @.p.( H.#.(.(.K.E.KX. P o P oX=.T h H h HX..( h.T.( h h.T # h.T t t.M tX. t h.T./ #.TXb t.M.M t.K.E #.q.p.T t t @ / @ @X= IX= , ,.K , t @ h.p.p H.M t # t t t.M tXb.(.(.9 *.D o.M $ j s #.(Xd o # o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0 s H.K.K h.p @ #.K.$ TXn TXM T $ T T $ T TXMXM T $ T T $XM TXM TXMXnXM T $ TXMXMXMXM $XMXf $XMXM $XMXM $ $XMXM.!XM $ $X0XMXM $XM $X0 < $ $ $ $ $ $ $.J.>X8 <./ < < < < < < < < < <Xq <Xq < fX*X* Z N Q A gXhXh gXg $ T $ $XMXMXnXM T $ $XM T $ T $ TXMXM TXM F.RXM T |XM 4 M ( $XM r r rX> z Z.c v G i D r r.x H H HX8 Z ].x.x.x r rX>X>.m.mX8X*.c n G.PX:.JX:X:X: TX: cX: T.$ TX:X: T.$X: T T. X: TX: TX:. .$X: TX:X:X:X:.$.$ TX:X:X:X:.$X:X:.$ TXrX:.$X:X:.$X:.$X: TX: TX:XrX:.$X:X:.$.$X:X,X:X,X:.$X:X:X:.$.$X:X:X,X:.$X:.$.$X:X,.F.F.F.F.F.F.;.q.~ oXd H hXX.T @ oXd o.(.p t.T.=.#XX.( h P.p.p h.( h.( HXX # H.TX.XX H t # H.T t.M.T.M ..v .Xb.M @.MXb t t t @ t @ / @ @ @.EX=.EX= V.D.DXdXd V.:.: 1.eX$.....p @ @.M t @.M.M.M h H t t.T h.( @ t b j t.T O o V.< o.( o.(.~.(.(.qXd.D o.~ 1 # # H.G H #.E.GX= 1X=X= h h.e # o.qX= P * h #.e VXd V & V 1.p HX=.T h o.~Xd.D.D &.:.:.:.b.:.:.D & V.:Xd.~Xd.D VXd.: oXd.D V.D.:.: &.: &XdXd oX=.pX8 * o o 1.~X=X= V o o.( # hXdX=.q o oXdX=.(.p s H.K.K h.p @ #.K.K.p.e #.K.(X= oX= #.(.q hXX.<XdX8.q.~ oXd H hXX.T @ oXd o.(.p t.T.=.#XX.( h P.p.p h.( h.( HXX # H.TX.XX H t # H.T t.M.T.M ..v .Xb.M @.MXb t t t @ t @ / @ @ @.EX=.EX= V.D.DXdXd V.:.: 1.eX$.....p @ @.M t @.M.M.M h H t t.T h.( @ t b j t.T O o V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.(X..h H H #.e.K.T.K.$ T T T T T T T $ T TXnX+ T T TXnXM T T $ TXM $ T $ TXfXMXMXM TXM T $XfXM $ $XM $XfXM $XM $Xf $XM $.Q $ $XMXMX0X0XM $ $.A $ $ $XM.} f.@ <./ < < < < < < < <Xq <XqXqXq.A.A.t Z.; n N A g.I.I.IXhX: $XMXfXMXMXMXM $XM $ T $ TXMXM T.R TXMXM.R F TXMX:Xn b M b r r r r r | ] Z ;.^ GXe.w |X> H.mX8.G.c 3 Z r r r r r.m H HXq HX* ;.^.^.D T. XM T T TX: d TX:.$ T T TX:X: TX: T.  TX:. X:X:. X:.$X:X:X: TX:X:.$X:. X:.$X:.$X:.$X:X:Xr TX:.$.$XrX:X:X:X,X:X:X:X7 T |X:X:X:X:X1.$X:X:X:.$X:X:.$X:X:.$X,.$X1X:X,X:X:X,X:.F.F.F.F.F.F & oX=.( *.(.q.9.p.e o o o.(.q @ h o.( h P * o H H.h PX8 h.(.' # h.p h hXX.T.T @ tX..T t.M.M.M .Xb .Xb t t t t.K @ @.K # H.p.K @.p.eX=Xd.: V V.DX0.:.D.:.~X=.e.E @.M t t t.M.M.MXbX..(.T.(.(.(.(.( HXbXb.M h h.qXdXd.( o.(.p P.(.(.<.D.<.e o.q # @XX.( h H.pX=.~.e o o.(.p.p.( oXd.p.p hX8 #X= V VXdXd V X.e.( o # *.~Xd.D.D.D.:.D.b.:.:.: V.D.:.b.: V VXd o o &.DXd.<.~Xd.D.D V V.:.D V.DXd o.pX=X=X=X=X= oX=.pXdXdX= h.p.( o o.p o.~.<X8.q.(X..h H H #.e.K.T.K #.e h #.K I.E.e.(.K.pX= h.p * V * oX=.( *.(.q.9.p.e o o o.(.q @ h o.( h P * o H H.h PX8 h.(.' # h.p h hXX.T.T @ tX..T t.M.M.M .Xb .Xb t t t t.K @ @.K # H.p.K @.p.eX=Xd.: V V.DX0.:.D.:.~X=.e.E @.M t t t.M.M.MXbX..(.T.(.(.(.(.( HXbXb.M h h.qXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.~.T.p.K.K h H @ t.K.$ T T T TXn T TXM TXn TXM T $ TXM T $XM TXMXn T $ TXMXM TXMXM $ $XM.!XM $XM T $ $ $XM $XMXMX0 $ $ T.QXM $ $XMXM.QXM $ $ $ $ $ $X:.u f H < < < < < < < < <Xq <XqXq <.A <.AX*.cX*.c NX7X&X&.I  .I.n TXMXMXMXM T $ TXM TXnXM $ TXMXn $ TXMX:.R F r TXM 4 M M S.x r r rX> z ].c 3 GXu | T ] |X> Z ; ; vXz.;X: r r r HX> H H H z.c.u G iX: dXMX:X:X:.$ dX: T TX:.$ TX: T TX:X:X:. X:X: T TX:.  TX:.$ TX:X:X: TX:.$X:.$.$X:.$ TX: TX: pX:X:X:X:X:X:X:X:X:.$X: T.$X7.$.$X:X: T.$ |X,X:.$X:.$.$X:X:.$X:.$.$X:X:.$X:X:.$X:.F.F.F.F.F.F &X= oX8.(X8 oXX.(X=X8 H.( o oX8 # o o *.h P o.q.K h.(.(.T h h #X. h H h.'.T.MX..TX..T @.M.vXb.v.vXbXbXbXb q @ @ t.K #.( o oX=.p @.e.e 1Xd *Xd.b.b.b.:.D V.G.f HX= @XbXb t @ @ @ t.T #.T o P.p.' * *.[Xb.[.K H.< o o P.q.( o oXd V &Xd *.h.~ o o.q h *.( h.(X= VXXXd XX=.M.M X.G oX= H.(.K.p.e V VXd.~ VXd * &X= o.r o 1Xd.D &.:.b.:.b.D.D &.:.D.:.:Xd V VXdXd.D.:.D V VXd.~.D V.b.b & &.D V oX8.~ o 1.~.~ o.(.p V V.~.(.p o oX= o o o * *X8 1.T.p.K.K h H @ t.K.K.K H.(.K...K.K.p o.(.p.p.( H o PX= oX8.(X8 oXX.(X=X8 H.( o oX8 # o o *.h P o.q.K h.(.(.T h h #X. h H h.'.T.MX..TX..T @.M.vXb.v.vXbXbXbXb q @ @ t.K #.( o oX=.p @.e.e 1Xd *Xd.b.b.b.:.D V.G.f HX= @XbXb t @ @ @ t.T #.T o P.p.' * *.[Xb.[.K H.< o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O *X. #.p h # h @ # #.$ T T T T T TXn T T T T T T $ TXn T T $ TXM TXM T $ TXMXMXf TXM T $.!XMXM $ $ T $XM $ $XM $XfXM $ $XfXM $ $ $ $X0 $XM $ $ $XMXM n v.>Xq./ < <./ < < < <Xq < <Xq <XqXq.AXq.@ 6 Z.; v N A.I.I.I.IX& $ $XMXM $ $ $ $ T $ $ TXM $XM TXMXnXMXM F.R TXjXn b ( ( r r r r rX> ] ].B.^ G.R T T |.w ].RXz.^ F 7X  7XN.mX>.mXNXNX8 z.c x.k F |X:.yX:X: TX: T d TX: T.$ TX:X: TX:.$X: T.  T TX:X:.A. .$X: TX:X:.$ TX: TX:X:.$X:X:.$ |.$.$ | T ' TX:.$X:X: TX:X:.$X:X:X: pX:X:X:.$X:X:.$X:.$X:X:X:.$X:X:.$X:.$X:X:.$X:X:.$X:X,.F.F.F.F.F.FXd P.pX=.( * oXd.(.(X=.p #.( V.e.h o * * P * o *.# h h.(.( @.T.T t t #.T t tX. H *.M @ t.M.M.vXb.MXbXb.M t t @X... #.(.p o.r o.e.K @ o.D V.b.b.:.bX0.:.D.:.: V.(.f , t t h.(.p.(.( @ #.( o.' hX..p.T t ..v h.K h PXdX= H.K.( *.<Xd oXdXdXd *.(.(.q * & k R R oXd &.D.(.f 1 o @.M.(Xd.(.T.( t.M.p.< V V VX=X=...qX. h * V.~ V VXdXd.:Xd &Xi.b.D.: V.~ V V & V.:.D &.b.:.b.:.D V &.b V.:.:Xd.b V V o.pX= V 1 o.~.4XdXd oXd o o.h.( oX=.( o.(X= *X. #.p h # h @ # #.(.h.K # H @ t t # H.(.(.(.( h h.( P.pX=.( * oXd.(.(X=.p #.( V.e.h o * * P * o *.# h h.(.( @.T.T t t #.T t tX. H *.M @ t.M.M.vXb.MXbXb.M t t @X... #.(.p o.r o.e.K @ o.D V.b.b.:.bX0.:.D.:.: V.(.f , t t h.(.p.(.( @ #.( o.' hX..p.T t ..v h.K h P [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.' # ,X=.'.T.T h #.$ T T T T T T T $ T T TX+ T T T TXnXMXn T $ T $ T $XMXf TXf $ T $XMXfXM $ $ T $XM.! TXM $ $Xf $ $XMX0XM $XM $X0Xf $ $XM $ $ $X0.k 6 8 <./ < < < < <Xq <Xq <XqXqXq <.A <.AXq ; Z.;.c NX7X& g.I.I.I.gXnXf TXM T T $ $ T $ TXM TXMXM.PXM TXM F F T | S ( M SXM r r.x rXN ] Z ; G G.D T T TXMXf.!Xm.X T T T |.; 7 ] D.G ] Z.c x.^.; |X: T.y T TX: T T.  c T.$ T.$ T.$ T.$X: T T. X: T. X:X:.  TX:X: TX:X:X:X:X:X: pX:X:.$X:.$X:X:.$X: pX:.$.$ pX:X:.$X,.$X:.$X:X:XuX:X:X:.$X1X:X:X:.$X,.$X:.$X:X:.$X:.$X1X:X:X,X:X:X:.F.F.F.F.F.FX5.<.pX8.e * o o.(X=.( @.T #.p #.K &.=.# o * o V.q.p.(.( h.T # # # t t.h h *.(.(.9 t.MXb t.v.v.MXbXbXb t.M # tX. @ @ H.K.q 1.qX= V t o.< &X5X5.b.:.b.b.:.D.DX=.p.f ,.. #.(X= H.K.K.p.p H & o.(.( #.p.M.MXb.M.'XXXX P o.(.(.(.< & o.<.~Xd V.~X=.q.=Xd.D.:.< o &Xd XX= t.( o V.T.h.( V.~.(.~ tXb.pX8 oX=.( H.K * &.9 h.( V & 1.D.D.:.DXd.D.D.: XXd.D.~ V.D.D.: V.:.:.:.D.b.:.:.: V.bXd.:.: 1.D.:XdX=X= V.~ 1.~ VXdXd o.~ V 1.qX=.q oX=.p.pX= oX=.' # ,X=.'.T.T h # H H.p HX= h t.e # H h.(.T.( h & &.<.pX8.e * o o.(X=.( @.T #.p #.K &.=.# o * o V.q.p.(.( h.T # # # t t.h h *.(.(.9 t.MXb t.v.v.MXbXbXb t.M # tX. @ @ H.K.q 1.qX= V t o.< &X5X5.b.:.b.b.:.D.DX=.p.f ,.. #.(X= H.K.K.p.p H & o.(.( #.p.M.MXb.M.'XXXX [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.~.p.T @.pX..h.p.K H.$ T T T TXn T T TXn T T $ T $ TXM T TXM TXnXM T $ TXM TXMXfXMXMXnXMXfXM TXM $ T $XM $ $ TXMX0XMXM $ $X0 $ $XMXMX0.A $ $ $ $.; G.c f <./ < < < < < < < < <XqXq <XqXq.A.A.A.A.>.c Z.;.J N A.I.3.I gX+XMXM $XMXnXnXMXMXMXnXM TXM TXM T $XM T F FX: | 4 M M.x r r r r rXN ].c 3 G N.a T.$ T TXM T T.$ T TX: T T 7X0.B.).B n FX0.wX:X:X:X: cX: T TX: r dX:X: TX:.$.$X: T TX:.$ T.  TX: T.$ TX: p T TX:.@X:X: TX:X: T.$X:X:X:X:.$X:.$X:X:XuX:X:.$X:X:X:.$X:X:X, TX:XrX: TX:X: T.$X:X,.$.$X:X:.$X:X,X:X,.$X:X:.$.$X:X:.$.F.F.F.F.F.F.) oX=.p.p.T h.(X=X=.(.E.p q.T @X8 o.T h.<.<XX H PX=.p.9.p.(.(.( H # hXX.(.( h hXX t . ..v .XbXb @ ..M t @.... @ @.p.K 1 o.4 o o.: # V oXd.:.b.< VXd.:.: V.DX=.(.D X I h.h.9 @ #.K h @ H * *X8X8 H.q t.T b . s.( hXX o.q o.(.D &.( oX8 o.< o.z *.(Xd & & o V oX= o.p t *.D 1.K.qX= o 1.~ & H ..( o.( oX= h.< & oX= h s V VXd.~ VXd VXdXd.: V V o VXdXdXd V.D V o.D.DXd &.D.D.:.b &Xd.D.b &.:.b VXdX=Xd V.<Xd VXd VXd 1Xd V 1 o oX= o.(.p o o 1.p.T @.pX..h.p.K H h h H t.T #.M.eX8 h.p.( h @ #.9.< oX=.p.p.T h.(X=X=.(.E.p q.T @X8 o.T h.<.<XX H PX=.p.9.p.(.(.( H # hXX.(.( h hXX t . ..v .XbXb @ ..M t @.... @ @.p.K 1 o.4 o o.: # V oXd.:.b.< VXd.:.: V.DX=.(.D X I h.h.9 @ #.K h @ H * *X8X8 H.q t.T b . s.( h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.G.p #.z.K #X=XX.(.$ T T T T T TXM T TXnXn T T T TXM TXMXnXM T $ TXM T $XMXfXM T $ $XMXf $XM $Xn $ $XMXM $ $ $XfXM $ $XMXfXM $ $ $XM.! $ $XnXm.J.B f.> < < < < zXq < <Xq <XqXq <XqXq.A <XqXqXq 8.t.c.; i N.o.I.I.I.% g.X TXM TXMXn.AXnXM $ T $ T $XM T TXM T.R.R |X: b M b r r rXM r r D Z.c x GXz |Xn T T rX:XM T TX: T.$X: |.g.g.!.P.R.P.PX5.!.!XeXM cX: TX:X: TX:.J rX: TX:.$Xj.aXeXeXeXgXg 0 0.!.n.g.a.$. X:X: T.$X:X:X: TX:X:.$X: TX:X:.$.$X: TX:XrX:X:X:X:.$X:.$X:X: TX:X:X:XuX:X:.$ |.$X:.$X:.$X:.$X:X:.$.$.$X:X,X:X:X:X:.$X:.F.F.F.F.F.F P hXX.T h H IX8 P.p.(.( oX8 t.p *.(.(.(.< o *.p t H hX=.( o.(XX * HX. H t @ t.M.T.v .Xb t # qXb.M @ 1X=.p HX=.e.h H.p.< P.q.K h.D 1 V & V.:.D.D & V P *.D o.~XdXdXd &XdX$ @.(.p @.(.p.p.<X=XX..Xb t h o oXb b s * o.< o V.<Xd.( * o &Xd.<.<X= o & &Xd V oX=.~ V @.T t.r.<.e.K.pX8 o oXd.D o #.pXd.D #.p.p.= o o.~Xd V o 1 & 1.<Xd o 1.:.D.D.:.D.:.b.DXd &Xd.DXd.D &.:.D &.D.D.:.:.:.b.b.b.b.: o oX=.r oXd 1Xd.D.DXd 1 VX= o.~ o.qXd V V.( o o.G.p #.z.K #X=XX.(.p.(.p.p H # #.T.( h H # # h H hX. hXX.T h H IX8 P.p.(.( oX8 t.p *.(.(.(.< o *.p t H hX=.( o.(XX * HX. H t @ t.M.T.v .Xb t # qXb.M @ 1X=.p HX=.e.h H.p.< P.q.K h.D 1 V & V.:.D.D & V P *.D o.~XdXdXd &XdX$ @.(.p @.(.p.p.<X=XX..Xb t h o oXb b s * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=X=.( #.eXXX=.pX=.(.$ T TXn T TXn T T T T TX+XMXn T T T T TXM T $ T $ T TXf.R T T $ TXfXMXMXM T $XM $XfXM $XMXMX0XMXM $XMX0XMXMXM i $X0XMXM.XXzX3 f fXq < < <.>X* 8 <Xq < <XqXqXqXqXqXq.A.AXq.A.A.c.c Z.c N QX&.I.I g g.nXfXnXM TXMXnXM T T $XMXM TXnX+ $ T T.P.PX2 T ( ( 4XM r r H rX> D.}.BXz.JXfXMX: T T T.PX: TX:.a.gXe.nX-XeXeX-Xe.n.n.).n.n.PXeX: cXMX:X:XMX: r.y d T T |.g.!X-.n.n.n.n.n.n.!X5 0 0 d 0X1X:X:X:X: p TX:.$X:Xr.$X:X:.$X:X:.$X:X:X:.  |.$ p.$X:X:.$.$X:X:X:X:X:X:X1 TX:. X:.$.$X:X:X,.$X:.$X: |.$.$X1X:.$.$.$X,X,.F.F.F.F.F.F.&.T hX.X8.( 1 oX8 * h.( o.e # H.T.(.( o *.#.( h.T # P o PX8.(X=X=.q H # hXX t.MX.Xb.vXb.M @Xb t...f 1 I.pX=.e IX= H.(.:.DXdX=.(.:.~.<.DXd V &Xd V &.:.D &.(.< V &.DXd o 1 w.KX=.( sX=.K & PXX @ .Xb o.(.hXn j s R * P.< o * o P.(Xd.< o.DXd oXd.: &Xd.~.p.pX8.e t t H o o.p h.(X=X8.q V.~.< h.q 1X=.( o o.(.h.(X8 V VX= o 1.~ V o VX=Xd.Y.D.:.:.b.:.<XdXd VXd.D &.D.b.:.:.b.:.b V.D.D.:.:.4.b.~X8.E * o VXd 1 X.:.D o o C.~X= o oXdXd V oX=X=X=.( #.eXXX=.pX=.(.K.TXX.(.q.(.p.p.( t.T h H.p h.T #.T hX.X8.( 1 oX8 * h.( o.e # H.T.(.( o *.#.( h.T # P o PX8.(X=X=.q H # hXX t.MX.Xb.vXb.M @Xb t...f 1 I.pX=.e IX= H.(.:.DXdX=.(.:.~.<.DXd V &Xd V &.:.D &.(.< V &.DXd o 1 w.KX=.( sX=.K & PXX @ .Xb o.(.hXn j s R [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.p , h.p H.pX=.q.K.$ T T T T T TX:XM T T T T $ T T $ $ T $ T TXn T T $ $ T.! $ $ T $.R T $ $ $ $ TXM $XMXM $ $Xf $ $ $XMXf $ $XM $XMXfXM.X.uXfX* fXq < < <.@ ZX* 6 <Xq <Xq <XqXqXq.AXq.A.A 8.A.A.> Z.t.cXz N NX&X&.I.%X& $ T T $ TXM T $ TXM TXM T TXM TXMXM F.! | $ M M $ r r r rXMX  ] Z i FXz.R.g 7.g.gXeXOXe.n.nXe.gXe.g.wX2X2X X2 7X2.w.wXz p 7X: cX:X: TX:X: dX:X:X2.)X-Xe.gXO 7 7 7 7.g.w.wXe.).!.P.P d.o.!XkXk.PXgXkXgXkXgXgXk.!Xk.!Xf.nX:X:XMX: 'X:X:.$X:.$X:X:.$.$X:X:X:X:Xr |.$X:.$X:X:.$X:.$X:X,X:.$.$X:X,.$X:X:X:X:X:X:.F.F.F.F.F.F.&.h o.qX= # 1 o.( *.(.(.(.p.p h tX=X=.( o.(.p H.( h.(.~ o o.q.q.<.=X. h.9 h h.9 # tXbXbXb.M @.pX= 1 VX= 1 V X V.~ 1 o.: V V.r.( V.< XXd oXdXd.<.rXd.:.b.D o.:.b.:.D.: 1 V.f t @ H #X8.z.= k o #.MXb h *.<.( B $XX.1 *XdXd o *.( P.D.~ o.<Xd 1.D &.D V V.(X8.p @ @ h.( o oX8.M.( H.( H h...K.p @.e.e o o o #Xb.M h.( o o o.~ VXd.< V o 1.:.DXd VXd.D &.DXdXd.<Xd &.D.:.b.b.:.:.D.D.:.:.D.:.b.:Xd.e.p 1Xd.~Xd o oXd.~.( oXd 1X=X= o o VXd 1X=X=.p , h.p H.pX=.q.K.p.K.( I.(X= # H h #.M.T.h h t.p #.h o.qX= # 1 o.( *.(.(.(.p.p h tX=X=.( o.(.p H.( h.(.~ o o.q.q.<.=X. h.9 h h.9 # tXbXbXb.M @.pX= 1 VX= 1 V X V.~ 1 o.: V V.r.( V.< XXd oXdXd.<.rXd.:.b.D o.:.b.:.D.: 1 V.f t @ H #X8.z.= k o #.MXb h *.<.( B $XX [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX= H.p # #.p.p H.p #.$ T T T T T T T T $X: T T T TXM T T T T $ T $ T T T $ TXfXM T $ TXfXMXM TXn T $ $XMXM $XMXMXf $XMXM $ i $XM $XM.AX0XM.u v 6 f 8 < < < 8 Z f fX* 8Xq <XqXqXqXq <.A.AXqXq.A H.A.A.t.c.c.t N.oX&X&.I gX&.g $ $ T $XMXM T $XM TXMXn $ T T TX:.!.wX2Xn ( (.x r r.x r HXN ].cX0 iX0.n.!.n.n.n.n.n.g.gX2.gX2X2 |X2 | | | DX X2XN i.J G | T.J T TX: T T.yX:XeXeXO 7X2X2.aX2 |X2.a D 7.w.w.wXeXeX0X5.PX5.!.!X5.!XgXgXgXg.!XgXgXfXgXg 0.$X:X:X: pX:X:X:X:.$X:X:X:X:.$.$X:X:X:Xu.$X:X:X:.$X:X,X:X:X:X:X,X:X:.$X:X:X:X:.$X,X,.F.F.F.F.F.F.&.' hX..p.( H # o o P.( * o.( #.p o oX= #.pX=.(XXX8 o.(.p oX8.< oXX t.TX. # t.M.T.( t.M t V.~ o X.: 1X=.( 1 1 X.D V V o.<.D V 1.(.( V &.DXd.DXdXd.D.D.D V o.: V.b.b.4 V V.r.e @Xb @ @ H.(.p.(X..( o h o.( oXX.9XX o P P.# P * V.< &Xd & oX= k.DXd 1 &.< oXdXd.< o.~ o o.< * # h H.( RX= t t.K.pX= h h.p.e @ @.p VX=X=.(.h h o oXd o o o.D.:.D VXdXd.D.:.D.b & &.b.DXd.b.b V V.:.:.:.D o.D.D.:XdX= C V &.D V V V & V o o.~.~Xd 1 o o 1.q oX=X= H.p # #.p.p H.p #.qX=.p.q.e @ #.T t tX.X. h H hX. #.' hX..p.( H # o o P.( * o.( #.p o oX= #.pX=.(XXX8 o.(.p oX8.< oXX t.TX. # t.M.T.( t.M t V.~ o X.: 1X=.( 1 1 X.D V V o.<.D V 1.(.( V &.DXd.DXdXd.D.D.D V o.: V.b.b.4 V V.r.e @Xb @ @ H.(.p.(X..( o h o.( oXX.9XX [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX= #.E.p #.p.K.E.p.E.$ T T T T TXn T T T TXMX+ $ T T TXMXnXM TXn T TXMXn $.R TXMXnXMXMXfXM T $XMXM $ TXfXM $ T $XfXM $ $XMXf $ $XM i $XfXf 9 6 f.m < < < 8X* f.tX* f f <Xq.A <XqXq.A <Xq.A.A.A.A 8.AX*.c.c.c.^X7Xp g.%.I +X1Xn TXM TXM T $ TXM T $ TXM.P |XO.wX2X2X: T M YXM r r r r r D ].;.wX2.wX2X2XO 7 7 7X2X2X2 | | | |X: | | | | |XN | ] 3 G FX:Xz TX:X:.$ TX: 0.wXOX2X2 |Xj | | | D |X X  D D D.w.w.w.;.).).)XeXeXeXeXeXeXeXeXe.)XeXe.) d 9X:X:X:X:XuX:XrX:.$X:X:.$X:X,X:X: TX: TX1X:X1X:X:X,.$.$X:X:.$X:.$X,X:.$X1X:X,.$ |.$X:.F.F.F.F.F.F P.K h H.p h.( t.( kXX P o o.(X8X= V o.(.pX8.pX= P o o *.( HX.Xb # H.T #.K h @X. H h @Xb h 1.r.4 V V 1.(X= V.~ V V &.< o.~Xd V.D.e.(Xd.D &.<Xd.D V V.:.:.DXd.D.D.:.:.: VXd.f.K #.p # @ @ t @ # h * o.= P o P * hXX oX8.1XX.# h hXd * *.<.( * oXdXd.< V o * V V V.r oX= *.XXX t.p o.DX8.h.. @.KX.X=.q.(.T #.T.pX= VX= *X. h *XX o V VXd oXd.D V V.D &.D.:.b.:.:.D.DXd V.DXdXd & VXd.:.D & &Xd o V.q 1.D.:.: VXd.D.D VXd.~ V V VXd o.~ o 1.~ oX= #.E.p #.p.K.E.p.E hX=X8.p.p.E h t h.M.M t h h #.TX..K h H.p h.( t.( kXX P o o.(X8X= V o.(.pX8.pX= P o o *.( HX.Xb # H.T #.K h @X. H h @Xb h 1.r.4 V V 1.(X= V.~ V V &.< o.~Xd V.D.e.(Xd.D &.<Xd.D V V.:.:.DXd.D.D.:.:.: VXd.f.K #.p # @ @ t @ # h * o.= P o P * hXX [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.p.p.K #.K H @ @.T T.$ T T T T T T T T T T T TXM TXM T T TXMXM T $ TXM TXf TXM TXM TXfXMXM $ T $XM $ $ $XM $XMXf $XMXM $Xf $XM $XMXM 9 G.; fX8 < < < <X* f ; G Z 6X*XqXqXqXq.AXq.A.A.A.AXqXq.A 8 8.A n.c.tX3 Q.oX& g g.IX&.XXnXM $ T $ TXM $ $ TX:.a.g 7X2 | |X:X: T ( Y r r r r r r D Z D | | | |X  | | |X2 | |X: |X: | T | rX>X> r |X> D.; F.J.R T c.$ T TX:X:X2XeX2X2X:X: | | | | | | D |X  |X  D D 7.w.w.;.; 7.w 7 7.w 7.w.w 7.w.w.w.w.R p -X:.$X: TX:X:X:X:.$X:X:X:X: TX:X,.$X:X:X: pX:X:.$X:X:X:.$X:X:X:X:X:X:X:.$X:.$X:.$X:X:.F.F.F.F.F.FX  #.K.( P.(XX h P o o P * P *.p H.< * #X=X=.(.( oXd * oX=.e.p.M t H h t t @ t h.(.(.T.M.( oX8 V.: V I o.q.rX=X= V 1 o.( V V.:.: V o.: VXd *Xd.D.~ V.D.: o.: X V.D.4.D & V oXX 1 X.E h @ t.. t.(.' h * o.< P oX..# h t.M.M.MXbXbXX.9 h h.(.(.p &.< & P.q o.< & V.q.(.( s R H.T oX= V 1.GX..E @ @ t #X=.p o #X=.r.(.(.p h.( oXd V VXd.D V o &XdXd V.<.:.:.:.:.:.:.:.D & &Xd o VXd oXdXdXd.D V oX=.p.~.:.D.:.:.D V.D V V 1 X V V V.~X=X= o o 1X=.p.p.K #.K H @ @.T.p.qX= #.T.p @ h.( t.T t.T # t t.T #.K.( P.(XX h P o o P * P *.p H.< * #X=X=.(.( oXd * oX=.e.p.M t H h t t @ t h.(.(.T.M.( oX8 V.: V I o.q.rX=X= V 1 o.( V V.:.: V o.: VXd *Xd.D.~ V.D.: o.: X V.D.4.D & V oXX 1 X.E h @ t.. t.(.' h * o.< P oX..# [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.p # HX. #.p.p h # T T T T T T TXM T T T T T TXM T T TXM TXM TXMXM T $ T.RXM TXM TXfXMXM TXM $ T $XMXM TXMXMXMXf $XM $XMX0 $ T $ $.}.k.t f z < < < < <X* Z.k G nX*X*.>Xq <.A <Xq.A.A.AXq.A 8.A 8.A 8.c.t.t.c NX7X&X&X&.I.I.n T TXMXM T $XM TXMXMXjXjX2X: |X: T r r T S $.x r.x r rX>XN |X>X> |X> | | | | | | | rX>X: rX> rX>X>X>X>X>X>X> ].; v.JX0 r c TX:X: TXOXOX2 |X:X: | T |X>X> DX>XN |XNXN | D | | D D.w.w D 7 D D 7 D 7 D.w.w D.wX0 9 ' 9X:X:X:X:X: rX:X:X:X:X:X:X:X:.$X:X:X:X:.$ 'X: TX:X:X:X:X:X:X:.$X:.$X:X:X:.$X:X:X:X: |.F.F.F.F.F.FXd h h.p.(.9.p o.( R k *XX./ P.(.p h.T.E I.q o o.q h.K.p H ,.K I.K.pX8 h h.p.( #XX.r.p.K V o.(X= oX8.~Xd V.h.(X= VX8.q o.(XX V.DXdX8.<.:.D.: oXd.DXd V oX8Xd o.D o o V o R R.e # @ # @.K.p.e.KXX o.( h.( V.< *Xd.9 h t.# H.T./.6 s R o.( o H * oX=.qXd o o P o.~.<.(.~ h.(X= VXd 1 X V.~ t t.M.M.. @.... @.(.q * t tXb o o o.<Xd V.:.: VXdXd.D V &.:.b.:.D.:.:.bXd.:.: oXX.D.D.:.:.< * oX=.p CX=.(.~ V.:.:.: V.DXd k o 1 V.~X= I.p.~ 1X=X=.pX=.p # HX. #.p.p h #.p I.(.p.p.q # H.# H.(.(X. H H.(.( h h.p.(.9.p o.( R k *XX./ P.(.p h.T.E I.q o o.q h.K.p H ,.K I.K.pX8 h h.p.( #XX.r.p.K V o.(X= oX8.~Xd V.h.(X= VX8.q o.(XX V.DXdX8.<.:.D.: oXd.DXd V oX8Xd o.D o o V o R R.e # @ # @.K.p.e.KXX o.( h.( V.< *Xd.9 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.CX= @ # O #.p #.p HX: 0 T T 0 T TX+ T TX+ TX+ T TX+XM TX+XMXnX+ $ TX+XM.R.PXMXMXMXM.RXMXMXf T $Xf TXMXfXM $Xf $Xf nXMXfXMXfXf $ $ 9.kX0 f zXq < < < <.> Z.^.^ G G f 6 ZXq.A.A.A.AXq.AXq.A.A.A 8.A 8.A.>.c.c.tXz N.o.%.{.7.I g $XfXM.RXMXMX+XMXMX+ |X:XMX:XMXM rXn S.x.x r r r r r r rX> r rX:X>X>X> rX> r |X> rX>X:X> r r | rX>X>X>X>X>X> ] ZXz GX2X: c T T.yX2 7XjX: T r r r r | DXNX>X XN | z DXNXNXNXN DXNXN ]XNX X  D D D D | D D D.;X3 F N -X:. X:X: p ' p T |. X:X:XrX:X:X1X:X: pX: TX1X:X1X:X:XrX:X:X1.$X:X1X:.$X7.$X:Xr.$X:X:.F.F.F.F.F.FX  O.# * *X. # o * o o.<XdX. * o.p.K.p.e.G.e h P.( h.p.K h.E ,.K H.p.p #.p.p.( H h.( h h o V.D oX= * o.< o o.~X= P o.(Xd o.(.<Xd.D V *Xd.:.4.<.<Xd oXdXd o.4 V &Xd o o.X.(.p oX=.f #.K , #X=X=.( *.( s.(.< o.<Xd # t./.(X..p @.' j.#.( *.p.# o * o.< oX= * * oXd V o.r.p @.( o o.~ VXdX= t.MXb.E.(.e I.G.G h t t.e @.M s h o.(.< &.D.DXdXd.D.: V &.D.:.DXd.b.:.bXd.D.:.2XX R.D.D V VXd V V.~X=X=X= oXd.DXd.bXd.D V VXdX= 1 VX8.K.pX= 1 C o.z.EX= @ # O #.p #.p H h.e.E.( h.9 h.q.(X. # # # h t #.T O.# * *X. # o * o o.<XdX. * o.p.K.p.e.G.e h P.( h.p.K h.E ,.K H.p.p #.p.p.( H h.( h h o V.D oX= * o.< o o.~X= P o.(Xd o.(.<Xd.D V *Xd.:.4.<.<Xd oXdXd o.4 V &Xd o o.X.(.p oX=.f #.K , #X=X=.( *.( s.(.< o.<Xd # [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX>X=.z.p h.# t I.p.q.$ T T TXn T T T T T T T TXM T T $ TXM T T TXM TXM T.PXM TXM T $.P $ TXM $ T $XMXMXMXMXMXMXM.! T $XMXM iXM $.X 9X3 fX* H < < < <.> 6.u G N N.k.t 6X*.@Xq <Xq.AXq.A.A 8XqXq 8.A 8 8.A x.t.t.B N.o g g.I.I g.g TXM TXM T $ TXM TX2X: S SXM S S $.x r r r r r.x r r r r r r r r r r r | r r r rX> rX>X> rX>X>X>X>X>X>X>X> Z.B.J.J | c TX:.$.aXO |X: T rXM T r |XN.mXNXNXNXNXN HXNXNXN D |X> DXN DXN D D | DXN D D D D D.;X3 F GXzX:X:X:X: T. X: T TX:X:X:X:X:.$X: TX:.$.$X:.$ pX: TX:X:X:X:.$X:X:.$.$X:X:X:X,X:X,.$X,.F.F.F.F.F.F k hXX P o @ H.(.< *.< o P.( o o * @.p oXd.( h *X8X= H.p.K.p.K.p.(.pX=.(.(X=.p.p.TX. H H 1.~Xd.~ V V * *.~ o.(X=.h #.E VXd.D.< VXd.DX8 2 V VXdXd V.rXd.D.DXd VXd.D V VXd 1X= 1X8X=.q.p.p @ o.~.( o o.(XX.D *.<.(.'.M s P h h hX= H $ R.(.p.(.(XX o.qXd.p.9 o oX8XdXd.~.(.p h # O o oX=.q t t.M.9.(.( o XXdX8 t @ tX..M.MXXX8 k * s *.~ V &.< &.D.~Xd & V &.b.D.b.D.:.D V.D o.: oXd.~ V V.: V o o o.~.<Xd V.:.:.DXdXd V.~.e.pX8.. IX=.~ o oX= HX=.z.p h.# t I.p.q h h H #.(.(.M.T.M @ @ t.p.TXb.T h hXX P o @ H.(.< *.< o P.( o o * @.p oXd.( h *X8X= H.p.K.p.K.p.(.pX=.(.(X=.p.p.TX. H H 1.~Xd.~ V V * *.~ o.(X=.h #.E VXd.D.< VXd.DX8 2 V VXdXd V.rXd.D.DXd VXd.D V VXd 1X= 1X8X=.q.p.p @ o.~.( o o.(XX.D *.<.(.' [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.p o V.( #.p I.p.(.$.$ T T T T T TX,XfXgXgX1XgXgXgXgXgXgXgXgXgXgXgXgXgXrXrXgXgXgXgXrXgXgXgXgXgXgXgXgXrXgXgXg.!XrXgXgXg.! pXfXzXz 6 f 8 < < <Xq.A ZX*.t.J N.8.8X7.k.t Z 6X8Xq.AXq.AXq 8.A.A 8 8.A 8 8 8X8.t.t.BX3 N Q.I.IXa g g -XgXgXgXgXgXgXgX5.g T.x S b S.x.x r.x r r.x r r r r r r r r r r r rX> r rX> r rX>X> rX> rX>X>X>X>.mX>X>XN.;.B G '.P.o.PXgXeX2 T T S b S r |XNX>X XN.m z H H H HX8XNX> rXN |XNXN DXNXN D D z zXN z ] z ] Z 3 v G.oXfXg.P.PXg.P =.PXg.P.P.PXg.PXg.PXg.PXg.PXg }.PXg.P.P.P.P.PXg.P.P.P.P.P u.P.P.P.P.P.P.F.F.F.F.F.F %.(.(Xd.<.# h.( h PXX V.D V.< o o.K.pX=.(.(.p.~ o.f.T V.p.p.(X=.pX=X8 H H.(.KX= o.p.p.( o V.DXdXd &Xd o.( P h @.p.p.h.(.KX8X=XdXd.~ VXd V.~.<XdXd V V.: &.:.D V R o.D V o.q.T #.K s.p.. t.pX= H.< P * o.D.<.( PX..# P * o.( tX. o PX: sX.Xb j.( h h o.(.pXd & oXd P o H # h H.e #.(.(.G.e.K.KXd.DXdXd o V.(.h.(.K @.M.G.(XX o o.<.: VXd &.:.bXd V &.D.:.b.D.b.:.D 1 oXd V.~.:.b.: k R &.D V V.~.~ oXdXd.D.< *.< VXdXd k P *X=.p H.qX= 1X=.pX=.p o V.( #.p I.p.(.p.q.(Xb @.M t.T.(.T h.#.pX..M h.9.(.(Xd.<.# h.( h PXX V.D V.< o o.K.pX=.(.(.p.~ o.f.T V.p.p.(X=.pX=X8 H H.(.KX= o.p.p.( o V.DXdXd &Xd o.( P h @.p.p.h.(.KX8X=XdXd.~ VXd V.~.<XdXd V V.: &.:.D V R o.D V o.q.T #.K s.p.. t.pX= H.< P * o.D.<.( PX. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.pX=.q.q h #X8X=.p.$ T T TXM T T T.gX1XrXrXrXrXrXrXrX1.FX1XrXrXrXrX1.oX1XrXrXrXr }XrXrXrXrXrXrXrXrX1XrXrXrXr uXrXrXrX1Xr p p 9 ZX*.@ <Xq <.AXq 6X*.t.^ N.N.8.N.8.JXf Z 6 f.AXq.A 8.A.A 8 8 8.A 8 8 8 8 8.t.t.t.t N Q g.I.I.I.% AXrX1XrX1X1XrXrX1X-X: S S (.x r r r r r r r r.x r r r r r rX> r r rX> rX> r fX>.m H.mX>X>.mX> rX>X>X>.m z.c.B G QX7.oX1 dXO T T Y ( b SX>X>.m |.mXN z.G.G.G.c Z zXN H r rXNXN DXN DXN z HX> H H H H H H zX3 F G.oX1X1XrX1X1Xr uX1X1X1XrX1X1X1XrXrX1X1X1X1X1X1XrX1X1XrX1X1 u.7Xp y u yX1X1X1 =X1X1XrX1.F.F.F.F.F.F P h.( V k o PXX.( o.(.:XdXdXd.< o H t t.K.p.pX=X8.e o o.K o 1 PX8.e I H I.p.KX8.p H.T.(.(Xd.D V.< V.D.D.~ OX..( # H.( o.p #XX V * V.DXd V o o 1Xd.DXd V &XdXd.D.b.D & *.DXd.q H @ @ @ t @ @.. # &.D P.( *Xd o k H.h * PXd.=.M H.(.p.(.( hX. * o * *.(.( oXd.<Xd.D.~ o.p t.M hXX o #.p o 1.K.q 2Xd V.D V.q.T.p.~ h h @.~.( H s *.D V & V V.:.DXd V VXd.D.D.:.D &.:.DXdXd o *.:.4.: P mXdXd V oX8 o.D V.D &.D oXd.: &.<X: R *.q C.E I.q X.e.q.~.pX=.q.q h #X8X=.p.z I #.M t.M t # H.( # h.' t.MX. t h.( V k o PXX.( o.(.:XdXdXd.< o H t t.K.p.pX=X8.e o o.K o 1 PX8.e I H I.p.KX8.p H.T.(.(Xd.D V.< V.D.D.~ OX..( # H.( o.p #XX V * V.DXd V o o 1Xd.DXd V &XdXd.D.b.D & *.DXd.q H @ @ @ t @ @.. # &.D P.( *Xd o k H [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.p.~X=X=.(.'X8.qX=.$.$ T T T T T TXgXrX1Xr =XrXrXrXrXrX1XrXrXrXrXrX1.oXrX1XrXrXr.oXrXrX1XrXrXrX1XrXrXrXrXrX1X7X1XrX1. X1. .J.t f.@Xq < < < <X* 6.c x.^.8.8Xw.8.8Xu G 6 Z.c 8Xq 8Xq 8.A 8.A 8 8 8 8 8 8 8 f.t.t.B.^ Q.o g.IX&.IXpX1XrX1XrX7X1X1XrX-X: $ S b.x r r rX> r r.x r r rX>XN.mX>.mX>.m.mX> H.mX>.m.m ].mXNX>XM b.A r.mX> 8X>X> ].c i G N NX1X1X-X2X: 4 ( M b rXN.mXNXNXN z ] Z.c ; x ; ]X> r.x rX>XNXN DXN D DX> H H H H H H H H Z v G.oX1X1X1X1X1X1 u.+X1X1X1X1X1X1 =.+XrX1X1X1X1X1.o A.+X1X1X1XpX1 u QX1 +X1X1X1Xr.+X1.+X1.F.F.F.F.F.F k #.(Xd V.h o.< H *.( V V V P P.(.p H...e.T.K H.E.e.(.E.KX8.(.p *.p H.K h...( H h o o oXd.< V.DXd V oXdXd.q k * #.q.p o.r #.(.(.p oXd.D V 1.~Xd VXd oXd V.<.rXd.:.: &.~.< oX8.p @ @ t t.K #.K h &Xd.<.( h.2 l.b o H.(XX P.q t t h.K h *.(Xd o &.2.D.<X= *.D V V.<XdXd t.T t t H.p o.GX=.~.< V.~ V.D.~ o.K hX=.( h h.p o.(XX h h & V V oXd.DXd &.DXd &.: &.D X V &.b.:.:.D &.D.b.:Xi.b.D &.: V.K.~Xd.b.: & &.D &.b &Xd R * o.K.e IX8 ,X= #.pX=.p.~X=X=.(.'X8.qX=.p.p tX. t t *.p.MX. #X. @.M t.( h #.(Xd V.h o.< H *.( V V V P P.(.p H...e.T.K H.E.e.(.E.KX8.(.p *.p H.K h...( H h o o oXd.< V.DXd V oXdXd.q k * #.q.p o.r #.(.(.p oXd.D V 1.~Xd VXd oXd V.<.rXd.:.: &.~.< oX8.p @ @ t t.K #.K h &Xd.<.( h.2 l.b o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O K.h o o o.( #X= o o.$ T.$ T T T TXjXr =XkXf.!.!.!XfXfXf.nXf.nXf.nX0.nX0.).!.).)X0.n.).n.D.nX0.n.DX0.D.n.).D.).).D.)Xe.n. Xu.c.}X8Xq <Xq.A < f 6X*.u G N.8.8.N.8.PX0.k n 6 Z f 8Xq 8 8.A 8 8 8 8 8 8 8 8.@ 8.u.t.t.Q NX7X&.7XhX&.P.nXf.nXf.n n.!.!.wX: S.x rX>X>X>X> b r.x r r H r.m ]XNXNXNXNXNXNXNXNXN zX8X8 f ]X  S ( MX>X>X>X>X>X>.mX*.c i GX+ -.P.P.g TXM b M M.x |.mXNX>XNXN Z.c ; x.^ G v.w r.x.x.x.x DXN | DXN D.B.cX* z.G.G.G.G.G z.B GX7 - - - - 0.y.y d - - -.y - - - -.y - d - d c.y -. .y -.y. . . .y. . .y.  d d.FX1X1X1.F.F.F.F.F.F.D *.D o oXd.#.(.(.( h &Xd V s t h t.p h t #.( # HX=.p.E.K.p.pX= oX= #.p.K #.( o.pXd VXd V 1Xd.DXd V.D.: & o o o oXdX8.(X= o V.(.q H o o o oXd oXd &.DXd.D &.D.:.D VXdXdXd 1X=X8.K.p h #.( o H hX. h P V h.T.MX. H.T HX.X. t t t t R.6 $.( P.(.D & oXd.<XdXd.D & V V o.pX8.K t.K h.(X=X= t #.( * * PX=Xd o.K.K.eX= 1.<X= o.( o.<Xd.(.~ oXd.DXdXd V o.:.:.D VXd V &.DXd VXdXd V V.D.: V X V 1Xd.<.<.D & &.D.D.w P *XX.( VXdXd #X.X. o H.E.p.eX8.h o o o.( #X= o o.p.p.M P.K @.(.(XX.T # t t.T HXX.= *.D o oXd.#.(.(.( h &Xd V s t h t.p h t #.( # HX=.p.E.K.p.pX= oX= #.p.K #.( o.pXd VXd V 1Xd.DXd V.D.: & o o o oXdX8.(X= o V.(.q H o o o oXd oXd &.DXd.D &.D.:.D VXdXdXd 1X=X8.K.p h #.( o H hX. h P V h.T.MX. H [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.pX=.~X=X=.p.(XdX8.$.$ T T T T T.nXr 0XmXm 7.aXm.a.a.aXm.aX .a f.a 7X .aX X X X .X.X.X.X.X.X.X.X |.X.@.@ |.@ |.@ | |X0.J.QX* f.A <Xq < <.>.cX* n G.k.8.8Xw.NXz.X.@.u.^.c.c Z 8 8Xq 8.A 8 8 8 8 8 8.@ 8 8 8 6.t.t.t.J QXwX&.I.I -XmXm.aXmXmXm D.wX2X:XM rXNXN D |.x ( r r r r r rXN ].c ] z z ] z ].G ] z ] z ].;X> M M (X>X>X>X>X>X>.m.;.cX3 GX0X0.!.)X2 T.6 M ( ( |X>XNXN |XN | Z ; x.k G F iX2 rXM S S.xXNXN DXN |XN.cX3 v 3.;.c.c.c.c.c.c vXu.R.!.R.R.R.R.R F.R.R.R.R.P.R.R.R F.R F F F.RX+ FX+.RX+.R.R.R FX+.R FX+.R.P.P.y.+X1Xg.F.F.F.F.F.FXd H.( H.(.(.( *.(XX.# * HX8X.X. H.K.' h @ @.KX=X=.pX= * h IX=.q.qX8 #X8.E.M o &XdXdXd.D.D o V & oXd.:.:.bXdXd V o o o.(.q oXd o o t.T o 1 o.~.(Xd V &.<Xd.D.:.:.:.: V o oX= o o oX8.p.# o.( h.#.( *.<Xd H H @.M #.(.T.T./.M tXbXb hXn $ o o.( V V o.D.DXd *.:.DXdXdX= H.pX= @ t t o oX= t.p.(X8.( o 2.D.(.h o o.( * o.(.(.(.(.~.DX= o o o 1Xd V.~.~.:.D V.:.:.b VXd.< VXd V o V X.:.4.4.: V oXX oXd P P k *.(.q V V.DXd V V tXb.MX= h #.EX=X=.pX=.~X=X=.p.(XdX8.(.` t h h.p.(.( h h # t tX. h.(XX H.( H.(.(.( *.(XX.# * HX8X.X. H.K.' h @ @.KX=X=.pX= * h IX=.q.qX8 #X8.E.M o &XdXdXd.D.D o V & oXd.:.:.bXdXd V o o o.(.q oXd o o t.T o 1 o.~.(Xd V &.<Xd.D.:.:.:.: V o oX= o o oX8.p.# o.( h.#.( *.<Xd H H @.M # [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.(.p o.(.< oX= #.(.(.$ T.$ T T T.$ 0X1Xf.aXmXmXmXmXm fXmX XmXmX .aX X X X X .aX X X .@X .@.@.@.@.@.@ |.@ |.@ |.@.@ |.D.k n f fXqXqXq <.A.@ 6 6 ;.k G N.8.8.N.8.w | |.} G.t.c.c z.A 8 8 8.A 8 8 8 8 8 8 8.@ 8 f ;.Q.t.RX7.o.% gX& g fXmX XmXmXm.} ].a r |.w ] ] ] r Y (XM r r r r rX X*.c 3 ;.B.c.B.c.c.B.B.B.B.; D S M M bX> 8X> r.mX>XN.;.c 3.^ iX0X0.gX: $ b M M S |.mXNXNX>XN D ;X3.^ G x iX0X2X:XM S Y.xXN |XN D DXN.c ; v G.^ 3 3 3 3 3X3 F.J i F.R.R.R.R.R.R F.R F.R F.R F.R F.R F.R.R F.R.R vXz F F F.R F F F F.RX+.R.PX1X1.+.g.F.F.F.F.F.F k.(.( h H t # H o V o o * o.T h.( h #.K.p.(X8.(.p.pX8.(.p H.(.e.p.(.p H.E.TXd.D.:.D V V.:Xd.< V o V.b.: V VXd.< o.( o o o VXd V o # @.p.< V V o.: VXd *Xd &.D.:.D.:.r VXd.<.~ o.(.(.(XX h H.( R &.b &.<.( t # qXX.( h *.(.p tXb.M.M $.6.h P.(.~.< &.<.< o oXd &XdXd VX= o 1 # @.T *.r oX..pX= o o.< o.D h.p o &.E #X=.( P o oXd V o 1 V V oXd oXd V V.: VXdXd VXd * &Xd.<Xd.~.<Xd VXd V V oXd.(.p o hX..( o o.D.: X.DXd o.~ hXb ..p.q o.p H.(.p o.(.< oX= #.(.( o o t.(.p.p.(XX.T.p h.pX. h H.( h.(.( h H t # H o V o o * o.T h.( h #.K.p.(X8.(.p.pX8.(.p H.(.e.p.(.p H.E.TXd.D.:.D V V.:Xd.< V o V.b.: V VXd.< o.( o o o VXd V o # @.p.< V V o.: VXd *Xd &.D.:.D.:.r VXd.<.~ o.(.(.(XX h H.( R &.b &.<.( t # qXX [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.q o oXd.( * * o.<.<X: T T T T T.gXrXr.g.DXm.}XmXmXmXmXm.a f.aXm.>XmXm.>.aX X X X X .XX  |X .@ |.@ |.@.@.@ |.@.@ |.@.^.u 6 f 8Xq <.AXqXq.cX*.t.^ G N.8.N.8.8.; |.@.@.@ G.u Z.c.c 8 8.A 8 8 8 8 8 8 8 8.@ 8.@ 8.t.t.B n NX7 gX& gX& 7 fXm.} f f.w D.w 7X0 i iX0X  $ S M r r r.x r r D ] Z v G.^ v v v.^ v vXz F.w r 4 M M 4X>X>X>X>X>.m D Z ;.^Xz.Q iX0X2 TXn M M MX>X>.m |XNX>XN Z ; v G.^ i.!X0X2X: $ ( ( S |XN DXNXN D.c ; F G GX3 v.^ v v.^ v.^.R.R.RXf.R.R.R.R F.R.R.R.R.R.R.R.R F.R F.R 9.R.R.R 9.R.u FX+.u F.R F.RXz.P -X1.+X1Xj.F.F.F.F.F.F %.p.K...p o.q H *.(.(.(X= o.G # HX= h.pX= * *.e o.(.E H.zX=X8X= o.( I #.p.EXd.D.:.q.(Xd X &.< X.D.:.D.:.: o.~.~ oXd.(./.( 1Xd.~ h o oX=.TXXXd o o.:.D.:.<Xd.b.: V o.(Xd o.D o * oXdXd o o V V k & & lXd.M tXX.9.(XX * P.< @ t.M t.M.(.(.<.< *.( oX= o oX= *.q.<.D &.<.~.~ o.(X=.T O V V , HX= o.~ 1.<Xd.M t o o o o.( o &.<.(X8 s 1 &Xd.~ VXd & &.D.b.D &.~Xd.<.~XdXd VXd * o * o R.# R * o.<.q.r.~Xd.DXd.:.:.b.: &.D.D V *.( . . # I.~Xd P.q o oXd.( * * o.<.<.:Xd H 1.( h.TX..( # h.p.(.( o.(.9.p.K...p o.q H *.(.(.(X= o.G # HX= h.pX= * *.e o.(.E H.zX=X8X= o.( I #.p.EXd.D.:.q.(Xd X &.< X.D.:.D.:.: o.~.~ oXd.(./.( 1Xd.~ h o oX=.TXXXd o o.:.D.:.<Xd.b.: V o.(Xd o.D o * oXdXd o o V V k & & lXd.M tXX.9.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&XdXd P * V.D * & & T.$ T T.$XnXfX1X+Xm.}.}XmXmXmXm 7 fXm.a f.aXmX .a f.a.>.aX X X .XX .@X .@X .@.@ |X .@.@ | |.@Xm.u 6 6 8Xq.A.A < 8 6 Z Z x G N.8.8.N.8Xf |.@ r.X.@X0 G.;.c.cX8 8 8 8.A 8 8.@ 8.@ 8.@ 8.@ 8.c.t.t.QXzX7 A g.% g fXm ]XmXm.} ].}X0 F.RX3 i.; rXn Y M r r r r r r z Z.B v G.^.;.;.;.;.;.t.;.) |Xn b ( MXMX>X>.mX>.mX> ].c ;Xz x iX0X0 | T 4 M M b |X>X .mXNXNXN Z 3 G G.R iXf.)X2 r $ ( M YXNXN DXNXN D.c i v G G i.R i.u.RX3.R i.RXf.R.R.R.R.R.R.R F.R.R.R F.R F.R.R F.R F.R F.R F.u 9 F.u.R F F F 9.R F.R. X7X1.+X:.F.F.F.F.F.FXd.( @ @.K *.(.K o P.( 1.q oX= #X8.pXX.(X=.< *X= h.K.e.( I.p.pX=.p.( H H.(.( o.D.:.( *.: VXd o &.D.D.D.D.: oXd oXd oX= # h.(X=X= o &XdX= @ H 1 V.q.<.:.4.~XdXd V o oX=.4 V o oX=.~.b &XdXX.1 kXd.X & V h @.p o VX..( PXXX=.TXbX. t.M o.p &.D &Xd o.~ &XdX=X=X= o.D.D.D oXd & V V # # oXd h h.h VXd.q.~.(Xb.p.(X=X=X8.p h.p &.(.h.# o.DXd V V.D.:.DXd & &.DXd VXdXd.< o VXd VXd k VXd V.< o.D X o o.< *XdXdXd.D.D.: &.: & V.DXd s.M.K.z VXd o oXdXd P * V.D * & &.DXd H.( H.9 h.p h h.( H.( o *.(.(.( @ @.K *.(.K o P.( 1.q oX= #X8.pXX.(X=.< *X= h.K.e.( I.p.pX=.p.( H H.(.( o.D.:.( *.: VXd o &.D.D.D.D.: oXd oXd oX= # h.(X=X= o &XdX= @ H 1 V.q.<.:.4.~XdXd V o oX=.4 V o oX=.~.b &XdXX.1 kXd.X & V h @.p o VX. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O *.< V *.D VXd.<.<Xd.$ T T T.$XjX1Xr.n.wXm.}XmXmXmXmXm 7 fXmXm fXmXm f.aX XmX .>XmX .XX .XX .X.XX .@.@.@ |.@.@.X f 9.c 6 8 <.A <XqXqX* Z 6 x G G.8.8.NXwX+X .@.@.@.@.@ ].J ;.t.c 6.A 8 8 8 8 8 8 8 8 8 8.> 8.@ 8 v.t.B n N.oX&.I gX0Xm fXm f ]Xm ]Xm.}.w.;.wX2 r $ b M r.x r r HX> D Z.B.^ G.^.D.;.tX0.tX0.).w | $ b M MX>X>X>X> HX>X>X*.c ;.^X3 iX0X0X2Xn Y M M S.m.mXNX>.mX>X .c x G.^X3 i iXeX2 TXn M M SXN |XN DXNXN.cX3 v G G.RXf.RX3.RX3X3 FXfX3.RX3Xf.R.R.R.R FX3.R F.R.R.R.R F.R F.u.R F F.R F v F F F.R F.u F F.R -X1X1.+X1X:.F.F.F.F.F.F.< h.p I h oX8X=.(.9.(X8.p.p.K.p.(.p H.p V VXd.( #.p.p.p.e H.pX8.(.(.p.(X8.(.(.D.D V oXd.b VXd.<Xd.: &Xd V P o * V oX=.p I h o.~ o V.< o.K #.( oX=Xd V VXd.<Xd V V o o P.~X= o V VX0.:.b.<XX R.2 s m.( #X= # oXd H t.(.9 t.M ..M t h o oXdXd.< PXdXd.D *.qXX.q P &Xd.1 R PXd &.b oX= o 1.E tX.Xd V.T o.TXb 8X8Xd V V o o.e # HX..( 1Xd V.D V &.:.D.D.: VXd VXd o.~Xd o.D VXd.<Xd &Xd.D.~Xd.D &Xd &Xd.<Xd.:.:Xd.:.D.:.: &Xd &.D hXbX..(X= VXd *.< V *.D VXd.<.<Xd &.<.pX. #.( #.p.(.(.( o o * o.( H h.p I h oX8X=.(.9.(X8.p.p.K.p.(.p H.p V VXd.( #.p.p.p.e H.pX8.(.(.p.(X8.(.(.D.D V oXd.b VXd.<Xd.: &Xd V P o * V oX=.p I h o.~ o V.< o.K #.( oX=Xd V VXd.<Xd V V o o P.~X= o V VX0.:.b.<XX R.2 s m.( #X= # oXd H [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.(.( * o kXdXd o o.$X: T T TXeX1 dXeXm.}Xm.DXmXm 7 fXmXmXm.a fXmX Xm.>XmX XmX .>.XX .XX .XX .@.XX X .X.@.X |X .u.^X*X8XqXq.AXqXq f.c Z n G G N.8.8 Q.NXm |.@.@.@.@ |.@ F.^.c.t.c.@ 8 8 8 8 8.@ 8.@.@ 8 8.@.@.@.c ;.t n.^ N A gX&Xz 7Xm f.}.} f.}.}Xm.} ].w |Xn S Y M r r r r rX> ].; ;Xz N FX0.;X0.c.;X0X0.w TXM ( M (X>X> rX>X>.m.m Z.cX3 G n.QX0.)X:XM Y M M rX>XNX>X XN | ].B.^ G.^Xf iXfXe | T 4 M M Y DXN DXN z D.BX3Xz G.^.R.R.R i.RX3X3 3.R 3Xf.R 3.R 3.R.R v.R F 3.R 3 F.R.R F.R F F.u F.R F.R F v F F.RX+ F FX+XzX1X1X1XgX:.F.F.F.F.F.F.:.=X= oX8 o.(.( hX= * V oX= @.. I.E.p o V X V.p.p.e.p H.pX= 1X=.(.e.p H.pX= I.(.b & &.< V &.:.~.< V.< o o o V X o oX= oX= oXd V.~ o oXd oX= H.e.pX= * 1.DXd.< o VXd o V V V V o V.:.D V oX=.e t R.bX=X=.< H #.# *X8.T.T t.vXdX=X=.M.M s *.<.<Xd V.<.hXX 1.( o.h *.(.( h.q o *.(.: V tXb.Y 1X=.r.p.( @ H.e 1 VXd oXdXd PXd 1.(.~ o.~ 2 &.:.:.b.:Xd.DXd V & VXdXd VXdXd.(Xd & &Xd.D o * &.D &Xd *Xd VXdXd k & &.b.D o.<Xd.<Xd.: H ..M.( V o V o.(.( * o kXdXd o o *Xd.< h h oX= o o.( o.=.(.qX8.( o.=X= oX8 o.(.( hX= * V oX= @.. I.E.p o V X V.p.p.e.p H.pX= 1X=.(.e.p H.pX= I.(.b & &.< V &.:.~.< V.< o o o V X o oX= oX= oXd V.~ o oXd oX= H.e.pX= * 1.DXd.< o VXd o V V V V o V.:.D V oX=.e t R.bX=X=.< H #.# * [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX> k o.D.D.D.: k * 1.$.$ T TX,.PXr.!Xm.DXmXmXm 7XmXmXmXm 7Xm f.aXmXmXm.a f.a f.a.a f.a.>X X X X .XX .@X .X.@ f.R.^.tX8Xq <.A <.A.@ Z.c.t.^.J N.8.N.8.8.8.@.@ |.@.X |X .@.; G.t.c.t f 8 8 8 8.@ 8.@ 8 8.@ 8X8 8.@.> n n.t F QX7X&.%.%XeXmXm.} f.}XmXm.}.}.}.w |XMXn b ( r r r.x r.m ].; ;.J NXf.;.;X0.;X0.cX0X2 rXn ( M b rX>.mX>X>X>XN Z.B x GX0 i iXeX: $ b M ( r.mXN.mXNX>.mX*.B.^ G v i iX0X2X: T b M M $XN DXN DXNXN.B n.^ GXz.R i.RXfX3.R.R i.RXf 3.R.R.R.R.R.R F FX3.R.R F.R 3.R 3.R.R F.R.R.u F F F 9 F.R F F F.R 9 pX7X1.+.gX,.F.F.F.F.F.F.: o V.~.( *.( *XXX8X8.q.K.p # @.K.e o.:.DXd X.p.p.p o.z.e.e oX=X=X= H.(X= 1X8.h &.:.: V oX=X= o o o o V o o * o o oXdXdXd 1 o X 1 o.q.< oX8 #.E.p 1 V VXdX8X=Xd.DXdXd VXd.D.D o.~ & V.DXdX8.p t # &.:Xd o h t.T P.~.. @.M O o.(.(.( O.( oXd o o & &.e.q o.p @ h.(.# h # I 1 HX=Xd * H H.p * V.p.p H o #.p V VXd V V VX= o *.p P o.~ V &Xd.D.:Xd oXd V V V & V.DXd V.< oXd V V &Xd o V & & VXd V.DXd & &.D.:.D &XdXd.~Xd.~.D.: H.M .Xb.(.( o H k o.D.D.D.: k * 1 1Xd & H.p *XdXd o.( *.( o P.(.( o o V.~.( *.( *XXX8X8.q.K.p # @.K.e o.:.DXd X.p.p.p o.z.e.e oX=X=X= H.(X= 1X8.h &.:.: V oX=X= o o o o V o o * o o oXdXdXd 1 o X 1 o.q.< oX8 #.E.p 1 V VXdX8X=Xd.DXdXd VXd.D.D o.~ & V.DXdX8.p t # &.:Xd o h t.T P [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.0 &.:Xd V.:.<.# h V.$ T.$ T.g =Xr.n.w.}Xm.}Xm.wXm.wXmXmXmXmXmXm f 7 fXmX XmX Xm.aX X X .a.>X X X X .XX X  DXf.kX0.c.AXq.A.A.A 8.c.c.c.^ GX7.8.8.8.8.N.) |.@.@.X.@.@.@ |X  G 3.t.c.t 8.@ 8.@ 8 8.@X8.@ 8.@.@.@X8.@.t ; n n NX7 + + g.PXm f.}Xm.}.} f 6.}.}.w |XM 4 b Y r r r r rXN ] ZX3 G NXf.cX0.;X0.;X0.; | T 4 M M S | 8 rX>.mX> D.;.B x G.QX0X0XeX:XM b b YX> |XNXNXNX> D ].B G NXf iXfXeX2X:XM ( M ( r |XNXN DXN D.BX3.^ G.^.R n.RX3Xf.uXf v i FX3.R 3.R 3.R 3.R F 3.R 3.R.R.R.R.R F vX3 v v F.u.u F F v.u F.u FX+ 9X7X1.+.FX,X,.F.F.F.F.F.F.:Xd.:Xd.#.p P o oXdX= H.EX8 #.T.TX= V.D.:.DXdX= H.pX= oX=X=.(X8X8.e #X= o 1 o.p.#.:.DXd o.~X= o.~ o.~ V oX8.q o & o & 1.~ o o.r 1 oX= o * o.(...e.q.~ 1 1.T # oXd V V VXd V.<.~X=XdXd V o.p oX=.D.b.b.DX8 t t h.K..Xb @.M.M.( o o o.(.( RX= o P o.DX= o 1.p @ h.e ,.p tX=.G.~.G.q.p h.( t.( oX=X= * *.T.pXdXd VXd.D V VXd V.~ oXd.<Xd V o &.D.rXd o o o.~XdXd oXdXdXd.:.D &Xd V VXd o V &.< VXdXd V VXd.<.DXd V.<.DXd V.<.~.K.T #Xb b j.(X8.p &.:Xd V.:.<.# h V & V.~ o o oXd.< oX=X=.(.(.( *X8 oXd.:Xd.#.p P o oXdX= H.EX8 #.T.TX= V.D.:.DXdX= H.pX= oX=X=.(X8X8.e #X= o 1 o.p.#.:.DXd o.~X= o.~ o.~ V oX8.q o & o & 1.~ o o.r 1 oX= o * o.(...e.q.~ 1 1.T # oXd V V VXd V.<.~X=XdXd V o.p oX=.D.b.b.DX8 t t h.K [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& o & &.:.b.: R.( 1.$ 0.$ TX1Xr 0Xe.}Xe.}.w.}.}.wXm.}Xm.wXmXmXmXmXm 7 7 fXmXmX X Xm.>XmX  f.aX X X X X .XXf.k.Q 6.>.AXq.AXq 8.c 6.c x.J G.8Xw.8.8.8.R.XX X X .@X .@X X X .Q G.t.t.t f 8 8 8.@ 8 8.@ 8 8.@.@ 8.@.@ 6 n.t.t.^ NXw.I.IX&XmXm.}.}Xm.}.}.}.}.}.gX:XM S b Y.x H r r rXN ].; 3 G N.cX0X0.cX0X0.c.) |XM Y M MXM r.m r.mX>X> D.c.B.^ G n.Q i.wX:.x Y b YX>.mX>XNX>XN.m.;.B G GX3 i.! 7X2 TXn M M Y |XNXN DXNXN D ; 3.^ GXz.RX3Xf.u.RX3.R.uX3.R.RX3 F F.R.R.R.R v F v 3 F v.R F v.R F.R F F v F v.u.u 9.u.u 9.R FX1.+X1Xp.nX:X:.F.F.F.F.F.F iXd VXd o V V V o.(X= H t.K o 1 o V.D.: X V 1 o o.qX=.~ V o I #.e.~ V.:.b.:.~ 1 IXd.: & X V.~.~ * o o.~ VXd V V.(.pX=X= * o.( * R t.p 1 o o o #.pX=X=X= t t @ oXd & VXd.<.DXd oX=.~ V o.D H.h * &.b.<.( t t #.q.<Xd.( @ @ hXdXd o.qX=.q * P * o o oX=X=.pX= #X..E.p.p.qX=.~.G.G @.p.e H.p h I 1.~ P o.D &.D.~ o V V 1 * VXd.DXd X k h.( 1.b &.D V o.( o.DXd.<.DXd.D.D *.<Xd VXdXd &Xd V * oXd.DXd V & o o.~.D V &Xd oXd V V &Xd.DXX.(.T.E V o o & &.:.b.: R.( 1.D VXd oXdXd VXd V V o * P.< oXd.DXd VXd o V V V o.(X= H t.K o 1 o V.D.: X V 1 o o.qX=.~ V o I #.e.~ V.:.b.:.~ 1 IXd.: & X V.~.~ * o o.~ VXd V V.(.pX=X= * o.( * R t.p 1 o o o #.pX=X=X= t t @ oXd & VXd.<.DXd oX=.~ V o.D H.h * &.b.<.( t t #.q.< [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.<Xd V.:.: V.1.( 1X:X: T.XXrX1XkXm.DXm.}XeXmXm.}XmXmXm.} ] 7XmXm ]Xm D 7XmX .a 7X Xm.XX .a.>.a.>X X  fX0.k.Q.D.>.AXq.A.A.A 6.c.c.u G.J.8.8.N A.N c 7.@ |X .@X .@X .@X X Xm GX3.c.t Z.@ 8 8 8.@ 8.> 8.> 8.@.> 8.>.@ v n nX3 N NX& g g iXmX*Xm.}.}X*.}.}.} 7 TXM S ( Y r r r r r D Z.c 3 G GX0.c.;X0.;X0.tXeX: $ b M (X>X>.mX>.mX>.mX*.c ;.^ G nX0.Q.) |XM S Y.xX>XNX>X X>X X>.c.B G GXf.!.)XjX: T b M M.x DXNXNXNXN D D n v G G 3X3.RX3.RX3Xf.u.RX3.R.RX3.R 3.RX3.R.u 3.R 3.R.R.R.R.R F 3.R.R F F 3.R v.R F v v.u v.R.PX1X1X1 =X2X:X:.F.F.F.F.F.F.V.D V & VXd.<XdXd oX=X=.p.TXdXdXd &.D.:.c o.~ k 1.r o V V V.e.pX8 o V.:.D.:Xd o.f k.:.:.D V o V * o o 1 o oX=X=.T.p.q V VXd.~ o P h @.pXd.~ V.p.(.p.e /.M t @ * VXd V VXd.D.<X=X= V o o.(.e.( o.= * *.KXb.MXX.r.~ o 1 #..X. o V oX8.(X8X=XX.# o.(.p.q.p.q o o H # , ,.p h O.p # @ ,X=.p.pX= 1.: V.q VXd oXd VXd.<XdXd &XdXd V V.~ o o 1 1 V.D &Xd o o.~.<.~ V &.D & & oXd.D &XdXd X.D.: o oXdXd &XdXd.~.~ o oXd 1XdXdXd VXd.DXd &.: oX. @.e V.<Xd V.:.: V.1.( 1.: V 1 V VXd VXd oXd o P oXd.< V.:.D V & VXd.<XdXd oX=X=.p.TXdXdXd &.D.:.c o.~ k 1.r o V V V.e.pX8 o V.:.D.:Xd o.f k.:.:.D V o V * o o 1 o oX=X=.T.p.q V VXd.~ o P h @.pXd.~ V.p.(.p.e /.M t @ * VXd V VXd.D.<X=X= V o o.(.e.( o.= * *.KXb.MXX.r.~ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& *.~ V V.D o B.q.~.$ T TX-X1. .DXmXe.}.}.}XmXe.wXm.}XmXmXmXmXmXmXmXmXm fXmXmXmXmX  7.>.a fX X  fX .aX0.k.R.c.> 8.A 8 8XqX*.t.c ;.^ G N.8.8.8.8.8.w.XX X X X X X X X X X .@ v.^.t.t.t.> 8.@.@ 8.@ 8.@ 8.@.@.>.>.@.@.c ; n ;.JX7 Q g.% Q.wXm.}Xm.}.}X*.}.wXOX: S S b S r r r rX> DX*.B v G GX0.;.;.tX0.;.c.w T $ b M (X> rX> 8X>X>X> Z.c n G GX0.QX0.) | T.x.x.xX>XNX>XNXNXNXN.;.B G N.R.nXOX2X:XM M ( Y rXN DXN z DXN ] 3.^ GXz n.R n.RX3Xf.R n.RX3.RX3.RX3.R.R.R.R.R.R F 3 F.R.R.R.R.R.R.R F.R F.R F.R.R.R v 9.u F.u.yX1.+X1XgX,X:X:.F.F.F.F.F.F i V.:.D &Xd.<.DXd &.< oXd.q V.DXd V &.:.~ V.D o o.~ k o V V o V.: V.D.: &.:.D.<.q.( o.D.:.D o V * o.qX8.p # h.p h 1 H VXd oXd o.qX=.( #.K hX8X8.(.( t.. @ @.K *.~ 1 1 o.~Xd oX= 1 VXd.r.K.(X= 1X=.K o @.MXb o.~.~Xd V.e @.M oXd.~ o.qX= o.p O.q h h o o o.(.rXd @ H HXXX8X= t t.p.(.(XXX= 1 V.D V V &.DXd VXd V o oXd.D VXdXd V V VXd *.:Xd &.DXd o V VXd.<XdXd.: &.DXs &.D &.<.< & V V V.~ V V V VXdXd V.~XdXdXdXd 2 o oXd VXd &.D.:.K t t o *.~ V V.D o B.q.~.~.< & V V VXd V V VXd oXd &Xd.:.D V.:.D &Xd.<.DXd &.< oXd.q V.DXd V &.:.~ V.D o o.~ k o V V o V.: V.D.: &.:.D.<.q.( o.D.:.D o V * o.qX8.p # h.p h 1 H VXd oXd o.qX=.( #.K hX8X8.(.( t.. @ @.K *.~ 1 1 o.~Xd oX= 1 VXd.r.K.(X= 1X=.K o @.MXb o.~.~ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.`.(.( & o o R B.( o.$.$X:.PX1XgXe.D.}.}.D.}.}.}Xm.}Xm.wXmXmXmXmXm ]Xm 7.a f.a f.a f fXmX .>.a f.aX .t.k.u 6 f 8.A 8.A 8.>.t.c.t.^.k N.8.8.N.8.NX0.X.X.@.@X X X X X X .>X  f.; N.Q.t ; 6 8.>.@ 8.>.@.> 8.> 8.@X8.@.>.>.u n n v NX7.IX& g.)Xm.}.}X*.}.}.;.}.a T $ Y b $ r.x r r r ] Z.BXz GXz.c.;X0.t.cX0.cX2 T S ( M YX>X>.mX>X>.mXN Z.B 3 G.^X0X0X0X0 | r $ r.xX>XNXNX>XNX>XN Z.B.^ Q.PXeXjXj T S b Y r | DXNXN DXN D.c 3 G G v.R.R.RX3XfX3.R.RX3.RX3.R.R.R.R.R.R.RXf.u v.R 3.R.R.R.R.R.u.R v.R F 3.R v F.R F v F.RX+ pXpX1.+.gX:X:X:.F.F.F.F.F.F J VXdXd * VXd oXd & &Xd &.D.DXdXd.~XdXd.D V o VXd VXd.D.~ V k E.D V.D X o &Xd V VX=XX * V V.D V.~.( # @.p #.r.( V.~.D.p PXd o VXd o o.q.' s #Xd VX=.T @.h o o o o V o &.D.: &Xd V o.~.r *.p.q 1 o 1.G.K.( *.D 1 V.: VX= @ B oXd.D oX=X8 PX.Xb.K.p.M.<.pX=X8 1Xd I.( R h * & X VX=.pX8 1 V.~ 1 h.h.D.D.~X8Xd VXd V & V V.:.D o oXd &.D.:Xd.rXd o.< VXdXd oXd.DXd &.D &Xd P.(.( o.~ V V.<Xd V V V o * oXd o o.~ o.~ 1XdXd oXdXdXd V.D &Xd *.T #.(.( & o o R B.( o oXdXd.<.<Xd.<XdXd V.: V V.:.:.DXd VXdXd * VXd oXd & &Xd &.D.DXdXd.~XdXd.D V o VXd VXd.D.~ V k E.D V.D X o &Xd V VX=XX * V V.D V.~.( # @.p #.r.( V.~.D.p PXd o VXd o o.q.' s #Xd VX=.T @.h o o o o V o &.D.: &Xd V o.~.r *.p.q 1 o 1.G.K.( *.D 1 V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O B.' O &.~ V s j.( VX:.$.g =X7.D.}XeXm.D.}.}.}Xm.DXm.DXmXmXmXm.}XmXmXm fXmXmXmXmX XmX XmX Xm fXmX X0. .u.t f 8 H 8XqXq.>.t.t.t.^ G G.8.8.8.8.8.R 7X X X X X X X X .>X X X X X  G.u.t.t ; 8 8 8.> 8.@ 8.@.>.>.@.@.@.@.>.Q ; n n N Q.I.3.I dXm.}.}.}X*.}.}.; | T S Y b r r r r r.m ] Z.t.^ GXz.;X0.cX0.cX0.; |XMXn ( M $X> rX> 8X>X> D Z.B F G.^.Q.QX0X0.wX: r.x rX>X>XN |XNXN.m ].c.R.yX5.gX2 | T S S.xX> DXNXN DXN z ].B.^ G.^ F i.R n.RX3.RX3 n.R.R n.RX3X3X3.R.uX3.u.R 3 v.R.R.u 3.R v.R.u.R F.R.R.u.u.R.R F F FXzXz.8 g.+.  |X:X:X,.F.F.F.F.F.F J oXd V V VXd.<.D.: & & &Xd V V & oXd o X.~ V V o o VXd.r o k & V.~ X.YXd.D V.:.: VX8 h VXd V V VX=.e # H h.p o.~ V V.(XX PXdXd o 1.( o # tX..<Xd P.p.p.E o V V X.~ *.D.D.:.:.DXd.r.p.K 1 VX=.~.r CX= o o VXd.~ o oX8.p h RX= o V.~ o o.pX. t.p.T hXX.(X8 V.~ 1 h B H.( *.<.<.q.qX= C o.4 o.# @.h VXd V.( V.<.D.: V &.: V VXdXd.< V.~ V o o V 1 V.D V.~ * *Xd k P k *XXX8 o V.D VXd VXd 1XdXdXdX=.~ 1.~ 1 o o.~ o o o V oXdXd &.<.D.b V o.( B.' O &.~ V s j.( V.~Xd V o *.< o.D.DXd.:.:.:.D.D &Xd oXd V V VXd.<.D.: & & &Xd V V & oXd o X.~ V V o o VXd.r o k & V.~ X.YXd.D V.:.: VX8 h VXd V V VX=.e # H h.p o.~ V V.(XX PXdXd o 1.( o # tX..<Xd P.p.p.E o V V X.~ *.D.D.:.:.DXd.r.p.K 1 VX=.~.r CX= o o VXd.~ o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O )XbXb.<Xd.<.# B.q C.$.$XgXr 0Xe.DXe.}Xe.}.}.D.}Xm.}Xm.}Xm.}Xm.}XmXmXmXmXmXmXmXmXmXmX Xm f 7X .aX0 c v.t f.@Xq 8 8.A 8.t.c.c.u.^ G.8.8.8.8.N.JXm.@ D.XX .>X .>X  DX X X  fX X Xf G.t.t ; fX8 8.@.@.>.@.@.> 8.>.>.@.>.@ f n nX3XzXu.%.7Xh gXe.}.} 6.}.}.}.}X2XM $ Y b r r r r H.m ] Z n G N.R.;X0.t.cX0.cX0 | T Y ( M rX>X>X>X>X>.m D.;.B v G v.Q.Q iX0.; | r.x r rX>.m.m |XNXN D.;X0X0.w 7 | T r r r |XN DXN DXN D ].c ;.k G v.uX3X3X3.RX3.u F.u.R 3 v F.u.RX3.RXf.u.RX3.R v 3.R.u.R.R 3.R x.u.R.u v.R v.R F 3 F F.R.yX7X1 +X-X:X:X:X:.F.F.F.F.F.F JXd o oXdXd VXd.:.DXdXd.D & & VXd V V o.: V V V * kXd o.~ o V V 1.Y V VXdXd.: V.D X V.p V.: V &.<.q h.K.M H * oXd.D 1 o.q.( o o.~ o o.( * #XbXd oX. o o.e.pXd V VX8.h VXd &.:.D o.e t O.p o oX=.~ oXd V.pXd o V o H hX8.( *.#.q o o P * # PXX t @ o.(.(X= o.(.( oX8.q.(X= *XX.(X= oX= C.q O.M.K.p o.rXdXd o o VXd.DX8.D.D & V o o *X8.q.q.( oXdXdXd.< o V.p o oX..( o.~.D.D VXdXd.<Xd V o.~ V.q oXdXd o oXd VXd.~ oX= o o o 1 o oXd 1 H o o.MXbXb.<Xd.<.# B.q C V.~ VXd.DXd V & &.:.D.: & X.D.DXdXd o oXdXd VXd.:.DXdXd.D & & VXd V V o.: V V V * kXd o.~ o V V 1.Y V VXdXd.: V.D X V.p V.: V &.<.q h.K.M H * oXd.D 1 o.q.( o o.~ o o.( * #XbXd oX. o o.e.pXd V VX8.h VXd &.:.D o.e t O.p o oX=.~ oXd V.pXd o V o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O TXbXb.(.D R.6X= o V.$XjX1XrXf.D.}Xe.}.DXmXmXe.}.}.g.}.g.}XmXeXm 7XmXm 7XmXmXmXm.aXmXm 7XmX Xm.D c v.t 6.m 8 8 8.A 8.t.c.t n G.^ N.8.8.N.N.8.}X  7 fX  fX X X  fX X X  fX .a fXm G.u.t.t.t.@.> 8.> 8.> 8.@.>.> 8.>.>.>.>.^ n n n N g.I gX&.R.}.}.}.}.}.;.w |XM S Y Y r r r r rXNX* ZX3 G NX0.cX0.;X0X0X0X0 |Xn b M ( r r.mX> 8X>.m ].c ;.^ G 3.Q.QX0X0 i DX: r r rX>X>XN.m |XNX> ].w.w D | | | | rX>XN DX> DXNXN z Z ; 3 G.kX3X3.u.RX3X3X3 v 3.uX3.RX3.u 3X3.u.R.uX3.u.RX3 F.R 3.R.R 3.R F.R v.R F.R.u.u.R F F F F 9 pX1 gX1X1X:X:X:X,.F.F.F.F.F.F J P.DXdXdXd VXd.~ o & V V V.< V V V.:.: VXd.D.DXd o V 1 o V.:.DXd V 1.:.:.D.:.D V XX=.q.( 1 1Xd VXdXd.D V.(.q o *.pX=.~ o o oX= oXd oX=.p.p.pX= o V &Xd o # hX=.~.q V V.~.~ oX= H t h V.~ o.(.~ o *Xd V.( V V V.< V o.T O P oX= *.< VXd.< o R.(.qXd.<.p.( o oXd.~.<.( * oXdXd.~X8 o 1X8 @...K.` o.f & V VXd V.D.: &.b V.~XdXd & oXdXd.< o.~ o o *.~ *Xd o o o o.:Xd V.:.:.: &.D o.D.D.:.:Xd VXdXdXdXd o VXd V.D V V.~ o o o V.~XdXd.DXd o O.#XbXb.(.D R.6X= o V VXdXdXdXdXd &.:.:.:.:.D.D &.DXdXd P.DXdXdXd VXd.~ o & V V V.< V V V.:.: VXd.D.DXd o V 1 o V.:.DXd V 1.:.:.D.:.D V XX=.q.( 1 1Xd VXdXd.D V.(.q o *.pX=.~ o o oX= oXd oX=.p.p.pX= o V &Xd o # hX=.~.q V V.~.~ oX= H t h V.~ o.(.~ o *Xd V.( V V V.< [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.MXb.EXd P $ * 1 VX, 0Xr 0.D.)Xe.DXe.DXe.DXe.D.DXeXeXeXe.}.DXe.g.D.gXe.wXe.}.g.gXm.g.wXmX0Xz.^.t.t 8 8 8 8 8 8.A 6.c.t v G G.8.N Q.8Xp -Xm 7XmXmXmXm 7XmXeXmXmXm.gXm.wXm.wXmXmXf.kX3.t ;.c.@.>.@X8.> 8.>.@.>.@.>.>.>.>.> x.u n F QX&Xh.IX& 9Xe.DX0Xe.).wX:XM S Y S r r r HX> DX*.c x G.J.!X0X0X0X0.!X0X0 T $ b M YX>X>X>X>.mX>XN Z.BX3 G G.RXfXfXf.!.!.!.w | r rX>X>X>XNXNXNXN | | D |XN DXN |XN |XN D zXN z.G.c ; v.^ F FX+.RX+.P.R.R.PXz F 9 9X+ 9.R 9 F.P F 9 9 F 9 9 9Xz 9 9Xz 9 9 9 9Xz.P -X+ - 9 9Xz.y 9.P pX1X1X1XeX: pX:X:X,.F.F.F.F.F.F ~.D VXd P 1.<XdXd VXd.< o o VXdXd V.D XXd V V VXd.r V.~ V o.:.:.DXd 1Xd.D.: V V.~ 1.(X8 h o V.< 1 o.r.~.r.#XX.<.p o o *.(X= o *.q VXdX8.pX8XX o.~X= V o o.e #.hX=X8 oXd V V o H h.M O o o.D o.<.(X= o o.( V.~ o o o h t B.( P P.1Xd VXdXd oX=.q o o.< * o V V oXd VXd.< V.D o oX=X=.q.p t.M.TX8.~.pXd VXdXd V.:.b.D.: V o o V.< * VXd o k V.DXd.< o.D.D.~.~Xd o.<Xd.D.:.D & V.:.: V &.DXd V.D o.DXd V oXdXdXd VXd o o 1Xd.~.DXd & V V o & kXd.MXb.EXd P $ * 1 V.~.<XdXd V * 2Xd.:.D.D.:.b.:XdXd V.D VXd P 1.<XdXd VXd.< o o VXdXd V.D XXd V V VXd.r V.~ V o.:.:.DXd 1Xd.D.: V V.~ 1.(X8 h o V.< 1 o.r.~.r.#XX.<.p o o *.(X= o *.q VXdX8.pX8XX o.~X= V o o.e #.hX=X8 oXd V V o H h.M O o o.D o.<.(X= o o.( V.~ o o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e t t t V * P * 1Xd.gXrX1X1X7X7 QX7X1X7 QX7.8X7X1X7X1X7X7 Q.8 '.oX7X7X7 Q.8.8 QX7X7X7 N Q.k.^.Q.c.@ 8 8 8 8 8 8 6.Q.tX3.^ G.8.8Xw.8.N +.8X1X7 g.N QX1X7X7X7X7 gX7X7X7X7X1X7.oX7 Q.J F.Q n.t.@.>.> 8.>.>.>.@.>.@.>.>.>.>.>.c n.uX3 Q Q +XhX&X&.I.8X7X7XpXe T.x S Y r.x r r r r z Z.c v G NX7X7X7X7 ' 'X7X1 rXn ( (.xX> r.m r.mX>X8.;.c x GX7.8X7 'X1X1X7 '.P D |.mX>X>X>X>XNX>XNXNXN DXNX>XNXNXNXNXNXNXNXN z.G.c ; 3.^ GX7X1X1X7 A.8X7X7.8X7X7X7X1X7X1X1X1X1 '.NX1 'X1X7 'X1X7.N ' '.oX1 'X1.NX1X1X7X7X7X1X1.8X7X1X1X1.+.7X:X: 'X:X:X:.F.F.F.F.F.F.: o VXd oXdXd & V * V * *Xd.~Xd.:.~ V V.D.: V V.~X=Xd.D V &.:.:.D oX=.:Xd V.~Xd & V.~.(.T h RXX.#XXXX h oX.X. t.q.q.<X= * o o.(.< oXd.p o.( * V 1 o.~.<Xd 1.p.( I.p.( oXd X 1 CX=Xb hX8 * & o o.(X=.(.( o.p.( # hXX k.(.2 k R P R &.DXd & & o o.<.( &.D V.D V.(.DXd V *.~ V 1.q.(X8 t @ t.MX= V V.p o.rXdXd.<.D.: & V.D.<XdXdX= o V VXdXd &Xd.D.~X=.: &Xd &Xd.<Xd.:.D o o.~ & V.: o V.~ &.DXd *Xd V V.~ o.D.D V oXdXdXd V.D.D.: V * *.(.D.:.: t t t V * P * 1Xd *X= o V o.(Xd.D &.:.D.:.D.b VXd.~ o VXd oXdXd & V * V * *Xd.~Xd.:.~ V V.D.: V V.~X=Xd.D V &.:.:.D oX=.:Xd V.~Xd & V.~.(.T h RXX.#XXXX h oX.X. t.q.q.<X= * o o.(.< oXd.p o.( * V 1 o.~.<Xd 1.p.( I.p.( oXd X 1 CX=Xb hX8 * & o o.(X=.(.( o.p.( # h [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e &.( @.p o h o 1.~.gXkXk.nXk.n.).n.nX-.n.n.n.n.n.nX0.n.). .n.n.nXe.n.).n.) p.).).).) -Xu.^.Q 6.@ 8 8 8 8 8 8 f.t.t ; G G N.8.8.8.8 g Q -.).n c. Xe.n.DXe.D.nXe.).n.D.nXe.).D.nXe 9 G.t.t n.@.@ 8.>.>.@.>.>.>.>.>.>.>.>.> f x nX3 N Q.%.I  X@    .IXk.nX2X: $ S Y.x r r r HX> D Z.B.^.JX+.).).).)X0.!.)X-XM S ( ( rX>.mX>.mX>.m D.c.B v GXfXu.)Xk.).n.).n '.)XmXN.mX>.mX>X>X X>XNX>XN.m DXNXNXN z zX8 H H.G.c ; x G G.!.!.n.n.nX1.!.).!.).!.n.n.n.nXk.).n.n.n.n.n.!.)Xk.n.n.n.o.n.n.).n.!.n.n.n.nXk.n.n.nX0 A.)X0.!XkXkXeX:X: 'X:X:X:.F.F.F.F.F.F i &.< * *XdXd 2 * o.~ *XdXd V.D 1 1 o V.b.: VX=X= V.:.: V *Xd.D.: 1.( 1 oXd.b.:.DXd.< V j j s.r.~X=Xd 2 oXX.p.p o.~ o * 1 VXd.(.~.D VX=.~ V 1 o V V o.e o PX=.p...p o V V 1 H @.MX8 H.p.qXd V.(.(.q k.< P 1 1 o I.f.e * oX= H.p.#Xd.D &.<Xd oXd o o h o o.<.q hXd P o o.(.( V o oX=X=X= o V o.~XdXd.~ 1 V o VXdXdXdXd V V o VXd V * V &.DXd.D o & & &Xd.<XdXdXd.D.<Xd.<Xd V.:.D.: o * o.D.:.~ V V & oXd & o 1.~Xd.D.:.D V X o oX=.D.~.D.:.D.: &.( @.p o h o 1.~.~ V o o o VXd.D.:.:Xd o 2 o.( &.D &.< * *XdXd 2 * o.~ *XdXd V.D 1 1 o V.b.: VX=X= V.:.: V *Xd.D.: 1.( 1 oXd.b.:.DXd.< V j j s.r.~X=Xd 2 oXX.p.p o.~ o * 1 VXd.(.~.D VX=.~ V 1 o V V o.e o PX=.p...p o V V 1 H @.MX8 H.p.qXd V.(.(.q k.< P 1 1 o I [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.DXd.(.(X8 hX8 1 o.$.$.$ T T T TX: TX: T.$ T T T T T TX: 9X: T T.$ T T T TX+ T T.X.D.J 9.Q.c.> 8 8 8X: 8 8.@.Q.t.t.^.^ G.8.8.NXw.8Xw +. .gXm 0.PX:X: T TXn TXM T $ T T T T TXn T.XXuX3 n ;.>.@.>.>.>.>.>.@.>.>.>.>.>.> f.>.t.uX3.k N.o.%X@  .3.IXh.7X5X2XM S S Y r r r r rX> ] Z ;Xz N.)X: T TX: T T TXj $ Y b b rX>X>.m r.mX> ].c ;.^ G.J rX:X: TX:X: T dX:.w.wX>XM rX> DX>X>XNXNXNXNXNXN H H H H H.G.G.c ;.^.^ GXm T TX: TX:. X:X: TX: TX: TX:X:X:X:X:X: TX: T.$X:.$X:X:X:. X:X:X:.$X:.$X:X:X:X:.$ TX:.$X: 'X:X: T.$X:X: pX:X:X:X,.F.F.F.F.F.F JXdXd o * o * *Xd oXd o oXdXd 1.q oXd.D.b.: V o.q.( VXd.DX8 *.: V * k *Xd.:.b.:.:XdXd V s.6 $.~.<.~ 1.(.h 1 V 1.( o o.~Xd.~.~Xd.D X.r.( o.p.( *X=.(X=X=Xd o o.( #X8.p o.~ 1 t.M t.K #.pX= o o h P R k.< oX=X=.~.p.p.E hX= o.~.GXX.< &.DXd &Xd.<.~XdX. o.< o * o.< V.<Xd V * VXd o.~.< o 1 o.q.<XdXdX=.q V.<Xd.< V.D VXdXd o V o V.9Xd.D.b.D.~Xd.D.:.DXd 2XdXd.D X V V o * oXd V.:Xd & *.< V oXdXd VXd VXd.<.( o 1 V.D.: VX= h P kXdXd &.:.D &.DXd.(.(X8 hX8 1 o 1 o.~ * oXd.D &.D.:.:.:Xd VXd *XdXdXd o * o * *Xd oXd o oXdXd 1.q oXd.D.b.: V o.q.( VXd.DX8 *.: V * k *Xd.:.b.:.:XdXd V s.6 $.~.<.~ 1.(.h 1 V 1.( o o.~Xd.~.~Xd.D X.r.( o.p.( *X=.(X=X=Xd o o.( #X8.p o.~ 1 t.M t.K #.pX= o o h P R k.< oX=X=.~.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd V VXdX.X..MX= o.rX:.$.$ TX:.$X:.$ T T.$.$Xz T.$.$ T T T 9 T T T T.$Xn.$ 9X+.a.n.R.  v.Q.c.> 8 8.@ 8.@ 8 8.Q.t.t.t G G.8.8.8.8.8.8XwXw Q +Xw.8 AXw.8 Q 0Xm TX+ T TXM T T.$XeXf. .8.J.^ ; n.@.>.> 8.>.@.>.>.>.>.>.> f.> f.> f vX3.u NXu A.%.3.I.3XpXp.PXj T $ S Y r r rX> HXN ] Z i.^ GXe T T T T T T T |XM Y ( YX>X>.m r.m.m.m ].c n G N c c TXMX:X:X:X2 d rXj.w |X: Y M M SX>XN zXN H H H H H H z.G.c ; ;.^ GX0.JX:X:X: TX: TX:. XMX:X:X:X:X:X:.$.$X:X: TX:Xr TX:X:X: TX:X:X: pX:X:X:.$X:. X:X:X:X:X:X:X:X: r 'X:X:X: p pX:X:X:X:X,.F.F.F.F.F.F JXd.~Xd P oX=.<Xd.< V.~XdXd o o o.D 1.:.D V o H.( * V VXd.D.~ o V P.6.6 k.D.:.:.:.: VXd h j.6 * o V.(.h VXd V IX= oX= o o.~.~ V V.r.(.q.e.p.( P P hX. o X.qX= o t.EX=X= 1.K t t.. @.pX= o *.(.1.1 R * *X=X= oX8 o o.( s.( 1X= oX= oXdXd & V o V V o * o *.<.(XdXdXd V VXd V.( V V o.~ o oX=.(Xd.DXd * V oXd o o * oXdXd oXdXd VXd.( * V.bXdXd oXd.D oXd.: V & &.< & &Xd.D &.~ & V.:.: &X= V V.~ oXd.~.D o.~.(X=XdXd o.D V * * & V.DX0.:.:.: & V VXdX.X..MX= o.r 1 o o.DXd.D VXdXd & V &.: &.:.~XdXd.~Xd P oX=.<Xd.< V.~XdXd o o o.D 1.:.D V o H.( * V VXd.D.~ o V P.6.6 k.D.:.:.:.: VXd h j.6 * o V.(.h VXd V IX= oX= o o.~.~ V V.r.(.q.e.p.( P P hX. o X.qX= o t.EX=X= 1.K t t.. @.pX= o *.(.1.1 R * *X=X= oX8 o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e V.:.D.M . ..pX= o.$ T T T T T T TX: TX: T T T T T T T.y T T T T T T.XXe.n QXu.JXz.u.Q.c.>.@ 8.@ 8 8 8 8.D.Q.t.t n G N.8.8.8 A.oXw A.oXw QXw A.oXp.o +.N.a $XM $XM T.aXf dXwXw Q NXu.^ n ;.> 8.>.>.>.>.>.>.>.>.>.>.> f.> f.>.c.uX3 v NX7.o g g g + +.P |XM S 4 S r r r H rXN ] Z 3 G N.aX: T T T TX: TXj.x b b S rX>.m r.mX>XN Z.cX3 GXz.^X: TX:Xe.)X5.!XeX:X2XjX:XM ( M MXMXNXN D.cX*.G.G Z.G.c.c ; ;.^ G G.w |. .AX:.$X:.$X:X:.JX:X: rX: T.$X: TX: TX:X:X: TX:X: TX:X: TX:X: p TX:X:X: TX:X:X:X:X:X:X:X:X:X:X:Xu p p pX:X:X:X: |X:.F.F.F.F.F.F J V V * * o *.DXd V * o o 1.~ o VXd.D V.: 1.~.(.( h.'.qXd V.:.: V * j.~ 1 o.4.D.~.~.~.: V.( j O.p CX=.< V.(.~ V V *Xd oX=X8 H.(.p # o.p V V V o.e.h.p.K h.(.( 1.pX=.G / @ @ t t.M @ t.h P k k RX: j.( 1 1X=X=.e.pX=X=XX o 1.(X= o o.~ VXd X.G.M h h oX= o.p.( o.< o.<Xd.< o.D o V.~ o o.p o o h.(.(.: & VXd oX= o.DXdXdXdXdXdXd oXd o P VXd.D.< V.~ oXdXdXd V.:.:.D VXd &.:XdXd o.b.D V.(.p 1Xd V o VXd V VXd.~ oX8.( kXd.: V V V.D V.D V.:.: V.:.D.M . ..pX= o.~Xd VXdXd o.< VXd.: V V V.: VXdXd V V * * o *.DXd V * o o 1.~ o VXd.D V.: 1.~.(.( h.'.qXd V.:.: V * j.~ 1 o.4.D.~.~.~.: V.( j O.p CX=.< V.(.~ V V *Xd oX=X8 H.(.p # o.p V V V o.e.h.p.K h.(.( 1.pX=.G / @ @ t t.M @ t.h P k k RX: j.( 1 1X=X=.e.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O _.:.b.D.#.MXb.( o 1X, | T TX: TX: T.$ T TX: TX: T TXz T 9 r T.XXeX0 dX7 pXu.J.J v.Q.t.tX  8.@ 8 8.@ 8.@.@ n.Q.t.t.u.k NX7X7X7 Q AXw AXw Q.o.oXwXp u.7 +.8X: T TX:.gXf.o QX7X7 p. . .J.u n ;.>.>.>.>.>.>.>.>.>.>.>.> f.> f.>Xm.> n x.uXz GXuX7X7 Q Q.oXp A.!.) | r r r r rX>XN ].c 3 G N |XM T T TX:XM TX2 S Y b S | 8X>X>.mX>XN Z.B 3 G i.y.X.nXgXgX-X-.g.nX:.w |XM 4 M M b |X>XN.c.B ;.;.c.B.t ; x v G F.;X X: T T.JX:X:X:X: rX:.J. .J p.JX:X:X: TX:X:X:X:X:X:X: T | TX:X: TX: p rX:X: TX:X:X:X:X:X: TX: TX:X:XMX:X:X: |X:X:X: T.$.$.F.F.F.F.F.F J.DXd 1 o oXd.D.D V o.~ 1 o 1.<.~ VXd.~.: o.(.p o.q j.#X= V.D V.4.D k V V 1 V VXdXd 1.D V oXb t # 1.< V.~ V 1.D VX=.(.p.p.K #.q.e.qXd.9.~ V VX=X8 PX=.e #.K h H @ h.(Xb @ t...K @.K t H h * o.( P B.p o o *X8 h.pX=X=.(XX o o o o.< oX8.e , # & VX=.q.(.~.( 1 k oXdXd.r.~ V o * 1Xd V o.p.q V o 1 V V &.:Xd o.~ o o.D.<.~ V V V o.D.: o o.D.:.:.: V.< VXd.b.b & V o o.D.D &.~ o & & & & o.h o 1.~.<Xd V.D X 1.~X8XX *.:.b.:.:.DXd &.D & V.b.b.:.b.D.#.MXb.( o 1 V.DXd.D V.:Xd.D V VXdXd X.~XdXdXd.DXd 1 o oXd.D.D V o.~ 1 o 1.<.~ VXd.~.: o.(.p o.q j.#X= V.D V.4.D k V V 1 V VXdXd 1.D V oXb t # 1.< V.~ V 1.D VX=.(.p.p.K #.q.e.qXd.9.~ V VX=X8 PX=.e #.K h H @ h.(Xb @ t...K @.K t H h * o.( P B.p o o *X8 h.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O _.:.D.: o sXb @.p 1.$Xz.$ TXz.$X: d TX:Xz TXz T TXzXzXz c c 9.J.J d c.J c.k c.u.Q.Q.c.> 8.@.@.@ 8.@ 8.@.>.u ;.Q.tX3.k c c c c d c c.J. .  QXp.8.8 g.8.8 Q TXMXzXz.J. .J c.J c c c c.u n n n.>.>.@.>.>.>.>.>.>.> f.> f f.> f.>Xm f.u.u x.u.J GXuXu. Xu p p ' 'X7.J r r rX> H D Z.c 3 G.^Xz T T -X:XM -X: | S b Y rX>X> 8X>X>.m D.;.BXz G cXfXgXkXe.g.gX2.!.P.PXOX: T ( M MXMXNXNXN Z.B.B.;X0X3 x v.^ G N 7X: d TX:.J.  rX:X:. X:X:.JX:X:.J.$. .J.$X:. X:X:.  T.  | T. .$X:.  |X:.  pX:.JX:X: p T pX:X:XrX:.$X1 TX: pX: T pX:X:XuX:X:X:.F.F.F.F.F.F JXdXd *Xd *.~XdXdXdXdXdXdXd VXd VXd.rXd V 1.e.p #.( h s.#.~ 1.D.:.4.< 1 1 1.~ V o VXdXd o.p.. #XXX=.~.GXd.D V.:Xd o.(.T @ h h 1.( V.~ 1.( 1 o.p.(X= o o.(.# h h h oXd.e @.M.(.h.(.K @ t o.~ V V oX=X=.~.(X=.(.(.(.(.( R.#.K o V.D oX8.~.M t o VXd.(.< o o H.~ o.( V oXd o o o o h V V.(X. s.(Xd *.:Xd.D V.D o o &XdXd o o V.<XdXd &.:.D * &.:.D V &Xd &XdXd.:.DXd *.<.: & & o oXd.D.~.D.D &XdXd V o 1 oX=.p H HXXXd V 2 V &XdXd VXd V.< &.:.b.:.D.: o sXb @.p 1 VXd V o P VXd.:.D.~ V.D V &.D VXdXdXd *Xd *.~XdXdXdXdXdXdXd VXd VXd.rXd V 1.e.p #.( h s.#.~ 1.D.:.4.< 1 1 1.~ V o VXdXd o.p.. #XXX=.~.GXd.D V.:Xd o.(.T @ h h 1.( V.~ 1.( 1 o.p.(X= o o.(.# h h h oXd.e @.M.(.h.(.K @ t o.~ V V oX=X=.~.(X=.(.(.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.:X0.: V 1.q.M.M.T.$.$X: T.$X: T T T.$ TX: TX: T T -Xz c.J.J.kXz.^.^.u.u n n n.t 6.@.@.@ 8.@ 8.@ 8.@.@.>.u.t n.t.Q.u.u v.^.^.^.J.^.J.J.JX7.N.N.8.NXp.8.!X+X:.R.J.J.k.^ v.^.u.u.u n n n n.t.>.>.>.>.>.>.>.>.> f.>.> f.> f.> 6.> f.^.u.u.u.u v.^.^.J.J.J G.J.J.o.R r r r rX> z ].B v G FXMX:XMX: TX:X:X: | S Y Y r.m rX>.m.mX> ].c ;Xz.J.!.)X-XOX2X2 |X2Xz.yX2X2X: $ ( M bX>.m.mXN ].; ].w.w.;.).! F - p A -.a TX:X:.JX: TX:X:XM.  rX: TX: TX:. X: rX: TX:.$X: TX:X: TX:X: T TX: T pX:X: TX:X:X:X:X:X:X:X:X: TX:X:X:X:X:X: TX:X:.$X:X,.F.F.F.F.F.F JXd * P k oXdXd V 1Xd V.D V.: V.D V.D & V X V.~ o oXd 1XX.#.T.q V.D XX8.( X o.~.D V o.( 1.~ o.e.p.(.(.(X8 V oX= o.q.p.E # t #XX oXd V V.q.(.~ 1.~ 1.(.( *.(X.Xb * VXd.< * o *.e @Xb.TX. hX8 1.(X=.p 1.Y V X.f @ t.( H H.hX8 * oXd.<.h @X=X=Xd VXd V.DXd o.p o.#.p.( o 1 o.~ H.(.~Xd VXd.(.q.q.D & o 1 V o.~.D V V o VXd VXd o o.:Xd o VXd 1Xd.D.:.: VXd.DXd * o.< o.<.DXd o V V.D kXd o V.:.q 1.< oX8 *.<XdXd &.D V.: VXd o.rXd V.:.:.D.D.:.:.:X0.: V 1.q.M.M.T.r o o o.( *XdXd.D V &Xd &.:.< VXdXd * P k oXdXd V 1Xd V.D V.: V.D V.D & V X V.~ o oXd 1XX.#.T.q V.D XX8.( X o.~.D V o.( 1.~ o.e.p.(.(.(X8 V oX= o.q.p.E # t #XX oXd V V.q.(.~ 1.~ 1.(.( *.(X.Xb * VXd.< * o *.e @Xb.TX. hX8 1.(X=.p 1.Y V X.f @ t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.b.:.b.D V V.MXb.M.$.$.$ TX: T TX:.$ T.$ T T T TX:Xz c.J.JXf n n.Q n.Q n n ; n f.@ 8.@ 8.@ 8.@ 8.@.@ 8.@.u.Q.t.t n.Q.Q.Q.Q.Q.Q.Q n n.^ GX7.N.8.N.8 g +.)XM 9.J.u.Q n.QX3.Q n n n n ;.Q Z f.>.>.>.>.>.>.>.>.>.>Xm.> f fXm.> f.> 6 f v.u.u x.u x.u x.u v.R F N.8.c rX> r r.m D Z.BXz GXf T T T T T TX: |X: S Y YX>X>X>.mX>.mX> Z Z i G.!XeX2X2 |XjX: |X0 G.yX5X2 TXM b b SXNX XNX  DXN ] ].w.w.w.w.).!Xg.PXr.o dX2 TXrX: rX:X: c |X:X:X: TX:X: TXuX:X:X: TX:X:X: TX: TX:X: TX: TX:X: p rX:X: TX:X:X:X:X:X:X:X:X:X:.$X:X:X:X:X:X:X:.$X:.F.F.F.F.F.F e o o *.<Xd V o.< oXdXd V & &.: V & X.D 1 1.D V V.~Xd V oXX.# hXd.:.D 1 o.~ V oXd.(X=.~ VXd 1X.X= V.#.#.p.z H h.K.K @.K.p t.pX=.~ V V V o 1 o o.r.~X=.( H o.TXbXd o oXdXd.< o # t # h.( # h o o oX= 1.~ o 1X= 8.MX../ H.q o V o o.(.M t o o V.D.D.D V & o H.~ kXX.(.(.~X8X=.q.( oXd.D o *.< P.~ V.~ o.~.~ V.D.:XdXdXdXdXdXdXdXdXd V.D.:.D VXd.D.:.:.:.:.D.D & o CX8 * o *.~XdXdXd *.~ o o VX8.(X=.( * V V.:.:.:Xd o &.~Xd V VXd.D V.D.:.D.D V.b.:.b.D V V.MXb.MX=X=X=Xd oXd.D.:.<.:.D & VXd.r 1X= o o *.<Xd V o.< oXdXd V & &.: V & X.D 1 1.D V V.~Xd V oXX.# hXd.:.D 1 o.~ V oXd.(X=.~ VXd 1X.X= V.#.#.p.z H h.K.K @.K.p t.pX=.~ V V V o 1 o o.r.~X=.( H o.TXbXd o oXdXd.< o # t # h.( # h o o oX= 1.~ o 1X= 8.M [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.:.b.: V X X hXbXbX:.$ T.$ TX: TX: T.$ T T d T TX:.yXz.J.J n.u n n.Q.Q.t 6Xm.>.> 8.@.@.@.@.>.@.@.@ 8.@.@.@ f.c.t.t ;.Q.u.Q n.Q.Q.t.Q G G.8.8XpXp gXw A.aXMXz G n.Q n n n n.t.t Z 6 6.>.>.>.>.>.>.>.>.> f.> f f.> fXm.> f f fXm.> f f 6.Q.u.u.u.^ v.u v 3Xz N.8.w r r r H.m ] Z ;Xz G.;X: T T T T T TXjX: S Y.xX>X>X>X>.mX>XN ].B i.; 7X  | |X: rX>.wX3 '.!.w.g r $ Y Y rX>XN.mXNXNXNXN D D ].w.w.w.w.)X0.P.P dX1.y. X:X: TX:.  r cX: T.$ TX:X:.  rX:X:.$X: T. X:X:.$X:X:X: TX:X:X:. X: TX: pX:X: T T.$ TX:X:X: TX:.$X: pX:X:X:.$X: |.F.F.F.F.F.F.: * & & & oXd * * &.DXdXd.:.:.b.D.<.: V V.D XXd.4.q.D VXd o *.#X=Xd.D V.DXdXdXd o.z 1 V & V 1 h h 1 *XX.p.p.E.p.. ,.p.pX=.p.eX= oXdXd o V 1X=.( o.(.qX8.q o *.qX= o oXd.:.: @Xb.p.p.(.(.p.K.(.~X=.r V V.p.: 1 I , H.T oX8 1 # o o t.# o.<Xd oXdXd.D &.D o H.( *.L *.( o.(.q V o.q & o &Xd o *X=.q.(.( o o VXd.D 1Xd V o V VXd o 1Xd V.D 1Xd.D & & & V.D.: o 1.~.DXd 1 o P &.~.<.~.~ VX=X=.p o h.( *.<.D &.:.DXd o.~ & V VXd V.~XdXd V &XdXd.D.:.b.: V X X hXbXb.e.~ 1XdXd.DXdXdXd V V XXdXd o o o * & & & oXd * * &.DXdXd.:.:.b.D.<.: V V.D XXd.4.q.D VXd o *.#X=Xd.D V.DXdXdXd o.z 1 V & V 1 h h 1 *XX.p.p.E.p.. ,.p.pX=.p.eX= oXdXd o V 1X=.( o.(.qX8.q o *.qX= o oXd.:.: @Xb.p.p.(.(.p.K.(.~X=.r V V.p.: 1 I , [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd & V.: X V V.~X=.9.$.$ T.$ T T.$ T T.$ T TX: T TXMXz c.JXzX3.c.>Xm.>.@.@.@.>.@.m.>.@ 8.@ 8.@.@.@.@.@.@.@ 8.>.@ 8.@.m.>.@.> 6.u.Q nX3 G G.8.8 g g +.8 gX:XM c.^ n n 6 f.>.>.>.>.>.>.>.>.>.>.>.>.>.> f.>.>Xm.> f f f f f.>Xm f f f f f 6 f f 6 f f.c x.u.u.^.8 NX  r rX> rXN.G.; i GX7 7XM T T T T T TXj T S S rX>X>.mX>X>.mX> ].;.w | | | | r r | |.B F '.wXjX: rX: S.x.x zXN |XNXNXNXNXN D D ] ].w.w.;.w.)X0.!.P. .8XeX: TX: cX:X:X:X:X:X:X:XMXu TX: TX: TX:X:X: T T TX:X:.$ T TX: 'X:X: T TX:X:X:X:X:X:X: TX:.$X:.$X:X:X:X:X:.$X:X:.F.F.F.F.F.F.: VXdXd o 1Xd oXd.<Xd &.: V.D &.:.:.:.:.4.: & 1X=Xd.D V V.r 1 oXb B o X.4.: o.p.E VXdXd X V V o I.( * H.p.K @ t H.p h.K.E.p o.~ V VXd.D V o.(X=.(.p.qX=.( oX=XX 1X= o @ t t.D.( P & oX= o VX=X=.p.....T.(.DXd.DX8.K @ V o V.~ o o V V VXd.< * * oXd & V.D P o.~ o V & *.~ 1 o o.< * * o V.~X=.~Xd V V.~ o o 1.~ o *.~.~ VXd o o o.~Xd V VXdXd V V V.( * * PXX k *.(.(X= *Xd.( *X= o h @Xb / t hXX.<.< o & VXd.D oXd.D.~ o o.~ V V o V.D V & & & V.: X V V.~X=.9X..( o V &XdXdXdXd.: V V V V V.~.~ VXdXd o 1Xd oXd.<Xd &.: V.D &.:.:.:.:.4.: & 1X=Xd.D V V.r 1 oXb B o X.4.: o.p.E VXdXd X V V o I.( * H.p.K @ t H.p h.K.E.p o.~ V VXd.D V o.(X=.(.p.qX=.( oX=XX 1X= o @ t t.D.( P & oX= o VX=X=.p.....T.(.DXd.DX8 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.:XdXd V 1 1Xd o.(.$X:.$ TX: T T.$ T.$X: T T T TX:XzXzXu FX3 f.>.@.@.@.>.@.@.@.>.@.@.>.@.@.@.@ 8.@ 8.@ 8.>.@.@.>.@.@.@.mX8.t n ;.Q x G N.N.N.8Xw.8.8 9.AXM.J c n.t.>.>X8.@.>.>.>.>.>.>.>.>.>.>.> f.> f f.> f f f f f f f f f f f f 6 f f 6 f 6X*.c v x v.^ N.8X> r r r HXN ].c 3.J NX:X: T T T T T TX2X:XM.xXMX> rX>X>.mX>XNXN ] D |X> | rX> rX> ] ;X3X0X:X:X:XM rX>.xX>XNXNXN |XNXNXNXNXNXNX> D ] ] ].w.;.w.).!Xg -X1X: TX:. X: rX:XM TX:X:X:. X:X: TX:X:.$.AX:.$X: TX:X:X:X:X: TX: pX:X:X:X:.$X: TX:X:X:X:X:X:X:X:X:X:X:.$X:.$X:X:.F.F.F.F.F.F J &Xd o oXd.~ o V VXd &.: &.: V.: VX0 V.b.:.D o * 1.: &.D.D 1 V s B.(Xd V.:.pX= VXd V V V XX= 1X=.T VX=.(X= o.(.qX= H.p.e.pX= 1 V.<Xd 1Xd.~.(.(XX.q.q o o.( o.q C.e @.h *.D & o oXd.rX=.( o V.e @ @.p V 1 V X o oX= @ VX= o o * oXdXd o o oXdXd.< V.D V & kX: oXdXd & R * o CX=.q.D.<.~ o V oX8 oXdXd V.~ o.~Xd.~.q o o.<.~ o V V V * * V.rX=.(.(.( k &Xd &Xd.< & o.(.(X. HX=.e H.p.T h.M.( o R k P V o V &Xd.: o & V o.~.q.D V V.~ V VXdXd &.:XdXd V 1 1Xd o.( s #.G VXd VXd V.D V XXd.D.~XdXdXd &Xd o oXd.~ o V VXd &.: &.: V.: VX0 V.b.:.D o * 1.: &.D.D 1 V s B.(Xd V.:.pX= VXd V V V XX= 1X=.T VX=.(X= o.(.qX= H.p.e.pX= 1 V.<Xd 1Xd.~.(.(XX.q.q o o.( o.q C.e @.h *.D & o oXd.rX=.( o V.e @ @.p V 1 V X o o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXdXd.D.D o * *.<Xd 1X:.$.$ T T T T T.$ T TX:XzX: TX:Xz cXu.uX3.Q.Q.t.t.t.t.Q.t.t.t.t.t.t.t.t.t.t.t.t.t.t.t.t.t.t.c.t.t.c.t.t n.t n n.^ G N.8.8.N.N -.gX: T 9 G.u.QX3X0.t.Q.t.t.t.t.Q.t.t.Q.t.Q.Q.Q.Q.Q.t.Q.Q.Q.Q.Q n.Q n.Q n.Q.u.Q n.Q n.Q.u.Q n n.u.u.^ v.^ N F r rX> rX> zX*.c x GXzXMXMX: T T T T TXj |XM.x r.mX>.mX>X>.mX>X>XNXNX> |X> r |X> D.;.B F | r r rXM.x.x.xX>X>XNXNXNXNXNXNXNXNX XNXNXN D D ] ].w.w.;.).!.P. X,X: r.  dX:X:X:X:XM.  r TX:X:X: T T. X: T |.$X: TX:X:.$X:X:.JX:X:.  TX:.$X:X:.$X:X:X:.$X:X: T pX:X:X:.$X:X:.F.F.F.F.F.F ~Xd.<.~.<Xd o oXdXd o.D.D.D V.D.D.:.b X.D.D.:.(Xd o V V VXdXdXd.(.L R o V o I 1 V V.D VXd V o.~.f @ V 1.~.q.D VX8.e.e o.p.qXd.~ 1 o.r.q 1 o o H # o.( o 1.( o V.E.. @ VXd V.<Xd o oXd o V o 1.q.E @.(X=.q 1 1X8.~ 1.K.~ o * * oXd V.D o * * o VXd.D.~.<Xd.1 m R.D.:XsXd.< k.< oX= 1 o VXX o o * o.D VXdXd V o.~ 1 o oXd V.~XdXd.< o o V.~ o h k.D &.b.D.D & &.D.<Xd o PXX P h O.( P R o PXdXd V &.<XdXd * VXd &Xd.<.:XdXd.<.<.~Xd o.~.DXdXd VXd.D.D o * *.<Xd 1.MXb h oX= k.< & V oXd.D.: V & & VXd.<.~.<Xd o oXdXd o.D.D.D V.D.D.:.b X.D.D.:.(Xd o V V VXdXdXd.(.L R o V o I 1 V V.D VXd V o.~.f @ V 1.~.q.D VX8.e.e o.p.qXd.~ 1 o.r.q 1 o o H # o.( o 1.( o V.E.. @ VXd V.<Xd o oXd o V o 1.q.E @.(X=.q 1 1X8.~ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& V V.~.DXd.2 V o.#X, TX:.$ TX:.$ TX:.$.$X: T TX:XMXz.JXu F.R vX3.u.u.u.u.u.u.u.u.uX3.R.u.uXf.uXf.u.R.R.R n.u nXf.RX3X3.u n.RX3X3X3.J.J Q.N.N.R c T TXM 9.X.J v.RXf.uX3X3.u.R.u.u.u.u.u.u.u.u.u.u.u v.u v x v v x v v v v.u.^.u v v v v v.^ v v v.^ v v v N NX0 r r r rX> z Z.B.^ GXf.$ rX: T T T T T | |XM r rX>.mX> HX>.mX>.mX>X>X>X>X>XNX>XNXN.;.B.w $Xn S.x r r |.m.mXNXNXNX> |XNXNXNXNXN DX> DXNXN D ] ].w.w.;.).! ' pX:X: T pX>X:XMX: ' T TX:X: T TX:X:X:X:.$ TX:X:.$ TX:X:X:X:. X: rX:X:X:X:.$X: TX:X:X:X: TX:X:X:X:.$X:X:X:X:.F.F.F.F.F.F ~ o o * * o 1 o V.~.< V.DXd.:.D.b.4 V 1 X 1.~Xd V V.D.~ oXd.D V VXd V.h I.~ X X.f 1 oX= o.G @.h ,.p * V.G X V 1 o.p.p h.p.e o.p.h 1 X V.~X=.p o o.q.~X=.E @.`.K * o o V VXd VXd o H.( o.<Xd 1X= V VX=.f 1 * o o.fX= >XdXd o * 1.( & &.< hXX.X P o.~.T.h PXX o.~ V VXd.<XX.( * k E j o o oX=Xd oXdXdXd o.<.~XdXd oXd o.<Xd &.DXd.D.DXd.D k.D.D &.D.b o &.: &.: V V o & o V.D VXd &.~ VXd o VXd o.D.D.DXdXdXd &.D.D &Xd.D.D.D o o.~ o.q o VXd.~ V V.~.DXd.2 V o.#Xb ..MXd.(.(XdXd &Xd VXd &.DXd o V o o * * o 1 o V.~.< V.DXd.:.D.b.4 V 1 X 1.~Xd V V.D.~ oXd.D V VXd V.h I.~ X X.f 1 oX= o.G @.h ,.p * V.G X V 1 o.p.p h.p.e o.p.h 1 X V.~X=.p o o.q.~X=.E @.`.K * o o V VXd VXd o H.( o.<Xd 1X= V VX=.f 1 * o o.f [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& 1 oXd VXd * V * m.$X:.$ TX: TX: T T T T TX:X: TX:Xz.w QX7 N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N NX7 N N GXu.8.).XXM T 9X+ 9 T.wXu N N N N N N N N N N N N N N NX7 N N N N N N N N N N N N N N N N N N N N N N N N N NX7 N N N N.8 ] r rX>X> H z Z ;.^ GXe T T T T TX: T TXj | r r rX>X>.mX>.mX>.mX>XN.m.m.mX>X>XN.mXN ZX0 S b S.xX> |X>XNXNXN.m HX> zXNXN |XNX .mXN DXNXN |XNXN D ] ].w.;.;.P '.yX:X:XM. . Xu d T TX:X: TX:X: T TX: TX:X: T TX:.$X:X:X: rX: pX: TX:X: T |.$X:.$X: TX:X:X: TX: TX:X:.$X:X:.F.F.F.F.F.F.:X=Xd k *XdXd *.<Xd.<.DXd.D V.:.D.: oXd h.pX= V V V X V.~Xd.~ V o *.(X= 1 1.D.4.~X=X8 C 1.p.h.p.e.pXd 1.( o o o V VX= #.p.e.(.e @ V.D XX8.e t o.(X= @ @ @.(.q o.~ o.< o V VX=X8.(.(.q o o o o.( C V o.K H.(.~.~.. #.p o V V.( oX=.D & & oXX *.#XX o.#.#Xd o o.D VXd oXd &.( V o k.(.( o o oX=.~ * VXd VXdXdXd.<Xd o oXd.D.D VXdXd.D.b.b.:.D.:Xd VXd *.<.DXd.<.D *.D.:XdXdXd VXd.: o o o * 1.D.<.:.D.< &.<.<.:Xd.:.: V.:.:.DXd o VX=.( o 1 1 o 1 oXd VXd * V * m.[ ..v o oXdXd.DXd.D.:.D VXd V.~.~X=Xd k *XdXd *.<Xd.<.DXd.D V.:.D.: oXd h.pX= V V V X V.~Xd.~ V o *.(X= 1 1.D.4.~X=X8 C 1.p.h.p.e.pXd 1.( o o o V VX= #.p.e.(.e @ V.D XX8.e t o.(X= @ @ @.(.q o.~ o.< o V VX=X8.(.(.q o o o o.( C V o.K H.(.~.~.. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& o V o VXd o P.# ..$.$.$.$ TX: T T T.$.$X:.y TXz.y.y c 7.g 7 7 7 7Xm c 7.J 7Xm 7 7.g.a.g 7 7 7 7.a 7 c.aXm 7 c 7.a 7 7Xm.a 7 7 7 c 7 7.X T T T T T T T TX: 7.y 7 7Xm.a 7.a 7Xm.a 7 7.a 7 7Xz 7 7Xz.} 7 D 7 7Xm.a 7 7 7Xm c 7XmXm 7.aXm 7 7 7.w 7.w.g DX  |.mX: r rX> HXNX* ZX3 G N | T TX: T T T TX: T 7 r r r r.mX>.mX>.mX>.m.m.mX>.mXNXN H H H zX> ( b.xX>X>XNXNXNXN H HX8 z zXNXNXNX XNXN.mXN DXNXNXN DXNXN D ].w.; iXz.o.)X:. X: TX:X:X:X: T | TX: TX:X:. X: TX:X:X:X:X:X: TX: TX: pX:. X:X:X:.$.$.$X:.$X:X:.$X:X:XuX:X:X:X:X:X:.F.F.F.F.F.F.: * V &.D P.<Xd.<Xd & & VXd V.~.:.4X=.: # @ /X= 1Xd V VXdXd V o o.p I VX= 1.:.4.c oX=.fXd V.: h I.K 1X= h.( o 1 V V o.p.p.pX=.(.p.~ V.r @ # @ 1X=.p.MX..( o o.q.< o *.~ o.~X=.qX= o o.< o o V o o.~.r.(X=.(X= o @.E.K * V o o.(X8XdXd.DXd.<Xd *.(.=XdXdXdXdXd V.DXd VXd.D &Xd V.DXd *Xd.< o *X8 hXd VXdXd V.D oXd VXdXd V V V o V &.:.:.: &.:XdXdXd VXdXd VXd VXdXd V k VXdXd.<.< o *.~ o * o oXd &Xd V.<.q V V.4.D V V.: & VXdXd.q.(X=.~ V.~ o V o VXd o P.# . mXb.v # o 1 V VXd.: V VXdXd.~ o o * V &.D P.<Xd.<Xd & & VXd V.~.:.4X=.: # @ /X= 1Xd V VXdXd V o o.p I VX= 1.:.4.c oX=.fXd V.: h I.K 1X= h.( o 1 V V o.p.p.pX=.(.p.~ V.r @ # @ 1X=.p.MX..( o o.q.< o *.~ o.~X=.qX= o o.< o o V o o.~.r.(X=.(X= o @ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd VXd V V V kXXXX.XX:.$X:X: TX: TX:.$ TX: T T.y T.yXMX: - T T.$ T T.$Xz.$ T T T T.$ T T T T.$ T T T T T T T T 9 T T T T T T T T TX+XM T T T T TXM T TXM T T T T T $ T TXM T TXM T TXM T T T T TXM TX+XMX: TXM T T T T T TXM TXM T T TXn T T T T TXj | T $ S.x r r r r HXN.G.c x G.R T TXMX:X:XM T T T r.gX: r rX>X>.m HX>XN.mX>.mXN.m H H H H zX*.x ( ( S r |XNXNXN H HX8.G.c Z zX XNXNXNXNXNXNXNXNXN DXNXN DXNXN z ] ZX0.!.JXw.XX:XMX: | TX: T.$ T.$X:X:X: T.$X: TX: T | T T TX:X:X:X:X:Xu TX:X: TX:X:X:X:X:X:X:X:X:.$X:.$X:.$X:.$X,.F.F.F.F.F.F.:Xd k o o.~ V V.D.:.:.: &.D.b.:.: 1X= oXd.:.:Xd.< o.( 1 V 1 o.~.p.~Xd 1 o hX= o.:.4 V XXd V.~ 1X=.K oX=.~ oX= oXd V.D I.p.e.E.p , @ @ t t.. @ #.`.(X=.(.p * &.D V.( *XdXd V.p.p h o *.<.( o o o.rX= o o.q VXd.(X= I.p.< o o V.e.(XdXd oXs.:Xd.DXdXd & & V.D oXd.D VXd &.:.D o o &.D &.~ o.eXX V VXdXd.< o VXd V X.r o V V oXd.< * &.D.:.:.D.: VXdXd.D.b & &Xd &Xd oXd o o.D * * o o 1.<Xd V oXdXdXd.b.:.D.D oXd V &.:.D.:.:.:.b.D.D V V.: V V VXd V V V kXXXX.XX: m.L h hX=X..M O V o.~ VXd V.~.~Xd k o o.~ V V.D.:.:.: &.D.b.:.: 1X= oXd.:.:Xd.< o.( 1 V 1 o.~.p.~Xd 1 o hX= o.:.4 V XXd V.~ 1X=.K oX=.~ oX= oXd V.D I.p.e.E.p , @ @ t t.. @ #.`.(X=.(.p * &.D V.( *XdXd V.p.p h o *.<.( o o o.rX= o o.q VXd.(X= [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.D.: V.D &Xd PXd.<.$.$.$ T |.$ TX, T.$ TXz T TX:XM TX: T.$XzX:.$ T TXz.$ T.$ T T T.$ T.$ T T T T T T T T T TXzXMX: T T T T.$ T TXM -XM T T T $ T T T T T T T T T T T TXM T TXM TXM T T TXMXM TXMXz 9Xz 9 T TXM T T T T T T T TX: T T TXn T T T TX2 TXM S S r rX> H rX> z Z ;.^ G.X T T T TX: T T TX:X: r.w D |XNXN z z z z.G D z.G.G.G.c.c.c Y M M Y rX>X>XNXN.m z.c ; ;.^.^ v.c ] ] ] zXN DXNXNXNXNXNXNXNXN z D z DXN.c i.R '.8 r TX:XM TX:X:X: TX:X: | TX: T T | T T TX: T TX: TX:X:X:X:. X: r.J | G G.J.J '. X: TX:X:X:X:X: TX:X:.F.F.F.F.F.F ~ V * * oXdXdXd.D &.D.: VXd.D.:.D o I.p.4.b.:.: V.p h.qXd V.~ oX= VXd V V 1.( o V.Y V V X 1.( o.f.p o.q.r.q o oXd V V H @.E @ @ @.p.( h 1.p.p o V.~X=.e.p o.:.b & VXd o o oX=.p #.( P.q.< o o 1.qX= o o.r V V 1 oX=.( o.~ o.D * h 1 1 oXd.(X=Xd o.< & V V.DXd oXd V.D V.: V o o.:Xd.: V.( PXd o V.DXdXdXd.DXd.D.:.D &Xd * o V.<Xd &.D.D.:.D V & &Xd.D.: V.D V.DXd o.~ o.<XdXd o o P *.<XdXd.< V VXd V V V V *.<.:.D.: V.D X.D.:.D.:.:.:.D.~Xd.D.: V.D &Xd PXd.<.~ R R.# #.E * oX= oX= oXd V.D.D V V * * oXdXdXd.D &.D.: VXd.D.:.D o I.p.4.b.:.: V.p h.qXd V.~ oX= VXd V V 1.( o V.Y V V X 1.( o.f.p o.q.r.q o oXd V V H @.E @ @ @.p.( h 1.p.p o V.~X=.e.p o.:.b & VXd o o oX=.p #.( P.q.< o o 1.qX= o o.r V V 1 o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXdXd.:.b.:.D & 1 VXd |.$X:.$ TX:X: T.$X:X: dX:X: T TX: T T TXz TX:X:XzX: TX: TX: T T T T T T T T T T T T T TXM - T r T T T T T T T r 9XMX:XM TX: T TXn T TXM T T T T.A T.$.A T T TXM T T T TX:XMX:XM 9 -XzXMXMX: T T T T TXMX: TXM T T TXMX:XMX:X: |X:XM S S HX> r rX>X8 z.c x.J.R r TX: T TX: TX: T T T.$Xe.;.} ] D ] ] ] Z ] Z Z Z.c.B ;X3 i M M ( r |XNXN.mXN z Z ; x.^.^X0X X0.B Z ] ] ] D z zXNXNXNXN DXN DXNXNXNXN.;X0X3Xz Q 7 T T |X:X: T TX: T T.$.$X:X:X: TX:X: TX:X:X:X: TX:XMX: TXuX:X:. X:X:X:X:X: TX:X: TX:X:X:X: TX:X:.X.F.F.F.F.F.F J XXdXdXdXd.D V.DXdXdXd VXd.:.:.D o.~ 1X0.:.D V V.pX= 1 1.< o.p 1 V V V.~ V I.~.D o.~ V 1X=.~X=X=.e o.~ 1 o o V.~ o 1 @ t @ t @.EX=.(.( 1.e.h.~ oX=X=.p.qXf.*Xr.iXd.D * o oX=X8 hXdXd.~ o V VXd o oXd W U o o.<.~ o.~ V V oXd o H o.r oX..# o VXd o.<Xd & VXd.(.D V o & PXdXd o.< o V V * & o.* J X 1Xd.D VXd.: &Xd.D VXd * P oXd V &.b.b.D & & V.D VXd.< VXd V.b.H L UXd.~ o.<.<.~.<Xd o VXd V.:.< X 1XdXdXd.~ V.:.: oXdXd &.: V.D V.:.b.D VXd.:.b.:.D & 1 VXd.: V *.h h..X=X=.~.~ * o VXdXd.DXd XXdXdXdXd.D V.DXdXdXd VXd.:.:.D o.~ 1X0.:.D V V.pX= 1 1.< o.p 1 V V V.~ V I.~.D o.~ V 1X=.~X=X=.].*XyX9 o o V.~ o 1 @ t @ t @.EX=.(.( 1.e.h.~ oX=X=.p.q.< o.<.H L d * o oX=X8 hXdXd.~ o V VXd V.* UX<.* o o.<.~ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.:X0.b.-.D k.b.D VX, d.$.$ d.$ T. .$ T dXz d TX: d T.$ d T d - T T cXM T - T T TX:Xz T T - T T 9.$ T 9 T TXz - r 9XM 9.$ T 9 T T 9XzX:Xz TX:.P T T 9 T.P T T 9XMX:.P T T 9 TX: 9 T T T 9 T.PXM rXzXz 9XzX: r.P T T 9X: T - T T.P.n 0.$ T -XMX:.) | TXM S.x r rX> H r.m.G.t.^ G.w - TX: - T TXzX: T c T T T.w i.;.c.; Z.c.c.c.B ; 3 3 v.^.)X> M (.xX>.mXN.m.m.mX*.t ;.^ G.} T cX:X0 i.c Z ] ] D D z DXNXNXNXN zXN DXN D ].cX3XzX7Xu.$X:. X:X: d | T. X: T. X:. .$X:.  TX:. .$ TXu.$X:. X: rXu T pX:X:. X:XM pX:X: pX: T. X: TXrX: |X:.F.F.F.F.F.F.:Xd 1 o P * o o.~Xd V.<Xd.D.D.DXd V.4.~X0.:.D V VXiX<.{X9X9.,.i.i oX= *.: V.(.EX= X.GX=.e.(.~.f o.~Xd.< 1 1 V VX=.. t.hX=X=.e t.MX4X# h.p.~.DX=X=X=X8X=.p.H.3   }XdXd oX8.( @.p.(Xd 2 o.( o V * ~ '.{  X#.< 1 1X0X<X# }., V.D V.<.i.,.+., L.~.D.< o.3       a.<Xd.DXd &.:.b.<Xd.< V oXd d.,    .: &Xd k.H.,.,X<X< &.:Xs.:X9 y }.,.HXd.D JX< yX<.U.H.D.:.DXd o V L.3   -Xd o & VXdXdXd o.( o.~Xd o o V oXd V.DXd VX<X#X<X9 y }.i.:Xd VXd.D.D.:.:X0.b.-.D k.b.D V V.~ & V #.KX. * 1 oXdXd W a., V oXd 1 o PX9X#X9X9X<X< dXd.D.D.DXd V.4.~X0.:.D V V VXd o o I.~.p.~ oX= *.: V.(.EX= X.GX=.e.(.~.f o VX9  X# 1 V VX=.. t.hX=X=.e t.MX8 h h.p.~.DX=X=X=X8 U   U l L.3  .* oX8.( @.p.(Xd 2 o.( o V *.:.y     o.< 1 1.D [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2X0.b.:.4.D.<.:.: V.$.$ T T.$ TX:.$X: T.$ T cX: T T T.$ T dXMX: TX:.y TX: T.$ T T T T.$ T T T T T T TX: T TX: 9 TX: TX: T T.$ T TXMXzXM.$ TXM T T T T T T TXM T T T T T T T TXM T T TXMX: TX: T T TXMXzXzXMX:XMX: T TXM T T T T.n d.FXr.P.gXj TX2X:XM S S $X> HX> rX> z Z ; G FX:X:X: TX: T TX: T T TX: T T T |Xe.R.R F 3 F v.^.^.^ FX0.) | T b Y r.m.m.mXN.m D Z ; 3 GXzX:X: TX:X: |X0.R.B ZX* ] z DXNXNXNXNXN D zXN D z.BX3 v NX0 TX:XMX:X:X:X:X: T TX:.$X:X:X: TX:X: T.$X:X: T TX:X:X:X: T pX:X:X:X:X:X:X: TX:.$ T.$ | T |X:.$.$ |.F.F.F.F.F.F.:Xd.~.(.q *.<Xd o XXd oXd VXd V V o V o.b.:.D.DXy  .{ V # oXi   ~X= H 1 V.D 1X8 I 1X=X=X= o VX=X= V VXd.< 1 o 1 @.M.M o.~ o.K t.M.5.5X  h.~ V o o o.(X=.q.<.{  Xv.<Xd oX= h #.# y V k o oXd.D o V oX#  .i.~ V W a a P VX@.W 1 o U   VX=Xi   U.K V.*.{X#X@X#X< oXd.b.D.D.DXd V &.:X=.( & &X9  .,Xd.: & W a.3Xd U   0 &.: y.{XdXdX<.3Xd o y.{.D oX<.3 &.D.: o.~Xd oX#   VXdXdXd V oX= VXd * o o o.~Xd 1 o o.D V V }   W VXd.H  Xi V.:.DXd.D V.DX0.b.:.4.D.<.:.: V 1 VXd VX=.q hXX o.q.< V [   a o oXd.~.(.i  X0Xd o.*   WXd VXd V V o V o.b.:.D.DXiX9.: o # o V o.(X= H 1 V.D 1X8 I 1X=X=X= o.*X9X= V.i  .+ 1 o 1 @.M.M o.~ o.K t.M.p #.# h.~ V o o o.(.i  .+ &.<X#  Xd oX= h #.#.# o k o oXd.D o V.*  X# o.~ V V V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.:.b.b.- &Xd.D V V.$.$.$X:X: T.$X:.$ TX: T T cX: TX:X:Xz.$X: T TXM.yX: T.$ T TX: T.$X:X: T.$ T T.$ T TX: T T - T T T T T T T TX: TXz T T T T T T T T T T T TX: T T T T T T T T T T T.$ T T T TX: r T -XzXzXMX:XM TX: T T TXj.a.nXg.P.P d d.F.PX2XnXM S S.xX> r rX> H.G.c.^ G.;X:XM r T T T T T TX:X: T T TX:XMX: r |.w 7.w D.w.JX: rX:X2 |XM S.xX>XNXNX>XNXNXN.c.c x GXz rX: T.$ TX:X:XM.D i.B.; ] DXN.mX> DXN DXN DXNXN ; ; vXuXfX:X:X:XMX:X: T TX:X: T.@X: TX:X:.AX:X:X: T TX:X: TX:X:X:X:. X:XMX:X: T TX:X:X: TX:X: TX: TX:X:X:X:.F.F.F.F.F.F J V o *Xd.D V.<.r V.< kXd o VXd V oXd k.b.:.D L   a.;.qX=.(.~.,.e.(X= 1 V.: oX=.M V 1X= 1X=X=.~ o oXdXd *.~ 1X= t.MXX o o o # @.~ V P h.( o o o o.( o.~.< J    .D P o.r.p t P UX#.D.~.D VXd oXd o o    Xi.<.bX<  .+ tXdX#   V VX#  .: o V  .i.M.KXpXd o 1 o * *X=.<.:.b.:.: VX0.:.( * V.<.{  .iXd.DXd }  X9.D -  X<.:.:  .{.D VX9   V *  .{Xd *X9  Xd.:.:.D.DXd.~  X#Xd V o.<Xd.~.qX=.<X=.~ o.~ o o.h.qX= 1Xd.D a   W V.DXdX#XdXd.D.D.:Xd.:.:.:.b.b.- &Xd.D V V oX= o oXd o h.#XXX=.(Xd oXi.Z.<Xd V o * a   W.<.r V.W kXd o VXd V oXd k.b.:.D.:.{Xy.<.qX=.(.~Xd.e.(X= 1 V.: oX=.M V 1X= 1.].{ U o o.,  .H.~ 1X= t.MXX o o o # @.~.pX. h.( o o o o.( o.~.P &.DXd  X# o.r.p t P.h.p.D.~.D VXd oXd o.i  .i.~.<.b 1 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.:X0.bX0.DXd.: &XdX:X:X:.$ T.$X:.$X:.$ T T d.$ c dXz d.$ TX: T TX: cX: T d TX: TX: T T T T T T T T.$ 9 T T TXz T T.$ T T TX: T T - 9 T T T T T T T T.$ T T T 9 T T T T T T T T T T T T T T.PX: T T T rXzXzXM T T T T T T.! | |X2Xe.)XkX5X5.PXgX: T S S S rX> r r H H.G 3.kXzX: r.y TX: T.$ TX: T T T TX:XMX: c TX:X:XMX: rX: TX:.y c.y.) |XM.x rX>.mXNXNX>XNXN Z ;X3 GX7Xe T.$X: T T rX:X:X:.)X0X0 ]X>X>X> rX XNXNXNXN z.cX3 v N NX: TX:X: T TX:X:X:X:X:X:X: dX: TX:X:X: TX:X: T TX: T rX: p rX:X:X:X: TX:X:X:X:X:.$X: pX:X:X: TX:X:.F.F.F.F.F.F.V.D &Xd o &.D &.#.6 RXd &Xd.b.: V.: o.~ & V.V    .i.~.~.~ V.<.HXX *X8Xd 1.< V o V.*.iX9.4X9X<.* oXyX9X< 1.. L.i.( o o.q 1 V @XrX9X<.*.TX= o V.p o.~ oXd V L  X#XdXyX#.i 1.(.i  X9Xd V.< o VXd.~ o U  .3 * o o a  .* o.:    .* o.,  X# VX< a eXd ~  .{.i V oXd.: P k &.:.D.:.:.Y.< oXdXdX0     eXdXd.D a  .* V.+  X#.b & a  X9X0 aX< *Xd a  Xr.: aX<Xd.D.:Xd.DXd.P  X9X<X#.H.~.*.+., VXdX9X9X=X= P o.~ oXd o.q o a  .{.V &Xd.D.:.P UX<X<Xf &.D.:X0.b d }X9 ~ }.,.P &Xd V o oX= # sXX.*X9.+., o.:.:.D &Xd a  .{.V.#.6 RXd.H.*X<X<Xi.: o.~ & V.H.{   o.~.~ VX<.U.H.i.HX8.*Xy.+ W.*.,.iX=.f.4.{   W oX= a   1.4X<Xy.( o o.qXyX# U dX9 1XoXrXy oX< L o.*X9X9., VXd.*  X9X9X# [.( e.*X9X9Xi.< o VXd.~ o.{   ~ * o o * o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.:.b.:Xd.DXd.D VXdX,.$ TX:X:.$ T T TX:.$.$ TX: T.$ T T T.$ T TX:.y T T T TX: T.$ T T T T T T T.$ T T TX: T T -XMX: T T T T T T T T rXz T T T T T T T T T T T TX: T T T T T T T T T T T T T TXM T T T TXzXzX:XMX: T T TX:X2.$ T |X2X2.a.wXe.)X2 $XM 4 Y.xX> r rX> H H.c.^.^.DX:X:XMX: T T TX: T T TX: TX:X:X: TX:X:XMX:X: T TX:XMX:X:X: | | T r rX>XN.mXN.mXNXN Z.c iXz Q.N -.g.$ TX:.$.a 7Xe.nXe 7 |X: rXMX>XN DXN z D ].B 3.^ G.}X:X:XMX:X: TX:.AX: TX:X:X:X: rX: T T TX:X: TX:X:.$ TX:X: TX:X:X: rX:X:.$ TX:X: TX:X:X: T TX:X:.$X:.F.F.F.F.F.F ~XdXd o k &Xd.D * R &.D.:.b V.~ o.D.~ o.D.:X<     VXd o 1 R R *.:.:.H.,X<X<X#.* oXi  .5X<.i  .3 V V a  .].M     oX9X#.{Xy.3X# t    Xd tX=X9.{X9       1 oX<  X9X9X9    .p U.5  X#X9 V o o V.< V oX1  X< o.(X=    X=.rXr     o V.*     aX<Xd P VX<      .3 V.<.D.q V.:.D.:.: VXd.D.<Xd o U  .3 P o.DXd    XdXd.,   }.: V }    X# d V.<.<X9    .{Xy.~ &.:.D &Xd o.i  X<X9  .3 o oX#   U o a  X=.qX= o o.~.r.< VXXXy     aX<.DXd.:.H.,  .3.D V a   U.:.i  X# }.,  .3 V o.(Xy.,X9.3 { O.#X9  .,Xd V VXdXd oXv     aX9 R &.D.*.,  .3 o.D a  .P.:.{   aX#.H V.{ y k a   U *.i  X#XvX<     t.pX#  .5X#.*.*  X#Xl L     o 1.:X#.3XfXv  X#.r U  X#X=.{   V.rX9  X< V.<X9  X<X9  .3.( e.,  .3 V o a  Xf V V  .3.( o.(X=.( 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd V V.DXd VXd.: &.DX:.$X:.$.$.$.$X: T.$ T T TX: T TX: T.$ T TX: T d T TX: T T.$ T.$ T.$ T T T T TX: T T TX:XM -X: T T T.$ T T.$ T T T - T T T T T T T T T T T T TXM T T T T T T T T T T T T T T TXMX: TX:Xz - - 9 - T TX2 T T 4 4 rX: | |X2X2 |XM S Y Y r r rX> H HX8 ;.k vX: rXMX:XMX: T T T T T T TXMX:X:XMX:XMX: TX: T T TX:.$ rX: rXj | T r rX>XN.mXNXNXNXN ].c.B.R cX7.%.o =.P.PX5.PX5XkXeX2Xj T $ ( Y.xXNXNXNXNXNX* ; 3.^ G.a rX:X: TX: TX: TX: TX:.AX: TX: TX:X:X:X: TX: TX: TX: TX:X:X: p.J p T T.$X: TX: TX:X: TX: T.$X:X:X:.F.F.F.F.F.F ~.< &Xd oXd &Xd *XdXd.b.b.:Xd.<Xd V.(.: &.b.3  X@ V V V P k o * VXr  .i 1X=  .3X= [  .5 o @    .~.qX<  .HX.X9.{ o.*  .W U.,.5 P  .3.K.MX9   L o     o V o a  X<.HXi  X@ OX=.s   o.~Xd V.<Xd o oX=.{   UX8 *X=.W   JX=X@  .{ o 1 W.,.5  .{.:.D VXd V.i.5  .+Xd VXdXd.DXd V 1Xd.D 1 oX=X=X<   } V.q &Xd.{  .: W    XvXsXd.i.3   a.* &.: & U.{    .* o.D.: &.D VXd.{  .*Xd    .~XdXy  X9Xd.i.{ *X=.(.(X=.~ oXd.( o o.* a    X#X0.:.DX@  .i.:Xy  .3 V.D L  .{.: &     * *X< a.Z.~  .3 B $X<  .iXdXd V.< &Xd o U a    X#.:.b.bX#  XrXdXy  .3 &.b d   } V VX#   & o   a.D o L  .,.*.H  .3 h.M U   L 1.~.i  ., U *  .{ o.~.,  .* 1.i   L o.K.5.3.q.:X< o.~X<  Xy VXd.{  .*X=    X=.K.,  .iXdXy  .3 o o U  X<.qX8 *X= H V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXdXdXd.<.:.D * 1 o o.$X:.$X: TX:.$ T TX:.$X: d TX:X:X: TX: TX: T T.y T T TXzX:.$.$X: T TX: T TX: T T T 0 T TX:XzXMX: T T T T T T T - TXz T T T T T T T T T T TXzXM T T T T T T T T T T T T T 9 T TX:XMX:XM -XMX: TX: -X2 TXn 4 ( b r r r |X: |X: b b b SX> HX> H H H.G.^ GXm T TX:.yX: T T T T TX: T T T T TX:.yX: TX: r.$X: T T T T T TX:X2 r r rX>XN.mX>XNXNXN z Z.;X0 i - -Xr d.P.PXgX5.nX-XOX2 | T M ( b rXNXN D z z Z n 3 G.J.JX: TX: TX: T TX: TX:X: T TXu TX: TX: T TX:X: TX:.$X:X: r.J p rX:X: pX:X:.$X:.$X:X:X:XuX:X:X:X:.$X:.F.F.F.F.F.F ~Xd o &.D &.D & * *.D & &.: V.~ 1 o * o.e.q    X< V kXd V o o o U  .3 o.~.*     o.i  X<X. e  .3 , @ U  X9 o., L V.i  ., V ~ WXy  X< 1.p     V.*  .3.r o ~    X9 oX<   U IXi  .{ * o o 1 o o *.( 2    .: o.( o.4X#.3X#     U.(X9.{ o ~ a  ., VXd o o.<.i  .,.q o                X9XdXd V.3  Xy.<Xd oXd.*.3.{.3  .3 &Xi.3 L J.{  X#.D.bX<., oX#  .{Xd.<.~ V.D &.:  .3 o V  .3.< * W  X#.~.iXy * oX=.q.( o o o VXdXd.:.;.,     y.D J    X0 V.,  X9Xd.<.,  Xy 1Xi  .3 V L   } VXi     o h.{  Xi.~ V VXd o &.D &X0.U     y & J     V 1X<  X9.e.q.,  Xy VXv  X< o.*  ., V VX<  .,Xd.i  X< 1 VX<  .*X= ,.,  X<Xd.i  X< V.*  X# V.:.{  .4Xd 1.,  .( W.* oX=Xh   e.~.c  .3 o o  .3 o V     V oX<  X9 *.(.+   UXd o.( oX= 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd V.:.D V V.# k.<XdX,X:X:X:.$ T.$ T.$.$.$.$ TX: TX: T.$ T.$ TX:X:.yX:X:X:.$.$ T T TX: T T T T T.$ TX: TX: TXM -X: T.$ T.$ T.$ TX: TXM - T T T T T T.$ T T T T T T T TXn T T T T T T T T T T T T T T TXM -X: 9X: TXM | | T $ b M bXM r r r r rX> b b b.x rX> H H HX8.c.^.Q | T T T T T TX: TX: T T T TX: TX:X: T T T TX: TX: T TX:.$ TX:X:X2 | r rX>.mXNXNX>XNXNX> Z.w.;.;X0.!X5.!X5.n.nXeX-X2X2 |X: S ( M S.m D z z zXN.B ;Xz.^.RX:X: TX:XMX:X: TX: T TX:.$ T TX:X: TX:X: TX: TX: T TX:X:X:.JX:X:X: rX: ' rX:.$ TX:X:X:X:X:X:.$X:X:.$.F.F.F.F.F.F J o &.D & &Xd.D h R.<Xd lX0 VXd.4X=.(X=.~ V    X<.<Xd V.rX=X= oX#  .i.~ V.i  .{X=.,   U o d   L.M.MX;  X#.4.3.D.~X#  XyXd V.DX<  Xy VX=.3  Xd., a.4.qX= L  .3 V.]     VX=X9  .i o oX= o o o o.e.i  .{ 1 o o o.KX=X=X#  ., t U  X0XX.(.*     & o.( R.D o  ., * o.iX9X9.iX<X<X9.+.*.:.<.H     JXdXd *.D VXd U    .*Xd.3.,Xd V U     &Xr   eXdXi     VXdXd &.<.: L  X9 o U  X9 * *.r    .~X#Xd * *X8 o o o oXd VXy.<.~Xd o.i    .D.i  .U.:.V    .*.:.D.3  X  k.+   } &.{   U.DXy  .{X= W   aX8.~ VXd o & d & &Xd.DXy    Xd L  .,Xd.*    .4.~ V   a V.<.,  .yX=X9   LXd V.3  .* oX#   U VXd  .5 t t O    Xf V.{   d.~.,  .iXdXi  .{ o V VX#   ^X9 o oXt  .{.q o L  X9X8.*  X9 oXy  ., oXt    Xi o.e.3   V 1 o o o.KX= [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2 &.:.:Xd * B.L.< V.$ T.$ T.$X:X: TX: TX:X:X: TX: T.$X: TX:X: T T dXMX: TX: TX:X:.$ T T.$ T T.$ T T T T T TX:XzXMX: T T T T T T TX:X:Xz TX: T T T.$ T T T TX:X:.A.$ T T T T T T T T T T T TX:X:XM T TXz T TXM TXMX: |Xj rXn b ( Y r.xXM r r r r b ( YX> HX> H H H.G ;.^.a T T.$X:X: TX: TX: TX: TX: T T T TXMX:X:X: rX: TX: TX:XM T T TX:.w | r rX> |.mXNXNXNX>XN | ] Z.w.w.w.;Xe.wXe.wX2X2X  |X: TXM $.x rXNXNXN zXN D ; 3.^.J.; T TX:X:X: T T TX: T TX: T.$X:X: TX: T TX:.AX: TX: TX:X:.J |X: T.$X:X: r pX:.@ T.$ TX:X:XMX:X:.$X:X:.F.F.F.F.F.F.:XdXd V &Xd &XdX. * *Xd.:.b.D V.:.q.~ V.D.:.,  ., * o.<Xd o.* o    .: V V.3  Xl.e a a.D V.{.5 O t * V   aX<Xy o ~   a.D V.: V.3   VXi 1XkX< L.i W.q o oX#  X9 V L  X<.ZX=.{   W VX= o o.( * VX=.,  .iXd V.~X=.p oX9  .{ V.( '  .( P o.D  .3.<.VXd *Xd.;  Xr.~ o o VX= k.D &.:.DXd.: o.i  X# 1.D.D o V * V a   L.DXd  .+XdXd.D   a.: }   * o V   a.D.<Xd V.:.D }  .*.~X< a VXd * oX#  X<Xy.~X=X= o 1XdXd o V &X# W.~ 2Xd &   a.D.,   d.:X#  .3 &.:Xi  ., B.L.3 a W.D    .V.DX<  .  VXr  .,.q o V.~XdXdX# JXd &XdX.   aXd.,   d VX#  .3 V.DXy   yXd *    .: o.3   W 1.V  .3 V V    .q V d  X9 h.MXi  .{Xd W     VXi    X0 V.,  X9 o.~.:X#  X< ^ V V U  X9.Z VX<  Xi #X< a.]X=.,   UX=X#  .3 * V.4  X#.( ~ V.~X=.p o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2 VXdXd.:.: V.L o VX,X:X:X: T.$.$X:.$.$ T T d T.$X:X:X: T.$ TX:.yX:X: T T d TX:.$X: T TX:X: T T T.$.$ -X: T TXzX: T T.$X: T TX: TXzXMXz T T T T T T TX: TX:XM - T T T T T T T T T T T T T TXz TXMX: T -XMX:X:X: T TX2X:XM $ S SX: rX> r r rXM r S Y rX>X> H H H.G ;.^Xm T T T T TXzX: T T TX: T T T T TX:X: TXzXM TX: TX:XMX: T TX:X:X:XM.aX2 rX>X>.m.mXN.m.mXNXNXNXN ] ] ].w 7 DX2X X2X  | | |X> | r.xX>XNXNXNXN z z Z 3Xz.JX0 T.JX:X:.AX:X: TX: T T.$X: TX:. .AX: TX: TX: TX:.$X: TX:X:.J.JX:.$X: TX:X:.J T.$.$X:X: TXuX:X:.$ |X,X:.F.F.F.F.F.F iXd.DXd &.< o P *Xd V.D & V V o I V.:.: V VXi a  .i 1 o U., ~ o.3  X=X=.i  XyX= W  ., @Xy  .H t.K o V.{  X#.D.: L  X< V.:.D W  .{ U U o.3.3 0 [ V 1.( V    Xi C.,  Xy L V  .5.V UX8.pX= o o.r.]    XiX=.(.p.K.q.i  .i oXd V U  .* oXd -   L.H  X# * *.iX<.b.:Xd V.e.( V V.D.<Xd V * P.{  X9XdXdXd 1 o.H.3.3.*Xd.D oX#., oXd.*  .+Xd -  Xf.D U  X< V P * &.< &.3  .;.H a.H VXd o *.i  .{Xd.< * oXd V V.~ o.D o aX<Xd &Xd.H  X<.D    .V } }   } L.H L  X< V.d a UXd V.3   VXi   y * V }  Xy.E I.D.DXd.D a }.< o P.H  X<.D    XiX9X9  X<.i.*X<   LX9 W     V.iX#  .4 9.i  X9X=.*  ., U 1.i  Xv.i h '  .iXd U  X@X<.H     WXy.{  .*X9.qX=., aXd.# X VX<  XyX< o.3   o J a ~ o.q     e.+.i  X9XyX3Xy  X1.iXt.(.p.K.q.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O eXd.:.b.D.b.:.< * 1.$.$.$.$X:.$ T.$ TX:X:.$X:X: T.$.$.$X:X: T.$ c TX: TX:X: TX:.$X: T T T T.$ T.$ T T.$.$ T TXzX:.A.$ T T T T T T TX: TXz T T T T.$ T TX: T T T T T T T T T T T T T T.$ T T T TX: T r - TXMXMX: T TXO |XM r.x r r r r r r r r r r.xX> H H H H.G.c.^.k r T.$ TX: TX: T TX:X:.AX: T TX: TX: TX:X:X:X: TX:X: T TX: TX:XM TX: r.w |X>X>.mXN.mXN.mXNXNXNXNXN ] ] D D D D | | | |X>X>X: rX>X>XNXNXN z z z ].c x.k F |X:X: TX: TX:X:.AX: TX: TX:X: T TX:X:X:X: T TX: TX: TX:X: r p r T.$.$X:X: r pX:X: T.$X:.$X: TX: TX:X:X:.F.F.F.F.F.FX5.:Xd o.( kXd.( 1 V V V V o.(.E.~.c & V V oXX WX< a   aX< WX= o [X#., A., ~.h.(.i  .3.iX#XiX=.E @ h VX# a ~ V V.,   - VXd V W.5  Xy 1.t.5      X#.Z 1 U  .{XdX=.,  X# V W a  .+Xd o.p o.(.(X9.3    ., -.p #Xy.,X9 ~ o 1.p.p o U.W.+.+X# U oXd }  X< L U *.D.b.< o # P &Xd V.:.D.D LX#    .{X<.< oXtX<X# L J oXdXd.<.:X<X9X<.WXy.D &Xd d.U }.{X9Xs.: &.<.< kXdX9 aX9X<.*.< o.<.~ VX9 a.H oX=.( * o.< V.D &XdXiX# }XxXx.,X#Xy o &.{  .3.H.i   a L.:.,  .{.,.W.V 1 VXd.*.3 }.,X9 V.< o.3   W #.p V &.: ~X#.iXxX9X<X# L V V.{  .3Xt.i   a L VX9  .3Xi 1X9   a UX#  X< o.,   [ @.:   a UX=.i  .3.4.EX#  Xi V.H   a L o.i     L.i  X# V o 1Xp.: * R 1 1X9  .{ V *X9 a.iX<Xi o.~X=X#  .3Xi L   a U * U  .5 ~ H.p #X=.pX. [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd l.D.DXd.D.:.<XdXdX:X:X:X: T.$.$X: T.$.$X: T.$X: TX:X: T TX: T dX: TX: T TX: T T T.$ TX: T T T T T.$ TX:X: TXzX: T.$ T.$X: TX: T T T T - TX: TX: T T T T TX: T T T T T T T T T TX:X: T T TX:XMX: T T -X:X:X:XM TX:XO | r rXM r r r rX> rX> rX>X> rX> H H H.G.c x.^.Q TX: T T TX: T T T T T T TX: T T T T TXMX:X:XMX: T TX: T TX:XMX: T T.$.aX X>.mX>.mXN.mXN.mXN.mXNXNXNXNXN D D D | |X>XN |XNX>X>X XN DXNXN zXN.G.c ;.^ G DX: TX: TX: T TX: TX:X: T TX: TX:X: TX: T TX: TX:X: T T.$ TX:.JX:X:X:.$ TX:X:. X:X:X:.$X:.$ TX:X:X:X:X:X:.F.F.F.F.F.F J &XdXd k &Xd o o o o V.~.( # I.Y.Y VX= * *Xd 1 o.~.~X= oX=.( oX=X=.e t @ tX= o.,  .* 1 oX= * 1X= tX8X#Xy VXdXd o.~.D VXd & V o o.r 1.i '.VXy.3  ., 1 1 o V.r.(X= W.~ o o V.0Xd V VX8.pX8.( o @.M t.p h # o.Z I.pX8X=X= # # 1.~.e o &.<Xd V 1 P P.X h P.< &.b o.(.( *.:.D.:.:.:.D.: o.(XdXdXdXdXd V o.<Xd o o o.~Xd.DXd.D.D.< oXd V o o.D XXdXd.:.D.bXd * VXd * o *.<XdXd o * o *X9 L o.(.( *Xd.<XdXd V.~.DXdXdXd V.D &.<.(.~ oXd.P.D.:.<.* & l.D a  X0.:.<XdXd o oXd V X V V *.~ ~  .3 o.# hXdXd &XdXd k &Xd o o o o V.~ ~ # I.Y.* VX= * * ~ 1 o.~.~.4 VX= oXiX=X=.e t @ tX= W V o V 1 WX= * 1X= tX8 1 VXiXdXd o.~.PXiXd & U.p.(.r 1 V.G * h V 1.~.4 1 o V.r.(X= o.~ o o o #.H V VX8 WX8.( o @ R t.p h # o 1 I.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.D &.:.:.:.D * o V.$.$.$.$X:.$X: TX: TX:.$ dX:X:.$ T.$ TX:.$X: d T T TX: d T TX: T.$ T.$ T.$X: T.$ TXz T TX: cXMX: T TX: TX: T TXz TX:.yXMX: T T T.$ TX: T TXz T T T T T T T T T T T T TX: -X:XM T TX:XzXMX: TX: TX2X2 T r r r r rX> r r rX> r rX> H H H.G.c x G v.XX:XMX: T T r d TX: TX: T T T T TX: TX: TXz TX:X:.AX: TX:.AX: TX: T T T.y DXNX>XNXN.mXNXN.mXNXN.mXNXNXNXNXNXNXNXNXN |XNX>XNXNXNXNXN z z zXN.G.c ; x.k GX: rX: dX: TX: TX: T TX: TX:X: rX:. X:X:X: TX:X:X:.AX:X:X: TX:X:Xu TX:X:X:X:.JX:X: TX: T TX: p TX: T T |X:.F.F.F.F.F.F & *Xs &.< o.(.(Xd.: o H @ #.pX=.f.q *X=Xd.D VX=X=X=X=.e.p w t t #.q oX= o o 1 o a aX= o V.D o U aXiXg U.~Xd V 1.q.< o.:.b.: V R.( o.i   V.f.~ o  X<.(X8.(Xd o * oX= * oX=X= H tX= *.(X= o o V H.p.KX8X=.(.~ VX= o o.~.p o.q h.(.q V.D V HXX o * & oXd.<.DXd o.pXX o.D V.~.D.D &.:.D o o VXd VXd V.~.q.~.<.~ o * 1.~Xd.:.DXd.D o * o.~ 1 VXd oXd k.D.DXd.~XdXd *.( * *Xd V.P a L.*X9.q *.<.~Xd VXd o.~XdXd &.DXdXd.D.:.:.D.:Xd *Xd.:.D.D.:.b.:.D.H  X#.:.D * o V 1Xd.~ 1XdXd oX9 L L  X9.D V.~XX P *Xs &.< o.(.(Xd.: o H @ #.pX=.f.q *X=Xd.D VX=X=X=X=.e.p w t t #.q oX= o o 1 o VX8X= o V.D o.qX=.~Xb.p.~Xd V 1.q.< o.:.b.: V R.( o.~ V V.f.~.(.p @.(X8.(Xd o * oX= * oX=X= H tX= *.(X= o o V H.p.KX8X=.(.~ VX= o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.: &.b.b.<.D o o.~.$X:.$X:X:.$X: TX:X: TX: T TX:.$X:.$ T TX: T dX:.$X: T TX:X: TX:X: T T TX: TX:.$ TX: T TXM.y rX:.$ T.$.$.AX: TX: T TXzX: T T T T TX: T T T T T T T.$ T TX: T T TXMX: TX: TXMX: TX:XM T - rX:XMX:.!X2X>X: r r r rX> r rX> r r r H HX8.G.c ;.k.k | TX:X: T TX: T T.AX: T TX: TX:X: T TX:X: T TX:XMX: T TX:X: TX: T TX:.$X:XM.; ] DXNXNXNXNXNXNXN.mXNXNXNXNXNXNXNXN |XNXNXNXN DXNXN zX8X8X8 z Z.c ; x.^.;.J rX:X:X: TX: TX:X:X:X: TX:X:X:.$ T rX:X: T T T.AX:.$X: T T.$ rX: TXu rX: r pX:X:X: T TX:X: TX:X:X:X:X:.$X,.F.F.F.F.F.FXd o.:.DXdXd.D h.DXdXd..X. # h.p.q R V o o.~ V.~ 1 o.e.E.p.M t.(.~ o.G.~.~.~ V U  .{ o oXd V o U  .{ ~ #.GX=Xd V.~ V.~ V.:.b V.(.pX8.*  .i V o.i.{ P #.p o V o *X=.q 1 oX=.(.p.K.q.(.pX= o.~ 1X8.e.p oX= * o oX= o V 1 V o.(.K.p oX= X.G #.( oXd VXd.b V.< P o H * o V.DXd o.:.D.D.: V o.D.D &.: X.<.9.q 1 VXdXd o.~ V.DXd.(.:.< o oXd VXd.D * 2Xd.: o o.<.D V.~ * o *Xd o.V a.3 U o.~ V V.:.< oXd.q 1 V V X.D & & &.D.: oXdX0Xd * V &Xd.b.:.D.:Xx  .,.<.D o o.~ o V.D V VXd * a.+X#.{XdXd.D V hXX o.:.DXdXd.D h.DXdXd..X. # h.p.q R V o o.~ V.~ 1 o.e.E.p.M t.(.~ o.G.~.~.~ V o 1X= o oXd V o.~ oX= @ #.GX=Xd V.~ V.~ V.:.b V.(.pX8.~ V V V oX=.e t #.p o V o *X=.q 1 oX=.(.p.K.q.(.pX= o.~ 1X8.e.p oX= * o oX= o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e.b.b.b.:XdXdXd o o.$X:X:.$X: T.$X:.$.$X,X:X: T.$.$ TX:X: T T.  T T.$X: T T T T T T TX: TX: T T T TX: T TX:X: cX:XM TX: T T TX: T T T T cX:XMX: TX: T TX: T T T T TX: T T T T TX: T TX: T TX:X: T T TX: TX:.y - - - |Xe | |X>X> rX> HX> rX> r.m.mX8 z.G.t x.k.k GXMX:X:XMX: | T | TX: T T T TX: T T TX: T T TX: T TX: TX:.A.$ T TX: T TX: TX: 9.;.w ] DXN DXNXNXNX .mXNXNXNXNXNXNXNXNXNXNXNXN z zXNXNX8 z.G.c ; ; x.^ FX:.J TX:X: TX: T | T r TX: T.@ TX:.A T.$X: rX:X: TX: T TX:X:X:X:X: TX:X:.  p.JX:X:X: TX:X: TX: |X:XMX:X:X:X:X:.F.F.F.F.F.F k *Xd V 1 X V.~ oX=X8.E #.# h.T.E.fX=.p.GX=X= IX=.f @ # @ #.~.qX=X=.p o.~ VXtX9X<X9. .q VX= V V.D.~X=.K.p o 1 1 V o V o.D.: V o.( o.qXi.iX<X9.* oX= #X= o.~ o o.~ o o * o 1X= IX= @.(.r o o V.e #X= o.~X= o.~ oXdXd o.~ oX=.p #.K @ @.M.p *Xd VXdXd.DXd o o.(.p *Xd.DXdXd.D & &.DXd.D.~ VXd V V X &.<.q VXd.:.D VXd.~ V P *Xd *.~ o 1.~Xd.D * * o &.(XX &XdXd oXd o.< o.<Xd.< * *.<Xd V oXd V * o o.~ o.~Xd VXd.:Xd &Xd k V.b.:.<Xd 1Xd.:.D.:XvX<X<X< LXdXd o o &Xd VXdXdXdXd ~X9Xy.<Xd 1 &Xd H h *Xd V 1 X V.~ oX=X8.E #.# h.T.E.fX=.p.GX=X= IX=.f @ # @ #.~.qX=X=.p o.~ VX= * V.~.r.q VX= V V.D.~X=.K.p o 1 1 V o V o.D.: V o.( o.q V V V 1 o oX= #X= o.~ o o.~ o o * o 1X= IX= @.(.r o o V.e #X= o.~X= o.~ oXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O _.:.:.DXd.bXs.D V &X,. X:.$. X:.$.  T.$. .$. .$X: dX: T dX:X: dX:X: d TX: d TX:X:X: d T.$ dX:X: dX:.$XzX:Xz c c.^. X: -.$X:.y T TXz.$ T - rX:XzX:.$Xz TXzX: TXzX: TXz T.$Xz T.$Xz T T TXzX: 9X: TXzX: TXz TXM -X: T -.) 7 | |X>.m r r r H.m.m z z.G.G ;.^.^.^ GXz cX: c TX:XzXMX:.y T.$ c TX: cX: TXzX:X:X:X: c rX: cX: T d TX: c TX: d TX:.y.JXz i.w D D D ] DXN DXNXNXN.mXNXNXN zXNXN zX8 z.mX8X8 z.G.c.c ; x.k.^ F.a r.J c |XM. X: T d.$ T.  TX: dX: T. X:. X: T.  TX:. X:X:.  T T.  TX:.JX: pXMX:.JX: TXuX:X:. X: T.  |.$ p T.$X:.F.F.F.F.F.F &Xd @ # t t @ # #.K h #.qX8.. @.(.(.p # #.(.~ V.~Xd oXd V o 1 oXdX=X=X= o.~.~ V o V V 1.b.4.: VXd V.q.p.p.e.(.~Xd V.:.D V.D V.G H oX=.q V 1 o.~ 1.~.p.p # o.(.q.~ o o.< VX=.(X= #.( o.~ o.~ 8 #.p.( V V oXd o.q o o.fX= o # oX8 o h t.p.<.( o V.~ o VXdXd V o * o o V & VXd.DXd.D.DXdXd.D *X= o VXdXd oX= V V.~XdXd.~ *.DXd oXd.< *.< o V * P o 1.<.<XdXdXd V o o.<.~XdXd.DXd.< & o o & o *.~Xd.< oXd.DXd V.DXd & o & V.~.D.<.:.:.<.~ &.b.:.b.:.:.DXd.bXs.D V &.DXd V.< V.D.D.~.D V 1 1 o * oX= *Xd @ # t t @ # #.K h #.qX8.. @.(.(.p # #.(.~ V.~Xd oXd V o 1 oXdX=X=X= o.~.~ V o V V 1.b.4.: VXd V.q.p.p.e.(.~Xd V.:.D V.D V.G H oX=.q V 1 o.~ 1.~.p.p # o.(.q.~ o o.< VX=.(X= #.( o.~ o.~ 8 #.p.( V V oXd o.q o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O _ o *.( V &.:.:.D.:X:X:.$.$X:.$.$ T.$ |.$X:X:X:.$.$X:.$X:.AX: dX: TX:X: T.$ TX:X:X:X:X:X:.$ T.$ TX: T TX: T cXz cX: TX: T TX:XMX: T.$ TXM cX: T T T TX: T TX: T T T T.$ T T T | T T T T T TX: T T T T T T TXMX: TX: TX: 7X0.w ] D ] D ] Z ].c.c.t x.^ G.;X: r c.^X: T TX: T rX: T T T TX:.$.AX:X:X: T TX: TX: TX:.AX: T.@X: T.AX: T T | T rX:X: rX:XM.).R.B.c ZX* ZX* ZX* ZX* ZX*.G Z.G Z.c Z.c ; ; ; x.^.^.^.}X:X:X:X: TX:.J r TX:.A T T | T TX:X:X: T.AX: TX:X: TX: TX:X:X:X:X:X: T TX:.AX: TX:X:XMX:X: rX:X: T TX: TX:X:X: TX: TX,.F.F.F.F.F.FX5.D # t tXb t #.( * k VX8 @X..(.( V.~.~Xd.D V 1 oXd V V V V V.~X=.(.~.(X= V V oX= VXd.~.:.D.:Xd V.D V 1 o @.p.(.4 V X 1 X.:X=.p #X= o V.~ V.~.(.D V t @ t.p.(X= V.qX=.~.~X=X=X=.pX= o o oX=X= o o o o & 1 o.G o.<X=X= 1X= t o.~.(.(.( hX= * o.~ V V V o V 1 o.(X=.~XdXd.DXd.:.DXdXdXd.< &Xd o *Xd VXd.<X=.~ V 1 *Xd V * VXd o oXdXd & oXd o *.q * o o o o VXdXd.~Xd.<XdXdXd &XdXd.~ V VXd.< o.~XdXdXdXd V &.<.D.D.:.bXdXd V &.:.bXd.<Xd.bX0.b o *.( V &.:.:.D.:.D.: &XdXd.D.DXd.DXd o.( o o *Xd &.D # t tXb t #.( * k VX8 @X..(.( V.~.~Xd.D V 1 oXd V V V V V.~X=.(.~.(X= V V oX= VXd.~.:.D.:Xd V.D V 1 o @.p.(.4 V X 1 X.:X=.p #X= o V.~ V.~.(.D V t @ t.p.(X= V.qX=.~.~X=X=X=.pX= o o oX=X= o o o o & 1 o.G o.< [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OX=.( k.w VXd V V &.:.$X:X:.$X:.$.$X:.$.$.$.$ d TX:X: TX:X:X:X: d TX:.$.$X: dX: T.$ T T T.$ TX:X: T TX: c TX:.y c cX: T T TX: TX:XMXz.$X: T cXMX:X:X: T T TX: T cX: T T T.$X: T TX: TX: TX: TXz.$ T T TX: T TX: T T TX:XM T c.R.c.;.}.; Z.;.c ; x.^.^X0 c r TX:Xz cX: TX:.$ T.$ TX: c.$X: T TX:X:.A TX:X:.A TX: c T.$ T T T T TX:X: TX: TX:X: cX: rX:X:XM |X0 F i ;.B.c Z.c Z.; Z.c.c.c.B.B ; ; ; x v G.^ F.;X: TX:X:.AX:X: T cX:X:.J.$X:X: TX:X:X: TX:X: TX:X:. .AX:X:X:.AX: TX:X: TX: | TX:.  T TX:X:X: TX: T TX:X: TX: p TX:X:X: | |.F.F.F.F.F.F i.D.p hX. H.hX= #.D.:.. t.M.9.qX= V.< VXd V VXd VXd.DXdXdXdXd VX= oXd.G * 1 o.p * X V V V.4 V 1Xd.DXd.: V #.p.z.4.: VX= o.=.T hX=X=.~ 1X= 1.e.(.~X8Xb t.. h H.p 1X=X8 o.(X= h.q VX8.p H.h.(X= 1 1 1Xd.D 1.q oXd oX=X= o.K.T 1Xd.r.( 1.q * 1 o.<.DXd VXd oXd.~XX.q oXdXd V.DXdXd o.DXd &.DXdXdXd.DXd VXdXdX=X=Xd VXdXd * V o.(Xd.~ o.< oX8.( oX=.(.( *Xd V.D.<.D V.~ o V V.<.b.DXd.~ oXdXdXd o V V &.< &.:.DXdXdXd VXd.D.DXd.bXs & *.bXd V VX=.( k.w VXd V V &.:.:.DXd.:.D & V 1X= o VXd *Xd.D &.D.D.p hX. H.hX= #.D.:.. t.M.9.qX= V.< VXd V VXd VXd.DXdXdXdXd VX= oXd.G * 1 o.p * X V V V.4 V 1Xd.DXd.: V #.p.z.4.: VX= o.=.T hX=X=.~ 1X= 1.e.(.~X8Xb t.. h H.p 1X=X8 o.(X= h.q VX8.p H.h.(X= 1 1 1Xd.D 1.q oXd o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.D.:.:.:.: & o o.:.$X,X:.$X:X:X:.$X:X:.$ T.$X:X:.$.$X: T.$ dX:X:.$.$X: T.$.$X:X:X:.$.$.$X: T.$X:.$.$X: TX: - d c T TX:X: T TX:X:.$X: T T - T.$ T T T.$.$ T.$ T T.$X:.$ T.$ T.$.$ T.$ T.$.$.$ TX:.$.$ TX: T T T TX: TX: T T |.! FXf i.R FXz.J F.) 7X: T T TX:.y cX: T.$X:X: TX: T TX: T TX: T T.$.$ T T.$ T T.$ TX: T TX: T.$ T T TX:XMX:XM TX:X:XMX:X:X: T.X.w iXz F FX3X3X3X3X3 3 3 x vXzXz.J.^ i.w DX:X:X: T T TX: TX:X:.  rX:X: TX: TX: T T TX:X: T TX:.$ TX:.$ T T.$X:.$ T T T T.$ T.$ TX:X: TX: TX: TX:.$X:X:.$.$X:X: T TX:.$X:.F.F.F.F.F.F J V.(.(.h h.K h @.M t @.( * o V 1 V 1X=.~ V VXd V 1 VXd o 1 V V.~ 1.~ 1.~X=X= o V VXd V &.:.:.: VXd V.DX= / . t H.K / @ @ @.TX. 1Xd V.D oX=.GXXX= o.p H h.(.(.p.K.p.E.p.e.(.~ o 1 oX8X=X=.e.e oX8 oX= o V # H.(.p H.~.p t O o.<.p.f 1 o.# t #.<Xd V.qXd VXd o.q.p oX= V 1XdXdXd o V.D & &.D.D.D VXd V VXd VXd oXX o * P o o o o o.~ VXd o *.( oX= o o oXd.(.~ & o o o.:Xd & VXd.D o.( o o o.~Xd o kXd.D.:Xd oX=.r oXd.D.:Xd.b.bX5.< oXdXd PXd.D.:.:.:.: & o o.:.<Xd & X 1.~ oX= oXd.D X.<.:.D.DXd V.(.(.h h.K h @.M t @.( * o V 1 V 1X=.~ V VXd V 1 VXd o 1 V V.~ 1.~ 1.~X=X= o V VXd V &.:.:.: VXd V.DX= / . t H.K / @ @ @.TX. 1Xd V.D oX=.GXXX= o.p H h.(.(.p.K.p.E.p.e.(.~ o 1 oX8X=X=.e.e oX8 oX= o V # H.(.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&Xd.D.D.D.b.:XX.( VX,.$.$X:X,X:X,X:.$X:.$X,X:X:.$X,X:X:.$X:.+X:.$X:X:.$X:X:.$X:X:.$X:X:.$X:X:X:.$X:X:X:X:.$X1X1XrX:X:X:.$X:X:X:.$X:.$X:X:X1X:.$X:X:X:X,.$X:.$X:.$X:X:X:.$X:.$X:X:.$.$X:.$X:.$X:X:X:.$X:.$X:X:X:X:.$X:.$X:X:X:X: |X0.PXfX0.).w |X:X:X:X:X:.$X: ' pX:X:.$X:.$X:X:.$X:X:X:X:X:.$X:X:X:X:X:.$X:.$X:.$X:X:X:.$X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:.$X:X:X: DX1X0 i.R F.JXz.R.!X0.).; 7X7X:X:X:X:X:X:X:X:X,.$X:X:X:X1.$X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X:X,X:X:X:X:X:X:X:X:X:X:X:X:X:X:X,X:X,X:X:X,.F.F.F.F.F.F.:.~ o o.(X. h.( @X..(.(.pXX.D.D V V.D.~ 1 1.D 1.< V o V oXd 1 1 oX8 1X=.(X=X= 1 V V 1XdXd.D.:.: V.D.: V 1 @ .X..z I.K.qX= I.K # V.D.YXd.~X=X=X=.p.p.K h H.~ o hX= o.~ t.p o.D V o 1X=X=X8.T o.~X= o o o.~.p.p O 1.rX=.K t O.q.<X8 o oX= B R.j.* LX9 o V V.DXd o h 1.( V.~ o.D o * V.D V V.*.:XdXd VXd V V oXd.<Xd.<Xd oXd o * *.( *.<.< o.< * o.q o * oXd k VXd * o o.b.DXd.< * V o o o &Xd o o BXd & & &Xd o o * k.b.D V.<.:.D.: oXX &.b.DXdXd.D.D.P.iXyXX.( V * o 1X8 o.( V.<.:.~ VXd &.D.b V o.~ o o.(X. h.( @X..(.(.pXX.D.D V V.D.~ 1 1.D 1.< V o V oXd 1 1 oX8 1X=.(X=X= 1 V V 1XdXd.D.:.: V.D.: V 1 @ .X..z I.K.qX= I.K # V.D.YXd.~X=X=X=.p.p.K h H.~ o hX= o.~ t.p o.D V o 1X=X=.QX0.i.iX= o o o.~.p.p O 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.D 1Xd.b.:.: o * 1 |X,X:X,X,.$X,X:X,X,X,X, gX,X,X:X,X,X:X, +X,X:X,X,X:X, gX,X,X,X,X,X:X,X,X,X:X,X,X, +X,X, gX& gX:X:X,X:X,X,X:X, +X:X,X: gX,X:X,X,X,X:X,X:X, gX,.$X,X:X,X:X,X:X,X:X,X:X, | +X,.$X,X:X,X:X,X,X,X,X,X,X,X, +X,X:X,X:X:X:X:X:X:X,X:X,X: +X,X,X:.7 gX:X:X:X:X,X:X,X: gX,X,X,X,X,X,X:X,.$X,X,X,X, +X,X,X:X,X:X,X:X,X,X,.$X,X:X: gX,X:X:X,X:X:X,X:X,X:X, +X: gX:X:X:X:X:X: |X:X:X:X,.8 |X: gX:X:X,X,X,.$X,X,X:X: gX:X, +X:X:X,.$X,X,X,X,X,X,X,X,X, +X,X,X:X,X,X,X:X,X,X,X,X,X,X, +X,X:X,X,X,X:X,X,X,X,X:X,X, gX:X,X:X,X,X,.F.F.F.F.F.F.: o oXd.~.M h h tX. h P oXXXd.DXd.D V V o o VXdXy.3    X9X#.{.i oX=X=X=.~X= o o V V V V oXd.:.: V V 1 V X tXb.M H.K # C 1 Z , #X= 1XiX9.{XxX9X<.iX<.p h h V VX=X=X8.(.p.qXd oX= H * o o o.~ V o.r.~.q o oX=.p # VXdX9 a P.( V.~X= o o o.L *X0.,  X<.~.~Xd V V.p.q oX= X V.~ V.~ o ~.i.{  X#.DXd.D.: y.{X9X<Xf & X.D.i., }.,.i o o.q ~.,.{X9X<.r o o o *Xd & V & *Xd.D.:X0X9 a  .U V.~Xd &XdX9X#., }.:.b.:.<.VX#X9.{ U.:XdXr           a ~.D V.D 1 L.3   U o * 1.(X=X= *.~ VXd &.D.DXd V.: VXx     aX9.{X#.V h h tX. h P oXXXdXf a } V V o o VXd o o.~ 1 o V.~ V oX=X=X=.~X= o o VX<     aX9.:.:Xi.,  ., X tXb.M H.K # C 1 Z.iX#X9X9X<X# o hX=X=.p.p.p h h V VX=X=X8.( V aX9 oX= H * o oXi.3  X9.r.~.q o oX=.p # V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.DXdXdXd.D VXd.(.qX,X,X,X,X:X,X,X:X,.$X,X,X:X,.$X,X,X:X,X, gX,X,X:X,X,X:X,X:X,X,X:X,X,X,X:X,X,X:X:X:X,X,X:X, gX,X,X,X,X,X,X,X,.$.XX,X,X,X: gX,X:X:X,.$ |X,X,.$X,X:X,X:X,X:X,.$X,X:X,X,.$X,X,X,X:X,X:X,X,.$X,.$X,.$X,X,X,X,X,X:X,X,X,X:X,X:X,X,X,X,X,X,X,X,X,.I gX:X,X,X,.$X,X,X:X,.$X,X:X,X:X,X,X,X,X:X,X:X,X:X,X,X,X,X,X,X,X,X:X,X,X,X,X,.$X:X,X,X,X,X,X,X,X,X,X,X,X,X,X,XjX:X,X,X,X,X,X,X,X, gX,X,X,X,X,X,X,X,X,X,X,X,X,X, +X,X,X,X,X,X,X,X:X,X:X,X,X:X,X,X,X:X,X,X,.$X:X,X:X,.$X,X:X,X,X,.$X,X,.$X,.$X,.$.$X:X,.$X,X:X,X:X,X:X,X,.F.F.F.F.F.F.: R.~Xd.<.hX=...(XX.<X=.<Xd * X.D 1 V.~ o kXd V VX#  ., V V    .*.~ o o.~ o.(Xd V V V.:.:.D.D V.D V.i UX8 tXbXb o.~ 1.r.p.G @ t.<Xy a.{ W.~.~.].3.i.qX8.(.DX= hX=.(.E.~ o H.K.`.p.9.pXX 1 o * o oX= o 1 o VX= o H.(.,  .*.~ oX= o 1 o oXd o *X<  Xy o o VXd o.(XX.i U.~ 1 oXdXd.DXd VX#  .+.D &X0.{  .V.bX9 a.: & d   W P.:   dXd W a a.: o  X9XdXd oXd V.< &.: &.:.b &X#X<X9 a  ., oXd.<X< a.: &   -.~.<.H aXx &XxX@ o *.3           L.D.:Xd.DXdXdX#   VXd.(.qX8.~ V.:.D.~.D V.D.b.:Xd.b.:Xd.3  .i.~.:    .*...(XX.<X=.<Xd *.*  X# V.~ o kXd V V 1 V.~ V.~ 1.( o.~ o o.~ o.(Xd V V.,  X#.D.D V.DXy.,XdX8 tXbXb o.~ 1.r.p 5   P.<.~.+., V.~.~X=.eX=.qX8.(.DX= hX=.(.EXi  .W.K.`.p. .*XX 1.{   U oX= o 1 o VX= o H [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.:.: V.:.4 X V.pX=X,.$X,X:X,X,.$X,X,X:X,X,X,X,X,X,X,.$X,X, gX:X,X,X,X:X,X,X,X,X,X,X,X:X,X,X,X,X,X,X,X:X:X,X, g.$X,X,.$X,.$X,X,X,X,X,.$X,X:.7X,X,X,X,X,X,X,X,X:X,X,X,.$X,X,X,X:X,X,X,X,X,X,X,X,X:X,X,.$X,X,X,.$X,X,.$X,X,X,X,X,X,X,X,X,X:X,X:.$X,X,X,X,.$X,X:.7X&X,X:X,X,X,.$X,X,X,X:X,X,.$X,X,.$X,X:X,X,X,X,X,X,.$X,.$X,X,X:X,X,X,.$X,X,X,.IX,.$X,X,X,X,X,X,X,.$X,X,.$X,X:X:X:X,X,X,.$X,X:X,X, +X,X:X,.$X,X,X,.$X,X,.$X,X,X, gX:.$X,X,.$X,X,X,X,.$X,X,.$X,X,X,X,.$X,.$X,X,X,X,X,.$X,X,X,.$X,X,X:X,.$X,X,X,X,X,X,X,X,X,X,.$X,X,X,X,X,.F.F.F.F.F.F &Xd o V.<.~.e..X8 R k.<Xd & P * V * o o k * VXd 1 a  .i & V    .i.~ 1 o.r.~ oXdXd 1 V.D.DXdXd V 1Xi a V.f , t.K.( V V t @ @ @Xb L   aXi.4 V.r.e.i JX=.~ o V.<.E.r.~ oX8.p.q.q o.~.D o.# V.~ o o o o * o.D.<XdX=.p h.0.4.pX8.(.q V o o.<Xd 1.q.s   eXd.<Xd.D o h ~ a o.9X= o.D & & o J    .H.D.b.,   }.D.:X9   d.(X#  .:.< o  X9 2X<  .iXd P  .{.( o.<.< V &.D V.D.b.D.P JXd VXy    Xd oX9  X9.D ~  XxXd.: a   ~.:X<   o.H.+Xd.b.b.i.{ o.: V &.:.: V  X# X V.pX= * V o.DXd.<.D.D.:.:.DXdXdXdXf     U o V    X9..X8 R k.<Xd & P *.*Xd o o k * VXd 1 2.~ V & V.~.~.q.~ 1 o.r.~ oXdXd 1X<    XdXd V 1X# V o.f , t.K.( V V t @.5   jXd V.*X<.4 V.r.e.pXXX=.~ o V.<.E.r.~ oX8 W.~.q oXi a V.# W     o o o * o.D.<XdX=.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2 V.D.: V 1 V 1.p.TX,X,X,X,X,.$X,.$X,X,X,X,.I.$X,X,X:X,X,.IX,X,X,X,X,.$X, gX,X,X,X,X:X,X,X,X:X,X,X,X, gX,X,X:X,X:X,.$XjX,X,X,.$X,.IX,X,X,X,.IX:X,X,.$X,X,X,X, gX,.$X,X,.$X,X,.$X,X,X,X,X,.$ gX,X,.$X,.$X,.$X,X,.$X,X,X,X, +X,.$X,X,.$X,X,X,X,.$X,X:X, uX,X,X, +.IX:X,.$X,.$X,X,X, gX,X,X,X,X,X,X,X,.$X,X,X,X, gX,X,X,X,X,X,X,X,X,X,X,X,X,X: gX,X,X,.$X,.$X,.$X,X,X,X,X, gX,X,X,X,X:X,X,.$X,X,X,.7X:XjXpX,X,.$X,X,X,X,X,.$X,X, gX, gX,X,X,X,.$X,X,X,X,X,X,X,X,.7X,X,X,X,X,.$X,X,.$X,X,.$X,X, gX,X,X,X,.$X,.$X,X,.$X,X,.$ gX,.$X,X,X,X,.F.F.F.F.F.F.V.: * R.~.e t.E.~ oXdXd.:.D oXX V.DXd.< *Xd * V.H     ~ VXy    .* 1Xd.iX# [X9XyXd VXd VXd.< V V.*.5.{ X 1.eX..~ h *.G @ t @ > P a  X< V V V 1.(XiX=X8 1.~.~X=.(X=.(.*.iX1.HX<.U.* o.*X9., V o.i.i.~ 1Xd & oXd.~ U.i LX9.p.K.(.(.~ * o o.< o.c  .3.( U.U.iXdXd.*.5X#XX *.(.( V V.:Xd d  .3 V.D & a  Xv.b &.{  X< h y  .{.ZX< a ~Xd a  .HXd.H    .( *Xd &.DXdXd & & &.b.b VXd o.H  .3 o.: a  .*X= U  X#.:.+  .U.DXd.{  .* * &.D.D J a.*XdXd V.D V.D U  X9X<X# W.T UX9.,.: 1X<X9Xd.:.:.DXdXd.D.i    .: *X;     J.E.~ oXdXd.:XfX9.i.,XfXd.< *.iX#.*X9Xy V.HXyX<X3.*.,.iXdX= V 1X= oXd V U    .< V V L.* o X 1.eX..~ h *.G @ t.5  X9 o V.4 V VX<X9.iXi.4.oX9.~Xi.,.iX= eX9X9 u.V V d a.{ oX= L  X#.p UX#.iXd & oXd.~.( [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& VX8XX B OXX o.e @.6.6 b.6 4 b.6.6.6 b.6.6 4.6 4.6.6.I.I.I.6.6 b 4.6.6 4.6.6 b b.6.6.6.6.6 b.6.6 4.6.6.6.I g.% g.6.6 b.6 b.6.6.6 b 4.6 4.6.7.I.I 4.6.6 b.6 b.6.6.6 4.6 4.6 b b.6 4.6.6 4.6.6 4.6.6 4.6 4.6 4 4.6 4 4 4 4.6.6.6.6 4.6.6 b 4 4.6.6 b.6.6.6 4.6.I g.6 b 4.6 4.6 4.6.6.6.6 b.6 b.6 b b.6.6 b b b.6.6.6 b 4.6 b 4.6 b.6 b 4.6 4.I 4.6 4.6.6.6 b.6.6.6 b.6 4 4.6 4.6 4.6 4.6.6 b.6 g.I g g 4.6.6.6 4.6 4 b 4 b.6 4 g.6 4 4.6 4 4.6 b.6.6 b 4.6 b.6.6 4.6 b.6 4.6 b.6.6 4.6 4.6.6.6.6 4.6 4.6 4.6.6 4.6 4.6.6 4.6.6.6.6 4.6.F.F.F.F.F.F WXdX= t tXd lX= * V & V.D &.:.<.q VXd V V o 1 oX9  .3 V.4.{  .i V.;.{.{ o.,  .i.(.*.,X#.i., a.*.3  .3X# W.WXxX<.{Xt @.. @.p IX9     V o 1X= oXX C H o.P.,X<.oX#Xi.q.*   a.,X<  .3 V 1X#  .*.~ a  .~X9X#.{ U.3.{ oX#   U.T.pXy.{X<X9      .(.i  X<.H.i    Xd.H.3  .3X# oX= h.D o.( PX9   }.<Xd *    X0.DXi     -XdXf a   a.,.Q V V     * oX9  .,.( * &.D & l &Xs.b.DXd & &.: oX9   L.~.i  .3 o.(.+  .,.q a   L &Xd    .P V & oXdX<X< &.: V XXd VX8.i  Xx.i  .3 @.(.,   L.D a  .D.DXd VX= V o.U  .{.*Xy.5X# U lXtX#X#XxX<  Xv U  .3 VXd W.{.{.ZX#  X9Xd.*   a.4X9    Xd.<.(.eX=.q.( h W    Xi.(XtX< o VXd V HXX V V.E @.. @.i    .{.* o o 1.]    .*.+    XiX< a  .*.q.*  .3.:.*.3  .3X#X=X<  X9X<X9    Xd VXd.~.< o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.(Xb.6.#XX oXd.(X. M M M M M M M M M M M M M M M M M.7 a.I.IXa M M M M M M M M M M M M M M M M M M M M.% M M M M.I M M M M M M M M M M M.7.%.I.% M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M g.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M MXh M M M M M M M M M M M M M M M M M M M M M M M.I M M M M.% M M M M M M M M M M M g M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M (.F.F.F.F.F.F ~ 1 tX. *.D.D.~.#Xd V &.: V.:.<.( V.D o VXd V o.{  .{X<X9Xy oXd VX#  Xt.p.,   [ VX=   a L.i  .*X<  Xy o.i  Xd VX9.e I #.K.p X.{  X#Xd V 1X= *X8X= HXy  .i o o  .3.( ~   aXf V    .< V U  .iX=.i.{ o U  X# U.U aXd.3   o.#.i  X9Xd V   a.<.~.,  .,.* W  .{ & VX<   U.<X8.K h oXd.( o.3  Xy * V.pX#  .: & y    X0Xd WX<.3  .{ V o oX#   oXd.3  X9 o.( & &.D.D & &.b.D kXd &.: ~ aX<.<XdX#  X9 o o.{  X9.P    .: & U    .:.DXdXd.* a ~ & o V o.~.(XbX@  Xo o    X..( U  X<.DX9.{ &Xd V.~ o V * a  X<X9X#X#.H.D.D.~.W  X<X;  .i.i  X< V.DX#   ~ VX#   [Xd.*  .,.* ~  .3 oX=.p.p V 1 VX= 1     UX=., W 1 V oX=.p * V I.e I #.K.pX<     a ~ V 1.*  .WX9 H   aX9 o a   V.( U  X<.D VX<   - V.( a  X<XiXi  .{.<XdXd.D oXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.( R $XX.:Xd 1 V o.T M M M M M M M M M M M M.I M M M M.3       y ( M M M M g M M M M M M M M M M M M MXa M M M M M M M M M M M M M.I M M M.%Xh.%.% M M M M M M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M a M M M M M M M M M M M M M.3 M M M.I a M M M M M M M M g M M M M M M M M M M M M MXh.% g g.%.7Xh.I.%Xh M M M M M.I M M M M M M M M M M M M M   M M M M M M M M g M M M M M   g M M M M M M M M M M g M.I M M  .7  .% g   M M M M M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M M.F.F.F.F.F.F e @ * &.<.: &.D.h * V.D.:.: &.D.(.DXdXd V.r o.:    Xy 1Xd o.< V U  ., 1X=  .3 o oXi  .3.: 1.4.~ a   V 1Xy  .{X0 1 C.GX=X= o.4    X9.D.DXd *.(.fX=.*  .s.~.~.*    .~.i  Xx.D.*  .3XdX= e  X#X=.i d 1.i  ., VX0 _Xi  Xh tXX a   ~.D L  .3Xd o    X9.p.i  .i o o a  X0 &.( hXX #.p.G.c     VX=...( oX#.3.,     }Xd.* a L.:.{  .,.< oXf.3.3X#    X0.~X#              X#.<.< V.;.{X<.< o P a   U.D ~    .H.i  .{.D VX<  .U &.: VXd.3X9.D VXdXd V.( R.L  .3Xd.Z  .3.T o W  X#Xd.i L V.D VXd V oX;    .4 @.:     U &.D.5 a U.D.*.: }   U.D U  .,.r o  .3Xd 1.i  .{.< L  .,.p 1X= o 1 o o o 1.3  X9.i U V.D o 1.~.q V.D 1 C.GX=X= o.4.i    .U.DXdX9  .{.] U  .s V U  .{.D.~X<   U.D V a  .:X= ~    X9X= }   L.D.b V.D P V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O * V.D V *Xd V.D.:.D M M M M M M M M M M M M M M M M M g  .I.I M M M M M M M M M M M M M M M M M M MXa M M M M M M M.I M M M ( M M M M M M M  .I.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.IX4 M M M M M M M M M M M M M M M M M M M M M M M M.I.%.I M M MX& M M M M M.I M M M M M M M M M M M M M M M M M M M M M M g M M M M M M M M g ( M M M M M M M M M.I M M M.I M.I   M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F W.D V &.D.D.:.DXd.< * V.<Xd *Xd VXd X V.~ V X.      V o o.(X=.f.,  Xy 1 U  X< o XX9  X< H.~ V.*  ., V.:.GX<  .{Xd V 1.K.pX= V    X< 1 o o V 1X=.~X#  .i o o.i  .{.~.,   U V.i  X9 &X8 *    .rX# o.(X#  .FXd.DXd L  X9.( @X#   V.H a.3 ~Xd.*   a W.<.3   e o U  .UXd 1 o.q k * o o.i  X@ * RXd & &.D.DXx   a.: *.3.,.< V.*     o oX=.#.: a  X9Xd.DXyXxX<.+X<XxX9.iXy 1 h o.,XrXd.~XfXd    X0 V L  .3.DX9  X<.:Xd.3  Xr & &XdXx.3 JXd V.: * * * VXr  X9XdXy  X<.DX=.~     V.{ WXdXd.~Xd VXdX9  .5 1.D V     }.: -  .{ * V.<Xd.3   WXd.,   U VXy  X< o o.,   UX=X<  .i V 1 o.~ 1 o X 1.~X#  .,X< 1 1 V V.:.GX= 1 1Xd V 1.r WX= V.~.i     o o.{  .i.~X<  .i oX<  .i V.~.3   V V.*  ., &X8 L  .3.r o     VXd lXd.DXd & [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&Xd V * V.DXdXd.D V M M M M M M M M M M M M M M M M M.%.3.%   M M M M M M M M M M M M M M M M M M M g M M M M M M MXa M M M M M M M M M M M.I.I.% M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M.I.3 M M M M M M M M M M M M M M M M M M M M M M M M.I M g a    .I   M M M M a M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M.I M M M M M M M M M M g M M M.I  .I M     M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M (.F.F.F.F.F.F J &.:XdXd.D.:.: &Xd kXd X.D o.< V V V 1 X.D.:X<  .{ VX= V 1 VXd     V.qX#  Xy.~.:.{   [.~.G.K.i   L W.4.4 H.,  Xy 1 V.f.KX. o.,  .,Xd P VXd o U 1     W o o.3   U o a a *.D.3 a V.~X8 *X#  X9 UX=.]   a E.<Xd k y  XlXt H o y LX< U 1 o oX9   yXd.H  X# * WX9   L.; PXd.< o VXd.D u  X9Xd.<Xd &.D.D.*   a.*.D.<  X< oXdXd   aXd o.p PX#  X< & & o *.<Xd & &.< o.< * o *X9.*Xd.DXr.*Xd.3.3XdXdX#  Xy & L  .i.bX;  .{.:Xd.DXi a LXdXd V 1 m.LXdXdX<   U.DX< aX0 V o 1X#  X9XyXd V V 1.< 1 #X#  X<Xd &.*    Xr.:X<  .i kXd XXf  .{ VXi     W.DX#   U o V a a 1 V.{   [ V.q V.~ V.~.: V VX9   a.r h.r V X.4.4 H.( o 1 1 V [ 'X. o V.~   a P W     V 1 a   V o a   ~ W W  X# *XfX<  Xy VX8X#  .iX= L  X< V.< E.<Xd k.D [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXdXd VXd.~ V.D V.: V M g M M g M M.% M M g M g M M.I M M.I.% M.I M MXa M M g M M M M + M M.I M M g MXh.I M MXa M M + a a M M.3 M M.I M M   M  .IXa M.3 M.I M MXa M M.I M M   M M g M M M   M.I M M g M M.I M M.I M M.I M M g M M.I M g M M.I M M.% M M g M M y.I.3X4 M.I M M.I M M a M M g M MX4 ( M.I M M M M a M  .I M MXa M M a M M g M g.I M.I M MXw M M g M MXa M MXa M M.3 M M.I M.I   M MXa M M.I M.3Xa M M.I M M M M g M     M M.3 M M.7 M M   M M + M g M M.3 M M.I M M.I ( M.I M M.3 M.I M M + M M a M M.I M MXa M M.I M M M.F.F.F.F.F.F.V.:.D V.D.D.D &.D VXd.< V.: V.: V 1.~ V V V.: a  X9.(.~ X.D V V     W U.{  .*X<.*  .3.f o.p tX#  Xi 5 UX<.p P  .i V 1.~.G.p o.V a   L.: 1.H.UXyXd.3   oX=.i  Xr.qXi  X# 1.i   UXd.=X=.pX<  .{X=X8 U  X< * kXd.<.3  .*X9.p.+.5X9.HXd o.~ oX#  Xy.DXx  X9 L.Z.{  .*X9.q V.<XX.~ V ~    X; oXd.D.D & L aX@Xi.(Xd &X#X#.<.<.*  XrXd V o., a.i.D.D.D *.< VXdXdXdXd.~ o o V.{.3X#X#X#.3.(.<X9X@.DXi  .,.D &.: aX;.:., a.H.D & VX#X@ VXd *.<.( * * VXd.3   V.* a.*.: V 1XdX9  .{Xd o 1 I oX8 , R     U.:.:X@  .{.D.D.3  XiXd.< V.i  X<X<.4     W L.{  .*X9 ~  .,.D V    XiXy.( oX8X= V.4 V VXy   L t ,.E.h.c a   W h.pXd V 1X9Xh o o P.*  X9XdXl  .U o.*  X# o.4  .{Xr ~Xy  X9X9Xi.{  .*.+.]     WX=X#   U.i k * kXd.< V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&Xd V V VXd.DXd.D o M M M M M M M M M M M M M M M M M M  .I M M M M M ( M M M M M M M M M M M M M M g M M M M M M M.I M M M M M M M M M M M M.3   M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I.3 M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M M M M M.% M M M ( M M M M M M ( M M M M M M M M M M M.I M M M M M M M M.I M M M M M M M M M M.I M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F.V.D.:.:.D.~Xd V.: &.:.( o.< 1.:.: 1 X.c.~Xt.,    .{XyXd V o VXdX<     L.,  X# X.i  X9.pX=.e.pX#  .,.]X9X#X9.,X9 VXd V o o.e.KX8.:X< a  .5., ` o V.*X#.,X<.,Xi V V L  .3.iX4 U o.D h.p.E.i aXiX=X=.,   U l & V oX4   } oX=.,      .3Xi o.]   a.r.q L  .{ JX8X#  X# W.<Xd o.(X=X9.3    .U L &.D.*.U.U.*.h.(.2 & o J }X9X9X#Xy * VX9X#X9XtXd V.(Xd.D &Xd.DXdXd V *.~Xd.{           L.(XdX0.,X9X@Xx.D &.:.bXy.U.,.U U.D.:Xd U  .H P B.1 R.<Xd V.~XdX< aX<X<.PXd.D o o VXx a.*.r.p h.M.M.M.b.{    .,X<.{.{X9X0.~.H  .{ &.:.( o -   a.* 1X<    Xy.,  ., *X9  .i o V a  X< VXd V.~ V X V 1X=XiX#.e.p @ ,.E.] a  .4X= 1 VXd VX9X9X< '.+.{X9 V VX<   d oX<  .iX=.4     L V.*  .5 ~.r.{  X@ P.*  X#.q o.,  ., o o l & V o.r [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.D.DXdXd V.:.D.:.( M M M M M M M M M M M M M M M M M M.%   M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M M M M M M  .I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M  .3 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M g M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M MXa M M M M M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M.F.F.F.F.F.F ~ V.D.:.:XdXdXd V.:.b.(.~ VXd V ZX=X= 1.G.( HX= HXdXd o VXd V.: V.* [.D ;.*X= V 1X=.e.E.p.~X=.p.Z.p oX=X=X=X=Xd.~ 1 oX=.f 1X. h * V V 1X= o.(X= o o 1X=.~ 1 o o o u  .c.p o.~ o o.q.p @.i U.M hX8.pX=.qXdXdXd hXd ~ V 1.4X+ WXyX#   a.(.( oXd.( P o W.(.(.( h W.< o & o.(XX.( * VXd k.D &.D &X0.b.b &Xd.<.D.:.< o &XdXd o.< kXd V o o.< P *Xd o.~ o *.( o o.<Xd *XdXd.DXd oXd V.(.( & V &Xd.: &.D.: l.: &.b.b & &.:.D &.D V R m m kXdXd.<.~ o.D.DXdXd V.:.D.:.( 1 VX9.i 1XX @XbXb * o.~ o.:.:.D X V.D.:.:XdXdXd V.:.b.(.~ V ~ V ZX=X= [.t.(.=.* HXdXd o VXd V ~Xi V X.D.c CX= V 1X=.e.E.p.~X=.p.e.p oXtXtX=X=Xd.~ 1 oX=.f 1X. h * V V 1X= o.(X= o o 1X=.~.4 V o oX8 V.K.p o.~ W o.q.p @ @ @.M h.c.pX=.qXdXdXd hXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O *.: V V VXd.b.: V H M M M M M M M M M M M MXa M M M M M   M M M M M M M M a M M M M M M M M M M M M M g   M M M M g M M M M M M MXa M M M M M M.I M M M M M MXa M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M M a M M M.I a M M M M M M M M   M M M M M M M M M M M M M.% M M M M M M M M M M M M M.I.7 M M ( M M M M M M M M M M.I M M M M M M M M M g M M M M.7 M M M M M M M M M M M M g.I M M M M M M M M M M M M M g M M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M (.F.F.F.F.F.F ~.:.:.D.D.< &.D.:.D & *.(.DXd V o 1 o o oX=X=.p o o VXd V * V.< V V 2 V 1.~X=X=X=.e H.q I oX=X= I.eX=X=X=.G.~ o 1 o o V.Y.c s B oX=X= CX=X= 1.~ V o o o 1 oX= oX= a.5.E h *.r o [ aXy eX9X= , t t.h o o o.~.r * 1 V.~ o a.].( * o.{ a o * o oXX * *.<.(.q h.p.( V & V.(.q.( *.9 *.D.:XdXd & & & & & &.D VXd &XdXXX8 1 o *.< V V.<.~.<Xd.2 o.~ * o k * o *XdXd &XdXd.D.:.D & * o.q o V o o VXdXd & & & &.D.:.D.D.b.:.:.D * P $ EXd V VXd o o *.: V V VXd.b.:.*.5XyXiX9X8.( P.MX. o V o hXd V.: V X.:.:.D.D.< &.D.:.D & *.(.DXd V o 1 o o oX=X=.p o o VXd V * V.< V V 2 V 1.~X=X=X=.e H.q I oX=X= I.eX=X=X=.G.~ o 1 o o V.Y.c s B oX=X= CX=X= 1.~ V o o o 1 oX= oX=X=.E.E h *.r o 1 oX= #X=X= , t t.h o o o.~.r * 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& & V VXd.D.: o V o M M M M M M M M M M ( M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M.I.3.% g M M M M M M M M M M M M M M M   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.3 g M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M g M M M M M M M M M M M M M M M M M M M M M M ( M M M   g +.I M M M M M M M M M M M M M M.% M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F i V.: &.( P R k.:.:.: V *Xd X 1.~ 1 V CX=X8.KX=Xd VXd 1 V V 1.rX= I.zX8X= 1 1 o o.(X=X=X= 1X= 1X=X= o.f.~.~ o o V.~X=X= o.( t.(X=X= 1X= o o o o.~ 1.~ V V IX= o U  .{ ,.( o V 1Xt a.3 9 o o.q oX=.p @ @.p.q o oX=.~ VXdX#.i.].(Xi.3.* o o.(.( o.q o H.q o.p.p o o.:.< oX8 o V.< & V.<.D.< *Xd & &.: &Xd.<.< o *.<X=.<.<.<.~ 1.~ oXd VXd.: V.: & &.< o o.<XdXd.<.D.< * V.<.:Xd V oXdXdXd o k V VXdXd &.D.D.b.b.b.b.:.< kXd &.c.<Xd V.< V V 1.~ & V VXd.D.: oXi a.3 U o.: C.K.b V.:Xd.: V VXd o V.D V.: &.( P R k.:.:.: V *Xd X 1.~ 1 V CX=X8.KX=Xd VXd 1 V V 1.rX= I.zX8X= 1 1 o o.(X=X=X= 1X= 1X=X= o.f.~.~ o o V.~X=X= o.( t.(X=X= 1X= o o o o.~ 1.~ V V IX= o o o I ,.( o V 1X=X=.(X8 o o.q oX=.p @ @.p.q o oX= [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& VXd VXd.D.<Xd V.< M M M M M M M ( M M M M M M    .I   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I.3.% M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M a a M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.3 g.I.3 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.IXa g gXa M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F.: V.D V o * k R V.:.D VXdXd 1 1 V V o.pX=.p.q.~ oX=Xd X.~ 1.~X=X=.q.eX=.~ X C 1.~ o.q oX=X=X=.eX= o 1 o 1 o.pX8 * 1.e.p h.KXb h.e IX= o o o o.< oX=X=.fX= o 1 WX9X9X9XlX..D VX=.( o o CX=.~X=X= o o.E.K.K #.pXX o V V.D VXyX9.+ UXd o.(.p.(.q.< o o *X8.qX8.p h.<XdXd.< *.~.D o.D.<Xd.: &Xd.D l & &.DXdXdXdXdXdXd *.~ *Xd V * V *.<Xd &.: &.DXd.DXdXd *Xd & &XdXdXdXd VXd.DXdXd.< &.D V *.D VXd VXd VXd &.b &.:.D.D k &.D.:Xd.DXdXdXd oXd V o VXd VXd.D.<Xd V.<.pX=.~X= ,.~.:.:.:.:.bXd.:.DXd.~.~ V.D V o * k R V.:.D VXdXd 1 1 V V o.pX=.p.q.~ oX=Xd X.~ 1.~X=X=.q.eX=.~ X C 1.~ o.q oX=X=X=.eX= o 1 o 1 o.pX8 * 1.e.p h.KXb h.e IX= o o o o.< oX=X=.fX= o 1 oX= * 1 ,X..D VX=.( o o CX=.~X=X= o o.E.K.K #.pXX o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd 1Xd & V.~ V o V o M M M M M M M M M M M M   M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M   M M M M M   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M g M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F.: V.: V.:.: & & V V V 1.~Xd 1 V XX=.p.p.~.f.G.~.fX= V V 1 VX=.(X=X=.~X= 1 VXd 1 V oX8X=.( oX=.zX=.q 1.f.rX=.p o o 1.q.( h.EXbX. ,.EX= 1 1 oX= o.f.(.K.K #.(.qX= 1.(.(.e #.< o HX= 1 V oX=.p h.(.p oX8.q oX8.. @.~ V V V V.< o * o o o.( H * oX=.( oX=.(.p.( o o oXd oXd oXdXdXd.D k &.D.D.D &.:.: VXdXdXd VXdXd *.#.K.(X8 *.( *.< k.D &.D.D.<.(XX o VXdXd.D V &.D VXd &.( V 1XdXdXd &.DXdXd o oXd.<Xd.: V.: l.b o k &.DXd V.~Xd &.D V V oXd V 1Xd & V.~ V o V o oXX o I.z.:.:X0.:.:.D VXd.:.D o.~ V.: V.:.: & & V V V 1.~Xd 1 V XX=.p.p.~.f.G.~.fX= V V 1 VX=.(X=X=.~X= 1 VXd 1 V oX8X=.( oX=.zX=.q 1.f.rX=.p o o 1.q.( h.EXbX. ,.EX= 1 1 oX= o.f.(.K.K #.(.qX= 1.(.(.e #.< o HX= 1 V oX=.p h.(.p oX8.q oX8.. @.~ [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd 1Xd.D V 1 1XdXdX= M M M M M M M M M M M g M M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.IXa M M M M M M M M M M M M M M M M M M M M M M M M M M M M MXa M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M g M M M M M M M MXa M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F J VXd o 1.4.b.b V.D X.~Xd V * V o.( * V o C X C.~.f o.~ 1 1X=X=X= I #.~ o X VX8 t V.G o o oX= o I.p.f IX=X..hX= 1 o.( I.G I /X. V 1.G *.r.~X= V oX8.K @ @.9X=X= V V.< @.q.Y o & &.< V.~ o.(.qX=.q o o oX8.(.~X=.K t t *.: V *.< V.(.( o.p *X=.p.(X= o *.( o *Xd VXd.(.< oXd o o o o o o o.<Xd V.: &.D.D.D *Xd.< V & &Xd P.DXdXd.( k.: &XdXd V.< oXd oXd.DXd.D V.DXdXd * H.(XdXd.<.D & V &Xd o.< VXd.~ V P.# $.6.w.D.: & & &Xd.D.DXdXd.~ VXd V 1Xd.D V 1 1XdXdX=X= t.M.(.p o.:X0.4.4 V.~ V &.:.~Xd VXd o 1.4.b.b V.D X.~Xd V * V o.( * V o C X C.~.f o.~ 1 1X=X=X= I #.~ o X VX8 t V.G o o oX= o I.p.f IX=X..hX= 1 o.( I.G I /X. V 1.G *.r.~X= V oX8.K @ @.9X=X= V V.< @.q.Y o & &.< V.~ o.(.qX=.q o o oX8.(.~X=.K [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.DXd VXd o *X8.p H M M M M M M M M M M M  .I M M M M M M M   M M M M M M.I M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M.I M M M M M M M g.I M M M M M M M M M M M M M M a M M M M M M M M M M M M M M a M M M M M M M M M M M M M.I M M MXa.I M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M M.I M M M M M M M.3 M M M M M M M M M M M M MXa M M M M M M M M M M M M M M.I M M M M M M M M M M M   M.I M M M M M M + M M M M M M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M M   M M M M M M.F.F.F.F.F.F.V.D.D.~ o 1.:.:.: V.: 1 V o o.(X= oXd V V 1X= VX=X=X=.~ 1.p.(.r o oX=X=.~ V 1X=.( o V o V.~X=X= o I 1.GX=X8X= o.qX= * 1.f.G.pXX PX=.(.p oXd o oX=.(X=.p.p.K.(.~Xd o.( @.(.<Xd V o.( oX=.~X=.( oX=.( o.~X=.qX= o 1 1X8 @ #.h o oXd.( o o.h o.(.pXX.( * o o.< o 1.pX=.pXd.( *.# P o oXdXdXd.< o o &.DXd &Xd.2 VXd VXd & o.h.( *.< o o.< &Xd.< oXd.D & oXdXd.b &.: &.D &.pX..(Xd V o.D & V.<XdXd.(.<.<.( B.1 4.X &Xd & V.D &XdXdXdXd.D.D.DXd.D.~.DXd VXd o *X8.p H.K t.M s h o.:.:Xd.: o 1.D &.:.D.:.D.D.~ o 1.:.:.: V.: 1 V o o.(X= oXd V V 1X= VX=X=X=.~ 1.p.(.r o oX=X=.~ V 1X=.( o V o V.~X=X= o I 1.GX=X8X= o.qX= * 1.f.G.pXX PX=.(.p oXd o oX=.(X=.p.p.K.(.~Xd o.( @.(.<Xd V o.( oX=.~X=.( oX=.( o.~X=.qX= o 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.:.DXd oXdXd h H.q M M M M M M M M M M M + ( M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M MXa M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I a M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F ~Xd.D VXdXd V.D V X V o.~ o oX=.E VXdXd V V 1 VX=X=.pX=.G.(X= o.~ 1.p.q V V X 1.~XXXd o oX=X=.qX=X=.fX=.eX=.( oX8XX * 1 1.G.M q t.( H.(.<.D o oX8.pX= o.~ XX8.( V I.K # sX=.~ V o.p o 1 o.(.( *.(X=X= o * o.q oXd.~.D.D.E.M o.p.(.(X=.(.p.9X=.( o.~ 1 o o 1 oXd.q o o V.(.< O RX= V o 2.~ o o.( oXd V o.<Xd &Xd o.< VXd o h.< k.< &Xd.<.<Xd oXdXdXdXdXd.D.D.D &Xd &.rX=.(.p V VXd V & V.D V.~.~Xd.~ R m m k o & V o.DXd.DXd &.D &XdXd.: oXd &.:.DXd oXdXd h H.q.K t s.6 m hXd.D V o.~Xd X.D.:Xd VXd.D VXdXd V.D V X V o.~ o oX=.E VXdXd V V 1 VX=X=.pX=.G.(X= o.~ 1.p.q V V X 1.~XXXd o oX=X=.qX=X=.fX=.eX=.( oX8XX * 1 1.G.M q t.( H.(.<.D o oX8.pX= o.~ XX8.( V I.K # sX=.~ V o.p o 1 o.(.( *.(X=X= o * o.q oXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.:.~ o.:.<.( V.~X= M M M M M M M M M M M.3 M M M M M M M M g M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M.3 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M a a M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M M M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F.).D o VXd V V X.:.DXd * o V.: o.~X= o oXd.D V CX=X= o o 1X=X=.~ o.~X=.q.~ 1 V X.~ 1 V.~ CX= HX=X=X=.q.( o o 1.K h.E.... @ t.M.M @ # IX= o oXd *.4X=X=.p o.c V 1.f.KXb.( t.K oX=.~ * o.q o 1 V o.(.( o *./.M o o V V.~ * * o t.MX..TX. H.M.K.p 1.(.q 1 1 o * *.D o P.~ o o @ h.(X=.(.q.( h o.(.(.q.e.X P PXd.(.(XX * o.( hX=Xd &Xd &.<Xd &XdXd &.<Xd &Xd.D &.D.~ o.( 1.~ V P.<.<Xd k.V.*.i.d &.2.L.L.< & VXdXd o *.<Xd &Xd.<Xd &.V.PXd.D.D &.D.:.~ o.:.<.( V.~X= o o.(.1 PXX.e.~.Y W.H.D.: &.DXd.<.D W UX9 W V X.:.DXd * o V.: o.~X= o oXd.D V CX=X= o o 1X=X=.~ o.~X=.q.~ 1 V X.~ 1 V.~ CX= HX=X=.4Xi L.i o 1.K h.E.... @ t.M.M @ # IX= o oXd *.4X=X=.p o.c V 1.f.KXb.( t.K oX=.~ * o.q o 1 V o.(.( o *./.M o o V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O e oX=Xd *.q o o.(.p M M M M M M M M M M M MXa M M M M M M.I ( M M M M M M.I M M M M M M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M.I M M M M M.I M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M M MXa M M M M M M M M M M M M M.I M M M aXa M M M M M M M M.I M M M M M M M M M M M M M.I M M M M M M M.I M M M M M MXa M M M M M M M M M M M M M.I M M M M M M M M M M M M M M.I M M M M M M M M M M M M.3.I M M M M MXa M M M M M M M   M M M M M M M M M M M M M M.I M M M M M M M M M M M M MXa M M M M M M.F.F.F.F.F.F JXd.:.D V V VXd V 1.< 1.~Xd X.: V.q.~.~.D V.(.e.( o X 1 X.~ o 1X=.e H.r o 1 o V V 1X= 1.e.z.( I.rX=.~ 1.(X8.(.p h.K.E..X$.. t.M s.e.K # *.<Xd.: V VX=X= 1 1 1.r.G #X..K.K.(.pX8.( V.( eX<    X#X9.3., o.M PXd.D o o o o.<.q.K.M.M.M h o # H.fX=X8 o V o o V o * &XdXd *X=.q.4X<X# L.i.,.i LX=.(.(.hXX k.< V.<.(X8.(XX.(.q oXd.D.< &.< & &.<Xd V o &.<XX & o.{.{.(.( V & & o R k k kXf.3  Xx & & & & V.D.~.<Xd o V.D P VXd.H.+.3  X<.: &.:X0.,.{X9.,Xd.q o VX<X#X9 y ~ *X= o.4X9.3  X<Xd.D.D.: VXd.*.,  .3 V VXd V 1.< 1.~Xd X.: V.q.~.~.D V U.3    X<X#.{.i o 1X=.e H.r o 1 o V V 1X= 1.e.z.( I.r.4.,  .iX8.(.p h.K 1X9    .5 L sX<  .,.H.<X9 aXi VX=X= 1 1 1.r.G #X..K.K.(.pX8.( V.(.(X= * o V o.( 1 @.M PXd.D o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O _.h.<X=.(X= 1X=.p.q M M M M M M M M M M M M MXa M M M M.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I M M M.3 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M a.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I ( M M M.I M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M MXa M M M M.3 M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F ~ V VXd.DXd.D.<Xd C.(X= V V X.c 1 o.(X= o.p @.pX=.~ 1 1 X 1 X.~X=.hX=.~ 1 1Xd X.~ 1 1 V.~X=.q.q.fX8 o.(.p.pX=.(.E t.T.eX=.f.M.M.M h h.p k R oXd.4.~ VX= 1X= *.(X=.( *.p.p.( H.q.( V oX=.R     ~ 1X9  ., h h o.<.D VX= h V.(.( H.. #.p.(.p o., 1X= *.p.q oXd o o.D.D o.(.# U  .{.=.M s e  .: o.p.(.( o.~.< E o.(.~ oX=.(X8 o &.DXd.< & V.< kXd & PXd & &.: * a aXd.<Xd &XdXd.1 * k &.:.{   d &.b.DXd o.<.~.,.: &XdXd o 1.< &Xd     U.b.b ~ a a *.<X#.,X=.Z.{   eXdX< a.:.< 1 1.~    Xi V V V.:Xd V V.i   }Xd.D.<Xd C.(X= V V X.c 1 o.(X= o.p @.,  ., 1.Z     U.~X=.hX=.~ 1 1Xd X.~ 1 1 V.~X=.q.q.fX8X#  Xi.pX=.(.E t.T.]    X;.M.MXyXx.p k R.,  Xy.~ VX= 1X= *.(X=.( *.p.p.( H.q.( V oX=X8.p.q.q 1 o.( h h h o.<.D [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.h.D o V.Y V.e.p * o M M M M M M M M M M M M M M.3 g.I.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I.I.I M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I a M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M g   g.3 M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.I.I   g M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F J.D.:Xd.D X o V V X 1.K.T.(.( * o 1.(.z.pX= IX=X= V.~.G.q X 1 CX=.~ 1X= 1 1X= o VX=X=X=X=X= V VXd V.~ V.rXd o.~.q h.p.q o.p.M @.M.. #.qX8.~X= k k R R j.# 1 1X= o.( hX= o P o o.( o o 1.i   a *.p.i    .p.K.p.p t.M @ @ @ @.M @ @X=.(.(.eX9 '.q V o VXd VXd 1Xd o V o.(Xy   a o H * P h.,.(.p h.p #.(.( #Xd o kX=X= o o o.(.(.( h.( H.( V.<.( &.2 k o.q *.< W W k.D.D.b.: & k VXd & J    .bXs.D &Xd.~.<Xr.{ &.D o.< o.< &.D d   a.D.D.:X<  .i.D oX#   WX<  X< o XX<   U V V VXy   a o.~ 1.D.:.DXd.D.,   d X o V V X 1.K.T.(.( * o 1.(.z.pX= I a  .i.~.G    X9 CX=.~ 1X= 1 1X= o VX=X=X=X=X= V VXd V   a.rXd o.~.q h.p U     O @X;.i #.qX8.~.].V k R R j.# 1 1X= o.( hX= o P o o.( o o 1 o.~.e *.p.p.G H.p.K.p.p t [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&Xd V.: V.e.z V o.~ M.I M M.I M MXa M M g M   M MXa M M.I M M   M MXa M M g M M M M.I M M.I M M   M M.I M MXa M M g M.I M MXa M MXa M MXa M M.I M M.I M g M M g M M   M M.I M M g M M M.I M.I M M g M M   M M   M M   M M.I M M   MXa M M.I M M.I M M.3 M M.%X@.IXa M a M M.I M M.I M M.I M M g M M g M M M M g M M + M M g M M.3 M M   M M.I M.I M M.I M M.I M M.I M M.I M M a M MXa M M g M M.I M M g M M   M M g M M M M g M M   M M g M M   M M.I M M   MXa M M g M M   M MXa M MXa M M.I MXa M MXa M M   M M.I M M.I M M.I M M M.F.F.F.F.F.F.V.:.4.:.: V.:.D.D.4.:.p # *.~ o o.e I I.K I I 1 C o.~X= 1 1 1X=X= 1.( o 1 o VXd VX= o o o o 1 1 1Xd V oXd.rX=X=X= o oX8X=.(.MXb t.K t.K H * o P k k $.6.L 1 1X=X=X=.p oXd.( V o o o.~X=.,  X<XX.TX#  X#XdX8 o 5., [X9 J @ t @ @ @ o oXd.,  .*X8X= V oX8 o.r oXd.( kXd V    .i O h #.(.pXi.p.K O t.T.(X8.p.pXiX9X9 oX<.,.4.h U.iXxXX s.iX9 k o.b &.:.( oX9X9 } U & V kXs.D.: k *.<Xd L  X#.: LX#.i.D.<X9   }Xd.<.~Xd oXdXs.bX<   y.:X0.: a  .*Xd V     [.5   U.~ 1.{  X9.: V XX<  X< 1 1 V V V.:.: ~    .*.,.,.P.DX<X< L #X9X9 o o.e I I.K I.4     W.~ U    .*X=X=Xy.,Xy.iX9 V.HXyX9.i o o o 1 1 1 U  .,Xd.rX=X=X= o o.o  X#.M.i.*.K t.K -X9X9X9 k.VXg L {.*.,.iX=X=.p oXd.( V o o o.~X= o oX=XX.T # VXdXdX8.z.G.e [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.a V.: V...`.D.DXdXd M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M  Xa M M M M M M M M M M M M M M M M M M M M M M M M M ( ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F i.4.b.4.:.:.4.: X Z CX=X=.rX= o.~X=.G I.p.h.e o.r C 1.~.f V 1X=.~ o H o CX= o o.fXd o.r.( o 1.~.c 1 V.~ V o o P.~ 1.~ o o 1 @Xb t.K t t.p o o P.( O R m * * oX= 1.(.~ o *.9.~X8X=X=X=.e    Xv hXv  .{ W o.0X#X<.Z a   J hX9.,., U aX9X<    .,Xl.]X#X9.i.3 *.~ o.(.(Xd '    .1 m h # h.T.qX= h.*.,X9X9.W W.( d  .,.i.,  .s.( o a  .; o    .;X<.WX@ d a.i.q    X0Xs.:.+.{X<       & & }   }X9X9    .D L a  .{ } o o oXdXd &.b.{  Xr.D V o    .< V.i    .`    .:Xd W     -.: V V.{  XyX= 1 X V.:.:.D L  .3.,X<  .3 XXz  .{X= a   o.~X=.G I.p.hX9  Xh C.4.{  .i 1.]X#.3 2.i  X# oXi.3  .i.r ~  .,.~.cX9  Xy V o o P.~ 1.~ a  X<X<.F t.K t t.pX#  Xv.( &  .5.VX9     1.(.~Xy.{.+X9      X=.eX. O P h tX=.~ o o # #.E 1 [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.K...p V V.DXd.D.D M M M M M M M M ( M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.7   M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M M.F.F.F.F.F.F & V.D.:.D &.:.D &XdXd o.~ V 1 1 o 1.fX=.f 1 CX=.zX=X= X X.~X= IX=.(X=.~ V.~.~.~.f V 1 1 h.( o oX= * 1 o o.D V 1X= oX= o oXd @ tXb @ hXd o V o V o # k P k.2 *.( 1 oX= I.9XX oX=.(.(.[X5    .iX9X9.4Xd o o.,   o o   a.~.eXr  .+.B a.,Xt  X# @.p d  .; *X9.(.(.q hX=.z.3  ., h.[ j h.q.(.pX8 U  Xy # *  .3.(Xy  X@ o.(     *.(X<  .!X..i.{ o.+  X<.V a.U W  .3 &.DX<   U t    X0.b.: a   y.*.*  .{.: V.3  .:.<Xd.D.< o o k J     e.( o.:X#   V.K.,  .{ VX@  X0.DX<     V V.:Xi     [ 1 o 1 &.D o RX<  .,.D &     &Xd.3   VXi., 1 o 1.fX=.f 1.{  X#X9X9.i W.~X=.,  XiX=X9  .i.~.~.3  .4 1.i  .i oX=.{   W o.D V 1X= o.4    .{  .,Xb @ hXd o.3  Xi o e  ., U.!  .3 1 oX9  X1XX V   a.(.[ ..#.(.p 1 oX=Xd o o @.K.z o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.(.p.~ VXdXd.D.: &.: VXd V V V.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F l.:.D.:.:.:.:.:.D &.D o V V V 1X= XX=X= 1.~ oX= CX=.pX= 1 oX=.p 1.Y 1.~ 1 V 1 1 o.~ V 1.(X=.(.Y 1 oXd.<.~ V V 1 o o.r X 1.~.K H t.p.~ V o V o.rX=.p * k P.~X8.( 1.f H h k.< oX=.(.( B.i  .3X= oX= oXd * c  .o.p U  ., V o u  Xv o V o L  .i.K t d  X< V o o.(.p.hX8 H    Xr s 4 BX=X=.T.KXi  .3.K.T.B     hX<   U o.c  .3 P * L  .i HX< d.(.,  .i P.V.: d   }.~ *     I J  .3 &.D.P     } o }  Xr.b.H  .{.D & l.D & l k.< L  .{.: oX: *.VX#.3.,     LXdX0X#.3.,    X< V VXd.i  .{.:.~ V.D X X * k a  Xi.:Xi  .{.D & y   U V L 1X= XX=X= 1 V    XyX=.pX= 1 o.*  X#.Y 1.{  Xi 1 [  .{ V 1 a   e.Y.4  .3.<.~ V V 1 o o '   a.*     J.p.~ V W  .3.rX= L  .{ PXy  ., 1.f.5   J.<Xy  .3.( B B h.pX= oX= oXd *X8.p.K.p V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.C o VXdXd &.:.:.:.:.<Xd & &.:.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.V.:.:.:.b.D.:.: V V V.q o.~.~ 1.~ 1 1X=.f 1 1.~ 1 1.(XXX= 1.f.p.~.~X= 1.~X=X=X8.q 1.~.G.q 1X=.~.4 VXd V V 1 1 V oXd V V V o.p @ @ H.(Xd o.~.< * 1.~X8 o.( 1.~ o.p H h P P P & o.(XX.1.3  X9 *.~ * o V o.,  .*.(.i  Xy.D V     h.h.(X=.,  Xd.p.M.0X#   L.p o o.#.( HXX    .i h.X B.p H @ H.W   L.T.hXy  .{X..3  .:.(.i  X9 BXX.!  X# k.s s B     o *.DXdX<  Xy & &.3   o., a.H &.DX9  .3Xd.:    .; &X9  .iXd.D &.:.D &.:.b.,  X<.DX=.(XX *.K..X#  X#Xd &.:.:.:X<   a J &.:.D.,  X<.D V.:.: X.: kXy  .,.:.b.+  X< V VX<  X9 U V 1.~ 1 1X=.fXy    .Z 1.(XXX= 1.,  Xy.~Xt  .{X=X= p  X9.~ c  .{X=.~.i  X9 V V 1 1 V oXdX#  ., o.,  ., H.(XdXy  .+ * 1.,  Xy.(X<  .i.p HX#  Xd.V a.3 ~XX.1 R.pX= *.~ * o V o.p H I.(.q [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O *X= o.~XdXd 1 oXdXdXd VXdXdXd.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.FX5.:.:.DX=.~ V V V V V.~X= o X.f 1X= 1 V 1 1X=.f C C.~ X.f.(X= o.~.<.q.r C.~ V oX= h.q C o 1 1 *.~ V 1.~ V V HX= 1 1 o.~.D o.f.. @.~.e o.Y.c.Y o o o.p.e.q V H.( V V.~X8 h @ R.( o o J     U.q *Xd.<X= #    .].q.3  Xi VXl  X<X8.(.q o  .s @.0 JXX.Q.5 aX= # h.hXX oXXX<  X< hX. . h.p.Q.(     %XX *.s  X+ %  .,Xd &.3 a V P P R   aX< U oXv  .UXdXdXd &.3   o e.D WXx.i.iX0Xd V.<X#  .+.<.i   y J &.{  .VX0XdXd V.<Xd.D.< a   U.: H *Xd.h.<X9  .{ VXdXd 1 o.*   a.*XdXdXd o a   U.D.: X V V.:X8Xx  .i.DX=.3.{ W V V U  .,Xy X.f 1X= 1 V 1X<  .{ C C.~ X.f.(     V.<X<  X9.~ VX#  .:.~.3  X9 1 *.,  Xl W V V HX= 1.Z    .+ o.*    .*.e o.,  Xy W o a.5.e.q.{   ~ W V V uXy.i.H.( o o k.2.(X=.q *Xd.<X= # #XdX=.q V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& 1X=X=.( * o.q o o.<.~ VXdXd.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F i.D.: o h o X V.~ V.~ 1 o.~.G.f 1 1 X X 1 oX=X=.G 1 1 X.~.~ C H.q o.(X= 1 o 1X=.pX= o VX=X=.(.~.~ VXd V VX8.E 1 1 V 1.D XXd 1.. @.p.p.( X.f V oX=X=.(.f.p V.p.#.: V.(.D 1X8 * o o.( L     o.( o V.~ H @     W.i.{  .* UX<  Xv o.p 1.*   u U.:.i J #.i a.( *.< E * & o ~ a  .i P.6.*.,.V o.{  .( * L  Xv R U  Xx &X9 aX;Xd P * oX#  .,X= o.,  Xy oXdXd ~  .{Xy UXd.3.3 0 ~.DXd V.:     ~ RX#  Xy.iX0   a.* L.<.D oXd &.bXv    .D 1XXXd.<X=X<  X9.]X=.( * o U aX#X0.~ VXdXdXy    .~ X.:.D.:.: V.`.3  Xi oXx.{ W V.~ V V  .3 V.G.f 1 1 X X 1 a  X9.G 1 1 X.~.~    .~ UX#  XlX9 1    XtX<.,   U.i.~.3  .*X< VX8.E 1 1Xy     [Xd 1X#  .,.p.(.3   UX9.4  .,.f.p    .)Xy V.i aX9.Q * o o.( P.( o o.( o V.~ H @.p.D V.p V [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.< 1Xd V.D X.D o o VXd X &Xd.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F.F J.b o # # V V V V V V 1 1 1 C 1.f 1 1 1.~.~ oX= C o X 1.~ 1 1X=X= oX=X=.(X= 1X= 1.~.~ X.~ * * VX= o V V.eX=X= 1.~ V V.D o.: 1X$...e.E.(.4 1 1 1 V o CX=X= VX8.h V V 1.( oX=.( *.(.i a    X9 WX= o.~.p #X9   a.*X#  X<Xd a  .] o * o U  .5 U *.,.,.iX#.*XX o * & E.2 &.DX0X< a  .5X< W.=.( JX#X<XxX<.*.(.<.+  .{ }X#Xf.DXd o.< oX#.5 W.~.q a   WX= o.<X0 a  Xr oX0 a      X#.:XdXy  .{Xd.# y  X#Xd.: a  X9Xd V.D.(XdXi } a     5XiXd.D LX# }.P.< 1Xd V -.,.U U o VXd X.VX9 a    X9 U.:.:.DXdXd.KX9.3X9X9.i W V V V V V  Xl 1 C 1.f 1 1.4X#    .{Xy o X 1.~ 1X9    Xy.i  X#.] 1.3  .{ V.,  X#Xd V.3  X< V.eX=X= 1.* a    .,XiXy a    .i.(.{  X< 1X<  .iX=X= a  .i V V.,      .3.V.( o.qX=.( o oX= o.~.p # *Xd V.pXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd.~Xd.DXd V.:Xd.< o o.q 1 X V 1 1XdX=.4 V V o *.D X I.f I.GX=.D.: X V V X 1X=X= 1 1.f V.~ o.~ o.~ X.f.(.Y 1.~.q CX8X=X=X=X8 *X= C.fX= * 1 X.~X=.p 1 o.e.M #Xd.:.: V.: & VX=X=X= 1.G @X=.p.pX= V 1 o.~ 1X= C 1.eX= H.: 1Xd VX=X= B o o.:.D.~ oX=.(X=.p # o oXdXd V 1 o.:.:.:Xd.(.~.( H.p o.p h #.(.p.#.DXd o & & & *XdXdXdXd o o.<.( B H *.< &.=XXXX * PXX P.< k.( & oXX.< *.~ o.~.q o.~.D.~.<XdX8.(X8 o.< & oXdXdX8XdXs o &.:.D P.(.< o *X= oXX.(.p.( *.1 k.X k E.( o V V.r.TXd o k.2.b.p l V &.~Xd.DXd V.:Xd.< o o.q 1 X V 1 1XdX=.4 V V o *.D X I.f I.GX=.D.: X V V X 1X=X= 1 1.f V.~ o.~ o.~ X.f.(.Y 1.~.q CX8X=X=X=X8 *X= C.fX= * 1 X.~X=.p 1 o.e.M #Xd.:.: V.: & VX=X=X= 1.G @X=.p.pX= V 1 o.~ 1X= C 1.eX= H.: 1Xd VX=X= B o o.:.D.~ oX=.(X=.p # o oXd.H W 1 V.P.:.:.:Xd.(.~.( H.p W.p h #.(.p.#.DXd o & & & *XdXdXdXd o o.<.( B H *.< &.=XXXX * PXX P a   o & oXX.< *.~ o.~., U.~.D.~.<XdX8.(X8 o.< J VXdXd p.i.P.i.3  .U P.(.< o *X= oXd.(.p.(Xd E k.X k E.( o V V.r.TXd o k.2.b o l V &.~Xd.DXd W.:Xd.< o o.q 1 X V 1 1XdX=.4 V V o *.D X I.f I.GX=.D.: X V V XX<X=X= 1 1.f V.~ o.~ o.~ X.f.(.Y 1.~.q C.QXtX=X=.R *X= C.f.4 * 1 X WX=.p 1 o.Z.M #Xd.:.: V.: & VX=X=X= 1.G @X=.p.pX=Xi 1 o.~ 1X= C 1.]Xt H.: [ U.*XyX#   a o.:.D.~ oX=.(X=.p # o oXdXd V 1 o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.D &Xd VX= oX=.qXd 1 V * V 1Xd V.r oXd V oXd o o 1.K t.e.z 1 V V.DXd.: V 1.( 1 1.~X= X 1.~.~ o o.f.~ X X 1X= X 1X=.f I.fX=.( oX=X=X=.~ 1 C.~ 1.~X=.K.E.p 1.=.4 1 V.D.D.b VX=.~.(X= @.~X=.e.qXd X 1 V 1 V V 1 @ t.M V o V VXd.r.M k VXdXd o.(.(X=.(.#.T o.(.( o.< 1 oXdXd.D o.( H.p h #.(.T o P o * PXd o o.D.D &.<.<.<.< & o.<.< o $XX.( &Xd o.< k o o P.< k o o.< * hXX o V.~X=.q o o V.< *.< * *.( k.<XdXd VXd * &.:Xd V &.( s P V o * h.#.~.(.#.# k k.< & & & *Xd.< * *XdXd.D.b.b.: o &.~Xd.D &Xd VX= oX=.qXd 1 V * V 1Xd V.r oXd V oXd o o 1.K t.e.z 1 V V.DXd.: V 1.( 1 1.~X= X 1.~.~ o o.f.~ X X 1X= X 1X=.f I.fX=.( oX=X=X=.~ 1 C.~ 1.~X=.K.E.p 1.=.4 1 V.D.D.b VX=.~.(X= @.~X=.e.qXd X 1 V 1 V V 1 @ t.M V o V VXd.r.M k VXdXd o.(.(X=.(.#.T o.(.( o.< 1 o oXdXd.D o.( H.p h #.(.T o P o * PXd o o.D.D &.<.<.<.< & o.<.< o $XX.( &Xd o.< k o o PXf  X# o.< * hXXXy aXiXy U o o V.< *.< * *.( k.<XdXd V.i   &.:Xd W  ., s P V o * h.#.~.(.#.# k k.< & & & *Xd.< * *XdXd.D.b.b.: o &.~Xd.D &Xd VX= oX=.qXd 1 V * V 1Xd V.r oXd V oXd o o 1.K t.e.z 1 V V y.{ ~.i.Z.( 1 1.~X= X 1.~.~ o o.f.~ X X 1X= X 1X=.f I.fX=.( oX=X=X=.~ 1 C.~ 1.~X=.K.E.p 1.=.4 1 V.D.D.b VX=.~.(X= @.~X=.e.qXd X 1 V 1 V V 1 @ t.M V a W VXd.rX# a VXdXd o.(.(X=.(.#.T o.(.( o.< 1 o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.2.b.:.bXd o * o V V 1.~X=.~ 1 o X 1 V.: V.:.4.D XX=.p # /.p.f.~.D V V V o o o X X 1 X.f 1 1 o.~ 1 1X=X=.Y XX=.f.f.( IX=.zX8.z I CX=X=X=.G o.G oXd #.(.~ o V 1 V.~ o.:.D & oX=X8.q.p.. o V o.( VXd * o o oX8.( t.M.M o.~ o VX= IXb R o.r o oX=.( o.pXX # #...(.<Xd 1Xd o VXd o.(.p h.(.(.< OXd * P V.D oXd.<Xs & & & &.~ P & &Xd o.(.# $XX.D.< * * o k P k.<.< o * *XX.(.( o 1 o.(.(.q VXd VXd &.D V.<.< & o.D &.D &.< &.b.<.:.M $.< o.~ k.( o oXd & EXd &.:.b.b.b.D.b.:.D o o l.b.<.:.D * V V.D.b.:.bXd o * o V V 1.~X=.~ 1 o X 1 V.: V.:.4.D XX=.p # /.p.f.~.D V V V o o o X X 1 X.f 1 1 o.~ 1 1X=X=.Y XX=.f.f.( IX=.zX8.z I CX=X=X=.G o.G oXd #.(.~ o V 1 V.~ o.:.D & oX=X8.q.p.. o V o.( VXd * o o oX8.( t.M.M o.~ o VX= IXb R o.r o oX=.( o.pXX # #...(.<Xd 1XdXd o VXd o.(.p h.(.(.< OXd * P V.D oXd.<Xs & & & &.~ P & &Xd o.(.# $XX.D.< * * o k P k.+  X< * *XX.(.( U  .{Xi.(.q VXd VXd &.D V.<.< & o.D & -  Xr &.bXr.{ R $.< o.~ k.( o oXd & EXd &.:.b.b.b.D.b.:.D o o l.b.<.:.D * V V.D.b.:.bXd o * o V V 1.~X=.~ 1 o X 1 V.: V.:.4.D XX=.p # /.p.f.~.DX<  X< V o o X X 1 X.f 1 1 o.~ 1 1X=X=.Y XX=.f.f.( IX=.zX8.z I CX=X=X=.G o.G oXd #.(.~ o V 1 V.~ o.:.D & oX=X8.q.p.. o V o.( VXd * o o oX8.( t.M.M oX#.i WX= [.{.H o.r o oX=.( o.pXX # #...(.<Xd 1Xd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&.D.D.< V.~.D & VXd * 1 o C V oX=X=.~ XXd V.< V 1 1.p t t.(Xd VX=.K oX= o * o X X X C X.Y X 1.~ 1X= C.~X=.~.fX=X= I 1 1.q C.f IX= I.p.q.p.qX= *.(.rX=X=X=.( V *.<Xd V.D.( V.Y 1 o V.D.pX=X=.(Xd.D.<Xd.D h h.(.h t . # * o o q @X. oXd oX=.(X8.(.( k *.e.p.p *.<.(XdXd V & P *.q h.q V.2 &.D lXd.< R.<.< *XdXd.D k k.2 &.D.: & V l &Xd R * * &.<.<.< * k & P.#.#.<.<Xd *Xd *X= & o P &XdXd &.< V &Xd.<Xd &XdXd.D.: & l.b.b.D.:.D.: &XX.< o hXX V o o.<.< &Xd.:.D o.DXd VXd.< &.: &.DXs.qXd.D VXd.D.D.< V.~.D & VXd * 1 o C V oX=X=.~ XXd V.< V 1 1.p t t.(Xd VX=.K oX= o * o X X X C X.Y X 1.~ 1X= C.~X=.~.fX=X= I 1 1.q C.f IX= I.p.q.p.qX= *.(.rX=X=X=.( V *.<Xd V.D.( V.Y 1 o V.D.pX=X=.(Xd.D.<Xd.D h h.(.h t . # * o o q @X. oXd oX=.(X8.(.( k *.e.p.p *.<.(XdXd & V & P *.q h.q V.2 &.D lXd.< R.<.< *XdXd.D k k.2 &.D.: & V l &Xd R * * &.<.<.< * kX;X9XrXr d.<Xd *Xd *X= & o P &XdXd &.< V &Xd.<Xd &XdXd.D.:.VXxX<X< -.:.D.: &XX.< o hXX V o o.<.< &Xd.:.D o.DXd VXd.< &.: &.DXs.qXd.D VXd.D.D.< V.~.D & VXd * 1 o C V oX=X=.~ XXd V.< V 1 1.p t t.(Xd VX=.K oX= o * o X X X C X.Y X 1.~ 1X= C.~X=.~.fX=X= I 1 1.q C.f IX= I.p.q.p.qX= *.(.rX=X=X=.( V *.<Xd V.D.( V.Y 1 o V.D.pX=X=.(Xd.D.<Xd.D h h.(.h t . # * UX9 ' U h oXd oX=.(X8.(.( k *.e.p.p *.<.(XdXd [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.&Xd.~Xd.~ VXd.~.D.: V V VX=X=X= V X.D.4 V 1Xd V X.e @ #.. / h.r @ t H.( o.q C.~ Z.f.~ X 1.Y.f.~ 1.~.~ 1.~.fX=X= I I.f X.rX=X=.f I.z I.(X=X=X=X= * oX= k *.#.X.<X=.( o * V o X V.< &.<.p h.( o &Xd.< & o * k o.r t.M.T.( o.p t @.M o V.<Xd o.qX= P o.( o.e H.p.<.#.# &.<Xd & o o k.<Xd &.D &.bXs.D.<.#.<Xd &.< *.X 2 k &.#Xd.D &.D & & * R & &.<.( P k & &Xd.h & o.w & P *.X & PXdXd.D.< & k & & &.D &.< oXd.< &.D V k.<.DXd &.:Xs.<.< & V.#.(.~ *XX *.(.#Xd &Xd P.D o *Xd oXd V &.:.p.~.b.DXd oXd.~Xd.~ VXd.~.D.: V V VX=X=X= V X.D.4 V 1Xd V X.e @ #.. / h.r @ t H.( o.q C.~ Z.f.~ X 1.Y.f.~ 1.~.~ 1.~.fX=X= I I.f X.rX=X=.f I.z I.(X=X=X=X= * oX= k *.#.X.<X=.( o * V o X V.< &.<.p h.( o &Xd.< & o * k o.r t.M.T.( o.p t @.M o V.<Xd o.qX= P o.( o.e H.p.<.#.# & V.<Xd & o o k.<Xd &.D &.bXs.D.<.#.<Xd &.< *.X 2 k &.#Xd.D &.D & & * R & &.<.( P k & &Xd.h & o.w & P *.X & PXdXd.D.< & k & & &.D &.< oXd.< &.D V k.<.DXd &.:Xs.<.< & V.#.(.~ *XX *.(.#Xd &Xd P.D o *Xd oXd V &.:.p.~.b.DXd oXd.~Xd.~ VXd.~.D.: V V VX=X=X= V X.D.4 V 1Xd V X.e @ #.. / h.r @ t H.( o.q C.~ Z.f.~ X 1.Y.f.~ 1.~.~ 1.~.fX=X= I I.f X.rX=X=.f I.z I.(X=X=X=X= * oX= k *.#.X.<X=.( o * V o X V.< &.<.p h.( o &Xd.< & o * k o.r t.M.T.( o.p t @.M o V.<Xd o.qX= P o.( o.e H.p.<.#.# & [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& V.< V * o.< 1XdXd.:.:.: VX= oX= 1 1.Y V.4Xd V V.z 1.Y.....p H t.M H.h.(X= 1 C.~Xd VXdXd 1 1 X.~ 1 1 1 X V 1.G I.f.G.~.fX=X=.f.p.p I.p.e.p 1.fX=.D V.D * k *X=.( o o.( PXd.:.: o.<.DX= H.( o V P.~.< H o.< o.( @.M t.p.e o.(.KXb k o.<.~ 2.p o.X o.~.q.e h.p H.M.M oXX o *.<.# o.(XdXs &.b.D l l.D.w &.D o.b &.D o R.X EXd &.:.<XdXd V.(.bXs &.(.<Xd.< V.< oXd oXd.< &.< k.2.< &.< oXd & &.:.D &.b.DXd & o.<Xd.D.D oXd &.DXd.b.: *Xs & &XX o o s.(Xd o o.( o o *Xd.<Xd V & 1.<.~ &.qX0.b VXdXd V.< V * o.< 1XdXd.:.:.: VX= oX= 1 1.Y V.4Xd V V.z 1.Y.....p H t.M H.h.(X= 1 C.~Xd VXdXd 1 1 X.~ 1 1 1 X V 1.G I.f.G.~.fX=X=.f.p.p I.p.e.p 1.fX=.D V.D * k *X=.( o o.( PXd.:.: o.<.DX= H.( o V P.~.< H o.< o.( @.M t.p.e o.(.KXb k o.<.~ 2.p o.X o.~.q.e h.p H.M.M o.(XX o *.<.# o.(XdXs &.b.D l l.D.w &.D o.b &.D o R.X EXd &.:.<XdXd V.(.bXs &.(.<Xd.< V.< oXd oXd.< &.< k.2.< &.< oXd & &.:.D &.b.DXd & o.<Xd.D.D oXd &.DXd.b.: *Xs & &XX o o s.(Xd o o.( o o *Xd.<Xd V & 1.<.~ &.qX0.b VXdXd V.< V * o.< 1XdXd.:.:.: VX= oX= 1 1.Y V.4Xd V V.z 1.Y.....p H t.M H.h.(X= 1 C.~Xd VXdXd 1 1 X.~ 1 1 1 X V 1.G I.f.G.~.fX=X=.f.p.p I.p.e.p 1.fX=.D V.D * k *X=.( o o.( PXd.:.: o.<.DX= H.( o V P.~.< H o.< o.( @.M t.p.e o.(.KXb k o.<.~ 2.p o.X o.~.q.e h.p H.M.M o [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O.& V *XdX= oXd o o 1.DXd V.:.:.~ X VXd oXd V 1 1 o VXd.: 1.K /...M.M tX..(.(.z o VXd.D V o o 1.~ 1.~X=X= 1 oX= , I.GX= o C.zX= I.K.E H I.e.q 1X= o *.< h.D V o.< o &Xd oXd *Xd o.( oXd.<Xd.< * V * h o.< P P *.:...M t h o oX8 @ h.<.D.(.q o * P o.(X8.q oX8.p.K H.h P h.( V.< P * PXs &.w.D.D l &.DXd & & &.D l &.DXd &.<.< V.q o V * E & *.D & & &.DXd.< oXd * P k & *Xd k.<.D PXX.X R P.D.< k E.w.D &.D *XX.<.< * o.< & V.D.<.<Xd.D.D.b.< V *.~ o o oXd.DXd o o.~ o o.D &.(.2.D.DXdXd k o oXd V *XdX= oXd o o 1.DXd V.:.:.~ X VXd oXd V 1 1 o VXd.: 1.K /...M.M tX..(.(.z o VXd.D V o o 1.~ 1.~X=X= 1 oX= , I.GX= o C.zX= I.K.E H I.e.q 1X= o *.< h.D V o.< o &Xd oXd *Xd o.( oXd.<Xd.< * V * h o.< P P *.:...M t h o oX8 @ h.<.D.(.q o * P o.(X8.q oX8.p.K H.h P R h.( V.< P * PXs &.w.D.D l &.DXd & & &.D l &.DXd &.<.< V.q o V * E & *.D & & &.DXd.< oXd * P k & *Xd k.<.D PXX.X R P.D.< k E.w.D &.D *XX.<.< * o.< & V.D.<.<Xd.D.D.b.< V *.~ o o oXd.DXd o o.~ o o.D &.(.2.D.DXdXd k o oXd V *XdX= oXd o o 1.DXd V.:.:.~ X VXd oXd V 1 1 o VXd.: 1.K /...M.M tX..(.(.z o VXd.D V o o 1.~ 1.~X=X= 1 oX= , I.GX= o C.zX= I.K.E H I.e.q 1X= o *.< h.D V o.< o &Xd oXd *Xd o.( oXd.<Xd.< * V * h o.< P P *.:...M t h o oX8 @ h.<.D.(.q o * P o.(X8.q oX8.p.K H.h P [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXd o * V o.~ V.(.(X8 V V V VXd.< V V oX=X= o 1 XXd V.D V , # @...M.(.M tX8XXX8 1 o oXd 1.~.~ 1 o C 1 I.zX= I , IX=X=.( C.~X= C C.p h.p.fX=.~X= o.~ h.(.p o V.(Xd oXd k o 1 * P P.(.< V k.<.<.D.< o *Xd.< o hXd 2 t.M @ #X=.(.T #.qXd oX=X= o P.q 1 oX=X=.~.~.(XX P H.p.# k o *.< &.<.D l &.b.< & & & l &.D k &.D &Xd.< o * o *.<.< * &.D & PXdXs VXd &Xd o k o P *.( o P.2.< k.< kXd & &.< * & VXd l &.<.<.< * PXd.<.<.( VXd.<.X &.D & &.D oXdXd.< o P &.: & o.<Xd V.~.( V V PXd o & * 2.hXd o V o * V o.~ V.(.(X8 V V V VXd.< V V oX=X= o 1 XXd V.D V , # @...M.(.M tX8XXX8 1 o oXd 1.~.~ 1 o C 1 I.zX= I , IX=X=.( C.~X= C C.p h.p.fX=.~X= o.~ h.(.p o V.(Xd oXd k o 1 * P P.(.< V k.<.<.D.< o *Xd.< o hXd 2 t.M @ #X=.(.T #.qXd oX=X= o P.q 1 oX=X=.~.~.(XX P H.p h.# k o *.< &.<.D l &.b.< & & & l &.D k &.D &Xd.< o * o *.<.< * &.D & PXdXs VXd &Xd o k o P *.( o P.2.< k.< kXd & &.< * & VXd l &.<.<.< * PXd.<.<.( VXd.<.X &.D & &.D oXdXd.< o P &.: & o.<Xd V.~.( V V PXd o & * 2.hXd o V o * V o.~ V.(.(X8 V V V VXd.< V V oX=X= o 1 XXd V.D V , # @...M.(.M tX8XXX8 1 o oXd 1.~.~ 1 o C 1 I.zX= I , IX=X=.( C.~X= C C.p h.p.fX=.~X= o.~ h.(.p o V.(Xd oXd k o 1 * P P.(.< V k.<.<.D.< o *Xd.< o hXd 2 t.M @ #X=.(.T #.qXd oX=X= o P.q 1 oX=X=.~.~.(XX P H.p [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.O PXd o.D.( o o *.~ o VXd X.r.~ o.: V.~ 1X=X= 1.G oXd.4 V.p.K @ @.M h.~ o.(.~.qX=.( 1.rXd 1 V C 1 1X= o 1X=...T I C.eX= oX=.qX=.eX8.q.q.~.~.c * o VX= * V.<.~ H.(.(Xd &Xd P V o k P * VXd.DXd o o * * o.q.< P R.p.M.M.K @.( H @ @.# o o o.(.(.~.~.(.~ o o P.< o.<Xd.( H h.<.<.( & *.w &.D & & &.DXs & &.D & & k.D &Xd o.(.< & & & & PXd &Xd o.(.( & & & kXdXdXX *.< k PXX *.2.<Xd & &.<Xd & & & P P.D &.D k.< o P.(.<.q.(.<.~ o &Xd &.:.: & &.< &Xd.< * l.:.D o oXd o o o *.~.< V oXd o &.( V o PXd o.D.( o o *.~ o VXd X.r.~ o.: V.~ 1X=X= 1.G oXd.4 V.p.K @ @.M h.~ o.(.~.qX=.( 1.rXd 1 V C 1 1X= o 1X=...T I C.eX= oX=.qX=.eX8.q.q.~.~.c * o VX= * V.<.~ H.(.(Xd &Xd P V o k P * VXd.DXd o o * * o.q.< P R.p.M.M.K @.( H @ @.# o o o.(.(.~.~.(.~ o o P.< o.<Xd.( HXX h.<.<.( & *.w &.D & & &.DXs & &.D & & k.D &Xd o.(.< & & & & PXd &Xd o.(.( & & & kXdXdXX *.< k PXX *.2.<Xd & &.<Xd & & & P P.D &.D k.< o P.(.<.q.(.<.~ o &Xd &.:.: & &.< &Xd.< * l.:.D o oXd o o o *.~.< V oXd o &.( V o PXd o.D.( o o *.~ o VXd X.r.~ o.: V.~ 1X=X= 1.G oXd.4 V.p.K @ @.M h.~ o.(.~.qX=.( 1.rXd 1 V C 1 1X= o 1X=...T I C.eX= oX=.qX=.eX8.q.q.~.~.c * o VX= * V.<.~ H.(.(Xd &Xd P V o k P * VXd.DXd o o * * o.q.< P R.p.M.M.K @.( H @ @.# o o o.(.(.~.~.(.~ o o P.< o.<Xd.( H [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O.OXcXt.:XtXtXdX6Xt XXt.:Xt.Y.4.: X X.:.:.4 e.Y 1.4.-.4 i.Y.~ 1X= CX=._Xt.a X.:.4.4 XXdXdXdXdXt.Y.D.Y XXt X.~ V.Y V.Y X.~ 1 1.~.~ V.Y eXdXdXd.}.4.4Xt.:.4Xt.:.4.4XdX%.:.:Xt.:.:XtXt.: XXt eXdXt.S.S e.: e e eXd eX= B BXX.O._.} X.~ o.4Xt eXd V.4XtXtXtXtXtXd.aXt eXd oXe eXt e _.b {.b.bXi.-.b.:.b.b { _.b.-.bXt e.bXt e.S.b.b.:.b.S.4.:.:.b.:.b.S.b.S _.-.-.S e _.S { eXt e.S.S.b _ _.S.S.:.b.-.b _.b.:.-Xk ~.S.S eXt.w.~ e _.S.:Xi.-.-Xi ~.-.S.:.-.b.-.b.SXtXt e.:XtXtXtXtX%XtXt.b.-Xt.-.b oXt.SXt.:XtXtXdX6Xt XXt.:Xt.Y.4.: X X.:.:.4 e.Y 1.4.-.4 i.Y.~ 1X= CX=._Xt.a X.:.4.4 XXdXdXdXdXt.Y.D.Y XXt X.~ V.Y V.Y X.~ 1 1.~.~ V.Y eXdXdXd.}.4.4Xt.:.4Xt.:.4.4XdX%.:.:Xt.:.:XtXt.: XXt eXdXt.S.S e.: e e eXd eX= B BXX.O._.} X.~ o.4Xt eXd V.4XtXtXtXtXtXd.aXt eXd oXeXd eXt e _.b {.b.bXi.-.b.:.b.b { _.b.-.bXt e.bXt e.S.b.b.:.b.S.4.:.:.b.:.b.S.b.S _.-.-.S e _.S { eXt e.S.S.b _ _.S.S.:.b.-.b _.b.:.-Xk ~.S.S eXt.w.~ e _.S.:Xi.-.-Xi ~.-.S.:.-.b.-.b.SXtXt e.:XtXtXtXtX%XtXt.b.-Xt.-.b oXt.SXt.:XtXtXdX6Xt XXt.:Xt.Y.4.: X X.:.:.4 e.Y 1.4.-.4 i.Y.~ 1X= CX=._Xt.a X.:.4.4 XXdXdXdXdXt.Y.D.Y XXt X.~ V.Y V.Y X.~ 1 1.~.~ V.Y eXdXdXd.}.4.4Xt.:.4Xt.:.4.4XdX%.:.:Xt.:.:XtXt.: XXt eXdXt.S.S e.: e e eXd eX= B BXX.O._.} X.~ o.4Xt eXd V.4XtXtXtXtXtXd.aXt eXd oXe [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [ [ [ [ [",
".O.O.O.O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [ [ [ [",
".O.O.O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [ [ [",
".O.O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [ [",
".O.O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [ [",
".O.O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [ [",
".O.O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [ [",
".O ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl [ [",
" ^XlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXlXl ["
};


#endif /* USE_XPM */

/* splash background for monochrome or non-XPM compile */

#define spl_bckgnd_width 630
#define spl_bckgnd_height 210
static char spl_bckgnd_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x24,0x08,0x48,0x12,0x22,0x04,0x00,0x41,0x00,0x04,0x82,
 0x00,0x02,0x12,0x00,0x00,0x00,0x44,0x04,0x01,0x20,0x44,0x04,0x00,0x11,0x01,
 0x44,0x08,0x82,0x88,0x80,0x80,0x20,0x42,0x10,0x91,0x04,0x00,0x84,0x20,0x01,
 0x00,0x00,0x81,0x10,0x84,0x04,0x10,0x81,0x40,0x00,0x00,0x22,0x41,0x04,0x40,
 0x40,0x40,0x10,0x80,0x08,0x09,0x88,0x10,0x01,0x01,0x20,0x84,0x20,0x11,0x40,
 0x20,0x22,0x00,0x40,0x02,0x09,0x44,0x24,0x80,0x20,0x01,0x40,0x80,0x90,0x12,
 0x04,0x49,0x90,0x08,0x52,0x48,0x40,0x2a,0x29,0x29,0x01,0x10,0x94,0x84,0x00,
 0x90,0x12,0x00,0x24,0x01,0x21,0x08,0x02,0x0a,0x12,0x02,0x08,0x01,0x04,0x90,
 0x24,0x11,0x02,0xa4,0x24,0x49,0x24,0x42,0x10,0x90,0x00,0x24,0x04,0x25,0x25,
 0x08,0x04,0x90,0x04,0x05,0x09,0x41,0x12,0x20,0x20,0x21,0x02,0x24,0x24,0x05,
 0x21,0x02,0x44,0x0a,0x09,0x80,0x94,0x12,0x48,0x20,0x01,0x11,0x0a,0x04,0x80,
 0x08,0x10,0x00,0x40,0x20,0x00,0x02,0x20,0x00,0x00,0x08,0x00,0x00,0x00,0x20,
 0x82,0x00,0x00,0x20,0x02,0x80,0x88,0x00,0x20,0x00,0x41,0x40,0x40,0x00,0x10,
 0x01,0x88,0x00,0x01,0x00,0x00,0x90,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x88,
 0x00,0x20,0x00,0x80,0x00,0x20,0x02,0x20,0x20,0x00,0x08,0x00,0x04,0x02,0x00,
 0x80,0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x00,0x10,
 0x28,0x20,0x20,0x12,0x80,0x04,0x09,0x04,0x01,0x12,0x20,0x80,0x88,0x24,0x81,
 0x40,0x42,0x84,0x88,0x00,0x20,0x11,0x89,0x20,0x04,0x02,0x48,0x04,0x02,0x10,
 0x08,0x00,0x44,0x40,0x10,0x20,0x10,0x44,0x44,0x48,0x00,0x08,0x49,0x04,0x08,
 0x84,0x20,0x24,0x21,0x88,0x08,0x48,0x10,0x24,0x81,0x20,0x01,0x00,0x11,0x82,
 0x24,0x81,0x90,0x04,0x09,0x88,0x88,0x28,0x04,0x00,0x21,0x10,0x22,0x04,0x21,
 0x44,0x11,0x89,0x40,0x14,0x0a,0x82,0x00,0x24,0x40,0x40,0x01,0x90,0x80,0x08,
 0x09,0x00,0x00,0x20,0x12,0x10,0x20,0x00,0x24,0x09,0x00,0x00,0x08,0x41,0x40,
 0x02,0x80,0xa0,0x04,0x82,0x24,0x01,0x09,0x84,0x04,0x84,0x00,0x10,0x02,0x24,
 0x42,0x00,0x90,0x22,0x21,0x08,0x00,0x00,0x02,0x02,0x02,0x04,0x00,0x10,0x08,
 0x90,0x24,0x84,0x20,0x00,0x20,0x00,0x40,0x40,0x02,0x00,0x00,0x91,0x04,0x04,
 0x85,0x00,0x20,0x04,0x01,0x04,0x00,0x04,0x15,0x20,0x08,0x24,0x01,0x01,0x04,
 0x48,0x04,0x08,0x02,0x20,0x12,0x41,0x04,0x00,0x81,0x00,0x21,0x00,0x80,0x24,
 0x02,0x00,0x08,0x04,0x20,0x09,0x04,0x40,0x20,0x00,0x08,0x00,0x00,0x80,0x00,
 0x88,0x00,0x20,0x01,0x00,0x84,0x00,0x00,0x00,0x80,0x10,0x09,0x10,0x20,0x20,
 0x41,0x42,0x04,0x40,0x04,0x00,0x00,0x00,0x11,0x02,0x22,0x04,0x10,0x90,0x24,
 0x02,0x00,0x10,0x00,0x00,0x44,0x00,0x00,0x08,0x20,0x11,0x10,0x2a,0x14,0x01,
 0x00,0x00,0x90,0x10,0x00,0x00,0x42,0x40,0x84,0x40,0x10,0x80,0x20,0x04,0x12,
 0x08,0x21,0x22,0x80,0x50,0x92,0x00,0x91,0x08,0x80,0x00,0x10,0x08,0x88,0x40,
 0x22,0x49,0x22,0x20,0x22,0x84,0x04,0x00,0x91,0x20,0x44,0x80,0x48,0x22,0x04,
 0x20,0x81,0x08,0x09,0x00,0x10,0x80,0x04,0x00,0x12,0x41,0x12,0x80,0x88,0x00,
 0x91,0x04,0x00,0x00,0x48,0x44,0x02,0x91,0x90,0x10,0x12,0x91,0x20,0x01,0x40,
 0x42,0x15,0x42,0x90,0x88,0x94,0x00,0x40,0x22,0x91,0x00,0x08,0x00,0x00,0x82,
 0x08,0x02,0x10,0x40,0x00,0x04,0x00,0x02,0x00,0x00,0x12,0x00,0x80,0x10,0x24,
 0x81,0x80,0x00,0x02,0x00,0x00,0x08,0x09,0x00,0x10,0x40,0x14,0x04,0x00,0x00,
 0x09,0x02,0x00,0x20,0x02,0x04,0x00,0x00,0x14,0x81,0x08,0x90,0x48,0x40,0x04,
 0x40,0x04,0x00,0x04,0x00,0x40,0x89,0x48,0x00,0x01,0x10,0x00,0x02,0x80,0x40,
 0x00,0x02,0x44,0x02,0x80,0x12,0x90,0x04,0x02,0x00,0x24,0x04,0x08,0x00,0x20,
 0x02,0x22,0x14,0x00,0x22,0x10,0x81,0x08,0x44,0x00,0x49,0x48,0x88,0x44,0x40,
 0x04,0x22,0x04,0x00,0x08,0x10,0x44,0x90,0x10,0x11,0x01,0x40,0x42,0x02,0x10,
 0x80,0x00,0x49,0x22,0x40,0x00,0x49,0x82,0x80,0x40,0x44,0x22,0x01,0x04,0x42,
 0x02,0x02,0x04,0x90,0x08,0x20,0x42,0x40,0x04,0x11,0x20,0x00,0x22,0x10,0x01,
 0x49,0x00,0x09,0x04,0x48,0x40,0x10,0x20,0xa4,0x2a,0x02,0x52,0x54,0x55,0x49,
 0x51,0x51,0xa5,0x92,0xa8,0x94,0xa2,0xaa,0x80,0x00,0x28,0xa2,0x88,0xaa,0x24,
 0x11,0x25,0x12,0x85,0x52,0x89,0xd2,0xaa,0x52,0xa3,0x92,0x44,0x4a,0x4a,0xaa,
 0x12,0x29,0xa8,0xa2,0x2a,0x55,0x24,0x89,0x12,0x48,0x10,0x29,0x2a,0x2a,0x29,
 0x49,0x54,0x28,0x89,0x54,0x54,0xa9,0x22,0x52,0x95,0x94,0x2a,0x51,0x4a,0x85,
 0xaa,0x44,0x22,0x54,0x24,0x55,0xa4,0x50,0x21,0x08,0x41,0x95,0xa8,0x0a,0xa8,
 0x84,0x82,0x88,0x24,0x24,0x88,0x08,0x04,0x45,0x42,0x10,0x21,0x54,0x44,0x02,
 0x49,0x22,0x11,0x81,0xa4,0x92,0xa4,0x50,0xa4,0x54,0x24,0x84,0x08,0x48,0x54,
 0x92,0x22,0x21,0x11,0x48,0x8a,0x02,0x08,0x80,0x00,0x11,0x22,0x41,0x11,0x40,
 0x84,0x80,0x84,0x84,0x90,0x92,0x4a,0x22,0x81,0x22,0x12,0x89,0x04,0x22,0x25,
 0x81,0x12,0x11,0x29,0x01,0x92,0x08,0x81,0x82,0x20,0x22,0x12,0x08,0x21,0x10,
 0x42,0x52,0x29,0x02,0x10,0x29,0x51,0x4a,0x41,0x25,0x52,0x50,0x88,0x94,0x4a,
 0x84,0x82,0x90,0x20,0x24,0x09,0x4a,0x54,0x12,0x24,0x10,0x25,0x11,0x41,0x89,
 0x52,0x52,0x15,0x81,0x08,0x48,0x4a,0x4a,0x11,0x28,0xa9,0x50,0x55,0xaa,0xa4,
 0x48,0x14,0x40,0x02,0x29,0x15,0x29,0x52,0x4a,0x44,0x10,0x48,0x54,0x48,0x49,
 0x52,0x52,0x49,0x90,0x54,0xa4,0xa4,0x24,0x54,0x24,0xa1,0x28,0x54,0x4a,0x49,
 0x44,0x25,0x10,0x40,0x94,0xa8,0x2a,0x48,0xa5,0x44,0x8a,0x22,0x92,0x88,0x04,
 0x05,0x52,0x22,0x90,0x12,0x29,0x02,0x40,0x49,0xa4,0x10,0x02,0x44,0x49,0x45,
 0x48,0x48,0x2a,0x42,0x89,0x20,0x40,0x2a,0x45,0x93,0x92,0x92,0xa4,0x42,0x04,
 0x0a,0x12,0x12,0x09,0x02,0x25,0x12,0x50,0x42,0x42,0x12,0x01,0x11,0x29,0x85,
 0x12,0x25,0x25,0x02,0x89,0x20,0x10,0x25,0x09,0x12,0x4a,0x4a,0x11,0x49,0x14,
 0x84,0x22,0x12,0x24,0x89,0x12,0x05,0x25,0x21,0x22,0x15,0x22,0x08,0x29,0x09,
 0x4a,0x28,0x25,0x51,0x50,0x89,0x94,0x42,0x48,0x04,0x48,0x02,0x82,0x10,0x4a,
 0xa9,0x90,0x02,0x12,0x21,0xa5,0x90,0x14,0x22,0x8a,0x2a,0x21,0x28,0x44,0x44,
 0x4a,0x90,0x14,0x29,0xa1,0x48,0x89,0xa4,0x54,0x10,0x40,0x20,0x29,0x14,0xa4,
 0x54,0x44,0x82,0x28,0x49,0x48,0x49,0x54,0x22,0x8a,0x4a,0x44,0xa4,0xa4,0x20,
 0x11,0xa4,0x24,0x49,0x08,0x94,0x44,0x89,0x44,0x08,0x20,0x90,0x44,0xa9,0x2a,
 0x08,0xa2,0x84,0xa4,0x94,0x82,0x50,0x04,0x09,0x42,0x22,0x14,0x12,0x51,0x02,
 0x40,0x29,0x45,0x91,0x44,0x45,0x54,0x49,0x95,0x28,0x2a,0xa2,0x14,0x41,0x44,
 0x94,0x92,0x29,0x29,0x11,0x25,0xa2,0x40,0x08,0x92,0x24,0x11,0x01,0x05,0x15,
 0x41,0x04,0x41,0x11,0x89,0xa2,0x54,0x44,0x22,0x25,0x92,0x92,0x14,0x21,0x22,
 0x29,0x51,0x09,0x4d,0x4a,0x49,0x92,0x80,0xa2,0x22,0x29,0x22,0x11,0x22,0x89,
 0x00,0x29,0x50,0x15,0xa0,0x24,0x29,0x49,0x11,0x29,0x85,0x52,0xa4,0x94,0x88,
 0x22,0x49,0x02,0x28,0x21,0x22,0x11,0x25,0x29,0x92,0x10,0x05,0x08,0x41,0x41,
 0x95,0x42,0x14,0x09,0x49,0x24,0xa2,0x42,0x4a,0x48,0x09,0x25,0xa1,0x44,0x08,
 0x22,0x2a,0x29,0x00,0x90,0x52,0x29,0x45,0x52,0x44,0x02,0x09,0x89,0x48,0x09,
 0xa5,0x42,0x44,0x89,0x44,0x82,0x54,0x22,0x89,0x90,0x44,0x2a,0x08,0x44,0x84,
 0x08,0xa2,0x04,0x04,0x50,0x42,0xa5,0x24,0x0a,0x90,0x44,0x52,0x94,0x40,0x51,
 0x08,0x02,0x21,0x25,0x48,0x02,0xa8,0x44,0x88,0x88,0xa4,0x88,0x84,0x24,0xa5,
 0x50,0x45,0xac,0x94,0x48,0x12,0x41,0xa2,0x44,0x92,0x14,0x28,0x11,0x22,0x52,
 0x09,0x14,0x92,0x92,0x08,0x41,0x04,0xa4,0x44,0x40,0x42,0x90,0x84,0x92,0xa8,
 0x52,0x12,0x52,0xa2,0x28,0x11,0x11,0x22,0x92,0x54,0x92,0x94,0x24,0x24,0x21,
 0x85,0xa2,0x92,0x22,0x22,0x11,0x51,0x42,0x81,0x28,0x51,0x15,0x50,0x45,0xa9,
 0x84,0x22,0x2a,0x88,0x92,0x28,0x94,0x90,0x04,0x54,0x11,0x02,0x01,0x12,0x41,
 0x22,0x29,0x81,0x08,0x05,0x08,0x11,0x11,0x95,0x44,0x14,0x09,0x92,0x48,0xd2,
 0x4a,0x8a,0x48,0x20,0xa4,0xa2,0x48,0x24,0x52,0x12,0x50,0x01,0x00,0x15,0x29,
 0x25,0x29,0x02,0x11,0x05,0x44,0x84,0x14,0x45,0x4a,0xa4,0x88,0x48,0x22,0x49,
 0x21,0x91,0x92,0x94,0x10,0x8a,0x24,0x14,0x89,0x44,0x04,0x09,0x04,0x41,0xa8,
 0x2a,0x05,0x28,0x12,0x32,0x09,0x90,0x82,0x04,0x85,0x22,0x4a,0x50,0x01,0x4a,
 0xa9,0x48,0xa0,0x94,0x48,0x42,0x2a,0x52,0xa2,0x42,0x4a,0xa5,0x52,0x12,0xa1,
 0xa0,0x20,0x85,0x24,0x92,0x02,0x2a,0x89,0x02,0x10,0x12,0x89,0x04,0x44,0x15,
 0xaa,0x12,0xa0,0x00,0x49,0x82,0x54,0xa4,0x40,0x01,0x52,0xa2,0xaa,0x82,0x08,
 0x42,0x20,0x49,0x52,0x54,0x0a,0x48,0x40,0x42,0x21,0x81,0x42,0x22,0x10,0xa9,
 0xa0,0x20,0x94,0x22,0x15,0x50,0x81,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x54,0x81,0x40,0x50,0xa5,0xa0,
 0x10,0x52,0x11,0x42,0x01,0x44,0x08,0xaa,0x80,0x28,0x81,0x12,0x2a,0xaa,0x94,
 0x48,0x24,0x14,0xa2,0x88,0x92,0x20,0x44,0x09,0x41,0x21,0x82,0x08,0x8a,0x54,
 0x14,0x48,0x25,0x42,0x0a,0x0a,0x40,0xa8,0x2a,0x04,0xa0,0x04,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x02,0x20,
 0x84,0x0a,0x08,0x15,0x85,0x44,0x54,0x91,0x54,0x11,0x40,0x01,0x2a,0x89,0x28,
 0xa4,0x84,0x00,0x49,0x92,0x92,0x82,0x10,0x20,0x09,0x40,0x29,0xa4,0x28,0x08,
 0x20,0xa2,0x40,0x8a,0x82,0x92,0x48,0x91,0x42,0x21,0x10,0xa5,0x12,0x52,0x05,
 0x02,0x00,0x01,0x80,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x80,0x00,0x20,
 0x00,0x08,0x00,0x02,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,
 0x40,0x40,0x48,0x15,0x10,0xa4,0x52,0xa2,0x10,0x12,0x41,0x4a,0x00,0x44,0x10,
 0x94,0x00,0x22,0x91,0x08,0x11,0x55,0x22,0x49,0x4a,0x2a,0x49,0x95,0xa4,0x14,
 0x42,0x49,0x82,0x22,0x91,0x14,0x2a,0x51,0x28,0x44,0x12,0x25,0x28,0x44,0x40,
 0x50,0x15,0x00,0xa8,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x42,0x41,0x49,0x00,0x09,0x48,0x40,0x95,
 0xa4,0x54,0x10,0x02,0x01,0x00,0x91,0x24,0x84,0x44,0x08,0x15,0x24,0x21,0x51,
 0x02,0x42,0x00,0x44,0x94,0x24,0x50,0x48,0x00,0x44,0x81,0x08,0x02,0x11,0x49,
 0x92,0x12,0x10,0x08,0x52,0x2a,0x2a,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0x42,0x08,0x2a,0x24,0x55,
 0x50,0x22,0x15,0x2a,0x09,0x09,0x41,0x10,0x04,0x80,0x44,0x82,0x52,0x92,0xa2,
 0x48,0x49,0x4a,0x82,0xa8,0x88,0x2a,0x88,0x22,0x89,0x82,0x22,0x55,0x89,0x54,
 0x22,0x54,0x44,0x92,0x24,0x48,0x48,0x82,0x50,0x15,0x40,0x54,0x0a,0x00,0x01,
 0x80,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x80,0x00,0x20,0x00,0x08,0x00,
 0x02,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x40,0x40,0x95,
 0x52,0x01,0x41,0x08,0x05,0x11,0x40,0x01,0x52,0x42,0x14,0x80,0xa0,0x00,0x90,
 0x28,0x84,0x20,0x14,0x45,0x12,0x29,0x55,0x12,0x52,0x80,0x52,0x88,0xa4,0xa4,
 0x14,0x20,0x20,0x84,0x08,0x01,0x91,0x28,0x48,0x05,0x05,0x20,0xa4,0x12,0x0a,
 0x91,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x60,0x45,0x02,0x2a,0x04,0xa5,0x08,0x44,0x15,0x2a,0x10,0x29,0x41,
 0x55,0x02,0x12,0x00,0x91,0x10,0x8a,0xa0,0x90,0xa8,0xa4,0x08,0x49,0x89,0x2a,
 0x88,0x52,0x02,0x02,0xa1,0x96,0x82,0x48,0x42,0x54,0x24,0x85,0x24,0x28,0x22,
 0x89,0x50,0x15,0x40,0x44,0x22,0x49,0x49,0x92,0x90,0x24,0x29,0x49,0x52,0x92,
 0x44,0x49,0x92,0x94,0x24,0x29,0x49,0x12,0x92,0x24,0x25,0x49,0x92,0x24,0x09,
 0x49,0x92,0x92,0x24,0x25,0x49,0xa2,0x2a,0xa9,0x48,0x51,0x00,0x82,0xa8,0x40,
 0x49,0x8a,0x08,0x14,0x80,0x08,0x04,0x40,0x4a,0x8a,0x50,0x4a,0x24,0x05,0x49,
 0x52,0x20,0x52,0x90,0x52,0x84,0xa8,0x50,0x0a,0x20,0x28,0x02,0x10,0x01,0x91,
 0x28,0x08,0x05,0x49,0x40,0x44,0x2a,0x0a,0x11,0x09,0x00,0x80,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0x45,0x12,0x25,0x84,
 0x52,0x50,0x02,0x55,0x24,0x20,0xa2,0x22,0x22,0x42,0x80,0x00,0x20,0x51,0x82,
 0x08,0x91,0x54,0x12,0x20,0x95,0x04,0x45,0x88,0x2a,0x20,0x4a,0xa4,0x8a,0x44,
 0xa9,0x40,0x54,0x4a,0x22,0xa1,0xa8,0x20,0x92,0xb0,0x0a,0x40,0xa4,0x84,0x2a,
 0x29,0xaa,0xaa,0xaa,0x5e,0x25,0x25,0x55,0x45,0x92,0x24,0x92,0x4a,0x92,0xa4,
 0x54,0x92,0x24,0x49,0x55,0x92,0x3c,0x49,0x29,0x29,0xa9,0xaa,0x54,0x25,0x49,
 0x95,0x48,0x48,0x29,0x04,0x04,0xa8,0x10,0x49,0x45,0x49,0x80,0x90,0x00,0x2a,
 0x2a,0x09,0x8a,0x54,0xa4,0x48,0xa2,0xa4,0x0a,0x48,0xa2,0x28,0x42,0x00,0x94,
 0x12,0x29,0x24,0x29,0x00,0x14,0x92,0x90,0x94,0x44,0x04,0x8a,0x20,0x45,0x29,
 0x2a,0x01,0x12,0x80,0x01,0x80,0x00,0x20,0x11,0x08,0x80,0x02,0x00,0x41,0x80,
 0x08,0x20,0x00,0x0a,0x02,0x03,0x82,0x21,0x40,0x00,0x62,0x00,0x88,0x80,0x02,
 0x00,0x01,0x40,0xa0,0x4a,0x12,0x11,0x91,0x50,0x51,0x11,0x45,0x11,0x10,0x82,
 0x12,0x04,0x12,0x20,0x01,0x44,0x50,0x22,0x11,0x12,0x89,0x12,0x44,0x22,0x49,
 0x42,0x29,0x2d,0x20,0x48,0x42,0x91,0x40,0x49,0x41,0x24,0x42,0x22,0x21,0xa9,
 0x20,0x04,0x50,0x15,0x00,0x54,0x41,0x12,0x90,0x22,0x90,0x84,0xae,0x48,0x29,
 0x20,0x52,0x14,0x52,0x42,0x12,0xa9,0x80,0x40,0xa0,0x20,0x08,0x10,0x4a,0x9f,
 0xa4,0x04,0x12,0x44,0x92,0x48,0x92,0x64,0x95,0xa4,0x44,0x24,0x09,0x04,0x4a,
 0x52,0x8a,0xa2,0x54,0x04,0x81,0x40,0x48,0x84,0x20,0x15,0x48,0x84,0x54,0x52,
 0x88,0x22,0x91,0x14,0x29,0x88,0x00,0x95,0x92,0x28,0x24,0x2a,0x20,0x28,0x49,
 0x29,0x11,0x40,0x04,0x05,0x91,0xa0,0x2a,0xaa,0x20,0x10,0x40,0x02,0x88,0x02,
 0x50,0x44,0x02,0x00,0x82,0x00,0x81,0x00,0x10,0x40,0x00,0x14,0x04,0x04,0x12,
 0x42,0x45,0xa0,0x44,0x11,0x10,0x40,0x10,0x00,0x02,0x00,0xa2,0x05,0x12,0x29,
 0x01,0xa2,0xa8,0x90,0x88,0x28,0x00,0x81,0x20,0x14,0x00,0x82,0x10,0x84,0xa0,
 0x20,0x21,0xa2,0x24,0x25,0x14,0x4a,0xa2,0x44,0x25,0xa0,0x40,0x22,0x92,0x92,
 0x80,0x8a,0x42,0x24,0xa5,0x24,0x85,0x52,0x00,0x04,0x50,0x25,0x00,0x0a,0x01,
 0x12,0x49,0x82,0x90,0x44,0x45,0x28,0x49,0x22,0x10,0x21,0x90,0x04,0x29,0x12,
 0x09,0xa1,0x92,0x00,0x11,0x80,0x84,0x24,0x05,0x8a,0x14,0x02,0x49,0x91,0xd4,
 0xa0,0xaa,0x48,0x8a,0x54,0x09,0x12,0x4a,0x52,0x82,0xa8,0x28,0x89,0x00,0x00,
 0x28,0x95,0x20,0x08,0x44,0x08,0x11,0x49,0x92,0xa2,0x92,0x28,0x28,0x81,0x40,
 0x2a,0x09,0x49,0x49,0x2a,0x21,0x14,0x89,0x10,0x12,0x20,0x00,0x52,0x00,0xa0,
 0x14,0x4a,0x00,0x50,0x00,0x00,0x10,0x04,0x20,0x44,0x00,0x00,0x08,0x41,0x08,
 0x05,0x21,0x00,0x42,0x20,0x04,0x00,0x24,0x80,0x28,0x90,0x04,0x21,0x21,0x40,
 0x24,0x04,0x00,0x00,0xa4,0x0a,0xa1,0x50,0x22,0x50,0xa4,0x24,0x01,0x09,0x02,
 0x02,0x20,0x02,0x00,0xa0,0x20,0x00,0xa1,0x82,0x02,0xa2,0x24,0x49,0x88,0x24,
 0x42,0x91,0x00,0x14,0x81,0xa4,0x24,0x22,0x11,0x84,0xa0,0x24,0x42,0x84,0x94,
 0x4a,0x81,0x02,0xa8,0x2a,0x10,0x02,0x04,0x49,0x92,0x04,0x80,0x44,0x80,0x04,
 0x22,0x01,0x08,0x00,0x40,0x80,0x44,0x0a,0x84,0x20,0x24,0x81,0x24,0x82,0x84,
 0x24,0x09,0x08,0x09,0x01,0x41,0x4a,0x12,0x41,0xa5,0x14,0x0a,0x89,0x0a,0x42,
 0x42,0x54,0x22,0x48,0x41,0x15,0x09,0x92,0x12,0x8a,0x0a,0x10,0xa8,0x50,0x14,
 0x91,0x04,0x25,0x11,0x29,0x25,0x00,0x40,0x54,0x28,0x80,0x94,0x4a,0x51,0x2a,
 0x91,0x28,0x12,0x82,0x00,0x50,0x10,0x51,0x15,0x42,0x40,0x01,0x00,0x01,0xa0,
 0x24,0x50,0x2f,0xd9,0x94,0x6a,0x55,0x25,0x94,0x56,0xaa,0x56,0x59,0x82,0x02,
 0x04,0x01,0x40,0x00,0xab,0x58,0x48,0x20,0x4a,0x08,0x21,0x40,0xb4,0x15,0x41,
 0xa9,0x54,0xa4,0x14,0x29,0x21,0x84,0x12,0x24,0xa0,0x20,0x08,0xa0,0x52,0x20,
 0x42,0x01,0x85,0x20,0x4a,0x52,0x88,0x24,0x92,0x90,0xa0,0x8a,0x10,0x41,0x15,
 0x49,0xa4,0x8a,0x44,0x22,0x85,0x40,0x14,0xa2,0x84,0x02,0x20,0x15,0x90,0x0a,
 0x94,0x24,0x40,0x04,0x00,0x52,0xd1,0xa6,0xaa,0xaa,0xaa,0x03,0xe9,0xaa,0x55,
 0xd5,0xd6,0x10,0x90,0x40,0x48,0x12,0x29,0x42,0x22,0x02,0x08,0x00,0x42,0x80,
 0x24,0xa0,0x4a,0x2a,0x04,0x05,0x49,0xa2,0x44,0x8a,0x51,0xa4,0x02,0x08,0x0a,
 0x41,0x15,0x09,0x09,0x48,0x52,0x20,0x42,0x11,0x09,0x25,0x92,0x24,0x49,0x04,
 0x21,0x45,0x2a,0xa2,0x04,0x11,0x50,0x92,0x94,0xa8,0x2a,0xa1,0x08,0x50,0xa4,
 0x54,0x25,0x02,0xa0,0x02,0x80,0x14,0x41,0x82,0x08,0x0a,0x08,0x10,0x04,0x91,
 0x46,0x04,0x49,0xaa,0x2a,0xd5,0x44,0x00,0x12,0x02,0x08,0x30,0x1c,0x94,0x48,
 0x41,0x49,0x10,0x05,0x80,0x44,0xa5,0x44,0x29,0x28,0x10,0x89,0x92,0x54,0x8a,
 0x00,0x14,0xa2,0xa0,0x00,0xa2,0xa4,0x40,0x00,0x89,0x0a,0x08,0xa2,0x24,0x90,
 0x48,0x91,0x24,0x51,0x0a,0x14,0xa1,0x04,0x29,0x4a,0x05,0x21,0x21,0x45,0x84,
 0x04,0x11,0x82,0x10,0x50,0x15,0xa8,0x4a,0x48,0x12,0x01,0x90,0x20,0x48,0x00,
 0x01,0x05,0x41,0x20,0x1f,0x54,0x22,0x01,0x40,0xd2,0x01,0x96,0x00,0x41,0xc2,
 0xa4,0x60,0x32,0x08,0x10,0x02,0x04,0x91,0x54,0xd0,0x0a,0x91,0x84,0x82,0x4a,
 0x52,0x24,0x82,0x20,0x55,0x01,0x10,0x2a,0x28,0x08,0x09,0x04,0x22,0xa2,0x40,
 0x82,0x14,0x49,0x4a,0x22,0x14,0x88,0x08,0x51,0xa1,0x14,0x52,0x42,0x11,0xa8,
 0x48,0x14,0x91,0x22,0x52,0x04,0x28,0xa5,0xa2,0x2a,0x02,0x00,0x01,0x00,0x20,
 0x04,0x04,0x0a,0x20,0x10,0x40,0x08,0x92,0x1d,0x14,0x08,0x54,0x15,0xd5,0x89,
 0x00,0x92,0x08,0x00,0x98,0x00,0x52,0x21,0x85,0x28,0x21,0x00,0x02,0xa1,0x56,
 0x24,0x52,0x54,0x24,0x88,0x90,0x14,0x85,0x00,0x14,0x45,0x10,0x81,0x50,0xa4,
 0x00,0x00,0x14,0x11,0x09,0x48,0x00,0x20,0x49,0xa1,0x52,0x42,0x04,0x0a,0xa1,
 0x88,0x14,0x44,0x01,0x25,0xa1,0x44,0x94,0x88,0x08,0x01,0x12,0x28,0x09,0x50,
 0x25,0x94,0x24,0x09,0x41,0x40,0x90,0x04,0x00,0x00,0x80,0x48,0x77,0x8a,0x82,
 0x02,0x40,0x69,0x23,0x40,0x00,0x20,0x29,0xa9,0x44,0xdd,0x08,0x20,0x00,0x08,
 0xa9,0x40,0x48,0x05,0x89,0x24,0x02,0x49,0x25,0x4a,0x42,0x29,0x52,0x01,0x92,
 0x0a,0x14,0x04,0x12,0x0a,0x48,0x41,0x44,0xa2,0x12,0xa9,0x44,0x12,0x14,0x89,
 0x10,0x51,0xa1,0x14,0x25,0xa2,0x52,0xaa,0x48,0x4a,0x24,0x22,0x42,0x22,0xaa,
 0x04,0xa2,0x2a,0x02,0x90,0x20,0x49,0x48,0x92,0x94,0x44,0x00,0x41,0x04,0x52,
 0xa2,0x5f,0x52,0x2a,0xa8,0x56,0xea,0x11,0x93,0x34,0x25,0x49,0xda,0xb4,0x2a,
 0x49,0x92,0x9a,0x24,0x25,0x49,0x62,0x55,0x24,0x49,0xa9,0x04,0x91,0x90,0x14,
 0x42,0x48,0x24,0x04,0x41,0x00,0x51,0x48,0x41,0x04,0x94,0x12,0x14,0x40,0x00,
 0x10,0x49,0x21,0x52,0x22,0x04,0x0a,0x49,0x90,0x14,0x81,0x14,0x05,0x91,0x92,
 0x84,0x28,0x00,0x84,0x08,0x50,0x15,0x28,0x45,0x0a,0x00,0x02,0x00,0x00,0x2a,
 0x2a,0x08,0x90,0x08,0x54,0x75,0xaa,0x12,0x02,0xa9,0xaa,0x05,0x04,0x02,0x08,
 0x00,0xaa,0xac,0x29,0x81,0x04,0x00,0x41,0x00,0x10,0xa4,0x0a,0x49,0x24,0x24,
 0x52,0x0a,0x25,0xa2,0x94,0x22,0x01,0x69,0x14,0x41,0x80,0x12,0x14,0x00,0xa4,
 0x48,0x05,0x00,0xaa,0x4a,0x90,0x94,0x8a,0x48,0x51,0x51,0x82,0x2a,0x89,0x54,
 0x42,0x51,0x2a,0x44,0x52,0x84,0x2a,0x29,0x92,0xa4,0x2a,0x82,0x90,0x20,0x22,
 0x11,0x84,0x00,0xd4,0x02,0x00,0x00,0xa2,0x55,0x1f,0x55,0xa5,0x68,0x55,0xf5,
 0x21,0x22,0xa0,0x21,0x51,0xb4,0x5a,0x2d,0x29,0x50,0x23,0x04,0x89,0x42,0xa1,
 0xa5,0x24,0x91,0x92,0x48,0x51,0x94,0x08,0x41,0x84,0x94,0x04,0x00,0x08,0x29,
 0x44,0x01,0x92,0x10,0x22,0xa8,0xaa,0x00,0x90,0x22,0x52,0x14,0x11,0x22,0x85,
 0x28,0x84,0x24,0x91,0x14,0x8a,0x40,0x91,0x08,0x29,0x80,0x24,0x00,0x50,0x09,
 0x24,0x48,0x8a,0x08,0x00,0x21,0x94,0xa0,0xaf,0x00,0x01,0x68,0xfb,0x77,0xb8,
 0x0b,0x29,0xea,0xbf,0x08,0x00,0x09,0x00,0x04,0xa4,0xaa,0x35,0x06,0x02,0x88,
 0x20,0x22,0x20,0x48,0x15,0x12,0xaa,0x44,0x25,0x14,0x41,0x52,0x28,0x52,0x00,
 0x80,0x22,0x20,0x02,0x11,0x04,0x00,0x84,0x88,0x4a,0x00,0x50,0x25,0x89,0x84,
 0x42,0x48,0x49,0x50,0x12,0x29,0xa9,0x24,0x49,0x21,0x2a,0x24,0x52,0x42,0x11,
 0x01,0x42,0xa0,0x2a,0x90,0x22,0x01,0x40,0x49,0x80,0x00,0xa4,0x1a,0x24,0x88,
 0xa2,0xaf,0x3e,0xe8,0x12,0xc4,0xba,0xea,0x40,0x4a,0x00,0x25,0x60,0x6c,0x6d,
 0x25,0x28,0x08,0x02,0x82,0x80,0x44,0x62,0xa5,0xa4,0x00,0x29,0x88,0xa0,0x14,
 0x89,0x82,0x80,0xa0,0x14,0x80,0x80,0x28,0x44,0x09,0x40,0x10,0x21,0x91,0x22,
 0x05,0x90,0x54,0x12,0x08,0x25,0x24,0x05,0xa1,0x22,0x04,0x89,0x10,0x4a,0x40,
 0x89,0x08,0x11,0x44,0xa4,0x08,0x51,0x2a,0x05,0x48,0x4a,0x04,0x00,0x12,0x22,
 0x01,0xac,0x00,0x00,0xe8,0xf5,0x1b,0x62,0x85,0x2a,0xdd,0xbf,0x89,0x00,0x48,
 0x08,0x09,0x02,0xab,0x06,0x89,0xa2,0x90,0x28,0x24,0x90,0xa0,0x26,0x22,0xaa,
 0x04,0x25,0x15,0x82,0x44,0x28,0x50,0x08,0x81,0x12,0x22,0x04,0x90,0x10,0x10,
 0x44,0x88,0x48,0x08,0x40,0x22,0x02,0x49,0xa5,0x40,0x89,0xa8,0x48,0x48,0x51,
 0x52,0x44,0x91,0x2a,0x22,0x45,0x80,0x00,0x08,0x02,0x50,0x15,0x50,0x11,0x01,
 0x11,0x09,0x40,0x00,0xa8,0x14,0x00,0x20,0xa0,0x5f,0x2f,0xc0,0x12,0xe9,0x77,
 0x6b,0x00,0x92,0x04,0x21,0x80,0x32,0xb4,0x41,0x08,0x00,0x02,0x80,0x80,0x00,
 0xa4,0x4a,0x94,0x48,0xa8,0x90,0xa0,0x28,0x90,0x92,0x02,0x21,0x04,0x40,0x80,
 0x48,0x22,0x02,0x80,0x10,0x25,0x25,0x41,0x15,0x90,0x54,0x24,0x12,0x2a,0x12,
 0x01,0x25,0x25,0x22,0x89,0x92,0x44,0x40,0x48,0x28,0x49,0x48,0x01,0x50,0x90,
 0x2a,0x09,0x48,0x28,0x00,0x21,0x89,0x88,0x10,0xc0,0x84,0x04,0x48,0xf7,0x00,
 0x11,0x81,0x24,0xdd,0x10,0x24,0x02,0x20,0x01,0x4a,0x22,0x24,0x10,0x54,0x24,
 0x4a,0x12,0x15,0x4a,0x41,0x95,0x42,0x12,0x05,0x4a,0x14,0x92,0x24,0x20,0x08,
 0x14,0x29,0x08,0x08,0x82,0x80,0x28,0x22,0x44,0x48,0x88,0x14,0x80,0x04,0x01,
 0x89,0x84,0x84,0x44,0xaa,0x88,0x48,0x91,0x20,0x24,0x20,0x2a,0x02,0x02,0x00,
 0x22,0x90,0x00,0x52,0x15,0xa4,0x22,0x85,0x24,0x00,0x00,0x20,0x40,0x22,0x00,
 0x00,0xd1,0x1f,0x40,0xc0,0x54,0xd9,0x37,0x42,0x80,0x48,0x02,0xa4,0x00,0x92,
 0x24,0x41,0x11,0x81,0x00,0x40,0x40,0x20,0xb4,0x22,0x94,0x20,0x50,0x20,0xa2,
 0x04,0x80,0x8a,0xa0,0xa0,0x90,0x00,0x00,0x10,0x14,0x05,0x80,0x88,0x82,0x22,
 0x82,0x10,0x50,0x54,0x22,0x49,0x10,0x92,0x24,0x25,0x01,0x0a,0x82,0x88,0x4a,
 0x11,0xa9,0xa8,0x12,0x89,0x4a,0x00,0xa0,0x24,0x01,0x10,0x08,0x00,0x48,0x22,
 0x04,0x4a,0xc4,0x22,0x00,0x88,0x3a,0x12,0x24,0x41,0xea,0x1d,0x08,0x25,0x00,
 0x10,0x01,0x50,0x12,0x84,0x4a,0x20,0x24,0x90,0x14,0x08,0x08,0xa0,0x4d,0x09,
 0x0a,0x8a,0x8a,0x48,0x42,0x55,0x00,0x09,0x0a,0x24,0x82,0x00,0x01,0x44,0x50,
 0x28,0x20,0x50,0x88,0x20,0x84,0x04,0x81,0x08,0x12,0x95,0x24,0x91,0x90,0x54,
 0x91,0x54,0x22,0x90,0x44,0x00,0x02,0x40,0x48,0x20,0x42,0x50,0x15,0x54,0x45,
 0x22,0x49,0x01,0x80,0x00,0x28,0x80,0x00,0x12,0xa0,0x3f,0x01,0x50,0x28,0xb5,
 0x86,0x08,0x00,0x25,0x41,0x24,0x41,0x11,0x24,0x81,0x2c,0x80,0x42,0x80,0x21,
 0x41,0xa1,0x92,0x52,0x50,0x10,0x12,0x10,0x08,0x00,0x25,0x00,0x50,0x49,0x24,
 0x04,0x10,0x11,0x85,0x40,0x4a,0x85,0x22,0x0a,0x21,0x00,0x14,0xa0,0x40,0x40,
 0x90,0x44,0x22,0x05,0x44,0x08,0x15,0x44,0x08,0x55,0x24,0x09,0x22,0x95,0x14,
 0x50,0x15,0x01,0x10,0x09,0x00,0x12,0x11,0x52,0x81,0x14,0x05,0x80,0x88,0x76,
 0x08,0x29,0x92,0xfa,0x17,0x80,0x48,0x00,0x08,0x01,0x08,0x11,0x25,0xa1,0xc0,
 0x24,0x08,0x22,0x08,0x24,0x48,0x4d,0x24,0x05,0xa5,0x44,0x4a,0xa2,0x52,0x40,
 0x44,0x0a,0x12,0x09,0x20,0x00,0x80,0x28,0x91,0x10,0x28,0x90,0x20,0x08,0x54,
 0x41,0x12,0x14,0x15,0x25,0x91,0x94,0x50,0x21,0xa2,0x40,0x29,0x42,0x00,0x41,
 0x00,0x48,0x24,0x02,0xa2,0x2a,0x54,0x22,0x44,0x04,0x40,0x84,0x00,0x24,0x84,
 0x20,0x00,0x20,0x7d,0x20,0x14,0x48,0xaf,0x41,0x12,0x00,0x92,0x20,0x24,0x01,
 0x91,0x24,0x8a,0x00,0x02,0x21,0x08,0x21,0x81,0x60,0x25,0x49,0x54,0x12,0x91,
 0x10,0x09,0x08,0x09,0x10,0x20,0x40,0x20,0x01,0x20,0x54,0xa2,0x08,0x40,0xa1,
 0x22,0x82,0x20,0x01,0x04,0x49,0x01,0x40,0x92,0x24,0x21,0x95,0x44,0x09,0x15,
 0x01,0x08,0x29,0x04,0xa4,0x00,0x81,0x48,0x50,0x0a,0x81,0x48,0x29,0x51,0x09,
 0x22,0x90,0x04,0x29,0x05,0x02,0x02,0x6f,0x49,0x8a,0x52,0xf5,0x2a,0x49,0x52,
 0x92,0x24,0x25,0x59,0x12,0xa4,0x0a,0xcb,0x92,0x92,0x25,0x25,0x59,0x4a,0x85,
 0x22,0x81,0x44,0x04,0x44,0x40,0xa2,0x40,0x05,0x89,0x24,0x4a,0x92,0x84,0x80,
 0x14,0x41,0x15,0x0a,0x80,0x28,0x08,0x24,0x51,0x20,0xa4,0x28,0x24,0x49,0x8a,
 0x22,0x11,0x44,0x40,0x50,0x51,0x80,0x40,0x01,0x4a,0x20,0x22,0xa2,0x2a,0x24,
 0x02,0x01,0x00,0x20,0x80,0x04,0x20,0x84,0x02,0x10,0x50,0xfe,0x00,0x22,0xa4,
 0x5f,0x02,0x00,0x01,0x00,0x02,0x00,0x80,0x48,0x44,0x42,0x10,0x21,0x08,0x00,
 0x00,0x00,0xa1,0x55,0x44,0x0a,0x12,0x50,0x10,0x15,0x10,0x04,0x80,0x00,0x92,
 0x08,0x01,0x00,0x2a,0x42,0x00,0x20,0x11,0x29,0x42,0x45,0x00,0x80,0x84,0x12,
 0x82,0x82,0xa4,0x28,0x44,0x42,0x09,0x09,0x05,0x02,0x29,0x04,0x04,0x00,0x4a,
 0x49,0xa9,0x12,0x88,0x20,0x8a,0x24,0x89,0x10,0x00,0x24,0x10,0x24,0x00,0x00,
 0xfa,0x00,0x0a,0xb2,0x75,0x04,0x42,0x10,0x49,0x90,0x48,0x22,0x09,0x04,0x02,
 0x05,0x09,0x02,0xa4,0x94,0x44,0x60,0x15,0x29,0x51,0x81,0x0a,0x85,0x00,0x09,
 0x80,0x08,0xa4,0x20,0x52,0x24,0x90,0x40,0x91,0x52,0x45,0x44,0x84,0x24,0x10,
 0x52,0x22,0x20,0x80,0x40,0x50,0x10,0x85,0x92,0x14,0x52,0x22,0xa0,0x48,0x02,
 0x90,0x40,0xa2,0x10,0x14,0x50,0x2a,0x22,0x82,0x20,0x00,0x01,0x82,0x90,0x82,
 0x44,0x05,0x42,0x44,0xed,0x52,0xa1,0xd4,0x1e,0x92,0x08,0x42,0x02,0x01,0x01,
 0xc8,0x48,0x64,0x12,0x4a,0x22,0x52,0x00,0x01,0x50,0x4a,0xa5,0x84,0x04,0x2a,
 0x20,0x28,0x55,0xa0,0x14,0x00,0x10,0x01,0x89,0x00,0x02,0x00,0x12,0x00,0x01,
 0x10,0x11,0x92,0x42,0x08,0x08,0x81,0x08,0x12,0x05,0x45,0x28,0x49,0x22,0x01,
 0x84,0x14,0x05,0x48,0x02,0x08,0x08,0x81,0x50,0xa5,0x0a,0x80,0x10,0x0a,0x49,
 0x20,0x20,0x04,0x20,0x10,0x14,0x00,0x00,0xf4,0x80,0x0a,0xea,0x8f,0x04,0x90,
 0x08,0x40,0x48,0x24,0x81,0x08,0x45,0x42,0x02,0x82,0x00,0x49,0x48,0x05,0xa0,
 0x0a,0x22,0x51,0x01,0x09,0x82,0x80,0x08,0x01,0x52,0x42,0x0a,0x22,0x05,0x10,
 0x95,0xa4,0xa2,0x50,0x45,0x44,0x09,0x28,0x85,0x02,0x14,0x82,0x00,0x51,0x12,
 0x45,0x24,0x48,0x54,0x21,0x40,0xa1,0x10,0x40,0x02,0xa2,0x04,0x44,0xa0,0x2a,
 0x0a,0x02,0x00,0x00,0x82,0x04,0x21,0x12,0x82,0x88,0x00,0x50,0xbd,0xa4,0xa0,
 0xb4,0x02,0x12,0x01,0x20,0x04,0x02,0x00,0x44,0x08,0x44,0x04,0x24,0x24,0x12,
 0x00,0x01,0x40,0x62,0xab,0x14,0x04,0x2a,0x20,0x28,0x15,0x02,0x28,0x08,0x00,
 0x20,0x88,0x80,0x00,0x00,0x00,0x08,0x02,0x00,0x11,0xa2,0x82,0x28,0x54,0x40,
 0x28,0x24,0x84,0x20,0x28,0x91,0x82,0x02,0x88,0x14,0x0a,0x42,0x09,0x28,0x00,
 0x50,0x10,0x51,0x15,0x50,0x91,0xa4,0x24,0x11,0x80,0x00,0x21,0x14,0x09,0x48,
 0x02,0xe8,0x41,0x88,0xfa,0x57,0x44,0x48,0x04,0x92,0x20,0x25,0x41,0xa4,0x64,
 0x24,0x89,0x08,0x42,0x2a,0x91,0x48,0x48,0x05,0x41,0x81,0x00,0x85,0x44,0x40,
 0x20,0x01,0x01,0x92,0x84,0x20,0x48,0x24,0x25,0x24,0x81,0x40,0x52,0xa4,0x14,
 0x54,0x84,0x02,0x09,0x00,0x81,0x20,0x4a,0x85,0x08,0x20,0x50,0x02,0x41,0x41,
 0x08,0x40,0x02,0x89,0x04,0x44,0x24,0x29,0x02,0x24,0x10,0x00,0x40,0x24,0x04,
 0x89,0x10,0x28,0x00,0x80,0xfa,0x19,0x51,0xad,0x00,0x05,0x02,0x91,0x00,0x04,
 0x00,0x44,0x02,0x04,0x05,0x04,0x4a,0x08,0x00,0x04,0x02,0xa1,0x2a,0x12,0x54,
 0x12,0x00,0x10,0x11,0x09,0x54,0x24,0x08,0x10,0x82,0x22,0x81,0x90,0x00,0x14,
 0x12,0x09,0x10,0xa1,0x80,0x52,0xa8,0x20,0x11,0x14,0x8a,0x00,0x10,0x21,0x92,
 0x00,0x10,0x14,0x08,0x41,0x29,0x11,0x20,0x90,0x90,0x50,0x15,0x48,0x01,0x04,
 0x12,0x09,0x01,0x40,0x10,0x04,0x11,0x00,0x00,0xa8,0x53,0x88,0xfa,0x22,0x84,
 0x20,0x00,0x22,0x21,0x49,0x41,0x4c,0x44,0x44,0x49,0x10,0x41,0x22,0x41,0x48,
 0x60,0x85,0x04,0x00,0x20,0x51,0x89,0x04,0x82,0x00,0x89,0x82,0x82,0x48,0x08,
 0x20,0x04,0x90,0x40,0x00,0x40,0x85,0x08,0x55,0x08,0x12,0x04,0x00,0x01,0x20,
 0x54,0x45,0x14,0x04,0x2a,0x81,0x80,0x52,0x10,0x00,0x80,0x84,0x04,0x05,0x54,
 0x15,0x22,0x54,0x42,0x40,0x00,0x88,0x88,0x08,0x14,0xa1,0x40,0x24,0xf2,0x05,
 0x65,0x2f,0x00,0x25,0x84,0x24,0x08,0x08,0x00,0x28,0x04,0x25,0x04,0x08,0x21,
 0x04,0x08,0x04,0x01,0xa5,0x16,0x50,0xa2,0x04,0x04,0x20,0x51,0x10,0x20,0x00,
 0x08,0x04,0x12,0xa1,0x04,0x52,0x02,0x00,0x20,0x12,0x28,0xa5,0x88,0x52,0x49,
 0x49,0x22,0x24,0x05,0x01,0x14,0x41,0x20,0x01,0x04,0x52,0x00,0x41,0x90,0x0a,
 0x21,0x02,0x48,0x51,0x25,0x08,0x01,0x10,0x08,0x48,0x00,0x02,0x02,0x41,0x24,
 0x08,0x00,0xa4,0x25,0xa0,0x9b,0x10,0x02,0x10,0x80,0x40,0x82,0x24,0x22,0x21,
 0xc4,0x54,0x52,0xa4,0x40,0x02,0x51,0x40,0x40,0x45,0x05,0x08,0x42,0x00,0x4a,
 0x04,0x80,0x44,0x84,0x22,0x21,0x09,0x14,0x11,0x90,0x08,0x48,0x82,0x00,0x45,
 0x10,0x52,0x24,0x24,0x12,0x08,0x08,0x40,0x20,0x41,0x0a,0x44,0x20,0x48,0x04,
 0x25,0x10,0x24,0x40,0x08,0x90,0x12,0xa4,0x14,0x22,0x04,0x80,0x20,0x01,0x91,
 0x90,0x28,0x14,0xa2,0x00,0x00,0xf0,0x82,0xda,0x0e,0x22,0x44,0x42,0x02,0x02,
 0x10,0x81,0x20,0x82,0x24,0x08,0x08,0x40,0x0a,0x28,0x01,0x55,0x64,0x25,0x22,
 0x40,0x08,0x4a,0x20,0x01,0x49,0x10,0x11,0x08,0x84,0x20,0x40,0x00,0x25,0x11,
 0x00,0x01,0x94,0x10,0xa1,0x88,0x92,0x92,0x48,0x44,0x00,0x08,0x09,0x04,0x20,
 0x00,0x0a,0x01,0x28,0x00,0x42,0x00,0x09,0x25,0x09,0x00,0x50,0x15,0x08,0x21,
 0x24,0x04,0x24,0x04,0x40,0x00,0x00,0x40,0x02,0x89,0x44,0x11,0xa9,0x27,0x00,
 0x15,0x08,0x90,0x90,0x04,0x24,0x50,0x12,0x84,0x09,0x22,0x89,0x40,0x02,0x24,
 0x00,0x48,0x8b,0x00,0x08,0x00,0x00,0x0a,0x40,0x00,0x02,0x44,0x02,0x21,0x84,
 0x14,0x48,0x48,0x82,0x44,0xaa,0x22,0x84,0x08,0x42,0x44,0x24,0x12,0x01,0x05,
 0x42,0x20,0x91,0x02,0x24,0x00,0x90,0x82,0x42,0x08,0x45,0x10,0x00,0x20,0x95,
 0xa4,0x2a,0xa2,0x84,0x00,0x21,0x00,0x20,0x02,0x92,0x24,0x45,0x10,0x00,0xa4,
 0x44,0xf6,0x86,0x44,0x04,0x41,0x04,0x02,0x20,0x80,0x14,0x42,0x24,0x48,0x28,
 0xa0,0x04,0x90,0x80,0x90,0xa0,0x02,0x42,0x42,0x45,0x94,0x50,0x09,0x92,0x80,
 0x08,0x48,0x08,0x00,0x42,0x02,0x21,0x28,0x90,0x48,0x14,0x29,0xa0,0x94,0x28,
 0x91,0x48,0x08,0x50,0x08,0x81,0x40,0x40,0x80,0x80,0x04,0x28,0x08,0x40,0x00,
 0x45,0x92,0x04,0x00,0x52,0x15,0x08,0x10,0x51,0x48,0xa9,0x92,0xa8,0x04,0x09,
 0x91,0x02,0x20,0xc8,0x20,0xb9,0x13,0x20,0x4a,0x10,0x52,0xa8,0x24,0x2b,0x49,
 0x92,0x84,0x09,0x69,0x96,0xb2,0x25,0x25,0x4a,0x66,0x95,0x00,0x10,0x00,0x01,
 0x04,0x80,0x00,0x20,0x22,0x02,0x10,0x49,0x00,0x48,0x48,0x82,0x22,0x25,0x49,
 0x44,0x14,0x22,0x85,0x08,0x05,0x21,0x81,0x00,0x24,0x08,0x02,0x24,0x15,0x90,
 0x04,0x40,0x12,0x50,0x00,0x00,0x40,0x80,0x50,0x12,0xa2,0x42,0x08,0x01,0x00,
 0x00,0x40,0x20,0x24,0x84,0x80,0x00,0x20,0x90,0xee,0x42,0x02,0x02,0x49,0x80,
 0x02,0x02,0x00,0x10,0x02,0xa4,0x48,0x40,0x00,0x00,0x00,0x88,0x00,0xa0,0x06,
 0x48,0x44,0x05,0x14,0x51,0x10,0x28,0x95,0x00,0x49,0x02,0x20,0x29,0x01,0x85,
 0x54,0x48,0x94,0x92,0x2a,0xa1,0x48,0x28,0xa5,0xa8,0x04,0x24,0x22,0x00,0x01,
 0x48,0x01,0x00,0x01,0x52,0x01,0x40,0x82,0x84,0x4a,0x08,0x15,0xa2,0x2a,0x08,
 0x10,0x00,0x10,0x09,0x08,0x02,0x08,0x00,0x00,0x09,0x04,0x49,0x89,0xba,0x01,
 0x90,0x44,0x00,0x54,0xba,0x20,0x21,0x09,0x91,0x84,0x08,0x44,0x01,0x13,0x48,
 0x22,0x24,0x49,0x05,0x02,0x01,0x10,0x20,0x04,0x82,0x40,0x00,0x08,0x04,0x00,
 0x09,0x40,0x48,0x20,0x08,0x91,0x42,0x24,0x89,0x14,0x92,0x92,0x10,0x12,0x09,
 0x08,0x08,0x49,0x20,0x01,0x20,0x05,0x50,0x00,0x80,0x08,0x11,0x11,0x01,0x02,
 0x80,0x50,0x15,0xa0,0x00,0x49,0x02,0xa1,0xa0,0x28,0x25,0x52,0x4a,0x01,0x40,
 0x00,0xa4,0x6f,0x88,0x04,0x12,0x8a,0x82,0x48,0x84,0x04,0x48,0x01,0x24,0x4a,
 0x49,0x14,0x41,0x21,0x81,0x40,0x60,0x55,0x20,0x00,0x00,0x00,0x90,0x00,0x00,
 0x29,0xa1,0x92,0x24,0x00,0x09,0x01,0x8a,0x20,0x42,0x94,0x92,0x24,0xa5,0x44,
 0x24,0xa5,0x44,0x20,0x01,0x20,0x20,0x05,0x24,0x00,0x00,0x02,0x92,0x04,0x40,
 0x44,0x40,0x4a,0x88,0x10,0xa4,0x2a,0x15,0x44,0x00,0x40,0x00,0x04,0x20,0x00,
 0x04,0x00,0x49,0x00,0xa0,0xa0,0x7a,0x21,0x40,0x04,0x40,0x20,0xa2,0xa9,0x22,
 0x29,0xa4,0x84,0x10,0x80,0x40,0x12,0x08,0x10,0x12,0xa4,0x05,0x0a,0x94,0x44,
 0x4a,0x02,0x88,0x54,0x42,0x10,0x24,0x00,0x51,0xa0,0xa0,0x20,0x54,0x94,0x22,
 0x24,0x89,0x48,0x22,0x89,0x10,0x29,0x15,0x20,0x85,0x4a,0x20,0x09,0x4a,0x94,
 0x10,0x00,0x40,0x12,0x08,0x12,0x10,0x02,0x24,0xa1,0x14,0x40,0x11,0x92,0x04,
 0x12,0x00,0x01,0x42,0x50,0x12,0x02,0x12,0x04,0xaa,0x37,0x00,0x11,0x45,0x10,
 0x85,0x88,0x22,0x05,0x88,0x01,0x94,0x10,0x89,0x04,0x84,0x40,0x42,0x40,0xa1,
 0x0a,0xa4,0x42,0x82,0x00,0x28,0x00,0x00,0x04,0x49,0x90,0x12,0x04,0x01,0x12,
 0x0a,0x81,0x20,0x94,0x92,0x24,0x25,0x49,0x92,0xaa,0x40,0x42,0x02,0x10,0x10,
 0x05,0xa4,0x04,0x00,0x42,0x54,0x08,0x48,0x21,0x48,0x92,0x10,0x00,0xa8,0x2a,
 0x14,0x04,0x00,0x20,0x41,0x92,0x50,0x22,0x04,0x08,0x12,0x00,0x10,0xd1,0x1d,
 0x12,0x20,0x12,0x4a,0x20,0x22,0x09,0x9a,0x04,0x91,0xa4,0x52,0x08,0x41,0x26,
 0x12,0x11,0x48,0x48,0x85,0x12,0x14,0x24,0x44,0x01,0x42,0x10,0x49,0x82,0x04,
 0x80,0x20,0x12,0x84,0x44,0x28,0x95,0xa2,0x24,0x51,0x49,0x92,0x44,0x04,0x95,
 0x14,0x48,0x02,0xa5,0x20,0x12,0xa9,0x8a,0x10,0x01,0x02,0x00,0x4a,0x02,0x04,
 0x80,0x4a,0x52,0x15,0x42,0xa1,0x24,0x09,0x08,0x00,0x04,0x08,0x21,0x42,0x02,
 0x40,0x00,0x7a,0x47,0x40,0x02,0x84,0x00,0x04,0x90,0xa0,0x54,0x24,0x04,0x84,
 0x10,0x22,0x09,0x09,0x40,0x84,0x02,0x60,0x2b,0x48,0x21,0x81,0x10,0x04,0x00,
 0x45,0x04,0x28,0x02,0x10,0x0a,0xa0,0x10,0x11,0x11,0x20,0x05,0x91,0x24,0x92,
 0x24,0x11,0x29,0x24,0xa1,0x00,0x40,0x40,0x8a,0x40,0x02,0x20,0x22,0x00,0xa0,
 0x12,0x00,0xa9,0x10,0x11,0x00,0xa1,0x12,0x10,0x08,0x00,0x00,0x01,0x92,0x10,
 0x02,0x24,0x04,0x94,0x04,0x82,0xd4,0x17,0x08,0x88,0x04,0x24,0x81,0x04,0x09,
 0x32,0x84,0x81,0x84,0x90,0x00,0x21,0x88,0x14,0x20,0x48,0x4a,0x05,0x04,0x4a,
 0x28,0x12,0x00,0x21,0x00,0xa0,0x8a,0x90,0x42,0x80,0x14,0x44,0x4a,0x8a,0x90,
 0xa8,0x24,0x92,0x24,0x49,0x4a,0x44,0x49,0x0a,0x94,0x08,0x94,0x00,0x14,0x50,
 0x8a,0x08,0x12,0x00,0x04,0xaa,0x48,0x02,0x84,0x28,0x54,0x2a,0xa2,0x44,0x4a,
 0x12,0x91,0x00,0x88,0x20,0x80,0x08,0x05,0x00,0x10,0xbd,0x82,0x40,0x20,0x12,
 0x00,0x08,0x20,0x20,0x68,0x44,0x28,0xa4,0x04,0x2a,0x82,0x12,0x80,0x01,0x41,
 0xa0,0x0a,0x91,0x20,0x80,0x48,0x49,0x88,0x08,0x05,0x14,0x01,0x00,0x29,0xa2,
 0x12,0x90,0x50,0x42,0x12,0x49,0x49,0x49,0x92,0xa4,0x92,0x24,0x24,0x01,0xa2,
 0x48,0x0a,0xa2,0x02,0x20,0x22,0x88,0x04,0x40,0x00,0x12,0x21,0x41,0x02,0x50,
 0x15,0x08,0x91,0x00,0x00,0x04,0x44,0x02,0x09,0x4a,0x40,0x28,0x90,0x00,0xea,
 0x03,0x08,0x02,0x84,0x12,0x22,0x09,0x01,0x45,0x91,0x02,0x04,0x61,0x80,0x24,
 0x20,0x25,0x48,0x10,0x62,0x45,0x48,0x0a,0x20,0x02,0x00,0x00,0x42,0x50,0x41,
 0x10,0x12,0x02,0x14,0x20,0x49,0x04,0x21,0x49,0x22,0x50,0x2a,0x49,0x12,0x24,
 0x89,0x48,0x48,0x01,0x85,0xa0,0x10,0x94,0x00,0x04,0x01,0x20,0x11,0xaa,0x04,
 0x04,0x10,0x40,0x55,0x15,0x22,0x04,0x4a,0x24,0x20,0x00,0x08,0x20,0x04,0x0a,
 0x08,0x01,0x44,0x7d,0x49,0x02,0x88,0x22,0x40,0x00,0xa0,0x48,0xa8,0x82,0x90,
 0x24,0x09,0x09,0x02,0x22,0x00,0x01,0x41,0xc8,0x0a,0x90,0x80,0x0a,0x20,0x09,
 0x09,0x08,0x0a,0x04,0x44,0x40,0x10,0xa1,0x8a,0x04,0xa9,0x84,0xa4,0x94,0x8a,
 0x90,0x2a,0x49,0x89,0x24,0x20,0x02,0x24,0x28,0x02,0x48,0x01,0x2a,0x91,0x84,
 0x08,0x44,0x10,0x20,0x10,0x80,0x14,0x90,0x12,0x08,0x21,0x00,0x81,0x02,0xa2,
 0x44,0x85,0x40,0x08,0x28,0x00,0x00,0xd4,0x81,0x40,0x21,0x84,0x04,0x28,0x09,
 0x00,0x50,0xa2,0x00,0x24,0x21,0x88,0x48,0xca,0x48,0x52,0x48,0xa2,0x46,0x22,
 0x0a,0x20,0x45,0x00,0x80,0x42,0x20,0x01,0x00,0x08,0x04,0x14,0x20,0x20,0x12,
 0x29,0x49,0x02,0x51,0x4a,0x44,0x92,0x24,0x11,0x15,0x24,0x82,0x82,0x48,0x42,
 0x8a,0x00,0x20,0x00,0x02,0x01,0x04,0x09,0x00,0x09,0x00,0xaa,0x2a,0x22,0x84,
 0x24,0x08,0x88,0x00,0x04,0x20,0x44,0x20,0x11,0x44,0x08,0xf9,0x13,0x04,0x00,
 0x02,0x20,0x01,0x40,0x28,0xa5,0x48,0x4a,0x04,0x51,0x20,0x0a,0x00,0x01,0x01,
 0x02,0xa0,0x8a,0x40,0x51,0x01,0x08,0x91,0x12,0x04,0x00,0x54,0x49,0xa0,0x50,
 0xa0,0x92,0x82,0x40,0x44,0x12,0xa9,0xa4,0x92,0x92,0x24,0x49,0xa4,0xa0,0x90,
 0x08,0x14,0x21,0x10,0x11,0xa9,0x82,0x22,0x10,0x0a,0x40,0x40,0x49,0xa0,0x12,
 0x51,0x15,0x48,0x21,0x08,0x49,0x49,0x14,0x91,0x04,0x29,0x49,0xa2,0x00,0x41,
 0xa8,0x87,0x90,0xa4,0x5a,0x00,0x2a,0x89,0x00,0x50,0x09,0x92,0x24,0x29,0x4b,
 0xaa,0x92,0x64,0x2c,0x59,0x56,0x45,0x10,0x04,0xa8,0x42,0x04,0x00,0x11,0x84,
 0x00,0x00,0x12,0x02,0x15,0x08,0x24,0x14,0x92,0xa4,0x08,0x12,0xa4,0x54,0x4a,
 0x92,0x12,0x14,0x04,0x40,0x82,0x48,0x42,0x44,0x02,0x10,0x80,0x84,0x40,0x00,
 0x28,0x10,0x20,0x40,0xa0,0x12,0x02,0x82,0x20,0x00,0x00,0x40,0x80,0x10,0x04,
 0x00,0x20,0x10,0x00,0xf5,0x17,0x02,0x10,0x02,0x88,0x08,0x00,0xa2,0x24,0x61,
 0x00,0x04,0x21,0x00,0x08,0x44,0x11,0x81,0x80,0xa0,0x8a,0x82,0x50,0x01,0x08,
 0x20,0x09,0x40,0x50,0x92,0x92,0x40,0x01,0x40,0xa5,0x80,0x42,0x28,0x12,0xa5,
 0xa4,0x12,0x21,0x91,0x24,0xa4,0xa2,0xa0,0x12,0x49,0x82,0x08,0x21,0x48,0x89,
 0x08,0x00,0x24,0xaa,0x82,0x42,0x91,0x02,0x55,0x2a,0xa0,0x10,0x05,0x22,0x11,
 0x09,0x24,0x40,0x40,0x12,0x20,0x02,0x24,0xa0,0x0e,0x90,0x04,0x44,0x20,0xb2,
 0xa4,0x08,0x50,0x45,0x20,0x25,0x05,0x24,0x11,0x11,0x04,0x20,0x20,0xa0,0x55,
 0x50,0x02,0x94,0x42,0x02,0x20,0x12,0x09,0x49,0x04,0x10,0x48,0x2a,0x20,0x25,
 0x10,0x85,0xa4,0x40,0x52,0x89,0x94,0x24,0x89,0x12,0x14,0x09,0x20,0x22,0x28,
 0x40,0x80,0x02,0x02,0x02,0x40,0x80,0x40,0x54,0x00,0x00,0x10,0x50,0x15,0x0a,
 0x02,0x90,0x08,0x04,0x40,0x80,0x22,0x42,0x88,0x44,0x80,0x80,0xea,0x4b,0x01,
 0x20,0x02,0x04,0x0c,0x10,0x40,0x2a,0x41,0x0a,0x24,0x21,0x09,0x50,0x02,0x23,
 0x09,0x45,0xa2,0x02,0x09,0xa9,0x02,0x10,0x08,0x00,0x40,0xa0,0x94,0x20,0x80,
 0x02,0x48,0x85,0x90,0x4a,0x08,0x92,0x8a,0x24,0x52,0x42,0x4a,0x50,0x48,0x21,
 0x40,0x04,0x88,0xa2,0x2a,0x15,0x28,0x50,0x90,0x00,0x09,0x8a,0x92,0x0a,0x22,
 0x85,0xa4,0x2a,0x90,0x94,0x02,0x00,0x21,0x89,0x44,0x00,0x14,0x10,0x20,0x10,
 0x00,0xa4,0x1f,0x44,0x84,0x24,0x80,0x92,0xca,0x12,0x90,0x20,0x80,0x04,0x08,
 0x40,0x12,0x40,0x04,0x42,0x00,0xa8,0x56,0x92,0x00,0x40,0x84,0x40,0x80,0x08,
 0x15,0x49,0x0a,0x25,0x10,0x12,0x50,0x04,0x20,0xa2,0x48,0x20,0x55,0x29,0xa9,
 0x92,0x0a,0x25,0x94,0x12,0x41,0x22,0x14,0x80,0xa0,0x42,0x04,0x00,0x10,0x80,
 0x50,0xa4,0x80,0x80,0x10,0x50,0x15,0x42,0x40,0x48,0x22,0x00,0x00,0x42,0x04,
 0x40,0x40,0x28,0x02,0x12,0x68,0x1f,0x00,0x01,0x12,0x08,0x1a,0x14,0x40,0x8d,
 0x24,0x11,0x24,0x21,0x11,0x28,0x15,0x24,0x00,0x52,0xa2,0x0a,0x21,0xaa,0x2a,
 0x01,0x02,0x00,0x22,0xa0,0x92,0x10,0x80,0x04,0x20,0x25,0xa9,0x4a,0x08,0x24,
 0x45,0x90,0x44,0x12,0x24,0x51,0x94,0x40,0x08,0x14,0x80,0x40,0x15,0x12,0x82,
 0x20,0x0a,0x00,0x52,0x82,0x0a,0x15,0x0a,0x02,0x95,0x14,0x10,0x12,0x00,0x80,
 0x12,0x91,0x10,0xa0,0x44,0x14,0x12,0x40,0x80,0x84,0x1b,0x21,0xa0,0x04,0xa2,
 0x8a,0x84,0x14,0x92,0x40,0x84,0x24,0x05,0x08,0x21,0x82,0x08,0x95,0x40,0xa0,
 0xa5,0x08,0x00,0x00,0x48,0x24,0x04,0x80,0x0a,0x54,0x4a,0x29,0x11,0x89,0x48,
 0x22,0x12,0xa1,0x40,0x50,0x25,0xaa,0xca,0x52,0x8a,0x42,0x95,0xa2,0x00,0x29,
 0x14,0x42,0x84,0x28,0x04,0x81,0x80,0x00,0xa9,0x64,0x22,0xa1,0x10,0x50,0x25,
 0x42,0x44,0x92,0x04,0x40,0x00,0x42,0x02,0x84,0x10,0x48,0x00,0x04,0x68,0x5f,
 0x04,0x12,0x02,0x00,0x0a,0x10,0x48,0x81,0x24,0x20,0x04,0xa2,0x44,0x44,0x00,
 0x4a,0x00,0x12,0xa1,0x0a,0x52,0xa9,0xaa,0x80,0x00,0xa0,0x14,0xa9,0xa2,0x10,
 0x00,0x04,0x20,0x82,0x48,0x49,0x15,0x14,0x85,0x94,0x00,0x24,0x45,0x51,0x2a,
 0x22,0x02,0x92,0x84,0xa0,0x88,0x10,0x81,0x90,0x08,0x08,0x4a,0x02,0x89,0x88,
 0x00,0x01,0x50,0x15,0x14,0x11,0x04,0x40,0x08,0x24,0x41,0x10,0x01,0x80,0x14,
 0x14,0x21,0x82,0x3e,0x80,0x00,0x14,0x91,0x4c,0x42,0x52,0x55,0x20,0x89,0xaa,
 0x08,0x10,0x40,0x51,0x10,0x91,0x00,0x54,0x45,0x04,0x04,0x00,0x2a,0x02,0x01,
 0x82,0x80,0x14,0x4a,0x55,0xa1,0x94,0x54,0x12,0x02,0x40,0x41,0x28,0xa2,0x5a,
 0x49,0x50,0x8a,0x84,0x14,0x21,0x21,0x10,0x09,0x22,0x84,0x28,0x05,0x00,0xa1,
 0x80,0xa8,0x24,0x25,0x54,0xa4,0xa4,0x2a,0x20,0x42,0x11,0x09,0x81,0x80,0x24,
 0x20,0x94,0x2a,0x02,0x01,0x80,0xa8,0xbb,0x24,0x24,0x05,0x44,0x02,0x82,0x24,
 0x4a,0x22,0x24,0xa9,0x42,0x8a,0x48,0x02,0x21,0x41,0x64,0xa0,0x06,0x51,0x51,
 0xa5,0x00,0x08,0xa8,0x28,0x55,0xa2,0x24,0x00,0x04,0x40,0x82,0xa4,0xa0,0x94,
 0x94,0xa2,0x84,0x24,0xa5,0x26,0x21,0x29,0xa1,0x84,0x84,0x40,0x20,0x94,0x50,
 0x82,0x48,0x02,0x10,0x15,0x49,0x92,0x48,0x81,0x00,0x50,0x15,0x8a,0x14,0x44,
 0x40,0x24,0x10,0x01,0x04,0x80,0x00,0x25,0x88,0x10,0x40,0x7e,0x00,0x00,0x02,
 0x00,0x55,0x29,0x09,0x49,0x50,0x49,0x82,0x56,0x41,0x85,0x24,0x24,0x08,0x01,
 0x44,0x53,0x0a,0x00,0x08,0x2a,0x01,0x52,0x92,0x28,0x29,0x49,0x49,0x41,0x91,
 0x28,0x49,0x08,0x00,0x20,0x08,0x52,0x92,0x10,0x91,0x4a,0x92,0x28,0x29,0x20,
 0x0a,0x88,0x02,0x05,0x20,0x12,0x08,0xa4,0x44,0x22,0x49,0xa5,0x24,0x45,0x51,
 0x12,0x20,0x40,0x00,0x09,0x00,0x01,0x28,0x41,0x0a,0xa0,0x80,0x22,0x04,0x29,
 0x77,0x22,0x11,0x04,0x51,0x8a,0x44,0xa0,0x4c,0x12,0x02,0x28,0xa9,0x9a,0x82,
 0x80,0x40,0x21,0x24,0xb1,0x0a,0x50,0x55,0xa1,0x00,0x10,0x09,0x25,0x85,0x44,
 0x92,0x00,0x12,0x44,0x92,0x24,0xa5,0x52,0x8a,0x50,0x24,0x49,0xa5,0x4a,0x24,
 0x49,0x82,0x80,0x92,0x80,0x02,0x28,0x50,0x45,0x80,0x20,0x09,0x29,0x89,0x24,
 0x2a,0x00,0x10,0xa4,0x2a,0x0a,0x15,0x2a,0x00,0x25,0x48,0x21,0x20,0x04,0x49,
 0x0a,0x08,0x40,0x00,0xfd,0x08,0x44,0x11,0x04,0x21,0x11,0x09,0x24,0x90,0x50,
 0x45,0x0a,0x44,0x94,0x22,0x48,0x09,0x40,0x40,0x85,0x84,0x20,0x14,0x10,0x25,
 0x54,0x91,0x50,0x28,0x29,0xa5,0x40,0x11,0x04,0x11,0x49,0x88,0x20,0x0a,0x49,
 0x92,0x48,0x90,0x92,0x24,0x55,0x2a,0x04,0x20,0x90,0x82,0x2a,0x28,0x12,0x02,
 0x54,0x4a,0x52,0x92,0x48,0x25,0x49,0x51,0x15,0x50,0x40,0x80,0x24,0x80,0x80,
 0x80,0x04,0xa0,0xa0,0x40,0x83,0x00,0x52,0xda,0x80,0x10,0x82,0x20,0x04,0x04,
 0x20,0x0b,0x41,0x02,0x10,0x51,0x91,0x02,0x08,0x81,0x40,0x09,0x65,0x25,0x12,
 0x92,0xa0,0x42,0x80,0x20,0x4a,0x25,0x45,0x92,0x08,0x12,0x02,0x50,0x44,0x22,
 0x24,0x82,0x20,0x92,0x24,0x25,0x4b,0x24,0x49,0x12,0x01,0x51,0x05,0x40,0x28,
 0x80,0x42,0x41,0x48,0x49,0x90,0x44,0x24,0x25,0x08,0x84,0x90,0x2a,0x84,0x14,
 0x05,0x00,0x11,0x12,0x28,0x10,0x05,0x50,0x00,0x2a,0x94,0x80,0xfe,0x22,0x80,
 0x08,0x08,0x51,0x81,0x44,0x64,0x14,0x90,0x44,0x04,0x24,0x4b,0x42,0x90,0x10,
 0x40,0xa0,0x8a,0xa0,0x04,0x0a,0x10,0x24,0x8a,0x04,0x48,0x91,0x24,0x82,0x88,
 0x90,0x80,0x90,0x08,0x29,0x28,0x44,0x29,0x49,0x52,0x10,0x91,0x92,0xa4,0x44,
 0x00,0x20,0x15,0x84,0x94,0x10,0x10,0x12,0x22,0x25,0x29,0x49,0x91,0x22,0x41,
 0x54,0x15,0x12,0x02,0x30,0x49,0x44,0xd0,0x90,0x24,0x94,0x29,0xa9,0x05,0x00,
 0x24,0xf5,0x89,0x14,0x40,0x20,0x00,0x14,0x10,0x05,0x81,0x04,0x02,0x51,0x41,
 0x92,0x89,0x26,0x25,0x4d,0xa2,0x05,0x0a,0x48,0xa1,0x42,0x91,0x24,0x52,0x85,
 0x24,0x89,0x48,0x22,0x05,0x22,0x4a,0x52,0x42,0x40,0x08,0x44,0x92,0x84,0x4a,
 0x22,0x24,0x01,0x12,0x55,0x0a,0x40,0x52,0x40,0x8a,0x42,0x40,0x89,0x88,0x44,
 0x11,0x0a,0x84,0x14,0xa1,0x24,0x80,0xa8,0x04,0x10,0x01,0x02,0x04,0x00,0x21,
 0x10,0x80,0x56,0x42,0x88,0xd8,0x01,0x80,0x10,0x04,0x49,0x00,0x05,0x35,0x24,
 0xa0,0x50,0x04,0x94,0x06,0x21,0x00,0x82,0x00,0x50,0xa5,0xa0,0x22,0x14,0x28,
 0x00,0x92,0x84,0x28,0x49,0x52,0x12,0x88,0x80,0x84,0x10,0x09,0x10,0x91,0x02,
 0x91,0x48,0x55,0xa2,0x94,0x4a,0xa8,0x04,0x80,0x80,0x80,0x08,0x8a,0x20,0x10,
 0x15,0x24,0x22,0x11,0x4a,0x51,0x29,0x82,0x54,0x15,0x2a,0x00,0x42,0xa2,0x5a,
 0xd5,0x5a,0xb5,0x96,0x05,0xd4,0x25,0x08,0x21,0xed,0xb7,0x05,0x84,0x10,0x00,
 0x51,0x20,0x4a,0x81,0x04,0x04,0x50,0x40,0xb5,0x56,0x6d,0xad,0xda,0xab,0x0a,
 0x12,0x89,0x40,0x82,0x4a,0x49,0x10,0xa2,0x24,0x89,0x40,0x11,0x25,0x10,0x44,
 0xa4,0x24,0x24,0x90,0x24,0x25,0x92,0x14,0x21,0x11,0x21,0x50,0x15,0x20,0x2a,
 0xa0,0x24,0x8a,0x4a,0x40,0x49,0x08,0xa4,0x90,0x24,0x00,0x29,0xa2,0x2a,0x80,
 0xaa,0x10,0x48,0xad,0x6d,0xab,0xad,0xea,0x2a,0x41,0x1f,0x01,0x00,0xf2,0x5b,
 0x2d,0x00,0x82,0x24,0x04,0x88,0x76,0x00,0xa1,0x02,0x05,0x12,0xdd,0xda,0xb6,
 0x77,0x77,0x5d,0xa5,0x84,0x04,0x2a,0x24,0x00,0x92,0xa4,0x14,0x92,0x24,0x12,
 0xa4,0x40,0x09,0x11,0x11,0x48,0x91,0x04,0x48,0x92,0x24,0x8a,0x94,0x48,0x94,
 0x0a,0x00,0x14,0x80,0x4a,0x82,0x40,0x10,0x11,0x92,0x42,0x49,0x4a,0x4a,0x45,
 0x40,0x51,0x15,0x0a,0x10,0x8a,0x70,0x5b,0xb5,0x5a,0x6b,0x9b,0x02,0xf4,0x55,
 0x24,0xa5,0xac,0xb7,0x05,0x11,0x08,0x80,0x10,0x41,0x1a,0x41,0x04,0x49,0x90,
 0x80,0xaa,0xab,0x55,0xad,0x5d,0x6b,0x43,0x52,0x52,0x80,0x90,0xaa,0x24,0x02,
 0xa0,0x48,0x52,0x01,0x11,0x26,0x20,0x22,0x25,0x02,0x4a,0x52,0x90,0x24,0x49,
 0x51,0x21,0x25,0x41,0x50,0x95,0x40,0x24,0xa0,0x08,0x2a,0x02,0xa2,0x24,0x24,
 0x24,0x29,0x11,0x11,0x0a,0x2a,0x15,0x40,0xa5,0x00,0x90,0xa2,0x8a,0xa4,0x90,
 0xc4,0x00,0x52,0x17,0x01,0x00,0xf2,0x46,0x04,0x04,0xa1,0x2a,0x04,0x10,0x55,
 0x10,0xd0,0x02,0x44,0x28,0x56,0x54,0xaa,0x52,0x55,0x55,0x95,0x80,0x00,0x29,
 0x0a,0x40,0x92,0xa8,0x4a,0x92,0x14,0x52,0x40,0x00,0x84,0x94,0x90,0xa0,0x20,
 0x88,0x4a,0x92,0x24,0x4a,0x94,0x88,0x10,0x15,0x00,0x04,0x88,0x0a,0x42,0x00,
 0x54,0x14,0x49,0x89,0x82,0x84,0xa4,0x84,0x50,0x50,0x29,0x0a,0x10,0x95,0x52,
 0x08,0x20,0x02,0x02,0x50,0x92,0xec,0x51,0x48,0x94,0xa8,0x93,0x92,0x20,0x08,
 0x40,0x81,0x42,0x05,0x40,0xa9,0x12,0x91,0x45,0xa5,0x55,0x55,0x55,0xa5,0xae,
 0x06,0x0a,0x04,0x44,0x20,0x2a,0x49,0x05,0x81,0x24,0xa2,0x88,0x0a,0x09,0x01,
 0x49,0x0a,0x12,0x4a,0x22,0x10,0x29,0x49,0xa9,0x22,0x52,0x41,0xa0,0x4a,0x91,
 0x20,0x50,0x08,0x55,0x01,0xa2,0x24,0x11,0x14,0x51,0x0a,0x12,0x41,0xa0,0x0a,
 0x50,0x85,0x00,0x28,0x22,0x89,0x90,0xa4,0xa4,0x00,0xb5,0xa1,0x02,0x01,0xd5,
 0x27,0x20,0x02,0xa2,0x2a,0x04,0x20,0x52,0x00,0xa4,0x04,0x44,0xaa,0x54,0xaa,
 0x4a,0xaa,0x54,0xa9,0xaa,0x50,0x49,0x11,0x15,0x92,0xa4,0x50,0x2a,0x12,0x49,
 0x22,0x50,0x40,0x40,0x10,0x52,0x81,0x84,0x08,0xa5,0x84,0x24,0x82,0x10,0x09,
 0x22,0x14,0x10,0x04,0x09,0x0a,0x41,0x00,0xa8,0x28,0x91,0xa4,0x82,0x94,0xa4,
 0x44,0x14,0xa9,0x2a,0x02,0x28,0x4a,0x94,0x88,0x24,0x42,0x10,0x12,0x44,0xfa,
 0x24,0x48,0x10,0xb0,0x87,0x4a,0x41,0x48,0xd5,0x02,0x89,0x15,0x48,0xa8,0x82,
 0x90,0x56,0x95,0x24,0xa9,0x94,0x4a,0xa7,0x05,0x82,0x20,0x84,0xa0,0x48,0x12,
 0x05,0x41,0xa4,0x0a,0x89,0x22,0x2a,0x89,0xa2,0x08,0x24,0x52,0x52,0x12,0xa9,
 0x92,0x28,0x4a,0x52,0x90,0x42,0x45,0x50,0xa4,0xa0,0x14,0x95,0x02,0x42,0x4a,
 0x12,0x29,0x22,0x92,0x10,0x29,0x50,0x15,0x48,0x85,0x04,0x54,0x24,0x81,0x10,
 0x84,0x90,0x90,0x5a,0xc0,0x02,0x44,0x4a,0x57,0x50,0x04,0xa1,0x22,0x40,0x20,
 0x09,0x00,0x32,0x01,0x04,0x95,0xa4,0xaa,0xaa,0x4a,0x55,0x4a,0x95,0x28,0x89,
 0x22,0x0a,0x8a,0xa4,0x50,0x14,0x49,0x50,0x52,0x14,0x01,0x20,0x14,0xa5,0x92,
 0x08,0x08,0xa1,0x44,0x44,0x8a,0x82,0x94,0x42,0x54,0x12,0x05,0x01,0x12,0x81,
 0x40,0x94,0x94,0x24,0x09,0x44,0x48,0x49,0x4a,0x02,0xa5,0x24,0x22,0xa8,0x28,
 0x85,0x02,0x14,0x4a,0x11,0x0a,0x40,0x3d,0x15,0x49,0x00,0xe5,0x87,0x82,0x00,
 0xc4,0x94,0x02,0x42,0x55,0x28,0xa9,0x14,0x52,0xa5,0x2a,0x55,0x25,0x55,0x52,
 0xaf,0x42,0x02,0x04,0x89,0x20,0x51,0x12,0x85,0x48,0x24,0xa5,0x24,0x41,0x24,
 0x40,0x21,0x08,0x25,0x24,0x52,0x88,0x2a,0x29,0x51,0x54,0x51,0x80,0x80,0x08,
 0x90,0x54,0x44,0x94,0x0a,0x41,0x48,0x92,0xa4,0x28,0x25,0x92,0x54,0x28,0x94,
 0x2a,0x88,0x04,0x05,0x58,0xa8,0x42,0x01,0x84,0x48,0x92,0x6e,0xc0,0x04,0x52,
 0x10,0x2d,0x54,0xa0,0x50,0x89,0x80,0x90,0x02,0x40,0x54,0x02,0x00,0x55,0x52,
 0x49,0x52,0xa5,0xaa,0x62,0x2d,0x50,0x51,0x22,0x14,0x88,0x84,0x28,0x25,0x41,
 0x12,0x49,0x90,0x08,0x0a,0x8a,0xa2,0x88,0x02,0x89,0x52,0x84,0x44,0x0a,0x12,
 0x8a,0x52,0x55,0x52,0x25,0x01,0x11,0x21,0x51,0x14,0x92,0x44,0x12,0x45,0x90,
 0x48,0x22,0x42,0x51,0x15,0x02,0x52,0x48,0x06,0x01,0x08,0x54,0x10,0x02,0xa8,
 0x3b,0x89,0x92,0x08,0xaa,0x4f,0x81,0x04,0xa4,0x52,0x00,0x42,0x15,0x04,0xaa,
 0x00,0x55,0xa5,0x4a,0x95,0xaa,0x54,0x55,0xa7,0x42,0x05,0x40,0x44,0x41,0x51,
 0x52,0x92,0x88,0x94,0x48,0x92,0x22,0x20,0xa4,0x28,0x08,0x11,0x2a,0x12,0x88,
 0x52,0x12,0x51,0x49,0x11,0x01,0x88,0x04,0x02,0x54,0x44,0x40,0x82,0x40,0x49,
 0x92,0x48,0x12,0x21,0x25,0x49,0x11,0xa0,0x2a,0xa0,0x90,0x02,0xaa,0x54,0xa5,
 0x02,0x45,0x95,0x44,0x1d,0x20,0x09,0x82,0x40,0x1d,0x54,0x00,0x48,0x89,0x42,
 0x28,0x49,0x90,0x28,0x05,0x80,0x96,0x54,0x52,0x95,0xaa,0x92,0x45,0x2d,0x50,
 0xa5,0x22,0x94,0x14,0x91,0x48,0x24,0x41,0xa4,0x44,0x54,0x09,0x09,0x84,0x22,
 0x84,0x00,0x49,0x45,0x24,0x49,0x8a,0x24,0x4a,0x84,0x52,0x50,0xa9,0x22,0x11,
 0x92,0x24,0x15,0x91,0x48,0xa4,0x88,0x94,0x90,0x24,0x54,0x52,0x15,0x0a,0x4a,
 0x54,0x05,0x21,0x10,0x28,0x10,0x01,0xb2,0x47,0x85,0x22,0x08,0xaa,0x57,0x21,
 0x41,0xe1,0x24,0x00,0x41,0x05,0x00,0x9a,0x80,0x52,0xa9,0x92,0xaa,0xa4,0x92,
 0x54,0xb3,0xa5,0x0a,0x88,0x94,0x22,0xa1,0x24,0x25,0x41,0x14,0x11,0x29,0x10,
 0x24,0xa4,0x52,0x88,0x10,0xaa,0x94,0x28,0x89,0x24,0x51,0x92,0x90,0x12,0xa4,
 0x8a,0x24,0x94,0x24,0x54,0x92,0x50,0x22,0x25,0x11,0x21,0x21,0x24,0x92,0x10,
 0xa8,0x24,0x40,0x21,0x09,0xab,0x14,0x85,0x02,0x85,0x4a,0xd4,0x1d,0x20,0x15,
 0xa1,0x20,0x3d,0x4a,0x00,0x14,0x49,0x21,0x90,0x29,0xa8,0x50,0x02,0x84,0x96,
 0x54,0x49,0xaa,0x54,0xd5,0xa2,0x8a,0x44,0x52,0x42,0x91,0x2a,0x89,0x80,0x94,
 0x42,0x48,0x42,0x05,0x10,0x09,0x08,0x42,0x44,0x25,0x22,0x85,0x52,0x92,0x94,
 0x24,0xa5,0x24,0x49,0x28,0x89,0x22,0x89,0x82,0x24,0x25,0x95,0x88,0x44,0x4a,
 0x0a,0x91,0x24,0x25,0x52,0x15,0x0a,0x54,0x80,0x02,0x42,0x28,0x54,0x50,0x01,
 0x69,0x47,0x09,0x41,0x04,0x4a,0x9d,0x10,0x11,0xe0,0x24,0x80,0xa4,0x92,0x04,
 0x1a,0x40,0x50,0x29,0xa5,0xaa,0x52,0xa5,0xaa,0xa1,0x2a,0x92,0x24,0x29,0x4a,
 0x40,0x12,0x4a,0x02,0x08,0x92,0x14,0x52,0x4a,0xa4,0xa0,0x04,0x11,0x92,0x94,
 0x54,0x84,0x48,0x22,0x92,0x14,0x12,0x92,0x44,0x52,0x94,0x24,0x54,0x92,0x48,
 0x20,0x25,0x92,0x10,0x10,0x24,0x09,0x08,0xa4,0x2a,0x50,0x81,0x2a,0xa9,0x28,
 0x05,0x01,0x65,0xa0,0xf4,0x03,0x42,0x9a,0x90,0x40,0x7a,0x44,0x80,0x54,0x12,
 0x01,0x40,0x09,0x80,0x54,0x09,0x85,0x4a,0x95,0x94,0x4a,0x2a,0x65,0x49,0x95,
 0x24,0x49,0x12,0x21,0x15,0x89,0x90,0x54,0x24,0x49,0xa2,0x08,0x22,0x10,0x24,
 0x52,0x4a,0x41,0x42,0x11,0x29,0x25,0x48,0x49,0x42,0x89,0x20,0x90,0x94,0x22,
 0x92,0x92,0x24,0x92,0x4a,0x81,0x20,0x4a,0x44,0x49,0x52,0x45,0x29,0x15,0x02,
 0x22,0x80,0x91,0x82,0x50,0x2a,0x28,0x09,0x5b,0x29,0x08,0x25,0x42,0xaa,0x3e,
 0x09,0x21,0x50,0x29,0x90,0xaa,0x92,0x28,0x12,0x20,0x50,0x55,0x2a,0xa5,0x54,
 0x55,0xea,0x62,0x23,0x49,0x92,0xa4,0x54,0x4a,0x52,0x4a,0x22,0x89,0x24,0x09,
 0xa5,0x94,0x4a,0x80,0x04,0xa1,0x14,0x29,0xa2,0x24,0x88,0x12,0x25,0x29,0x52,
 0x44,0x2a,0x22,0x49,0x49,0x4a,0x92,0x24,0x15,0x2a,0x8a,0x04,0x09,0x92,0x04,
 0x11,0x51,0x29,0xa4,0x80,0xa8,0x4a,0x28,0x8a,0x00,0x15,0xa0,0xf4,0x82,0x52,
 0x14,0x10,0x40,0x6a,0x52,0x00,0xa4,0x44,0x01,0x80,0x2a,0x02,0xa8,0x04,0x49,
 0x49,0xa5,0xaa,0xaa,0x92,0xa9,0x40,0x4d,0x92,0x24,0x49,0x94,0x24,0x05,0x20,
 0x10,0x40,0x88,0x44,0x48,0x02,0x90,0x2a,0x49,0x14,0xa0,0x94,0x14,0x89,0xa2,
 0xa4,0x40,0x84,0x24,0x21,0x44,0x91,0x24,0x24,0x91,0x44,0x52,0x42,0x09,0x24,
 0x51,0x44,0x49,0x52,0x4a,0x54,0x15,0x10,0x22,0x42,0x21,0x45,0x10,0x55,0x24,
 0x91,0xde,0x48,0x80,0x4a,0x41,0x89,0xfe,0x88,0x48,0x69,0x12,0x20,0x69,0x11,
 0x50,0x01,0x92,0xa4,0x92,0x54,0x49,0x49,0x2a,0xf5,0xa9,0x92,0x24,0x49,0x22,
 0x21,0x89,0xa8,0x4a,0xa5,0x2a,0x25,0x91,0x22,0xa9,0x22,0x80,0x20,0x21,0x49,
 0x22,0x21,0x24,0x09,0x49,0x2a,0x29,0x91,0x10,0x09,0x2a,0x49,0x49,0x24,0x29,
 0x49,0x14,0xa5,0x48,0x8a,0x10,0x24,0x01,0x51,0x51,0x15,0x85,0x88,0xd4,0x14,
 0x21,0xa5,0x00,0x0b,0x44,0x77,0x12,0x54,0x50,0x14,0x20,0xf1,0x25,0x00,0x50,
 0xa9,0x00,0x90,0xaa,0x04,0xa8,0x20,0x50,0x55,0x55,0x2a,0x55,0xd5,0x2a,0xc2,
 0x2a,0x91,0x24,0x49,0x95,0x24,0x12,0x10,0x12,0x90,0x88,0x04,0x11,0x0a,0x94,
 0x2a,0x4a,0x4a,0x90,0x94,0x94,0x92,0xa4,0x12,0x49,0x92,0x24,0x42,0x52,0x89,
 0x24,0x92,0x92,0x84,0x94,0x4a,0x10,0x92,0x20,0x54,0x89,0x88,0x04,0xa5,0x2a,
 0x10,0x42,0xa8,0xfb,0xde,0xdb,0xff,0x20,0xa9,0xde,0xef,0xb7,0x4f,0x40,0x85,
 0xda,0xb7,0x08,0x65,0x57,0x48,0x62,0x6b,0x90,0x04,0x82,0x6a,0xef,0xaa,0xf7,
 0xb6,0xad,0x6d,0xb2,0x46,0x4a,0x52,0x12,0x4a,0x49,0x40,0x42,0x48,0x45,0x22,
 0x49,0x44,0x20,0x21,0xa4,0x24,0x01,0x0a,0x49,0x22,0x49,0x12,0xa4,0x24,0x25,
 0x89,0x20,0x22,0x52,0x49,0x49,0x24,0x29,0x21,0x11,0x45,0x40,0x4a,0x21,0x20,
 0x25,0x52,0x28,0x09,0x89,0x14,0x05,0x04,0xa1,0x10,0x41,0x0a,0xa4,0x35,0x10,
 0x48,0x90,0x12,0x50,0xf4,0x1e,0x40,0xa8,0x28,0x10,0x54,0x95,0x05,0x81,0x28,
 0x9a,0x10,0x55,0x08,0x4a,0x42,0x12,0x42,0x15,0x11,0x11,0x49,0x41,0x24,0x94,
 0x28,0x25,0x92,0x48,0x01,0x92,0x4a,0x44,0x09,0x49,0x54,0xa1,0x22,0x49,0x22,
 0xa4,0x12,0x92,0x48,0x52,0x8a,0x94,0x14,0x12,0x22,0x92,0x44,0x4a,0x4a,0x90,
 0x2a,0x22,0x4a,0x95,0x00,0x09,0xa5,0x2a,0x24,0x20,0x28,0x40,0x04,0x02,0x54,
 0x21,0xd2,0xbf,0x46,0x00,0x29,0x44,0x02,0xd5,0x2f,0x11,0x12,0x80,0x40,0x50,
 0x80,0x20,0x14,0x80,0x04,0x06,0x00,0x21,0x01,0x08,0x41,0xa9,0x4a,0x44,0x4a,
 0x25,0x2a,0x95,0x10,0x45,0x92,0x48,0x02,0x48,0x49,0x84,0x90,0x24,0x84,0x82,
 0x14,0x94,0x24,0x49,0x49,0x4a,0x49,0x92,0x88,0x12,0x22,0xa1,0x48,0x88,0xa4,
 0x92,0x24,0x11,0x24,0x44,0x49,0x24,0x42,0xa1,0x20,0x52,0x15,0x01,0x95,0x84,
 0x12,0x81,0x90,0x29,0x80,0xb4,0xd5,0xbb,0x22,0x5a,0x91,0xa8,0xf4,0x5f,0x00,
 0xb4,0x24,0x00,0xa5,0x89,0x08,0x40,0x52,0x4b,0x48,0x22,0x02,0x24,0x43,0x94,
 0x40,0x25,0x29,0xa1,0x40,0x09,0x22,0x48,0x22,0x49,0x84,0xa0,0x82,0x00,0x22,
 0x25,0x49,0x51,0x28,0x89,0x42,0x8a,0x24,0x12,0x51,0x92,0x44,0x52,0x09,0x91,
 0x54,0x92,0x52,0x12,0x21,0x09,0xaa,0x88,0x22,0x14,0x09,0x21,0x08,0x4a,0xa1,
 0x2a,0x54,0x24,0x08,0x00,0x24,0x42,0xab,0x04,0xe9,0x7e,0x6f,0x48,0x57,0x04,
 0x02,0x52,0x1b,0xa4,0x28,0x00,0x14,0xa8,0x50,0x02,0x12,0x49,0x09,0x09,0x08,
 0x48,0x04,0x08,0x6a,0xb2,0x95,0x44,0x8a,0x0a,0x45,0x95,0x22,0x49,0x20,0x09,
 0x0a,0x10,0xaa,0x08,0x49,0x80,0x24,0x25,0xa0,0x94,0x50,0x92,0xa4,0x84,0x48,
 0x92,0x84,0x24,0x24,0x89,0x22,0x44,0x49,0x8a,0x44,0x41,0x10,0x94,0xa0,0x24,
 0x94,0x20,0x81,0x54,0x12,0x01,0x11,0x22,0x91,0x90,0xb4,0x0a,0xa1,0x52,0xab,
 0x75,0xa2,0x55,0xa1,0x48,0xa9,0x76,0x01,0x2a,0x92,0x40,0x52,0x8a,0x00,0xa4,
 0x54,0x50,0xe8,0x82,0x02,0x25,0x81,0x00,0xa0,0x4a,0x22,0x51,0x90,0x28,0xa1,
 0x90,0x14,0x8a,0xa2,0xa0,0x04,0x41,0x52,0x84,0x2a,0x12,0x91,0x56,0x22,0x8a,
 0x94,0x12,0x52,0x84,0x44,0x52,0x0a,0x95,0xa4,0x48,0x29,0x24,0x01,0x92,0x94,
 0xa2,0x22,0x0a,0x42,0x01,0x08,0x48,0x50,0x15,0x94,0x24,0x08,0x49,0x69,0x55,
 0x11,0x84,0x54,0x55,0x5f,0x5c,0x95,0x04,0x22,0xa4,0xaa,0x07,0x68,0x12,0x00,
 0x54,0x51,0x05,0x11,0x35,0x09,0x09,0x91,0x92,0x2c,0x35,0x49,0xa3,0x0a,0x49,
 0x8a,0x02,0x45,0x0a,0x42,0x22,0x24,0x14,0x12,0x90,0x0a,0x01,0x29,0x44,0x48,
 0x12,0x90,0x94,0x24,0x22,0x4a,0x49,0x29,0x90,0x24,0x11,0x48,0x12,0x15,0x45,
 0x49,0x2a,0x29,0x25,0x88,0x14,0x50,0x09,0x54,0xa2,0x12,0xa5,0x2a,0x21,0x52,
 0x41,0x00,0x50,0x55,0x25,0x21,0xaa,0xaa,0x37,0xa5,0x4a,0xa0,0x08,0x51,0xd5,
 0x42,0x15,0x40,0x94,0xa2,0x84,0x00,0x44,0xc9,0x30,0x44,0x0a,0x20,0x00,0x00,
 0x20,0x48,0x55,0x92,0x24,0x55,0x28,0x51,0x11,0x09,0x91,0x82,0x20,0x05,0xa0,
 0x52,0x04,0x92,0x92,0x48,0x4a,0x42,0x49,0x49,0x91,0x24,0x92,0x4a,0x52,0xaa,
 0x20,0xa4,0x84,0x50,0x92,0x42,0x10,0x91,0x22,0x85,0x24,0x52,0x81,0x04,0x48,
 0x51,0x15,0x84,0x88,0x10,0x12,0x51,0x89,0x80,0x88,0x48,0x55,0x3d,0x55,0x94,
 0x0a,0x22,0x4a,0x15,0x0b,0x98,0x00,0x00,0x14,0x52,0x89,0x10,0x54,0x13,0x01,
 0x24,0x82,0x98,0x44,0x02,0x60,0x83,0x24,0x49,0x48,0x90,0x84,0x44,0x20,0x24,
 0x29,0x49,0x50,0x4a,0x00,0x49,0x29,0x40,0x92,0x10,0x15,0x92,0x94,0x44,0x92,
 0x48,0x92,0x84,0x44,0x48,0x11,0x29,0x85,0x24,0x94,0xa4,0x24,0x09,0x20,0x52,
 0x04,0x28,0x42,0x25,0x91,0x2a,0x21,0x54,0x82,0x40,0xa4,0x54,0x2a,0x42,0x52,
 0xa2,0x5f,0x92,0x22,0x90,0x88,0x20,0x6a,0x83,0x2a,0x54,0x48,0xa9,0x40,0x02,
 0x84,0x22,0x15,0x9a,0x84,0x24,0x10,0x11,0x50,0x49,0x2d,0x91,0xa4,0x92,0x4a,
 0x52,0x12,0x4a,0x91,0x44,0x90,0x82,0x24,0x4a,0x04,0x84,0x2a,0x44,0x8a,0x48,
 0x49,0x44,0x22,0x44,0x82,0x24,0x29,0x29,0x91,0xa4,0x84,0x50,0xaa,0x2a,0x11,
 0x49,0x52,0x89,0x88,0xa2,0x92,0x10,0x48,0xa4,0x12,0x84,0x90,0x04,0x02,0x51,
 0x01,0x00,0x08,0x01,0xd5,0x3a,0x45,0x88,0x44,0x22,0x45,0x91,0x25,0x14,0x01,
 0x02,0x04,0x54,0x20,0x11,0x88,0x9a,0x00,0x04,0x80,0x12,0x40,0x09,0xa0,0x92,
 0x44,0x49,0x25,0xa0,0x24,0x49,0x00,0x4a,0x12,0x05,0x14,0x91,0x84,0xb2,0x28,
 0x90,0x92,0x50,0x22,0x91,0x12,0x49,0x11,0x28,0x91,0xa4,0x94,0x20,0x49,0x52,
 0x8a,0x90,0x40,0xa2,0x24,0x01,0x20,0x92,0x08,0x08,0xa2,0x22,0x51,0x15,0x28,
 0x4a,0x49,0x28,0xa0,0x4a,0x95,0x42,0x48,0xa8,0x1f,0x15,0x22,0x11,0x48,0x10,
 0x48,0x03,0x15,0x40,0x20,0x11,0x51,0x09,0x84,0x44,0x24,0x86,0x44,0x12,0x20,
 0x09,0x80,0xa4,0x25,0x29,0x94,0x48,0x05,0x91,0x24,0x95,0x90,0x80,0xa8,0x42,
 0x44,0x52,0x08,0x45,0x25,0x24,0x25,0x49,0x94,0xa4,0x10,0x44,0x82,0x24,0x29,
 0x22,0x85,0x24,0x29,0x52,0xa6,0xaa,0x04,0x49,0xaa,0x8a,0x48,0xa2,0xa2,0x14,
 0x04,0x55,0x2a,0x82,0x10,0x04,0x81,0xb2,0x28,0x20,0x94,0x92,0xf2,0x42,0x49,
 0x49,0x4a,0x25,0xab,0xaa,0x12,0x94,0x24,0x04,0x40,0x08,0x40,0x10,0x12,0x29,
 0x28,0x12,0x42,0x24,0x21,0x49,0x50,0x15,0x92,0x52,0x22,0x49,0x4a,0x41,0x20,
 0x45,0x2a,0x05,0xa9,0x82,0x88,0x52,0x14,0x48,0x11,0x48,0x92,0x22,0x08,0x25,
 0x11,0x55,0x4a,0x44,0x49,0x24,0x4a,0x42,0x89,0x08,0x11,0x49,0x24,0x41,0x24,
 0x92,0x88,0x84,0x48,0x51,0x52,0x15,0x20,0xaa,0x42,0x00,0xa0,0xa6,0xae,0x55,
 0x55,0x95,0x4d,0xa6,0xaa,0x52,0x55,0xa9,0xaa,0x41,0x15,0x00,0x91,0x14,0x22,
 0x12,0x85,0x40,0xc4,0x09,0x81,0x10,0x21,0x08,0x00,0xa4,0x4a,0x49,0x92,0x54,
 0x92,0x24,0x94,0x4a,0x28,0x41,0x50,0x0a,0x28,0x25,0x04,0x41,0x25,0xa4,0x92,
 0x24,0x49,0xa5,0x8a,0x48,0x11,0x91,0x22,0x14,0x41,0x21,0x29,0x44,0x65,0x4a,
 0x92,0x4a,0x14,0x89,0x24,0x45,0x28,0x45,0x8a,0xa4,0x12,0x8a,0x40,0x04,0x2a,
 0xc9,0xda,0xb5,0xb6,0xb6,0x6d,0x10,0xbb,0xb6,0xdd,0xb6,0xb7,0xb5,0x09,0x4a,
 0x12,0x40,0x80,0x08,0x40,0x10,0x12,0x51,0x74,0x04,0x02,0x40,0x42,0x52,0xa1,
 0x25,0x22,0x45,0x82,0x44,0x92,0x20,0x12,0x21,0x14,0x41,0xa1,0x12,0x40,0xa9,
 0x14,0x48,0x81,0x24,0x92,0x24,0x09,0x50,0x12,0x4a,0x4a,0x94,0xa2,0x00,0x4a,
 0x42,0x11,0x0a,0x91,0x44,0x84,0xa0,0x24,0x12,0x28,0x91,0x10,0x11,0x50,0x15,
 0x20,0x2a,0x91,0x00,0x35,0xa1,0x00,0x41,0x02,0x10,0x42,0x02,0x01,0x22,0x40,
 0x40,0x08,0x80,0x0a,0x40,0x12,0x24,0x80,0x14,0x84,0x44,0x88,0x83,0x48,0x22,
 0x49,0x11,0x40,0x48,0x95,0x90,0x28,0x54,0x29,0x49,0x8a,0x48,0x94,0x04,0x2a,
 0x10,0x49,0x15,0x42,0x40,0x25,0x2a,0x91,0x24,0x92,0x64,0x25,0x89,0x90,0x90,
 0x22,0x29,0x82,0x24,0x29,0x4a,0x51,0x48,0x92,0x52,0x0a,0x92,0xa0,0x04,0x44,
 0x4a,0x4a,0xa5,0x2a,0x8a,0x48,0x04,0x08,0x4a,0x24,0x4a,0x08,0x92,0x44,0x08,
 0x08,0x24,0x10,0x09,0x04,0x21,0x22,0x4a,0x02,0x80,0x80,0x02,0x40,0x51,0x00,
 0x51,0x02,0x00,0x08,0x84,0x40,0x05,0x60,0x45,0x26,0x45,0x11,0x42,0x92,0x24,
 0x25,0x01,0x52,0x44,0x45,0x22,0xa2,0x94,0x8a,0x94,0x48,0x24,0x49,0x49,0x92,
 0x94,0x24,0x25,0x25,0x45,0x42,0x08,0x91,0x44,0x54,0x4a,0xa5,0x24,0x94,0xa4,
 0x48,0x0a,0x90,0x12,0x21,0x10,0x29,0x15,0x20,0x24,0x41,0xa2,0x00,0x01,0x00,
 0x20,0x02,0x10,0x00,0x81,0x80,0x54,0x00,0x11,0x08,0x08,0x05,0x50,0x55,0x54,
 0x20,0x95,0x0a,0x52,0x84,0x16,0x49,0x82,0x20,0x59,0x25,0xa5,0x2a,0x91,0x28,
 0x8a,0x94,0x54,0x49,0x10,0xa8,0x08,0x29,0x22,0x94,0x14,0x21,0x52,0x42,0x25,
 0x89,0x24,0x22,0x49,0x22,0x92,0x48,0x91,0x28,0x29,0x45,0x44,0x92,0x82,0x24,
 0x0a,0x49,0x49,0x22,0x24,0x80,0x4a,0xa4,0x08,0x45,0xa4,0x12,0x82,0x48,0x0a,
 0x80,0x00,0x99,0x48,0x82,0x48,0x92,0x22,0x24,0x04,0x50,0x12,0x40,0x80,0xa0,
 0x92,0x04,0x80,0xa2,0x00,0x50,0xa4,0x08,0x11,0x45,0x00,0x10,0x02,0x09,0x00,
 0xa0,0x95,0x24,0x45,0x51,0x52,0x82,0x84,0x2a,0x81,0xa4,0x46,0x49,0xa1,0xa0,
 0x44,0x84,0x28,0x48,0x2a,0x49,0x54,0x12,0xa9,0x48,0x25,0x2a,0xa5,0x94,0x28,
 0x92,0x14,0x29,0x49,0x51,0x24,0x91,0xd4,0x12,0x29,0x10,0x19,0x51,0xd9,0x52,
 0x15,0x28,0x52,0x29,0x4b,0x59,0x92,0x90,0x24,0x23,0x49,0x52,0x92,0xa4,0x52,
 0x92,0x14,0x25,0x04,0x4a,0x12,0x55,0x54,0xa0,0xa4,0x12,0x42,0x44,0x4a,0xb2,
 0x92,0x24,0x25,0xcb,0x52,0x25,0x92,0xa8,0xea,0x8d,0x28,0xa2,0x44,0x32,0x11,
 0x2e,0x20,0xf4,0xf5,0xf2,0xf1,0x93,0x92,0x47,0x2f,0x1b,0x5f,0x7a,0x25,0x48,
 0xe9,0x2b,0x4a,0x4a,0x48,0xa3,0xfe,0x24,0x0a,0x91,0x48,0xe2,0x45,0x82,0xca,
 0x7a,0x08,0x72,0xa8,0x2a,0x42,0x24,0x82,0x00,0x81,0x00,0x02,0x00,0x08,0x10,
 0x00,0x00,0x00,0x20,0x40,0xb4,0x00,0x50,0x01,0x40,0xa8,0x8a,0x08,0x52,0xa0,
 0x08,0x91,0x0a,0x04,0x04,0x10,0x02,0x20,0xa0,0x8a,0x48,0x05,0x34,0x26,0x91,
 0x14,0x01,0x31,0x4a,0x97,0x4a,0x69,0x9a,0x19,0xeb,0x4b,0x4a,0x97,0xd9,0xd5,
 0xa9,0x30,0x48,0x11,0x1a,0x46,0x51,0x91,0xa0,0x8b,0x21,0x52,0x59,0x42,0x25,
 0x55,0x80,0x10,0xa2,0x19,0x51,0x69,0x25,0x15,0x10,0x52,0x29,0x50,0x44,0x50,
 0x20,0x49,0x82,0x10,0x08,0x42,0x92,0xa4,0x08,0x49,0x15,0x05,0x25,0x11,0x02,
 0x24,0x80,0x54,0x08,0x45,0x04,0x0a,0x01,0xa1,0x44,0x92,0x08,0xca,0x26,0x25,
 0xa8,0x9d,0x8c,0x44,0x42,0x8a,0x50,0x21,0x46,0x98,0xe4,0x9c,0x5b,0x13,0xa2,
 0x04,0xd7,0x9d,0x99,0x19,0xb5,0x12,0x4a,0xb9,0x2a,0x2a,0x24,0x15,0xa4,0x2b,
 0x09,0x99,0x28,0x41,0xe6,0x2a,0x84,0x94,0x5a,0x24,0x72,0xaa,0x12,0xa2,0x48,
 0x02,0x02,0x35,0x89,0x04,0x20,0x12,0x4a,0x22,0x12,0x00,0x41,0x82,0x50,0x01,
 0xe0,0x08,0x04,0x92,0xa8,0x24,0x50,0x41,0x08,0x50,0x25,0x28,0x02,0x00,0x01,
 0x42,0xa0,0x4a,0x40,0x45,0x5e,0x24,0xb9,0x7b,0x52,0x1e,0x4a,0xb7,0x4e,0x72,
 0xae,0xb9,0x79,0x09,0x29,0xe3,0xda,0xdb,0x5b,0xf4,0xac,0x21,0x3a,0x71,0xe9,
 0x97,0xe0,0xc9,0x43,0x57,0x4e,0x97,0x9e,0x6b,0xc3,0x5b,0xf3,0xdc,0x9a,0xb8,
 0x50,0x15,0x08,0x94,0x94,0x20,0x00,0x20,0x10,0x09,0x02,0x20,0x80,0x00,0x24,
 0x90,0x20,0x08,0x82,0x08,0x81,0x80,0x00,0x02,0x08,0xd4,0x12,0x25,0x05,0x0a,
 0x82,0x90,0x24,0x90,0x10,0x62,0x95,0x2a,0x29,0x0d,0xc9,0xe7,0xe6,0xf6,0x3b,
 0x3f,0x7f,0x9f,0xb4,0xcc,0xfb,0xfa,0x50,0x85,0xcb,0x9c,0x17,0x4f,0xd9,0xb9,
 0x95,0xf8,0x74,0xce,0x2e,0x8f,0x15,0x2f,0xe7,0xbe,0xdd,0x9b,0xf7,0xd6,0xec,
 0xce,0xfa,0xbc,0x33,0xaa,0x2a,0xa2,0x48,0x02,0x82,0x44,0x8a,0x40,0x40,0x52,
 0x20,0x09,0xa4,0x80,0x40,0x8b,0x20,0x10,0x62,0x24,0x24,0x12,0x48,0xa2,0x50,
 0x57,0x02,0x50,0x25,0x01,0x02,0x80,0x0c,0x40,0x48,0x25,0x42,0x42,0x5e,0x70,
 0x76,0x66,0xb6,0x9a,0x59,0x73,0x26,0x72,0xae,0xf9,0xe0,0x4b,0xa8,0xd3,0xad,
 0xcf,0x27,0xbd,0x5b,0x41,0xf2,0x75,0xe7,0xcc,0xcc,0xa1,0x5e,0x77,0xc6,0xcc,
 0x9d,0x75,0x77,0xc7,0x64,0xcd,0xcc,0x35,0x51,0x0a,0x08,0x12,0xa9,0x10,0x11,
 0x08,0x0a,0x24,0x02,0x2a,0x40,0x02,0x10,0x89,0x20,0x80,0x42,0x90,0x08,0x01,
 0x42,0x81,0x00,0x4a,0xa9,0x08,0x84,0x0a,0x50,0x4a,0x12,0x63,0x4a,0xa1,0x96,
 0x94,0x94,0x8e,0xba,0x66,0xd7,0x6a,0x9a,0x3d,0xb7,0x4e,0xb1,0xf8,0xcd,0xcb,
 0xf9,0xaf,0xa5,0x5f,0xae,0x9e,0x98,0xb1,0x95,0xc4,0x33,0xeb,0xee,0xce,0x15,
 0x3d,0xb3,0xee,0xde,0x59,0x73,0x66,0xd6,0xea,0xdc,0xdd,0x59,0xa4,0x2a,0xa2,
 0xa4,0x00,0x04,0x80,0x28,0x20,0x00,0x42,0x80,0x04,0x88,0x02,0x40,0x04,0x04,
 0x00,0x20,0x02,0x48,0x00,0x04,0x24,0x20,0x85,0x00,0x51,0x25,0x01,0x00,0x40,
 0x40,0x00,0xa4,0x4a,0x42,0x49,0x2e,0x3a,0x37,0xe7,0x76,0xad,0xcd,0x3b,0x23,
 0x3a,0xe2,0xc4,0x91,0xf5,0xc7,0x49,0x66,0x6d,0x4c,0xde,0xb5,0x20,0x95,0xbb,
 0x67,0xee,0xee,0x48,0xf4,0x7b,0x76,0xc6,0x9e,0xb1,0x77,0xd7,0x72,0xce,0xce,
 0x3a,0x51,0x15,0x08,0x28,0x14,0x91,0x24,0x88,0x04,0x49,0x12,0x24,0x40,0x02,
 0x90,0x24,0x90,0x90,0x00,0xaa,0x40,0x02,0x94,0x20,0x01,0x89,0x28,0x24,0x84,
 0x02,0x10,0x41,0x8a,0x12,0x49,0x40,0x95,0x24,0x12,0x4f,0x59,0x77,0xc3,0xb3,
 0x5c,0x97,0x73,0x97,0x58,0x71,0x96,0xa5,0x09,0xa8,0x25,0xef,0xec,0x9e,0xcc,
 0xf0,0x4a,0x24,0xbb,0x73,0x6e,0xd6,0xd2,0xb2,0x3b,0xe7,0xee,0xcc,0x31,0x3b,
 0xcb,0xa9,0x66,0xec,0x98,0xa8,0x24,0xa2,0x44,0x09,0x00,0x81,0x84,0x10,0x20,
 0x82,0x28,0x09,0x12,0x04,0x21,0x01,0x00,0x52,0x08,0x0c,0x48,0x02,0x82,0x28,
 0x24,0x42,0x81,0x50,0x29,0x45,0x0a,0x80,0x80,0x40,0xb2,0x45,0x92,0xa4,0x9c,
 0x9d,0xb9,0xd1,0x39,0xad,0x89,0x5d,0x4b,0x3a,0x3c,0xcd,0xcd,0xa4,0xc4,0xc9,
 0x31,0x4f,0x46,0x6e,0x75,0x94,0x4e,0xdb,0x77,0xe3,0x66,0xc4,0xb8,0x7d,0x6f,
 0xd7,0xde,0xbb,0xf7,0xd7,0xf4,0xb6,0xf6,0x3f,0x51,0x15,0x08,0x51,0x42,0x49,
 0x20,0x04,0x02,0x09,0x22,0x40,0x80,0x40,0x21,0x24,0xa4,0x48,0x00,0x94,0x40,
 0x02,0x40,0x20,0x02,0x01,0x11,0x24,0x84,0x02,0x00,0x40,0x92,0x92,0x12,0xa0,
 0x2a,0x48,0x11,0x79,0x71,0x75,0xc5,0x5a,0x9d,0xdf,0x39,0x17,0x7e,0x4d,0xfa,
 0x3c,0x09,0xf2,0x63,0xc5,0xd2,0x2f,0x58,0x31,0x41,0xf4,0x7a,0xeb,0x69,0x6b,
 0x69,0x9f,0x73,0xe7,0xee,0xac,0x59,0x77,0x4e,0x71,0x2e,0xcf,0x58,0x94,0x2a,
 0x22,0x84,0x04,0x00,0x05,0x25,0x48,0x20,0x82,0x42,0x12,0x04,0x80,0x20,0x10,
 0x02,0x91,0x0a,0x02,0x90,0x04,0x09,0x48,0x54,0x84,0x80,0x68,0x48,0x24,0x09,
 0x80,0x80,0x40,0x49,0x45,0x11,0x54,0xa2,0x04,0x98,0x48,0x09,0x62,0x1d,0xa1,
 0x40,0x00,0x02,0x04,0x82,0xa4,0x0a,0x8a,0x28,0x09,0x90,0x22,0x54,0x2a,0x05,
 0x09,0x39,0x92,0x70,0x84,0x40,0x14,0x48,0x10,0x92,0x84,0xa0,0x22,0x84,0x90,
 0x54,0x02,0x51,0x15,0x48,0x52,0x51,0x24,0x21,0x84,0x01,0x24,0x12,0x48,0x40,
 0x22,0x12,0x81,0x04,0x20,0x04,0x49,0x98,0x04,0x52,0x00,0x03,0x01,0x21,0x28,
 0x42,0x09,0x01,0x82,0x24,0x51,0x48,0xa0,0x55,0x24,0x89,0x14,0xa1,0x3a,0x6d,
 0x52,0x69,0x9a,0x14,0x94,0x0a,0x51,0x41,0x28,0x21,0x51,0x29,0x45,0x52,0xa5,
 0x14,0x97,0x44,0x51,0xa2,0xb2,0x24,0x6d,0x51,0x14,0x89,0x12,0x05,0x49,0x12,
 0x15,0x41,0x29,0x4a,0x80,0x48,0xa4,0x12,0x00,0x29,0x0a,0x01,0x08,0x04,0x48,
 0x80,0x40,0x40,0x04,0x80,0x00,0x94,0x50,0x84,0x20,0x06,0x01,0x90,0x00,0x29,
 0x28,0x44,0x84,0x82,0xb4,0x20,0x24,0x08,0x00,0x22,0x02,0xa2,0x22,0x89,0x20,
 0x42,0x14,0x9d,0x1c,0x49,0xe2,0x4c,0xa2,0x22,0xa1,0x24,0x14,0x45,0x44,0x4a,
 0x82,0x28,0x44,0x10,0x41,0x17,0x11,0xa5,0x94,0x3c,0x49,0xbc,0x22,0x11,0x20,
 0x49,0xa8,0x24,0x49,0xa4,0x94,0x84,0x20,0x29,0x21,0x29,0x15,0x55,0x48,0x01,
 0x48,0x82,0x22,0x02,0x12,0x0a,0x14,0x41,0x12,0x24,0x01,0x0d,0x11,0x88,0x25,
 0x80,0x04,0x10,0x00,0x05,0x11,0x20,0x20,0x94,0x08,0x00,0x42,0x4a,0x1c,0x90,
 0x50,0x4d,0x25,0x92,0x14,0x80,0x34,0x22,0x24,0x89,0x13,0x89,0x08,0x4a,0x92,
 0x82,0x28,0x29,0x21,0x29,0x85,0x92,0x4a,0x54,0x40,0x4a,0x12,0x45,0x6a,0x22,
 0x15,0x48,0x45,0x4a,0x12,0x02,0x09,0x12,0x49,0x42,0x22,0x95,0x44,0x94,0xa4,
 0x2a,0x00,0x25,0xaa,0x22,0x49,0x92,0x98,0xa4,0x2a,0x49,0x52,0x92,0x44,0x24,
 0x52,0x40,0xa2,0x2a,0x4d,0x52,0x92,0x26,0x55,0x44,0x85,0x44,0x95,0x62,0xd3,
 0x92,0x24,0xa5,0x49,0xa2,0x12,0x80,0x08,0xa2,0x2a,0x49,0x49,0x91,0x24,0x44,
 0x24,0xa1,0x20,0x49,0x28,0x42,0x42,0x8a,0x24,0x52,0x48,0x20,0x89,0x2a,0x91,
 0x24,0x28,0x89,0x94,0xa8,0x02,0x10,0x21,0xa4,0x54,0x64,0x49,0x24,0x29,0x09,
 0x08,0x11,0x21,0xa9,0x0a,0x54,0x48,0x09,0x08,0x10,0x02,0x40,0x00,0x85,0x80,
 0x04,0x00,0x00,0x41,0x80,0x14,0x59,0x04,0x10,0x00,0x04,0x00,0x20,0x21,0x28,
 0x55,0x01,0x09,0x08,0x00,0x00,0x00,0x00,0xa4,0x0d,0x50,0x50,0x29,0x45,0x92,
 0x24,0x48,0x82,0x12,0x49,0x4a,0x94,0x90,0x04,0x29,0x91,0x52,0x92,0x94,0x12,
 0x95,0x44,0x48,0x24,0xa9,0x8a,0x24,0x25,0x85,0x28,0x44,0x90,0x12,0x89,0x92,
 0x24,0x91,0x42,0x52,0xa5,0x44,0x4a,0x52,0x29,0x82,0x84,0x22,0xa1,0x41,0x92,
 0x02,0x29,0x05,0x8a,0x10,0x25,0x09,0x09,0x81,0xa2,0x2a,0x22,0x89,0x24,0x21,
 0x51,0x81,0x4a,0x91,0x54,0x04,0x01,0x00,0x2a,0x49,0x01,0x52,0xa0,0x52,0x0a,
 0x42,0x42,0x28,0x21,0x49,0x95,0x28,0x09,0x10,0x11,0x49,0x4a,0x52,0x92,0x24,
 0x84,0x48,0x42,0x44,0x40,0x92,0x92,0x92,0x84,0x24,0x51,0x48,0x52,0x92,0x10,
 0x4a,0xa4,0x24,0x24,0x49,0x24,0x88,0x08,0x10,0x12,0x91,0x48,0x15,0x20,0x51,
 0x08,0x00,0x08,0x41,0x20,0x00,0x45,0x20,0x40,0x00,0x40,0x00,0x28,0x94,0x02,
 0x0c,0x00,0x00,0x08,0x04,0x12,0xa8,0xaa,0x0a,0x21,0xa9,0xa4,0x00,0x00,0xa4,
 0x00,0x52,0x8d,0x80,0x28,0x29,0x45,0x54,0x55,0x20,0x90,0x20,0x45,0x48,0x92,
 0x00,0x24,0x24,0x49,0x29,0x25,0x11,0x29,0x95,0x48,0x44,0x24,0x51,0x92,0x14,
 0x25,0x11,0x09,0x44,0x91,0x12,0x49,0x49,0x92,0x08,0x51,0x02,0x85,0x48,0x24,
 0xa2,0x2a,0x0a,0xa4,0x92,0x24,0x20,0x09,0x89,0x44,0x15,0x81,0x02,0x49,0x12,
 0x52,0x00,0x51,0x48,0x43,0x22,0x49,0x22,0x20,0x40,0x22,0x95,0x24,0x08,0x01,
 0x00,0x92,0x24,0x10,0x92,0xa0,0x12,0x12,0x45,0x92,0x12,0x09,0x22,0x81,0x24,
 0x05,0x08,0x25,0x48,0x2a,0x90,0x54,0x22,0x52,0x92,0xa4,0x80,0x48,0x92,0x92,
 0x90,0x24,0x49,0xe2,0x88,0xa4,0x52,0x00,0x24,0x49,0x22,0x92,0x4a,0xa0,0x28,
 0x29,0x28,0x25,0x4b,0x58,0x12,0x90,0x12,0x09,0x08,0x0b,0x81,0x00,0x20,0x07,
 0xa8,0x28,0x82,0x40,0x01,0xa5,0x04,0x22,0x16,0x08,0x02,0x02,0x09,0x93,0x50,
 0x00,0x24,0x22,0x49,0x4a,0x02,0x01,0x05,0x40,0xc8,0xa6,0x80,0x28,0x79,0xa7,
 0x52,0x49,0x20,0xd1,0x5d,0x45,0x02,0x85,0x60,0x25,0x1c,0x49,0xd1,0x69,0x6b,
 0xeb,0x13,0x45,0x4f,0x5e,0x5c,0xff,0xf4,0x24,0x49,0xfe,0xa5,0x5a,0xa4,0x94,
 0xf4,0xf1,0x08,0x6e,0x04,0x85,0x41,0x97,0x42,0x15,0x42,0x48,0xa2,0x40,0x40,
 0x25,0x2a,0x05,0xa2,0x04,0x81,0x08,0x02,0x0a,0x00,0x90,0x00,0x46,0x29,0x28,
 0x49,0x20,0x00,0x82,0xa4,0x44,0x80,0x12,0x20,0x24,0x54,0xa0,0x24,0xa1,0x0a,
 0x2a,0x92,0xf4,0x0e,0xa4,0x34,0x48,0x74,0x0a,0x91,0xa8,0x28,0xe5,0x48,0x5d,
 0x94,0xe4,0xb5,0xb3,0x66,0xa6,0xa8,0x9d,0x93,0x37,0x3f,0x61,0x92,0x94,0x9c,
 0x09,0x9c,0x12,0x21,0xf1,0x2a,0xa0,0xd3,0x52,0xd2,0x19,0x43,0xb4,0x2a,0x10,
 0x52,0x09,0x12,0x11,0x81,0x40,0x50,0x0a,0x40,0x25,0x90,0x90,0x40,0x92,0x04,
 0x54,0x06,0x40,0x02,0x10,0x0a,0x49,0x28,0x00,0x94,0x14,0x86,0x04,0x81,0x00,
 0x0a,0x08,0x64,0x55,0x41,0x49,0x72,0x56,0x29,0xa4,0x12,0xb1,0x58,0x24,0x04,
 0x85,0x10,0x92,0x0c,0x31,0xca,0x79,0x36,0xb6,0x16,0x54,0x5c,0x3b,0x63,0xb5,
 0x6a,0x41,0x22,0x9e,0xa3,0x22,0x48,0x4a,0xc8,0x94,0x12,0x63,0x04,0x01,0xb2,
 0x97,0x42,0x15,0x42,0x24,0x21,0x00,0x85,0x94,0x04,0x21,0x20,0x0d,0x81,0x02,
 0x42,0x09,0x88,0x90,0x20,0x16,0x09,0x48,0x42,0xa0,0x01,0x41,0x95,0x24,0x40,
 0x0a,0x10,0x0a,0x92,0x21,0x41,0xa1,0x82,0x14,0x22,0xb9,0xcf,0x46,0xb9,0x20,
 0x3c,0x49,0xd1,0xf6,0x2c,0x75,0x08,0xed,0x9a,0xe8,0x9c,0xf7,0x7b,0xa6,0x42,
 0x9d,0xb9,0x3b,0x58,0xf4,0x39,0x4b,0xcd,0x45,0x4d,0xd7,0x9d,0xf2,0x2a,0x08,
 0x97,0x7b,0xf7,0x9c,0x3b,0x54,0x2a,0x14,0x09,0x04,0x44,0xe0,0x00,0x00,0x80,
 0x07,0x00,0x0f,0x20,0x08,0x80,0x00,0x00,0x00,0x06,0x80,0x00,0x00,0x00,0x21,
 0x00,0x00,0x1e,0x00,0x22,0x42,0x20,0x00,0x00,0x10,0x40,0x2d,0x42,0x49,0x3a,
 0x67,0xf7,0x7f,0x4f,0x9c,0x82,0xcf,0x8f,0xed,0x76,0xfe,0xee,0x7c,0xc4,0x38,
 0xe3,0x32,0x0f,0x29,0xd9,0xbb,0x73,0x95,0x62,0x73,0x27,0xfe,0xfa,0xae,0x9d,
 0x3b,0xc4,0x99,0x44,0x2f,0xe6,0xce,0xbe,0xb5,0x52,0x15,0x20,0x44,0x01,0x00,
 0xe0,0x03,0x00,0x40,0x08,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,
 0x00,0x00,0x00,0x01,0x00,0x00,0x21,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x60,
 0x13,0x29,0x91,0xf8,0x38,0x63,0x5b,0x0d,0x5d,0xe8,0xec,0xec,0xea,0x37,0x63,
 0xee,0x0e,0x71,0xd9,0xf7,0xb9,0xa7,0x84,0xce,0xb9,0xb5,0x2c,0xb2,0x6b,0x93,
 0x6e,0xd9,0xcd,0xae,0x99,0xd2,0x24,0x29,0x5e,0x6f,0xe7,0x8c,0x3b,0xa4,0x12,
 0x0a,0x01,0x04,0x00,0xe1,0x83,0x00,0x20,0x00,0x88,0x07,0x02,0x00,0x01,0x80,
 0x00,0x20,0x06,0x08,0x00,0xfe,0x07,0x01,0x40,0x80,0x60,0x00,0xca,0x0f,0x02,
 0x00,0x01,0x40,0x40,0x4d,0x84,0x24,0x3a,0x75,0xeb,0x98,0xa3,0x9c,0x72,0xdc,
 0x9e,0xd5,0x34,0xf7,0xd6,0x5c,0x64,0xb2,0x93,0xe3,0xf3,0x5f,0xd6,0xda,0x39,
 0x9d,0x34,0x63,0x4a,0xc7,0x3a,0xee,0xcc,0x5d,0xc8,0x97,0x84,0x3c,0xf7,0x6e,
 0xdd,0xb5,0xa9,0x2a,0xa0,0xb4,0x0a,0x00,0xe0,0x01,0x00,0x10,0x10,0x00,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x38,0x82,0x00,0x00,0x40,0x80,
 0x00,0x44,0x0b,0x00,0x00,0x00,0x00,0xa0,0x22,0x29,0x49,0x9d,0x98,0x73,0x5e,
 0x17,0x1d,0x79,0x6f,0x8d,0x65,0x3a,0x3b,0x6f,0x0d,0x79,0xc9,0x5d,0x97,0x6b,
 0x2f,0xe1,0xdc,0xbd,0x46,0xb8,0xeb,0x11,0xef,0x9d,0xf6,0xee,0x9a,0xd2,0x49,
 0x12,0xb9,0x6b,0x63,0xcd,0x19,0x52,0x15,0x14,0x08,0x01,0x00,0xe0,0x01,0x00,
 0x10,0x10,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0xe8,0x87,
 0x00,0x00,0x40,0x80,0x00,0xc4,0x0d,0x00,0x00,0x00,0x00,0x60,0x95,0x44,0x92,
 0x3c,0xba,0x3b,0x58,0x4e,0xbc,0x34,0x6e,0xa6,0xf7,0x58,0x56,0x67,0x56,0x72,
 0xe4,0x39,0xc3,0x85,0x80,0xda,0xdd,0x3a,0x52,0xba,0xe5,0x4a,0xc7,0x2d,0x67,
 0xce,0x2d,0xc9,0xa3,0xd4,0x34,0x37,0x77,0xce,0xbd,0xa4,0x14,0x42,0x51,0x2a,
 0x49,0xc9,0x92,0x90,0x34,0x39,0x49,0x57,0x92,0x44,0x49,0x92,0x94,0x24,0x2f,
 0x49,0x12,0x9a,0xa4,0x25,0x49,0xd2,0xa4,0x09,0x4d,0x92,0x92,0x24,0x25,0x49,
 0x42,0x4b,0x92,0x24,0x4d,0xd9,0x75,0xad,0x2c,0x59,0xb3,0x73,0xc7,0x73,0xba,
 0x0b,0xfb,0x4e,0xb4,0x72,0x94,0x6b,0x28,0xd5,0xcf,0x8c,0x4d,0x07,0xd9,0xea,
 0x24,0xeb,0x9c,0xee,0xd7,0x9c,0xd4,0xc8,0xa0,0xb2,0xb3,0xeb,0xd7,0x2e,0x52,
 0x15,0x10,0x94,0x04,0x00,0xc0,0x00,0x00,0x10,0x10,0x00,0x06,0x00,0x00,0x00,
 0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x80,0x00,0x00,0x40,0x80,0x00,0x04,0x00,
 0x00,0x00,0x00,0x00,0xa0,0x2a,0x29,0x55,0x3e,0xba,0x3b,0xdc,0x47,0xf0,0x69,
 0xe5,0x13,0x33,0x39,0xbe,0x63,0x1e,0x7d,0x19,0xe9,0x59,0x85,0xe0,0x2f,0x57,
 0x97,0x51,0xba,0x60,0x81,0x7f,0x2e,0xef,0xed,0x3e,0x89,0xd2,0xd5,0x5d,0x3b,
 0x77,0xee,0x9c,0x24,0x25,0x42,0x22,0x01,0x00,0xc0,0x00,0x00,0x20,0x00,0x00,
 0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
 0x40,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0xa0,0x4a,0x92,0x40,0x40,0x55,0x84,
 0x22,0x28,0x05,0x92,0x38,0x44,0x41,0xc4,0x3a,0x2a,0x21,0x40,0x2a,0x12,0x24,
 0x28,0x95,0x40,0x50,0x48,0x82,0x40,0x55,0x50,0x42,0x41,0x10,0x04,0x48,0x52,
 0x40,0x02,0x20,0x48,0x01,0x00,0x20,0xa9,0x2a,0x90,0x48,0x05,0x00,0x41,0x80,
 0x00,0x60,0x08,0x08,0x04,0x02,0x00,0x01,0x80,0x00,0x20,0x06,0x08,0x00,0x02,
 0x80,0x01,0x40,0x00,0x21,0x00,0x0c,0x00,0x02,0x00,0x01,0x40,0xa0,0xa5,0x24,
 0x95,0xaa,0x88,0x52,0x88,0x8a,0x50,0x49,0x32,0xb9,0x20,0x91,0x71,0x41,0x94,
 0xaa,0x84,0x24,0x49,0x45,0x48,0x24,0x8b,0x92,0x28,0x2d,0x2d,0x09,0x29,0x94,
 0x8a,0xa2,0x92,0x08,0x95,0x54,0x95,0x92,0xa8,0x5a,0x89,0x50,0x15,0x0a,0x12,
 0x0a,0x00,0x40,0x00,0x00,0x80,0x07,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
 0x06,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x1e,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x40,0x15,0x12,0x12,0x10,0x11,0x89,0x52,0x50,0x8a,0x24,0x39,0xb2,0x8a,
 0xa4,0x1a,0x14,0x11,0x10,0x52,0x82,0x24,0x89,0x22,0x49,0x24,0x25,0x51,0x90,
 0x5c,0x52,0x52,0x29,0x52,0x28,0x09,0xa5,0x24,0x92,0x20,0x49,0x02,0x01,0x21,
 0xaa,0x14,0xa0,0x48,0x01,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
 0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x00,0x00,0x00,0x00,0x00,0xa0,0xa6,0x48,0x49,0xa5,0x44,0x22,0x09,0x15,0x20,
 0x49,0x6a,0x49,0x20,0x10,0x8b,0x02,0xa4,0x4a,0x29,0x51,0x42,0x52,0x94,0x24,
 0x49,0x49,0x8a,0x4a,0x02,0x94,0x14,0x88,0x14,0x89,0x44,0x09,0x49,0x21,0x48,
 0x92,0x54,0x54,0x8a,0x90,0x2a,0x02,0x92,0x04,0x00,0x81,0x00,0x00,0x00,0x00,
 0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x02,0x01,0x00,
 0x00,0x00,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0xa0,0x4a,0x25,0x12,0x89,0x92,
 0x14,0x52,0xa0,0x48,0x04,0x04,0x92,0x8a,0xaa,0x50,0x54,0x11,0x21,0x42,0x0a,
 0x89,0x20,0x51,0x92,0x24,0x92,0x28,0x92,0x54,0x49,0xa1,0x52,0x42,0x24,0x11,
 0x52,0x20,0x94,0x20,0x09,0x22,0x91,0x10,0x52,0x25,0xa8,0x24,0x09,0x80,0x00,
 0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,
 0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x02,0x04,0x00,0x00,0x00,0x00,0x40,0x25,
 0x49,0x49,0x52,0x48,0x82,0x84,0x14,0x12,0x22,0xa9,0x44,0x40,0x00,0x0a,0x21,
 0x48,0x4a,0x29,0x41,0x52,0x4a,0x0a,0x24,0x89,0x20,0x45,0x49,0x02,0x2a,0x94,
 0x8a,0x94,0x92,0xa4,0x02,0x15,0x09,0x14,0x42,0x14,0x4a,0x44,0x51,0x15,0x02,
 0x92,0x00,0x80,0x01,0x81,0x00,0x20,0x00,0x08,0x01,0x03,0x00,0x01,0x80,0x04,
 0x20,0x06,0x08,0x00,0x02,0x01,0x01,0x40,0x00,0x20,0x00,0x0a,0x04,0x02,0x00,
 0x01,0x40,0x60,0x8b,0x94,0xa4,0x84,0x22,0xa9,0x28,0x42,0xa0,0x44,0x04,0x29,
 0x95,0x4a,0x28,0x8a,0x22,0x08,0x92,0x14,0x88,0x24,0x29,0x49,0x24,0x4a,0x88,
 0x24,0x91,0x44,0x49,0x54,0x22,0x49,0x12,0xa9,0x48,0xa4,0xa2,0x24,0x48,0x24,
 0x29,0xaa,0x14,0xa0,0x24,0x09,0x80,0x00,0x01,0x10,0x00,0x00,0x00,0x01,0x01,
 0x00,0x00,0x00,0x80,0x00,0x06,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
 0x02,0x04,0x00,0x00,0x00,0x00,0x40,0x55,0x22,0x11,0x52,0x94,0x04,0x45,0x51,
 0x09,0x29,0x51,0x84,0x44,0x20,0x82,0xa0,0x94,0xa2,0x24,0xa5,0x22,0x91,0x84,
 0x24,0x09,0x24,0x25,0x49,0x04,0x92,0x24,0x89,0x48,0x92,0x88,0x24,0xa2,0x82,
 0x00,0x11,0x05,0x42,0x84,0x90,0x2a,0x0a,0x48,0x02,0x80,0x00,0x01,0x00,0x00,
 0x00,0x00,0x01,0x01,0x00,0x00,0x01,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,
 0x08,0x00,0x00,0x00,0x02,0x04,0x00,0x00,0x00,0x00,0xa0,0x8a,0x94,0xa2,0x84,
 0x40,0xaa,0x08,0x02,0x20,0x82,0x04,0x12,0x11,0x4a,0x21,0x0a,0x41,0x08,0x11,
 0x10,0x4a,0x4a,0x52,0xd2,0xa2,0x92,0x98,0x24,0x91,0x28,0xd1,0x52,0x92,0x44,
 0x52,0x92,0x54,0x28,0x28,0x4a,0x52,0x94,0x12,0xaa,0x0a,0x90,0x92,0x08,0x00,
 0x81,0x80,0x00,0x20,0x00,0x08,0x82,0x02,0x00,0x01,0x80,0x00,0x20,0x06,0x08,
 0x10,0x02,0x02,0x01,0x40,0x00,0x20,0x00,0x0c,0x02,0x02,0x00,0x01,0x40,0x40,
 0x55,0x4a,0x14,0x51,0x15,0x22,0xa2,0xa4,0x44,0x29,0x89,0xa0,0xbf,0x24,0x08,
 0x50,0x2a,0xfd,0x45,0x45,0x91,0x10,0x8e,0xc0,0x49,0x44,0x5e,0x1e,0x3e,0x7d,
 0xea,0x14,0x4a,0xfe,0x85,0x24,0xe1,0xc2,0xf7,0x96,0x04,0x02,0x24,0xa1,0x2a,
 0x42,0x04,0x01,0x00,0x42,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x00,
 0x00,0x00,0x06,0x40,0x00,0x00,0x84,0x00,0x00,0x00,0x00,0x00,0x08,0x01,0x00,
 0x00,0x40,0x00,0x60,0x23,0x21,0x49,0x24,0xa2,0x94,0x08,0x02,0x01,0x4a,0x22,
 0x4a,0x73,0x92,0xa0,0x86,0x10,0x87,0x10,0x12,0x42,0xa2,0x26,0xd5,0x92,0x49,
 0xad,0x73,0x33,0x9a,0xe4,0xa0,0x88,0x9c,0x49,0x92,0x74,0x8a,0x23,0x4e,0x92,
 0xa8,0x08,0x2a,0x15,0x10,0x61,0x0a,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x38,
 0x00,0x02,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,
 0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x40,0x95,0x14,0x92,0x12,0x95,0x22,0x55,
 0xa9,0xa0,0x10,0x89,0x90,0x77,0x00,0x12,0x53,0x8a,0x83,0x84,0x88,0x94,0x14,
 0x92,0xc8,0x24,0x23,0x8e,0xb3,0xeb,0x3c,0x69,0x15,0x22,0xac,0x27,0x49,0x62,
 0xc1,0x11,0x01,0x44,0x44,0xa2,0x50,0x25,0x42,0x94,0x20,0x49,0x49,0x92,0x90,
 0x24,0x29,0x49,0x52,0x92,0x44,0x49,0x92,0x94,0x24,0x2f,0x49,0x12,0x92,0x24,
 0x25,0x49,0x92,0x24,0x09,0x49,0x92,0x92,0x26,0x25,0x49,0xa2,0x26,0x29,0x44,
 0xa4,0x10,0x8a,0x48,0x04,0x08,0x02,0x12,0xc5,0x71,0xbd,0xa0,0x89,0xa4,0x53,
 0x21,0x76,0x4a,0xc9,0x25,0xf1,0xcf,0x89,0xae,0xf5,0x31,0x4d,0xf2,0x7b,0x4b,
 0xdd,0xb1,0x35,0x75,0xd4,0x8d,0x76,0x8b,0x92,0x00,0x52,0x29,0x14,0x21,0x0a,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x60,0x55,0x85,0x12,0x11,0x45,0x21,0x92,0xa2,0x02,0xa9,0xa4,0x90,0x77,0x36,
 0xdf,0xf7,0xc2,0x01,0x78,0xed,0xcc,0x7e,0xeb,0x67,0xed,0x53,0xae,0xb9,0xfb,
 0x9c,0xea,0x66,0x13,0xce,0xdd,0x39,0x73,0xc9,0x07,0x67,0xa7,0x3f,0xaa,0x48,
 0x15,0x40,0x44,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x40,0x25,0x52,0x24,0xa2,0x88,0x54,0x24,0x14,0xa1,0x04,
 0x09,0x8a,0x0d,0x73,0xb6,0x99,0xe8,0x49,0xcf,0xce,0xdd,0x66,0x33,0xf7,0xce,
 0x84,0xc6,0xb9,0x39,0x2d,0x70,0x76,0x4b,0x3f,0xaa,0xdd,0x35,0xd2,0xa3,0xeb,
 0xee,0x0c,0x24,0x52,0x15,0x15,0x29,0xaa,0xde,0xaa,0x76,0xff,0xbf,0xef,0xdf,
 0xaa,0xfa,0xfb,0xff,0xff,0xff,0x7e,0xa9,0x7f,0xbb,0xdf,0xaa,0xf6,0xef,0xff,
 0x6d,0xef,0xaa,0x6a,0xff,0xf6,0xbf,0xff,0xb7,0x4a,0x95,0x92,0x14,0x2a,0x25,
 0x89,0xa2,0x10,0x49,0x40,0xc1,0xa1,0x3b,0xcb,0x31,0xc2,0x11,0xc6,0xee,0xdc,
 0x9c,0x77,0x67,0xed,0x29,0x17,0x3f,0x7f,0x5e,0x35,0xcf,0x22,0x4e,0xdd,0x99,
 0x73,0xe5,0x2e,0x73,0x67,0x0e,0x89,0xa8,0x2a,0x40,0x90,0x24,0xa9,0xaa,0xaa,
 0x10,0xa9,0x14,0x54,0x55,0x0b,0x25,0x12,0x49,0x48,0xa1,0xb6,0xa0,0xaa,0xa8,
 0xaa,0x8a,0x14,0x41,0x55,0x99,0xaa,0x56,0x91,0x15,0x51,0x22,0xd5,0x96,0x48,
 0x24,0x49,0xa1,0x90,0x54,0x4a,0x42,0x90,0x0a,0xca,0x95,0xb5,0xe3,0x78,0xc9,
 0x40,0xe3,0xe6,0x58,0x46,0xb9,0x79,0x67,0x52,0x47,0x9c,0x9c,0x8e,0xba,0xe6,
 0x94,0x87,0xce,0xdc,0x99,0xe8,0x8e,0x2b,0x67,0x57,0x24,0x92,0x14,0x14,0x24,
 0x49,0x56,0x6d,0x55,0xd7,0x56,0xeb,0xab,0xda,0xea,0xaa,0x6d,0xb5,0xab,0xae,
 0xaa,0xbe,0xaa,0x56,0xb5,0xb5,0x6a,0xbd,0xaa,0xd6,0xaa,0x5a,0xad,0x6a,0xdd,
 0x5a,0x55,0x25,0x25,0x92,0x44,0x14,0x24,0x12,0x11,0x91,0x26,0xa4,0xe0,0x81,
 0x5b,0xcb,0x64,0xc0,0x13,0xeb,0x66,0x5a,0xa7,0xc5,0x72,0x6e,0x09,0x2b,0x4e,
 0x2e,0xa6,0x58,0xeb,0x4a,0x56,0x66,0xcd,0x3a,0x65,0xad,0x73,0x53,0x09,0x11,
 0x51,0x15,0xa0,0x92,0x24,0xb5,0x55,0xab,0xaa,0xaa,0x2a,0xd5,0xaa,0xaa,0x56,
 0xd5,0xaa,0x56,0xd5,0xaa,0xa2,0x55,0xb5,0xad,0x6a,0xd5,0xaa,0xb6,0xaa,0x56,
 0xd5,0x6a,0xd5,0x52,0xd5,0xaa,0x4a,0x94,0xa4,0x92,0x40,0x91,0x48,0xa4,0x44,
 0x48,0x89,0xea,0xac,0xbd,0xd3,0x65,0x95,0x65,0x33,0xb7,0x38,0x97,0x3b,0x39,
 0xeb,0xa4,0x43,0x97,0x47,0x97,0xba,0xc5,0x50,0x27,0xf7,0xfd,0x5d,0xf8,0x9c,
 0x3d,0xef,0xa0,0x44,0xaa,0x2a,0x0a,0x24,0x91,0x54,0x55,0xd5,0x5a,0x55,0xd5,
 0xaa,0x56,0xad,0x6a,0x55,0x55,0xa9,0xb5,0x56,0x5d,0x6d,0xab,0xaa,0x56,0x5b,
 0x55,0xd5,0xaa,0xaa,0x55,0xab,0x5a,0xad,0x56,0x6d,0x15,0xa2,0x52,0x48,0x2a,
 0x25,0x45,0x29,0x92,0x92,0x20,0xe0,0x83,0xbb,0xe1,0x7c,0x40,0x3f,0x5e,0x5e,
 0x5a,0xc7,0xf3,0x73,0xe7,0xd2,0xaf,0x43,0xa9,0x5f,0xb8,0xd2,0xa5,0x4f,0xee,
 0xdc,0x79,0xf5,0xbe,0x5b,0xe7,0x17,0x12,0xa1,0x12,0x20,0x91,0x44,0x25,0x12,
 0x2a,0x21,0x49,0x22,0x24,0x11,0x92,0x04,0x09,0x91,0x24,0x02,0xa9,0x00,0x80,
 0x10,0x01,0x01,0x00,0x21,0x02,0x91,0x10,0x20,0x10,0x22,0x91,0x48,0x92,0xa4,
 0x14,0x8a,0x52,0x11,0x92,0x08,0x45,0x41,0x22,0x55,0x15,0x28,0x45,0x05,0x81,
 0x2a,0x80,0x80,0x03,0x19,0x10,0xd9,0x05,0x09,0x08,0x20,0xa8,0x44,0x20,0x01,
 0x6a,0x94,0x90,0x14,0x05,0x02,0x02,0x81,0x20,0x51,0xa7,0x48,0x2a,0x15,0x4a,
 0x24,0x29,0x48,0x89,0x42,0x54,0xa4,0x14,0x49,0x84,0x24,0x51,0xa4,0x22,0x91,
 0x48,0x02,0xa5,0x2a,0x8a,0xa8,0xa8,0xaa,0x94,0xa0,0x24,0xa5,0x0a,0xa5,0x14,
 0x4a,0x24,0x21,0x02,0x4a,0x51,0x24,0x4a,0x49,0x52,0xa9,0x28,0x4a,0x48,0xa0,
 0x42,0x28,0x50,0x24,0x04,0x25,0x2a,0xa7,0x4d,0x85,0x2c,0x53,0x42,0x45,0x55,
 0x15,0x29,0x95,0xa4,0x2c,0x22,0x4a,0xa2,0x50,0x51,0xb5,0x28,0x55,0x98,0x16,
 0x82,0xa4,0x2a,0x00,0x49,0x44,0x25,0x25,0x94,0x92,0x92,0x22,0x22,0x51,0x49,
 0x44,0x11,0x90,0x20,0x01,0x54,0x10,0x90,0x24,0x05,0x42,0x00,0x21,0x0d,0x49,
 0x10,0xa4,0x14,0x51,0x91,0x92,0x4a,0xa9,0x10,0x85,0x92,0x20,0x04,0x01,0x02,
 0xa2,0x08,0x20,0x05,0x04,0x45,0x05,0x49,0xa9,0x88,0xc0,0x91,0x23,0x52,0x9a,
 0x01,0x94,0x52,0x02,0x51,0x44,0x52,0x92,0x9a,0x4a,0x91,0x08,0x45,0x82,0x08,
 0x45,0x02,0x31,0x4b,0x09,0x52,0x15,0x54,0x10,0x29,0x91,0x88,0x42,0xa4,0x48,
 0x90,0x14,0x0a,0x92,0x12,0x4a,0x42,0x48,0x54,0x21,0x45,0x25,0x49,0x42,0x29,
 0x54,0x4a,0xa2,0x24,0x45,0x49,0x42,0x0a,0x4a,0x44,0x50,0x04,0xa5,0x68,0x24,
 0x95,0xa2,0xa8,0xa8,0x09,0x52,0x49,0x50,0xa1,0xa0,0xa0,0x10,0x22,0x05,0x95,
 0x0e,0x94,0x08,0xe9,0xaa,0x42,0x94,0x54,0x0a,0x22,0x09,0x05,0x41,0x24,0x4a,
 0x92,0x10,0x54,0xc4,0x20,0x54,0x60,0x21,0xa0,0xa8,0x12,0x02,0xa5,0x24,0x2a,
 0x05,0x88,0x92,0x22,0x25,0x41,0x51,0x48,0x22,0x91,0x00,0x91,0x08,0x92,0x28,
 0x41,0x20,0x29,0x44,0x09,0x91,0x08,0x49,0x12,0x02,0x29,0x51,0x91,0x2a,0x25,
 0x91,0x00,0x85,0x92,0x48,0x08,0x05,0x25,0x52,0x09,0x00,0x25,0x0a,0x0a,0x15,
 0x45,0x89,0xa8,0x20,0xa0,0x20,0xa5,0x04,0x44,0x14,0x41,0xa2,0x50,0x95,0x54,
 0x22,0x94,0x52,0x91,0x24,0xa5,0x00,0x29,0x95,0x82,0x00,0x94,0x0a,0x51,0x15,
 0xa0,0x08,0x49,0x41,0xa2,0x22,0x24,0x49,0x49,0x2a,0x24,0x12,0x49,0x44,0xa4,
 0x20,0xa2,0x00,0x82,0x94,0x0a,0x8a,0x22,0x52,0x24,0x55,0x92,0xa4,0xa8,0x88,
 0xa4,0x24,0x91,0x54,0x25,0xa8,0xa8,0x48,0x12,0xa5,0xa8,0x48,0x09,0xa2,0x52,
 0x08,0xa1,0x50,0x40,0x49,0x22,0x25,0x94,0x2a,0x4a,0x49,0xa8,0x12,0xa1,0x94,
 0x14,0x15,0x21,0x49,0x91,0x40,0x48,0x4a,0x92,0x88,0x5a,0x42,0x82,0x28,0x52,
 0x41,0x44,0x50,0x2a,0x0a,0x52,0x92,0xaa,0x14,0x80,0x88,0x14,0x24,0x41,0x91,
 0x44,0x12,0x11,0x01,0x95,0x04,0xa9,0x28,0x49,0x52,0x11,0x49,0x41,0x81,0x20,
 0x48,0x12,0x41,0x52,0x12,0x92,0x24,0x81,0x94,0x00,0x45,0x22,0x21,0x10,0x41,
 0x22,0xa4,0x08,0x01,0x50,0x0a,0x80,0x2a,0x92,0x14,0x48,0x49,0x40,0x02,0x24,
 0x41,0x24,0x0a,0x11,0x22,0xa4,0x54,0x92,0x14,0x02,0x25,0x91,0x48,0x20,0x42,
 0x14,0x29,0x41,0x01,0x14,0x11,0x92,0x0a,0x90,0x88,0x44,0x08,0x49,0x22,0x52,
 0x82,0x42,0x24,0x04,0x51,0x44,0x4a,0x52,0x00,0x51,0x02,0x44,0x92,0x24,0x44,
 0x24,0x14,0x2a,0x4a,0x85,0x44,0x2a,0x89,0x88,0x44,0x90,0x54,0x02,0xa4,0x28,
 0x49,0x4a,0x45,0x2a,0x11,0x09,0x44,0x50,0x8a,0xa0,0x4a,0x90,0x24,0x82,0x22,
 0x12,0x95,0xa8,0x12,0x2a,0x49,0x41,0xca,0x88,0x12,0x88,0x44,0x8a,0x40,0x91,
 0x24,0x92,0x4a,0x91,0x42,0x08,0x2a,0xa8,0x44,0xa4,0x50,0x29,0x42,0x22,0x52,
 0x25,0x12,0x89,0x84,0x54,0x14,0x91,0x52,0x84,0x90,0x20,0x00,0x29,0x8a,0xa8,
 0x92,0x24,0x92,0xa8,0x48,0x22,0x48,0x11,0x10,0x92,0x40,0x22,0x22,0x89,0x2a,
 0x25,0x99,0x10,0x42,0x12,0x10,0x28,0x41,0x44,0xa4,0x12,0x01,0x11,0x15,0x20,
 0x45,0x92,0x54,0x4a,0xa4,0x40,0x22,0x49,0x81,0x24,0xaa,0x10,0x25,0xa1,0x52,
 0x92,0x28,0x14,0x22,0x49,0x04,0x10,0x22,0x94,0x52,0x80,0x00,0x28,0x09,0xa5,
 0x2a,0x10,0xa8,0x28,0xa9,0xa9,0xa0,0x52,0x2a,0x49,0x4a,0xaa,0x52,0x55,0x4a,
 0xa5,0x54,0x25,0x45,0x54,0x49,0x49,0x25,0x25,0x49,0x53,0xaa,0xaa,0x54,0xad,
 0x54,0x55,0x52,0x44,0x92,0x24,0x49,0xa9,0xaa,0xa6,0x85,0x2a,0x55,0xa9,0xa4,
 0x50,0x4a,0x89,0x4a,0x52,0x49,0x25,0xa5,0x4a,0x2a,0x4a,0x52,0x2a,0xa9,0x24,
 0xa5,0xa8,0x14,0x95,0x54,0x45,0x49,0x95,0x94,0xaa,0x4a,0x55,0x49,0x49,0x55,
 0xa2,0x8a,0x52,0x51,0x15,0x42,0x55,0xd7,0x56,0x55,0x5f,0xad,0xd5,0xb6,0xb5,
 0x55,0xad,0xd6,0xad,0x5a,0xab,0xda,0xda,0x55,0x5b,0xab,0xd6,0xb6,0xb6,0x56,
 0xd5,0xd6,0xaa,0x5a,0xab,0xaa,0xad,0xbb,0x6d,0xdb,0xb6,0xad,0xaa,0x5a,0xbd,
 0xda,0xda,0x56,0x5b,0xaf,0xb5,0x76,0xdb,0xae,0xb6,0xda,0x5a,0xb5,0xed,0xba,
 0xad,0xb5,0xd6,0xda,0x56,0x57,0xdb,0x6a,0xab,0x5a,0xbb,0x6a,0x6b,0xb5,0xb5,
 0xaa,0xb6,0xb6,0xb6,0x5d,0x75,0xad,0xae,0x2a,0x14,0xda,0xaa,0x6a,0x6d,0xa5,
 0xd6,0xaa,0xaa,0xaa,0xda,0xb6,0x55,0x6a,0xab,0xaa,0x55,0x55,0xb6,0x6a,0x6d,
 0xb5,0x5a,0xab,0x59,0x5b,0x55,0x6d,0x55,0xb5,0x6d,0xb5,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0x55,0x55,0xad,0xaa,0xaa,0xaa,0x6a,0xd5,0xaa,0xaa,0xb2,0x55,0x55,
 0x55,0xab,0x2a,0xab,0xaa,0xaa,0x55,0xad,0xda,0xaa,0x6a,0x55,0xb5,0xb6,0xca,
 0xb6,0xaa,0xaa,0xda,0xb6,0x55,0x55,0x5b,0x55,0xab,0x56,0x53,0x15,0xa0,0x56,
 0xb5,0x5a,0xab,0xda,0x5a,0x5b,0x6b,0x6d,0x55,0x55,0xad,0x55,0xb5,0x6d,0xad,
 0xad,0xd5,0x56,0xd5,0xaa,0xd5,0x5a,0xd7,0xaa,0x6d,0xab,0xb5,0xad,0xaa,0x6a,
 0x55,0xb5,0xb5,0x6a,0xdb,0xb6,0xb6,0xd5,0x6a,0xab,0xb5,0xb5,0x55,0xab,0xd6,
 0x56,0xad,0xda,0xb6,0xb6,0x56,0xb5,0xaa,0x5a,0x6d,0x6d,0xab,0xaa,0xda,0x56,
 0xdb,0xaa,0x55,0xb5,0xaa,0xad,0x6d,0xab,0xaa,0xda,0xaa,0xaa,0x6a,0xad,0xda,
 0x2a,0x29,0x8a,0xaa,0xd6,0x56,0xd5,0x56,0xab,0xaa,0xb5,0x56,0x6b,0x6b,0xd5,
 0xb6,0xad,0xaa,0x6a,0xd5,0x5a,0x55,0xab,0xb6,0xaa,0xaa,0x54,0x6d,0x55,0xb5,
 0x56,0x55,0xb5,0xad,0xb6,0xad,0x5a,0x5b,0x55,0xab,0xaa,0xaa,0x56,0xb5,0x5a,
 0xad,0xaa,0xda,0xaa,0xda,0x56,0xad,0xaa,0xd5,0x6a,0xdb,0xd6,0xd6,0x56,0x55,
 0xd5,0x56,0xab,0xaa,0xaa,0xb6,0x6a,0x5b,0xad,0x6a,0x55,0x55,0x5b,0xad,0xb6,
 0xd5,0xb6,0xaa,0x55,0x5d,0x15,0xa0,0xb5,0x55,0xb5,0xb6,0x5a,0xb5,0xb6,0xaa,
 0x55,0xad,0x5a,0x5b,0x55,0x55,0xd5,0x56,0x5b,0x55,0x6d,0xad,0x55,0x5b,0x6b,
 0x6b,0x55,0xab,0x55,0xad,0x6a,0xab,0xaa,0x55,0x6b,0xab,0xaa,0xaa,0xda,0x5a,
 0x5b,0xb5,0x56,0xab,0x6a,0x6d,0x55,0x6d,0x55,0xb5,0x55,0xab,0xaa,0x5a,0x55,
 0xad,0xaa,0xaa,0xad,0xb6,0xda,0x5a,0x6d,0xad,0xaa,0x56,0xd5,0x6a,0x55,0xab,
 0xb6,0x6a,0xab,0x55,0xad,0xaa,0xb5,0xaa,0x6a,0x15,0xaa,0x5a,0xb5,0xaa,0x55,
 0xd5,0xaa,0x55,0xad,0xda,0xaa,0xaa,0x55,0xad,0xb6,0x6d,0xb5,0x6a,0xad,0x55,
 0xb5,0xda,0xaa,0xb5,0xb5,0x56,0x6d,0xad,0xd5,0xb6,0xda,0xb6,0xaa,0xaa,0xaa,
 0xad,0x6d,0x55,0xab,0xd5,0xd6,0xda,0x6a,0xab,0xb6,0xb6,0x56,0xab,0x55,0xd5,
 0xda,0x5a,0xab,0xaa,0x6a,0x6d,0x6b,0xb5,0x55,0xab,0x6a,0xab,0xb5,0xad,0xb5,
 0x56,0xab,0x6d,0xb5,0x55,0x55,0xb5,0xda,0x6a,0xad,0xda,0xb6,0x55,0x25,0x50,
 0xd5,0xd6,0x56,0xad,0xad,0xad,0x6a,0x6b,0x55,0xdb,0x56,0xb5,0xb5,0x55,0xab,
 0x6a,0x55,0x6b,0xad,0x55,0x55,0xb5,0xaa,0xaa,0xb5,0xaa,0x5a,0xb5,0xaa,0x55,
 0x55,0xdd,0x5a,0x6d,0xb5,0xda,0x56,0xb5,0xb6,0xaa,0xaa,0x56,0xad,0xa9,0xd5,
 0xaa,0xb6,0xb6,0xb6,0xaa,0xb5,0xd6,0x6d,0xab,0x55,0xad,0xaa,0xaa,0x5a,0xab,
 0x5a,0xab,0x5a,0xd5,0x5a,0xad,0xaa,0x56,0x6d,0xdb,0xaa,0xaa,0xd5,0x6a,0xab,
 0x6a,0xab,0x15,0xda,0x56,0x55,0xb5,0xd5,0xaa,0x6a,0x5b,0x55,0xab,0xaa,0x6a,
 0xad,0xaa,0x6a,0xb5,0x56,0x5b,0x55,0xd5,0x6a,0x6b,0xad,0x5a,0xad,0xaa,0xb5,
 0xd5,0x56,0x5b,0xad,0xda,0x56,0x6b,0xab,0x56,0xab,0xda,0x5a,0x55,0xb5,0xd6,
 0xaa,0xb5,0xae,0xaa,0x6a,0x55,0x55,0xab,0x56,0xad,0x59,0x55,0xb5,0xaa,0xd5,
 0x56,0xdb,0x6a,0xb5,0x55,0x55,0xd5,0x5a,0xab,0xd5,0xd6,0xda,0xaa,0xaa,0xd6,
 0x56,0xad,0x56,0x55,0xad,0xda,0x2a,0x54,0xad,0xda,0xaa,0x5a,0xb5,0x56,0xd5,
 0x5a,0x6d,0xb5,0xad,0x6a,0x6d,0xad,0xaa,0xad,0x6a,0xad,0xb5,0x56,0xad,0xd5,
 0xd6,0x5a,0x6d,0xad,0x56,0xd5,0x6a,0xb5,0x55,0x55,0x55,0x55,0xb5,0xaa,0xaa,
 0xd5,0x6a,0xab,0xb5,0xb6,0xaa,0x6a,0x6d,0xdb,0x6a,0x6b,0xd5,0x5a,0x55,0x57,
 0xdb,0xaa,0x6d,0xb5,0xda,0xaa,0xd5,0x56,0x6b,0x6d,0xab,0x55,0xb5,0x5a,0xad,
 0xaa,0xd5,0x56,0xad,0x5a,0xb5,0xda,0xb6,0x55,0x55,0x15,0xaa,0xd5,0x56,0xdb,
 0x56,0x5b,0xb5,0x5a,0xad,0xb5,0x56,0xd5,0x56,0xab,0x55,0x5b,0xd5,0x56,0x6b,
 0xad,0xda,0xaa,0x6a,0x55,0xd5,0x56,0x55,0xb5,0x5a,0x55,0xab,0xaa,0xb5,0xad,
 0x6d,0xab,0xb5,0xad,0x56,0xad,0x5a,0x55,0x55,0xad,0x55,0xab,0xaa,0xb6,0x5a,
 0xb5,0x6a,0x6b,0xa9,0xaa,0xb6,0xaa,0x5a,0x55,0xb5,0x5a,0x55,0xb5,0xaa,0x5a,
 0x6d,0xad,0x56,0xd5,0x56,0x6d,0xb5,0xb5,0xd5,0x56,0xab,0xaa,0xda,0xb6,0x1a};

icon_struct	letters_ic = { letters_width, letters_height, 
			      (char*)letters_bits };
icon_struct	spl_bckgnd_ic = { spl_bckgnd_width, spl_bckgnd_height, 
			      (char*)spl_bckgnd_bits };
