/* $Id: smtp_auth.h,v 1.8 2001/11/18 00:23:55 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 2001 Duncan Haldane <duncan_haldane@users.sourceforge.net>*
 *               (C) 2001 by the Archimedes Project                            *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

/*
  headers for smtp_auth.c
*/

/* in smtp.c */
void  get_smtp_password ( char * , int );
void  get_smtp_username ( char * , int  );
void  ask_smtp_password( char * , char * , char * , int );

/*
  smtp_authenticate
  the authentication dialog function   called in smtp,c 
  Returns 0 if authentication was successful, -1 otherwise,
  char * is a pointer to the AUTH EHLO keyword list  sent by
  the server.
*/
int smtp_authenticate( char * , char *, char *);


#ifdef _SMTP_AUTH_C_


/*
  the size limits for authentication-id, authorization-id and
  password must each be at least 255 per RFC 2595.  All three limits
  are here set by MAX_AUTH_WORD_LEN.
*/
#define MAX_AUTH_WORD_LEN 255

/*
 the size of the reponse buffer must be large enough for the
responses of any supported SASL protocol:
PLAIN requires AUTH_RESPONSE_BUFSIZE > 4*((MAX_AUTH_WORD_LEN + 3)/3) + 12
*/
#define AUTH_RESPONSE_BUFSIZE 4096

/*  
	CLIENT_AUTH_LIST is a list of authentication mechanisms
	currently supported by this client, and CLIENT_AUTH_LIST_LEN 
	is the size of a char[] that can contain it.
	The space-separated list should  start with the most secure
	mechanisms, ending with PLAIN and LOGIN.
	Add to the list as support for new authentication mechanisms is added.
*/
#define CLIENT_AUTH_LIST_LEN 255
#define CLIENT_AUTH_LIST "CRAM-MD5 PLAIN LOGIN"

/* headers for client-supported authentication mechanism modules */
int smtp_auth_PLAIN ( char * , char * , int );
int smtp_auth_LOGIN ( char * , char * , int );
int smtp_auth_CRAM_MD5( char * , char * , int );


/*
  maximum number of repeat authentication attempts in case of
  "temporary server failure" response.
*/
#define MAX_AUTH_ATTEMPTS 10


/*
  get_next_item
  is a utility to extract items from a space-separated list.
  Arguments:
  first char * pointer to list
  second char * ponter to a char[]  , sizeof(char) = n
  int :  maximum strlen  of item to extract ( must be than n)
  Return value:  pointer to the shorter list with first item removed,
  or NULL if that list is empty.
*/
char * get_next_item (char * , char *, int );




/* 
   get_client_auth_list 
  first char* points to a space-separated list of the authentication
  mechanisms supported by the client,
  second char * points to a list of mechanisms advertised by the
  server,  It is used to order the client-supported mechanisms
  according to the preference reported by the server.  
*/
void  get_client_auth_list( char * , char *);


/*
  smtp_auth_response 
  Arguments:
	first char  *: pointer to challenge obtained from server.
	second char *: pointer to name of authentication mechanism.
	third  char *: pointer to buffer which will contain the response.
	int          : sizeof(response string buffer)
	if the challenge string pointer is NULL, the client string that initiates
  the authentication dialog is provided.
  Return values:
   0:  successfully created a response string,
  -1:  client does not support the requested authentication mechanism
  -2:  response string could not  be created.
  -3:  buffer was too small for the required response string.
*/
int smtp_auth_response ( char *  , char * , char *, const int );

/* 
   smtp_auth_dialog
   This is in smtp.c; allows dialog with the server:
   char *   :   client_to_server string:
   char * * :   address of pointer to  reply string from server:
   return value: ESMTP response code from server.
*/
int smtp_auth_dialog( char *  ,  char * *  );

#endif

