/* $Id: rep_fwd.cpp,v 1.12 2004/01/02 04:05:36 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

static FD_config_reply *reply_obj;

void Reply_Call(FL_OBJECT * obj, long param) {
}

void reply_conf(int set_default, FD_config_reply * form) {
	reply_obj = form;

	fl_clear_choice(reply_obj->Reply_INType);
	fl_addto_choice(reply_obj->Reply_INType, "no auto include");
	fl_addto_choice(reply_obj->Reply_INType, "indented");
	fl_addto_choice(reply_obj->Reply_INType, "not indented");
	fl_set_choice(reply_obj->Reply_INType,
				  Config.getIntDefault("include", 2, set_default));
	fl_clear_choice(reply_obj->Reply_MIME);
	fl_addto_choice(reply_obj->Reply_MIME, "never");
	fl_addto_choice(reply_obj->Reply_MIME, "always");
	fl_addto_choice(reply_obj->Reply_MIME, "ask");
	fl_set_choice(reply_obj->Reply_MIME,
				  Config.getIntDefault("inclmime", 3, set_default));
	fl_clear_choice(reply_obj->Reply_All);
	fl_addto_choice(reply_obj->Reply_All, "never");
	fl_addto_choice(reply_obj->Reply_All, "always");
	fl_addto_choice(reply_obj->Reply_All, "ask");
	fl_set_choice(reply_obj->Reply_All,
				  Config.getIntDefault("inclrecp", 3, set_default));
	fl_set_input(reply_obj->Reply_Prefix, Config.get("prefix", ">", set_default).c_str());
	fl_set_input(reply_obj->Reply_RePrefix, Config.get("reprefix", "RE:", set_default).c_str());
	fl_set_input(reply_obj->Reply_FwdPrefix, Config.get("fwdprefix", "FWD:", set_default).c_str());
	fl_set_input(reply_obj->Reply_Str, Config.get("replystr", "On %d %f wrote:%n", set_default).c_str());
	fl_set_input(reply_obj->Reply_And, Config.get("replyexand", "", set_default).c_str());
	fl_set_button(reply_obj->Reply_Exclude, Config.getIntDefault("replyex", 1, set_default));
	fl_set_input(reply_obj->Forward_Str, Config.get("fwdstr", "-----Fwd: %i-----%n%n",
										 set_default).c_str());
	fl_set_button(reply_obj->Reply_Charset,
				  Config.getIntDefault("replykeepchset", 0, set_default));
	fl_set_button(reply_obj->Reply_Keep,
				  Config.getIntDefault("replykeep", 0, set_default));
	fl_set_button(reply_obj->Reply_Save,
				  Config.getIntDefault("replysave", 0, set_default));
	fl_clear_choice(reply_obj->Forward_INType);
	fl_addto_choice(reply_obj->Forward_INType, "do not include");
	fl_addto_choice(reply_obj->Forward_INType, "short");
	fl_addto_choice(reply_obj->Forward_INType, "full");
	fl_addto_choice(reply_obj->Forward_INType, "MIME");
	fl_set_choice(reply_obj->Forward_INType,
				  Config.getIntDefault("fwdinclude", 2, set_default));
}
void handle_reply_input(FD_config_reply * form) {
	reply_obj = form;
	Config.set("prefix", (char *) fl_get_input(reply_obj->Reply_Prefix));
	Config.set("reprefix", (char *) fl_get_input(reply_obj->Reply_RePrefix));
	Config.set("fwdprefix", (char *) fl_get_input(reply_obj->Reply_FwdPrefix));
	Config.set("replystr", (char *) fl_get_input(reply_obj->Reply_Str));
	Config.set("fwdstr", (char *) fl_get_input(reply_obj->Forward_Str));
	Config.set("include", fl_get_choice(reply_obj->Reply_INType));
	Config.set("inclmime", fl_get_choice(reply_obj->Reply_MIME));
	/* fprintf(stderr,"get_choice of inclrecp: %i\n",fl_get_choice(reply_obj->Reply_All)); */
	Config.set("inclrecp", fl_get_choice(reply_obj->Reply_All));
	Config.set("fwdinclude", fl_get_choice(reply_obj->Forward_INType));
	Config.set("replyex", fl_get_button(reply_obj->Reply_Exclude));
	Config.set("replyexand", (char *) fl_get_input(reply_obj->Reply_And));
	Config.set("replykeepchset", fl_get_button(reply_obj->Reply_Charset));
	Config.set("replykeep", fl_get_button(reply_obj->Reply_Keep));
	Config.set("replysave", fl_get_button(reply_obj->Reply_Save));
}
