/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_REMOTE_H__
#define __XFMEDIA_REMOTE_H__

#include <glib.h>

struct _XfMediaMainwin;

G_BEGIN_DECLS

#define XFMEDIA_REMOTE_IS_RUNNING     "Ping"
#define XFMEDIA_REMOTE_CLEAR_PLAYLIST "ClearPlaylist"
#define XFMEDIA_REMOTE_LOAD_PLAYLIST  "LoadPlaylist"
#define XFMEDIA_REMOTE_SAVE_PLAYLIST  "SavePlaylist"
#define XFMEDIA_REMOTE_ADD_FILE       "AddFile"
#define XFMEDIA_REMOTE_REMOVE_FILE    "RemoveFile"
#define XFMEDIA_REMOTE_PLAY           "Play"
#define XFMEDIA_REMOTE_PAUSE          "Pause"
#define XFMEDIA_REMOTE_STOP           "Stop"
#define XFMEDIA_REMOTE_PREV           "Prev"
#define XFMEDIA_REMOTE_NEXT           "Next"
#define XFMEDIA_REMOTE_QUIT           "Quit"

typedef enum {
    XFMEDIA_REMOTE_UNKNOWN_ERROR     = -6,
	XFMEDIA_REMOTE_NO_SESSION_BUS    = -5,
	XFMEDIA_REMOTE_NO_INSTANCE       = -4,
    XFMEDIA_REMOTE_BAD_ARGUMENTS     = -3,
	XFMEDIA_REMOTE_BAD_COMMAND       = -2,
	XFMEDIA_REMOTE_COMMAND_FAILED    = -1,
	XFMEDIA_REMOTE_COMMAND_SUCCEEDED =  0
} XfMediaRemoteStatus;

gint xfmedia_remote_init(struct _XfMediaMainwin *mwin);
void xfmedia_remote_cleanup(struct _XfMediaMainwin *mwin);

XfMediaRemoteStatus xfmedia_remote_send_command(gint session_id, const gchar *command, ...);

G_END_DECLS

#endif
