/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__PLAYLIST_H_
#define _XFMEDIA__PLAYLIST_H_

#include <glib.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>

G_BEGIN_DECLS

typedef enum
{
    XFMEDIA_PLAYLIST_SORT_TITLE = 0,
    XFMEDIA_PLAYLIST_SORT_FILENAME,
    XFMEDIA_PLAYLIST_SORT_RANDOM
} XfMediaPlaylistSortType;

#define XFMEDIA_TYPE_PLAYLIST         (xfmedia_playlist_get_type())
#define XFMEDIA_PLAYLIST(object)      (G_TYPE_CHECK_INSTANCE_CAST((object), XFMEDIA_TYPE_PLAYLIST, XfMediaPlaylist))
#define XFMEDIA_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_PLAYLIST, XfMediaPlaylistClass))
#define XFMEDIA_IS_PLAYLIST(object)   (G_TYPE_CHECK_INSTANCE_TYPE((object), XFMEDIA_TYPE_PLAYLIST))

typedef struct _XfMediaPlaylistEntryRef XfMediaPlaylistEntryRef;

typedef struct _XfMediaPlaylist XfMediaPlaylist;
typedef struct _XfMediaPlaylistClass XfMediaPlaylistClass;
typedef struct _XfMediaPlaylistPriv XfMediaPlaylistPriv;
    
struct _XfMediaPlaylist
{
    GtkVBox parent;
    
    /*< private */
    XfMediaPlaylistPriv *priv;
};

struct _XfMediaPlaylistClass
{
    GtkVBoxClass parent_class;
    
    /*< signals >*/
    void (*playlist_cleared)(XfMediaPlaylist *plist);
    void (*playlist_opened)(XfMediaPlaylist *plist, const gchar *filename);
    void (*playlist_saved)(XfMediaPlaylist *plist, const gchar *filename);
    void (*playlist_scrolled)(XfMediaPlaylist *plist);
    
    void (*entry_added)(XfMediaPlaylist *plist, gint index);
    void (*entry_changed)(XfMediaPlaylist *plist, gint index);
    void (*entry_removed)(XfMediaPlaylist *plist, const gchar *uri);
    void (*entry_activated)(XfMediaPlaylist *plist, gint index);
    
    void (*shuffle_toggled)(XfMediaPlaylist *plist);
    void (*repeat_toggled)(XfMediaPlaylist *plist);
    
    /*< reserved >*/
    void (*_xfmedia_res0)();
    void (*_xfmedia_res1)();
    void (*_xfmedia_res2)();
};

XfMediaPlaylistEntryRef *xfmedia_playlist_entry_ref_new_for_index
                                                 (XfMediaPlaylist *plist,
                                                  guint index);
XfMediaPlaylistEntryRef *xfmedia_playlist_entry_ref_copy
                                                 (XfMediaPlaylistEntryRef *ref);
gboolean xfmedia_playlist_entry_ref_valid        (XfMediaPlaylistEntryRef *ref);
gint xfmedia_playlist_entry_ref_get_index        (XfMediaPlaylistEntryRef *ref);
void xfmedia_playlist_entry_ref_destroy          (XfMediaPlaylistEntryRef *ref);

GType xfmedia_playlist_get_type                  () G_GNUC_CONST;

GtkWidget *xfmedia_playlist_new                  ();

guint xfmedia_playlist_append_entry              (XfMediaPlaylist *plist,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename,
                                                  gboolean metadata_loaded);
guint xfmedia_playlist_insert_entry              (XfMediaPlaylist *plist,
                                                  guint index,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename,
                                                  gboolean metadata_loaded);

void xfmedia_playlist_modify_entry               (XfMediaPlaylist *plist,
                                                  guint index,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename);
                                                   
gboolean xfmedia_playlist_remove_entry           (XfMediaPlaylist *plist,
                                                  guint index);
void xfmedia_playlist_clear                      (XfMediaPlaylist *plist);

void xfmedia_playlist_set_metadata_loaded        (XfMediaPlaylist *plist,
                                                  guint index,
                                                  gboolean metadata_loaded);
gboolean xfmedia_playlist_get_metadata_loaded    (XfMediaPlaylist *plist,
                                                  guint index);
gboolean xfmedia_playlist_get                    (XfMediaPlaylist *plist,
                                                  guint index,
                                                  gchar **title,
                                                  gint *length,
                                                  gchar **filename);
guint xfmedia_playlist_get_n_entries             (XfMediaPlaylist *plist);

gint xfmedia_playlist_get_selected               (XfMediaPlaylist *plist);

void xfmedia_playlist_set_bold_entry             (XfMediaPlaylist *plist,
                                                  XfMediaPlaylistEntryRef *ref);
void xfmedia_playlist_set_italic_entry           (XfMediaPlaylist *plist,
                                                  XfMediaPlaylistEntryRef *ref);

void xfmedia_playlist_context_menu_prepend_item  (XfMediaPlaylist *plist,
                                                  GtkMenuItem *menu_item);
void xfmedia_playlist_context_menu_append_item   (XfMediaPlaylist *plist,
                                                  GtkMenuItem *menu_item);

gboolean xfmedia_playlist_is_dirty               (XfMediaPlaylist *plist);

void xfmedia_playlist_set_shuffle_state          (XfMediaPlaylist *plist,
                                                  gboolean state);
gboolean xfmedia_playlist_get_shuffle_state      (XfMediaPlaylist *plist);
void xfmedia_playlist_set_repeat_state           (XfMediaPlaylist *plist,
                                                  gboolean state);
gboolean xfmedia_playlist_get_repeat_state       (XfMediaPlaylist *plist);

void xfmedia_playlist_scroll_to_index            (XfMediaPlaylist *plist,
                                                  gint index,
                                                  gdouble align);
gboolean xfmedia_playlist_get_visible_range      (XfMediaPlaylist *plist,
                                                  guint *start,
                                                  guint *end);

void xfmedia_playlist_sort                       (XfMediaPlaylist *plist,
                                                  XfMediaPlaylistSortType type);

void xfmedia_playlist_set_external_menu          (XfMediaPlaylist *plist,
                                                  GtkMenu *menu);

void xfmedia_playlist_augment_add_menu           (XfMediaPlaylist *plist,
                                                  GtkMenuItem *menu_item);

void xfmedia_playlist_trigger_add_file           (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_add_directory      (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_add_url            (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_new_playlist       (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_open_playlist      (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_save_playlist      (XfMediaPlaylist *plist);
void xfmedia_playlist_trigger_jump_to_file       (XfMediaPlaylist *plist);

gboolean xfmedia_playlist_has_focus              (XfMediaPlaylist *plist);

/* playlist shuffle-play management */
gboolean xfmedia_playlist_shuffle_check          (XfMediaPlaylist *plist,
                                                  guint index);
gboolean xfmedia_playlist_shuffle_check_set      (XfMediaPlaylist *plist,
                                                  guint index);
void xfmedia_playlist_shuffle_unset              (XfMediaPlaylist *plist,
                                                  guint index);
void xfmedia_playlist_shuffle_unset_all          (XfMediaPlaylist *plist);
void xfmedia_playlist_shuffle_add_entries        (XfMediaPlaylist *plist,
                                                  gint start,
                                                  guint len);
void xfmedia_playlist_shuffle_remove_entries     (XfMediaPlaylist *plist,
                                                  guint start,
                                                  gint len);
void xfmedia_playlist_shuffle_swap_entries       (XfMediaPlaylist *plist,
                                                  guint a,
                                                  guint b);
void xfmedia_playlist_shuffle_init_entries       (XfMediaPlaylist *plist,
                                                  guint len);

G_END_DECLS

#endif
