/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_PLUGIN_H__
#define __XFMEDIA_PLUGIN_H__

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <xfmedia/xfmedia-playlist.h>

G_BEGIN_DECLS

#define XFMEDIA_PLUGIN_API_VERSION "3.0.0"
#define XFMEDIA_PLUGIN_API_MAJOR   3
#define XFMEDIA_PLUGIN_API_MINOR   0
#define XFMEDIA_PLUGIN_API_MICRO   0

/* all plugins must call this macro */
#define XFMEDIA_PLUGIN_DECL \
G_MODULE_EXPORT gboolean \
xfmedia_plugin_check_version(gint api_major, gint api_minor, gint api_micro) \
{ \
	if(api_major != XFMEDIA_PLUGIN_API_MAJOR \
			|| api_minor < XFMEDIA_PLUGIN_API_MINOR) \
	{ \
		return FALSE; \
	} \
	return TRUE; \
}

#define XFMEDIA_TYPE_PLUGIN            (xfmedia_plugin_get_type())
#define XFMEDIA_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), XFMEDIA_TYPE_PLUGIN, XfmediaPlugin))
#define XFMEDIA_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_PLUGIN, XfmediaPluginClass))
#define XFMEDIA_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFMEDIA_TYPE_PLUGIN))
#define XFMEDIA_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), XFMEDIA_TYPE_PLUGIN))
#define XFMEDIA_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), XFMEDIA_TYPE_PLUGIN, XfmediaPluginClass))

typedef struct _XfmediaPlugin      XfmediaPlugin;
typedef struct _XfmediaPluginClass XfmediaPluginClass;
typedef struct _XfmediaPluginPriv  XfmediaPluginPriv;

typedef GtkWidget *(*PluginConfigureFunc)(XfmediaPlugin *plugin);

struct _XfmediaPlugin
{
	GObject parent;
	
	/*< private >*/
	XfmediaPluginPriv *priv;
};

struct _XfmediaPluginClass
{
	GObjectClass parent_class;
	
	/*< signals >*/
	void (*stream_loaded)(XfmediaPlugin *plugin);
	void (*stream_started)(XfmediaPlugin *plugin);
	void (*stream_ended)(XfmediaPlugin *plugin);
	void (*speed_changed)(XfmediaPlugin *plugin);
	void (*unloading)(XfmediaPlugin *plugin);
    
    /*< signals: from xfmedia-playlist.h >*/
    void (*playlist_cleared)(XfmediaPlugin *plugin);
    void (*playlist_opened)(XfmediaPlugin *plugin, const gchar *filename);
    void (*playlist_saved)(XfmediaPlugin *plugin, const gchar *filename);
    void (*playlist_scrolled)(XfmediaPlugin *plugin);
    void (*playlist_entry_added)(XfmediaPlugin *plugin, gint idx);
    void (*playlist_entry_changed)(XfmediaPlugin *plugin, gint idx);
    void (*playlist_entry_removed)(XfmediaPlugin *plugin, const gchar *uri);
    void (*playlist_entry_activated)(XfmediaPlugin *plugin, gint idx);
    void (*playlist_shuffle_toggled)(XfmediaPlugin *plugin);
    void (*playlist_repeat_toggled)(XfmediaPlugin *plugin);
	
	/*< reserved for future expansion >*/
	void (*_xfmedia_reserved0)();
	void (*_xfmedia_reserved1)();
	void (*_xfmedia_reserved2)();
};

GType          xfmedia_plugin_get_type            () G_GNUC_CONST;

/* should not be called by plugin implementations */
XfmediaPlugin *xfmedia_plugin_new                 ();

void           xfmedia_plugin_set_name            (XfmediaPlugin *plugin,
                                                   const gchar *name);
G_CONST_RETURN gchar *xfmedia_plugin_get_name     (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_description     (XfmediaPlugin *plugin,
                                                   const gchar *description);
G_CONST_RETURN gchar *xfmedia_plugin_get_description
                                                  (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_version         (XfmediaPlugin *plugin,
                                                   const gchar *version);
G_CONST_RETURN gchar *xfmedia_plugin_get_version  (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_icon_file       (XfmediaPlugin *plugin,
                                                   const gchar *icon_file);
G_CONST_RETURN gchar *xfmedia_plugin_get_icon_file(XfmediaPlugin *plugin);

void           xfmedia_plugin_set_icon            (XfmediaPlugin *plugin,
                                                   GdkPixbuf *icon);
GdkPixbuf *    xfmedia_plugin_get_icon            (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_author          (XfmediaPlugin *plugin,
                                                   const gchar *author);
G_CONST_RETURN gchar *xfmedia_plugin_get_author   (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_website         (XfmediaPlugin *plugin,
                                                   const gchar *website);
G_CONST_RETURN gchar *xfmedia_plugin_get_website  (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_license         (XfmediaPlugin *plugin,
                                                   const gchar *license);
G_CONST_RETURN gchar *xfmedia_plugin_get_license  (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_date            (XfmediaPlugin *plugin,
                                                   const gchar *date);
G_CONST_RETURN gchar *xfmedia_plugin_get_date     (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_configure_func  (XfmediaPlugin *plugin,
                                                   PluginConfigureFunc func);
PluginConfigureFunc xfmedia_plugin_get_configure_func
                                                  (XfmediaPlugin *plugin);

void           xfmedia_plugin_set_enabled         (XfmediaPlugin *plugin,
                                                   gboolean enabled);
gboolean       xfmedia_plugin_get_enabled         (XfmediaPlugin *plugin);

XfmediaPlaylist *xfmedia_plugin_get_playlist      (XfmediaPlugin *plugin);

G_END_DECLS

#endif
