/* interface.c generated by valac 0.14.0, the Vala compiler
 * generated from interface.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>


#define XFMPC_TYPE_INTERFACE (xfmpc_interface_get_type ())
#define XFMPC_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterface))
#define XFMPC_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))
#define XFMPC_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_INTERFACE))
#define XFMPC_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_INTERFACE))
#define XFMPC_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_INTERFACE, XfmpcInterfaceClass))

typedef struct _XfmpcInterface XfmpcInterface;
typedef struct _XfmpcInterfaceClass XfmpcInterfaceClass;
typedef struct _XfmpcInterfacePrivate XfmpcInterfacePrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _XfmpcInterface {
	GtkVBox parent_instance;
	XfmpcInterfacePrivate * priv;
};

struct _XfmpcInterfaceClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcInterfacePrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkButton* button_prev;
	GtkButton* button_pp;
	GtkButton* button_next;
	GtkVolumeButton* button_volume;
	GtkProgressBar* progress_bar;
	GtkLabel* title;
	GtkLabel* subtitle;
	gboolean progress_bar_sync;
};


static gpointer xfmpc_interface_parent_class = NULL;

GType xfmpc_interface_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_INTERFACE, XfmpcInterfacePrivate))
enum  {
	XFMPC_INTERFACE_DUMMY_PROPERTY
};
void xfmpc_interface_set_title (XfmpcInterface* self, const gchar* title);
void xfmpc_interface_set_subtitle (XfmpcInterface* self, const gchar* subtitle);
void xfmpc_interface_pp_clicked (XfmpcInterface* self);
void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play);
static gboolean xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self, GdkEventMotion* event);
void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total);
static gboolean xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self, GdkEventButton* event);
static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event);
void xfmpc_interface_volume_changed (XfmpcInterface* self, gdouble value);
void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume);
void xfmpc_interface_popup_volume (XfmpcInterface* self);
void xfmpc_interface_reset (XfmpcInterface* self);
void xfmpc_interface_update_title (XfmpcInterface* self);
static void xfmpc_interface_cb_song_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing);
static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time);
static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time);
static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume);
static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self);
static void xfmpc_interface_cb_stopped (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self);
static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self);
XfmpcInterface* xfmpc_interface_new (void);
XfmpcInterface* xfmpc_interface_construct (GType object_type);
static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, gdouble value, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self);
static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self);
static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self);
static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self);
static void xfmpc_interface_finalize (GObject* obj);


void xfmpc_interface_set_title (XfmpcInterface* self, const gchar* title) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = title;
	gtk_label_set_text (_tmp0_, _tmp1_);
}


void xfmpc_interface_set_subtitle (XfmpcInterface* self, const gchar* subtitle) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subtitle != NULL);
	_tmp0_ = self->priv->subtitle;
	_tmp1_ = subtitle;
	gtk_label_set_text (_tmp0_, _tmp1_);
}


void xfmpc_interface_pp_clicked (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	XfmpcMpdclient* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_pp (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_is_playing (_tmp2_);
	xfmpc_interface_set_pp (self, _tmp3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void xfmpc_interface_set_pp (XfmpcInterface* self, gboolean play) {
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkImage* _tmp2_;
	GtkImage* image;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_pp;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GTK_IMAGE (_tmp1_));
	image = _tmp2_;
	_tmp3_ = play;
	if (_tmp3_ == TRUE) {
		GtkImage* _tmp4_;
		_tmp4_ = image;
		gtk_image_set_from_stock (_tmp4_, GTK_STOCK_MEDIA_PAUSE, GTK_ICON_SIZE_BUTTON);
	} else {
		GtkImage* _tmp5_;
		_tmp5_ = image;
		gtk_image_set_from_stock (_tmp5_, GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON);
	}
	_g_object_unref0 (image);
}


static gboolean xfmpc_interface_cb_progress_box_motion_event (XfmpcInterface* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	XfmpcMpdclient* _tmp0_;
	gint _tmp1_ = 0;
	gint time_total;
	gint _tmp2_;
	GdkEventMotion _tmp3_;
	gdouble _tmp4_;
	GtkProgressBar* _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gdouble song_time;
	gdouble _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp14_;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_get_total_time (_tmp0_);
	time_total = _tmp1_;
	_tmp2_ = time_total;
	if (_tmp2_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.x;
	_tmp5_ = self->priv->progress_bar;
	_tmp6_ = ((GtkWidget*) _tmp5_)->allocation;
	_tmp7_ = _tmp6_.width;
	song_time = _tmp4_ / _tmp7_;
	_tmp8_ = song_time;
	_tmp9_ = time_total;
	song_time = _tmp8_ * _tmp9_;
	_tmp10_ = song_time;
	if (_tmp10_ < ((gdouble) 0)) {
		song_time = (gdouble) 0;
	} else {
		gdouble _tmp11_;
		gint _tmp12_;
		_tmp11_ = song_time;
		_tmp12_ = time_total;
		if (_tmp11_ > ((gdouble) _tmp12_)) {
			gint _tmp13_;
			_tmp13_ = time_total;
			song_time = (gdouble) _tmp13_;
		}
	}
	_tmp14_ = song_time;
	_tmp15_ = time_total;
	xfmpc_interface_set_time (self, (gint) _tmp14_, _tmp15_);
	result = FALSE;
	return result;
}


static gboolean xfmpc_interface_cb_progress_box_press_event (XfmpcInterface* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->progress_bar_sync = FALSE;
	result = FALSE;
	return result;
}


static gboolean xfmpc_interface_cb_progress_box_release_event (XfmpcInterface* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	GdkEventType _tmp2_;
	gboolean _tmp5_;
	XfmpcMpdclient* _tmp6_;
	gint _tmp7_ = 0;
	gint time_total;
	gint _tmp8_;
	GdkEventButton _tmp9_;
	gdouble _tmp10_;
	GtkProgressBar* _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	gdouble song_time;
	gdouble _tmp14_;
	gint _tmp15_;
	XfmpcMpdclient* _tmp16_;
	gdouble _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_RELEASE) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_;
		guint _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 1);
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	self->priv->progress_bar_sync = TRUE;
	_tmp6_ = self->priv->mpdclient;
	_tmp7_ = xfmpc_mpdclient_get_total_time (_tmp6_);
	time_total = _tmp7_;
	_tmp8_ = time_total;
	if (_tmp8_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp9_ = *event;
	_tmp10_ = _tmp9_.x;
	_tmp11_ = self->priv->progress_bar;
	_tmp12_ = ((GtkWidget*) _tmp11_)->allocation;
	_tmp13_ = _tmp12_.width;
	song_time = _tmp10_ / _tmp13_;
	_tmp14_ = song_time;
	_tmp15_ = time_total;
	song_time = _tmp14_ * _tmp15_;
	_tmp16_ = self->priv->mpdclient;
	_tmp17_ = song_time;
	xfmpc_mpdclient_set_song_time (_tmp16_, (guint) ((gint) _tmp17_));
	result = TRUE;
	return result;
}


void xfmpc_interface_volume_changed (XfmpcInterface* self, gdouble value) {
	XfmpcMpdclient* _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = value;
	xfmpc_mpdclient_set_volume (_tmp0_, (guchar) ((gchar) _tmp1_));
}


void xfmpc_interface_set_volume (XfmpcInterface* self, gint volume) {
	GtkVolumeButton* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	_tmp1_ = volume;
	gtk_scale_button_set_value ((GtkScaleButton*) _tmp0_, (gdouble) _tmp1_);
}


void xfmpc_interface_popup_volume (XfmpcInterface* self) {
	GtkVolumeButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_volume;
	g_signal_emit_by_name (_tmp0_, "popup", NULL, NULL);
}


void xfmpc_interface_set_time (XfmpcInterface* self, gint song_time, gint time_total) {
	gint min = 0;
	gint sec = 0;
	gint min_total = 0;
	gint sec_total = 0;
	gdouble fraction;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GString* _tmp4_;
	GString* text;
	GString* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkProgressBar* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_;
	GtkProgressBar* _tmp19_;
	gdouble _tmp20_;
	g_return_if_fail (self != NULL);
	fraction = 1.0;
	_tmp0_ = song_time;
	min = _tmp0_ / 60;
	_tmp1_ = song_time;
	sec = _tmp1_ % 60;
	_tmp2_ = time_total;
	min_total = _tmp2_ / 60;
	_tmp3_ = time_total;
	sec_total = _tmp3_ % 60;
	_tmp4_ = g_string_new ("");
	text = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = min;
	_tmp7_ = sec;
	_tmp8_ = min_total;
	_tmp9_ = sec_total;
	g_string_append_printf (_tmp5_, "%d:%02d / %d:%02d", _tmp6_, _tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = self->priv->progress_bar;
	_tmp11_ = text;
	_tmp12_ = _tmp11_->str;
	gtk_progress_bar_set_text (_tmp10_, _tmp12_);
	_tmp13_ = time_total;
	if (_tmp13_ > 0) {
		gint _tmp14_;
		gint _tmp15_;
		_tmp14_ = song_time;
		_tmp15_ = time_total;
		fraction = (gdouble) (((gfloat) _tmp14_) / ((gfloat) _tmp15_));
	}
	_tmp17_ = fraction;
	if (_tmp17_ <= 1.0) {
		gdouble _tmp18_;
		_tmp18_ = fraction;
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = 1.0;
	}
	_tmp19_ = self->priv->progress_bar;
	_tmp20_ = _tmp16_;
	gtk_progress_bar_set_fraction (_tmp19_, _tmp20_);
	_g_string_free0 (text);
}


void xfmpc_interface_reset (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_set_time (self, 0, 0);
	xfmpc_interface_set_volume (self, 0);
	xfmpc_interface_update_title (self);
}


void xfmpc_interface_update_title (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_is_playing (_tmp0_);
	if (_tmp1_) {
		XfmpcMpdclient* _tmp2_;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		XfmpcMpdclient* _tmp5_;
		const gchar* _tmp6_ = NULL;
		XfmpcMpdclient* _tmp7_;
		const gchar* _tmp8_ = NULL;
		XfmpcMpdclient* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* text;
		const gchar* _tmp12_;
		_tmp2_ = self->priv->mpdclient;
		_tmp3_ = xfmpc_mpdclient_get_title (_tmp2_);
		xfmpc_interface_set_title (self, _tmp3_);
		_tmp4_ = _ ("by \"%s\" from \"%s\" (%s)");
		_tmp5_ = self->priv->mpdclient;
		_tmp6_ = xfmpc_mpdclient_get_artist (_tmp5_);
		_tmp7_ = self->priv->mpdclient;
		_tmp8_ = xfmpc_mpdclient_get_album (_tmp7_);
		_tmp9_ = self->priv->mpdclient;
		_tmp10_ = xfmpc_mpdclient_get_date (_tmp9_);
		_tmp11_ = g_strdup_printf (_tmp4_, _tmp6_, _tmp8_, _tmp10_);
		text = _tmp11_;
		_tmp12_ = text;
		xfmpc_interface_set_subtitle (self, _tmp12_);
		_g_free0 (text);
	} else {
		XfmpcMpdclient* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = self->priv->mpdclient;
		_tmp14_ = xfmpc_mpdclient_is_stopped (_tmp13_);
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = _ ("Stopped");
			xfmpc_interface_set_title (self, _tmp15_);
			xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
		} else {
			XfmpcMpdclient* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = self->priv->mpdclient;
			_tmp17_ = xfmpc_mpdclient_is_connected (_tmp16_);
			if (!_tmp17_) {
				const gchar* _tmp18_ = NULL;
				_tmp18_ = _ ("Not connected");
				xfmpc_interface_set_title (self, _tmp18_);
				xfmpc_interface_set_subtitle (self, PACKAGE_STRING);
			}
		}
	}
}


static void xfmpc_interface_cb_song_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_pp_changed (XfmpcInterface* self, gboolean is_playing) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_playing;
	xfmpc_interface_set_pp (self, _tmp0_);
	xfmpc_interface_cb_song_changed (self);
}


static void xfmpc_interface_cb_time_changed (XfmpcInterface* self, gint song_time) {
	gboolean _tmp0_;
	gint _tmp1_;
	XfmpcMpdclient* _tmp2_;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar_sync;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = song_time;
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_get_total_time (_tmp2_);
	xfmpc_interface_set_time (self, _tmp1_, _tmp3_);
}


static void xfmpc_interface_cb_total_time_changed (XfmpcInterface* self, gint total_time) {
	gboolean _tmp0_;
	XfmpcMpdclient* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar_sync;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = self->priv->mpdclient;
	_tmp2_ = xfmpc_mpdclient_get_time (_tmp1_);
	_tmp3_ = total_time;
	xfmpc_interface_set_time (self, _tmp2_, _tmp3_);
}


static void xfmpc_interface_cb_volume_changed (XfmpcInterface* self, gint volume) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = volume;
	xfmpc_interface_set_volume (self, _tmp0_);
}


static void xfmpc_interface_cb_playlist_changed (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_stopped (XfmpcInterface* self) {
	g_return_if_fail (self != NULL);
	xfmpc_interface_set_pp (self, FALSE);
	xfmpc_interface_update_title (self);
}


static void xfmpc_interface_cb_mpdclient_previous (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_previous (_tmp0_);
}


static void xfmpc_interface_cb_mpdclient_next (XfmpcInterface* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_next (_tmp0_);
}


XfmpcInterface* xfmpc_interface_construct (GType object_type) {
	XfmpcInterface * self = NULL;
	self = (XfmpcInterface*) g_object_new (object_type, NULL);
	return self;
}


XfmpcInterface* xfmpc_interface_new (void) {
	return xfmpc_interface_construct (XFMPC_TYPE_INTERFACE);
}


static void _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_previous (self);
}


static void _xfmpc_interface_pp_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_pp_clicked (self);
}


static void _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	xfmpc_interface_cb_mpdclient_next (self);
}


static void _xfmpc_interface_volume_changed_gtk_scale_button_value_changed (GtkScaleButton* _sender, gdouble value, gpointer self) {
	xfmpc_interface_volume_changed (self, value);
}


static gboolean _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_motion_event (self, event);
	return result;
}


static gboolean _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_press_event (self, event);
	return result;
}


static gboolean _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_interface_cb_progress_box_release_event (self, event);
	return result;
}


static void _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_song_changed (self);
}


static void _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_interface_cb_pp_changed (self, is_playing);
}


static void _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed (XfmpcMpdclient* _sender, gint song_time, gpointer self) {
	xfmpc_interface_cb_time_changed (self, song_time);
}


static void _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed (XfmpcMpdclient* _sender, gint total_time, gpointer self) {
	xfmpc_interface_cb_total_time_changed (self, total_time);
}


static void _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed (XfmpcMpdclient* _sender, gint volume, gpointer self) {
	xfmpc_interface_cb_volume_changed (self, volume);
}


static void _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_playlist_changed (self);
}


static void _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_interface_cb_stopped (self);
}


static GObject * xfmpc_interface_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcInterface * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* image;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkImage* _tmp22_;
	GtkVolumeButton* _tmp23_;
	GtkVolumeButton* _tmp24_;
	GtkVolumeButton* _tmp25_;
	GtkVolumeButton* _tmp26_;
	GtkAdjustment* _tmp27_ = NULL;
	GtkAdjustment* _tmp28_;
	GtkAdjustment* adjustment;
	GtkAdjustment* _tmp29_;
	GtkAdjustment* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	GtkAdjustment* _tmp33_;
	GtkAdjustment* _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	GtkAdjustment* _tmp37_;
	GtkAdjustment* _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	GtkEventBox* _tmp41_;
	GtkEventBox* _tmp42_;
	GtkEventBox* progress_box;
	GtkProgressBar* _tmp43_;
	GtkProgressBar* _tmp44_;
	GtkProgressBar* _tmp45_;
	GtkProgressBar* _tmp46_;
	GtkEventBox* _tmp47_;
	GtkProgressBar* _tmp48_;
	PangoAttrList* _tmp49_;
	PangoAttrList* attrs;
	PangoAttribute* _tmp50_ = NULL;
	PangoAttribute* attr;
	PangoAttribute* _tmp51_;
	PangoAttribute* _tmp52_;
	PangoAttrList* _tmp53_;
	PangoAttribute* _tmp54_;
	PangoAttribute* _tmp55_ = NULL;
	PangoAttribute* _tmp56_ = NULL;
	PangoAttribute* _tmp57_;
	PangoAttribute* _tmp58_;
	PangoAttrList* _tmp59_;
	PangoAttribute* _tmp60_;
	PangoAttribute* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkLabel* _tmp65_;
	PangoAttrList* _tmp66_;
	GtkLabel* _tmp67_;
	GtkLabel* _tmp68_;
	GtkLabel* _tmp69_;
	PangoAttrList* _tmp70_;
	PangoAttribute* _tmp71_ = NULL;
	PangoAttribute* _tmp72_;
	PangoAttribute* _tmp73_;
	PangoAttrList* _tmp74_;
	PangoAttribute* _tmp75_;
	PangoAttribute* _tmp76_ = NULL;
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	PangoAttrList* _tmp80_;
	GtkLabel* _tmp81_;
	GtkLabel* _tmp82_;
	GtkLabel* _tmp83_;
	GtkHBox* _tmp84_;
	GtkHBox* _tmp85_;
	GtkHBox* box;
	GtkHBox* _tmp86_;
	GtkHBox* _tmp87_;
	GtkButton* _tmp88_;
	GtkHBox* _tmp89_;
	GtkButton* _tmp90_;
	GtkHBox* _tmp91_;
	GtkButton* _tmp92_;
	GtkHBox* _tmp93_;
	GtkEventBox* _tmp94_;
	GtkHBox* _tmp95_;
	GtkVolumeButton* _tmp96_;
	GtkVBox* _tmp97_;
	GtkVBox* _tmp98_;
	GtkVBox* vbox;
	GtkVBox* _tmp99_;
	GtkVBox* _tmp100_;
	GtkLabel* _tmp101_;
	GtkVBox* _tmp102_;
	GtkLabel* _tmp103_;
	GtkButton* _tmp104_;
	GtkButton* _tmp105_;
	GtkButton* _tmp106_;
	GtkVolumeButton* _tmp107_;
	GtkEventBox* _tmp108_;
	GtkEventBox* _tmp109_;
	GtkEventBox* _tmp110_;
	XfmpcMpdclient* _tmp111_;
	XfmpcMpdclient* _tmp112_;
	XfmpcMpdclient* _tmp113_;
	XfmpcMpdclient* _tmp114_;
	XfmpcMpdclient* _tmp115_;
	XfmpcMpdclient* _tmp116_;
	XfmpcMpdclient* _tmp117_;
	parent_class = G_OBJECT_CLASS (xfmpc_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_INTERFACE (obj);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 4);
	_tmp2_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PREVIOUS, GTK_ICON_SIZE_BUTTON);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	image = _tmp3_;
	_tmp4_ = (GtkButton*) gtk_button_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->button_prev);
	self->priv->button_prev = _tmp5_;
	_tmp6_ = self->priv->button_prev;
	gtk_button_set_relief (_tmp6_, GTK_RELIEF_NONE);
	_tmp7_ = self->priv->button_prev;
	_tmp8_ = image;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_BUTTON);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (image);
	image = _tmp10_;
	_tmp11_ = (GtkButton*) gtk_button_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->button_pp);
	self->priv->button_pp = _tmp12_;
	_tmp13_ = self->priv->button_pp;
	gtk_button_set_relief (_tmp13_, GTK_RELIEF_NONE);
	_tmp14_ = self->priv->button_pp;
	_tmp15_ = image;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_MEDIA_NEXT, GTK_ICON_SIZE_BUTTON);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	_g_object_unref0 (image);
	image = _tmp17_;
	_tmp18_ = (GtkButton*) gtk_button_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->button_next);
	self->priv->button_next = _tmp19_;
	_tmp20_ = self->priv->button_next;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	_tmp21_ = self->priv->button_next;
	_tmp22_ = image;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkVolumeButton*) gtk_volume_button_new ();
	_tmp24_ = g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->button_volume);
	self->priv->button_volume = _tmp24_;
	_tmp25_ = self->priv->button_volume;
	gtk_button_set_relief ((GtkButton*) _tmp25_, GTK_RELIEF_NONE);
	_tmp26_ = self->priv->button_volume;
	_tmp27_ = gtk_scale_button_get_adjustment ((GtkScaleButton*) _tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	adjustment = _tmp28_;
	_tmp29_ = adjustment;
	_tmp30_ = adjustment;
	_tmp31_ = gtk_adjustment_get_upper (_tmp30_);
	_tmp32_ = _tmp31_;
	gtk_adjustment_set_upper (_tmp30_, _tmp32_ * 100);
	_tmp33_ = adjustment;
	_tmp34_ = adjustment;
	_tmp35_ = gtk_adjustment_get_step_increment (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_adjustment_set_step_increment (_tmp34_, _tmp36_ * 100);
	_tmp37_ = adjustment;
	_tmp38_ = adjustment;
	_tmp39_ = gtk_adjustment_get_page_increment (_tmp38_);
	_tmp40_ = _tmp39_;
	gtk_adjustment_set_page_increment (_tmp38_, _tmp40_ * 100);
	_tmp41_ = (GtkEventBox*) gtk_event_box_new ();
	_tmp42_ = g_object_ref_sink (_tmp41_);
	progress_box = _tmp42_;
	_tmp43_ = (GtkProgressBar*) gtk_progress_bar_new ();
	_tmp44_ = g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp44_;
	_tmp45_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp45_, "0:00 / 0:00");
	_tmp46_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp46_, 1.0);
	_tmp47_ = progress_box;
	_tmp48_ = self->priv->progress_bar;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = pango_attr_list_new ();
	attrs = _tmp49_;
	_tmp50_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	attr = _tmp50_;
	_tmp51_ = attr;
	_tmp51_->start_index = (guint) 0;
	_tmp52_ = attr;
	_tmp52_->end_index = (guint) (-1);
	_tmp53_ = attrs;
	_tmp54_ = attr;
	_tmp55_ = pango_attribute_copy (_tmp54_);
	pango_attr_list_insert (_tmp53_, _tmp55_);
	_tmp56_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_X_LARGE);
	_pango_attribute_destroy0 (attr);
	attr = _tmp56_;
	_tmp57_ = attr;
	_tmp57_->start_index = (guint) 0;
	_tmp58_ = attr;
	_tmp58_->end_index = (guint) (-1);
	_tmp59_ = attrs;
	_tmp60_ = attr;
	_tmp61_ = pango_attribute_copy (_tmp60_);
	pango_attr_list_insert (_tmp59_, _tmp61_);
	_tmp62_ = _ ("Not connected");
	_tmp63_ = (GtkLabel*) gtk_label_new (_tmp62_);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp64_;
	_tmp65_ = self->priv->title;
	_tmp66_ = attrs;
	gtk_label_set_attributes (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->title;
	gtk_label_set_selectable (_tmp67_, TRUE);
	_tmp68_ = self->priv->title;
	gtk_label_set_ellipsize (_tmp68_, PANGO_ELLIPSIZE_END);
	_tmp69_ = self->priv->title;
	gtk_misc_set_alignment ((GtkMisc*) _tmp69_, (gfloat) 0, (gfloat) 0.5);
	_tmp70_ = pango_attr_list_new ();
	_pango_attr_list_unref0 (attrs);
	attrs = _tmp70_;
	_tmp71_ = pango_attr_scale_new ((gdouble) PANGO_SCALE_SMALL);
	_pango_attribute_destroy0 (attr);
	attr = _tmp71_;
	_tmp72_ = attr;
	_tmp72_->start_index = (guint) 0;
	_tmp73_ = attr;
	_tmp73_->end_index = (guint) (-1);
	_tmp74_ = attrs;
	_tmp75_ = attr;
	_tmp76_ = pango_attribute_copy (_tmp75_);
	pango_attr_list_insert (_tmp74_, _tmp76_);
	_tmp77_ = (GtkLabel*) gtk_label_new (PACKAGE_STRING);
	_tmp78_ = g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp78_;
	_tmp79_ = self->priv->subtitle;
	_tmp80_ = attrs;
	gtk_label_set_attributes (_tmp79_, _tmp80_);
	_tmp81_ = self->priv->subtitle;
	gtk_label_set_selectable (_tmp81_, TRUE);
	_tmp82_ = self->priv->subtitle;
	gtk_label_set_ellipsize (_tmp82_, PANGO_ELLIPSIZE_END);
	_tmp83_ = self->priv->subtitle;
	gtk_misc_set_alignment ((GtkMisc*) _tmp83_, (gfloat) 0, (gfloat) 0.5);
	_tmp84_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_tmp85_ = g_object_ref_sink (_tmp84_);
	box = _tmp85_;
	_tmp86_ = box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp86_, FALSE, FALSE, (guint) 0);
	_tmp87_ = box;
	_tmp88_ = self->priv->button_prev;
	gtk_box_pack_start ((GtkBox*) _tmp87_, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 0);
	_tmp89_ = box;
	_tmp90_ = self->priv->button_pp;
	gtk_box_pack_start ((GtkBox*) _tmp89_, (GtkWidget*) _tmp90_, FALSE, FALSE, (guint) 0);
	_tmp91_ = box;
	_tmp92_ = self->priv->button_next;
	gtk_box_pack_start ((GtkBox*) _tmp91_, (GtkWidget*) _tmp92_, FALSE, FALSE, (guint) 0);
	_tmp93_ = box;
	_tmp94_ = progress_box;
	gtk_box_pack_start ((GtkBox*) _tmp93_, (GtkWidget*) _tmp94_, TRUE, TRUE, (guint) 4);
	_tmp95_ = box;
	_tmp96_ = self->priv->button_volume;
	gtk_box_pack_start ((GtkBox*) _tmp95_, (GtkWidget*) _tmp96_, FALSE, FALSE, (guint) 0);
	_tmp97_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_tmp98_ = g_object_ref_sink (_tmp97_);
	vbox = _tmp98_;
	_tmp99_ = vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp99_, FALSE, TRUE, (guint) 0);
	_tmp100_ = vbox;
	_tmp101_ = self->priv->title;
	gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = vbox;
	_tmp103_ = self->priv->subtitle;
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
	_tmp104_ = self->priv->button_prev;
	g_signal_connect_object (_tmp104_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_previous_gtk_button_clicked, self, 0);
	_tmp105_ = self->priv->button_pp;
	g_signal_connect_object (_tmp105_, "clicked", (GCallback) _xfmpc_interface_pp_clicked_gtk_button_clicked, self, 0);
	_tmp106_ = self->priv->button_next;
	g_signal_connect_object (_tmp106_, "clicked", (GCallback) _xfmpc_interface_cb_mpdclient_next_gtk_button_clicked, self, 0);
	_tmp107_ = self->priv->button_volume;
	g_signal_connect_object ((GtkScaleButton*) _tmp107_, "value-changed", (GCallback) _xfmpc_interface_volume_changed_gtk_scale_button_value_changed, self, 0);
	_tmp108_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp108_, "motion-notify-event", (GCallback) _xfmpc_interface_cb_progress_box_motion_event_gtk_widget_motion_notify_event, self, 0);
	_tmp109_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp109_, "button-press-event", (GCallback) _xfmpc_interface_cb_progress_box_press_event_gtk_widget_button_press_event, self, 0);
	_tmp110_ = progress_box;
	g_signal_connect_object ((GtkWidget*) _tmp110_, "button-release-event", (GCallback) _xfmpc_interface_cb_progress_box_release_event_gtk_widget_button_release_event, self, 0);
	_tmp111_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp111_, "song-changed", (GCallback) _xfmpc_interface_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp112_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp112_, "pp-changed", (GCallback) _xfmpc_interface_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp113_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp113_, "time-changed", (GCallback) _xfmpc_interface_cb_time_changed_xfmpc_mpdclient_time_changed, self, 0);
	_tmp114_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp114_, "total-time-changed", (GCallback) _xfmpc_interface_cb_total_time_changed_xfmpc_mpdclient_total_time_changed, self, 0);
	_tmp115_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp115_, "volume-changed", (GCallback) _xfmpc_interface_cb_volume_changed_xfmpc_mpdclient_volume_changed, self, 0);
	_tmp116_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp116_, "playlist-changed", (GCallback) _xfmpc_interface_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp117_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp117_, "stopped", (GCallback) _xfmpc_interface_cb_stopped_xfmpc_mpdclient_stopped, self, 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (box);
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attrs);
	_g_object_unref0 (progress_box);
	_g_object_unref0 (adjustment);
	_g_object_unref0 (image);
	return obj;
}


static void xfmpc_interface_class_init (XfmpcInterfaceClass * klass) {
	xfmpc_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcInterfacePrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_interface_finalize;
}


static void xfmpc_interface_instance_init (XfmpcInterface * self) {
	self->priv = XFMPC_INTERFACE_GET_PRIVATE (self);
	self->priv->progress_bar_sync = TRUE;
}


static void xfmpc_interface_finalize (GObject* obj) {
	XfmpcInterface * self;
	self = XFMPC_INTERFACE (obj);
	_g_object_unref0 (self->priv->button_prev);
	_g_object_unref0 (self->priv->button_pp);
	_g_object_unref0 (self->priv->button_next);
	_g_object_unref0 (self->priv->button_volume);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->title);
	_g_object_unref0 (self->priv->subtitle);
	G_OBJECT_CLASS (xfmpc_interface_parent_class)->finalize (obj);
}


GType xfmpc_interface_get_type (void) {
	static volatile gsize xfmpc_interface_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcInterface), 0, (GInstanceInitFunc) xfmpc_interface_instance_init, NULL };
		GType xfmpc_interface_type_id;
		xfmpc_interface_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcInterface", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_interface_type_id__volatile, xfmpc_interface_type_id);
	}
	return xfmpc_interface_type_id__volatile;
}



