/* -----------------------------------------------------------------------
   child process synchronization functions

   part of XfreeCD

   Copyright 1998 by Brian C. Lane
   nexus@tatoosh.com
   http://www.tatoosh.com/nexus

   ==========================[ HISTORY ]==================================
   05/09/98    Moved these functions into this seperate file

   ----------------------------------------------------------------------- */
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>



/*
   Synchronize with the parent process. Wait until we receive a 'P'
   from the parent. Send a 'C' to the parent in response

   Return a 0 if all went ok
   Return a -1 if something went wrong
*/
int parent_sync( int fd )
{
  char c;

  if( read( fd, &c, 1 ) != 1 )
    return(-1);

  if( write( fd, "C", 1 ) != 1 )
    return(-1);

  return(0);
}



/*
   Synchronize with the child process. Send a 'P' to the child and wait
   until a 'C' is received back.

   Return a 0 if all went ok
   Return a -1 if something went wrong
*/
int child_sync( int fd )
{
  char c;

  if( write( fd, "P", 1 ) != 1 )
    return(-1);

  if( read( fd, &c, 1 ) != 1 )
    return(-1);

  if( c != 'C' )
    return(-1);

  return(0);
}
