/*
 * Xiphos Bible Study Tool
 * shortcutbar_main.h - create and maintain the main shortcut bar
 *
 * Copyright (C) 2000-2009 Xiphos Developer Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __SHORTCUTBAR_MAIN_H_
#define __SHORTCUTBAR_MAIN_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <glib.h>
typedef struct _shortcut_item SHORTCUT_ITEM;
struct  _shortcut_item {
	gchar *url;
	gchar *name;
};

void showSBGroup(gint groupnum);
void changegroupnameSB(gchar * groupName, gint groupNum);
gint gui_get_num_shortcut_items(gint group_num);
void gui_get_shortcut_item_info(gint group_num, gint item_num, 
			gchar **item_url, gchar **item_name);	
void gui_setup_shortcut_bar(void);
void gui_update_shortcut_bar(void);
void gui_shortcutbar_showhide(void);
void gui_set_shortcutbar_porgram_start(void);
void gui_add_sb_item(gchar * url, gchar * name, gint group_num);

#ifdef __cplusplus
}
#endif

#endif
