#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdlib.h>
#include <math.h>

#include "callbacks_xlcm.h"
#include "interface_xlcm.h"
#include "support.h"

#include "cfg.h"
#include "widgets_xlcm.h"
#include "runtime.h"
#include "netio.h"
#include "proc_xlcm_lcp3.h"
#include "askname.h"

void
on_wnd_acitivity_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GdkEventMask events;
	widgets_load_wdg_activity();
	gdk_window_set_decorations(wnd_activity->window, 0);
	events = gdk_window_get_events(wnd_activity->window);
	gdk_window_set_events(wnd_activity->window, events |
			GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
	gdk_window_move(wnd_activity->window, config->wnd_activity_x, config->wnd_activity_y);
}


void
on_wnd_acitivity_unrealize             (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_activity->realized = FALSE;
	wnd_activity = NULL;
}

struct tMoveData
{
	gint x;
	gint y;
	gint dx;
	gint dy;
	gint timeout;
};
struct tMoveData *move_delta_activity = NULL;

gint timeout_wnd_activity_move( gpointer data )
{
#define SNAP_RANGE	6
	gint px, py;
	GdkModifierType modf;
	static gint bottom, right, scrw = 0, scrh = 0;
	if ( !scrw )
	{
		gint w, h;
		scrw = gdk_screen_width();
		scrh = gdk_screen_height();
		gdk_window_get_size(wnd_activity->window, &w, &h);
		bottom = scrh - h;
		right = scrw - w;
	}
	gdk_window_get_pointer(wnd_activity->window, &px, &py, &modf);
	move_delta_activity->x = px - move_delta_activity->dx + move_delta_activity->x;
	move_delta_activity->y = py - move_delta_activity->dy + move_delta_activity->y;
	if ( abs(move_delta_activity->y - bottom) <= SNAP_RANGE )
		move_delta_activity->y = bottom;
	if ( abs(move_delta_activity->x - right) <= SNAP_RANGE )
		move_delta_activity->x = right;
	if ( abs(move_delta_activity->y) <= SNAP_RANGE )
		move_delta_activity->y = 0;
	if ( abs(move_delta_activity->x) <= SNAP_RANGE )
		move_delta_activity->x = 0;
	gdk_window_move(wnd_activity->window, move_delta_activity->x, move_delta_activity->y);
	return 1;
}

gboolean
on_wnd_activity_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gint x, y;
	gint px, py;
	GdkModifierType modf;

	switch ( event->button )
	{
		case 1:
		case 3:
			break;
		default:
			return FALSE;
	}

	if ( event->button == 3 )
	{
		if ( !wdg_popup->realized )
			mn_popup = GTK_MENU(create_mn_popup());
		gtk_menu_popup(mn_popup, NULL, NULL, NULL, NULL, event->button, time(NULL));
	}

	if ( event->button != 1 ) return FALSE;
	// button 1 got pressed:
	if ( event->type == GDK_2BUTTON_PRESS )
	{
		gtk_timeout_remove(move_delta_activity->timeout);
		g_free(move_delta_activity);
		move_delta_activity = NULL;
		return FALSE;
	}

	gdk_window_get_position(wnd_activity->window, &x, &y);
	gdk_window_get_pointer(wnd_activity->window, &px, &py, &modf);

	move_delta_activity = g_malloc(sizeof(struct tMoveData));
	move_delta_activity->x = x;
	move_delta_activity->y = y;
	move_delta_activity->dx = px;
	move_delta_activity->dy = py;
	move_delta_activity->timeout = gtk_timeout_add(40, timeout_wnd_activity_move, NULL);
  return FALSE;
}


gboolean
on_wnd_activity_button_release_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if ( event->button != 1 ) return FALSE;
	if ( !move_delta_activity ) return FALSE;

	gtk_timeout_remove(move_delta_activity->timeout);
	timeout_wnd_activity_move(NULL);

	config->wnd_activity_x = move_delta_activity->x;
	config->wnd_activity_y = move_delta_activity->y;

	g_free(move_delta_activity);
	move_delta_activity = NULL;
  return FALSE;
}

void
on_mn_popup_show_messages_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( !wnd_messages )
	{
		wnd_messages = create_wnd_messages();
		gtk_widget_show(wnd_messages);
	}
	else
		gtk_window_activate_focus(GTK_WINDOW(wnd_messages));
}


void
on_mn_popup_exit_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_send(CMD3_UNREG, NULL, 0);
}


void
on_wnd_messages_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GList * cur = wdg_messages->msgs;
	gdk_window_resize(wnd_messages->window, config->wnd_messages_w, config->wnd_messages_h);
	widgets_load_wdg_messages();
	while ( cur )
	{
		gtk_clist_append(wdg_messages->cl_msg_messages, ((struct tmsg*)cur->data)->row);
		cur = g_list_next(cur);
	}
}


void
on_wnd_messages_unrealize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_messages->realized = FALSE;
	wnd_messages = NULL;
}


void
on_bt_msg_close_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(wnd_messages);
}


void
on_bt_msg_clear_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	GList * cur = wdg_messages->msgs;
	#ifdef DEBUG
		g_print("deleting messages...\n");
	#endif
	gtk_clist_clear(GTK_CLIST(wdg_messages->cl_msg_messages));
	while ( cur )
	{
		for (i=0; i<2; i++)
			g_free(((struct tmsg*)cur->data)->row[i]);
		g_free(cur->data);
		cur = g_list_next(cur);
	}
	g_list_free(wdg_messages->msgs);
	wdg_messages->msgs = NULL;
}


void
on_mn_popup_realize                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_popup();
}


void
on_mn_popup_unrealize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_popup->realized = FALSE;
	mn_popup = NULL;
}

void
on_wnd_askname_unrealize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_askname->realized = 0;
}


void
on_wnd_askname_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_askname();
}


void
on_bt_asknum_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
#if HAVE_LIBMYSQL
	an_ok();
#endif
}


void
on_bt_asknum_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
#if HAVE_LIBMYSQL
	an_cancel();
#endif
}

