/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_dialogsdialog.c - creation and destruction of the dialogs dialog
 *
 * show a dialog which will allow you to select the fields in the "worked before"
 * dialog. If the worked before dialog is active the fields are updated.
 */
#include <stdlib.h>
#include <gtk/gtk.h>

#include "gui_dialogsdialog.h"
#include "support.h"
#include "types.h"

extern GtkWidget *mainwindow;
extern GtkWidget *b4dialog;
extern preferencestype preferences;

void
on_menu_dialogs_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialogsdialog, *dialog_vbox, *notebook, *vbox, *label,
		*frame, *framehbox, *leftvbox, *rightvbox, *vbox2,
		*b40, *b41, *b42, *b43, *b44, *b45, *b46, *b47, *b48, *b49,
		*b410, *b411, *b412, *b413, *b414, *b415, *b416, *b417, *b418,
		*badif, *bu1, *bu2,
		*dialog_action_area, *dialogscancelbutton, *dialogsokbutton,
		*b4treeview;
	GdkPixbuf *dialogsdialog_icon_pixbuf;
	gchar **states, **split;
	gboolean check;
	GtkTreeViewColumn *column;
	gint i, response;

	split = g_strsplit(preferences.b4columns, ",", 0);
	dialogsdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (dialogsdialog), _("xlog - dialogs"));
	gtk_window_set_position (GTK_WINDOW (dialogsdialog), GTK_WIN_POS_MOUSE);
	dialogsdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (dialogsdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (dialogsdialog), dialogsdialog_icon_pixbuf);
			g_object_unref (dialogsdialog_icon_pixbuf);
		}

	dialog_vbox = GTK_DIALOG (dialogsdialog)->vbox;
	gtk_widget_show (dialog_vbox);

	notebook = gtk_notebook_new ();
	gtk_widget_show (notebook);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), notebook, TRUE, TRUE, 0);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);

	label = gtk_label_new (_("Columns to show in the 'Worked Before' dialog"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_misc_set_padding (GTK_MISC (label), 10, 0);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 10);

	framehbox = gtk_hbox_new (TRUE, 0);
	gtk_container_add (GTK_CONTAINER (frame), framehbox);

	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), leftvbox, TRUE, TRUE, 0);
	b40 = gtk_check_button_new_with_mnemonic (_("Logname"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b40), atoi(split[0]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b40, FALSE, FALSE, 0);
	b41 = gtk_check_button_new_with_mnemonic (_("QSO Number"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b41), atoi(split[1]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b41, FALSE, FALSE, 0);
	b42 = gtk_check_button_new_with_mnemonic (_("Date"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b42), atoi(split[2]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b42, FALSE, FALSE, 0);
	b43 = gtk_check_button_new_with_mnemonic ("GMT");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b43), atoi(split[3]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b43, FALSE, FALSE, 0);
	b44 = gtk_check_button_new_with_mnemonic (_("GMT - end"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b44), atoi(split[4]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b44, FALSE, FALSE, 0);
	b45 = gtk_check_button_new_with_mnemonic (_("Call"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b45), atoi(split[5]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b45, FALSE, FALSE, 0);
	b46 = gtk_check_button_new_with_mnemonic (_("Frequency"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b46), atoi(split[6]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b46, FALSE, FALSE, 0);
	b47 = gtk_check_button_new_with_mnemonic (_("Mode"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b47), atoi(split[7]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b47, FALSE, FALSE, 0);
	b48 = gtk_check_button_new_with_mnemonic ("TX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b48), atoi(split[8]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b48, FALSE, FALSE, 0);
	b49 = gtk_check_button_new_with_mnemonic ("RX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b49), atoi(split[9]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b49, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), rightvbox, TRUE, TRUE, 0);
	b410 = gtk_check_button_new_with_mnemonic (_("Qsl Out"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b410), atoi(split[10]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b410, FALSE, FALSE, 0);
	b411 = gtk_check_button_new_with_mnemonic (_("Qsl In"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b411), atoi(split[11]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b411, FALSE, FALSE, 0);
	b412 = gtk_check_button_new_with_mnemonic (_("Power"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b412), atoi(split[12]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b412, FALSE, FALSE, 0);
	b413 = gtk_check_button_new_with_mnemonic (_("Name"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b413), atoi(split[13]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b413, FALSE, FALSE, 0);
	b414 = gtk_check_button_new_with_mnemonic ("QTH");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b414), atoi(split[14]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b414, FALSE, FALSE, 0);
	b415 = gtk_check_button_new_with_mnemonic (_("Locator"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b415), atoi(split[15]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b415, FALSE, FALSE, 0);
	b416 = gtk_check_button_new_with_mnemonic (_("Freefield1"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b416), atoi(split[16]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b416, FALSE, FALSE, 0);
	b417 = gtk_check_button_new_with_mnemonic (_("Freefield2"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b417), atoi(split[17]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b417, FALSE, FALSE, 0);
	b418 = gtk_check_button_new_with_mnemonic (_("Remarks"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b418), atoi(split[18]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b418, FALSE, FALSE, 0);

	g_strfreev(split);
	gtk_widget_show_all (vbox);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);

	label = gtk_label_new (_("Export options for the 'Save As' dialog"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_misc_set_padding (GTK_MISC (label), 10, 0);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
	label = gtk_label_new ("ADIF");
	gtk_frame_set_label_widget (GTK_FRAME (frame), label);
	badif = gtk_check_button_new_with_mnemonic
		(_("When saving as ADIF convert frequency to band"));
	if (preferences.saveasadif == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (badif), TRUE);
	gtk_container_add (GTK_CONTAINER (frame), badif);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
	label = gtk_label_new ("labels");
	gtk_frame_set_label_widget (GTK_FRAME (frame), label);
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	bu1 = gtk_check_button_new_with_mnemonic
		(_("When saving as labels export freefield1"));
	gtk_container_add (GTK_CONTAINER (vbox2), bu1);
	bu2 = gtk_check_button_new_with_mnemonic
		(_("When saving as labels export freefield2"));
	if (preferences.saveaslabels == 3)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu1), 1);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu2), 1);
	}
	else if (preferences.saveaslabels == 2)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu2), 1);
	else if (preferences.saveaslabels == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu1), 1);

	gtk_container_add (GTK_CONTAINER (vbox2), bu2);
	gtk_widget_show_all (vbox);

	label = gtk_label_new (_("Worked Before"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);
	label = gtk_label_new (_("Save As"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label);

	dialog_action_area = GTK_DIALOG (dialogsdialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

	dialogscancelbutton = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (dialogscancelbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialogsdialog), dialogscancelbutton, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (dialogscancelbutton, GTK_CAN_DEFAULT);

	dialogsokbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (dialogsokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialogsdialog), dialogsokbutton, GTK_RESPONSE_OK);

	gtk_button_set_label (GTK_BUTTON (b416), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (b417), preferences.freefield2);
	
	response = gtk_dialog_run (GTK_DIALOG(dialogsdialog));
	if (response == GTK_RESPONSE_OK)
	{
		states = g_new0 (gchar *, 20);
		b4treeview = lookup_widget (b4dialog, "b4treeview");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b40));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 0);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[0] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b41));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 1);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[1] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b42));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 2);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[2] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b43));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 3);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[3] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b44));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 4);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[4] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b45));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 5);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[5] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b46));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 6);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[6] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b47));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 7);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[7] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b48));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 8);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[8] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b49));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 9);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[9] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b410));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 10);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[10] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b411));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 11);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[11] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b412));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 12);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[12] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b413));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 13);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[13] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b414));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 14);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[14] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b415));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 15);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[15] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b416));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 16);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[16] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b417));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 17);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[17] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b418));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 18);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
			}
		states[18] = g_strdup (check ? "1" : "0");

		states[19] = NULL;	/* terminator for g_strjoinv */
		preferences.b4columns = g_strjoinv (",", states);

		for (i = 0; i < 19; i++)
			g_free (states[i]);
		g_free (states);

		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(badif));
		if (check)
			preferences.saveasadif = 1;
		else
			preferences.saveasadif = 0;

		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu1));
		if (check)
			preferences.saveaslabels = 1;
		else
			preferences.saveaslabels = 0;
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu2));
		if (check)
			preferences.saveaslabels = preferences.saveaslabels + 2;

	}
	gtk_widget_destroy (dialogsdialog);
}
