/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>

#include "gui_helpdialog.h"
#include "support.h"

static void open_help (gchar *filename)
{
	GtkWidget *helpdialog, *helptextview, *dialog_vbox, *scrolledwindow,
		*dialog_action_area, *helpokbutton;
	GdkPixbuf *helpdialog_icon_pixbuf;
	gchar buf[80], *helpfile, *title;
	FILE *in;
	GtkTextBuffer *buffer;
	GtkTextIter iter;
	gint response;

	helpdialog = gtk_dialog_new ();
	gtk_widget_set_size_request (helpdialog, 550, 300);
	gtk_window_set_position (GTK_WINDOW (helpdialog), GTK_WIN_POS_MOUSE);
	helpdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (helpdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (helpdialog), helpdialog_icon_pixbuf);
			g_object_unref (helpdialog_icon_pixbuf);
		}

	dialog_vbox = GTK_DIALOG (helpdialog)->vbox;
	gtk_widget_show (dialog_vbox);

	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	helptextview = gtk_text_view_new ();
	gtk_widget_show (helptextview);
	gtk_container_add (GTK_CONTAINER (scrolledwindow), helptextview);

	dialog_action_area = GTK_DIALOG (helpdialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

	helpokbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (helpokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (helpdialog), helpokbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (helpokbutton, GTK_CAN_DEFAULT);

	title = g_strdup_printf ("xlog - %s", filename);
	gtk_window_set_title (GTK_WINDOW (helpdialog), title);

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(helptextview));
	gtk_text_buffer_get_start_iter (buffer, &iter);
	helpfile = g_strdup_printf ("%s%s%s", XLOG_DATADIR, G_DIR_SEPARATOR_S, 
		filename);
	gtk_text_buffer_create_tag (buffer, "bold", "weight", PANGO_WEIGHT_BOLD, NULL);
	gtk_text_buffer_create_tag (buffer, "italic", "style", PANGO_STYLE_ITALIC, NULL);
	gtk_text_buffer_create_tag (buffer, "blue", "foreground", "blue", NULL);

	in = fopen (helpfile, "r");
	if (in)
	{
		do 
		{
			if (fgets (buf, 80, in) == NULL) 
				break;
			else
			{
				if (buf[0] == '-')
					gtk_text_buffer_insert_with_tags_by_name
						(buffer, &iter, buf, -1, "bold", NULL);
				else if (buf[0] == '!')
				{
					buf[0] = ' ';
					gtk_text_buffer_insert_with_tags_by_name
						(buffer, &iter, buf, -1, "blue", NULL);
				}
				else if (buf[0] == '\t')
					gtk_text_buffer_insert_with_tags_by_name
						(buffer, &iter, buf, -1, "italic", NULL);
				else
					gtk_text_buffer_insert (buffer, &iter, buf, -1);
			}
		} 
		while (!feof (in));

		fclose (in);
	}
	g_free (helpfile);
	response = gtk_dialog_run (GTK_DIALOG(helpdialog));
	gtk_widget_destroy (helpdialog);
}

void
on_helpfaq_activate										(GtkMenuItem		 *menuitem,
																				gpointer				 user_data)
{
	open_help ("FAQ");
}


void
on_helpmanual_activate								 (GtkMenuItem		 *menuitem,
																				gpointer				 user_data)
{
	open_help ("MANUAL");
}


void
on_helptodo_activate									 (GtkMenuItem		 *menuitem,
																				gpointer				 user_data)
{
	open_help ("TODO");
}

void
on_helpthanks_activate									 (GtkMenuItem		 *menuitem,
																					gpointer				 user_data)
{
	open_help ("THANKS");
}

void
on_helpchangelog_activate									 (GtkMenuItem		 *menuitem,
																					gpointer				 user_data)
{
	open_help ("ChangeLog");
}
