/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow.c - callbacks for the main window
 *
 * these are callbacks not part of the menu, qsoframe, toolbar or list.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <hamlib/rig.h>

#include "hamlib-utils.h"
#include "callbacks_mainwindow.h"
#include "callbacks_mainwindow_toolbar.h"
#include "callbacks_mainwindow_menu.h"
#include "gui_savedialog.h"
#include "support.h"
#include "gui_utils.h"
#include "utils.h"
#include "preferences.h"
#include "log.h"
#include "gui_netkeyer.h"
#include "netkeyer.h"
#include "main.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern GtkWidget *keyerwindow;
extern preferencestype preferences;
extern keyerstatetype keyerstate;
extern statetype state;
extern GList *logwindowlist;
extern GtkUIManager *ui_manager;

/* capture the delete event and display a warning in case the log
 * has not been saved */
gboolean
on_mainwindow_delete_event (GtkWidget * widget, GdkEvent * event,
					gpointer user_data)
{
	gint i;
	logtype *logwindow;
	gboolean logchanged = FALSE;

	for (i = 0; i < g_list_length (logwindowlist); i++)
	{
		logwindow = g_list_nth_data (logwindowlist, i);
		if (logwindow->logchanged) logchanged = TRUE;
	}

	if (logchanged)
	{
		create_savedialog ();
		return (TRUE);
	}
	else
	{
		save_windowsize_and_cleanup ();
		gtk_main_quit ();
		return (FALSE);
	}
}

/* switch between pages of the notebook */
void
on_mainnotebook_switch_page (GtkNotebook * notebook, GtkNotebookPage * page,
					 gint page_num, gpointer user_data)
{
	logtype *logw = NULL;

	while (page_num >= 0)
	{
		logw = g_list_nth_data (logwindowlist, page_num);
		if (logw) break;
		page_num--;
	}

	if (logw) 
	{
		set_qsoframe (logw);
	}
}

/* catch keypresses when keyer is active, don't use PgUp/PgDn here */
gboolean
on_mainwindow_keypress (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
	GtkWidget *callentry, *rstentry, *myrstentry, *count, *stopbutton, 
		*f1button, *f2button, *f3button, *f4button, *f5button, *f6button,
		*f7button, *f8button, *f9button, *f10button, *f11button, *f12button,
		*clickallmenu;
	gchar *call, *countstr, *str;
	gint c;

	if (keyerwindow)
	switch (event->keyval)
	{
	case GDK_F1:
		f1button = lookup_widget (keyerwindow, "f1button");
		g_signal_emit_by_name (G_OBJECT (f1button), "activate");
	break;
	case GDK_F2:
		f2button = lookup_widget (keyerwindow, "f2button");
		g_signal_emit_by_name (G_OBJECT (f2button), "activate");
	break;
	case GDK_F3:
		f3button = lookup_widget (keyerwindow, "f3button");
		g_signal_emit_by_name (G_OBJECT (f3button), "activate");
	break;
	case GDK_F4:
		f4button = lookup_widget (keyerwindow, "f4button");
		g_signal_emit_by_name (G_OBJECT (f4button), "activate");
	break;
	case GDK_F5:
		f5button = lookup_widget (keyerwindow, "f5button");
		g_signal_emit_by_name (G_OBJECT (f5button), "activate");
	break;
	case GDK_F6:
		f6button = lookup_widget (keyerwindow, "f6button");
		g_signal_emit_by_name (G_OBJECT (f6button), "activate");
	break;
	case GDK_F7:
		f7button = lookup_widget (keyerwindow, "f7button");
		g_signal_emit_by_name (G_OBJECT (f7button), "activate");
	break;
	case GDK_F8:
		f8button = lookup_widget (keyerwindow, "f8button");
		g_signal_emit_by_name (G_OBJECT (f8button), "activate");
	break;
	case GDK_F9:
		f9button = lookup_widget (keyerwindow, "f9button");
		g_signal_emit_by_name (G_OBJECT (f9button), "activate");
	break;
	case GDK_F10:
		f10button = lookup_widget (keyerwindow, "f10button");
		g_signal_emit_by_name (G_OBJECT (f10button), "activate");
	break;
	case GDK_F11:
		f11button = lookup_widget (keyerwindow, "f11button");
		g_signal_emit_by_name (G_OBJECT (f11button), "activate");
	break;
	case GDK_F12:
		f12button = lookup_widget (keyerwindow, "f12button");
		g_signal_emit_by_name (G_OBJECT (f12button), "activate");
	break;
	case GDK_Escape:
		stopbutton = lookup_widget (keyerwindow, "stopbutton");
		g_signal_emit_by_name (G_OBJECT (stopbutton), "activate");
	break;
	case GDK_Return:
		myrstentry = lookup_widget (mainwindow, "myrstentry");
		callentry = lookup_widget (mainwindow, "callentry");
		if (GTK_WIDGET_HAS_FOCUS (myrstentry))
		{
			if (keyerstate.cqmode)
				cw (NULL, "cq");
			else
				cw (NULL, "sp");
			clickallmenu = gtk_ui_manager_get_widget
				(ui_manager, "/MainMenu/EditMenu/Click All");
			g_signal_emit_by_name (G_OBJECT (clickallmenu), "activate");
		}
		else if (GTK_WIDGET_HAS_FOCUS (callentry))
		{
			rstentry = lookup_widget (mainwindow, "rstentry");
			call = gtk_editable_get_chars (GTK_EDITABLE (callentry), 0, -1);
			if (strlen (call) > 0)
			{
				if (keyerstate.cqmode)
				{
					f3button = lookup_widget (keyerwindow, "f3button");
					g_signal_emit_by_name (G_OBJECT (f3button), "activate");
				}
				else
				{
					f6button = lookup_widget (keyerwindow, "f6button");
					g_signal_emit_by_name (G_OBJECT (f6button), "activate");
				}

				/* fill in defaults, check if we use a counter */
				if (g_ascii_strcasecmp (preferences.defaulttxrst, "?"))
				{
					if (g_strrstr (preferences.defaulttxrst, "#"))
					{
						count = lookup_widget (keyerwindow, "count");
						c = gtk_spin_button_get_value (GTK_SPIN_BUTTON (count));
						if (c < 10)
							countstr = g_strdup_printf ("00%d", c);
						else if (c < 100)
							countstr = g_strdup_printf ("0%d", c);
						else
							countstr = g_strdup_printf ("%d", c);
						str = my_strreplace (preferences.defaulttxrst, "#",
							countstr);
						g_free (countstr);
						gtk_entry_set_text (GTK_ENTRY (rstentry), str);
						g_free (str);
					}
					else
						gtk_entry_set_text (GTK_ENTRY (rstentry),
							preferences.defaulttxrst);
				}
				if (g_ascii_strcasecmp (preferences.defaultrxrst, "?"))
					gtk_entry_set_text (GTK_ENTRY (myrstentry),
						preferences.defaultrxrst);

				gtk_widget_grab_focus (myrstentry);
				gtk_editable_set_position (GTK_EDITABLE(myrstentry), -1);
			}
			else
			{
				if (keyerstate.cqmode)
				{	/* call CQ */
					f1button = lookup_widget (keyerwindow, "f1button");
					g_signal_emit_by_name (G_OBJECT (f1button), "activate");
				}
				else
				{
					f6button = lookup_widget (keyerwindow, "f6button");
					g_signal_emit_by_name (G_OBJECT (f6button), "activate");
				}
			}
		}
	break;
	case GDK_Up:
		if ((preferences.hamlib > 0) && (event->state & GDK_CONTROL_MASK))
		{
			if (preferences.polltime == 0)
				get_frequency ();
			set_frequency (state.rigfrequency + 50);
		}
		else
			return FALSE;
	break;
	case GDK_Down:
		if ((preferences.hamlib > 0) && (event->state & GDK_CONTROL_MASK))
		{
			if (preferences.polltime == 0)
				get_frequency ();
			set_frequency (state.rigfrequency - 50);
		}
		else
			return FALSE;
	break;
	default:
	return FALSE;
	break;
	}
	else
	switch (event->keyval)
	{
		case GDK_Up:
			if ((preferences.hamlib > 0) && (event->state & GDK_CONTROL_MASK))
			{
				if (preferences.polltime == 0)
					get_frequency ();
				set_frequency (state.rigfrequency + 50);
			}
			else
				return FALSE;
		break;
		case GDK_Down:
			if ((preferences.hamlib > 0) && (event->state & GDK_CONTROL_MASK))
			{
				if (preferences.polltime == 0)
					get_frequency ();
				set_frequency (state.rigfrequency - 50);
			}
			else
				return FALSE;
		break;
		default:
		return FALSE;
		break;
	}

	return TRUE;
}
