/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_segment.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_segment.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_SEGMENT_H
#define XMDS_SEGMENT_H

#include <xmds_element.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsSegment
// *****************************************************************************
// *****************************************************************************

//! xmds segment class
class xmdsSegment : public xmdsElement {

  public :

    //! Number of segments or current segment number (buh?)
    const unsigned long segmentNumber;

  //! Constructor of xmdsSegment object
  xmdsSegment(
              const xmdsSimulation *const yourSimulation,
              const bool& yourVerboseMode);

  //! Destructor
  ~xmdsSegment();

  //! Returns the output sample count
  virtual void outputSampleCount() const;

  //! Writes initialisation calls to file
  virtual void writeInitialisationCalls(FILE *const outfile) const;

  //! Writes destruction calls to file
  virtual void writeDestructionCalls(FILE *const outfile) const;

  //! Whether or not the segment needs to run when the simulation is in overtime
  virtual bool runsInOvertime() const = 0;
};


#endif // XMDS_SEGMENT_H
