.\" automatically generated by xml2rfc v1.23 on 02 Apr 2004 14:59:26 +0000
.\" 
.pl 10.0i
.po 0
.ll 7.2i
.lt 7.2i
.nr LL 7.2i
.nr LT 7.2i
.ds LF Rose
.ds RF FORMFEED[Page %]
.ds CF 
.ds LH README
.ds RH April 2004
.ds CH xml2rfc v1.23
.hy 0
.ad l
.nf
The README file                                                  M. Rose
                                            Dover Beach Consulting, Inc.
                                                           April 2, 2004


.ce
xml2rfc v1.23

.in 3

.ti 0
Table of Contents

.nf
   1.    Introduction . . . . . . . . . . . . . . . . . . . . . . . .  2
   2.    Requirements . . . . . . . . . . . . . . . . . . . . . . . .  3
   3.    Testing  . . . . . . . . . . . . . . . . . . . . . . . . . .  4
   3.1   Testing under a windowing system . . . . . . . . . . . . . .  4
   3.2   Testing without a windowing system . . . . . . . . . . . . .  4
   4.    Next steps . . . . . . . . . . . . . . . . . . . . . . . . .  5
   4.1   Processing Instructions  . . . . . . . . . . . . . . . . . .  5
   4.1.1 Option Settings  . . . . . . . . . . . . . . . . . . . . . .  5
   4.1.2 Include Files  . . . . . . . . . . . . . . . . . . . . . . .  7
   5.    Additions to RFC 2629  . . . . . . . . . . . . . . . . . . .  8
   6.    Limitations of xml2rfc . . . . . . . . . . . . . . . . . . .  9
   7.    References . . . . . . . . . . . . . . . . . . . . . . . . .  9
         Author\'s Address . . . . . . . . . . . . . . . . . . . . . .  9
   A.    MacOS 9 Installation (courtesy of Ned Freed) . . . . . . . . 10
   B.    rfc2629.xslt (courtesy of Julian Reschke)  . . . . . . . . . 11
   C.    Copyrights . . . . . . . . . . . . . . . . . . . . . . . . . 12
.bp
.fi
.in 4
.ti 0
1.  Introduction
.in 3

This is a package to convert memos written in XML to the RFC format.

If you don\'t want to install any software, you can use the <http://
xml.resource.org/>.
.bp
.in 4
.ti 0
2.  Requirements
.in 3

You need to have Tcl/Tk version 8 running on your system. Tcl is a
scripting language, Tk is Tcl with support for your windowing system.

To get a source or binary distribution for your system, go to the
<http://www.scriptics.com/software/tcltk/8.4.html> and install it. If
you get the binary distribution, this is pretty simple.

Of course, you may already have Tcl version 8. To find out, try
typing this command from the shell (or the "MS-DOS Prompt"):
.nf

    % tclsh

.fi
If the program launches, you\'re good to go with Tcl version 8.

If you are running under a windowing system (e.g., X or Windows), you
can also try:
.nf

.in 3
    % wish

.fi
If a new window comes up along with a "Console" window, then you\'re
good to go with Tk version 8.

Finally, you may notice a file called "xml2sgml.tcl" in the
distribution. It contains some extra functionality for a few special
users -- so, if you don\'t know what it is, don\'t worry about it...
.bp
.in 4
.ti 0
3.  Testing
.in 3

Now test your installation.

.in 5
.ti 0
3.1  Testing under a windowing system
.in 3

Type this command from the shell:
.nf

    % xml2rfc.tcl

.fi
A new window should come up that looks like this:
.nf

.in 3
    +------------------------------------------------------------+
    |                     Convert XML to RFC                     |
    |                                                            |
    |  Select input file: ____________________________  [Browse] |
    |                                                            |
    | Select output file: ____________________________  [Browse] |
    |                                                            |
    |               [Convert]               [Quit]               |
    |                                                            |
    +------------------------------------------------------------+

.fi
Fill-in the blanks and click on [Convert].

.in 5
.ti 0
3.2  Testing without a windowing system
.in 3

Type this command from the shell:
.nf

    % tclsh

.fi
If the program launches, type this command to it:
.nf

.in 3
    % source xml2rfc.tcl

.fi
and you should see these four lines:
.nf

.in 3
    invoke as "xml2rfc   inputfile outputfile"
           or "xml2txt   inputfile"
           or "xml2html  inputfile"
           or "xml2nroff inputfile"

.bp
.fi
.in 4
.ti 0
4.  Next steps
.in 3

Read the <draft-mrose-writing-rfcs.html> document. In particular,
<draft-mrose-writing-rfcs.html#anchor13> has some good information.

.in 5
.ti 0
4.1  Processing Instructions
.in 3

A *processing instruction* is a directive to an XML application. If
you want to give directives to \'xml2rfc\', the processing instructions
(PIs) look like this:
.nf

    <?rfc keyword=\'value\'?>

.fi
Of course, if you like the default behavior, you don\'t need any PIs
in your input file!

.in 7
.ti 0
4.1.1  Option Settings
.in 3

.nf
The list of valid keywords are:

   +--------------+--------------+-------------------------------------+
   |      keyword |    default   | meaning                             |
   +--------------+--------------+-------------------------------------+
   |       strict |      no      | try to enforce the ID-nits          |
   |              |              | conventions and DTD validity        |
   |              |              |                                     |
   |  iprnotified |      no      | include boilerplate from Section    |
   |              |              | 10.4(d) of [1]                      |
   |              |              |                                     |
   |   linkmailto |      yes     | generate mailto: URL, as            |
   |              |              | appropriate                         |
   |              |              |                                     |
   |      compact |      no      | when producing a txt/nroff file,    |
   |              |              | try to conserve vertical whitespace |
   |              |              |                                     |
   |   subcompact |    compact   | if compact is "yes", then you can   |
   |              |              | make things a little less compact   |
   |              |              | by setting this to "no"             |
   |              |              |                                     |
   |          toc |      no      | generate a table-of-contents        |
   |              |              |                                     |
   |    tocompact |      yes     | if toc is "yes", then setting this  |
   |              |              | to "no" will make it a little less  |
   |              |              | compact                             |
   |              |              |                                     |
   |     tocdepth |       3      | if toc is "yes", then this          |
   |              |              | determines the depth of the         |
   |              |              | table-of-contents                   |
.bp
   |              |              |                                     |
   |    tocindent |      no      | if toc is "yes", then setting this  |
   |              |              | to "yes" will indent subsections in |
   |              |              | the table-of-contents               |
   |              |              |                                     |
   |      editing |      no      | insert editing marks for ease of    |
   |              |              | discussing draft versions           |
   |              |              |                                     |
   |      private |      ""      | produce a private memo rather than  |
   |              |              | an RFC or Internet-Draft.           |
   |              |              |                                     |
   |       header |      ""      | override the leftmost header string |
   |              |              |                                     |
   |       footer |      ""      | override the center footer string   |
   |              |              |                                     |
   |       slides |      no      | when producing an html file,        |
   |              |              | produce multiple files for a slide  |
   |              |              | show                                |
   |              |              |                                     |
   |     sortrefs |      no      | sort references                     |
   |              |              |                                     |
   |      symrefs |      no      | use anchors rather than numbers for |
   |              |              | references                          |
   |              |              |                                     |
   |     topblock |      yes     | put the famous header block on the  |
   |              |              | first page                          |
   |              |              |                                     |
   |   background |      ""      | when producing an html file, use    |
   |              |              | this image                          |
   |              |              |                                     |
   |    needLines |      n/a     | an integer hint indicating how many |
   |              |              | contiguous lines are needed at this |
   |              |              | point in the output                 |
   +--------------+--------------+-------------------------------------+

.fi
Remember, that as with everything else in XML, keywords and values
are case-sensitive.

With the exception of the \'needLines\' PI, you normally put all of
these processing instructions at the beginning of the document (right
after the XML declartion).
.bp
.in 7
.ti 0
4.1.2  Include Files
.in 3

\'xml2rfc\' has an include-file facility, e.g.,
.nf

    <?rfc include=\'file\'?>

\'xml2rfc\'
.fi
will consult the $XML_LIBRARY environment variable for a search path
of where to look for files. (If this envariable isn\'t set, the
directory containing the file that contains the include-file
directive is used.)

You can also have \'xml2rfc\' set this envariable directly, by creating
a file called ".xml2rfc.rc" in the directory where your main file is,
e.g.,
.nf

.in 3
global env tcl_platform

if {![string compare $tcl_platform(platform) windows]} {
    set sep ";"
} else {
    set sep ":"
}

if {[catch { set env(XML_LIBRARY) } library]} {
    set library ""
    foreach bibxmlD [lsort -dictionary \\
                           [glob -nocomplain $HOME/rfcs/bibxml/*]] {
        append library $sep$bibxmlD
    }
}

set nativeD [file nativename $inputD]
if {[lsearch [split $library $sep] $nativeD] < 0} {
    set library "$nativeD$sep$library"
}

set env(XML_LIBRARY) $library

.fi
There are links to various bibliographic databases (RFCs, I-Ds, and
so on) on the \'xml2rfc\'<http://xml.resource.org/>.
.bp
.in 4
.ti 0
5.  Additions to RFC 2629
.in 3

A few additions have been made to the format originally defined in
RFC 2629. In particular, <draft-mrose-writing-rfcs.html#anchor19> of
the 2629bis document enumerates the additions.

In addition, \'xml2rfc\' recognizes an undocumented \'src\' attribute in
the \'artwork\' element, but only if HTML is being generated, e.g.,
.nf

       <figure><artwork src=\'layers.gif\' /></figure>

.fi
In this case, an \'img\' tag is placed in the HTML output, and the
textual contents of the \'artwork\', \'preamble\', and \'postamble\'
elements are ignored.
.bp
.in 4
.ti 0
6.  Limitations of xml2rfc
.in 3

.in 6
.ti 3
o  The \'figure\' element\'s \'title\' attribute is ignored, except when
generating HTML.

.ti 3
o  The \'xref\' element\'s \'pageno\' attribute is ignored.

.in 3

.ti 0
7  References

.in 8
.ti 3
[1]  Bradner, S., "The Internet Standards Process -- Revision 3", BCP
9, RFC 2026, October 1996.


.in 3
.nf
.ti 0
Author\'s Address

Marshall T. Rose
Dover Beach Consulting, Inc.
POB 255268
Sacramento, CA  95865-5268
US

Phone: +1 916 483 8878
EMail: mrose@dbc.mtview.ca.us
.bp
.fi
.in 13
.ti 0
Appendix A.  MacOS 9 Installation (courtesy of Ned Freed)
.in 3

.in 7
.ti 3
1.  Install Tcl/Tk 8.3.4

.ti 3
2.  When you performed Step 1, a folder in your "Extensions" folder
called "Tool Command Language" was created. Create a new folder
under "Extensions", with any name you like.

.ti 3
3.  Drag the file "xml2rfc.tcl" onto the "Drag & Drop Tclets"
application that was installed in Step 1.

.ti 3
4.  When asked for an appropriate "wish" stub, select "Wish 8.3.4".

.ti 3
5.  The "Drap & Drop Tclets" application will write out an executable
version of \'xml2rfc\'.

.in 3
.bp
.in 13
.ti 0
Appendix B.  rfc2629.xslt (courtesy of Julian Reschke)
.in 3

The file "rfc2629.xslt" can be used with an XSLT-capable formatter
(i.e., IE6) to produce HTML. A word of warning though: the XSLT
script doesn\'t support the processing instructions discussed earlier
(Section 4.1).
.bp
.in 13
.ti 0
Appendix C.  Copyrights
.in 3

(c) 2003 Marshall T. Rose

Hold harmless the author, and any lawful use is allowed.
.bp
