#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "globals.h"
#include "graphics.h"
#include "interface-xmms.h"

gboolean slidetemp,ratiotemp,skintemp,fstemp,isearchtemp,titletemp,smart_temp,getalltemp,autohidetemp,buttontemp;
gint slidespeedtemp;
GtkWidget *fontsel,*fontuse,*emptyimage,*titleformat,*imagedirectory,*imagekeywords,
		*scriptnet,*searchorder,*smartsearch,*getall,*autohide;
GtkAdjustment *slidespeed;

void killconf(GtkWidget *widget)
	{
	gtk_widget_destroy(widget);
	conf=FALSE;
	}

void offconf(GtkWidget *widget)
	{ gchar *temp;
	auto_hide=autohidetemp;
	title_display=titletemp;
	ratio=ratiotemp;
	slide=slidetemp;
	skinned=skintemp;
	show_button=buttontemp;
	internet_search=isearchtemp;
	slide_speed=slidespeed->value*1000;
	smart_search=smart_temp;
	if (getalltemp) get_all=strdup("1");
		else get_all=strdup("0");

	if (fullscreen!=fstemp)
    {
		fullscreen=fstemp;
		if (fullscreen)
			{
			Xwin=xwin; Ywin=ywin;
			xwin=gdk_screen_width(); ywin=gdk_screen_height();
			Posx=posx; Posy=posy;
			posx=0; posy=0;
			}
		else
			{
			xwin=Xwin; ywin=Ywin;
			Xwin=gdk_screen_width(); Ywin=gdk_screen_height();
			posx=Posx; posy=Posy;
			Posx=0; Posy=0;
			}
		gdk_window_move_resize(window->window,posx,posy, xwin,ywin);
		coview_init_imagebuffer();
	}

	imcount=0;
	redrawskin=TRUE;
	temp=gtk_entry_get_text((GtkEntry *)fontuse);
	fontname=strdup(temp);

	temp=gtk_entry_get_text((GtkEntry *)emptyimage);
	empty_picture=strdup(temp);

	temp=gtk_entry_get_text((GtkEntry *)imagedirectory);
	image_dir=strdup(temp);

	temp=gtk_entry_get_text((GtkEntry *)imagekeywords);
	image_keywords=strdup(temp);

	temp=gtk_entry_get_text((GtkEntry *)scriptnet);
	script_net=strdup(temp);

	temp=gtk_entry_get_text((GtkEntry *)titleformat);
	title_format=strdup(temp);
	
	temp=gtk_entry_get_text((GtkEntry *)searchorder);
	search_order=strdup(temp);

	write_xmms_config();
	gtk_widget_destroy(widget);
	conf=FALSE;
	}
	
void ratio_toggled()
	{
	if (ratiotemp)
		{ratiotemp=FALSE;}
	else {ratiotemp=TRUE;}
	}
	
void slide_toggled()
	{
	if (slidetemp)
		{slidetemp=FALSE;}
	else {slidetemp=TRUE;}
	}

void smart_toggled()
	{
	if (smart_temp)
		{smart_temp=FALSE;}
	else {smart_temp=TRUE;}
	}

void getall_toggled()
	{
	if (getalltemp)
		{getalltemp=FALSE;}
	else {getalltemp=TRUE;}
	}
	
void title_toggled()
	{
	if (titletemp)
		{titletemp=FALSE;}
	else {titletemp=TRUE;}
	}

void fs_toggled()
	{
	if (fstemp)
		{fstemp=FALSE;}
	else {fstemp=TRUE;}
	}

void skin_toggled()
	{
	if (skintemp)
		{skintemp=FALSE;}
	else {skintemp=TRUE;}
	}

void button_toggled()
	{
	if (buttontemp)
		{buttontemp=FALSE;}
	else {buttontemp=TRUE;}
	}
	
void isearch_toggled()
	{
	if (isearchtemp)
		{isearchtemp=FALSE;}
	else {isearchtemp=TRUE;}
	}
	
void hide_toggled()
	{
	if (autohidetemp)
		{autohidetemp=FALSE;}
	else {autohidetemp=TRUE;}
	}


void font_browse_ok(GtkWidget * w, gpointer data)
	{GtkFontSelectionDialog *fontsel = GTK_FONT_SELECTION_DIALOG(data);
        gchar *fntname;

        fntname = gtk_font_selection_dialog_get_font_name(fontsel);
        if (fntname) {gtk_entry_set_text(GTK_ENTRY(fontuse), fntname);}
        gtk_widget_destroy(GTK_WIDGET(fontsel));
}

void selfont(GtkWidget * w, gpointer data)
	{ static GtkWidget *fontsel;
	if (!fontsel)
	{
	fontsel = gtk_font_selection_dialog_new("Select title font:");
	gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fontsel), gtk_entry_get_text(GTK_ENTRY(fontuse)));
	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontsel)->ok_button), "clicked", GTK_SIGNAL_FUNC(font_browse_ok), fontsel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontsel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(fontsel));
	gtk_signal_connect(GTK_OBJECT(fontsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &fontsel);
	gtk_widget_show(fontsel);
        }
}

void dir_browse_ok(GtkWidget * w, gpointer data)
	{GtkFileSelection *dirsel = GTK_FILE_SELECTION(data);
        gchar *dirname,*pos;

        dirname = gtk_file_selection_get_filename(dirsel);
        if (dirname) {
		pos=strrchr(dirname,'/');
		pos[1]=0;
		gtk_entry_set_text(GTK_ENTRY(imagedirectory), dirname);
		}
        gtk_widget_destroy(GTK_WIDGET(dirsel));
	}

void seldir(GtkWidget * w, gpointer data)
	{ static GtkWidget *dirsel;
	if (!dirsel)
	{
	dirsel = gtk_file_selection_new("Select Images Directory");
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(dirsel), gtk_entry_get_text(GTK_ENTRY(imagedirectory)));
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->ok_button), "clicked", GTK_SIGNAL_FUNC(dir_browse_ok), dirsel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dirsel));
	gtk_signal_connect(GTK_OBJECT(dirsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &dirsel);
	gtk_widget_show(dirsel);
        }
	}

void im_browse_ok(GtkWidget * w, gpointer data)
	{GtkFileSelection *dirsel = GTK_FILE_SELECTION(data);
        gchar *dirname;

        dirname = gtk_file_selection_get_filename(dirsel);
        if (dirname) {
		gtk_entry_set_text(GTK_ENTRY(emptyimage), dirname);
		}
        gtk_widget_destroy(GTK_WIDGET(dirsel));
	}

void selim(GtkWidget * w, gpointer data)
	{ static GtkWidget *dirsel;
	if (!dirsel)
	{
	dirsel = gtk_file_selection_new("Select Default Image");
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(dirsel), gtk_entry_get_text(GTK_ENTRY(emptyimage)));
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->ok_button), "clicked", GTK_SIGNAL_FUNC(im_browse_ok), dirsel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dirsel));
	gtk_signal_connect(GTK_OBJECT(dirsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &dirsel);
	gtk_widget_show(dirsel);
        }
	}

void scr_browse_ok(GtkWidget * w, gpointer data)
	{GtkFileSelection *dirsel = GTK_FILE_SELECTION(data);
        gchar *dirname;

        dirname = gtk_file_selection_get_filename(dirsel);
        if (dirname) {
		gtk_entry_set_text(GTK_ENTRY(scriptnet), dirname);
		}
        gtk_widget_destroy(GTK_WIDGET(dirsel));
	}

void selscript(GtkWidget * w, gpointer data)
	{ static GtkWidget *dirsel;
	if (!dirsel)
	{  
	dirsel = gtk_file_selection_new("Select Internet Script");
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(dirsel), gtk_entry_get_text(GTK_ENTRY(scriptnet)));
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->ok_button), "clicked", GTK_SIGNAL_FUNC(scr_browse_ok), dirsel);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(dirsel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dirsel));
	gtk_signal_connect(GTK_OBJECT(dirsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &dirsel);
	gtk_widget_show(dirsel);
        }
	}


void conf_window()
	{GtkWidget *dialog, *frameopt,*frametitle,*framenet,*ratiob,*slideb,*skinb,*titleb,*fsb,*isearchb,*speedb,*buttonb,
			*font_button,*okay_button,*cancel_button,
			*box,*box2,*box3,*label,*confwin_notebook;
 
	if (!config_loaded)
		read_xmms_config();
	dialog = gtk_dialog_new();
	confwin_notebook = gtk_notebook_new();
	//confwin_box = gtk_vbox_new(FALSE, 10);
	//gtk_box_pack_start(GTK_BOX(conf_box), confwin_notebook, TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),confwin_notebook);
		
	// The "Display page"
	frameopt=gtk_frame_new((gchar *) "Display options");
			ratiob=gtk_check_button_new_with_label ((gchar *) "Preserve images ratio");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (ratiob),ratio);
			ratiotemp=ratio;
			gtk_signal_connect (GTK_OBJECT (ratiob), "toggled",GTK_SIGNAL_FUNC (ratio_toggled),NULL);

			slideb=gtk_check_button_new_with_label ((gchar *) "Enable slideshow");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (slideb),slide);
			slidetemp=slide;
			gtk_signal_connect (GTK_OBJECT (slideb), "toggled",GTK_SIGNAL_FUNC (slide_toggled),NULL);
		
			slidespeed=(GtkAdjustment *) gtk_adjustment_new(slide_speed/1000,0.100,10,0.100,0,0);
			speedb=gtk_hscale_new(slidespeed);

			skinb=gtk_check_button_new_with_label ((gchar *) "Enable skin");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (skinb),skinned);
			skintemp=skinned;
			gtk_signal_connect (GTK_OBJECT (skinb), "toggled",GTK_SIGNAL_FUNC (skin_toggled),NULL);

			buttonb=gtk_check_button_new_with_label ((gchar *) "Enable Buttons");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (buttonb),show_button);
			buttontemp=show_button;
			gtk_signal_connect (GTK_OBJECT (buttonb), "toggled",GTK_SIGNAL_FUNC (button_toggled),NULL);

			titleb=gtk_check_button_new_with_label ((gchar *) "Enable title");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (titleb),title_display);
			titletemp=title_display;
			gtk_signal_connect (GTK_OBJECT (titleb), "toggled",GTK_SIGNAL_FUNC (title_toggled),NULL);

			fsb=gtk_check_button_new_with_label ((gchar *) "Fullscreen");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (fsb),fullscreen);
			fstemp=fullscreen;
			gtk_signal_connect (GTK_OBJECT (fsb), "toggled",GTK_SIGNAL_FUNC (fs_toggled),NULL);

			autohide=gtk_check_button_new_with_label ((gchar *) "Hide coverviewer when no image available");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (autohide),auto_hide);
			autohidetemp=auto_hide;
			gtk_signal_connect (GTK_OBJECT (autohide), "toggled",GTK_SIGNAL_FUNC (hide_toggled),NULL);

			imagekeywords=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)imagekeywords,(gchar *) image_keywords);

			emptyimage=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)emptyimage,(gchar *) empty_picture);

			imagedirectory=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)imagedirectory,(gchar *) image_dir);

			scriptnet=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)scriptnet,(gchar *) script_net);

			box=gtk_vbox_new((gboolean) FALSE, 5);
			gtk_box_pack_start(GTK_BOX (box), ratiob,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), slideb,FALSE,TRUE,0);
			label=gtk_label_new((gchar*)"Slideshow delay (seconds) : ");
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), speedb,FALSE,TRUE,0);
			label=gtk_label_new((gchar*)"Images order priority");
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), imagekeywords,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), skinb,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), buttonb,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), fsb,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), autohide,FALSE,TRUE,0);
			label=gtk_label_new((gchar*)"Default image : ");
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			box2=gtk_hbox_new((gboolean) FALSE, 5);
			font_button=gtk_button_new_with_label((gchar *) " Select ");
			gtk_signal_connect_object (GTK_OBJECT (font_button), "clicked",GTK_SIGNAL_FUNC (selim),NULL);
			gtk_widget_set_usize(font_button, 85, 17);
			gtk_box_pack_start(GTK_BOX (box2), emptyimage,TRUE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box2), font_button,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), box2,FALSE,TRUE,0);
			gtk_container_add (GTK_CONTAINER (frameopt), box);
			gtk_container_set_border_width (GTK_CONTAINER (box), 5);
	
			gtk_notebook_append_page(GTK_NOTEBOOK(confwin_notebook), frameopt, gtk_label_new("Display"));

	// The Internet page
	framenet=gtk_frame_new((gchar *) "Internet options");
			box=gtk_vbox_new((gboolean) FALSE, 5);

			// ENABLE INTERNET SEARCH -> BOX
			isearchb=gtk_check_button_new_with_label ((gchar *) "Auto Internet Search");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (isearchb),internet_search);
			isearchtemp=internet_search;
			gtk_signal_connect (GTK_OBJECT (isearchb), "toggled",GTK_SIGNAL_FUNC (isearch_toggled),NULL);
			gtk_box_pack_start(GTK_BOX (box), isearchb,FALSE,TRUE,0);
			//SMART SEARCH (STREAMS / NO ALBUM)
			smartsearch=gtk_check_button_new_with_label ((gchar *) "Try to find covers for stream and files without album name");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (smartsearch),smart_search);
			gtk_signal_connect (GTK_OBJECT (smartsearch), "toggled",GTK_SIGNAL_FUNC (smart_toggled),NULL);
			smart_temp=smart_search;
			gtk_box_pack_start(GTK_BOX (box), smartsearch,FALSE,TRUE,0);
			//GET FROM ALL SITE
			getall=gtk_check_button_new_with_label ((gchar *) "Retrieve from all sites (instead of stopping after first cover found)");
			if (strcmp(get_all,"0")==0) getalltemp=FALSE;
				else  getalltemp=TRUE;
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (getall),getalltemp);
			gtk_signal_connect (GTK_OBJECT (getall), "toggled",GTK_SIGNAL_FUNC (getall_toggled),NULL);

			gtk_box_pack_start(GTK_BOX (box), getall,FALSE,TRUE,0);

			// IMAGE DIRECTORY -> BOX2 -> BOX
			label=gtk_label_new((gchar*)"Images directory : ");
			box2=gtk_hbox_new((gboolean) FALSE, 5);
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			font_button=gtk_button_new_with_label((gchar *) " Select ");
			gtk_signal_connect_object (GTK_OBJECT (font_button), "clicked",GTK_SIGNAL_FUNC (seldir),NULL);
			gtk_widget_set_usize(font_button, 85, 17);
			gtk_box_pack_start(GTK_BOX (box2), imagedirectory,TRUE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box2), font_button,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), box2,FALSE,TRUE,0);

			//INTERNET SEARCH SCRIPT ->BOX2 -> BOX
			/*label=gtk_label_new((gchar*)"Internet search script : ");
			box2=gtk_hbox_new((gboolean) FALSE, 5);
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			font_button=gtk_button_new_with_label((gchar *) " Select ");
			gtk_signal_connect_object (GTK_OBJECT (font_button), "clicked",GTK_SIGNAL_FUNC (selscript),NULL);
			gtk_widget_set_usize(font_button, 85, 17);
			gtk_box_pack_start(GTK_BOX (box2), scriptnet,TRUE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box2), font_button,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box), box2,FALSE,TRUE,0);*/

			//SEARCH ORDER
			label=gtk_label_new((gchar*)"Internet search order");
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
			searchorder=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)searchorder,(gchar *) search_order);
			gtk_box_pack_start(GTK_BOX (box), searchorder,FALSE,TRUE,0);
			label=gtk_label_new((gchar*)"1 Amazon.com - 2 Amazon.fr\n3 Darktown.com - 4 Images.google.com\n5 Coveralia.wom");
			gtk_box_pack_start(GTK_BOX (box), label,FALSE,TRUE,0);
					
		gtk_container_add (GTK_CONTAINER (framenet), box);
		gtk_container_set_border_width (GTK_CONTAINER (box), 5);
		gtk_notebook_append_page(GTK_NOTEBOOK(confwin_notebook), framenet, gtk_label_new("Internet"));

	// The title page
	frametitle=gtk_frame_new((gchar *) "Title options");
			box3=gtk_vbox_new((gboolean) FALSE, 5);
			//ENABLE TITLE
			gtk_box_pack_start(GTK_BOX (box3), titleb,FALSE,TRUE,0);

			//FONT
			label=gtk_label_new((gchar*)"Font : ");
			gtk_box_pack_start(GTK_BOX (box3), label,FALSE,TRUE,0);
			box2=gtk_hbox_new((gboolean) FALSE, 5);
			fontuse=gtk_entry_new();
			font_button=gtk_button_new_with_label((gchar *) " Select ");
			gtk_signal_connect_object (GTK_OBJECT (font_button), "clicked",GTK_SIGNAL_FUNC (selfont),NULL);
			gtk_widget_set_usize(font_button, 85, 17);
			gtk_entry_set_text((GtkEntry *)fontuse,(gchar *) fontname);
			gtk_widget_set_usize(fontuse, 300, 25);
			gtk_box_pack_start(GTK_BOX (box2), fontuse,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box2), font_button,FALSE,TRUE,0);
			gtk_container_set_border_width (GTK_CONTAINER (box2), 0);
			gtk_box_pack_start(GTK_BOX (box3), box2,FALSE,TRUE,0);

			//TITLE FORMAT
			titleformat=gtk_entry_new();
			gtk_entry_set_text((GtkEntry *)titleformat,(gchar *) title_format);
			label=gtk_label_new((gchar*)"Title display : ");
			gtk_box_pack_start(GTK_BOX (box3), label,FALSE,TRUE,0);
			gtk_box_pack_start(GTK_BOX (box3), titleformat,FALSE,TRUE,0);
			label=gtk_label_new((gchar*)"\%t for title - \%s for artist\n\%a for album - \%n for track");
			gtk_box_pack_start(GTK_BOX (box3), label,FALSE,TRUE,0);
			gtk_container_set_border_width (GTK_CONTAINER (box3), 5);
		gtk_container_add (GTK_CONTAINER (frametitle), box3);
		gtk_notebook_append_page(GTK_NOTEBOOK(confwin_notebook), frametitle, gtk_label_new("Title"));

	gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), 10);

	okay_button = gtk_button_new_with_label("Ok");
	cancel_button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",	GTK_SIGNAL_FUNC (offconf), (GtkObject *) dialog);
	gtk_signal_connect_object (GTK_OBJECT (cancel_button),"clicked",GTK_SIGNAL_FUNC (killconf),(GtkObject *)dialog);
	gtk_signal_connect_object (GTK_OBJECT (dialog),"destroy",GTK_SIGNAL_FUNC (killconf),(GtkObject *)dialog);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),okay_button);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),cancel_button);

	gtk_widget_show_all (dialog);
	gtk_window_set_title((GtkWindow *) dialog,(gchar *)"CoverViewer Configuration");
	//gtk_widget_set_usize(dialog,400,250);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
	}
