/*  xmms - graphically mp3 player..
 *  Copyright (C) 1998-1999  Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef WAV_H
#define WAV_H

#include <pthread.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "xmms/plugin.h"


extern InputPlugin mid_ip;
extern void show_mid_volume(int channel);
typedef struct
{
	FILE	*file;
	short	format_tag,channels,block_align,bits_per_sample,eof,going;
	long	samples_per_sec,avg_bytes_per_sec;
	int	position,length;
	int	seek_to,data_offset;
	pid_t	pid;
} WaveFile;

extern WaveFile *wav_file;

extern unsigned int total_time;
extern int vu_level[16], vu_delta[16];

void mid_init(void);
int is_our_file(char *filename);
void play_file(char *filename);
void stop(void);
void seek(int time);
void plugin_mid_pause(short p);
int get_time(void);
void set_prog_name(int c, int n);
void mid_note(int c, int n, int o);
#endif
