#ifndef _XS_CURVE_H
#define _XS_CURVE_H

#include <gdk/gdk.h>
#include <gtk/gtkdrawingarea.h>

#ifdef __cplusplus
extern "C" {
#endif


#define XS_TYPE_CURVE			(xs_curve_get_type())
#define XS_CURVE(obj)			(GTK_CHECK_CAST ((obj), XS_TYPE_CURVE, XSCurve))
#define XS_CURVE_CLASS(luokka)		(GTK_CHECK_CLASS_CAST ((luokka), XS_TYPE_CURVE, XSCurveClass))
#define XS_IS_CURVE(obj)		(GTK_CHECK_TYPE ((obj), XS_TYPE_CURVE))
#define XS_IS_CURVE_CLASS(luokka)	(GTK_CHECK_CLASS_TYPE ((luokka), XS_TYPE_CURVE))


typedef struct _XSCurve	XSCurve;
typedef struct _XSCurveClass	XSCurveClass;

typedef struct {
	gfloat x,y;
} t_xs_point;


struct _XSCurve {
	GtkDrawingArea graph;

	gint cursor_type;
	gfloat min_x;
	gfloat max_x;
	gfloat min_y;
	gfloat max_y;
	GdkPixmap *pixmap;
	gint height;		/* (cached) graph height in pixels */
	gint grab_point;	/* point currently grabbed */
	gint last;

	/* control points */
	gint num_ctlpoints;	/* number of control points */
	t_xs_point *ctlpoints;	/* array of control points */
};

struct _XSCurveClass {
	GtkDrawingAreaClass parent_class;
};


GtkType		xs_curve_get_type	(void);
GtkWidget*	xs_curve_new		(void);
void		xs_curve_reset		(XSCurve *curve);
void		xs_curve_set_range	(XSCurve *curve,
					 gfloat min_x, gfloat max_x,
					 gfloat min_y, gfloat max_y);

#ifdef __cplusplus
}
#endif

#endif /* _XS_CURVE_H */
