/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_KARAOKE_WINDOW_STATUS_H__
#define __DISPLAYER_KARAOKE_WINDOW_STATUS_H__

#include <gtk/gtkwidget.h>

#include "singit_song.h"

typedef struct {

	GtkWidget *karaoke_widget;

	guint timestamp_context_id;
	guint song_context_id;
	gint messageCounter;
	gint jump_to_song;

	gboolean canChangeVisibility;
	gboolean isVisible;

	gchar *fileName;
	SingitSong *song;

	gboolean print_debug;
	gboolean toggle_yz;
	gboolean guess_synced_lyrics;
	gboolean show_jumping_ball;
	gboolean hide_if_not_found;
	gboolean auto_resize;

}
KaraokeWindowStatus;

extern KaraokeWindowStatus karaoke_window_status;

#define DEBUG(x)  { if (karaoke_window_status.print_debug) debug x; }
#define PERROR(x) { if (karaoke_window_status.print_debug) perror(x); }

void displayer_karaoke_window_status_init(void);
void displayer_karaoke_window_status_finish(void);

#endif // __DISPLAYER_KARAOKE_WINDOW_STATUS_H__
