/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <stdlib.h>
#include <stdio.h>

#include <xmms/xmmsctrl.h>
#include <xmms/util.h>

#include "singit_displayer_plugin.h"
#include "displayer_test_msg_status.h"

#include "singit_config.h"

#include "singit_dialogs.h"

static void displayer_test_msg_init(void);
static void displayer_test_msg_finish(void);

static void displayer_test_msg_show(SingitSong *cur_song);
static void displayer_test_msg_hide(SingitSong *cur_song);

static void displayer_test_msg_set_time(guint time, SingitSong *cur_song, GList *real_next);

static void displayer_test_msg_playback_start(void);
static void displayer_test_msg_playback_stop(void);

static void displayer_test_msg_config_update(const SingitConfigData *singit_config);

DisplayerPlugin test_msg_dp =
{
	NULL,
	NULL,
	0,

	"Test MSG displayer",

	displayer_test_msg_init,
	displayer_test_msg_show,
	displayer_test_msg_hide,
	NULL,
	displayer_test_msg_finish,

	NULL,

	displayer_test_msg_config_update,

	displayer_test_msg_set_time,

	NULL,
	NULL,
	displayer_test_msg_playback_start,
	displayer_test_msg_playback_stop,

	NULL,
	NULL
};

DIPSPLAYER_SYMBOL(libdisplayer_test_msg, test_msg_dp)

static gint displayer_test_msg_disable_func(gpointer data)
{
	GDK_THREADS_ENTER();
	test_msg_dp.disable(&test_msg_dp);
	GDK_THREADS_LEAVE();
	return (FALSE);
}

static gboolean displayer_test_msg_event_thread_func(gpointer data)
{
	gboolean result = TRUE;

	if (!displayer_test_msg_status.kill) {

	}

	if (displayer_test_msg_status.kill) {
		displayer_test_msg_status.timeout = 0;
		displayer_test_msg_status.kill = FALSE;

		g_print("  Quit render thread\n");

		result = FALSE;
	}

	return result;
}

static inline gboolean shutdown_gtk_render_idle(void)
{
	if (displayer_test_msg_status.timeout != 0) {
		g_print("  Kill render thread\n");

		displayer_test_msg_status.kill = TRUE;

//		GDK_THREADS_ENTER();
#ifdef USE_GTK_TIMEOUT
		gtk_timeout_remove(displayer_test_msg_status.timeout);
#else
		gtk_idle_remove(displayer_test_msg_status.timeout);
#endif
//		GDK_THREADS_LEAVE();
		displayer_test_msg_status.timeout = 0;
		return TRUE;
	}
	return FALSE;
}

static inline gboolean set_gtk_render_idle(const gboolean start)
{
	if ((start == TRUE) && (displayer_test_msg_status.timeout == 0) &&
		((displayer_test_msg_status.xmms_playing == FALSE) ||
		(displayer_test_msg_status.singit_playing == TRUE)))
	{
		g_print("  Start render thread\n");

		displayer_test_msg_status.kill = FALSE;
		displayer_test_msg_status.timeout =
#ifdef USE_GTK_TIMEOUT
			gtk_timeout_add(50, displayer_test_msg_event_thread_func, NULL);
#else
			gtk_idle_add(displayer_test_msg_event_thread_func, NULL);
#endif
		return TRUE;
	}
	else {
		if ((displayer_test_msg_status.xmms_playing == TRUE) &&
			!xmms_remote_is_paused(test_msg_dp.xmms_session))
		{
			return shutdown_gtk_render_idle();
		}
		return FALSE;
	}
}

static void displayer_test_msg_init(void)
{
	g_print("displayer_test_msg.c [displayer_test_msg_init]\n");

	displayer_test_msg_status_init();

	g_print("  Start idle\n");

	set_gtk_render_idle(TRUE);
}

static void displayer_test_msg_finish(void)
{
	g_print("displayer_test_msg.c [displayer_test_msg_finish]\n");

	shutdown_gtk_render_idle();

	displayer_test_msg_status_finish();
}

static void displayer_test_msg_show(SingitSong *cur_song)
{
	g_print("displayer_test_msg.c [displayer_test_msg_show]: ");

	if (!xmms_remote_is_paused(test_msg_dp.xmms_session) &&
		(set_gtk_render_idle(FALSE)))
	{
		g_print("Real\n");
	}
	else {
		g_print("Stay\n");
	}
}

static void displayer_test_msg_hide(SingitSong *cur_song)
{
	gboolean hide;

	g_print("displayer_test_msg.c [displayer_test_msg_hide]\n");

	hide = ((displayer_test_msg_status.hideIfNotFound && !displayer_test_msg_status.is_fullscreen) ||
		(displayer_test_msg_status.hideIfNotFoundFullscreen && displayer_test_msg_status.is_fullscreen));

	if (hide) {
//		sdl_helper_map(FALSE);
	}
	else { set_gtk_render_idle(TRUE); }
}

static void displayer_test_msg_set_time(guint time, SingitSong *cur_song, GList *real_next)
{
	static GList *last = (GList*) -1;

	SingitSong *my_song;

	my_song = singit_song_attach(cur_song);

	if (my_song != displayer_test_msg_status.song)
	{
		g_print("displayer_test_msg.c [displayer_test_msg_set_time]: New song\n");

		singit_song_detach(&displayer_test_msg_status.song);
		displayer_test_msg_status.song = singit_song_attach(my_song);
		last = (GList*) -1;

		displayer_test_msg_status.singit_playing = singit_song_text_found(my_song);

		if (!displayer_test_msg_status.singit_playing) {

		}
	}
	else {
		if (displayer_test_msg_status.singit_playing &&
			!xmms_remote_is_paused(test_msg_dp.xmms_session))
		{
			set_gtk_render_idle(FALSE);
		}
		else {
			set_gtk_render_idle(TRUE);
		}
	}

//	if (displayer_test_msg_status.screen == SDL_GetVideoSurface())
//	{
//		singit_karaoke_data_set_time(displayer_test_msg_status.skd, time);
		if ((my_song != NULL) &&
			singit_song_lyrics_found(my_song) &&
			(last != my_song->active_token))
		{
//	#ifdef CODEDEBUG
//			g_print("displayer_test_msg.c [displayer_test_msg_set_time]: Show\n"));
//	#endif
		}
		displayer_test_msg_status.time = time;
//	}
	singit_song_detach(&my_song);
}

static void displayer_test_msg_config_update(const SingitConfigData *singit_config)
{
	g_print("displayer_test_msg.c [displayer_test_msg_config_update]\n");

//	g_print("Info Update: %i\n", SDL_WasInit(SDL_INIT_VIDEO));
}

static void displayer_test_msg_playback_start(void)
{
	g_print("displayer_test_msg.c [displayer_test_msg_playback_start]\n");

	displayer_test_msg_status.xmms_playing = TRUE;
}

static void displayer_test_msg_playback_stop(void)
{
	g_print("displayer_test_msg.c [displayer_test_msg_playback_stop]\n");

	displayer_test_msg_status.xmms_playing = FALSE;
	set_gtk_render_idle(TRUE);
}
